/* Logistic Chaos in GLUT, gkf 22jan2K on linux, 10aug on windows */ 
/* translated into basiCglut form the original Applesoft BASIC */
/* revised 26nov2K and 5jan01 */
#include <stdlib.h>
#include <stdio.h>
#include <gl\glut.h>
#include <windows.h>
#include <math.h>
#define  WIN      640           /* size of the square window */ 
#define  NAP      100           /* microseconds for ell() only */
#define  SLEEP(u) usleep(u)     /* usleep() - inux, sginap() - irix */ 
#define  FOR(i,a,b) for(i=a;i<b;i++) 
int ii, jj, kk; float tmp, temp;
float xmax = WIN , ymax = WIN ,      /* screen size */  
      x =.9, y = .9,  A = .99 ,      /* world variables */
      xx, yy, xy, yx,                /* screen variables */
      alt = .96,                     /* altitude of parabola */           
      pnt = .9 ,                     /* starting point */
      del = .01 ;                     /* graph step size */
int clr =0,                           /* color index */
    til = 10,                         /* run ells til */
    nth = 1;                          /* iterate */
float rainbow[8][3]={ {1.0, 0.0, 0.0},        /* red */  
                      {1.0, 0.5, 0.0},        /* orange */  
                      {0.8, 0.8, 0.0},        /* yellow */  
                      {0.0, 1.0, 0.0},        /* green */  
                      {0.0, 8.0, 0.8},        /* (blue) cyan */  
                      {0.0, 5.0, 1.0},        /* indigo */  
                      {1.0, 0.0, 1.0},        /* (violet) magenta */  
                      {1.0, 1.0, 1.0} };      /* white */  
int hasnumber, number, decimal, sign ;  /* SLevy  bump gadget */
/********************************************************************/
float func(int nth, float x){
      FOR(ii,0,nth)x= 4 * alt*(1-x)*x; return x; 
}
/********************************************************************/
void usleep(int nap){int ii; for(ii=0;ii< nap; ii++);} //a bad kludge
/********************************************************************/
void  drawell(void){       
      y=func(nth,x);     /* evaluate */
      xx = x*xmax ; yy = y*ymax;    /* world to screen coords */
      xy = x*ymax ; yx = y*xmax; 
      glBegin(GL_LINE_STRIP);
      glVertex2f(xx,xy); glVertex2f(xx,yy); glVertex2f(yx,yy);
      glEnd();
      x = y;              /*feedback*/
      SLEEP(NAP); 
}
/********************************************************************/
void frame(void){  /* box with diagonal */
    int bot=1, top=WIN; 
    glBegin(GL_LINE_STRIP); 
    glVertex2f(top,top); glVertex2f(bot,top); glVertex2f(bot,bot); 
    glVertex2f(top,top); glVertex2f(top,bot); glVertex2f(bot,bot);
    glEnd();
}
/********************************************************************/
void wipe(void){glClear(GL_COLOR_BUFFER_BIT); glClearColor(0.,0.,0.,0.);
 }
/********************************************************************/
void graph(void){ float x;   glColor3fv(rainbow[clr]); 
     glBegin(GL_LINE_STRIP);
     for(x=0; x < 1+del; x += del)
         glVertex2f(x*xmax, func(nth,x)*ymax);
     glEnd(); 
}
/********************************************************************/
void run(void){ glColor3fv(rainbow[clr]); FOR(jj,0,10){drawell();} }
/********************************************************************/
float getnumber(float dflt){      /* return new or default number  */
      if(!hasnumber)return dflt; 
      tmp = sign ? -number : number;
      return decimal>0 ? tmp/(float)decimal : tmp ;
}
/**********************************************************************/
void graffiti(char strng[128], float par){  /* from avn by SLevy */
     char buf[128], *p ; 
     glColor3f(0,0,0); glRecti(5,3,WIN,20);  /* erase old graffiti */
     glColor3fv(rainbow[clr]);  /* create and draw new graffiti */
     sprintf(buf, strng, par); 
     glRasterPos2i(5,5);  
     for(p=buf; *p; p++)glutBitmapCharacter(GLUT_BITMAP_8_BY_13, *p);
}
/**********************************************************************/
void altit(void) { 
      alt= getnumber(alt); graffiti("%0.3f=(A)lt", alt); }
void point(void){ 
   x=pnt = getnumber(pnt); graffiti("%0.3f=(P)nt",pnt); }
void delta(void){ 
     del = getnumber(del); graffiti("%0.3f=(D)el",del); }
void until(void){ 
     tmp = getnumber((float)til); graffiti("%f=(T)il",tmp); til=(int)tmp; }
void power(void){ 
   tmp = getnumber((float)nth); graffiti("%f=(N)th",tmp); nth=(int)tmp;}
void color(void){ 
   tmp = getnumber((float)clr); graffiti("%f=clr",tmp); clr = (int)tmp; }
#if 0 
void help(void){ fprintf(stdout,
     "(ESC)ape (w)ipe (f)rame (g)raph el(l) (r)un (h)elp \n \
      (a)ltitude (p)oint (d)elta (n)th (t)il (c)olor \n ",0);
#endif
void helpH(void){
     graffiti("(ESC)ape (W)ipe (F)rame (G)raph el(L) (R)un (H)(J)",0); }
void helpJ(void){
     graffiti("(A)ltitude (P)oint (D)elta (N)th (T)il (C)olor",0);}

/********************************************************************/
void cycle(int *par, int bas){
     if(hasnumber){*par = getnumber(0); return;} /* the 0 is a herring */
     *par = (*par + 1)%bas ;
}
/********************************************************************/
void keyboard(unsigned char key, int x, int y){
#define PLOT(foo) glutDisplayFunc(foo); glutPostRedisplay();
  switch(key){ 
     case  27: fprintf(stderr," Thanks for using GLUT ! \n"); exit(0); break;
     case 's': {exit(0); break;}; /* stop */
     case 'w': {wipe(); break;};
     case 'f': {PLOT(frame); break;};
     case 'g': {PLOT(graph); break;};
     case 'l': { glColor3fv(rainbow[clr=(clr++)%7]);  /* cycle colors */
                 PLOT(drawell); break;};
     case 'r': {PLOT(run); break;};
     case 'h': {helpH(); break;};
     case 'j': {helpJ(); break;};
     case 'a': {altit(); break;};
     case 'p': {point(); break;};
     case 'd': {delta(); break;};
     case 'n': {power(); break;};
     case 't': {until(); break;};
     case 'c': {cycle(&clr,7); color(); break;};
   }   
   glFlush(); /* superstition ? */
   /* Stuart Levy's gadget parser from avn.c 1998 */
   if(key >= '0' && key <= '9'){ hasnumber = 1;
         number = 10*number + (key - '0'); decimal *= 10;}
   else if(key == '.'){ decimal = 1;}
   else if(key == '-'){ sign = -1;}
   else {hasnumber = number = decimal = sign = 0;}
}
/********************************************************************/
void nothing(void){  } /* Glut3 forbids glutDisplayFunc(NULL); */
/**********************************************************************/
int main(int argc, char **argv){ 
  glutInitWindowSize(WIN, WIN);        
  glutInitWindowPosition(10,10);
  glutInit(&argc, argv); 
  glutInitDisplayMode(GLUT_RGB); 
  glutCreateWindow("<< Logistic Chaos in GLUT >>");
  glutDisplayFunc(nothing);
  glutKeyboardFunc(keyboard);
  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  glOrtho(0,WIN,0,WIN,-10.0,10.0);
  glMatrixMode(GL_MODELVIEW);
  glLoadIdentity();
  glutMainLoop();
  return 0;             /* ANSI C requires main to return int. */
}
