/* linewidth and TIMES_ROMAN_24 chages gkf 18feb05
/* and the 2D part 10aug2k */
/* Michael Pelsmajer corrected the 3D part August 2K */ 
/* buggy (M)ask tends to blank out the image altogether */
/* de ++ed  26may2K
 cleaned up to compile on Linux/gcc gkf 25may2K
 illuSion.C by Michael W. Daniels
 based on noosh.C by Francis, Bourd, Hartman, and Chappell
 began 28 March 1997
 version 1.0 as documented in final report
 version 1.1 closed on 5-15-97: some bugs fixed, some still not found

 (C) 1997 Board of Trustees University of Illinois
 e-mail mwdaniel@uiuc.edu
 Several anomalies are still present in the CAVE version:
   -- the midpoints for the 3d illusion are calculated incorrectly
   -- the CAVE crashes when the program is exited

 In general, this program could be easily altered to display some other sort
 of 4-d object if one wanted -- there are certainly many more interesting
 ones out there.
 General notes on further improvement are noted throughout.
*/

//#pragma warning (disable:4305)  /* double-to-float  */
//#pragma warning (disable:4101)	/* unreferenced local variable */
//#pragma warning (disable:4056)	/* overflow in fp constant arithmetic */

//#include <GL\glut.h>
#include <glut.h>
#include <stdlib.h>
#include <stdio.h>
#include <math.h>
//#include <sys\timeb.h>
#include <sys/time.h>
#include <stdio.h>
//#include <malloc.h>
#include <string.h>
//#include <windows.h>
#include "getopt.h"
#define M_PI 3.1415926 
#define random rand 
#define fsqrt  sqrt 
#define GL_POLYGON GL_LINE_STRIP 

#define WIDTH 2   //gkf wrong one to thicken it's the mask lines
#define MANY 5000000


#pragma warning (disable:4305) /* disable double-to-float */
#pragma warning (disable:4101) /* disable "unreferenced local variable" */
#pragma warning (disable:4056)	/* disable bogus "overflow in floating-point constant arithmetic" warning */


#ifdef CAVE
#include <cave_ogl.h>
#include <cave.macros.h>
#endif 





#define  MAX(x,y)      (((x)<(y))?(y):(x))
#define  MIN(x,y)      (((x)<(y))?(x):(y))
#define  DOT(p,q)      ((p)[0]*(q)[0]+(p)[1]*(q)[1]+(p)[2]*(q)[2])
#define  NRM(p)        sqrt(DOT((p),(p)))
#define  DG            M_PI/180
#define  S(u)          sin(u*DG)
#define  C(u)          cos(u*DG)
#define  CLAMP(x,u,v)  (x<u? u : (x>v ? v: x))


int highlight3=0;
int highlight2=0;
int thicken3=1;
int thicken2=1;

int frozen = 0;                       
float lux[3]={1.,2.,3.};              
float mysiz, speed, torq, focal, wnear, wfar; 
int win = 2;                          
unsigned int BUT,XX,YY,SHIF;          
int xt,yt;                            
int caveflag=0;                       
float lu[3];                          
int msg,binoc;                        
float nose;                           
float knopf=0;

#define FLYMODE  (0)
#define TURNMODE (1) 
#define ROTATEMODE (2)



struct share_var{ 
  float s_siz;          
  int s_morph;          
  int s_mode;           
  GLfloat s_aff[16];    
  GLfloat s_starmat[16];
  int s_wp2;            
  int s_wp3;            
  int s_dms;            
  float s_rta[3][4];    
  int s_stp;            
  float s_pt2[20][3];   
  float s_pt3[84][4];   
  int s_ed2[24][2];     
  int s_ed3[80][2];     
  float s_pr2[20][3];   
  float s_pr3[84][3];   
  int s_tra;            
  int s_mas;            
} *s_var; 



#define siz         (s_var->s_siz)
#define mode        (s_var->s_mode)
#define morph       (s_var->s_morph)
#define aff         (s_var->s_aff)  
#define starmat     (s_var->s_starmat)
#define whichProj2  (s_var->s_wp2)
#define whichProj3  (s_var->s_wp3)
#define dimensions  (s_var->s_dms)
#define rotateAng   (s_var->s_rta)
#define step        (s_var->s_stp)
#define shape2verts (s_var->s_pt2)
#define shape3verts (s_var->s_pt3)
#define edges2      (s_var->s_ed2)
#define edges3      (s_var->s_ed3)
#define shape2proj  (s_var->s_pr2)
#define shape3proj  (s_var->s_pr3)
#define transFlag   (s_var->s_tra)
#define maskFlag    (s_var->s_mas)

void getmem(){
if (caveflag)
#ifdef CAVE

#endif
      ;
  else
    s_var = (struct share_var*)malloc(sizeof(struct share_var));
  if (s_var == NULL) {
    fprintf(stderr,"No room to share! %x \n",s_var); 
    exit(1);
  }
}

void char2wall(GLfloat x, GLfloat y, GLfloat z, char buf[]){
  char *p; 
  glRasterPos3f(x,y,z);
  for(p = buf; *p; p++) 
//  glutBitmapCharacter(GLUT_BITMAP_9_BY_15, *p);
    glutBitmapCharacter(GLUT_BITMAP_TIMES_ROMAN_24, *p);
}


void autotymer(int);    




void initPoints() { 

  static float shape2vs[20][3] = {{0,0,0},{0,0,1},{0,1,1},{0,1,0},
				  {5,0,0},{5,0,1},{4,1,1},{4,1,0},
				  {5,5,0},{5,4,1},{4,4,1},{4,5,0},
				  {5,5,5},{5,4,5},{4,4,5},{4,5,5},
				  {0,-1,-2},{4,2,1},{4,3,1},{0,0,-1}};
  
  static float shape3vs[4][4] = {{4,4,3,1},{5,4,4,3},{3,1,0,0},{4,3,1,0}};
  
  int ii; int jj;

  for (ii = 0; ii < 20; ii++) 
    for (jj = 0; jj < 3; jj++)
      shape2verts[ii][jj] = shape2vs[ii][jj];


  for(ii=0;ii<80;ii++)
    for(jj=0;jj<4;jj++){
      shape3verts[ii][jj]=((ii%16)&(1<<jj))?1:0; /* 5 hypercubes together */
      shape3verts[ii][jj]+=(jj<(ii/16))?4:0; /* & apart */
    }
  for (ii = 80; ii < 84; ii++) 
    for (jj = 0; jj < 4; jj++)
      shape3verts[ii][jj] = shape3vs[ii-80][jj];
}



void initEdges() { 

  int edg2[24][2] = {{0,1} ,{1,2} ,{2,3}  ,{3,0}  ,{4,5}  ,{6,7}  ,
		     {9,10},{11,8},{12,13},{13,14},{14,15},{15,12},
		     {0,4} ,{4,8} ,{8,12} ,{1,5}  ,{5,9}  ,{9,13} ,
		     {2,6} ,{6,10},{10,14},{3,7}  ,{7,11} ,{11,15}};
  
  /* (now) just a cube */
  int edg3[12][2] = {{0,1}  ,{0,2}  ,{0,4}  ,{3,7}  ,{5,7}  ,{6,7}  ,
		     {1,3}  ,{1,5}  ,{2,3}  ,{2,6}  ,{4,5}  ,{4,6}};
  
  int ii; int jj;
  for (ii = 0; ii < 24; ii++)
    for (jj = 0; jj < 2; jj++)
      edges2[ii][jj] = edg2[ii][jj];

  for (ii = 0; ii < 12; ii++)for (jj = 0; jj < 2; jj++){
      edges3[ii+32][jj] = 2*edg3[ii][jj];
      edges3[ii+68][jj] = (4*16) + 8 + edg3[ii][jj];
  }/* endcubes */
  for (ii = 0; ii < 4; ii++){
    int kk=((ii==0)?1:((ii==1)?3:((ii==2)?0:2)));/* successor along square */

    edges3[ii+44][0]=16+2+4*(ii%2)+8*(ii/2);
    edges3[ii+44][1]=16+2+4*(kk%2)+8*(kk/2);
    edges3[ii+48][0]=16+1+4*(ii%2)+8*(ii/2);
    edges3[ii+48][1]=16+1+4*(kk%2)+8*(kk/2);

    edges3[ii+52][0]=32+4+1*(ii%2)+8*(ii/2);
    edges3[ii+52][1]=32+4+1*(kk%2)+8*(kk/2);
    edges3[ii+56][0]=32+2+1*(ii%2)+8*(ii/2);
    edges3[ii+56][1]=32+2+1*(kk%2)+8*(kk/2);

    edges3[ii+60][0]=48+8+1*(ii%2)+2*(ii/2);
    edges3[ii+60][1]=48+8+1*(kk%2)+2*(kk/2);
    edges3[ii+64][0]=48+4+1*(ii%2)+2*(ii/2);
    edges3[ii+64][1]=48+4+1*(kk%2)+2*(kk/2);
  }/* joints */
  for (ii = 0; ii < 8; ii++){
    edges3[ii][0] = ii*2; 
    edges3[ii][1] = ii*2 + 16;
    edges3[ii][1] += ((edges3[ii][1]&2)?0:1);

    edges3[ii+8][0] = (ii/2)*4 + (ii%2) + 16;
    edges3[ii+8][1] = (ii/2)*4 + (ii%2) + 32;
    edges3[ii+8][0] += ((edges3[ii+8][0]&1)?0:2);
    edges3[ii+8][1] += ((edges3[ii+8][1]&4)?0:2);

    edges3[ii+16][0] = (ii/4)*8 + (ii%4) + 32;
    edges3[ii+16][1] = (ii/4)*8 + (ii%4) + 48;
    edges3[ii+16][0] += ((edges3[ii+16][0]&2)?0:4);
    edges3[ii+16][1] += ((edges3[ii+16][1]&8)?0:4);

    edges3[ii+24][0] = ii + 48;
    edges3[ii+24][0] += ((edges3[ii+24][0]&4)?0:8);
    edges3[ii+24][1] = ii + 64 + 8;
  }/* straights */
}




void reProject(void) {
  int ii, jj; 
  if(dimensions == 3){
    for (jj = 0; jj < 20; jj++) {
      ii = 0;
      while (ii < whichProj2) {
	shape2proj[jj][ii] = shape2verts[jj][ii];
	ii++;
      }
      while (ii < 2) {
	shape2proj[jj][ii] = shape2verts[jj][ii+1];
	ii++;
      }
    }
  }
  else {
    for (jj = 0; jj < 84; jj++) {
      ii = 0;
      while (ii < whichProj3) {
	shape3proj[jj][ii] = shape3verts[jj][ii];
	ii++;
      }
      while (ii < 3) {
	shape3proj[jj][ii] = shape3verts[jj][ii+1];
	ii++;
      }
    }
  }
}



void deFault(){
  int ii; int jj; float tmp; 
  msg = 1; binoc = 0; nose = .06; siz = 1.; mode = TURNMODE; frozen = 0;
  speed = .01; torq = .002; focal = 2.; wnear= .02, wfar = 45.; mysiz = .01; morph = 0; 
  for (ii = 0;ii < 16;ii++) starmat[ii] = aff[ii] = (ii/4 == ii%4) ? 1 : 0;   
  tmp = NRM(lux);
  for (ii = 0;ii < 3;ii++) lux[ii] /= tmp;
  if (caveflag) {
    aff[12]=0; aff[13]= 5; aff[14]= -10 ;} 
  else {
    aff[12]=0; aff[13]= 0; aff[14]= -14.2;} 

  whichProj3 = 3; initPoints(); whichProj2 = 2;
  if (caveflag) step = 1; else step = 100; 
  for (ii = 0; ii < 3; ii++) for (jj = 0; jj < 4; jj++) rotateAng[ii][jj] = 0.;
  transFlag = 0; maskFlag = 0; reProject();
  autotymer(1); 
}







void rotate(int from, int to, float sign) {
  int ii; float temp;
  float ang = ((float)step/100.0) * (float)sign;

  

  float cc = C(ang); float ss = S(ang);
  rotateAng[from][to] += ang;

  if (dimensions == 3) {
    for (ii = 0; ii < 20; ii++) {
      temp = shape2verts[ii][from];
      shape2verts[ii][from] = temp * cc - shape2verts[ii][to] * ss;
      shape2verts[ii][to] = shape2verts[ii][to] * cc + temp * ss;
    }
  }
  else {
    for (ii = 0; ii < 84; ii++) {
      temp = shape3verts[ii][from];
      shape3verts[ii][from] = temp * cc - shape3verts[ii][to] * ss;
      shape3verts[ii][to] = shape3verts[ii][to] * cc + temp * ss;
    }
  }
  reProject();
}











 
int midpoint(float result[], float x1[], float x2[], float y1[], float y2[]) {
  float bc = x1[1] * y1[0]; float ad = x1[0] * y1[1]; float be = x1[1] * y2[0];
  float de = y1[1] * y2[0]; float af = x1[0] * y2[1]; float cf = y1[0] * y2[1];
  float dh = y1[1] * x2[0]; float fh = y2[1] * x2[0]; float ci = y1[0] * x2[1];
  float ei = y2[0] * x2[1]; float tdenom = ad-af-dh+fh+be-bc+ci-ei; 
    
  if (dimensions == 3) {
    if (tdenom != 0) {
      float tt = (bc-ad-be+de+af-cf) / tdenom;
      if (tt > 0 || tt < -1) return 1;

      
      

      result[0] = x1[0] - tt*(x2[0] - x1[0]);
      result[1] = x1[1] - tt*(x2[1] - x1[1]);
      result[2] = 0; 
      return 0;
    }
    else return 1;
  }
  else { 
    if (tdenom != 0) {
      float tt = (bc-ad-be+de+af-cf) / tdenom;
      if (tt > 0 || tt < -1) return 1;
      result[0] = x1[0] - tt*(x2[0] - x1[0]);
      result[1] = x1[1] - tt*(x2[1] - x1[1]);
      result[2] = x1[2] - tt*(x2[2] - x1[2]);
      return 0;
    }
    else {
      bc = x1[2] * y1[0]; ad = x1[0] * y1[2]; be = x1[2] * y2[0]; 
      de = y1[2] * y2[0]; af = x1[0] * y2[2]; cf = y1[0] * y2[2];
      dh = y1[2] * x2[0]; fh = y2[2] * x2[0]; ci = y1[0] * x2[2];
      ei = y2[0] * x2[2]; tdenom = ad-bc+be-af-dh+fh+ci-ei;
      
      if (tdenom != 0) {
	float tt = (bc-ad-be+de+af-cf) / tdenom;
	if (tt > 0 || tt < -1) return 1;
	result[0] = x1[0] - tt*(x2[0] - x1[0]);
	result[1] = x1[1] - tt*(x2[1] - x1[1]);
	result[2] = x1[2] - tt*(x2[2] - x1[2]);
	return 0;
      }
      else {
	bc = x1[2] * y1[1]; ad = x1[1] * y1[2];	be = x1[2] * y2[1];
	de = y1[2] * y2[1]; af = x1[1] * y2[2];	cf = y1[1] * y2[2];
	dh = y1[2] * x2[1]; fh = y2[2] * x2[1]; ci = y1[1] * x2[2];
	ei = y2[1] * x2[2]; tdenom = ad-bc+be-af-dh+fh+ci-ei;

	if (tdenom != 0) {
	  float tt = (bc-ad-be+de+af-cf) / tdenom;      
	  if (tt > 0 || tt < -1) return 1;
	  result[0] = x1[0] - tt*(x2[0] - x1[0]);
	  result[1] = x1[1] - tt*(x2[1] - x1[1]);
	  result[2] = x1[2] - tt*(x2[2] - x1[2]);
	  return 0;
	}
	else return 1;
      }
    }
  }
}


void drawNodeSphere(void){
  if(dimensions==3){
    glPushMatrix();
    glTranslatef(shape2proj[highlight2][0],shape2proj[highlight2][1],shape2proj[highlight2][2]);
    glColor3f(.7,.7,.7);
    glutWireSphere(.1,10,10);
    glPopMatrix();
  }
  else {
    glPushMatrix();
    glTranslatef(shape3proj[highlight3][0],shape3proj[highlight3][1],shape3proj[highlight3][2]);
    glColor3f(.7,.7,.7);
    glutWireSphere(.1,10,10);
    glPopMatrix();
  }
}

void drawShape() { int ii;
  if (caveflag) {
    if (mode == FLYMODE) glColor3f(1,1,0);
    else if (mode == TURNMODE) glColor3f(1,0,1);
    else if (mode == ROTATEMODE) glColor3f(0.66,0.33,0);
  }
  else
    glColor3f(1,1,0);
  if (dimensions == 3)
    for (ii = 0; ii < 24; ii++) {
      glBegin(GL_LINES);
      glVertex3fv(shape2proj[edges2[ii][0]]);
      glVertex3fv(shape2proj[edges2[ii][1]]);
      glEnd();
    }
  else
    for (ii = 0; ii < 80; ii++) {
      glBegin(GL_LINES);
      glVertex3fv(shape3proj[edges3[ii][0]]);
      glVertex3fv(shape3proj[edges3[ii][1]]);
      glEnd();
    }
}










void drawMask() { 
  if (dimensions == 3) {
    if (whichProj2 != 2) return;
    glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
    if(thicken2==1)glLineWidth(3);
    else glLineWidth(WIDTH);
    if(thicken2==0)glColor3f(.9,.9,.9); else
    glColor3f(0.1333,0.5333,0.8667);
    glBegin(GL_POLYGON);
    glVertex3fv(shape2proj[1]); glVertex3fv(shape2proj[5]);
    glVertex3fv(shape2proj[9]); glVertex3fv(shape2proj[18]); 
    glVertex3fv(shape2proj[6]);
    glVertex3fv(shape2proj[2]); glVertex3fv(shape2proj[1]);
    glEnd();
    if(thicken2==2)glLineWidth(3);
    else glLineWidth(WIDTH);
    if(thicken2==0)glColor3f(.9,.9,.9); else
    glColor3f(.7,0,.7);
    glBegin(GL_POLYGON);
    glVertex3fv(shape2proj[6]); glVertex3fv(shape2proj[2]);
    glVertex3fv(shape2proj[11]); glVertex3fv(shape2proj[8]);
    glVertex3fv(shape2proj[19]); glVertex3fv(shape2proj[17]); 
    glVertex3fv(shape2proj[6]);
    glEnd();
    if(thicken2==3)glLineWidth(3);
    else glLineWidth(WIDTH);
    if(thicken2==0)glColor3f(.9,.9,.9); else
    glColor3f(.4,.8,0);
    glBegin(GL_POLYGON);
    glVertex3fv(shape2proj[5]); glVertex3fv(shape2proj[9]); 
    glVertex3fv(shape2proj[16]);
    glVertex3fv(shape2proj[19]); glVertex3fv(shape2proj[8]); 
    glVertex3fv(shape2proj[4]);glVertex3fv(shape2proj[5]);
    glEnd();

  }
  else {
    if (whichProj3 != 3) return;
       
    glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);

    if(thicken3==1)glLineWidth(3);
    else glLineWidth(WIDTH);
    glColor3f(0.66, 0.33, 0);
    glBegin(GL_QUADS);
    glVertex3fv(shape3proj[8]);glVertex3fv(shape3proj[10]);
    glVertex3fv(shape3proj[14]);glVertex3fv(shape3proj[12]);
    glVertex3fv(shape3proj[8]);glVertex3fv(shape3proj[12]);
    glVertex3fv(shape3proj[29]);glVertex3fv(shape3proj[25]);
    glVertex3fv(shape3proj[10]);glVertex3fv(shape3proj[14]);
    glVertex3fv(shape3proj[30]);glVertex3fv(shape3proj[26]);
    glEnd();
    glBegin(GL_POLYGON);
    glVertex3fv(shape3proj[8]);glVertex3fv(shape3proj[10]);
    glVertex3fv(shape3proj[26]);glVertex3fv(shape3proj[42]);
    glVertex3fv(shape3proj[43]);glVertex3fv(shape3proj[25]);
    glEnd();
    glBegin(GL_POLYGON);
    glVertex3fv(shape3proj[12]);glVertex3fv(shape3proj[14]);
    glVertex3fv(shape3proj[30]);glVertex3fv(shape3proj[44]);
    glVertex3fv(shape3proj[45]);glVertex3fv(shape3proj[29]);
    glEnd();
    glBegin(GL_POLYGON);
    glVertex3fv(shape3proj[25]);glVertex3fv(shape3proj[29]);
    glVertex3fv(shape3proj[45]);glVertex3fv(shape3proj[57]);
    glVertex3fv(shape3proj[59]);glVertex3fv(shape3proj[43]);
    glEnd();
    glBegin(GL_POLYGON);
    glVertex3fv(shape3proj[26]);glVertex3fv(shape3proj[30]);
    glVertex3fv(shape3proj[44]);glVertex3fv(shape3proj[80]);
    glVertex3fv(shape3proj[58]);glVertex3fv(shape3proj[42]);
    glEnd();
    glBegin(GL_QUADS);
    glVertex3fv(shape3proj[42]);glVertex3fv(shape3proj[43]);
    glVertex3fv(shape3proj[59]);glVertex3fv(shape3proj[58]);
    glVertex3fv(shape3proj[44]);glVertex3fv(shape3proj[45]);
    glVertex3fv(shape3proj[57]);glVertex3fv(shape3proj[80]);
    glEnd();
    glBegin(GL_TRIANGLE_STRIP);
    glVertex3fv(shape3proj[58]);glVertex3fv(shape3proj[59]);
    glVertex3fv(shape3proj[80]);glVertex3fv(shape3proj[57]);
    glEnd();

    if(thicken3==2)glLineWidth(3);
    else glLineWidth(WIDTH);
    glColor3f(.7,0,.7);
    glBegin(GL_QUADS);
    glVertex3fv(shape3proj[17]);glVertex3fv(shape3proj[21]);
    glVertex3fv(shape3proj[29]);glVertex3fv(shape3proj[25]);
    glVertex3fv(shape3proj[17]);glVertex3fv(shape3proj[25]);
    glVertex3fv(shape3proj[43]);glVertex3fv(shape3proj[35]);
    glVertex3fv(shape3proj[21]);glVertex3fv(shape3proj[29]);
    glVertex3fv(shape3proj[45]);glVertex3fv(shape3proj[37]);
    glEnd();
    glBegin(GL_POLYGON);
    glVertex3fv(shape3proj[17]);glVertex3fv(shape3proj[21]);
    glVertex3fv(shape3proj[37]);glVertex3fv(shape3proj[53]);
    glVertex3fv(shape3proj[55]);glVertex3fv(shape3proj[35]);
    glEnd();
    glBegin(GL_POLYGON);
    glVertex3fv(shape3proj[25]);glVertex3fv(shape3proj[29]);
    glVertex3fv(shape3proj[45]);glVertex3fv(shape3proj[57]);
    glVertex3fv(shape3proj[59]);glVertex3fv(shape3proj[43]);
    glEnd();
    glBegin(GL_POLYGON);
    glVertex3fv(shape3proj[35]);glVertex3fv(shape3proj[43]);
    glVertex3fv(shape3proj[59]);glVertex3fv(shape3proj[67]);
    glVertex3fv(shape3proj[71]);glVertex3fv(shape3proj[55]);
    glEnd();
    glBegin(GL_POLYGON);
    glVertex3fv(shape3proj[37]);glVertex3fv(shape3proj[45]);
    glVertex3fv(shape3proj[57]);glVertex3fv(shape3proj[81]);
    glVertex3fv(shape3proj[69]);glVertex3fv(shape3proj[53]);
    glEnd();
    glBegin(GL_QUADS);
    glVertex3fv(shape3proj[55]);glVertex3fv(shape3proj[53]);
    glVertex3fv(shape3proj[69]);glVertex3fv(shape3proj[71]);
    glVertex3fv(shape3proj[57]);glVertex3fv(shape3proj[59]);
    glVertex3fv(shape3proj[67]);glVertex3fv(shape3proj[81]);
    glEnd();
    glBegin(GL_TRIANGLE_STRIP);
    glVertex3fv(shape3proj[69]);glVertex3fv(shape3proj[71]);
    glVertex3fv(shape3proj[81]);glVertex3fv(shape3proj[67]);
    glEnd();

    if(thicken3==3)glLineWidth(3);
    else glLineWidth(WIDTH);
    glColor3f(0.1333,0.5333,0.8667);
    glBegin(GL_QUADS);
    glVertex3fv(shape3proj[34]);glVertex3fv(shape3proj[35]);
    glVertex3fv(shape3proj[43]);glVertex3fv(shape3proj[42]);
    glVertex3fv(shape3proj[34]);glVertex3fv(shape3proj[35]);
    glVertex3fv(shape3proj[55]);glVertex3fv(shape3proj[54]);
    glVertex3fv(shape3proj[42]);glVertex3fv(shape3proj[43]);
    glVertex3fv(shape3proj[59]);glVertex3fv(shape3proj[58]);
    glEnd();
    glBegin(GL_POLYGON);
    glVertex3fv(shape3proj[35]);glVertex3fv(shape3proj[43]);
    glVertex3fv(shape3proj[59]);glVertex3fv(shape3proj[67]);
    glVertex3fv(shape3proj[71]);glVertex3fv(shape3proj[55]);
    glEnd();
    glBegin(GL_POLYGON);
    glVertex3fv(shape3proj[34]);glVertex3fv(shape3proj[42]);
    glVertex3fv(shape3proj[58]);glVertex3fv(shape3proj[74]);
    glVertex3fv(shape3proj[78]);glVertex3fv(shape3proj[54]);
    glEnd();
    glBegin(GL_POLYGON);
    glVertex3fv(shape3proj[54]);glVertex3fv(shape3proj[55]);
    glVertex3fv(shape3proj[71]);glVertex3fv(shape3proj[22]);
    glVertex3fv(shape3proj[30]);glVertex3fv(shape3proj[78]);
    glEnd();
    glBegin(GL_POLYGON);
    glVertex3fv(shape3proj[58]);glVertex3fv(shape3proj[59]);
    glVertex3fv(shape3proj[3]);glVertex3fv(shape3proj[82]);
    glVertex3fv(shape3proj[26]);glVertex3fv(shape3proj[10]);
    glEnd();
    glBegin(GL_QUADS);
    glVertex3fv(shape3proj[10]);glVertex3fv(shape3proj[14]);
    glVertex3fv(shape3proj[30]);glVertex3fv(shape3proj[26]);
    glVertex3fv(shape3proj[3]);glVertex3fv(shape3proj[7]);
    glVertex3fv(shape3proj[22]);glVertex3fv(shape3proj[82]);
    glEnd();
    glBegin(GL_TRIANGLE_STRIP);
    glVertex3fv(shape3proj[22]);glVertex3fv(shape3proj[30]);
    glVertex3fv(shape3proj[82]);glVertex3fv(shape3proj[26]);
    glEnd();

    if(thicken3==4)glLineWidth(3);
    else glLineWidth(WIDTH);
    glColor3f(.4,.8,0);
    glBegin(GL_QUADS);
    glVertex3fv(shape3proj[52]);glVertex3fv(shape3proj[53]);
    glVertex3fv(shape3proj[55]);glVertex3fv(shape3proj[54]);
    glVertex3fv(shape3proj[52]);glVertex3fv(shape3proj[54]);
    glVertex3fv(shape3proj[14]);glVertex3fv(shape3proj[12]);
    glVertex3fv(shape3proj[53]);glVertex3fv(shape3proj[55]);
    glVertex3fv(shape3proj[7]);glVertex3fv(shape3proj[5]);
    glEnd();
    glBegin(GL_POLYGON);
    glVertex3fv(shape3proj[52]);glVertex3fv(shape3proj[53]);
    glVertex3fv(shape3proj[5]);glVertex3fv(shape3proj[21]);
    glVertex3fv(shape3proj[29]);glVertex3fv(shape3proj[12]);
    glEnd();
    glBegin(GL_POLYGON);
    glVertex3fv(shape3proj[54]);glVertex3fv(shape3proj[55]);
    glVertex3fv(shape3proj[7]);glVertex3fv(shape3proj[22]);
    glVertex3fv(shape3proj[30]);glVertex3fv(shape3proj[14]);
    glEnd();
    glBegin(GL_POLYGON);
    glVertex3fv(shape3proj[12]);glVertex3fv(shape3proj[14]);
    glVertex3fv(shape3proj[30]);glVertex3fv(shape3proj[44]);
    glVertex3fv(shape3proj[45]);glVertex3fv(shape3proj[29]);
    glEnd();
    glBegin(GL_POLYGON);
    glVertex3fv(shape3proj[5]);glVertex3fv(shape3proj[7]);
    glVertex3fv(shape3proj[22]);glVertex3fv(shape3proj[83]);
    glVertex3fv(shape3proj[37]);glVertex3fv(shape3proj[21]);
    glEnd();
    glBegin(GL_QUADS);
    glVertex3fv(shape3proj[21]);glVertex3fv(shape3proj[29]);
    glVertex3fv(shape3proj[45]);glVertex3fv(shape3proj[37]);
    glVertex3fv(shape3proj[22]);glVertex3fv(shape3proj[30]);
    glVertex3fv(shape3proj[44]);glVertex3fv(shape3proj[83]);
    glEnd();
    glBegin(GL_TRIANGLE_STRIP);
    glVertex3fv(shape3proj[37]);glVertex3fv(shape3proj[45]);
    glVertex3fv(shape3proj[83]);glVertex3fv(shape3proj[44]);
    glEnd();

  }
}



void drawall() {
  if (transFlag) glTranslatef(-2,-2,-2);
  if (!maskFlag) drawShape();
  if (maskFlag) drawMask();
  drawNodeSphere();
}



void drawstars() { int kk; 
  static float star[1000][3]; static int virgin=1;
  if (virgin) {
    int ii; int jj; float fact;
    virgin = 0;
    for (ii = 0;ii < 1000;ii++) {
      for (jj = 0;jj < 3;jj++) star[ii][jj] = random()/(float)0x40000000-1.;
      if (caveflag) {
	fact = 90./NRM(star[ii]);
	for (jj = 0;jj < 3;jj++) star[ii][jj] *= fact;
      }   
    }
  }
  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();
  glMultMatrixf(starmat);
  glColor3f(1.0,1.0,0.0);    
  glBegin(GL_POINTS);
  for (kk = 0; kk < 1000; kk++) glVertex3fv(star[kk]);
  glEnd();
  glPopMatrix();
  glClear(GL_DEPTH_BUFFER_BIT);
}



void arguments(int argc, char** argv) {
  extern char *optarg; extern int optind; int chi;   
  
  while ((chi = getopt(argc,argv,"w:cd:")) != -1) 
    switch (chi) {
    case 'c': caveflag=1; break;  
    case 'w': win=atoi(optarg); break; 
    }
  if (optind != argc) fprintf(stderr,"%s: Incorrect usage\n",argv[0]);
}



void dataprep() {
  initEdges(); deFault(); dimensions = 4;
}

void slowdown(int many){
   int ii; for(ii=0; ii<many;ii++);
   }

void autotymer(int reset) {

    slowdown(MANY); 

#define TYME(cnt,max,act) {static int cnt; if(first)cnt=max; else\
                            if(cnt?cnt--:0){ act ; goto Break;}}
  static int first = 1;
  if (reset) {first=1;dimensions=4;}
    /* These angles are double because step is half normal */
  if (dimensions == 4) {
    TYME(switchproj, 1, whichProj3 = 3);
    TYME(switchstep, 1, step = 100);
    TYME(rotate1, 45, rotate(1,3,1));
    TYME(rotate2, 45, rotate(2,0,1));
    TYME(rotate4, 45, rotate(0,3,-1));
    TYME(rotate4, 90, rotate(0,3,1));

    TYME(finish  , 1 , {first = 1;morph=0;}  );
  }
  else {
    TYME(switchproj, 1, whichProj2 = 2);
    TYME(switchstep, 1, step = 100);
    TYME(rotate1, 90, rotate(0,2,1));
    TYME(rotate2, 90, rotate(1,2,1));
    TYME(finish  , 1 , first = 1  );
  }
  first = 0;
  Break:;
}




void illusionSnap() {
  int tempStep = 1;
  if (dimensions == 4) {
    tempStep = step;
    step = 100;
    whichProj3 = 3; 
    rotate(1,3,45);
    rotate(2,0,45);
    rotate(0,3,45);

    /*    
	  rotate(0,3,-134.87); rotate(1,3,-35.29); rotate(2,3,-30.01);
    */
    step = tempStep;
  }
  else {
    tempStep = step;
    step = 100;
    whichProj2 = 2; /*rotate(0,2,-134.84); rotate(1,2,-35.27);*/
    rotate(0,2,-135); rotate(1,2,(-1*atan(1./(fsqrt(2)))/(DG)));
    step = tempStep;
  }
}



#define  IF(K)            if(key == K)
#define  PRESS(K,A,b)     IF(K){b;}IF((K-32)){A;}  
#define  TOGGLE(K,flg)    IF(K){(flg) = 1-(flg); }
#define  CYCLE(K,f,m)     PRESS((K), (f)=(((f)+(m)-1)%(m)),(f)=(++(f)%(m)))

void keyboard(unsigned char key, int x, int y) {
  int junk = x = y; 
  static int dimSwitch = 0;
  static int stepSwitch = 0;
  static int projSwitch = 0;
  TOGGLE('v', binoc);                       
  TOGGLE('w', msg);                         
  TOGGLE('h', morph);                       
  TOGGLE('f', frozen);                      
  IF('a') {illusionSnap();}                 
  TOGGLE('t', transFlag);                   
  TOGGLE('m', maskFlag);                    
  CYCLE(' ', mode,TURNMODE+1);              
  PRESS('n', nose -= .001 , nose += .001);  
  PRESS('i', mysiz /= 1.1, mysiz *= 1.1);   
/*  PRESS('o', focal *= 1.1 , focal /= 1.1); */ 
  PRESS('p', wfar *= 1.01 , wfar   /= 1.01);  
  PRESS('o', wnear *= 1.01 , wnear   /= 1.01);  
  PRESS('s', speed /= 1.02, speed *= 1.02); 
  PRESS('q', torq /= 1.02, torq *= 1.02);   
  PRESS('z', deFault(), deFault());         
  IF(27) {exit(0);}                         
  TOGGLE('j', projSwitch);                  
  TOGGLE('d', dimSwitch);                   
  TOGGLE('b', stepSwitch);    
  if(dimensions==4){
    PRESS('x', highlight3-=1, highlight3+=1);
    if(highlight3==-1)highlight3=83;
    if(highlight3==84)highlight3=0;
    PRESS('y', thicken3-=1, thicken3+=1);
    if(thicken3==-1)thicken3=4;
    if(thicken3==5)thicken3=0;
  }
  else{
    PRESS('x', highlight2-=1, highlight2+=1);
    if(highlight2==-1)highlight2=19;
    if(highlight2==20)highlight2=0;
    PRESS('y', thicken2-=1, thicken2+=1);
    if(thicken2==-1)thicken2=3;
    if(thicken2==4)thicken2=0;
  }

  if (projSwitch) {
    if (dimensions == 4) {
      whichProj3++; 
      if (whichProj3 >= dimensions) whichProj3 = 0;
    }
    else {
      whichProj2++;
      if (whichProj2 >= dimensions) whichProj2 = 0;
    }
    reProject();
    projSwitch = 0;
  }
  
  if (dimSwitch) {
    if (dimensions == 4)
      dimensions = 3;
    else
      dimensions = 4;
    reProject();
    dimSwitch = 0;
  }

  if (stepSwitch) {
    if (step == 100)
      step = 10;
    else
      if (step == 10)
	step = 1;
      else 
	step = 100;
    stepSwitch = 0;
  }
}

void special_keybo(int key, int x, int y) {
  int junk = x = y;
  if (dimensions == 3) {
    IF(GLUT_KEY_RIGHT) {rotate(0,2,-1);}
    IF(GLUT_KEY_LEFT)  {rotate(0,2, 1);}
    IF(GLUT_KEY_UP)    {rotate(1,2,-1);}
    IF(GLUT_KEY_DOWN)  {rotate(1,2, 1);}
  }
  else {
    IF(GLUT_KEY_RIGHT) {rotate(0,3,-1);}
    IF(GLUT_KEY_LEFT) {rotate(0,3, 1);}
    IF(GLUT_KEY_UP) {rotate(1,3,-1);}
    IF(GLUT_KEY_DOWN) {rotate(1,3, 1);}
    IF(GLUT_KEY_PAGE_UP) {rotate(2,3,-1);}
    IF(GLUT_KEY_PAGE_DOWN) {rotate(2,3, 1);}
  }
}


/**********************************************************************/
float speedometer(void){
double dbl; static double rate; static int ii=0;
static struct timezone notused; static struct timeval now, then;
   if(++ii % 8 == 0){  /* 8 times around measure time */
      gettimeofday(&now, &notused); /* elapsed time */
      dbl =  (double)(now.tv_sec - then.tv_sec)
         +(double)(now.tv_usec - then.tv_usec)/1000000;
      then = now;  rate = 8/dbl;
      }
   return((float)rate);
}
/**********************************************************************/

#if 0
float speedometer(void){
double dbl; static double rate; static int ii=0;

static struct _timeb lnow, lthen;

   if(++ii % 8 == 0){  /* 8 times around measure time */

	   _ftime(&lnow);
		dbl =  (double)(lnow.time - lthen.time)
			 +(double)(lnow.millitm - lthen.millitm)/1000;
		lthen = lnow;  rate = 8/dbl;
      }

   return((float)rate);
}
#endif 
 
#define LABEL2(x,y,W,u) {sprintf(buf,(W),(u));char2wall(x,y,0.,buf);}

void messages() {     
  char buf[256]; int blank; 
  glMatrixMode(GL_PROJECTION); glPushMatrix(); glLoadIdentity();
  gluOrtho2D(0,3000,0,3000);
  glMatrixMode(GL_MODELVIEW); glPushMatrix(); glLoadIdentity();

  
  if (mode == TURNMODE) 
    glColor3f(0.1333,0.5333,0.8667);
  else      
    glColor3f(.8, .8, .8);
  LABEL2(1500,1500,"%s","o");

  
  if (mode == TURNMODE) 
    glColor3f(1.,0.,1.);
  else      
    glColor3f(1.,1.,0.);
  LABEL2(80,80,"%4.1f fps",speedometer());
  LABEL2(80,2840,\
	 "(ESC)ape (V)Binoc (MAUS2)Fore (BAR)Flymode %s (H)omotopy (W)riting",
	 mode?"FLYING":"CONTROL");
  LABEL2(10,10,"illuSion by  Michael W. Daniels 1997 and Michael Pelsmajer 2000 ",blank);
  LABEL2(80,2770,"(N)ose %0.3f",nose);
  LABEL2(80,2700,"(S)peed %0.4f",speed);
  LABEL2(80,2630,"Tor(Q)ue %0.4f",torq);
  LABEL2(80,2560,"Near clipper %g", wnear);
  LABEL2(80,2490,"F(O)cal factor %g",wnear);
  LABEL2(80,2420,"My s(I)ze %.2g",mysiz);
  LABEL2(80,2350,"Far cli(P)er= %0.3f",wfar);
  LABEL2(80,2280,"(Z)ap",blank);
  LABEL2(80,2210,"(D)imensionality %i", dimensions);
  LABEL2(80,2140,"Pro(j)ection %i",(dimensions == 3 ? whichProj2 : whichProj3));
  LABEL2(80,2070,"Rotate (B)y %0.2f", (float)step/100);
  LABEL2(80,2000,"(F)reeze mouse movement %i",frozen);
  LABEL2(80,1930,"Sn(a)p to illusion",blank);
  LABEL2(80,1860,"(T)ranslate rotation axis %i",transFlag);
  LABEL2(80,1790,"Occlusion (M)ask %i", maskFlag);
  LABEL2(80,1060,"for(E) %d", knopf);
  if (dimensions == 4) {
    LABEL2(80,1720,"ar> Rotate 0 -> 3 %0.3f", rotateAng[0][3]);
    LABEL2(80,1650,"ar<          <- %s","");
    LABEL2(80,1580,"ar^ Rotate 1 -> 3 %0.3f", rotateAng[1][3]);
    LABEL2(80,1510,"arv          <- %s","");
    LABEL2(80,1440,"pg^ Rotate 2 -> 3 %0.3f", rotateAng[2][3]);
    LABEL2(80,1370,"pgv          <- %s","");
  }
  else {
    LABEL2(80,1720,"F1 Rotate 0 -> 2 %0.3f", rotateAng[0][2]);
    LABEL2(80,1650,"F2          <- %s","");
    LABEL2(80,1580,"F3 Rotate 1 -> 2 %0.3f", rotateAng[1][2]);
    LABEL2(80,1510,"F4          <- %s","");
  }
  if(dimensions==4){
    LABEL2(80,1230,"(y) highlight a 3-face",blank);
    LABEL2(80,1300,"(x) highlight point number %d",highlight3);}
  else {
    LABEL2(80,1230,"(y) highlight a 2-face?",blank);
    LABEL2(80,1300,"(x) highlight point number %d",highlight2);}
  glPopMatrix();
  glMatrixMode(GL_PROJECTION); glPopMatrix();
} 

void chaptrack(int but, int xx, int yy, int shif){  
   long dx, dy;
   const float threshold = 3; 
   dx = xx - .5 * xt; dx = (abs(dx) > threshold ? dx : 0);
   dy = yy - .5 * yt; dy = (abs(dy) > threshold ? dy : 0);
   glMatrixMode(GL_MODELVIEW); glPushMatrix(); glLoadIdentity();
   if (mode == TURNMODE) glTranslatef(aff[12],aff[13],aff[14]);
   glRotatef(dx * torq, 0., 1., 0.); 
   glRotatef(dy * torq, 1., 0., 0.);
   if (but&(1 << GLUT_RIGHT_BUTTON)) glRotatef((shif ? -10 : -1), 0., 0., 1.);
   if (but&(1 << GLUT_LEFT_BUTTON)) glRotatef((shif ? 10 : 1), 0., 0., 1.);
   if (mode == FLYMODE) {
     glPushMatrix();
     glMultMatrixf(starmat);
     glGetFloatv(GL_MODELVIEW_MATRIX,starmat);
     glPopMatrix();
   }
   if (but&(1 << GLUT_MIDDLE_BUTTON)) 
     glTranslatef(0., 0.,(shif ? -speed : speed));
   if (mode == TURNMODE) glTranslatef(-aff[12],-aff[13],-aff[14]);
   glMultMatrixf(aff); 
   glGetFloatv(GL_MODELVIEW_MATRIX,aff);

   {
     int ii,jj; 
     for (ii = 0; ii < 3; ii++) {
       lu[ii] = 0;
       for (jj = 0; jj < 3; jj++) 
	 lu[ii] += aff[ii * 4 + jj] * lux[jj];
     }
   }
   glPopMatrix();
}

void reshaped(int xx, int yy) {  
  xt=xx; yt=yy;
}

void drawcons(){  
  glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
  if (binoc) glViewport(0, yt/4, xt/2, yt/2);
  glMatrixMode(GL_PROJECTION); glLoadIdentity();
  glFrustum(-mysiz * xt/yt, mysiz * xt/yt, -mysiz, mysiz, wnear , wfar); 
  glMatrixMode(GL_MODELVIEW); glLoadIdentity();
  drawstars();
  glTranslatef(-binoc * nose, 0.0, 0.0);
  glMultMatrixf(aff);
  drawall();
  if (binoc) {
    glViewport(xt/2, yt/4, xt/2, yt/2); 
    glMatrixMode(GL_MODELVIEW);
    glLoadIdentity();
    drawstars();
    glTranslatef(binoc * nose, 0.0, 0.0);
    glMultMatrixf(aff);
    drawall();
  }
  glViewport(0, 0, xt, yt);
  if (msg) messages();
  glutSwapBuffers();
}

void idle() {
  if (morph) autotymer(0);               
  glutPostRedisplay();                   
  if (!frozen) chaptrack(BUT,XX,YY,SHIF);
}

void mousepushed(int but, int stat, int x, int y) {
  if (stat == GLUT_DOWN) 
    BUT |= (1 << but);
  else 
    BUT &= (-1 ^ (1 << but));  
  XX = x; YY = y; 
  SHIF = (glutGetModifiers() == GLUT_ACTIVE_SHIFT) ? 1 : 0;
}

void mousemoved(int x, int y) {
  XX = x; YY = y; 
}



#ifdef CAVE

#define  CAVEPRESS(K,A,b)  CAVEIF(K){if(CAVEgetbutton(CAVE_LEFTSHIFTKEY)||\
                           CAVEgetbutton(CAVE_RIGHTSHIFTKEY)){b;}else{A;}}
void cavekeybo() {
  CAVEPRESS(CAVE_PKEY, wfar *= 1.01,   wfar   /= 1.01);
  CAVEPRESS(CAVE_QKEY, speed /= 1.02, speed *= 1.02);
  CAVEPRESS(CAVE_RKEY, torq /= 1.02,  torq *= 1.02); 
  CAVEPRESS(CAVE_ZKEY, deFault(), deFault());        
}

#define  LABEL3(x,y,z,W,u){sprintf(buf,(W),(u));char2wall(x,y,z,buf);}

void graffiti() {
  char buf[256];
  static float last = 0., fps;       
  if (!CAVEMasterDisplay()) return;  
  if (floor(2. * *CAVETime) > floor(2. * last)) {  
    last = *CAVETime;
    fps = *CAVEFramesPerSecond;
  }
  if (mode == TURNMODE) {
    glColor3f(1.,0.,1.);
    LABEL3(-3.8,1.,-5.0, "(snap to illusion) (mode) (occlusion mask) ","");
  } 
  else if (mode == FLYMODE) {
    glColor3f(1.,1.,0.);
    LABEL3(-3.8,1.0,-5.0, "(automatic) (mode) (reset) ","");
  }
  else {
    glColor3f(0.66,0.33,0); 
    LABEL3(-3.8,1.0,-5.0, "(cycle projection) (mode) (toggle dimension)", "");
  }
  LABEL3(-4.8,8.0,-5.0,\
	 "illuSion by M. Pelsmajer, 2000, and Michael W. Daniels, Math 198, 1997. illiShell97 (C) Francis, Hartman, Chappell, U. Illinois ","");
  LABEL3(-4.8,1.0,-5.0,"%5.1f fps",fps);
}

void cavetrack(){
  float azi,ele,rol,hx,hy,hz,wx,wy,wz;
  static float ohx,ohy,ohz;   
  static float owx,owy,owz;   
  static int opaw = 0, paw, joy = 0, friz;

  if (!CAVEMasterDisplay()) return;  
  paw = (CAVEBUTTON1 * 2 + CAVEBUTTON2) * 2 + CAVEBUTTON3;
  if (paw) joy = 1; 
  if (opaw != 2 && paw == 2) mode = (mode + 1) % 3;
  
  
  if (mode == TURNMODE){
    if (opaw != 1 && paw == 1) maskFlag = 1 - maskFlag;
    if (opaw != 5 && paw == 5) friz = 1 - friz;  
    if (opaw != 4 && paw == 4) {
      deFault();
      ohx = ohy = ohz = 0;  owx = owy = owz = 0;
      illusionSnap();
    }
  } 
  
  
  if (mode == ROTATEMODE) {                      
    if (opaw != 1 && paw == 1) {
      if (dimensions == 4)
	dimensions = 3;
      else
	dimensions = 4;
      reProject();
    }
    if (opaw != 4 && paw == 4) {
      if (dimensions == 3) {
	whichProj2++; 
	if (whichProj2 > 2) whichProj2 = 0;
      }
      else {
	whichProj3++; 
	if (whichProj3 > 3) whichProj3 = 0;
      }
      reProject();
    }
  }
    
  
  if (mode == FLYMODE){
    if (opaw != 1 && paw == 1){ 
      deFault();
      ohx = ohy = ohz = 0;  
      owx = owy = owz = 0;
    }
    if (opaw != 4 && paw == 4) morph = 1 - morph; 
  }
  
  CAVEGetWandOrientation(azi, ele, rol);
  CAVEGetHead(hx, hy, hz);  
  CAVEGetWand(wx, wy, wz);  
  
  glMatrixMode(GL_MODELVIEW); glPushMatrix(); glLoadIdentity();
  glTranslatef(ohx - hx, ohy - hy, ohz - hz); 

  if (mode == TURNMODE) 
    glTranslatef(aff[12], aff[13], aff[14]);
  if (!friz && mode != ROTATEMODE) {  
    glRotatef(rol * (mode?torq:-torq), 0., 0., 1.); 
    glRotatef(ele * -torq, 1., 0., 0.); 
    glRotatef(azi * -torq, 0., 1., 0.);
  }
  if (joy && ((fabsf(CAVE_JOYSTICK_Y)>.02) || (fabsf(CAVE_JOYSTICK_X)>.02)))
    glTranslatef(CAVE_JOYSTICK_X * speed, 0., CAVE_JOYSTICK_Y * speed); 
  if (opaw == 2 && paw == 2) 
    if (mode == FLYMODE)
      glTranslatef(wx - owx, wy - owy, wz - owz);

  

  if (mode == ROTATEMODE) {
    if (dimensions == 4) {
      rotate(0,3,ele);
      rotate(1,3,azi);
      rotate(2,3,rol);
    }
    else {
      rotate(0,2,ele);
      rotate(1,2,azi);
    }
  }

  if (mode == TURNMODE) 
    glTranslatef(-aff[12], -aff[13], -aff[14]);
  glMultMatrixf(aff); 
  glGetFloatv(GL_MODELVIEW_MATRIX,aff);
  
  { 
    int ii,jj; 
    for(ii = 0;ii < 3;ii++){
      lu[ii] = 0;
      for(jj = 0;jj < 3;jj++)
	lu[ii] += aff[ii * 4 + jj] * lux[jj];
    } 
  }
  
  if (mode == FLYMODE && !friz) { 
    glLoadIdentity();
    glRotatef(rol * (mode?torq:-torq), 0., 0., 1.); 
    glRotatef(ele * -torq, 1., 0., 0.); 
    glRotatef(azi * -torq, 0., 1., 0.);
    glMultMatrixf(starmat); 
    glGetFloatv(GL_MODELVIEW_MATRIX, starmat);
  }
  glPopMatrix();
  opaw = paw; 
  ohx = hx; ohy = hy; ohz = hz;
  owx = wx; owy = wy; owz = wz;
  if (morph) autotymer(0);  
}

void drawcaveinit() {
  CAVEFar = 1000.; glClearColor(0.,0.,0.,0.); glClearDepth(1.);
}

void drawcave() {
  float hx,hy,hz;
  glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
  drawstars();
  graffiti();
  CAVEGetHead(hx, hy, hz);
  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();
  glTranslatef(hx, hy, hz);
  glMultMatrixf(aff);
  glScalef(siz, siz, siz);
  drawall();
  glPopMatrix();
}
#endif



int main(int argc, char** argv) {
  arguments(argc,argv); 
  if (caveflag)
#ifdef CAVE
    CAVEConfigure(&argc, argv, NULL)
#endif
      ;
  getmem();
  dataprep();
  
  if (caveflag) {
#ifdef CAVE
    CAVEInit(); 
    CAVEFrameFunction(cavetrack,0); 
    CAVEInitApplication(drawcaveinit, 0); 
    CAVEDisplay(drawcave, 0);
    while(!CAVEgetbutton(CAVE_ESCKEY)) {
      cavekeybo();  
    }
    CAVEExit();
#endif
    ;}
  else { 
    glutInit(&argc, argv);
    glutInitDisplayMode(GLUT_DOUBLE|GLUT_DEPTH);
    switch (win) {
    case 0: break;
    case 1: glutInitWindowSize(640, 480);
      glutInitWindowPosition(0,1024-480); break;
    case 2: glutInitWindowPosition(0,0); break;
    }
    glutCreateWindow("<* illuSion in C++/OpenGL/GLUT *>");
    if (win == 2) glutFullScreen();
    glEnable(GL_DEPTH_TEST);
    glutDisplayFunc(drawcons);       
    glutKeyboardFunc(keyboard);
    glutSpecialFunc(special_keybo);
    glutMouseFunc(mousepushed);
    glutMotionFunc(mousemoved);       
    glutPassiveMotionFunc(mousemoved); 
    glutReshapeFunc(reshaped);
    glutIdleFunc(idle);             
    glutMainLoop();
  }
} 
