/****************************************************************/
/*4d tic-tac-toe
Author: Muneaki Nakamura
Date: 04/02/2004
*/
/****************************************************************/
#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <sys/time.h>    /* for the speedometer */
#include <glut.h>
#define  MAX(x,y)         (((x)<(y))?(y):(x))
#define  MIN(x,y)         (((x)<(y))?(x):(y))
#define  ABS(u)           ((u)<0 ? -(u): (u))
#define  FOR(a,b,c)       for((a)=(b);(a)<(c);(a)++)
#define  DOT(p,q)         ((p)[0]*(q)[0]+(p)[1]*(q)[1]+(p)[2]*(q)[2])
#define  NRM(p)           sqrt(DOT((p),(p)))
#define  DG            M_PI/180
#define  S(u)          sin(u*DG)
#define  C(u)          cos(u*DG)
#define  CLAMP(x,u,v) (x<u? u : (x>v ? v: x))
/* global variables */
int frozen = 0;
float gap, gap0=1.; /* kludge so that arguments() can set a default gap0 */
float lux[3]={1.,2.,3.};             /*world light direction vector     */
float luxx[3];                       /*  object space  direction vector*/
float amb, pwr ;             /* ambient fraction, pseudo-specular power */
float mysiz,speed, torq, focal, far; /*console navigation variables         */
int win = 1;                   /* 2 full screen, use 0 for demand sized */
unsigned int BUT, XX, YY,SHIF;     /* used in chaptrack gluttery           */ 
int xt,yt;                       /* once was xt,yt,xm,ym for viewportery */
int mode,morph,msg,binoc;            /* pretty global */
int th0, th1, dth, ta0, ta1, dta;    /* torus parameters */
#define FLYMODE  (0)
#define TURNMODE (1) 
int ii, jj, kk;  float tmp, temp;   /* saves gray hairs later */
float aff[16], starmat[16], mat[16]; 
int binoc;    /* flag                       */
float nose;   /* to eye distance in console */

int board[5][5][5][5];     /*What is held by the board:
                        //   1 for X, -1 for O, 0 for nothing*/
double xcoord[5][5][5][5]; /*Current x-coords of each cell (center)*/
double ycoord[5][5][5][5]; /*Current y-coords of each cell (center)*/
double zcoord[5][5][5][5]; /*Current z-coords of each cell (center)*/
double wcoord[5][5][5][5]; /*Current w-coords of each cell (center)*/

double projxc[5][5][5][5]; /*Projected x-coords*/
double projyc[5][5][5][5]; /*Projected y-coords*/
double projzc[5][5][5][5]; /*Projected z-coords*/

double pxline[4][4][3][5][2]; /*Projected x-coords of lines(both ends)*/
double pyline[4][4][3][5][2]; /*Projected y-coords of lines(both ends)*/
double pzline[4][4][3][5][2]; /*Projected z-coords of lines(both ends)*/

int currturn; /*1 for first player, -1 for second player*/
int winner; /* 1 for first player, -1 for second player*/

int xpos=0, ypos=0,zpos=0, wpos=0; /*Current position to place piece*/

double wx = 0, wy=0, wz = 1; /* How the fourth dimensional difference is
                                displayed in three dimensions */
int vectors=1; /*1 for draw helping vectors, 0 for not*/

float gridcolor[5][3] = { {1,1,1},{0.5,1,0.5},{0.5,0.5,1},{1,0.5,0.5}, {0.8,0.6,0.4} };
                             /* the colors of the grid lines of each cube*/

double average(double a, double b, double c, double d)
{
   return (a+b+c+d)/4;
}

void calcLines() /*Calculates positions of lines based on proj. coords
                 //   of adjacent cells */
{
   int i,j,k;
   for(k=0;k<5;k++)
   {
      for(i=0;i<4;i++)
      {
         for(j=0;j<4;j++)
         {
            pxline[i][j][0][k][0] = average(projxc[i][j][0][k],
	       projxc[i+1][j][0][k], projxc[i][j+1][0][k],
	       projxc[i+1][j+1][0][k]);
            pxline[i][j][0][k][1] = average(projxc[i][j][4][k],
	       projxc[i+1][j][4][k], projxc[i][j+1][4][k],
	       projxc[i+1][j+1][4][k]);
            pyline[i][j][0][k][0] = average(projyc[i][j][0][k],
	       projyc[i+1][j][0][k], projyc[i][j+1][0][k],
	       projyc[i+1][j+1][0][k]);
            pyline[i][j][0][k][1] = average(projyc[i][j][4][k],
	       projyc[i+1][j][4][k], projyc[i][j+1][4][k],
	       projyc[i+1][j+1][4][k]);
            pzline[i][j][0][k][0] = average(projzc[i][j][0][k],
	       projzc[i+1][j][0][k], projzc[i][j+1][0][k],
	       projzc[i+1][j+1][0][k]);
            pzline[i][j][0][k][1] = average(projzc[i][j][4][k],
	       projzc[i+1][j][4][k], projzc[i][j+1][4][k],
	       projzc[i+1][j+1][4][k]);
         }
      }
      for(i=0;i<4;i++)
      {
         for(j=0;j<4;j++)
         {
            pxline[i][j][1][k][0] = average(projxc[i][0][j][k],
	       projxc[i+1][0][j][k], projxc[i][0][j+1][k],
	       projxc[i+1][0][j+1][k]);
            pxline[i][j][1][k][1] = average(projxc[i][4][j][k],
	       projxc[i+1][4][j][k], projxc[i][4][j+1][k],
	       projxc[i+1][4][j+1][k]);
            pyline[i][j][1][k][0] = average(projyc[i][0][j][k],
	       projyc[i+1][0][j][k], projyc[i][0][j+1][k],
	       projyc[i+1][0][j+1][k]);
            pyline[i][j][1][k][1] = average(projyc[i][4][j][k],
	       projyc[i+1][4][j][k], projyc[i][4][j+1][k],
	       projyc[i+1][4][j+1][k]);
            pzline[i][j][1][k][0] = average(projzc[i][0][j][k],
	       projzc[i+1][0][j][k], projzc[i][0][j+1][k],
	       projzc[i+1][0][j+1][k]);
            pzline[i][j][1][k][1] = average(projzc[i][4][j][k],
	       projzc[i+1][4][j][k], projzc[i][4][j+1][k],
	       projzc[i+1][4][j+1][k]);
         }
      }
      for(i=0;i<4;i++)
      {
         for(j=0;j<4;j++)
         {
            pxline[i][j][2][k][0] = average(projxc[0][i][j][k],
	       projxc[0][i+1][j][k], projxc[0][i][j+1][k],
	       projxc[0][i+1][j+1][k]);
            pxline[i][j][2][k][1] = average(projxc[4][i][j][k],
	       projxc[4][i+1][j][k], projxc[4][i][j+1][k],
	       projxc[4][i+1][j+1][k]);
            pyline[i][j][2][k][0] = average(projyc[0][i][j][k],
	       projyc[0][i+1][j][k], projyc[0][i][j+1][k],
	       projyc[0][i+1][j+1][k]);
            pyline[i][j][2][k][1] = average(projyc[4][i][j][k],
	       projyc[4][i+1][j][k], projyc[4][i][j+1][k],
	       projyc[4][i+1][j+1][k]);
            pzline[i][j][2][k][0] = average(projzc[0][i][j][k],
	       projzc[0][i+1][j][k], projzc[0][i][j+1][k],
	       projzc[0][i+1][j+1][k]);
            pzline[i][j][2][k][1] = average(projzc[4][i][j][k],
	       projzc[4][i+1][j][k], projzc[4][i][j+1][k],
	       projzc[4][i+1][j+1][k]);
         }
      }
   }
}

void calcProj() /* calculate the project x,y,z based on the offset for w coord*/
{
   int i,j,k,l;
   for(i=0;i<5;i++)
   {
      for(j=0;j<5;j++)
      {
         for(k=0;k<5;k++)
	 {
	    for(l=0;l<5;l++)
	    {
	       projxc[i][j][k][l] = xcoord[i][j][k][l]+wx*wcoord[i][j][k][l];
	       projyc[i][j][k][l] = ycoord[i][j][k][l]+wy*wcoord[i][j][k][l];
	       projzc[i][j][k][l] = zcoord[i][j][k][l]+wz*wcoord[i][j][k][l];
            }
         }
      }
   }
   calcLines();
}

int initGame() /*Clears board and resets positions*/
{
   int i,j,k,l;
   for(i=0; i<5; i++) /*initialize board and coords*/
   {
      for(j=0; j<5; j++)
      {
         for(k=0; k<5; k++)
	 {
            for(l=0; l<5; l++)
	    {
	       board[i][j][k][l] = 0;          /*all board is blank*/
       	       xcoord[i][j][k][l] = 0.5*i-1;
	                                 /*place x from -1 to 1 incl.*/
	       ycoord[i][j][k][l] = 0.5*j-1;
	                                 /*"                    "*/
	       zcoord[i][j][k][l] = 0.5*k-1;
	                                 /*"                    "*/
	       wcoord[i][j][k][l] = 0.5*l-1;
	                                 /*"                    "*/
            }
	 }
      }
   }
   calcProj();
   xpos = ypos = zpos = wpos = 0;
   wx = wy = wz = 0;
   currturn = 1;
   winner = 0;
}
/**********************************************************************/
int calcDiagonals(int dimension) /*0 for xw doesn't change, 1 yw, 2 wz
                                   3 yz, 4 zx, 5 xy */
{
   int i;
   int sum1=0, sum2=0;
   if(dimension==0)
   {
      for(i=0;i<5;i++)
      {
         sum1+=board[xpos][i][i][wpos];
	 sum2+=board[xpos][i][4-i][wpos];
      }
      if(abs(sum1) == 5)
      {
         for(i=0;i<5;i++) board[xpos][i][i][wpos]*=2;
      }
      else if(abs(sum2) == 5)
      {
         for(i=0;i<5;i++) board[xpos][i][4-i][wpos]*=2;
      }
   }
   else if(dimension==1)
   {
      for(i=0;i<5;i++)
      {
         sum1+=board[i][ypos][i][wpos];
	 sum2+=board[i][ypos][4-i][wpos];
      }
      if(abs(sum1) == 5)
      {
         for(i=0;i<5;i++) board[i][ypos][i][wpos]*=2;
      }
      else if(abs(sum2) == 5)
      {
	 for(i=0;i<5;i++) board[i][ypos][4-i][wpos]*=2;
      }
   }
   else if(dimension==2)
   {
      for(i=0;i<5;i++)
      {
         sum1+=board[i][i][zpos][wpos];
	 sum2+=board[i][4-i][zpos][wpos];
      }
      if(abs(sum1) == 5)
      {
         for(i=0;i<5;i++) board[i][i][zpos][wpos]*=2;
      }
      else if(abs(sum2) == 5)
      {
	 for(i=0;i<5;i++) board[i][4-i][zpos][wpos]*=2;
      }
   }
   else if(dimension==3)
   {
      for(i=0;i<5;i++)
      {
         sum1+=board[i][ypos][zpos][i];
	 sum2+=board[i][ypos][zpos][4-i];
      }
      if(abs(sum1) == 5)
      {
         for(i=0;i<5;i++) board[i][ypos][zpos][i]*=2;
      }
      else if(abs(sum2) == 5)
      {
	 for(i=0;i<5;i++) board[i][ypos][zpos][4-i]*=2;
      }
   }
   else if(dimension==4)
   {
      for(i=0;i<5;i++)
      {
         sum1+=board[xpos][i][zpos][i];
	 sum2+=board[xpos][i][zpos][4-i];
      }
      if(abs(sum1) == 5)
      {
         for(i=0;i<5;i++) board[xpos][i][zpos][i]*=2;
      }
      else if(abs(sum2) == 5)
      {
	 for(i=0;i<5;i++) board[xpos][i][zpos][4-i]*=2;
      }
   }
   else if(dimension==5)
   {
      for(i=0;i<5;i++)
      {
         sum1+=board[xpos][ypos][i][i];
	 sum2+=board[xpos][ypos][i][4-i];
      }
      if(abs(sum1) == 5)
      {
         for(i=0;i<5;i++) board[xpos][ypos][i][i]*=2;
      }
      else if(abs(sum2) == 5)
      {
	 for(i=0;i<5;i++) board[xpos][ypos][i][4-i]*=2;
      }
   }
   if(abs(sum1) == 5 || abs(sum2) == 5) return 1;
   else return 0;
}
/**********************************************************************/
int calcBigDiagonals(int dimension) /* 0 for x constant, 1 y, 2z, 3w */
{
   int i; int sum1=0, sum2=0, sum3=0, sum4=0;
   if(dimension == 0)
   {
      for(i=0;i<5;i++)
      {
         sum1+=board[xpos][i][i][i];
         sum2+=board[xpos][i][i][4-i];
         sum3+=board[xpos][i][4-i][i];
         sum4+=board[xpos][4-i][i][i];
      }
      if(abs(sum1)==5)
      {
         for(i=0;i<5;i++) board[xpos][i][i][i]*=2;
      }
      if(abs(sum2)==5)
      {
         for(i=0;i<5;i++) board[xpos][i][i][4-i]*=2;
      }
      if(abs(sum3)==5)
      {
         for(i=0;i<5;i++) board[xpos][i][4-i][i]*=2;
      }
      if(abs(sum4)==5)
      {
         for(i=0;i<5;i++) board[xpos][4-i][i][i]*=2;
      }

   }
   else if(dimension == 1)
   {
      for(i=0;i<5;i++)
      {
         sum1+=board[i][ypos][i][i];
         sum2+=board[i][ypos][i][4-i];
         sum3+=board[i][ypos][4-i][i];
         sum4+=board[4-i][ypos][i][i];
      }
      if(abs(sum1)==5)
      {
         for(i=0;i<5;i++) board[i][ypos][i][i]*=2;
      }
      if(abs(sum2)==5)
      {
         for(i=0;i<5;i++) board[i][ypos][i][4-i]*=2;
      }
      if(abs(sum3)==5)
      {
         for(i=0;i<5;i++) board[i][ypos][4-i][i]*=2;
      }
      if(abs(sum4)==5)
      {
         for(i=0;i<5;i++) board[4-i][ypos][i][i]*=2;
      }
   }
   else if(dimension == 2)
   {
      for(i=0;i<5;i++)
      {
         sum1+=board[i][i][zpos][i];
         sum2+=board[i][i][zpos][4-i];
         sum3+=board[i][4-i][zpos][i];
         sum4+=board[4-i][i][zpos][i];
      }
      if(abs(sum1)==5)
      {
         for(i=0;i<5;i++) board[i][i][zpos][i]*=2;
      }
      if(abs(sum2)==5)
      {
         for(i=0;i<5;i++) board[i][i][zpos][4-i]*=2;
      }
      if(abs(sum3)==5)
      {
         for(i=0;i<5;i++) board[i][4-i][zpos][i]*=2;
      }
      if(abs(sum4)==5)
      {
         for(i=0;i<5;i++) board[4-i][i][zpos][i]*=2;
      }
   }
   else if(dimension == 3)
   {
      for(i=0;i<5;i++)
      {
         sum1+=board[i][i][i][wpos];
         sum2+=board[i][i][4-i][wpos];
         sum3+=board[i][4-i][i][wpos];
         sum4+=board[4-i][i][i][wpos];
      }
      if(abs(sum1)==5)
      {
         for(i=0;i<5;i++) board[i][i][i][wpos]*=2;
      }
      if(abs(sum2)==5)
      {
         for(i=0;i<5;i++) board[i][i][4-i][wpos]*=2;
      }
      if(abs(sum3)==5)
      {
         for(i=0;i<5;i++) board[i][4-i][i][wpos]*=2;
      }
      if(abs(sum4)==5)
      {
         for(i=0;i<5;i++) board[4-i][i][i][wpos]*=2;
      }
   }
   if( abs(sum1) == 5 || abs(sum2) == 5 || abs(sum3) == 5 || abs(sum4)== 5)
   {
      return 1;
   }
   return 0;
}
/**********************************************************************/
int calcBiggerDiagonals()
{
   int sum1, sum2, sum3, sum4, sum5, sum6, sum7, sum8, sum9, sum10, sum11;
   int i;
   sum1=sum2=sum3=sum4=sum5=sum6=sum7=sum8=sum9=sum10=sum11=0;
   for(i=0;i<5;i++)
   {
      sum1+=board[i][i][i][i];
      sum2+=board[4-i][i][i][i];
      sum3+=board[i][4-i][i][i];
      sum4+=board[i][i][4-i][i];
      sum5+=board[i][i][i][4-i];
      sum6+=board[4-i][4-i][i][i];
      sum7+=board[4-i][i][4-i][i];
      sum8+=board[4-i][i][i][4-i];
      sum9+=board[i][4-i][4-i][i];
      sum10+=board[i][4-i][i][4-i];
      sum11+=board[i][i][4-i][4-i];
   }
   if(abs(sum1)==5)
   {
      for(i=0;i<5;i++) board[i][i][i][i]*=2;
      return 1;
   }
   if(abs(sum2)==5)
   {
      for(i=0;i<5;i++) board[4-i][i][i][i]*=2;
      return 1;
   }
   if(abs(sum3)==5)
   {
      for(i=0;i<5;i++) board[i][4-i][i][i]*=2;
      return 1;
   }
   if(abs(sum4)==5)
   {
      for(i=0;i<5;i++) board[i][i][4-i][i]*=2;
      return 1;
   }
   if(abs(sum5)==5)
   {
      for(i=0;i<5;i++) board[i][i][i][4-i]*=2;
      return 1;
   }
   if(abs(sum6)==5)
   {
      for(i=0;i<5;i++) board[4-i][4-i][i][i]*=2;
      return 1;
   }
   if(abs(sum7)==5)
   {
      for(i=0;i<5;i++) board[4-i][i][4-i][i]*=2;
      return 1;
   }
   if(abs(sum8)==5)
   {
      for(i=0;i<5;i++) board[4-i][i][i][4-i]*=2;
      return 1;
   }
   if(abs(sum9)==5)
   {
      for(i=0;i<5;i++) board[i][4-i][4-i][i]*=2;
      return 1;
   }
   if(abs(sum10)==5)
   {
      for(i=0;i<5;i++) board[i][4-i][i][4-i]*=2;
      return 1;
   }
   if(abs(sum11)==5)
   {
      for(i=0;i<5;i++) board[i][i][4-i][4-i]*=2;
      return 1;
   }
   return 0;
}
/**********************************************************************/
int calcWin(void)
{
   int i;
   int sum1, sum2, sum3, sum4,sum5, sum6;
   sum1 = sum2 = sum3 = sum4 = sum5 = sum6 = 0;
   for(i=0; i<5; i++)
   {
      sum1+=board[i][ypos][zpos][wpos];
      sum2+=board[xpos][i][zpos][wpos];
      sum3+=board[xpos][ypos][i][wpos];
      sum4+=board[xpos][ypos][zpos][i];
   }
   if(abs(sum1) == 5)
   {
      for(i=0; i<5; i++) board[i][ypos][zpos][wpos]*=2;
      return currturn;
   }
   else if( abs(sum2) == 5)
   {
      for(i=0; i<5; i++) board[xpos][i][zpos][wpos]*=2;
      return currturn;
   }
   else if(abs(sum3) == 5)
   {
      for(i=0;i<5; i++) board[xpos][ypos][i][wpos]*=2;
      return currturn;
   }
   else if(abs(sum4) == 5)
   {
      for(i=0;i<5;i++) board[xpos][ypos][zpos][i]*=2;
      return currturn;
   }
   sum1 = sum2 = sum3 = sum4 = 0;
   if(xpos == ypos || xpos+ypos == 4) sum1=calcDiagonals(2);
   if(xpos == zpos || xpos+zpos == 4) sum2=calcDiagonals(1);
   if(zpos == ypos || zpos+ypos == 4) sum3=calcDiagonals(0);
   if(wpos == xpos || wpos+xpos == 4) sum4=calcDiagonals(3);
   if(wpos == ypos || wpos+ypos == 4) sum5=calcDiagonals(4);
   if(wpos == zpos || wpos+zpos == 4) sum6=calcDiagonals(5);
   if(sum1==1 || sum2==1 || sum3==1 || sum4 == 1 || sum5 == 1 || sum6 == 1)
   {
      return currturn;
   }
   sum1 = sum2 = sum3 = sum4 = sum5 = sum6 = 0;
   if( (xpos == ypos && ypos == zpos) || (xpos == 4-ypos && zpos == 4-ypos)
      || (ypos == 4-xpos && zpos == 4-xpos) || (xpos==4-zpos && ypos == 4-zpos))
   {
      sum4 = calcBigDiagonals(3);
   }
   if( (xpos == ypos && ypos == wpos) || (xpos == 4-ypos && wpos == 4-ypos)
      || (ypos == 4-xpos && wpos == 4-xpos) || (xpos==4-wpos && ypos == 4-wpos))
   {
      sum3 = calcBigDiagonals(2);
   }
   if( (xpos == wpos && wpos == zpos) || (xpos == 4-wpos && zpos == 4-wpos)
      || (wpos == 4-xpos && zpos == 4-xpos) || (xpos==4-zpos && wpos == 4-zpos))
   {
      sum2 = calcBigDiagonals(1);
   }
   if( (wpos == ypos && ypos == zpos) || (wpos == 4-ypos && zpos == 4-ypos)
      || (ypos == 4-wpos && zpos == 4-wpos) || (wpos==4-zpos && ypos == 4-zpos))
   {
      sum1 = calcBigDiagonals(0);
   }
   if(sum1 == 1 || sum2 == 1 || sum3 == 1 || sum4 == 1) return currturn;
   if(calcBiggerDiagonals()) return currturn;
   return 0;
}
/**********************************************************************/
void doTurn(void)
{
   if(board[xpos][ypos][zpos][wpos] == 0)
   {
      board[xpos][ypos][zpos][wpos] = currturn;
      winner = calcWin();
      if(abs(winner) == 1)
      {
         printf("Player %i wins\n", -currturn/2+1);
      }
      else currturn*=-1;
   }
}
/**********************************************************************/
void drawgrid(void) /* draw lattice */
{
   int i,j,k,l;
   glBegin(GL_LINES);
   for(i=0; i<4; i++)
   {
      for(j=0;j<4;j++)
      {
         for(k=0;k<3;k++)
	 {
	    for(l=0;l<5;l++)
	    {
	       glColor3f(gridcolor[l][0], gridcolor[l][1], gridcolor[l][2]);
	       glVertex3f(pxline[i][j][k][l][0],pyline[i][j][k][l][0],
	          pzline[i][j][k][l][0]);
	       glVertex3f(pxline[i][j][k][l][1],pyline[i][j][k][l][1],
	          pzline[i][j][k][l][1]);
            }
	 }
      }
   }
   glEnd();
}
/**********************************************************************/
void lightson(void);
void lightsoff(void);
void drawsel(void) /* draw selected area */
{
if(!winner)
{
   if(currturn == 1) glColor3f(0.1, 0.05, 1.0);
   else if (currturn == -1) glColor3f(1.0, 0.05, 0.1);
   glPushMatrix();
   glTranslatef(projxc[xpos][ypos][zpos][wpos], projyc[xpos][ypos][zpos][wpos],
                  projzc[xpos][ypos][zpos][wpos]);
   lightson();
   glutSolidCube(0.5);
   lightsoff();
   glPopMatrix();
}
}
/**********************************************************************/
void separateCubes(void)
{
   wx = wy = wz = 3.2;
}
/**********************************************************************/
void autotymer(int reset){ /* cheap animations */
#define  TYME(cnt,max,act) {static cnt; if(first)cnt=max; else\
                            if(cnt?cnt--:0){ act ; goto Break;}}
  static first = 1;  /* the first time autymer is called */
  if(reset)first=1;  /* or if it is reset to start over  */
if(winner) return;
  TYME( shrink , 1,xpos=rand()%5;ypos=rand()%5;zpos=rand()%5;wpos=rand()%5)
  TYME( grow   , 1,doTurn())
  TYME(finish  , 1 , first = 1  )
  first = 0;
  Break:   ;   /* yes Virginia, C has gotos */
}
/**********************************************************************/
void deFault(void){
th0=5; th1=355;  ta0=5; ta1=355; gap = gap0; 
msg=1; binoc=0; nose=.06; mode=TURNMODE;  
speed=.1; torq=.02; focal = 2.; far =20.; mysiz=.01; morph=0; 
FOR(ii,0,16) starmat[ii]=aff[ii] = (ii/4==ii%4);   /* identities */ 
FOR(ii,0,3)lux[ii]/=NRM(lux); amb = .3; pwr = 10. ;
aff[12]=0; aff[13]= 0; aff[14]= -4.2;   /* place where we can see it */
autotymer(1); /* reset autotymer to start at the beginning */

initGame();
}
/**********************************************************************/
void drawvert(int th, int ta){  
float lmb,spec,nn[3], dog, cat;
nn[0] = C(th)*C(ta); /* unit sphere radius vector */  
nn[1] = S(th)*C(ta);
nn[2] =       S(ta);
lmb = DOT(nn,luxx);lmb =(lmb<0 ? .2 : lmb);  lmb = MAX(amb, lmb); 
spec = CLAMP((1.1 - pwr+pwr*lmb), 0., 1.);  
dog = (ta-ta0)/(float)(ta1-ta0); cat = (th-th0)/(float)(th1-th0);
glColor3f(
  MAX(spec, lmb*dog),                    /* map R^2(dog,cat)->R^3(RGBspace */
  MAX(spec, lmb*(.25 + ABS(cat -.5))),  /* dog cat model of Hartman       */
  MAX(spec, lmb*(1 - cat)));            /* illiLight by Ray Idaszak 1989  */
glVertex3f(
  C(th) + .5*nn[0],
  S(th) + .5*nn[1],
          .5*nn[2]);
} /* end drawvert */
/**********************************************************************/
void drawtor(void){
int th, ta;
dth = (int)((th1-th0)/24);  /* 24  meridian strips */ 
dta = (int)((ta1-ta0)/24);  /* 24  triangle pairs per strip */
for(th=th0; th < th1; th += dth){
  glBegin(GL_TRIANGLE_STRIP);
  for(ta=ta0; ta < ta1; ta += dta){ drawvert(th,ta); drawvert(th+gap*dth,ta); }
  glEnd();
  } /* end for.theta loop */
}   /* end drawtor */
/**********************************************************************/
void lightson(void){
glEnable(GL_LIGHTING);
glEnable(GL_LIGHT0);
glEnable(GL_COLOR_MATERIAL);
glColorMaterial ( GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE);
}
void lightsoff(void){
glDisable(GL_LIGHTING);
glDisable(GL_LIGHT0);
glDisable(GL_COLOR_MATERIAL);
glColorMaterial ( GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE);
}


void drawpoints(void)
{
   int i,j,k,l;
   glColor3f(1.0,1.0,1.0);
   for(i=0;i<5;i++)
   {
      for(j=0;j<5;j++)
      {
         for(k=0;k<5;k++)
         {
	    for(l=0;l<5;l++)
	    {
   	       if(board[i][j][k][l] <= -1)
	       {
                  glPushMatrix();
                  if(board[i][j][k][l] == -1) glColor3f(1.0, 0.1, 0.0);
		  else glColor3f(0.1,1.0,0.0);
                  glTranslatef(projxc[i][j][k][l], projyc[i][j][k][l],
                     projzc[i][j][k][l]);
                  lightson();
                  glutSolidSphere(0.2,12,12);
                  lightsoff();
                  glPopMatrix();
               }
	       else if(board[i][j][k][l] >= 1)
	       {
                  glPushMatrix();
                  if(board[i][j][k][l] == 1) glColor3f(0.0, 0.1, 1.0);
		  else glColor3f(0.0,1.0,0.1);
                  glTranslatef(projxc[i][j][k][l], projyc[i][j][k][l],
                     projzc[i][j][k][l]);
                  glScalef(0.3,0.3,0.3);
                  lightson();
                  glutSolidTetrahedron();
                  lightsoff();
                  glPopMatrix();
               }
               else
               {
	          glColor3f(gridcolor[l][0], gridcolor[l][1], gridcolor[l][2]);
                  glBegin(GL_POINTS);
                  glVertex3f(projxc[i][j][k][l], projyc[i][j][k][l],
		     projzc[i][j][k][l]);
                  glEnd();
               }
            }
         }
      }
   }
   glEnd();
}

void drawvectors()
{
   glBegin(GL_LINES);
   glColor3f(1.0,1.0,0.0);
   glVertex3f(-1.1,-1.1,-1.1); glVertex3f(-.1,-1.1, -1.1);
   glVertex3f(-.15,-1.05,-1.05); glVertex3f(-.1,-1.1, -1.1);
   glVertex3f(-.15,-1.15,-1.15); glVertex3f(-.1,-1.1, -1.1);
   glColor3f(1.0,0.0,1.0);
   glVertex3f(-1.1,-1.1,-1.1); glVertex3f(-1.1,-.1, -1.1);
   glVertex3f(-1.05,-.15,-1.05); glVertex3f(-1.1,-.1, -1.1);
   glVertex3f(-1.15,-.15,-1.15); glVertex3f(-1.1,-.1, -1.1);
   glColor3f(0.0,1.0,1.0);
   glVertex3f(-1.1,-1.1,-1.1); glVertex3f(-1.1,-1.1, -.1);
   glVertex3f(-1.05,-1.05,-.15); glVertex3f(-1.1,-1.1, -.1);
   glVertex3f(-1.15,-1.15,-.15); glVertex3f(-1.1,-1.1, -.1);
   if(wx != 0 || wy != 0 || wz != 0)
   {
      glColor3f(1.0,1.0,1.0);
      glVertex3f(-1.1,-1.1,-1.1); glVertex3f(-1.1+wx/5,-1.1+wy/5,-1.1+wz/5);
      glVertex3f(-1.1+wx/5+wx/20,-1.1+wy/5-wy/20,-1.1+wz/5-wz/20);
       glVertex3f(-1.1+wx/5,-1.1+wy/5,-1.1+wz/5);
      glVertex3f(-1.1+wx/5-wx/20,-1.1+wy/5+wy/20,-1.1+wz/5-wz/20);
       glVertex3f(-1.1+wx/5,-1.1+wy/5,-1.1+wz/5);
      glVertex3f(-1.1+wx/5-wx/20,-1.1-wy/5-wy/20,-1.1+wz/5+wz/20);
       glVertex3f(-1.1+wx/5,-1.1+wy/5,-1.1+wz/5);
   }
   glEnd();
}
      
void drawall(void){drawpoints(); drawgrid(); drawsel();if(vectors) drawvectors();/*drawtor()*/; 
/*
glColor3f(0.5,0.3,0.4);
glBegin(GL_LINE_STRIP);
glVertex3f(-1,-1,-1);
glVertex3f(-1,-1,1);
glVertex3f(-1,1,-1);
glVertex3f(1,-1,-1);
glVertex3f(1,1,-1);
glVertex3f(1,-1,1);
glVertex3f(-1,1,1);
glVertex3f(1,1,1);
glEnd();
*/
}

/**********************************************************************/
void drawstars(void){ 
     static float star[1000][3]; static int virgin=1;
 if(virgin){  /* first time  set up the stars */
	     FOR(ii,0,1000)FOR(jj,0,3)star[ii][jj]=random()/(float)0x40000000-1.;
	     virgin=0; /* never again */
	  }
	  glMatrixMode(GL_MODELVIEW);
	  glPushMatrix();   /* insurance of superstition */
	  glMultMatrixf(starmat);
	  glColor3f(1.0,1.0,0.0);    
	  glBegin(GL_POINTS);
	    FOR(ii,0,1000)glVertex3fv(star[ii]);
  glEnd();
  glPopMatrix();
  glClear(GL_DEPTH_BUFFER_BIT); /* so the stars are behind everything */
}
/**********************************************************************/
void arguments(int argc,char **argv){
  extern char *optarg;
  extern int optind; 
  int chi;   
  /* w: needs ONE number after -w, c<nothing> means NO number follows*/ 
  while ((chi = getopt(argc,argv,"w:d:g:")) != -1) 
  switch(chi)  {
                case 'w': win=atoi(optarg); break; 
                case 'g': gap0=atof(optarg); break;
                }
  if (optind!=argc) fprintf(stderr,"%s: Incorrect usage\n",argv[0]);
}
/**********************************************************************/
void keyboard(unsigned char key, int x, int y){
#define  IF(K)            if(key==K)
#define  PRESS(K,A,b)     IF(K){b;}IF((K-32)){A;}  
/*was backwards in previous versions */
#define  TOGGLE(K,flg)    IF(K){(flg) = 1-(flg); }
#define  CYCLE(K,f,m)     PRESS((K), (f)=(((f)+(m)-1)%(m)),(f)=(++(f)%(m)))
#define  SLIDI(K,f,m,M)   PRESS(K,(--f<m?m:f), (++f>M?M:f))
#define  SLIDF(K,f,m,M,d) PRESS(K,((f -= d)<m?m:f), ((f += d)>M?M:f))
/* Only ASCII characters can be processes by this GLUT callback function */ 
   IF(27) { exit(0); }              /* ESC exit            */
   TOGGLE('v',binoc);                            /* cross-eyed STEREO   */
   CYCLE(' ', mode,TURNMODE+1);                  /* fly/turn modes      */
   TOGGLE('c',morph);                            /* autotymer on/off    */
   TOGGLE('w',msg);                              /* writing on/off      */
   TOGGLE('f',frozen);                           /* freezing on/off     */
   TOGGLE('e',vectors);
   if(key == 'x') {wx+=0.01;calcProj();}
   else if(key=='X') {wx-=0.01;calcProj();}
   if(key == 'y') {wy+=0.01;calcProj();}
   else if(key=='Y') {wy-=0.01;calcProj();}
   if(key == 'z') {wz+=0.01;calcProj();}
   else if(key=='Z') {wz-=0.01;calcProj();}
   if(key == 'b') {wx+=0.1;calcProj();}
   else if(key=='B') {wx-=0.1;calcProj();}
   if(key == 'n') {wy+=0.1;calcProj();}
   else if(key=='N') {wy-=0.1;calcProj();}
   if(key == 'm') {wz+=0.1;calcProj();}
   else if(key=='M') {wz-=0.1;calcProj();}
   PRESS('s',speed /= 1.02, speed *= 1.02);      /* flying speed        */
   PRESS('q',torq /= 1.02, torq *= 1.02);        /* turning speed       */
   PRESS('o', focal *= 1.1 , focal /= 1.1)       /* telephoto           */
   PRESS('i', mysiz /= 1.1, mysiz *= 1.1)        /* rescale the world   */
   PRESS('p', far *= 1.01 , far   /= 1.01)       /* rear clipping plane */
   PRESS('g', deFault(), deFault());             /* zap changes         */
   PRESS('a', separateCubes(), separateCubes());
 /*  PRESS('g',gap /= .9, gap *= .9);            
   PRESS('a',amb /= .9, amb *= .9);             
   PRESS('r',pwr /= .9, pwr *= .9);           
   */
   if(key == '8' && ypos != 4) { ypos++; }
   if(key == '2' && ypos != 0) { ypos--; }
   if(key == '4' && xpos != 0) { xpos--; }
   if(key == '6' && xpos != 4) { xpos++; }
   if(key == '7' && zpos != 4) { zpos++; }
   if(key == '3' && zpos != 0) { zpos--; }
   if(key == '9' && wpos != 4) { wpos++; }
   if(key == '1' && wpos != 0) { wpos--; }
   if(key == '5') { if(!winner) doTurn(); }
}
/**********************************************************************/
void special_keybo(int key, int x, int y){
/*non-ASCII keypresses go here, if you're lucky enough to know their names */
 fprintf(stderr," non-ASCII character was pressed.\n");
 fprintf(stderr," use special_keybo() to process it\n");
}
/**********************************************************************/
float speedometer(void){
double dbl; static double rate; static int ii=0;
static struct timezone notused; static struct timeval now, then;
   if(++ii % 8 == 0){  /* 8 times around measure time */
      gettimeofday(&now, &notused); /* elapsed time */
      dbl =  (double)(now.tv_sec - then.tv_sec)
         +(double)(now.tv_usec - then.tv_usec)/1000000;
      then = now;  rate = 8/dbl;
      }
   return((float)rate);
}
/**********************************************************************/
void char2wall(float x,float y,float z, char buf[]){
     char *p; glRasterPos3f(x,y,z);
     for(p = buf;*p;p++) glutBitmapCharacter(GLUT_BITMAP_9_BY_15,*p);
}
/**********************************************************************/
void messages(void){     
  char buf[256]; /* console messages are done differently from cave */
#define  LABEL2(x,y,W,u) {sprintf(buf,(W),(u));char2wall(x,y,0.,buf);}
  glMatrixMode(GL_PROJECTION); glPushMatrix(); glLoadIdentity();
  gluOrtho2D(0,3000,0,3000);
  glMatrixMode(GL_MODELVIEW); glPushMatrix(); glLoadIdentity();
      /*bull's eye*/
      if(mode==TURNMODE) glColor3f(0x22/255.,0x88/255.,0xdd/255.);
        else      glColor3f(.8,.8,.8);
      LABEL2(1500,1500,"%s","o");
      /* writings */
      if(mode==TURNMODE) glColor3f(1.,0.,1.);
        else      glColor3f(1.,1.,0.);
      LABEL2(80,80,"%4.1f fps",speedometer());
      LABEL2(80,2840,\
      "(ESC)ape (V)Binoc (MAUS2)Fore (BAR)Flymode %s (W)riting",
             mode?"FLYING":"CONTROL");
      LABEL2(10,10,"illi4dT3 \
   by Nakamura, Francis, Bourd, Hartman & Chappell, U. Illinois, 2004 %s","");
   /*   LABEL2(80,2770,"(N)ose   %0.3f",nose); */
      LABEL2(80,2700,"(S)peed  %0.4f",speed);
      LABEL2(80,2630," tor(Q) %0.4f",torq);
      LABEL2(80,2560,"near clipper %g", mysiz*focal);
      LABEL2(80,2490,"f(O)cal factor %g",focal);
      LABEL2(80,2420,"my s(I)ze %.2g",mysiz);
      LABEL2(80,2350,"far cli(P)er= %.2g",far);
      LABEL2(80,2280,"New (G)ame %s","");
      LABEL2(80,2210,"(x)proj.[b] %.3g",wx);
      LABEL2(80,2140,"(y)proj.[n] %.3g",wy);
      LABEL2(80,2070,"(z)proj.[m] %.3g",wz);
      LABEL2(80,2000,"(C)omputers: %s",morph ? "ON" : "OFF"); 
      LABEL2(80,1930,"(A)uto space %s", "");
      LABEL2(80,1860,"Draw v(E)ctors %s", "");
      if(winner)
      {
         LABEL2(1000,2000,"Player %s won", winner < 0 ? "2 (red)" : "1 blue)");
      }
  /*    LABEL2(80,2210,"(G)ap %.2g",gap);
      LABEL2(80,2140,"(A)mb %.2g",amb);
      LABEL2(80,2070,"pw(R) %.2g",pwr);*/
     
    glPopMatrix();
glMatrixMode(GL_PROJECTION); glPopMatrix();
} 
/**********************************************************************/
void chaptrack(int but,int xx,int yy,int shif){  
   long dx,dy; 
   dx = xx -.5*xt; dx = abs(dx)>10?dx:0;
   dy = yy -.5*yt; dy = abs(dy)>10?dy:0;

   glMatrixMode(GL_MODELVIEW); glPushMatrix(); glLoadIdentity();

   if(mode==TURNMODE) glTranslatef(aff[12],aff[13],aff[14]);
   glRotatef(dx*torq,0.,1.,0.); glRotatef(dy*torq,1.,0.,0.);
   if(but&(1<<GLUT_RIGHT_BUTTON ))glRotatef(shif?-10:-1,0.,0.,1.);
   if(but&(1<<GLUT_LEFT_BUTTON  ))glRotatef(shif?10:1,0.,0.,1.);
   if(mode==FLYMODE){
      glPushMatrix();
      glMultMatrixf(starmat);
      glGetFloatv(GL_MODELVIEW_MATRIX,starmat);
      glPopMatrix();
   }
   if(but&(1<<GLUT_MIDDLE_BUTTON)) glTranslatef(0.,0.,shif ? -speed : speed);
   if(mode==TURNMODE) glTranslatef(-aff[12],-aff[13],-aff[14]);
   glMultMatrixf(aff); 
   glGetFloatv(GL_MODELVIEW_MATRIX,aff);
   FOR(ii,0,3){luxx[ii]=0; FOR(jj,0,3)luxx[ii] +=aff[ii*4+jj]*lux[jj];}
   glPopMatrix();
}
/**********************************************************************/
void reshaped(int xx, int yy){xt=xx ; yt=yy;}   /* origin of moved window */
/**********************************************************************/
void drawcons(void){  
  glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
  if(binoc) glViewport(0,yt/4,xt/2,yt/2);
  glMatrixMode(GL_PROJECTION); glLoadIdentity();
  glFrustum(-mysiz*xt/yt,mysiz*xt/yt,-mysiz,mysiz,mysiz*focal,far); 
  glMatrixMode(GL_MODELVIEW); glLoadIdentity();
 /* drawstars(); */
  glTranslatef(-binoc*nose,0.0,0.0);
  glMultMatrixf(aff);
  drawall();
  glViewport(0,0,xt,yt);
  if(msg) messages();
  glutSwapBuffers();
}

/**********************************************************************/
void idle(void){ /*do this when nothing else is happening*/
   if(morph) autotymer(0);  /* advance autotymer */ 
   glutPostRedisplay();  /*redraw the window*/
   if(!frozen) chaptrack(BUT,XX,YY,SHIF);
}

/**********************************************************************/
void mousepushed(int but,int stat,int x,int y){
  if(stat==GLUT_DOWN) BUT |= (1<<but);
  else BUT &= (-1 ^ (1<<but));  
  XX=x; YY=y; SHIF=(glutGetModifiers()==GLUT_ACTIVE_SHIFT)?1:0;
}

/**********************************************************************/
void mousemoved(int x,int y){  XX=x; YY=y; }
/**********************************************************************/
int main(int argc, char **argv){  
   GLfloat specular[] = { 1.0, 1.0, 1.0, 1.0 };
   GLfloat shininess[] = {25.0 };
   GLfloat position[] = {1.0,1.0,1.0,0.0};
   arguments(argc,argv); 
   deFault(); 
srand(13);
 
       glutInit(&argc, argv);
       glutInitDisplayMode(GLUT_DOUBLE|GLUT_DEPTH);
       switch(win){ 
           case 0: break;  /* manage your own window */
           case 1: glutInitWindowSize(600, 600);
                   glutInitWindowPosition(100,100); break;
           case 2: glutInitWindowPosition(0,0); break;
         }
       glutCreateWindow("4-Dimensional Tic-Tac-Toe");
       if(win==2) glutFullScreen();
/*glMaterialfv(GL_FRONT, GL_SPECULAR, specular);*/
glMaterialfv(GL_FRONT, GL_SHININESS, shininess);
glLightfv(GL_LIGHT0, GL_POSITION, position);
#if 0
glEnable(GL_LIGHTING);
glEnable(GL_LIGHT0);
glEnable(GL_COLOR_MATERIAL);
glColorMaterial ( GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE);
#endif
       glEnable(GL_DEPTH_TEST);
       glutDisplayFunc(drawcons);       
       glutKeyboardFunc(keyboard);
       glutSpecialFunc(special_keybo);
       glutMouseFunc(mousepushed);
       glutMotionFunc(mousemoved);       
       glutPassiveMotionFunc(mousemoved); 
       glutReshapeFunc(reshaped);
       glutIdleFunc(idle);             
       glutMainLoop();
}
