/***************************************/
/*             Jorgenson's Article	    			*/
/*  								*/
/*      Craig Davis Project for Math 428, change to glut libraries and OpenGL */
/*      30/11/98, based on Paul McCreary's RTICA. Uses noosh of   */
/*      Francis, Chappell and Hartman as basic framework.                                                        
/*                                                                   */  
/* 12/4/95 changed all parameters of isoCircsData to be centered at origin */
/* Nov 6, 1995	added continuous parameter to matrix		*/
/* Oct 25, 1995							*/
/* March 5, 1996  added shift capability to Farey curves	*/	
/* Paul R. McCreary, Dept of Mathematics, UIUC, all rights etc. */

/* (C) 1995 Board of Trustees Unversity of Illinois */
/* e-mail paulmcc@math.uiuc.edu	*/
/************************************************************************/ 
/*****   Notes
	The scene begins with three pairs of isometric circles belonging to three
members of the infinite cyclic group generated by a certain loxodromic Moebius transformation.
The two by two matrix associated with this transformation is displayed in the upper right of 
the screen.  

*****************************************************************************************/      


#include <stdlib.h>
#include <stdio.h>
/* #include <device.h> */
#include <math.h>
#include <sys/timeb.h>
#include <malloc.h>
#include <gl/glut.h>
#include <windows.h>


#define  MAX(x,y)       (((x)<(y))?(y):(x))
#define  MIN(x,y)       (((x)<(y))?(x):(y))
#define  ABS(x)         (((x)<0)?-(x):(x))
#define  FOR(a,b,c)     for((a)=(b);(a)<(c);(a)++)
#define  DOT(p,q)    ((p)[0]*(q)[0]+(p)[1]*(q)[1]+(p)[2]*(q)[2])
#define  NRM(p)      sqrt(DOT((p),(p)))

#define  GETS(pt1,pt2)  FOR(inx,0,3){pt1[inx]=pt2[inx];}
#define  GETS2D(pt1,pt2)  FOR(inx,0,2){pt1[inx]=pt2[inx];}

/* global variables*/
char which[20]; /* audio needs this */
float id[16]={1.,0.,0.,0.,0.,1.,0.,0.,0.,0.,1.,0.,0.,0.,0.,1.};
int soundinter;
float lux[3]={1.,2.,3.};  /*light source direction vector */
float mysiz, speed, torq, focal,wfar;        /*notCAVE navigation variables */
float where=0;
int win = 1;  /* 0 on demand, 1 fixed screen, 2 is full  */
int xt,yt;                       /* once was xt,yt,xm,ym for viewportery */
int opaque;                      /* see through spheres  */
int caveyes=0;   
                   /* rename? ----------> caveflag */
unsigned int BUT,XX,YY,SHIF;     /* used in chaptrack gluttery */
int steer; /* disable mouse input */
int morph;



/*******************************
	Quick Fixx
**********************************/
#define  PNTN 500
float   trMMMM[3], trMMM[3], deMMMM[3], deMMM[3], origin[3],
	fareyPnts[PNTN][3],fareyCurve[PNTN][57][3],SingledCurve[200][3],
	radds[PNTN],centts[PNTN], traceMarker[3], offCent[3], fac1=.01, fac2=.1,
	point1[3],point2[3],fCurves[PNTN][57][3],
	ddddelt=.5,dddddelt=.1;
int ddd, flag1, flag2=1,odx,ody,wigl,memReq,inx,FareyFrac[100][2],
	sss, d1, veryThickWidth=5, fInx, disc,pp1[3],pp2[3],
	mmm1,nnn1,nnn2,nnn3,nnn4,nnn5,fareySequenceLength, maxFareyDenom,
	FFInx[PNTN],rowEndFlag=10000, movTrac,bigArc,m9,m10,m11,m12,
	SIList[500],cardOfSIList,
	mmmm,nnnn,inxx[4];
/* marking cube variables *****************************/
#define NC 400

float    cube[NC][2][4][3]; 

float   cuRad=.03;
float   center[NC][3];
/*****************************************************/

/****************************************
**************************************/
/****************************************
**************************************/

#define FLYMODE (1)
#define COMMANDMODE (0) /* COMMANDMODE must be last -- we use it for mod'ing */

#define  Nose     (CAVEConfig -> HalfInterocularDistance)

/*Shared memory variables as per Stuart Levy 1994 */  
struct share_var{ 
   float  s_siz;      /*final scaling factor before projection */  
   GLfloat s_aff[16];      /*affine modelling matrix for drawn object */
   GLfloat s_aff2[16];      /*affine modelling matrix for drawn object */
   GLfloat s_star[16];     /*affine modelling matrix for the stars*/
   float  s_lu[4];    /*direction of light source in calculite() */ 
   int s_mode;        /*CAVE mode */
   int s_msg ;        /*message flag */ 
   int s_wnd;         /*wand or maus flag */
   int s_gnd;         /*background colore */
   int s_prntCol;     /*print colore */
   int s_paw ;        /*binary for button state */
   int s_maus[2];     /*maus position */
  } ;

struct share_var  *s_var; 

#define  siz     (s_var->s_siz)  
#define  aff     (s_var->s_aff)
#define  aff2     (s_var->s_aff2)
#define  starmat (s_var->s_star)
#define  lu      (s_var->s_lu)
#define  mode    (s_var->s_mode)
#define  siz     (s_var->s_siz)
#define  msg     (s_var->s_msg)
#define  wnd     (s_var->s_wnd)
#define  gnd     (s_var->s_gnd)
#define  prntCol     (s_var->s_prntCol)
#define mauspaw  (s_var->s_paw)
#define mausx    (s_var->s_maus[0])
#define mausy    (s_var->s_maus[1])

/*************** Old, but necessary **********************************/

#define NL 20  /* number of lunes */
#define NA 50  /* number of latitude circles */
#define NO 2  /* number of loxodromic arcs */
#define NAP 57   /* number of points on each arc */
#define NH  8   /* number of circles in the hyperbolic pencil */
#define NIA 21  /* # of segments in isosphere circles */
#define X 0	/* x-coordinate or auxiliary "type" of frame or still */
#define Y 1
#define Z 2
#define A 0
#define B 1
#define C 2
#define D 3
#define Pi 3.1415926 

struct share_tor{
float s_sphere[10][NA][NA][3],
	s_frameLune[NL][NA][NAP][3], s_isoSphere[2][100][NA][NA][3],
	s_frameAxis[NL][NAP][3],s_mat[100][4][3],s_fineIsoSphere[2][100][NA][NA][3],
	s_lune[NL][NA][NAP][3], s_axes[NL][NAP][3],s_unitDisc[NAP][3],
	s_isoCircle[2][100][NAP][3],s_isoCirData[2][100][4],s_intPnt[4][100][100][3];
float s_matriks[4][3],s_mmm[4][3],
	s_shift[3];
float s_cf[100][4][3];     	
float s_fixedPnts[100][2][3], s_one[3],s_eye[3],s_negEye[3],s_negOne[3],s_two[3];
float s_twist, s_multiplierK;
int s_cMax,s_isoSpheres,s_axx,s_fine,s_inf,s_lim,s_rho,s_cen,s_rhM;
int s_band,s_lastLune,s_mov,s_www,s_sss,s_stopSpin,s_isoCirNum,s_maxCirInx,
	s_secCirInx,s_thirCirInx,s_poly,s_inxs[100];   
int s_DtP, s_PtD, s_tTr, s_tTrI,s_thinWidth,s_thickWidth;
float s_col[400][4];
}
countMemoryReq(){
}

struct share_tor  *s_tor; 
#define  sphere		(s_tor->s_sphere)
#define  frameLune     (s_tor->s_frameLune)
#define  isoSphere     (s_tor->s_isoSphere)
#define  frameAxis     (s_tor->s_frameAxis)
#define  mat     (s_tor->s_mat)
#define  fineIsoSphere     (s_tor->s_fineIsoSphere)
#define  lune     (s_tor->s_lune)
#define  axes	(s_tor->s_axes)
#define  unitDisc	(s_tor->s_unitDisc)
#define  isoCircle	(s_tor->s_isoCircle)
#define  isoCirData	(s_tor->s_isoCirData)
#define  intPnt	(s_tor->s_intPnt)
#define  matriks	(s_tor->s_matriks)
#define  mmm	(s_tor->s_mmm)
#define  shift	(s_tor->s_shift)
#define  cf     (s_tor->s_cf)
#define  fixedPnts     (s_tor->s_fixedPnts)
#define  theta     (s_tor->s_theta)
#define  one	(s_tor->s_one)
#define  eye	(s_tor->s_eye)
#define  negEye	(s_tor->s_negEye)
#define  negOne	(s_tor->s_negOne)
#define  two	(s_tor->s_two)
#define  twist	(s_tor->s_twist)
#define  multiplierK	(s_tor->s_multiplierK)
#define  cMax     (s_tor->s_cMax)
#define  isoSpheres     (s_tor->s_isoSpheres)
#define  axx     (s_tor->s_axx)
#define  fine     (s_tor->s_fine)
#define  inf     (s_tor->s_inf)
#define  lim     (s_tor->s_lim)
#define  rho     (s_tor->s_rho)
#define  cen     (s_tor->s_cen)
#define  rhM     (s_tor->s_rhM)
#define  band     (s_tor->s_band)
#define  lastLune     (s_tor->s_lastLune)
#define  mov     (s_tor->s_mov)
#define  www     (s_tor->s_www)
#define  sss     (s_tor->s_sss)
#define  stopSpin     (s_tor->s_stopSpin)
#define  isoCirNum     (s_tor->s_isoCirNum)
#define  maxCirInx     (s_tor->s_maxCirInx)
#define  secCirInx     (s_tor->s_secCirInx)
#define  thirCirInx     (s_tor->s_thirCirInx)
#define  poly     (s_tor->s_poly)
#define  inxs     (s_tor->s_inxs)
#define  DtP     (s_tor->s_DtP)
#define  PtD     (s_tor->s_PtD)
#define  tTr     (s_tor->s_tTr)
#define  tTrI     (s_tor->s_tTrI)
#define  thinWidth     (s_tor->s_thinWidth)
#define  thickWidth     (s_tor->s_thickWidth)
#define  col            (s_tor->s_col)

/* these are used only in console mode      */
int binoc;    /* flag                       */
float nose;   /* to eye distance in console */


void getmem(void)  /* allocate shared memory */ 
{
if(caveyes)
#ifdef CAVE
    s_var = CAVEMalloc(sizeof(struct share_var))
#endif 
      ;
else
  s_var = malloc(sizeof(struct share_var));
  s_tor = malloc(sizeof(struct share_tor));

  if(s_var==0 || s_tor==0){fprintf(stderr,"No room to share! %x\n",s_var); exit(1);}
}

/* The cube drawing routines are left over from the earlier code */
void createCube(int m){
        int t=1, b=0, k, l;

        for(k=0;k<4;k++){
                cube[m][t][k][Z]=cuRad + center[m][Z] + 2;
                cube[m][b][k][Z]=center[m][Z]-cuRad + 2;
        }
        for(k=0;k<2;k++){
                for(l=0;l<2;l++){
                        cube[m][l][k][Y]=center[m][Y]-cuRad;
                        cube[m][l][k+2][Y]=center[m][Y]+cuRad;
                        cube[m][l][k+2][Y]=center[m][Y]+cuRad;
                }
        }
                        cube[m][0][0][X]=center[m][X]-cuRad;
                        cube[m][0][1][X]=center[m][X]+cuRad;
                        cube[m][0][2][X]=center[m][X]+cuRad;
                        cube[m][0][3][X]=center[m][X]-cuRad;
                        cube[m][1][0][X]=center[m][X]-cuRad;
                        cube[m][1][1][X]=center[m][X]+cuRad;
                        cube[m][1][2][X]=center[m][X]+cuRad;
                        cube[m][1][3][X]=center[m][X]-cuRad;

}

void drawCube(int m){       
      int t=1, b=0, k;
      if (m == 200 ){   /* This creates the yellow marker box  */
                     glColor4fv(col[m]);
                     glBegin(GL_TRIANGLE_STRIP);
                     glVertex2f(center[m][X],center[m][Y]);
                     glVertex2f(center[m][X] + fac2,center[m][Y]);
                     glVertex2f(center[m][X],center[m][Y]+fac2);
                     glVertex2f(center[m][X]+ fac2,center[m][Y] + fac2);
                     glEnd();}
   else{
  
        glColor4fv(col[m]); 
        glBegin(GL_TRIANGLE_STRIP);
        glVertex3fv(cube[m][t][2]);
        glVertex3fv(cube[m][t][3]);
        glVertex3fv(cube[m][t][1]);
        for(k=0;k<4;k++){
              glVertex3fv(cube[m][t][k]);
              glVertex3fv(cube[m][b][k]);}
        glVertex3fv(cube[m][t][0]);
        glVertex3fv(cube[m][b][0]);
        glVertex3fv(cube[m][b][1]);
        glVertex3fv(cube[m][b][2]);
        glVertex3fv(cube[m][b][3]);
        glEnd();}
}



/*****************************************************************/
/*******  COMPLEX ARITHMETIC  ************************************/
/*****************************************************************/

add(float rp[3], float p1[3], float p2[3]){
	rp[X]=p1[X]+p2[X];
	rp[Y]=p1[Y]+p2[Y];
}
sub(float rp[3], float p1[3], float p2[3]){
	rp[X]=p1[X]-p2[X];
	rp[Y]=p1[Y]-p2[Y];
}
mul(float rp[3], float p1[3], float p2[3]){
	rp[X]=p1[X]*p2[X]-p1[Y]*p2[Y];
	rp[Y]=p1[X]*p2[Y]+p1[Y]*p2[X];	
}
cdiv(float rp[3], float p1[3], float p2[3]){
	rp[X]=(p1[X]*p2[X]+p1[Y]*p2[Y])/(p2[X]*p2[X]+p2[Y]*p2[Y]);
	rp[Y]=(-p1[X]*p2[Y]+p1[Y]*p2[X])/(p2[X]*p2[X]+p2[Y]*p2[Y]);	
}
cnj(float rp[3], float p1[3])/*float rp[3], p1[3];*/{
	rp[X]=p1[X];
	rp[Y]=-p1[Y];
}
float absValue2D(pt)float pt[3];{
        return (pow(pow(pt[X],2)+pow(pt[Y],2),.5));
}
sqr(float rp[3], float p1[3]){
	float r, thet;
	r=pow(absValue2D(p1),.5);
        if(p1[Y]>0) thet=acos(p1[X]/absValue2D(p1));
        else thet=2*Pi-acos(p1[X]/absValue2D(p1));
	rp[X]=r*cos(thet/2);
	rp[Y]=r*sin(thet/2);		
}	
slide(float resPnt[3], float pnt[3], float transPnt[3]){
	int i;
	FOR(i,0,3){
		resPnt[i]=pnt[i] + transPnt[i];
	}
}
/**CAEnd*****************************************************************
************************************************************************/



/************** Spherical Geometry subroutines *************************/
/***********************************************************************/

rotateT(float resultPt[3], float point[3], float angle){
        float initialAngle, r;
        r=absValue2D(point);
        if(r!=0){
                if(point[Y]>0) initialAngle=acos(point[X]/r);
                else initialAngle=2*Pi-acos(point[X]/r);
                resultPt[X]=r*cos(angle+initialAngle);
                resultPt[Y]=r*sin(angle+initialAngle);
                resultPt[Z]=point[Z];
        }
        else 	GETS(resultPt,point);
}
/***SGEnd*****************************************************************/
/*************************************************************************/

/********	Fixed Point Computation   	**************************/
/*************************************************************************/

normalizeMatrix(float matt[4][3]){
	int i,j;
	float detS[3], temp[4][3], mm[4][3];
	mul(temp[0],matt[A],matt[D]);
	mul(temp[1],matt[B],matt[C]);
	sub(temp[2],temp[0],temp[1]);
	sqr(detS,temp[2]);
	if(detS[X]!=0 || detS[Y]!=0){
		FOR(i,0,4){
			cdiv(mm[i],matt[i],detS);
			GETS(matt[i],mm[i]);
		}
	}
}
fixedPoints(int nn,float matt[4][3]){/* matrix already normalized */
	int i,j;
	float temp[5][3];
	sub(temp[0],matt[A],matt[D]);/*t0=(a-d)*/
	add(temp[1],matt[A],matt[D]);/*t1=(a+d)*/
	mul(temp[2],temp[1],temp[1]);/*t2=(a+d)^2*/
	temp[3][X]=4;temp[3][Y]=0;temp[3][Z]=0;/*t3=4*/
	sub(temp[1],temp[2],temp[3]);/*t1=(a+d)^2-4*/
	sqr(temp[2],temp[1]);/*t2=SQRT[(a+d)^2-4]*/
	temp[1][X]=2;temp[1][Y]=0;temp[1][Z]=0;/*t1=2*/
	mul(temp[3],temp[1],matt[C]);/* t3=2c */
	add(temp[4],temp[0],temp[2]);
	cdiv(fixedPnts[nn][0],temp[4],temp[3]);/* div by 2c */
	sub(temp[4],temp[0],temp[2]);
	cdiv(fixedPnts[nn][1],temp[4],temp[3]);/* div by 2c */
}

/* Drawing the IsoSpheres, Hlight lights the spheres. */

float* Hlight(int inx,float lmb){ 
	int rr,gg,bb; float spec; float tempCol[4];
	float amb= .33, pwr= 32.; int  brt=255;
       
	tempCol[X]=col[inx][X];tempCol[Y]=col[inx][Y];tempCol[Z]=col[inx][Z];

    lmb = MAX(lmb,amb);
    spec=brt*( 1. - pwr + pwr*lmb); 
    tempCol[X] = MAX(lmb*tempCol[X], spec);
    tempCol[Y] = MAX(lmb*tempCol[Y], spec);
    tempCol[Z] = MAX(lmb*tempCol[Z], spec);
    if(opaque) {tempCol[3] = .5;}
      else {tempCol[3] = 1;}

    return(tempCol);
}

drawIsoSphere(int nn,int ww){
	int i,j, k;
	float den, nnnn[3], aa[3], vo[3], vv[3],lmb;
        
		FOR(i,0,NIA-1){
			if((i-((int)i/2)*2==0) || (isoSpheres==2 || isoSpheres==3)){
				glBegin(GL_TRIANGLE_STRIP);
                		FOR(j,0,NIA-1){
                                  GETS(vo,isoSphere[nn][ww][j][i]);
                                  GETS(aa,isoSphere[nn][ww][j][i+1]);
                                  GETS(vv,isoSphere[nn][ww][j+1][i+1]);
                                  nnnn[0]=(aa[1]-vo[1])*(vv[2]-vo[2])-(aa[2]-vo[2])*(vv[1]-vo[1]);
                                  nnnn[1]=(aa[2]-vo[2])*(vv[0]-vo[0])-(aa[0]-vo[0])*(vv[2]-vo[2]);
                                  nnnn[2]=(aa[0]-vo[0])*(vv[1]-vo[1])-(aa[1]-vo[1])*(vv[0]-vo[0]);
                                  den = sqrt(nnnn[0]*nnnn[0]+nnnn[1]*nnnn[1]+nnnn[2]*nnnn[2]);
                                  lmb = (lu[0]*nnnn[0]+lu[1]*nnnn[1]+lu[2]*nnnn[2])/den;
                                  if(lmb<.0)lmb *= -1;
                                  glColor4fv(Hlight(ww,lmb)); 				
                                  glVertex3fv(isoSphere[nn][ww][j][i]);
                                  glVertex3fv(isoSphere[nn][ww][j][i+1]);
				}
				glEnd();
			}
		}
}

constructUnitDisc(){
	int i, j, k;
	FOR(i,0,NAP){
		unitDisc[i][X]=cos(2*Pi*i/(NAP-1));
		unitDisc[i][Y]=sin(2*Pi*i/(NAP-1));
		unitDisc[i][Z]=0;
	}
}

defineMatrices(){
	int ii, jj;

	tTr=99;
	tTrI=98;
	PtD=50;
	GETS(cf[PtD][A],eye);
	GETS(cf[PtD][B],one);
	GETS(cf[PtD][C],one);
	GETS(cf[PtD][D],eye);
	/**/normalizeMatrix(cf[PtD]);/**/
	FOR(ii,0,4){GETS(mmm[ii],cf[PtD][ii]);}

	DtP=51;
	FOR(ii,0,4){GETS(cf[51][ii],cf[50][ii]);}
	FOR(ii,0,3){cf[DtP][B][ii]*=(-1);cf[DtP][C][ii]*=(-1);}

}
multMatrix(float res[4][3],float m1[4][3],float m2[4][3]){
	float temp[4][3];
	mul(temp[0],m1[A],m2[A]);
	mul(temp[1],m1[B],m2[C]);
	add(res[A],temp[0],temp[1]);
	mul(temp[0],m1[A],m2[B]);
	mul(temp[1],m1[B],m2[D]);
	add(res[B],temp[0],temp[1]);
	mul(temp[0],m1[C],m2[A]);
	mul(temp[1],m1[D],m2[C]);
	add(res[C],temp[0],temp[1]);
	mul(temp[0],m1[C],m2[B]);
	mul(temp[1],m1[D],m2[D]);
	add(res[D],temp[0],temp[1]);
}
defineMatrix(int nn){
	float temp[4][3];
	mat[nn][A][X]=1;mat[nn][A][Y]=0;mat[nn][A][Z]=0;
	mat[nn][B][X]=-fixedPnts[nn][1][X];mat[nn][B][Y]=-fixedPnts[nn][1][Y];mat[nn][B][Z]=0;
	mat[nn][C][X]=1;mat[nn][C][Y]=0;mat[nn][C][Z]=0;
	mat[nn][D][X]=-fixedPnts[nn][0][X];mat[nn][D][Y]=-fixedPnts[nn][0][Y];mat[nn][D][Z]=0;
	normalizeMatrix(mat[nn]);

	mat[nn][A][X]=-fixedPnts[nn][0][X];mat[nn][A][Y]=-fixedPnts[nn][0][Y];mat[nn][A][Z]=0;
	mat[nn][B][X]=+fixedPnts[nn][1][X];mat[nn][B][Y]=+fixedPnts[nn][1][Y];mat[nn][B][Z]=0;
	mat[nn][C][X]=-1;mat[nn][C][Y]=0;mat[nn][C][Z]=0;
	mat[nn][D][X]=1;mat[nn][D][Y]=0;mat[nn][D][Z]=0;
	normalizeMatrix(mat[nn]);
}
/*************************************************************************/
/*************** animation subroutines ***********************************/
/*************************************************************************/
void convexCombOf(float rPt[3], float pt1[3], float pt2[3], float convFac){
	rPt[X]=pt1[X] + convFac*(pt2[X] - pt1[X]);
	rPt[Y]=pt1[Y] + convFac*(pt2[Y] - pt1[Y]);
        rPt[Z]=pt1[Z] + convFac*(pt2[Z] - pt1[Z]);
        
}
void sceneHomotopy(int whichLune, int iS, int fS, float cvF){	}movie(){}
/***ANIMEnd*****************************************************************/
/***************************************************************************/
void reSet(){
	int ii, jj, kk;
	binoc=1;isoSpheres=2;poly=0;
	axx=0;
	traceMarker[X]=.3;traceMarker[Y]=.6;
	nnn1=0;mmm1=0;
	m9=1;m10=0;m11=1;m12=2;
	ddddelt=.5;dddddelt=.1;
}
deFault(){
	float a, b, c, d, f1, f2, f12, f22 ;
	int i, j, k,rr,bb,gg;
        int tempCol;
	float denom,a2, b2, c2, d2,denom2;

	/****** illishell's general variables initialized ******/
	int ii; float tmp;

	/*************** make see through ******************/
	
          glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);  
  	gnd = 0;  prntCol=0xffffffff;  mauspaw = 0; wnd = 1; 
   	mode=COMMANDMODE;
        origin[X] = origin[Y] = origin[Z] = 0;  
        opaque =  1; 
   	speed=.10; mysiz=.01;  siz=1;steer=1;torq = .01;focal = 2.; fac2=.1; 
   	FOR(ii,0,16) starmat[ii]=aff[ii]=aff2[ii]=id[ii];
   	tmp=NRM(lux);
   	FOR(ii,0,3)lux[ii]/=tmp;
#ifdef CAVE
   aff[8]= 0.; aff[9]= 5.; aff[10]= -10.;/*5ft beyond front wall*/
   aff2[8]= 0.; aff2[9]= 5.; aff2[10]= -10.;/*5ft beyond front wall*/
#else /*notCAVE*/
   aff[8]= 0.; aff[9]= 0.; aff[10]= -4.2; /*why not there ?!*/
   aff2[8]= 0.; aff2[9]= 0.; aff2[10]= -4.2; /*why not there ?! */
   msg=1; binoc=1; nose=.06;
#endif  /* CAVE */



aff[0]=-0.374917;aff[1]=-0.921074;aff[2]=0.105164;aff[3]=0;
aff[4]=-0.924876;aff[5]=0.379399;aff[6]=0.0256991;aff[7]=0;
aff[8]=-0.06357;aff[9]=-0.0876292;aff[10]=-0.994122;aff[11]=0;
aff[12]=0;aff[13]=0;aff[14]=-4.2;aff[15]=1;

	/***** this application's variables initialized ********/
	multiplierK=1/.9;traceMarker[X]=1;traceMarker[Y]=1;traceMarker[Z]=0;movTrac=1;
 	poly=1;isoSpheres=2; opaque=1; axx=0;
	twist=2*Pi/6;lastLune=NL-1;thickWidth=3; thinWidth=1; 
	cMax=50; /* win=2; */ rho=1;
	one[X]=1; mov=1;www=1;eye[Y]=1; negEye[Y]=-1; negOne[X]=-1;negOne[Y]=0;
        negOne[Z]=0; two[X]=2;    

	shift[X]=0;shift[Y]=0;shift[Z]=0;

col[0][X] = 1.0;col[0][Y] = 0.0;col[0][Z] = 0.0;
col[1][X] = 0.0;col[1][Y] = 1.0;col[1][Z] = 0.0;
col[2][X] = 1.0;col[2][Y] = 1.0;col[2][Z] = 0.0;
col[3][X] = 0.0;col[3][Y] = 0.0;col[3][Z] = 1.0;
col[4][X] = 1.0;col[4][Y] = 0.0;col[4][Z] = 1.0;
col[5][X] = 0.0;col[5][Y] = 1.0;col[5][Z] = 1.0;
col[6][X] = 1.0;col[6][Y] = 1.0;col[6][Z] = 1.0;
col[7][X] = 0.7;col[7][Y] = 0.1;col[7][Z] = 0.1;
col[8][X] = 0.1;col[8][Y] = 0.7;col[8][Z] = 0.1;
col[9][X] = 0.7;col[9][Y] = 0.7;col[9][Z] = 0.1;
col[10][X] = 0.1;col[10][Y] = 0.1;col[10][Z] = 0.7;
col[11][X] = 0.7;col[11][Y] = 0.1;col[11][Z] = 0.7;
col[12][X] = 0.1;col[12][Y] = 0.7;col[12][Z] = 0.7;
col[13][X] = 0.7;col[13][Y] = 0.7;col[13][Z] = 0.7;
col[14][X] = 0.5;col[14][Y] = 0.1;col[14][Z] = 0.1;
col[15][X] = 0.1;col[15][Y] = 0.5;col[15][Z] = 0.1;
col[16][X] = 0.5;col[16][Y] = 0.5;col[16][Z] = 0.1;
col[17][X] = 0.1;col[17][Y] = 0.1;col[17][Z] = 0.5;
col[18][X] = 0.5;col[18][Y] = 0.1;col[18][Z] = 0.5;
col[19][X] = 0.1;col[19][Y] = 0.5;col[19][Z] = 0.5;
col[20][X] = 0.5;col[20][Y] = 0.5;col[20][Z] = 0.5;
col[21][X] = 0.25;col[21][Y] = 0.1;col[21][Z] = 0.1;
col[22][X] = 0.1;col[22][Y] = 0.25;col[22][Z] = 0.1;
col[23][X] = 0.25;col[23][Y] = 0.25;col[23][Z] = 0.1;
col[24][X] = 0.1;col[24][Y] = 0.1;col[24][Z] = 0.5;
col[25][X] = 0.25;col[25][Y] = 0.1;col[25][Z] = 0.25;
col[26][X] = 0.1;col[26][Y] = 0.25;col[26][Z] = 0.25;
col[27][X] = 0.25;col[27][Y] = 0.25;col[27][Z] = 0.25;
FOR(ii,0,400){col[ii][3] = 1;}
FOR(ii,28,400){col[ii][X] = col[ii - 28][X];col[ii][Y]= col[ii - 28][Y];col[ii][Z] = col[ii -28][Z];}
col[200][X] = 1;col[200][Y] = 1;col[200][Z] = 0;

reSet();
}



calculite()    /*Move the moon to shine steadily on a rotating object */
{
int ii,jj;
   FOR(ii,0,3)
      {
      lu[ii]=0;
      FOR(jj,0,3) lu[ii] += aff[ii*4 + jj]*lux[jj];
      }
}



drawall() /* Objects other than stars and messages */ 
{  
   drawit();   
}
drawall2() /* Objects other than stars and messages */ 
{int ii;
	  drawCube(200); 
   drawFareyDisc(); 
}




void audioprep(void){
#ifdef SOUND
   if (!FBgnSoundServer())
      fprintf(stderr,"UDP connection to sound server failed\n");
   else if ((audiohandle = AUDinit("noosh.aud")) == -1)
      fprintf(stderr,"Couldn't open noosh.aud\n");
#endif
}

void dohoot(void) {strcpy(which,"hoot");}
void dotrump(void){strcpy(which,"trump");}
void doflute(void){strcpy(which,"flute");}
void dodrum(void) {strcpy(which,"drum");}

void audiofunc(void){
#ifdef SOUND 
#define LIRP(X,A,B,x,a,b)  (X = A + (x-a)*(B-A)/(b-a))
  static float freq=440., ampl=1., indx=20., cmra=2.; 
  static float data[4];
  static omode =0; static ofocal = 0;
  static beep =0;  /* the sound server */

  if(omode > mode){dohoot(); beep = 1;}
  if(omode < mode){dodrum(); beep = 1;}

  LIRP(freq, 440, 1760, th0,  10, 170); /* frequeny mimics th1 */ 
  LIRP(indx, 10, 1,  focal, .03, 2.0); /* index  mimics focal */ 
  if(ofocal != focal){dodrum(); beep = 1;}    /* there is an fp bug here */

if(beep){data[0] = freq;  /* pitch in Herz      */ 
          data[1] = ampl;  /* the sum of all amplitudes must be < 1.0 */ 
          data[2] = indx;    
          data[3] = cmra;
          AUDupdate(audiohandle, which, 4, data);  /* send message  to vss */ 
          beep = 0; 
}
  omode = mode;  ofocal = focal; 
#endif
}

void audioclean(void){
#ifdef SOUND
   AUDterminate(audiohandle);
   EndSoundServer();
#endif
}




void drawstars(void){     
int i;
static float star[1000][3];
static int virgin=1;
if(virgin){
  int ii,jj;
  float fact;
  virgin=0;
  for(ii=0;ii<1000;ii++)
     {
     for(jj=0;jj<3;jj++) star[ii][jj] =   rand()/(float)0x40000000-1.;
     if(caveyes){
           fact = 90./NRM(star[ii]);
           for(jj=0;jj<3;jj++) star[ii][jj] *= fact;
           }   
     }
  }
  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();
  glMultMatrixf(starmat);
  glColor3f(1.0,1.0,0.0);    
  glBegin(GL_POINTS);
    for(i=0;i<1000;i++) glVertex3fv(star[i]);
  glEnd();
  glPopMatrix();
  glClear(GL_DEPTH_BUFFER_BIT);
}



arguments(int argc,char **argv){
#if 0
  extern char *optarg;
  extern int optind;
  int chi;
  /* w: needs ONE number after -w, c<nothing> means NO number follows*/
  while ((chi = getopt(argc,argv,"w:cd:g:")) != -1)
  switch(chi)  {case 'c': caveyes=1; break;
                case 'w': win=atoi(optarg); break;
                }
  if (optind!=argc) fprintf(stderr,"%s: Incorrect usage\n",argv[0]);
#endif
}

void dataprep(void){
   audioprep();
       deFault();reSet();
	defineMatrices();
	constructUnitDisc();
	constructIsometricCircles();
	computeFareyCurves();
	newMatrix();
}

void char2wall(GLfloat x,GLfloat y, GLfloat z, char buf[]){
     char *p; glRasterPos3f(x,y,z);
     for(p = buf;*p;p++) glutBitmapCharacter(GLUT_BITMAP_9_BY_15,*p);
}

cleanup(){}autotymer(){  }/*end autotymer*/

eraseOldFareyFracts(){
	int ii;
	FOR(ii,0,fareySequenceLength){
		GETS2D(FareyFrac[ii],origin);
	}
}
computeFareyFracts(int nn){
	int i, j, k, rowLength, thisInx;
	int lastRow[100][2];
	eraseOldFareyFracts();
	lastRow[0][X]=1;lastRow[0][Y]=1;
	lastRow[1][X]=1;lastRow[1][Y]=2;
	lastRow[2][X]=0;lastRow[2][Y]=1;
	rowLength=3;
	/**/FOR(i,0,nn-2){
		thisInx=0;
		FOR(j,0,rowLength-1){
			if(lastRow[j][Y]+lastRow[j+1][Y]<=nn){
				FareyFrac[thisInx][X]=lastRow[j][X];
				FareyFrac[thisInx][Y]=lastRow[j][Y];
				FareyFrac[thisInx+1][X]=lastRow[j][X]+lastRow[j+1][X];
				FareyFrac[thisInx+1][Y]=lastRow[j][Y]+lastRow[j+1][Y];
				thisInx+=2;
			}
			else {
				FareyFrac[thisInx][X]=lastRow[j][X];	
				FareyFrac[thisInx][Y]=lastRow[j][Y];
				thisInx++;
			}
		}
		FareyFrac[thisInx][X]=0;FareyFrac[thisInx][Y]=1;
		rowLength=thisInx+1;
		FOR(j,0,rowLength){
			lastRow[j][X]=FareyFrac[j][X];
			lastRow[j][Y]=FareyFrac[j][Y];
		}
	}/**/
	fareySequenceLength=rowLength;
	maxFareyDenom=nn;
	placePointsOnInterval();
}

FindNthRowMthPointArc(int nn, int mm){
	int i, ii, j, k, rowLength, thisInx;
	int lastRow[100][2];
	float cent1, radi;
        float temp[3]={0,0,0};

	eraseOldFareyFracts();
	lastRow[0][X]=1;lastRow[0][Y]=1;
	lastRow[1][X]=1;lastRow[1][Y]=2;
	lastRow[2][X]=0;lastRow[2][Y]=1;
	rowLength=3;
	/**/FOR(i,0,nn-2){
		thisInx=0;
		FOR(j,0,rowLength-1){
			if(lastRow[j][Y]+lastRow[j+1][Y]<=nn){
				FareyFrac[thisInx][X]=lastRow[j][X];
				FareyFrac[thisInx][Y]=lastRow[j][Y];
				FareyFrac[thisInx+1][X]=lastRow[j][X]+lastRow[j+1][X];
				FareyFrac[thisInx+1][Y]=lastRow[j][Y]+lastRow[j+1][Y];
				thisInx+=2;
			}
			else {
				FareyFrac[thisInx][X]=lastRow[j][X];	
				FareyFrac[thisInx][Y]=lastRow[j][Y];
				thisInx++;
			}
		}
		FareyFrac[thisInx][X]=0;FareyFrac[thisInx][Y]=1;
		rowLength=thisInx+1;
		FOR(j,0,rowLength){
			lastRow[j][X]=FareyFrac[j][X];
			lastRow[j][Y]=FareyFrac[j][Y];
		}
	}/**/
	GETS(pp1,FareyFrac[mm]);GETS(pp2,FareyFrac[mm+1]);
	if(nn==1){
		pp1[X]=1;pp1[Y]=1;pp1[Z]=0;
		pp2[X]=0;pp2[Y]=1;pp2[Z]=0;
	}
	if(nn==2){
		if(mm==0){
			pp1[X]=1;pp1[Y]=1;pp1[Z]=0;
			pp2[X]=1;pp2[Y]=2;pp2[Z]=0;
		}
		if(mm==1){
			pp1[X]=1;pp1[Y]=2;pp1[Z]=0;
			pp2[X]=0;pp2[Y]=1;pp2[Z]=0;
		}
	}
	point1[X]=2*cos(Pi*(float)pp1[X]/pp1[Y]);
	point2[X]=2*cos(Pi*(float)pp2[X]/pp2[Y]);
	cent1=(point2[X]+point1[X])/2;
      	radi=(point2[X]-point1[X])/2;
       	FOR(ii,0,NAP){
       		SingledCurve[ii][X]=radi*cos(Pi*(float)ii/(NAP-1))+cent1;
       		SingledCurve[ii][Y]=radi*sin(Pi*(float)ii/(NAP-1));
       	}
}
findFirstFareyFracts(int *resInx, int nn, int mm){
	int ii, jj, kk;
	/**//**/
	ii=0;
	while(((FareyFrac[ii][Y]!=nn && FareyFrac[ii][Y]!=mm) || FareyFrac[ii+1][Y]!=nn+mm) 
				&&
			ii<fareySequenceLength		){
		ii++; 
	}
	if(ii==fareySequenceLength) *resInx=ii;
	else *resInx=0;
}
findNextFareyFracts(int *resInx, int nn, int mm, int kk){
	int ii, jj;
	/**//**/
	ii=kk;
	while(((FareyFrac[ii][Y]!=nn && FareyFrac[ii][Y]!=mm) || FareyFrac[ii+1][Y]!=nn+mm) 
				&&
			ii<fareySequenceLength		){
		ii++; 
	}
	if(ii<fareySequenceLength) *resInx=ii;
	else *resInx=rowEndFlag;
}
placePointsOnInterval(){
	int ii, jj, kk;
	FOR(ii,0,fareySequenceLength){
		fareyPnts[ii][X]=2*cos(Pi*(float)FareyFrac[ii][X]/FareyFrac[ii][Y]);
	}
}
cCos(float res[3], float pnt[3]){
	float temp[3]={0,0,0}, temp2[3]={0,0,0};
	res[X]=(exp(-Pi*pnt[Y])*cos(Pi*pnt[X])+exp(Pi*pnt[Y])*cos(-Pi*pnt[X]));
	res[Y]=(exp(-Pi*pnt[Y])*sin(Pi*pnt[X])+exp(Pi*pnt[Y])*sin(-Pi*pnt[X]));
	res[Z]=0;
}
labelPointsOnInterval(){
	int ii, jj;
	cuRad=.02;
	FOR(ii,0,fareySequenceLength){
		GETS(center[ii],fareyPnts[ii]);createCube(ii);
	}
}
computeFareyCurves(){
	int ii, jj=0, kk, ll, nn=1, mm=1, maxDenom=8;
	float cent1, cent2, cent3, radi, radii, radiii,fp0,fp1,fp2,temp[3]={0,0,0};
/**/	FOR(ii,0,NAP){
		fareyCurve[0][ii][X]=2*cos(Pi*(float)ii/(NAP-1));
		fareyCurve[0][ii][Y]=2*sin(Pi*(float)ii/(NAP-1));
		fareyCurve[1][ii][X]=cos(Pi*(float)ii/(NAP-1))-1;
		fareyCurve[1][ii][Y]=sin(Pi*(float)ii/(NAP-1));
		fareyCurve[2][ii][X]=cos(Pi*(float)ii/(NAP-1))+1;
		fareyCurve[2][ii][Y]=sin(Pi*(float)ii/(NAP-1));
	}
	fInx=3;
	FOR(ll,3, maxDenom+1){
		computeFareyFracts(ll);
		nn=1;mm=ll-nn;	/** Initialize nn & mm **/
		while(nn<mm){
		   kk=0;jj=0;
		   while(jj!=rowEndFlag && fInx<PNTN-1){
			findNextFareyFracts(&jj, nn, mm, kk);
			kk=jj+1;
			cent1=(fareyPnts[jj+1][X]+fareyPnts[jj][X])/2;
/*qwe*/		       	cent2=(fareyPnts[jj+2][X]+fareyPnts[jj+1][X])/2;
		       	radi=(fareyPnts[jj+1][X]-fareyPnts[jj][X])/2;
		       	radii=(fareyPnts[jj+2][X]-fareyPnts[jj+1][X])/2;
		       	centts[fInx]=cent1;centts[fInx+1]=cent2;
		       	radds[fInx]=radi;radds[fInx+1]=radii;
		       	FOR(ii,0,NAP){
		       		fareyCurve[fInx][ii][X]=radi*cos(Pi*(float)ii/(NAP-1))+cent1;
		       		fareyCurve[fInx][ii][Y]=radi*sin(Pi*(float)ii/(NAP-1));
		       		fareyCurve[fInx+1][ii][X]=radii*cos(Pi*(float)ii/(NAP-1))+cent2;
		       		fareyCurve[fInx+1][ii][Y]=radii*sin(Pi*(float)ii/(NAP-1));
		       	}
/*****************************************
			fp0=(float)FareyFrac[jj][X]/FareyFrac[jj][Y];
			fp1=(float)FareyFrac[jj+1][X]/FareyFrac[jj+1][Y];
			fp2=(float)FareyFrac[jj+2][X]/FareyFrac[jj+2][Y];
			cent1=(fp1+fp0)/2;
		       	cent2=(fp2+fp1)/2;
		       	radi=(fp1-fp0)/2;
		       	radii=(fp2-fp1)/2;
		       	centts[fInx]=cent1;centts[fInx+1]=cent2;
		       	radds[fInx]=radi;radds[fInx+1]=radii;
		       	FOR(ii,0,NAP){
		       		temp[X]=radi*cos(Pi*(float)ii/(NAP-1))+cent1;
		       		temp[Y]=radi*sin(Pi*(float)ii/(NAP-1));
				cCos(fCurves[fInx][ii],temp);
		       		temp[X]=radii*cos(Pi*(float)ii/(NAP-1))+cent2;
		       		temp[Y]=radii*sin(Pi*(float)ii/(NAP-1));
				cCos(fCurves[fInx+1][ii],temp);
		       	}
/************************************/
		   	fInx+=2;	
		   }
		   nn++;mm--;
		}
	}
/**//**jj:=10000 when findNextFareyFracts() hits end of row**/
}
computeFareyCurves2(){
	int ii, jj, kk, ll, nn=1, mm=1;
	float cent1, cent2, cent3, radi, radii, radiii;
	placePointsOnInterval();
/**/	FOR(ii,0,NAP){
		fareyCurve[0][ii][X]=2*cos(Pi*(float)ii/(NAP-1));
		fareyCurve[0][ii][Y]=2*sin(Pi*(float)ii/(NAP-1));
		fareyCurve[1][ii][X]=cos(Pi*(float)ii/(NAP-1))-1;
		fareyCurve[1][ii][Y]=sin(Pi*(float)ii/(NAP-1));
		fareyCurve[2][ii][X]=cos(Pi*(float)ii/(NAP-1))+1;
		fareyCurve[2][ii][Y]=sin(Pi*(float)ii/(NAP-1));
	}
	nn=1;
	mm=2;
	fInx=3;
	jj=1;kk=0;
	while(nn<(int)maxFareyDenom/2){
		while(nn+mm<=maxFareyDenom){
		   while(jj!=0 && fInx<PNTN-1){
			findNextFareyFracts(&jj, nn, mm, kk);
			kk=jj+1;
			if(jj!=0){
				cent1=(fareyPnts[jj+1][X]+fareyPnts[jj][X])/2;
				cent2=(fareyPnts[jj+2][X]+fareyPnts[jj][X+1])/2;
				radi=(fareyPnts[jj+1][X]-fareyPnts[jj][X])/2;
				radii=(fareyPnts[jj+2][X]-fareyPnts[jj][X+1])/2;
				FOR(ii,0,NAP){
					fareyCurve[fInx][ii][X]=radi*cos(Pi*(float)ii/(NAP-1))+cent1;
					fareyCurve[fInx][ii][Y]=radi*sin(Pi*(float)ii/(NAP-1));
					fareyCurve[fInx+1][ii][X]=radii*cos(Pi*(float)ii/(NAP-1))+cent2;
					fareyCurve[fInx+1][ii][Y]=radii*sin(Pi*(float)ii/(NAP-1));
				}
				fInx+=2;
			}
			
		   }
		   mm++;jj=1;kk=0;
		}
		nn++;
		if((maxFareyDenom)%(2)==0) mm=nn;
		else mm=nn+1;
	}
/**//**jj:=0 when findNextFareyFracts() hits end of row**/
}

/* pE(resultPoint,(x,y,t),(a,b,c,d)): Poincare extension of the mobius transformation,
*****             (az + b)/(cz + d), where a, b, c, & d are all complex
*****Summary: a point {x,y,t} goes to {Re[pE(x,y,t)],Im[pE(x,y,t)],J[pE(x,y,t)]}*/
/***cf[10][4][3]*/
void pE(float rp[3], float pnt[3], float c[4][3]){
	float zz[3]={0,0,0},t,
			t1[3]={1,1,1},t2[3]={1,1,1},t3[3]={1,1,1},t4[3]={1,1,1},
			denominator;
	GETS2D(zz,pnt);t=pnt[Z];
	mul(t1,c[C],zz);/* c*z */
	add(t2,t1,c[D]);/* c*z + d */
	cnj(t4,t2); /* conj(c*z + d) SAVE for numerator*/
	mul(t1,t2,t4);/* |c*z + d|^2 SAVE for denom */

	cnj(t2,c[C]);/* conj(c) */
	mul(t3,c[C],t2); /* |c|^2 */

	denominator = t1[X] + t3[X]*t*t;
		/* END COMPUTATION SECTION, but save t4 */

	mul(t1,c[A],c[D]);
	mul(t2,c[B],c[C]);
	sub(t3,t1,t2);/* (ad-bc) */
	cnj(t1,t3);
	mul(t2,t3,t1);/* |ad-bc|^2 */

	rp[Z] = pow(t2[X],.5)*t/denominator;
		/* END COMPUTATION (j COMPONENT)*/

	/********** complex component  ************************/
	mul(t1,c[A],zz);/* az */
	add(t2,t1,c[B]);/* az+b */
	mul(t3,t2,t4);/*t4 from above->(az+b)*conj(cz+d)*/
	cnj(t1,c[C]);
	mul(t2,c[A],t1);/* a*conj(c) */
	/* t2=a*conj(c), t3=az+b)*conj(cz+d) */
	rp[X] = (t3[X] + t2[X]*t*t)/denominator;
	rp[Y] = (t3[Y] + t2[Y]*t*t)/denominator;
} 
determineListOfFaces(){
	int ii, jj, yy1=0, yy0=0, yy2=0, yy3=0;
	float pnts[2][3], dist;
	secCirInx=50;	
	thirCirInx=50;
	FOR(ii,0,25){SIList[ii]=500;}
	cardOfSIList=0;
	FOR(ii,0,10){
		if(ii!=maxCirInx){
			pointsOfIntersection(pnts,0,maxCirInx,0,ii);
			if(pnts[0][X]<1000){/**add to SIList **/
				SIList[cardOfSIList]=ii;
				cardOfSIList++;
			}
			else {
				pointsOfIntersection(pnts,0,maxCirInx,1,ii);
				if(pnts[0][X]<1000){/**add to SIList **/
					SIList[cardOfSIList]=ii;
					cardOfSIList++;
				}
			}
		}
	}
	FOR(ii,0,cardOfSIList){
		yy1=0;yy0=0;yy2=0;yy3=0;
		pointsOfIntersection(pnts,0,maxCirInx,0,SIList[ii]);
		FOR(jj,0,cardOfSIList){
		    	if(ii!=jj && SIList[jj]<500 && pnts[0][X]<100){/* not self and not up against an already
							disqualified circle*****/
				
	    			if(/** test for the first intersection point being hidden w/i one or the 
						other of the two jjth circles **/
     					pow(pow(pnts[0][X]-isoCirData[0][SIList[jj]][X],2)+
						pow(pnts[0][Y]-isoCirData[0][SIList[jj]][Y],2),.5)<isoCirData[0][SIList[jj]][D]
						||
					pow(pow(pnts[0][X]-isoCirData[1][SIList[jj]][X],2)+
						pow(pnts[0][Y]-isoCirData[1][SIList[jj]][Y],2),.5)<isoCirData[0][SIList[jj]][D]){
			
					/** if it does, say YES! **/
					yy0=1;
				}/** else leave yy0==0 **/
			      /** now test the second point **/
	    			if(/** if the first intersection points lie w/i the first or the second circle 
						then check for the second intersection point **/
     					pow(pow(pnts[1][X]-isoCirData[0][SIList[jj]][X],2)+
						pow(pnts[1][Y]-isoCirData[0][SIList[jj]][Y],2),.5)<isoCirData[0][SIList[jj]][D]
						||
					pow(pow(pnts[1][X]-isoCirData[1][SIList[jj]][X],2)+
						pow(pnts[1][Y]-isoCirData[1][SIList[jj]][Y],2),.5)<isoCirData[0][SIList[jj]][D]){
			
					/** if it does, say YES! **/
					yy1=1;
				}/** else leave yy1==0 **/
		    	}
		}
		if((yy0==1 && yy1==1) || pnts[0][X]>100){/**then check the intersection points of circle with
			the OTHER max circle **/
			pointsOfIntersection(pnts,1,maxCirInx,0,SIList[ii]);

			FOR(jj,0,cardOfSIList){
		    		if(ii!=jj && SIList[jj]<500 && pnts[0][X]<100){/* not self, not up against an already
							disqualified circle, and there IS intersection*****/
				
	    				if(/** test for the first intersection point being hidden w/i one or the 
						other of the two jjth circles **/
     						pow(pow(pnts[0][X]-isoCirData[0][SIList[jj]][X],2)+
							pow(pnts[0][Y]-isoCirData[0][SIList[jj]][Y],2),.5)<isoCirData[0][SIList[jj]][D]
							||
						pow(pow(pnts[0][X]-isoCirData[1][SIList[jj]][X],2)+
							pow(pnts[0][Y]-isoCirData[1][SIList[jj]][Y],2),.5)<isoCirData[0][SIList[jj]][D]){
			
						/** if it does, say YES! **/
						yy2=1;
					}/** else leave yy2==0 **/
				      /** now test the second point **/
	    				if(/** if the first intersection points lie w/i the first or the second circle 
						then check for the second intersection point **/
     						pow(pow(pnts[1][X]-isoCirData[0][SIList[jj]][X],2)+
							pow(pnts[1][Y]-isoCirData[0][SIList[jj]][Y],2),.5)<isoCirData[0][SIList[jj]][D]
							||
						pow(pow(pnts[1][X]-isoCirData[1][SIList[jj]][X],2)+
							pow(pnts[1][Y]-isoCirData[1][SIList[jj]][Y],2),.5)<isoCirData[0][SIList[jj]][D]){
			
						/** if it does, say YES! **/
						yy3=1;
					}/** else leave yy3==0 **/
		    		}
			}
			if((yy2==1 && yy3==1) || pnts[0][X]>100){/** i.e. if there was NO intersection **/
				SIList[ii]=500;
			}/**mark iith off list 
				if both intersection points are hidden w/i other circles **/
		}
		/** else leave it be **/
	}
	/**/ii=0;
	while(SIList[ii]==500){ii++;}
	secCirInx=SIList[ii];ii++;	
	while(SIList[ii]==500){ii++;}
	thirCirInx=SIList[ii];	
	/**/
}
determineListOfFaces2(){
	int ii, jj, yy1=0, yy0=0, yy2=0, yy3=0;
	float pnts[2][3], dist;
	cardOfSIList=0;
	FOR(ii,0,10){
		if(ii!=maxCirInx){
			pointsOfIntersection(pnts,0,maxCirInx,0,ii);
			if(pnts[0][X]<1000){/**add to SIList **/
				SIList[cardOfSIList]=ii;
				cardOfSIList++;
			}
			else {
				pointsOfIntersection(pnts,0,maxCirInx,1,ii);
				if(pnts[0][X]<1000){/**add to SIList **/
					SIList[cardOfSIList]=ii;
					cardOfSIList++;
				}
			}
		}
	}
	FOR(ii,0,cardOfSIList){
		yy1=0;yy0=0;yy2=0;yy3=0;
		pointsOfIntersection(pnts,0,maxCirInx,0,SIList[ii]);
		FOR(jj,0,cardOfSIList){
		    	if(ii!=jj && SIList[jj]<500 && pnts[0][X]<100){/* not self and not up against an already
							disqualified circle*****/
				
	    			if(/** test for the first intersection point being hidden w/i one or the 
						other of the two jjth circles **/
     					pow(pow(pnts[0][X]-isoCirData[0][SIList[jj]][X],2)+
						pow(pnts[0][Y]-isoCirData[0][SIList[jj]][Y],2),.5)<isoCirData[0][SIList[jj]][D]
						||
					pow(pow(pnts[0][X]-isoCirData[1][SIList[jj]][X],2)+
						pow(pnts[0][Y]-isoCirData[1][SIList[jj]][Y],2),.5)<isoCirData[0][SIList[jj]][D]){
			
					/** if it does, say YES! **/
					yy0=1;
				}/** else leave yy0==0 **/
			      /** now test the second point **/
	    			if(/** if the first intersection points lie w/i the first or the second circle 
						then check for the second intersection point **/
     					pow(pow(pnts[1][X]-isoCirData[0][SIList[jj]][X],2)+
						pow(pnts[1][Y]-isoCirData[0][SIList[jj]][Y],2),.5)<isoCirData[0][SIList[jj]][D]
						||
					pow(pow(pnts[1][X]-isoCirData[1][SIList[jj]][X],2)+
						pow(pnts[1][Y]-isoCirData[1][SIList[jj]][Y],2),.5)<isoCirData[0][SIList[jj]][D]){
			
					/** if it does, say YES! **/
					yy1=1;
				}/** else leave yy1==0 **/
		    	}
		}
		if((yy0==1 && yy1==1) || pnts[0][X]>100){/**then check the intersection points of circle with
			the OTHER max circle **/
			pointsOfIntersection(pnts,1,maxCirInx,0,SIList[ii]);

			FOR(jj,0,cardOfSIList){
		    		if(ii!=jj && SIList[jj]<500 && pnts[0][X]<100){/* not self, not up against an already
							disqualified circle, and there IS intersection*****/
				
	    				if(/** test for the first intersection point being hidden w/i one or the 
						other of the two jjth circles **/
     						pow(pow(pnts[0][X]-isoCirData[0][SIList[jj]][X],2)+
							pow(pnts[0][Y]-isoCirData[0][SIList[jj]][Y],2),.5)<isoCirData[0][SIList[jj]][D]
							||
						pow(pow(pnts[0][X]-isoCirData[1][SIList[jj]][X],2)+
							pow(pnts[0][Y]-isoCirData[1][SIList[jj]][Y],2),.5)<isoCirData[0][SIList[jj]][D]){
			
						/** if it does, say YES! **/
						yy2=1;
					}/** else leave yy2==0 **/
				      /** now test the second point **/
	    				if(/** if the first intersection points lie w/i the first or the second circle 
						then check for the second intersection point **/
     						pow(pow(pnts[1][X]-isoCirData[0][SIList[jj]][X],2)+
							pow(pnts[1][Y]-isoCirData[0][SIList[jj]][Y],2),.5)<isoCirData[0][SIList[jj]][D]
							||
						pow(pow(pnts[1][X]-isoCirData[1][SIList[jj]][X],2)+
							pow(pnts[1][Y]-isoCirData[1][SIList[jj]][Y],2),.5)<isoCirData[0][SIList[jj]][D]){
			
						/** if it does, say YES! **/
						yy3=1;
					}/** else leave yy3==0 **/
		    		}
			}
			if((yy2==1 && yy3==1) || pnts[0][X]>100){/** i.e. if there was NO intersection **/
				SIList[ii]=500;
			}/**mark iith off list 
				if both intersection points are hidden w/i other circles **/
		}
		/** else leave it be **/
	}
	ii=0;
	while(SIList[ii]==500){ii++;}	
	secCirInx=ii;ii++;	
	while(SIList[ii]==500){ii++;}
	thirCirInx=ii;	
}
thing1(){
	int ii, jj;
	float pnts[2][3];
	cardOfSIList=0;
	FOR(ii,0,10){
		if(ii!=maxCirInx){
			pointsOfIntersection(pnts,0,maxCirInx,0,ii);
			if(pnts[0][X]<1000){/**add to SIList **/
				SIList[cardOfSIList]=ii;
				cardOfSIList++;
			}
			else {
				pointsOfIntersection(pnts,0,maxCirInx,1,ii);
				if(pnts[0][X]<1000){/**add to SIList **/
					SIList[cardOfSIList]=ii;
					cardOfSIList++;
				}
			}
		}
	}
}
thing2(){
	int ii, jj, kk, yy1=0, yy0=0, yy2=0, yy3=0,test1=0;
	float pnts[2][3], dist;
	FOR(ii,0,cardOfSIList){
		yy1=0;yy0=0;yy2=0;yy3=0;
		pointsOfIntersection(pnts,0,maxCirInx,0,SIList[ii]);
		FOR(jj,0,cardOfSIList){
		    	if(ii!=jj && SIList[jj]<500 && pnts[0][X]<100){/* not self and not up against an already
							disqualified circle*****/
				
	    			if(/** test for the first intersection point being hidden w/i one or the 
						other of the two jjth circles **/
     					pow(pow(pnts[0][X]-isoCirData[0][SIList[jj]][X],2)+
						pow(pnts[0][Y]-isoCirData[0][SIList[jj]][Y],2),.5)<isoCirData[0][SIList[jj]][D]
						||
					pow(pow(pnts[0][X]-isoCirData[1][SIList[jj]][X],2)+
						pow(pnts[0][Y]-isoCirData[1][SIList[jj]][Y],2),.5)<isoCirData[0][SIList[jj]][D]){
			
					/** if it does, say YES! **/
					yy0=1;
				}/** else leave yy0==0 **/
			      /** now test the second point **/
	    			if(/** if the first intersection points lie w/i the first or the second circle 
						then check for the second intersection point **/
     					pow(pow(pnts[1][X]-isoCirData[0][SIList[jj]][X],2)+
						pow(pnts[1][Y]-isoCirData[0][SIList[jj]][Y],2),.5)<isoCirData[0][SIList[jj]][D]
						||
					pow(pow(pnts[1][X]-isoCirData[1][SIList[jj]][X],2)+
						pow(pnts[1][Y]-isoCirData[1][SIList[jj]][Y],2),.5)<isoCirData[0][SIList[jj]][D]){
			
					/** if it does, say YES! **/
					yy1=1;
				}/** else leave yy1==0 **/
		    	}
		}
		if((yy0==1 && yy1==1) || pnts[0][X]>100){/**then check the intersection points of circle with
			the OTHER max circle **/
			pointsOfIntersection(pnts,1,maxCirInx,0,SIList[ii]);

			FOR(jj,0,cardOfSIList){
		    		if(ii!=jj && SIList[jj]<500 && pnts[0][X]<100){/* not self, not up against an already
							disqualified circle, and there IS intersection*****/
				
	    				if(/** test for the first intersection point being hidden w/i one or the 
						other of the two jjth circles **/
     						pow(pow(pnts[0][X]-isoCirData[0][SIList[jj]][X],2)+
							pow(pnts[0][Y]-isoCirData[0][SIList[jj]][Y],2),.5)<isoCirData[0][SIList[jj]][D]
							||
						pow(pow(pnts[0][X]-isoCirData[1][SIList[jj]][X],2)+
							pow(pnts[0][Y]-isoCirData[1][SIList[jj]][Y],2),.5)<isoCirData[0][SIList[jj]][D]){
			
						/** if it does, say YES! **/
						yy2=1;
					}/** else leave yy2==0 **/
				      /** now test the second point **/
	    				if(/** if the first intersection points lie w/i the first or the second circle 
						then check for the second intersection point **/
     						pow(pow(pnts[1][X]-isoCirData[0][SIList[jj]][X],2)+
							pow(pnts[1][Y]-isoCirData[0][SIList[jj]][Y],2),.5)<isoCirData[0][SIList[jj]][D]
							||
						pow(pow(pnts[1][X]-isoCirData[1][SIList[jj]][X],2)+
							pow(pnts[1][Y]-isoCirData[1][SIList[jj]][Y],2),.5)<isoCirData[0][SIList[jj]][D]){
			
						/** if it does, say YES! **/
						yy3=1;
					}/** else leave yy3==0 **/
		    		}
			}
			if((yy2==1 && yy3==1) || pnts[0][X]>100){/** i.e. if there was NO intersection **/
				SIList[ii]=500;
			}/**mark iith off list 
				if both intersection points are hidden w/i other circles **/
		}
		/** else leave it be **/

	}		
}
binSearch(){
	int ii, jj;
	float delt, tMark[3], fP[3], sP[3], ddelt;
	delt=.5;ddelt=.1;
	while((delt>.000001 || delt<-.000001) && ddelt>.000000001){
		markAllPointsOfIntersection(m9, m10);
		GETS(fP,center[mmmm]);
		markAllPointsOfIntersection(m11, m12);
		GETS(sP,center[nnnn]);
		delt=pow(pow(fP[X],2)+pow(fP[Y],2),.5)-pow(pow(sP[X],2)+pow(sP[Y],2),.5);
		if(delt<0){traceMarker[Y]+=ddelt;}
		else {traceMarker[Y]-=ddelt;}
		ddelt/=2;
		newMatrix();constructIsometricCircles();
		GETS(center[200],traceMarker);createCube(200);
	}
}
thing(){
	int ii, jj;
	float fP[3], sP[3]; 
		markAllPointsOfIntersection(m9, m10);
		GETS(fP,center[mmmm]);
	GETS(center[101],center[mmmm]);createCube(101);
		markAllPointsOfIntersection(m11, m12);
		GETS(sP,center[nnnn]);
	GETS(center[102],center[nnnn]);createCube(102);
		ddddelt=pow(pow(fP[X],2)+pow(fP[Y],2),.5)-pow(pow(sP[X],2)+pow(sP[Y],2),.5);
		if(ddddelt<0){traceMarker[Y]+=dddddelt;}
		else {traceMarker[Y]-=dddddelt;}
		dddddelt/=2;
		newMatrix();constructIsometricCircles();
		GETS(center[200],traceMarker);createCube(200);

}
markAllPointsOfIntersection(int ff, int ss){
	int ii, jj, kk;
	float temp[2][3];
	FOR(ii,0,2){GETS(temp[ii],origin);}
	pointsOfIntersection(temp,0,ff,0,ss);
	GETS(center[0],temp[0]);
	GETS(center[1],temp[1]);
	pointsOfIntersection(temp,1,ff,0,ss);
	GETS(center[2],temp[0]);
	GETS(center[3],temp[1]);
	pointsOfIntersection(temp,0,ff,1,ss);
	GETS(center[4],temp[0]);
	GETS(center[5],temp[1]);
	pointsOfIntersection(temp,1,ff,1,ss);
	GETS(center[6],temp[0]);
	GETS(center[7],temp[1]);
	cuRad=.1;
	FOR(ii,0,8){
		createCube(ii);
	}
}
pointsOfIntersection(float iP[2][3],int ii,int mm,int jj,int nn){
    		 /**of isoCirc[ii][mm] & isoCirc[jj][nn] **//** non intersection results in
							iP[0][X] being assigned a LARGE # **/
	int i, j, k;
	float temp[8][3], cent[2][3], rad[2], thet, tInt[3];
	FOR(i,0,8){GETS(temp[i],origin);}FOR(i,0,2){GETS(cent[i],origin);}
	GETS(tInt,origin);
	GETS(cent[0],isoCirData[ii][mm]);GETS(cent[1],isoCirData[jj][nn]);	
	rad[0]=isoCirData[ii][mm][D];rad[1]=isoCirData[jj][nn][D];
	/** translate to origin **/
	sub(temp[1],cent[1],cent[0]);

	if(pow(temp[1][X]*temp[1][X]+temp[1][Y]*temp[1][Y],.5)<rad[0]+rad[1]){

		/** rotate onto positive x-axis **/
		if(temp[1][Y]>=0){thet=acos(temp[1][X]/pow(pow(temp[1][X],2)+pow(temp[1][Y],2),.5));}	
		else {thet=2*Pi-acos(temp[1][X]/pow(pow(temp[1][X],2)+pow(temp[1][Y],2),.5));}	
		cent[1][X]=pow(pow(temp[1][X],2)+pow(temp[1][Y],2),.5);cent[1][Y]=0;
		tInt[X]=(rad[0]*rad[0]-rad[1]*rad[1]+cent[1][X]*cent[1][X])/(2*cent[1][X]);
		tInt[Y]=pow(rad[0]*rad[0]-tInt[X]*tInt[X],.5);
		rotateT(temp[0],tInt,thet);
		tInt[Y]*=(-1);
		rotateT(temp[1],tInt,thet);
		FOR(i,0,2){
			FOR(j,0,3){
				temp[i][j]+=isoCirData[ii][mm][j];
			}
		}
		GETS(iP[0],temp[0]);GETS(iP[1],temp[1]);
	}
	else { iP[0][X]=1000000000;}/**no intersection flag**/

}
determineWhichCircles(){
	int i, j, k, tt, nt, tt2, nt2, numTempInx=0, secCirFnd=0, thirCirFnd=0,
		tempI[100];
	float tempRad, dist1, dist2, tempIPs[8][3], tTempIPs[2][3];
	FOR(i,0,8){GETS(tempIPs[i],origin);}FOR(i,0,2){GETS(tTempIPs[i],origin);}
	inxs[99]=0;
	maxCirInx=0;
	/**Determine index of isoCir with MAX rad!!!!!!!!!!!!!! **/
	FOR(i,1,isoCirNum){
		if(isoCirData[0][maxCirInx][D]<isoCirData[0][i][D]){
			maxCirInx=i;
		}
	}
	/**/constructIsometricSpheres();/*Temporarily disconnect iso spheres */
}
determineWhichCircles2(){
	int i, j, k, tt, nt, tt2, nt2, numTempInx=0, secCirFnd=0, thirCirFnd=0,
		tempI[100];
	float tempRad, dist1, dist2, tempIPs[8][3], tTempIPs[2][3];
	FOR(i,0,8){GETS(tempIPs[i],origin);}FOR(i,0,2){GETS(tTempIPs[i],origin);}
	inxs[99]=0;
	maxCirInx=0;
	/**Determine index of isoCir with MAX rad!!!!!!!!!!!!!! **/
	FOR(i,1,isoCirNum){
		if(isoCirData[0][maxCirInx][D]<isoCirData[0][i][D]){
			maxCirInx=i;
		}
	}
	/** determine theta of vector isoCirData[0][maxCirInx] **/
	GETS(center[100],isoCirData[0][maxCirInx]);cuRad=.1;createCube(100);
	/** Find isoCirc which has the intersection point with max Circ that has largest modulus **/
	if(maxCirInx!=0) secCirInx=0;
	else secCirInx=1;
	FOR(i,0,isoCirNum){
		if(i!=maxCirInx){
			if((isoCirData[0][i][D])>=isoCirData[0][secCirInx][D]){
				secCirInx=i;
			}
		}
	}
	/** Find isoCirc which has the third largest rad!!!!!!!!!!!!!!!!!!!!!!!! **/
	if(maxCirInx!=0 && secCirInx!=0) thirCirInx=0;
	else {
		if(maxCirInx!=1 && secCirInx!=1) thirCirInx=1;
		else thirCirInx=2;
	}
	FOR(i,0,isoCirNum){
		if(i!=maxCirInx && i!=secCirInx){
			if((isoCirData[0][i][D])>=isoCirData[0][thirCirInx][D]){
				thirCirInx=i;
			}
		}
	}
	/**/constructIsometricSpheres();/*Temporarily disconnect iso spheres */
}
axisBtwn(float arcPts[NAP][3],float pt1[3],float pt2[3]){
	int i, j, k;
	float temp[4][3], thet, dist, rad, ee=.00001;
	FOR(i,0,4){GETS(temp[i],origin);}
	sub(temp[0],pt2,pt1);
	dist=pow(pow(temp[0][X],2)+pow(temp[0][Y],2),.5);
	if(temp[0][Y]>0){thet=acos(temp[0][X]/dist);}
	else {thet=2*Pi-acos(temp[0][X]/dist);}
	rad=dist/2;
	temp[2][X]=rad;
	FOR(i,0,NAP){
		arcPts[i][X]=rad*cos(Pi-ee-Pi*(float)i/(NAP-1)*(1-2*ee));
		arcPts[i][Z]=rad*sin(Pi-ee-Pi*(float)i/(NAP-1)*(1-2*ee));
		arcPts[i][Y]=0;
		slide(temp[1],arcPts[i],temp[2]);
		rotateT(temp[3],temp[1],thet);
		slide(arcPts[i],temp[3],pt1);
	}
}
sphereIntersections(){
	int i, j, k;
	float tempRad, dist1, dist2, tempIPs[8][3], tTempIPs[2][3];
	FOR(i,0,8){GETS(tempIPs[i],origin);}FOR(i,0,2){GETS(tTempIPs[i],origin);}

	pointsOfIntersection(tTempIPs,0,maxCirInx,0,secCirInx);	
	axisBtwn(axes[0],tTempIPs[0],tTempIPs[1]);
	pointsOfIntersection(tTempIPs,0,maxCirInx,0,thirCirInx);	
	axisBtwn(axes[1],tTempIPs[0],tTempIPs[1]);
	pointsOfIntersection(tTempIPs,0,thirCirInx,1,secCirInx);	
	axisBtwn(axes[2],tTempIPs[0],tTempIPs[1]);
	pointsOfIntersection(tTempIPs,1,secCirInx,1,maxCirInx);	
	axisBtwn(axes[3],tTempIPs[0],tTempIPs[1]);
	pointsOfIntersection(tTempIPs,1,maxCirInx,1,thirCirInx);	
	axisBtwn(axes[4],tTempIPs[0],tTempIPs[1]);
	pointsOfIntersection(tTempIPs,1,thirCirInx,0,secCirInx);	
	axisBtwn(axes[5],tTempIPs[0],tTempIPs[1]);

	pointsOfIntersection(tTempIPs,1,secCirInx,1,thirCirInx);	
	axisBtwn(axes[6],tTempIPs[0],tTempIPs[1]);
	pointsOfIntersection(tTempIPs,1,secCirInx,0,secCirInx);	
	axisBtwn(axes[7],tTempIPs[0],tTempIPs[1]);
	pointsOfIntersection(tTempIPs,0,secCirInx,0,thirCirInx);	
	axisBtwn(axes[8],tTempIPs[0],tTempIPs[1]);

	pointsOfIntersection(tTempIPs,1,thirCirInx,0,thirCirInx);	
	axisBtwn(axes[9],tTempIPs[0],tTempIPs[1]);
	pointsOfIntersection(tTempIPs,1,maxCirInx,0,maxCirInx);	
	axisBtwn(axes[10],tTempIPs[0],tTempIPs[1]);

	pointsOfIntersection(tTempIPs,0,maxCirInx,1,secCirInx);	
	axisBtwn(axes[11],tTempIPs[0],tTempIPs[1]);
	pointsOfIntersection(tTempIPs,1,maxCirInx,0,secCirInx);	
	axisBtwn(axes[12],tTempIPs[0],tTempIPs[1]);

}
constructIsometricSpheres(){
	int ii, jj, kk, ll;
	float rad, cent[3], ee=.00001;
	cent[Z]=0;
	FOR(ii,0,NIA){
		FOR(jj,0,NIA){
			FOR(kk,0,10){
				FOR(ll,0,2){

			rad=isoCirData[ll][kk][D];
			GETS(cent,isoCirData[ll][kk]);
	isoSphere[ll][kk][ii][jj][X]=rad*sin(.5*Pi*((float)ii/(NIA-1)*(1-2*ee) + ee))*cos(2*Pi*jj/(NIA-1)) + cent[X];
	isoSphere[ll][kk][ii][jj][Y]=rad*sin(.5*Pi*((float)ii/(NIA-1)*(1-2*ee) + ee))*sin(2*Pi*jj/(NIA-1)) + cent[Y];
	isoSphere[ll][kk][ii][jj][Z]=rad*cos(.5*Pi*((float)ii/(NIA-1)*(1-2*ee) + ee));
				}
			}
		}
	}
	sphereIntersections();	
}
constructIsometricCircles(){/** offCent is added directly to isoCircData **/
	int i, j, k;
	float rad, cent[3], ee=.001,temp[4][3], tt[4][3],alpha, tMatt[4][3],tempMat[4][3],
		tC1[3]={0,0,0},tC2[3]={0,0,0},tMp[3]={0,0,0};
	cent[Z]=0;FOR(i,0,4){GETS(tMatt[i],origin);GETS(temp[i],origin);
			GETS(tt[i],origin);GETS(tempMat[i],origin);}

	isoCirNum=10; 
	rad=1/pow(pow(matriks[C][X],2)+pow(matriks[C][Y],2),.5);
	cdiv(tC1,matriks[D],matriks[C]);
	tC1[X]*=(-1);tC1[Y]*=(-1);
	cdiv(tC2,matriks[A],matriks[C]);
	add(tMp,tC1,tC2);
	cdiv(offCent,tMp,two);
	sub(isoCirData[0][0],tC1,offCent);
	isoCirData[0][0][D]=rad;
	sub(isoCirData[1][0],tC2,offCent);
	isoCirData[1][0][D]=rad;
	FOR(i,0,NAP){
		isoCircle[0][0][i][X]=rad*cos(2*Pi*i/(NAP-1)) + isoCirData[0][0][X];
		isoCircle[0][0][i][Y]=rad*sin(2*Pi*i/(NAP-1)) + isoCirData[0][0][Y];
		isoCircle[0][0][i][Z]=0;   
		mul(isoCircle[1][0][i],isoCircle[0][0][i],negOne);
	}
	FOR(j,0,4){GETS(temp[j],matriks[j]);}
	FOR(i,1,isoCirNum){
		multMatrix(tMatt,temp,matriks);
		rad=1/pow(pow(tMatt[C][X],2)+pow(tMatt[C][Y],2),.5);
		cdiv(tC1,tMatt[D],tMatt[C]);
		tC1[X]*=(-1);tC1[Y]*=(-1);
		cdiv(tC2,tMatt[A],tMatt[C]);
		sub(isoCirData[0][i],tC1,offCent);
		isoCirData[0][i][D]=rad;
		sub(isoCirData[1][i],tC2,offCent);
		isoCirData[1][i][D]=rad;
		FOR(j,0,NAP){
			isoCircle[0][i][j][X]=rad*cos(2*Pi*j/(NAP-1)) + isoCirData[0][i][X];
			isoCircle[0][i][j][Y]=rad*sin(2*Pi*j/(NAP-1)) + isoCirData[0][i][Y];
			isoCircle[0][i][j][Z]=0;   
			mul(isoCircle[1][i][j],isoCircle[0][i][j],negOne);
		}
		FOR(j,0,4){GETS(temp[j],tMatt[j]);}
	}

	/**/determineWhichCircles();/**/

}
newMatrix(){
	int ii, jj, kk, nn;
	float xx[3], temp[4][3], four[3]={4,0,0};
	FOR(ii,0,4){GETS(temp[ii],origin);}

	mul(temp[0],traceMarker,traceMarker);/** temp[0]==Tr^2 **/
GETS(mmm[0],temp[0]);
	sub(temp[1],temp[0],four);/** temp[1]==Tr^2-4 **/
GETS(mmm[1],temp[1]);
	sqr(temp[3],temp[1]);/** temp[3]==Sqrt(Tr^2-4) **/
GETS(mmm[2],temp[3]);
	mul(temp[2],traceMarker,temp[3]);/** temp[2]==Tr*Sqrt(Tr^2-4) **/
GETS(mmm[3],temp[2]);
	sub(temp[3],temp[0],two);/** temp[3]==Tr^2-2) **/
	add(temp[1],temp[3],temp[2]);/** temp[1]==Tr^2-2+Tr*Sqrt(Tr^2-4) **/
	cdiv(temp[0],temp[1],two);
	/** temp[0] == K * E^(i theta) **/

	temp[A][Z]=0;
	temp[B][X]=0;temp[B][Y]=0;temp[B][Z]=0;
	temp[C][X]=1;temp[C][Y]=0;temp[C][Z]=0;
	temp[D][X]=1;temp[D][Y]=0;temp[D][Z]=0;
	normalizeMatrix(temp);
	/**/FOR(ii,0,4){GETS(mmm[ii],temp[ii]);}/**/
	determinate(3,mmm);
	add(trMMM,mmm[A],mmm[D]);
	/**/FOR(ii,0,4){GETS(matriks[ii],temp[ii]);}/**/


}
determinate(int m, float mm[4][3]){
	float temp[4][3];
	mul(temp[0],mm[A],mm[D]);	
	mul(temp[1],mm[B],mm[C]);	
	if(m==4) sub(deMMMM,temp[0],temp[1]);
	else sub(deMMM,temp[0],temp[1]);
}
void newCoefficients(int whichOne,float fix1[3], float fix2[3], float multiplier[3]){  
	int n;
	float mu[3], imu[3], t1[3], t2[3], t3[3];
	sqr(mu,multiplier); /* mu = SQRT(K) */
	cdiv(imu,one,mu);
	n=whichOne;
	mul(t1,fix1,mu);
	mul(t2,fix2,imu);
	sub(cf[n][A],t1,t2);
	sub(t1,imu,mu);
	mul(t2,fix1,t1);
	mul(cf[n][B],fix2,t2);
	sub(cf[n][C],mu,imu);
	mul(t1,fix1,imu);
	mul(t2,fix2,mu);
	sub(cf[n][D],t1,t2);
}

drawFareyDisc(){
	int ii, jj, kk;
	FOR(ii,0,fInx){
		glColor4fv(col[ii]); 
		glBegin(GL_LINE_STRIP);
		FOR(jj,0,NAP){
                           glVertex2f(fareyCurve[ii][jj][X],fareyCurve[ii][jj][Y]);
		}
		glEnd();
	}
}

drawit(){

	int i, ii,jj, j, k,kk, nl/*which lune*/, w/*hichLune*/, begLune=0, endLune=2, scN;
	int r, g, b;
        GETS(center[200],traceMarker);cuRad = fac2;
        newMatrix();
        constructIsometricCircles();
	markAllPointsOfIntersection(mmm1, nnn1);

	/**if(axx) drawAxes();/**/
	/**drawCube(1);drawCube(0);drawCube(2);drawCube(3);/**/
	if(axx) FOR(ii,0,8){drawCube(ii);}
	else drawCube(mmmm);

	drawCube(101);drawCube(102);
	
	glLineWidth(thickWidth); 
	switch(poly){
		case 0: 
		FOR(ii,0,11){
			FOR(jj,0,2){
			    if(ii==m9 || ii==m10 || ii==m11 || ii==m12){
				glColor4fv(col[ii]); 
				glBegin(GL_LINE_STRIP);
				FOR(kk,0,NAP){
					 glVertex3fv(isoCircle[jj][ii][kk]); 
                                        
				}
				glEnd();
			    }
			}
		}
		break;
		
		case 1:
		FOR(jj,0,2){
			glColor4fv(col[maxCirInx]); 
			glBegin(GL_LINE_STRIP);
			FOR(kk,0,NAP){
				glVertex3fv(isoCircle[jj][maxCirInx][kk]);
			}
			glEnd();
		}
		FOR(jj,0,2){
			glColor4fv(col[secCirInx]);
			glBegin(GL_LINE_STRIP);
			FOR(kk,0,NAP){
				glVertex3fv(isoCircle[jj][secCirInx][kk]);
			}
			glEnd();
		}
		FOR(jj,0,2){
			glColor4fv(col[thirCirInx]); 
			glBegin(GL_LINE_STRIP);
			FOR(kk,0,NAP){
				glVertex3fv(isoCircle[jj][thirCirInx][kk]);
			}
			glEnd();
		}
		break;
		case 2:
		FOR(ii,0,11){
				glColor4fv(col[ii]);  
				glBegin(GL_LINE_STRIP);
				FOR(kk,0,NAP){
					glVertex3fv(isoCircle[0][ii][kk]);
				}
				glEnd();
		}

		break;
	}
	glLineWidth(thinWidth);

	if(isoSpheres!=0){
		FOR(i,0,2){
			FOR(j,0,10){
				if(isoSpheres!=3 || i==0) drawIsoSphere(i,j);
			}
		}
	}
	else {
	    if(axx){
		FOR(ii,0,2){
			drawIsoSphere(ii,maxCirInx);
			drawIsoSphere(ii,secCirInx);
			drawIsoSphere(ii,maxCirInx+secCirInx);
			drawIsoSphere(ii,thirCirInx+maxCirInx);
			if(maxCirInx-secCirInx>0) drawIsoSphere(ii,maxCirInx-secCirInx);
			else drawIsoSphere(ii,secCirInx-maxCirInx);
			if(maxCirInx-thirCirInx>0) drawIsoSphere(ii,maxCirInx-thirCirInx);
			else drawIsoSphere(ii,thirCirInx-maxCirInx);
		}
	    }
	}

}
/**************************************************************/


/* control keys */
void keyboard(unsigned char key, int x, int y){
#define  IF(K)            if(key==K)
#define  TOGGLE(K,flg)    IF(K){(flg) = 1-(flg); }
#define  PRESS(K,A,b)     IF(K){b;}IF((K-32)){A;}
#define  CYCLE(K,f,m)     PRESS((K), (f)=(((f)+(m)-1)%(m)),(f)=(++(f)%(m)))
     
   TOGGLE('O', opaque);                  /* opaque? */
   CYCLE('I',isoSpheres,4);        /* show isometric spheres */
   TOGGLE('w',msg);                              /* writing on/off      */
   CYCLE('P', poly,4);              /* show all iso circles or just poly */
   PRESS('s',speed /= 1.02, speed *= 1.02);      /* flying speed        */
   PRESS('q',torq /= 1.02, torq *= 1.02);        /* turning speed       */
   TOGGLE('v', binoc);                          /* wiggle lune */
   PRESS('b', fac2 /= 1.1, fac2 *= 1.1);       
   PRESS('z', deFault(), deFault());             /* zap changes         */
   TOGGLE(' ', mode);                  /* fly/turn modes      */
    IF(27) {exit(0); }              /* ESC exit            */
 
} /* end glut keyboard */

void special_keybo(int key, int x, int y){


if(movTrac){ /** move trace marker **/
   PRESS(GLUT_KEY_LEFT, traceMarker[X]+=speed, traceMarker[X]-=speed );
   PRESS(GLUT_KEY_RIGHT, traceMarker[X]-=speed, traceMarker[X]+=speed );
   PRESS(GLUT_KEY_UP,     glMatrixMode(GL_MODELVIEW); glPushMatrix(); glLoadIdentity();
                          glTranslatef(0.,0.,speed);glMultMatrixf(aff2);glPopMatrix(), 
			traceMarker[Y]+=speed  );
   PRESS(GLUT_KEY_DOWN,    glMatrixMode(GL_MODELVIEW); glPushMatrix(); glLoadIdentity();
                          glTranslatef(0.,0.,-speed);glMultMatrixf(aff2);glPopMatrix(),  
			traceMarker[Y]-=speed  );}



	


}


/* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */

#ifdef CAVE    

/* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */

void cavekeybo(void){
#define  CAVEIF(K)         if(CAVEgetbutton(K))
#define  CAVEPRESS(K,A,b)  CAVEIF(K){if(CAVEgetbutton(CAVE_LEFTSHIFTKEY)||\
                           CAVEgetbutton(CAVE_RIGHTSHIFTKEY)){b;}else{A;}}
#define  CAVETOGGLE(K,flg) CAVEIF(K){(flg) = 1-(flg); }
#define  CAVECYCLE(K,f,m)  CAVEPRESS((K),(f)=(((f)+(m)-1)%(m)),(f)=(++(f)%(m)) )
#define  CAVESLIDI(K,f,m,M)  CAVEPRESS(K,(--f<m?m:f), (++f>M?M:f))
#define  CAVESLIDF(K,f,m,M,d) CAVEPRESS(K,((f -= d)<m?m:f), ((f += d)>M?M:f))
  CAVEPRESS(CAVE_PKEY, wfar *= 1.01,   wfar   /= 1.01) /* rear clipping plane*/
  CAVEPRESS(CAVE_QKEY, speed /= 1.02, speed *= 1.02);/* flying speed       */
  CAVEPRESS(CAVE_RKEY, torq /= 1.02,  torq *= 1.02); /* turning speed      */
  CAVETOGGLE(CAVE_YKEY,wnd);                         /* mauspaw vs wandpaw */
/* not yet implemented */ 
   CAVEPRESS(CAVE_ZKEY, deFault(), deFault());        /* zap changes       */
}

void graffiti(void){             /* used to be called speedo  */
  char buf[256];                 /*messages written into here */ 
#define  LABEL3(x,y,z,W,u){sprintf(buf,(W),(u));char2wall(x,y,z,buf);}
  static float last=0.,fps;      /*for measuring time         */ 
  if(!CAVEMasterDisplay()) return;  /* USE CAVEMasterWall in papeBeta */
  if(floor(2.*(*CAVETime))>floor(2.*last)){  /* rationalize this */ 
     last=*CAVETime;
     fps=*CAVEFramesPerSecond;
     }
  if(mode==COMMANDMODE){
        glColor3f(1.,0.,1.);
        LABEL3(-3.8,1.,-5.0,\
          "AUTO=click(L) (M)ode SIZE=hold(M)click(L/R) 5=freeze 7=reset %s","");
        } else {
        glColor3f(1.,1.,0.);
        LABEL3(-3.8,1.0,-5.0,
          " push thumb-button to fly, TRACTOR=hold(M) GAP=hold(L)click(M/R) %s","");
        }
     LABEL3(-4.8,8.0,-5.0, " Illustrations for T Jorgenson's Math. Scan. article (1973). P McCreary, updated 1998 C Davis.","")
       LABEL3(-4.8,1.0,-5.0,"%5.1f fps",fps);
}
void cavetrack(void){
  float azi,ele,rol,hx,hy,hz,wx,wy,wz;
  static float ohx,ohy,ohz;   /*old head position */
  static float owx,owy,owz;   /*old wand position */
  static int opaw = 0,paw, joy = 0, friz;

  if(!CAVEMasterDisplay()) return;  /* doit once per frame */
  paw = wnd ? (CAVEBUTTON1*2+CAVEBUTTON2)*2+CAVEBUTTON3 : mauspaw;
  if(paw) joy = 1; /* activate joystick by clicking any button*/
  if(opaw!=2 && paw==2) mode = 1-mode; /* click modes */
  if(mode==COMMANDMODE){   /* hold middle button and click right to shrink */
     if (opaw == 2 && paw == 3)siz /= 1.5;     /*shrink object */
     if (opaw == 2 && paw == 6)siz *= 1.5;     /* grow   object */
     if (opaw != 4 && paw == 4)morph = 1-morph;/* shape changer */
     if (opaw != 5 && paw == 5)friz = 1-friz;  /* parking option */
     } 
  

  if(opaw==2 && paw == 7){ /* restart, the most useful feature */
     deFault(); ohx=ohy=ohz=0; owx=owy=owz=0;
     } 
  if(wnd){ 
      CAVEGetWandOrientation(azi,ele,rol);
      CAVEGetHead(hx,hy,hz);  /*position*/
      CAVEGetWand(wx,wy,wz);  /*position*/ 
      }
   else{  /* fix this for CAVE mouse flying */ 
      azi = .5*512; ele = .5*-512;
      } 
   glMatrixMode(GL_MODELVIEW); glPushMatrix(); glLoadIdentity();

   glTranslatef(ohx-hx,ohy-hy,ohz-hz); 
   if(mode==COMMANDMODE) glTranslatef(aff[12],aff[13],aff[14]);
   if(!friz){  /* if not parked */
      glRotatef(rol*(mode?torq:-torq),0.,0.,1.); 
      glRotatef(ele*-torq, 1.,0.,0.); 
      glRotatef(azi*-torq,0.,1.,0.);
      }
   if(joy&&((fabsf(CAVE_JOYSTICK_Y)>.02)||(fabsf(CAVE_JOYSTICK_X)>.02)))
       glTranslatef(CAVE_JOYSTICK_X*speed,0.,CAVE_JOYSTICK_Y*speed);
 
 if(opaw==2 && paw==2)glTranslatef(wx-owx, wy-owy, wz-owz); /*wand tractor */

 if(mode == COMMANDMODE) glTranslatef(-aff[12],-aff[13],-aff[14]);
   glMultMatrixf(aff); 
   glGetFloatv(GL_MODELVIEW_MATRIX,aff);

  {int ii,jj; for(ii=0;ii<3;ii++){ lu[ii]=0; /* calculite */
   for(jj=0;jj<3;jj++) lu[ii] += aff[ii*4+jj]*lux[jj];} }

   if(mode==FLYMODE && !friz) /*make the star matrix rotate*/
      {
      glLoadIdentity();
      glRotatef(rol*(mode?torq:-torq),0.,0.,1.); 
      glRotatef(ele*-torq,1.,0.,0.); 
      glRotatef(azi*-torq,0.,1.,0.);
      glMultMatrixf(starmat); 
      glGetFloatv(GL_MODELVIEW_MATRIX,starmat);
      }
   glPopMatrix();
   opaw=paw; ohx=hx; ohy=hy; ohz=hz;
             owx=wx; owy=wy; owz=wz;
   if(morph) autotymer(0);  /* advance autotymer */
   audiofunc();
}

void drawcaveinit(void){   /* kludge? needed why ? */  
   CAVEFar = 1000.;
   glClearColor(0.,0.,0.,0.);
   glClearDepth(1.);
}

void drawcave(void){
  float hx,hy,hz;
  glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
  drawstars();
  graffiti();
  CAVEGetHead(hx,hy,hz);
  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();
  glTranslatef(hx,hy,hz);
  glMultMatrixf(aff);
  glScalef(siz,siz,siz);
  drawall();
  glPopMatrix();
}

#endif

/* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */

/* Console Part  */

/* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */



/**********************************************************/
/*** console speedometer                                  */
/**********************************************************/
float speedometer(void){
/* this is the windows speedometer */
double dbl; static double rate; static int ii=0;

static struct _timeb lnow, lthen;

   if(++ii % 8 == 0){  /* 8 times around measure time */

	   _ftime(&lnow);
		dbl =  (double)(lnow.time - lthen.time)
			 +(double)(lnow.millitm - lthen.millitm)/1000;
		lthen = lnow;  rate = 8/dbl;
      }

   return((float)rate);
}

#if 0
/* this is the unix speedometer */
float speedometer()
{
double dbl; static double rate; static int ii=0;
static struct timezone notused; static struct timeval now, then;
   if(++ii % 8 == 0)  /* 8 times around measure time */
      {
      gettimeofday (&now, &notused); /* elapsed time */
      dbl =  (double)(now.tv_sec - then.tv_sec)
         +(double)(now.tv_usec - then.tv_usec)/1000000;
      then = now;  rate = 8/dbl;
      }
   return((float)rate);
}
#endif


void messages(void){     
  char buf[256]; /* console messages are done differently from cave */

#define  LABEL2(x,y,W,u) {sprintf(buf,(W),(u));char2wall(x,y,0.,buf);}

  glMatrixMode(GL_PROJECTION); glPushMatrix(); glLoadIdentity();
  gluOrtho2D(0,3000,0,3000);
  glMatrixMode(GL_MODELVIEW); glPushMatrix(); glLoadIdentity();
      /*bull's eye*/
      if(mode==0) glColor3f(0x22/255.,0x88/255.,0xdd/255.);
        else      glColor3f(.8,.8,.8);
      LABEL2(1500,1500,"%s","o");
      /* writings */
      if(mode==0) glColor3f(1.,0.,1.);
        else      glColor3f(1.,1.,0.);
      LABEL2(80,150,"%4.1f fps",speedometer());
      LABEL2(80,2840,\
      "(ESC)ape  (MAUS2)Fore  (v)inoc (W)riting",
             mode?"FLYING":"CONTROL");
      LABEL2(10,80,"Illustrations for T Jorgenson's Math. Scan. article (1973)",0);
      LABEL2(10,10," by Paul R. McCreary, U Illinois, 1995, updated and nooshed by Craig Davis 1998 %s","");
      LABEL2(80,2700,"(S)peed  %0.4f",speed);
      LABEL2(80,2630," tor(Q) %0.4f",torq);
      
      LABEL2(80,2540,"(I)soSph = %d",isoSpheres);
      LABEL2(80,2470,"(P)oly = %d",poly);
      LABEL2(80,2400,"(O)paque = %d",opaque);
      LABEL2(80,2330,"(B)ox Size = %f",fac2);


      LABEL2(80,2280,"(Z)ap %s","");

      
     
    glPopMatrix();
glMatrixMode(GL_PROJECTION); glPopMatrix();
} 


void chaptrack(int but,int xx,int yy,int shif){
   long dx,dy;
   dx = xx -.5*xt; dx = abs(dx)>5?dx:0;    
   dy = yy -.5*yt; dy = abs(dy)>5?dy:0;

   glMatrixMode(GL_MODELVIEW); glPushMatrix(); glLoadIdentity();

   if(mode==COMMANDMODE) glTranslatef(aff[12],aff[13],aff[14]);
   glRotatef(dx*torq,0.,1.,0.); glRotatef(-dy*torq,1.,0.,0.);
   if(but&(1<<GLUT_RIGHT_BUTTON )){where = where + .1;glRotatef(shif?-10:-1,0.,0.,1.);}
   if(but&(1<<GLUT_LEFT_BUTTON  )){where = where - .1;glRotatef(shif?10:1,0.,0.,1.);}

   if(but&(1<<GLUT_MIDDLE_BUTTON)) glTranslatef(0.,0.,shif ? -speed : speed);
   if(mode==COMMANDMODE) glTranslatef(-aff[12],-aff[13],-aff[14]);
   glMultMatrixf(aff);
   glGetFloatv(GL_MODELVIEW_MATRIX,aff);
   {int ii,jj; for(ii=0;ii<3;ii++){ lu[ii]=0; /* calculite */
          for(jj=0;jj<3;jj++) lu[ii] += aff[ii*4+jj]*lux[jj];}}
   glPopMatrix();
}

void idle(void){ /*do this when nothing else is happening*/
    if(morph) autotymer(0);  /* advance autotymer */ 
    chaptrack(BUT,XX,YY,SHIF);
    audiofunc(); 
   glutPostRedisplay();  /*redraw the window*/
}


void mousepushed(int but,int stat,int x,int y){
  if(stat==GLUT_DOWN) BUT |= (1<<but);
  else BUT &= (-1 ^ (1<<but));
  XX=x; YY=y; SHIF=(glutGetModifiers()==GLUT_ACTIVE_SHIFT)?1:0;
}

void mousemoved(int x,int y){  XX=x; YY=y; }

void reshaped(int xx, int yy){xt=xx ; yt=yy;}   /* what is this for ? */

void drawcons(void){  

  glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
  if(binoc) glViewport(0,yt/8,xt/2,6*yt/8);  
  glMatrixMode(GL_PROJECTION); glLoadIdentity();
  glFrustum(-mysiz*xt/yt,mysiz*xt/yt,-mysiz,mysiz,mysiz*focal,100.); 
  glMatrixMode(GL_MODELVIEW); glLoadIdentity();
     drawstars(); 
  glTranslatef(-binoc*nose,0,-5);
  glMultMatrixf(aff);
  drawall();

  if(binoc){
    glViewport(xt/2,yt/4,xt/2,yt/2); 
    glMatrixMode(GL_PROJECTION);
    glLoadIdentity();
    gluOrtho2D(-3,3,-2.2,2.2);  
    glMatrixMode(GL_MODELVIEW);
    glLoadIdentity();
    glTranslatef(-binoc*nose,0,0); 
    glMultMatrixf(aff2);
    drawall2();
    }
  glViewport(0,0,xt,yt);
  if(msg) messages(); 
  glutSwapBuffers();
}

void main(int argc, char **argv){  
   arguments(argc,argv); 

   if(caveyes)
#ifdef CAVE
       CAVEConfigure(&argc, argv, NULL)
#endif
       ;
   getmem();
   dataprep();
 
   if(caveyes){
#ifdef CAVE
       CAVEInit(); /* Each wall is (part of) a forked process from here on.*/ 
       CAVEFrameFunction(cavetrack,0);  
       /*is restricted to MasterWall, so once per frame */
       CAVEInitApplication(drawcaveinit, 0); 
       CAVEDisplay(drawcave, 0);
       while(!CAVEgetbutton(CAVE_ESCKEY))
         {
         cavekeybo();  /* is asynchronous from display processes */ 
         sginap(10); 
	 }
       audioclean();
       CAVEExit();
#endif
       ;}
     else{ /*console main*/
       glutInit(&argc, argv);
       glutInitDisplayMode(GLUT_DOUBLE|GLUT_DEPTH);
       win = 2;
#if 0
       switch(win)
         { case 0: break;
           case 1: glutInitWindowSize(640, 480);
                   glutInitWindowPosition(0,1024-480);
                   break;
           case 2: glutInitWindowPosition(0,0);
	           break;
         }
#endif
       glutCreateWindow("<* illiSkel in C/OpenGL/GLUT *>");
       if(win==2) glutFullScreen();
       glEnable(GL_DEPTH_TEST);
       glEnable(GL_BLEND); 
       glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);
       glutDisplayFunc(drawcons);       
       glutKeyboardFunc(keyboard);
       glutSpecialFunc(special_keybo);   
       glutMouseFunc(mousepushed);
       glutMotionFunc(mousemoved);       
       glutPassiveMotionFunc(mousemoved); 
       glutReshapeFunc(reshaped);
       glutIdleFunc(idle);  
       glutMainLoop();
       }
} 


/* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */

/* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */




