/*
 *  stoneh_draw.c
 *  schprel
 *
 *  Created by mflider on Mon Jul 23 2001.
 *  Copyright (c) 2001 Mark Flider. All rights reserved. ;)
 *
 */

/* GLUT for *every* platform! */
#ifdef __sgi
#include <glut.h>	/* SGI glut libs */
#endif
#ifdef __MWERKS__
#include <glut.h>	/* MacOS 9 glut libs */
#endif
#ifdef __LINUX
#include <GL/glut.h>	/* Linux glut libs */
#endif
#ifdef __MACOSX
#include <GLUT/glut.h>	/*OS X glut libs */
#endif
#ifdef __WINDOWS
#include <gl\glut.h>	/* Windows glut libs */
#endif

#include <stdio.h>
#include <stdlib.h>

#include "self.c"

/*
 *  The following variables define the 3D mesh.
 *  The number of elements for vertices can be calculated
 *  as sizeof(obj_vertex)/sizeof(Point3). The number of elements
 *  in the face arrays can be calculated as sizeof(obj_face)/sizeof(long).
 *  ------------ pave -------------
 *  ------------ lentil -------------
 *  ------------ low_rocks -------------
 *  ------------ lentil01 -------------
 *  ------------ lentil02 -------------
 *  ------------ tallrock01 -------------
 *  ------------ tall_roc01 -------------
 *  ------------ tall_roc02 -------------
 *  ------------ tall_roc03 -------------
 *  ------------ tall_roc04 -------------
 *  ------------ tall_roc05 -------------
 *  ------------ tall_roc06 -------------
 *  ------------ tall_roc07 -------------
 *  ------------ tall_roc08 -------------
 *  ------------ tall_roc09 -------------
 *  ------------ tall_roc10 -------------
 *  ------------ tall_roc11 -------------
 *  ------------ tall_roc14 -------------
 *  ------------ tall_roc15 -------------
 *  ------------ tall_roc16 -------------
 *  ------------ tall_roc17 -------------
 *  ------------ tall_roc18 -------------
 *  ------------ tall_roc19 -------------
 *  ------------ tall_roc20 -------------
 *  ------------ tall_roc21 -------------
 *  ------------ tall_roc22 -------------
 *  ------------ tall_roc23 -------------
 *  ------------ tall_roc13 -------------
 *  ------------ lentil03 -------------
 *  ------------ lentil04 -------------
 *  ------------ lentil05 -------------
 *  ------------ biglent01 -------------
 *  ------------ biglent -------------
 *  ------------ biglent02 -------------
*/

void normalize_data(Point3 xxx[], int theLength)
{
    int ii;
    for (ii=0; ii<theLength; ii++)
    {
        xxx[ii].x /= 5.0; xxx[ii].x -= 40.0;
        xxx[ii].y /= 5.0; xxx[ii].y -= 40.0;
        xxx[ii].z /= 5.0; xxx[ii].z -= 5.0;
    }
}

void initTheGL(void)
{
    GLfloat LightAmbient[]= { 0.25f, 0.25f, 0.3f, 1.0f };
    GLfloat LightDiffuse[]= { 1.0f, 1.0f, 0.95f, 1.0f };
    GLfloat LightPosition[]= { 0.1f, 1.0f, 1.0f, 0.0f };
    

    glShadeModel(GL_SMOOTH);				/* Enable Smooth Shading */
    glEnable(GL_DEPTH_TEST);				/* Enables Depth Testing */

    glLightfv(GL_LIGHT1, GL_AMBIENT, LightAmbient);	/* Setup The Ambient */
    glLightfv(GL_LIGHT1, GL_DIFFUSE, LightDiffuse);	/* Setup The Diffuse Light */
    glLightfv(GL_LIGHT1, GL_POSITION, LightPosition);	/* Position The Light */
    /*glLightf(GL_LIGHT1, GL_CONSTANT_ATTENUATION, 0.002);
    glLightf(GL_LIGHT1, GL_LINEAR_ATTENUATION, 0.002);*/
    
    glLightModeli(GL_LIGHT_MODEL_TWO_SIDE, GL_TRUE);
    
   /* glEnable(GL_LIGHT1);	/* Enable Light One; directional */
}

void initall(void)
{
    normalize_data(pave_vertex,44);
    normalize_data(lentil_vertex,28);
    normalize_data(low_rocks_vertex,940);
    normalize_data(lentil01_vertex,28);
    normalize_data(lentil02_vertex,28);
    normalize_data(tallrock01_vertex,56);
    normalize_data(tall_roc01_vertex,56);
    normalize_data(tall_roc02_vertex,56);
    normalize_data(tall_roc03_vertex,84);
    normalize_data(tall_roc04_vertex,56);
    normalize_data(tall_roc05_vertex,56);
    normalize_data(tall_roc06_vertex,56);
    normalize_data(tall_roc07_vertex,56);
    normalize_data(tall_roc08_vertex,84);
    normalize_data(tall_roc09_vertex,56);
    normalize_data(tall_roc10_vertex,56);
    normalize_data(tall_roc11_vertex,112);
    normalize_data(tall_roc14_vertex,56);
    normalize_data(tall_roc15_vertex,56);
    normalize_data(tall_roc16_vertex,56);
    normalize_data(tall_roc17_vertex,56);
    normalize_data(tall_roc18_vertex,84);
    normalize_data(tall_roc19_vertex,84);
    normalize_data(tall_roc20_vertex,84);
    normalize_data(tall_roc21_vertex,56);
    normalize_data(tall_roc22_vertex,56);
    normalize_data(tall_roc23_vertex,56);
    normalize_data(tall_roc13_vertex,63);
    normalize_data(lentil03_vertex,28);
    normalize_data(lentil04_vertex,28);
    normalize_data(lentil05_vertex,28);
    normalize_data(biglent01_vertex,152);
    normalize_data(biglent02_vertex,152);
    normalize_data(biglent_vertex,152);
    initSelf();
}




void updateThis(float ca,float cb,float sa,float sb,float v,float thegamma,Point3 xxx_draw[],Point3 xxx_vertex[],int theLength)
{
   float temp; int ii;
   for (ii=0; ii<theLength; ii++)  /* rotation */
   {
       temp  = xxx_vertex[ii].y * ca - sa * xxx_vertex[ii].x;
       xxx_vertex[ii].x = xxx_vertex[ii].x * ca + sa * xxx_vertex[ii].y;
       xxx_vertex[ii].y = temp * cb - sb * xxx_vertex[ii].z;
       xxx_vertex[ii].z = xxx_vertex[ii].z * cb + sb * temp;
      /* translation */
       if(mode==FLYMODE) xxx_vertex[ii].y += v;
              
       if (linearVel)
       {
         xxx_draw[ii].z = updateVertex(xxx_vertex[ii].x, xxx_vertex[ii].z, xxx_vertex[ii].y, cls, v, thegamma);
         xxx_draw[ii].y = xxx_vertex[ii].z;
         xxx_draw[ii].x = xxx_vertex[ii].x;
       }
       else
       {          
          dd=ff=HOW_FAR_BACK/2;
          temp_best = 1000;
          for (;;)
          {
            ff /= 2;
            if (ff < 1) break;
            
            temp = cls*/* v/ */(float)dd - fsqrt(
                     dist2(xxx_vertex[ii].x-selfPosition[dd][0],
                           xxx_vertex[ii].z,
                           xxx_vertex[ii].y-selfPosition[dd][2]) );
            
             /* if ( ABS(temp) <= theThreshold) break; */
             if ( ABS(temp) < ABS(temp_best) )
             {
                dd_best = dd; temp_best = temp;
             }

             if (temp < 0) dd += ff;
             else dd -= ff;
           }
                xxx_draw[ii].x = xxx_vertex[ii].x-selfPosition[dd_best][0];
                xxx_draw[ii].y = xxx_vertex[ii].z;
                xxx_draw[ii].z = xxx_vertex[ii].y-selfPosition[dd_best][2];
         }
       
   }
}


void updateall(float ca,float cb,float sa,float sb,float v,float thegamma)
{
    updateThis(ca,cb,sa,sb,v,thegamma,pave_draw,pave_vertex,sizeof(pave_vertex)/sizeof(Point3));
    updateThis(ca,cb,sa,sb,v,thegamma,lentil_draw,lentil_vertex,sizeof(lentil_vertex)/sizeof(Point3));
    updateThis(ca,cb,sa,sb,v,thegamma,low_rocks_draw,low_rocks_vertex,sizeof(low_rocks_vertex)/sizeof(Point3));
    updateThis(ca,cb,sa,sb,v,thegamma,lentil01_draw,lentil01_vertex,sizeof(lentil01_vertex)/sizeof(Point3));
    updateThis(ca,cb,sa,sb,v,thegamma,lentil02_draw,lentil02_vertex,sizeof(lentil02_vertex)/sizeof(Point3));
    updateThis(ca,cb,sa,sb,v,thegamma,tallrock01_draw,tallrock01_vertex,sizeof(tallrock01_vertex)/sizeof(Point3));
    updateThis(ca,cb,sa,sb,v,thegamma,tall_roc01_draw,tall_roc01_vertex,sizeof(tall_roc01_vertex)/sizeof(Point3));
    updateThis(ca,cb,sa,sb,v,thegamma,tall_roc02_draw,tall_roc02_vertex,sizeof(tall_roc02_vertex)/sizeof(Point3));
    updateThis(ca,cb,sa,sb,v,thegamma,tall_roc03_draw,tall_roc03_vertex,sizeof(tall_roc03_vertex)/sizeof(Point3));
    updateThis(ca,cb,sa,sb,v,thegamma,tall_roc04_draw,tall_roc04_vertex,sizeof(tall_roc04_vertex)/sizeof(Point3));
    updateThis(ca,cb,sa,sb,v,thegamma,tall_roc05_draw,tall_roc05_vertex,sizeof(tall_roc05_vertex)/sizeof(Point3));
    updateThis(ca,cb,sa,sb,v,thegamma,tall_roc06_draw,tall_roc06_vertex,sizeof(tall_roc06_vertex)/sizeof(Point3));
    updateThis(ca,cb,sa,sb,v,thegamma,tall_roc07_draw,tall_roc07_vertex,sizeof(tall_roc07_vertex)/sizeof(Point3));
    updateThis(ca,cb,sa,sb,v,thegamma,tall_roc08_draw,tall_roc08_vertex,sizeof(tall_roc08_vertex)/sizeof(Point3));
    updateThis(ca,cb,sa,sb,v,thegamma,tall_roc09_draw,tall_roc09_vertex,sizeof(tall_roc09_vertex)/sizeof(Point3));
    updateThis(ca,cb,sa,sb,v,thegamma,tall_roc10_draw,tall_roc10_vertex,sizeof(tall_roc10_vertex)/sizeof(Point3));
    updateThis(ca,cb,sa,sb,v,thegamma,tall_roc11_draw,tall_roc11_vertex,sizeof(tall_roc11_vertex)/sizeof(Point3));
    updateThis(ca,cb,sa,sb,v,thegamma,tall_roc14_draw,tall_roc14_vertex,sizeof(tall_roc14_vertex)/sizeof(Point3));
    updateThis(ca,cb,sa,sb,v,thegamma,tall_roc15_draw,tall_roc15_vertex,sizeof(tall_roc15_vertex)/sizeof(Point3));
    updateThis(ca,cb,sa,sb,v,thegamma,tall_roc16_draw,tall_roc16_vertex,sizeof(tall_roc16_vertex)/sizeof(Point3));
    updateThis(ca,cb,sa,sb,v,thegamma,tall_roc17_draw,tall_roc17_vertex,sizeof(tall_roc17_vertex)/sizeof(Point3));
    updateThis(ca,cb,sa,sb,v,thegamma,tall_roc18_draw,tall_roc18_vertex,sizeof(tall_roc18_vertex)/sizeof(Point3));
    updateThis(ca,cb,sa,sb,v,thegamma,tall_roc19_draw,tall_roc19_vertex,sizeof(tall_roc19_vertex)/sizeof(Point3));
    updateThis(ca,cb,sa,sb,v,thegamma,tall_roc20_draw,tall_roc20_vertex,sizeof(tall_roc20_vertex)/sizeof(Point3));
    updateThis(ca,cb,sa,sb,v,thegamma,tall_roc21_draw,tall_roc21_vertex,sizeof(tall_roc21_vertex)/sizeof(Point3));
    updateThis(ca,cb,sa,sb,v,thegamma,tall_roc22_draw,tall_roc22_vertex,sizeof(tall_roc22_vertex)/sizeof(Point3));
    updateThis(ca,cb,sa,sb,v,thegamma,tall_roc23_draw,tall_roc23_vertex,sizeof(tall_roc23_vertex)/sizeof(Point3));
    updateThis(ca,cb,sa,sb,v,thegamma,tall_roc13_draw,tall_roc13_vertex,sizeof(tall_roc13_vertex)/sizeof(Point3));
    updateThis(ca,cb,sa,sb,v,thegamma,lentil03_draw,lentil03_vertex,sizeof(lentil03_vertex)/sizeof(Point3));
    updateThis(ca,cb,sa,sb,v,thegamma,lentil04_draw,lentil04_vertex,sizeof(lentil04_vertex)/sizeof(Point3));
    updateThis(ca,cb,sa,sb,v,thegamma,lentil05_draw,lentil05_vertex,sizeof(lentil05_vertex)/sizeof(Point3));
    updateThis(ca,cb,sa,sb,v,thegamma,biglent01_draw,biglent01_vertex,sizeof(biglent01_vertex)/sizeof(Point3));
    updateThis(ca,cb,sa,sb,v,thegamma,biglent_draw,biglent_vertex,sizeof(biglent_vertex)/sizeof(Point3));
    updateThis(ca,cb,sa,sb,v,thegamma,biglent02_draw,biglent02_vertex,sizeof(biglent02_vertex)/sizeof(Point3));
    updateSelf(ca,cb,sa,sb,v,thegamma);
}

void normalizeThis(Point3 xxx,Point3 yyy,Point3 zzz,GLdouble normy[])
{
    double temp;
    normy[0] = (xxx.y-yyy.y)*(xxx.z-zzz.z)-(xxx.z-yyy.z)*(xxx.y-zzz.y);
    normy[1] = (xxx.z-yyy.z)*(xxx.x-zzz.x)-(xxx.x-yyy.x)*(xxx.z-zzz.z);
    normy[2] = (xxx.x-yyy.x)*(xxx.y-zzz.y)-(xxx.y-yyy.y)*(xxx.x-zzz.x);
    temp = fsqrt(dist2(normy[0],normy[1],normy[2]));
    normy[0] /= temp; normy[1] /= temp; normy[2] /= temp;
}
    

void drawThis(Point3 xxx_draw[],long xxx_face[],int theLength)
{
    GLdouble normy[3];
    int ii;
    for (ii=0; ii<theLength; ii+=4)
    {
        normalizeThis(xxx_draw[xxx_face[ii]],xxx_draw[xxx_face[ii+1]],
            xxx_draw[xxx_face[ii+2]],normy);
        glNormal3dv(normy);
        glVertex3d(xxx_draw[xxx_face[ii]].x,
            xxx_draw[xxx_face[ii]].y,
            xxx_draw[xxx_face[ii]].z);
        glNormal3dv(normy);
        glVertex3d(xxx_draw[xxx_face[ii+1]].x,
           xxx_draw[xxx_face[ii+1]].y,
           xxx_draw[xxx_face[ii+1]].z);
        glNormal3dv(normy);
        glVertex3d(xxx_draw[xxx_face[ii+2]].x,
           xxx_draw[xxx_face[ii+2]].y,
           xxx_draw[xxx_face[ii+2]].z);
    }
}

void drawall(void)
{
    GLfloat mat_specular[] = { 1.0, 1.0, 0.95, 1.0 };
    GLfloat mat_specular_default[] = { 0, 0, 0, 1.0 };
    glEnable(GL_LIGHTING);
    glEnable(GL_LIGHT1);
    
    glMaterialfv(GL_FRONT, GL_SPECULAR, mat_specular);
    glMaterialf(GL_FRONT, GL_SHININESS, 100);
    glEnable(GL_COLOR_MATERIAL);
    glColorMaterial(GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE);
    glBegin(GL_TRIANGLES);
    
    glColor3f(.2,.4,.2);
    drawThis(pave_draw,pave_face,sizeof(pave_face)/sizeof(long));
    glColor3f(.5,.4,.1);
    drawThis(low_rocks_draw,low_rocks_face,sizeof(low_rocks_face)/sizeof(long));
    glColor3f(.6,.6,.65);
    drawThis(lentil_draw,lentil_face,sizeof(lentil_face)/sizeof(long));
    drawThis(lentil01_draw,lentil01_face,sizeof(lentil01_face)/sizeof(long));
    drawThis(lentil02_draw,lentil02_face,sizeof(lentil02_face)/sizeof(long));
    drawThis(lentil03_draw,lentil03_face,sizeof(lentil03_face)/sizeof(long));
    drawThis(lentil04_draw,lentil04_face,sizeof(lentil04_face)/sizeof(long));
    drawThis(lentil05_draw,lentil05_face,sizeof(lentil05_face)/sizeof(long));
    drawThis(lentil_draw,lentil_face,sizeof(lentil_face)/sizeof(long));
    drawThis(lentil_draw,lentil_face,sizeof(lentil_face)/sizeof(long));
    drawThis(biglent_draw,biglent_face,sizeof(biglent_face)/sizeof(long));
    drawThis(biglent01_draw,biglent01_face,sizeof(biglent01_face)/sizeof(long));
    drawThis(biglent02_draw,biglent02_face,sizeof(biglent02_face)/sizeof(long));
    drawThis(tallrock01_draw,tallrock01_face,sizeof(tallrock01_face)/sizeof(long));
    drawThis(tall_roc01_draw,tall_roc01_face,sizeof(tall_roc01_face)/sizeof(long));
    drawThis(tall_roc02_draw,tall_roc02_face,sizeof(tall_roc02_face)/sizeof(long));
    drawThis(tall_roc03_draw,tall_roc03_face,sizeof(tall_roc03_face)/sizeof(long));
    drawThis(tall_roc04_draw,tall_roc04_face,sizeof(tall_roc04_face)/sizeof(long));
    drawThis(tall_roc05_draw,tall_roc05_face,sizeof(tall_roc05_face)/sizeof(long));
    drawThis(tall_roc06_draw,tall_roc06_face,sizeof(tall_roc06_face)/sizeof(long));
    drawThis(tall_roc07_draw,tall_roc07_face,sizeof(tall_roc07_face)/sizeof(long));
    drawThis(tall_roc08_draw,tall_roc08_face,sizeof(tall_roc08_face)/sizeof(long));
    drawThis(tall_roc09_draw,tall_roc09_face,sizeof(tall_roc09_face)/sizeof(long));
    drawThis(tall_roc10_draw,tall_roc10_face,sizeof(tall_roc10_face)/sizeof(long));
    drawThis(tall_roc11_draw,tall_roc11_face,sizeof(tall_roc11_face)/sizeof(long));
    drawThis(tall_roc13_draw,tall_roc13_face,sizeof(tall_roc13_face)/sizeof(long));
    drawThis(tall_roc14_draw,tall_roc14_face,sizeof(tall_roc14_face)/sizeof(long));
    drawThis(tall_roc15_draw,tall_roc15_face,sizeof(tall_roc15_face)/sizeof(long));
    drawThis(tall_roc16_draw,tall_roc16_face,sizeof(tall_roc16_face)/sizeof(long));
    drawThis(tall_roc17_draw,tall_roc17_face,sizeof(tall_roc17_face)/sizeof(long));
    drawThis(tall_roc18_draw,tall_roc18_face,sizeof(tall_roc18_face)/sizeof(long));
    drawThis(tall_roc19_draw,tall_roc19_face,sizeof(tall_roc19_face)/sizeof(long));
    drawThis(tall_roc20_draw,tall_roc20_face,sizeof(tall_roc20_face)/sizeof(long));
    drawThis(tall_roc21_draw,tall_roc21_face,sizeof(tall_roc21_face)/sizeof(long));
    drawThis(tall_roc22_draw,tall_roc22_face,sizeof(tall_roc22_face)/sizeof(long));
    drawThis(tall_roc23_draw,tall_roc23_face,sizeof(tall_roc23_face)/sizeof(long));
    glEnd();
    if (!track) drawSelf();
    glColor3f(1,1,1);
    glDisable(GL_COLOR_MATERIAL);
    glMaterialfv(GL_FRONT, GL_SPECULAR, mat_specular_default);
    glDisable(GL_LIGHTING);
    
}


