//***************************************************************************
// The database for the space tiling by dodecahedra is from the
// Geometry Center at the University of Minnesota. This is an old CAVE demo
// of George Francis's group. The porting to Syzygy was done by
// Matt Woodruff and Ben Bernard.
//***************************************************************************

#ifndef DOD_DESCRIP_H
#define DOD_DESCRIP_H

#define N_VERTS 20
#define N_FACES 12
#define N_EDGES 30
#define FACE_VERTS 5
#define STOPSTRIP -1
#define ENDARRAY -2

// These arrays are used in only some of the files which include this.

static float ddvert[N_VERTS][4] ={ 
{ 0.353553, 0.000000, 0.135045, 0.925615 }, 
{ 0.218508, -0.218508, 0.218508, 0.925615 }, 
{ 0.218508, 0.218508, 0.218508, 0.925615 }, 
{ 0.000000, -0.135045, 0.353553, 0.925615 }, 
{ 0.000000, 0.135045, 0.353553, 0.925615 }, 
{ -0.353553, 0.000000, 0.135045, 0.925615 }, 
{ -0.218508, -0.218508, 0.218508, 0.925615 }, 
{ -0.218508, 0.218508, 0.218508, 0.925615 }, 
{ -0.135045, 0.353553, 0.000000, 0.925615 }, 
{ 0.135045, 0.353553, 0.000000, 0.925615 }, 
{ -0.135045, -0.353553, 0.000000, 0.925615 }, 
{ 0.135045, -0.353553, 0.000000, 0.925615 }, 
{ 0.218508, -0.218508, -0.218508, 0.925615 }, 
{ 0.353553, 0.000000, -0.135045, 0.925615 }, 
{ 0.218508, 0.218508, -0.218508, 0.925615 }, 
{ 0.000000, -0.135045, -0.353553, 0.925615 }, 
{ 0.000000, 0.135045, -0.353553, 0.925615 }, 
{ -0.218508, -0.218508, -0.218508, 0.925615 }, 
{ -0.353553, 0.000000, -0.135045, 0.925615 }, 
{ -0.218508, 0.218508, -0.218508, 0.925615 } 
  };

static int ddface[N_FACES][FACE_VERTS] ={ 
{ 16, 15, 17, 18 ,19 }, 
{ 14, 13, 12, 15 ,16 }, 
{ 12, 11, 10, 17 ,15 }, 
{ 6, 5, 18, 17 ,10 }, 
{ 5, 7, 8, 19 ,18 }, 
{ 8, 9, 14, 16 ,19 }, 
{ 1, 3, 6, 10 ,11 }, 
{ 0, 1, 11, 12 ,13 }, 
{ 2, 0, 13, 14 ,9 }, 
{ 4, 2, 9, 8 ,7 }, 
{ 3, 4, 7, 5 ,6 }, 
{ 4, 3, 1, 0 ,2 }, 
  };

static int ddwire[] = {
  18,17,15,16,19,18,5,6,10,11,12,13,14,9,8,7,4,3,1,0,2,4,STOPSTRIP,
  10,17,STOPSTRIP, 12,15,STOPSTRIP, 14,16,STOPSTRIP, 8,19,STOPSTRIP,
  3,6,STOPSTRIP, 1,11,STOPSTRIP, 0,13,STOPSTRIP, 2,9,STOPSTRIP,
  7,5,ENDARRAY
  };

static float sddcolr[N_FACES][4] ={ 
{ 0.800000, 0.100000, 0.100000, 0.750000 }, 
{ 0.100000, 0.650000, 0.400000, 0.750000 }, 
{ 0.100000, 0.100000, 0.800000, 0.750000 }, 
{ 0.900000, 0.600000, 0.000000, 0.750000 }, 
{ 0.000000, 0.600000, 0.800000, 0.750000 }, 
{ 0.500000, 0.000000, 0.900000, 0.750000 }, 
{ 0.500000, 0.000000, 0.900000, 0.750000 }, 
{ 0.000000, 0.600000, 0.800000, 0.750000 }, 
{ 0.900000, 0.600000, 0.000000, 0.750000 }, 
{ 0.100000, 0.100000, 0.800000, 0.750000 }, 
{ 0.100000, 0.650000, 0.400000, 0.750000 }, 
{ 0.800000, 0.100000, 0.100000, 0.750000 } 
  };

float sphcolr[8][4] ={
{ 0.2, 0.2, 0.2, 1.0},  // gray
{ 0.0, 0.9, 0.9, 1.0},  // cyan
{ 0.9, 0.0, 0.9, 1.0},  // mag
{ 0.9, 0.9, 0.0, 1.0}, //  yellow
{ 0.0, 0.0, 0.9, 1.0},  // blue
{ 0.0, 0.9, 0.0, 1.0},  // green
{ 0.9, 0.0, 0.0, 1.0},  // red
{ 0.9, 0.9, 0.9, 1.0} // white
};


static float hddcolr[N_FACES][4] ={
{ 0.800000, 0.100000, 0.100000, 0.750000 },
{ 0.800000, 0.100000, 0.100000, 0.750000 },
{ 0.100000, 0.650000, 0.400000, 0.750000 },
{ 0.900000, 0.600000, 0.000000, 0.750000 },
{ 0.900000, 0.600000, 0.000000, 0.750000 },
{ 0.500000, 0.000000, 0.900000, 0.750000 },
{ 0.100000, 0.650000, 0.400000, 0.750000 },
{ 0.100000, 0.100000, 0.800000, 0.750000 },
{ 0.100000, 0.100000, 0.800000, 0.750000 },
{ 0.500000, 0.000000, 0.900000, 0.750000 },
{ 0.000000, 0.600000, 0.800000, 0.750000 },
{ 0.000000, 0.600000, 0.800000, 0.750000 }
 };

#endif
