// toggle speeds for fine and coarse motion
// toggle gap=6 and rim to show only trail
// put in the chaptrail, but switch args to Hanrahan
//25jul05 took out the CAVE stuff but trouble in stars with a buserror
/* this is shnail06mar03.c which is compiled in gaol and on Menu*/
/* wrist sensor displacement */
/* added a freeze joy==3 and changed the siz==3 20jul02*/
/* gkf 7jul02 TimesRoman and gesturejoy */
/****************************************************************/
/****          shnail =  noosh.c = ishell97 to be                    ****/
/****           descended from ishell95                      ****/
/****            14 February 1995                            ****/
/****            29 August   1995                            ****/
/****             1 November 1995                            ****/ 
/****            15 november 1996   ishell96.c               ****/
/****            27 november 1996   ishell96.c               ****/
/****            23 march    1997   newsh.c                  ****/
/****    (C) 1994 Board of Trustees University of Illinois   ****/ 
/****    A Model Real-Time Interactive CAVE Application      ****/
/****    George Francis, Glenn Chappell, Chris Hartman       ****/
/****    e-mail  gfrancis@math.uiuc.edu                      ****/
/****    Generic RTICA by GGC 7/25/94 revised gkf 12.30.94   ****/ 
/****    Revised by GGC and GKF august 95                    ****/
/****    "Opengl ed" by AVB, nov 14-15, 1996                 ****/
/****    Reformatted by AVB, nov 16, 1996                    ****/
/****    adaptation to CAVE 2.6Beta started 6feb97 gkf       ****/
/****    New version to fix many bugs and clean up 17mar97 cmh  */
/****    Rationalization begun 26mar97 gkf                   ****/    
/****    snail installed from snail+skel 3apr97 gkf             */
/****************************************************************/
/* CAVE trials 1apr97 bugs:
   1. At 24x24x2 triangles = 1152 we get 24fps with all 8 processors
      At 30x30x2 triangles = 1800 this drops to 16 fps on 8 processors
      With fewer processors (mpunlock) the dropoff is disastrous, 
   2. Current version (= 31mar97) does ambient only on process 2 (right
      wall and floor) .... no paint at all!
*/
/* Some emerging conventions on the path of rationalization 

   draw<what> == this function uses GL calls for drawing something
   cons       == pertaining to the console mode only
   cave       == pertaining to the CAVE mode(s)
                 all such functions are protected by #ifdef CAVEs for
                 CAVE less compilation
   audio      == pertaining to the vss audio stuff required three
                 matched files: vssClient.h libsnd.a and vss 
                 should also be protected by #ifdef SOUNDs
   autotymer  == is (now) called only by the master process in the CAVE
                 with the result that non-shared globals are not updated
                 on the other walls. So we share them. 
   <factor>  == a factor is a function that has been separated out for 
                 (1) convenience (i.e. is not a factor of any other function) 
                 (2) necessity (i.e. is a factor of another function )
   <depth>   == from main() in the factor graph. 

   Of necessity, C requires that the factor graph be treelike with the leaves
   at the top of the program code. For a C++ conversion, this tree will be 
   turned upside down.  
*/

/* Factor graph for this program. Please indicate structural modifications 
   The asterisk indicates a factor that has more than one function calling it. 
       main  
         arguments ....................command line switches and parameters 
           getopt  
         CAVEconfigure
         getmem .......................allocate shared memory  
           Malloc(share_var)
         dataprep .....................done only once   
           audioprep
             AUDinit
          *deFault 
         ifCAVE
           FrameFunc(cavetrack)........done once every frame 
                   >   *deFault........on the reset button combination
                   >   *autotymer .....automatic clockwork animation
                       *audiofunc .....sends messages to soundserver
           InitApplic(drawcaveinit)....done each frame 
           Display(drawcave)...........done each frame
                    *drawstars
                     graffiti..........on the front CAVE wall
                        char2wall
                  >  *drawall
                  >     drawsnail.........compressed version of snail 
                  >       snailvert........do everything for one vertex
                  >     drawhoop..........border of the surface
           while(notESC) cavekeybo.....done asynchronously from display
                           *deFault
           audioclean .................shut down audio server
           Exit........................shut down CAVE properly 
         ifCONS
           gluttery....................we use the GLUT library
              drawcons.................analogue to drawcave
                *drawstars
                *drawall 
                    drawsnail 
                      snailvert
                    drawhoop
          >>    messages...............analogue to graffiti
                  char2wall
                  speedometer..........unix based speedometer
          >>    keyboard.................GLUT distinguishes between ascii keys 
                *deFault
                *audioclean
              special_keybo............and other kinds of keys
              mousepushed..............mouse buttons were pressed
              mousemoved...............mouse was moved       
              reshaped.................what to do if window is reshaped
              idle.....................done when nothing else is being done 
                 chaptrack.............updates the two affine matrices 
                *autotymer.............updates the animation parameters
                *audiofunc.............updates the sound servers  
         endIF 
*/
#include <stdlib.h>
/*#include <sys/types.h>*/
#include <stdio.h>
#include <math.h>
#include <sys/time.h>
// #include <malloc.h>
#include <glut.h>

#ifdef SOUND
/* #include <device.h> */
#include <string.h>
#include "vssClient.h" 
#endif
#ifdef CAVE
#include <cave_ogl.h>
#include <cave.macros.h>
#endif 

#define cosf cos
#define sinf sin
#define fcos cos
#define fsin sin
#define fsqrt sqrt

#define WHICH 2  /* we think */
/* Examples of useful geometric macros, use inliners in C++ */
#define  MAX(x,y)         (((x)<(y))?(y):(x))
#define  MIN(x,y)         (((x)<(y))?(x):(y))
#define  FOR(a,b,c)       for((a)=(b);(a)<(c);(a)++)
#define  DOT(p,q)         ((p)[0]*(q)[0]+(p)[1]*(q)[1]+(p)[2]*(q)[2])
#define  NRM(p)           fsqrt(DOT((p),(p)))
#define  CLAMP(x,u,v) (x<u? u : (x>v ? v: x))

/******************chaptrail**********************************/
#define MAXTIE 5000   /* chaptrail is shorter than 5000 rungs */
#define TIEWIDTH   .05   
#define  MANY       8   /* before we lay a tie */
float trail[2*MAXTIE][3];
int  trailtie=0, trailmake=0, traildraw=0, trailwryte=0 ;  /* trail pointer */
//traildraw does nothing herein
float maxtie0=MAXTIE, maxtie, tiewidth0=TIEWIDTH, tiewidth;  //til args fixed
int  flying ; //very bad name for this, midbuttondown would be better
/******************chaptrail**********************************/

/* global variables ... add new ones on top of the stack */
char which[20]; /* audio needs this */
int delta; /* new variables for autotymer to change torus */
float gap0=1.; /* ... for letting arguments reset default gap value */
float speed0=.0005; /* ... for letting arguments reset default speed value */
float speed1=.005; /* ... for letting arguments reset default speed value */
float joy0=0; /* ...default navigator */ 
float siz0=5; /* ...default siz was 3 */ 
float wrist0= -0.3; /* wrist sensor displacement as it was  -.5*/
int audiohandle; /* for telling vss the name of the .aud file */
float lux[3]={1.,2.,3.};             /*light source direction vector        */
float lu[3];     /* this needs to be shared current light direction vector*/
float mysiz,speed, torq, focal, far; /*console navigation variables         */
int win = 2;                         /* full screen, use 0 for demand sized */
unsigned int BUT,XX,YY,SHIF;     /* used in chaptrack gluttery           */ 
int xt,yt;                       /* once was xt,yt,xm,ym for viewportery */
int caveyes=0;                      /* rename? ----------> caveflag */
int morph,msg,binoc;            /* pretty global */
/* note mode, alfa, beta, lima DO need to be shared to make autotymer right */ 

#define FLYMODE  (0)
#define TURNMODE (1) 

/*%%%%%%%%%%%%%%%%%%%%%%%%%%snailvars%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*/
static float dth,cdth, fdth, dta,cdta,fdta;
static float amb,pwr;
/*%%%%%%%%%%%%%%%%%%%%%%%%%%snailvars%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*/

// /*Shared memory variables as per Stuart Levy 1994 */  
// struct share_var{ 
   int mode ;           /* because drawhoop uses it to change color */
   float alfa ;           /* because autotymer changes these display vars */
   float beta ;
   float lima ;
   float one ;
   float two ;
   float tri ;
   float th0 ;           
   float th1 ;       
   float ta0 ;      
   float ta1 ;     
   float gap ;  
   int joy ;  
   float siz ;         /*final scaling factor before projection      */  
   int wnd;            /*wand or maus flag                           */
   int gnd;            /*background color                            */
   float wrist;          /* wrist displacement */
   float lu[3];         /* current light direction */ 
   int mauspaw ;      /*binary for mouse button state                     */
   GLfloat aff[16],starmat[16]; /*affine matrices for object, stars*/
// } *s_var; 
#if 0
#define mode    (s_var->s_mode)
#define alfa    (s_var->s_alfa)
#define beta    (s_var->s_beta)
#define lima    (s_var->s_lima)
#define one     (s_var->s_one)
#define two     (s_var->s_two)
#define tri     (s_var->s_tri)
#define th0     (s_var->s_th0)
#define th1     (s_var->s_th1)
#define ta0     (s_var->s_ta0)
#define ta1     (s_var->s_ta1)
#define gap     (s_var->s_gap)
#define joy     (s_var->s_joy)
#define siz     (s_var->s_siz)
#define wnd     (s_var->s_wnd)
#define gnd     (s_var->s_gnd)  /* use only if printframe function is present */
#define wrist   (s_var->s_wrist) 
#define lu      (s_var->s_lu )  /* else the right wall isn't specularized */
#define aff     (s_var->s_aff)  
#define starmat (s_var->s_starmat)
#define mauspaw (s_var->s_mauspaw)
#endif

/* these are used only in console mode      */
float nose;   /* to eye distance in console */

#if 0
void getmem(void){
  if(caveyes)
#ifdef CAVE
     s_var = CAVEMalloc(sizeof(struct share_var))
#endif
     ;
   else
     s_var = malloc(sizeof(struct share_var));
  if(s_var==NULL)
    {fprintf(stderr,"No room to share! %x \n",s_var); exit(1);}
}
#endif


/******************chaptrail**********************************/
void whereis3f(float xx, float yy, float zz, float *there){
   /* there = U'*(X-m) = affinv*X */
   xx -= aff[12] ; yy -= aff[13]; zz -= aff[14];
   there[0]=aff[0]*xx + aff[1]*yy + aff[2]*zz;
   there[1]=aff[4]*xx + aff[5]*yy + aff[6]*zz;
   there[2]=aff[8]*xx + aff[9]*yy + aff[10]*zz;
}
void maketrail(void){
    float right = tiewidth, left= -tiewidth;
    if(trailtie==maxtie)trailtie=0;
    whereis3f( right,0,0, trail[2*trailtie]);
    whereis3f(left, 0,0, trail[2*trailtie+1]);
    trailtie++;
}
void writetrail(void){
    int ii,jj ;
    FOR(ii,0,trailtie){
    FOR(jj,0,3)printf(" %.2g ", trail[2*ii][jj]);
    printf("\n");
    FOR(jj,0,3)printf(" %.2g ", trail[2*ii +1][jj]);
    printf("\n");
    }
    trailwryte=0;
}
void drawtrail(void){
    int ii;
    glColor3f(1.0,0.8,0.0);
    /* glBegin(GL_LINE_STRIP); */
    glBegin(GL_LINES);
    FOR(ii,0,trailtie-1){
    glVertex3f(trail[2*ii][0],  trail[2*ii][1],trail[2*ii][2]);
    glVertex3f(trail[2*ii+1][0],  trail[2*ii+1][1],trail[2*ii+1][2]);
    }
    glEnd();

}

/******************chaptrail**********************************/

void char2wall(GLfloat x,GLfloat y, GLfloat z, char buf[]){
     char *p; glRasterPos3f(x,y,z);
     for(p = buf;*p;p++) glutBitmapCharacter(
        caveyes? GLUT_BITMAP_TIMES_ROMAN_24:GLUT_BITMAP_9_BY_15 ,*p);
}

void autotymer(int);  /* to allow deFault to call the autotymer later */

void deFault(void){ int ii, jj; float tmp;
  flying =0; maxtie = maxtie0; tiewidth = tiewidth0;
  wrist = wrist0; /* originally +.5 feet */
  msg=1; binoc=0; nose=.06; mauspaw = 0; wnd = 1; siz = siz0; mode=TURNMODE;  
  speed=speed0; torq=.001; focal = 2.; far =13.; mysiz=.01; morph=0; 
  for(ii=0;ii<16;ii++)  starmat[ii]=aff[ii] = (ii/4==ii%4) ? 1 : 0;   
  tmp=NRM(lux);  for(ii=0;ii<3;ii++)lux[ii]/=tmp;
  if(caveyes){aff[12]=0; aff[13]= 5; aff[14]= -10.0 ;}/*5ft beyond front wall*/ 
       else{aff[12]=0; aff[13]= 0; aff[14]= -4.2; } /*inside the console */ 
  FOR(ii,0,2*MAXTIE)FOR(jj,0,3)trail[ii][jj]=0; trailtie=0;

/*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%snailstuff%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*/
   /* ftym = 0  is ok */
/* surface patch */
   alfa = 2; beta = 1; lima=0.; gap = gap0; joy=joy0;
   th0 = 90 ; th1 = 269; cdth=10; fdth= 6;
   ta0 = 90 ; ta1 = 270; cdta=10; fdta= 6;
   dta = fdta; dth = fdth;
/* initial quaternion */
   one = -45. ; two =0; tri =0.;
/*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%snailstuff%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*/
autotymer(1); /* reset autotymer to start at the beginning */
}

/*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%snailfrag%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*/

snailvert(float *vv, float th, float ta, int again )
{     float li, tw, tmp, tmp1, tmp2, pp[4]; int ii,jj;
      static first; static float C0, S0;
      static float C1, S1, C2, S2, C3, S3,lrp1,lrp2,lrp3;

#define  DG             M_PI/180.
#define  C(t)           fcos(t*DG)
#define  S(t)           fsin(t*DG)

      first = again;
      if(first){   /* these are constant for one full tope of the surface */
         first=0;
         C0=C(lima); S0=S(lima);  /*the trigs made a big difference */
         C1=C(one);  S1=S(one);
         C2=C(two);  S2=S(two);
         C3=C(tri);  S3=S(tri);
         lrp1 = (1.- .5*S(lima*2.))*(1. - .293*(one+45.)/(-45.) );
         lrp2 = (1. + .414*(one+45.)/(-45.) );
         lrp3 = (1. + .67*(one+45.)/(-45.) ); /*these algs didn't make any */
      }

      li  = C0 - S0*C(ta);             /* limaconic homotopy */
      pp[1]  = C(alfa*th)*C(ta)*li*lrp1;     /* Sudanese Moebius Band */
      pp[2]  = S(alfa*th)*C(ta)*li*lrp1;     /* Dan Asimov, ca 1980*/
      pp[3]  = C(beta*th)*S(ta)*li*lrp2;     /* Larry Siebenmann, 1982 */
      pp[0]  = S(beta*th)*S(ta)*li*lrp2;     /* Blaine Lawson, 1972 */

       tmp  = pp[0];  /*turn(pp,0,1,one),turn(pp,0,2,two),turn(pp,0,3,tri); */
       tmp1 = tmp  *C1 -  S1*pp[1];
       tmp2 = tmp1 *C2 -  S2*pp[2];
      pp[0] = tmp2 *C3 -  S3*pp[3];
      pp[1] = pp[1]*C1 +  S1*tmp  ;
      pp[2] = pp[2]*C2 +  S2*tmp1 ;
      pp[3] = pp[3]*C3 +  S3*tmp2 ;

      vv[0] =  pp[1]*lrp3*7./(10.+9.*pp[0]);  /* project from 4D to 3D */
      vv[1] =  pp[2]*lrp3*7./(10.+9.*pp[0]);
      vv[2] =  pp[3]*lrp3*7./(10.+9.*pp[0]);

}

drawsnail()
 {
  float th,ta; float vv[3], aa[3], vo[3], nn[3], lmb;
  float spec, dog, cat, rr, gg, bb ;

    snailvert(vo,th0,ta0,1);  /* first */
    for(th=th0; th < th1; th += dth)
     {
  /*  bgntmesh(); */ glBegin(GL_TRIANGLE_STRIP);
       snailvert(vo,th,ta0+dta,0);
     ta=ta0; while(1)
       {
       snailvert(vv,th,ta,0 ); /* normal on vo aa vv */
       snailvert(aa,th+dth-gap,ta,0);
       nn[0]=(aa[1]-vv[1])*(vo[2]-vv[2])-(aa[2]-vv[2])*(vo[1]-vv[1]);
       nn[1]=(aa[2]-vv[2])*(vo[0]-vv[0])-(aa[0]-vv[0])*(vo[2]-vv[2]);
       nn[2]=(aa[0]-vv[0])*(vo[1]-vv[1])-(aa[1]-vv[1])*(vo[0]-vv[0]);
       lmb = DOT(lu,nn)/NRM(nn); lmb = fabsf(lmb);

       spec = MIN(1, 1*(1-10+10*lmb));
        dog = (ta-ta0)/(float)(ta1-ta0); cat = (th-th0)/(float)(th1-th0);
         gg = MAX(lmb*dog                   ,spec);
         rr = MAX(lmb*(.25 + fabsf(cat -.5)),spec);
         bb = MAX(lmb*(1 - cat )            ,spec);
 /*RGBcolor((short)(255.*rr),(short)(255.*gg),(short)(255.*bb));*/ glColor3f( rr, gg, bb ); 
     
 /*  v3f(vv); v3f(aa); */ glVertex3fv(vv); glVertex3fv(aa);
        vo[0]=vv[0]; vo[1]=vv[1]; vo[2]=vv[2];
        if (ta >= ta1) break;
        ta += dta;
        if (ta > ta1) ta=ta1;
       } /* end while */
 /*   endtmesh(); */ glEnd();
    } /* end for theta */
}

drawhoop(float ta, float dt)
 { float yy, th, lmb,spec;
   static int imax;
   static float vv[3],aa[3],vo[3],nn[3];

  glBegin(GL_TRIANGLE_STRIP); 
     snailvert(vo,th0+dth,ta,1);
     for(th=th0;th<th1+dth; th += dth)
      {
      snailvert(vv,th,ta,0 );snailvert(aa,th,ta+dt,0);
      nn[0]=(aa[1]-vv[1])*(vo[2]-vv[2])-(aa[2]-vv[2])*(vo[1]-vv[1]);
      nn[1]=(aa[2]-vv[2])*(vo[0]-vv[0])-(aa[0]-vv[0])*(vo[2]-vv[2]);
      nn[2]=(aa[0]-vv[0])*(vo[1]-vv[1])-(aa[1]-vv[1])*(vo[0]-vv[0]);
      lmb = DOT(lu,nn)/NRM(nn);
      lmb = MAX(amb,fabsf(lmb));
      spec=MIN(1.,( 1. - pwr + pwr*lmb));
      yy = MAX(lmb, spec);  
      /* cpack( 0xff000000 + (yy<<(fly?8:16))+yy); /* lighted yellow or mag. */
      glColor3f( yy,(mode==FLYMODE)?yy:0,(mode==TURNMODE)?yy:0); 
      glVertex3fv(vv); glVertex3fv(aa); 
      vo[0]=vv[0]; vo[1]=vv[1]; vo[2]=vv[2];
      }
   glEnd(); 
}

void drawall(void){ drawtrail(); 
   if(gap!=6){ drawsnail(); drawhoop(ta0,-6); drawhoop(ta1,6);} 
}

/*%%%%%%%%%%%%%%%%%%%%%%%%%%%%end snailfrag %%%%%%%%%%%%%%%%%%%%%%%%%%%%*/


#if  0   /* blank out drawvert drawtorus drawall */

void drawvert(int th, int ta){  
/* exercise ... float all the angles for a smoother homotopy */ 
float lmb,spec,nn[3], dog, cat;
nn[0] = C(th)*C(ta); /* unit sphere vector */  
nn[1] = S(th)*C(ta);
nn[2] =       S(ta);
lmb = MAX(CLAMP(nn[0]*lu[0] + nn[1]*lu[1] + nn[2]*lu[2],0.,1.),.3);
spec = MIN(1, 1*(1-10+10*lmb));                    /* clamp spec below maximum       */
dog = (ta-ta0)/(float)(ta1-ta0); cat = (th-th0)/(float)(th1-th0);
glColor3f(MAX(lmb*dog,spec),                     /* map R^2(dog,cat)->R^3(RGBspace */
          MAX(lmb*(.25 + fabsf(cat -.5)),spec),  /* dog cat model of Hartman       */
          MAX(lmb*(1 - cat ),spec));             /* illiLight by Ray Idaszak 1989  */
glVertex3f(C(th) + .5*nn[0],S(th) + .5*nn[1],.5*nn[2]);
}

void drawtor(void){
int th, ta;
dth = (int)((th1-th0)/24);  /* 24  meridian strips */ 
dta = (int)((ta1-ta0)/24);  /* 24  triangle pairs per strip */
for(th=th0; th < th1; th += dth){
  glBegin(GL_TRIANGLE_STRIP);
  for(ta=ta0; ta < ta1; ta += dta){ drawvert(th,ta); drawvert(th+gap*dth,ta); }
  glEnd();
  }
}

void drawcube(void){ /* transfer from skel.c as an exercise  */ }

void drawall(void){  
     drawtrail();
     drawtor(); 
     drawcube(); 
}
#endif /* blankout torus */

#include "opengl_stars.c"
#if 0
void drawstars(void){
int i;
static float star[1000][3];
static int virgin=1;
if(virgin){
  int ii,jj;
  float fact;
  virgin=0;
  for(ii=0;ii<1000;ii++)
     {
     for(jj=0;jj<3;jj++) star[ii][jj] =   random()/(float)0x40000000-1.;
     if(caveyes){
           fact = 90./NRM(star[ii]);
           for(jj=0;jj<3;jj++) star[ii][jj] *= fact;
           }   
     }
  }
  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();
  glMultMatrixf(starmat);
  glColor3f(1.0,1.0,0.0);    
  glBegin(GL_POINTS);
    for(i=0;i<1000;i++) glVertex3fv(star[i]);
  glEnd();
  glPopMatrix();
  glClear(GL_DEPTH_BUFFER_BIT);
}
#endif
void audioprep(void){
#ifdef SOUND
   if (!FBgnSoundServer())
      fprintf(stderr,"UDP connection to sound server failed\n");
   else if ((audiohandle = AUDinit("noosh.aud")) == -1)
      fprintf(stderr,"Couldn't open noosh.aud\n");
#endif
}

#if 0
void dohoot(void) {strcpy(which,"hoot");}
void dotrump(void){strcpy(which,"trump");}
void doflute(void){strcpy(which,"flute");}
void dodrum(void) {strcpy(which,"drum");}
#endif

void audiofunc(void){
#ifdef SOUND 
#define LIRP(X,A,B,x,a,b)  (X = A + (x-a)*(B-A)/(b-a))
  static float freq=440., ampl=1., indx=20., cmra=2.; 
  static float data[4];
  static omode =0; static ofocal = 0;
  static beep =0;  /* the sound server */

  if(omode > mode){dohoot(); beep = 1;}
  if(omode < mode){dodrum(); beep = 1;}

  LIRP(freq, 440, 1760, th0,  10, 170); /* frequeny mimics th1 */ 
  LIRP(indx, 10, 1,  focal, .03, 2.0); /* index  mimics focal */ 
  if(ofocal != focal){dodrum(); beep = 1;}    /* there is an fp bug here */

if(beep){data[0] = freq;  /* pitch in Herz      */ 
          data[1] = ampl;  /* the sum of all amplitudes must be < 1.0 */ 
          data[2] = indx;    
          data[3] = cmra;
          AUDupdate(audiohandle, which, 4, data);  /* send message  to vss */ 
          beep = 0; 
}
  omode = mode;  ofocal = focal; 
#endif
}

void audioclean(void){
#ifdef SOUND
   AUDterminate(audiohandle);
   EndSoundServer();
#endif
}

void arguments(int argc,char **argv){
  extern char *optarg;
  extern int optind; 
  int chi;   
  /* w: needs ONE number after -w, c<nothing> means NO number follows*/ 
  while ((chi = getopt(argc,argv,"w:cd:g:i:s:")) != -1) 
  switch(chi)  {case 'c': caveyes=1; break;  
                case 'w': win=atoi(optarg); break; 
                case 'g': gap0=atof(optarg); break;
                case 'i': wrist0 = atof(optarg); break;
                case 's': siz0  = atof(optarg); break;
                }
  if (optind!=argc) fprintf(stderr,"%s: Incorrect usage\n",argv[0]);
}

void dataprep(void){
   audioprep();
  initstars(); 
   deFault();
}

void autotymer(int reset){
   #define  TYME(cnt,max,act) {static cnt; if(first)cnt=max; else\
                               if(cnt?cnt--:0){ act ; goto Break;}}
   static first = 1;  /* the first time autymer is called */
   if(reset)first=1;  /* or if it is reset to start over  */
  TYME( snl2mob,72, ta0++; ta1--) /*shrink snail to moebius*/
  TYME( mob2snl,72, ta0--; ta1++) /*grow moebius to snail*/
  TYME( snl2xcp,90, lima++ )      /*curlup to crosscap*/
  TYME( xcp2rom,45, one--)        /*swim to roman */
  TYME( romdwll,20,      )        /*dwell on roman */
  TYME( rom2xcp,45, one++)        /*swim from roman */
  TYME( xcp2snl,90, lima--)       /*uncurl from crosscap*/
  TYME( snl2mob,72, ta0++; ta1--) /*shrink to moebius */
  TYME( twist  ,100, beta += .01 ) /*twist to annulus ===== it doesnt do this*/
  TYME( ann2tor,66, ta0--; ta1++)  /*grow annulus to torus*/
  TYME( tordwll,20,       )        /*dwell on torus */
  TYME( tor2ann,66, ta0++; ta1--)  /*shrink from torus*/
  TYME( twist, 100, beta += .01 )  /*twist to moebius*/
  TYME( mob2box,66,ta0--; ta1++ )  /*grow to knotbox*/
  TYME( boxdwll,20,       )        /*dwell on knotbox*/
  TYME( box2mob,66,ta0++; ta1-- )  /*shrink0 from knotbox */
  TYME( untwist,200, beta -= .01 ) /*untwist all the way*/
  TYME( mob2snl,72, ta0--; ta1++)  /*grow to snail */
  TYME( snldwll,20,             )  /*dwell on snail */
  TYME(finish  , 1 , first = 1  )  /*da capo */
  first = 0;
  Break: ;                         /*yes Virginia, C has gotos */
}/*end autotymer*/


/*Beware of competing keys in CAVEsimulation and wnd==1   */
/* you may want to remap these keys to avoid the conflict */

void keyboard(unsigned char key, int x, int y){
#define  IF(K)            if(key==K)
#define  PRESS(K,A,b)     IF(K){b;}IF((K-32)){A;}  
/*was backwards in previous versions */
#define  TOGGLE(K,flg)    IF(K){(flg) = 1-(flg); }
#define  CYCLE(K,f,m)     PRESS((K), (f)=(((f)+(m)-1)%(m)),(f)=(++(f)%(m)))
#define  SLIDI(K,f,m,M)   PRESS(K,(--f<m?m:f), (++f>M?M:f))
#define  SLIDF(K,f,m,M,d) PRESS(K,((f -= d)<m?m:f), ((f += d)>M?M:f))
/* Only ASCII characters can be processes by this GLUT callback function */ 
   TOGGLE('v',binoc);                            /* cross-eyed STEREO   */
   TOGGLE('w',msg);                              /* writing on/off      */
   TOGGLE('h',morph);                            /* autotymer on/off    */
   PRESS('n', nose -= .001 , nose += .001 );     /* for binoculars      */
   CYCLE(' ', mode,TURNMODE+1);                  /* fly/turn modes      */
   PRESS('i', mysiz /= 1.1, mysiz *= 1.1)        /* rescale the world   */
   PRESS('o', focal *= 1.1 , focal /= 1.1)       /* telephoto           */
   PRESS('p', far *= 1.01 , far   /= 1.01)       /* rear clipping plane */
// PRESS('s',speed /= 1.02, speed *= 1.02);      /* flying speed        */
   PRESS('s',speed = speed0, speed=speed1);      /* flying speed        */
   PRESS('q',torq /= 1.02, torq *= 1.02);        /* turning speed       */
   PRESS('g',gap = gap0, gap = 6.0);             /* gap parameter       */
   // PRESS('g',gap /= .99, gap *= .99);             /* gap parameter       */
   PRESS('z', deFault(), deFault());             /* zap changes         */

   TOGGLE('t',trailmake);
   TOGGLE('d',traildraw); // does nothing for now
   TOGGLE('y',trailwryte);

   IF(27) {audioclean(); exit(0); }              /* ESC exit            */
}

void special_keybo(int key, int x, int y){
/*non-ASCII keypresses go here, if you're lucky enough to know their names */
 fprintf(stderr," non-ASCII character was pressed.\n");
 fprintf(stderr," use special_keybo() to process it\n");
}
/* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */
#ifdef CAVE
/* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */

void cavekeybo(void){
#define  CAVEIF(K)         if(CAVEgetbutton(K))
#define  CAVEPRESS(K,A,b)  CAVEIF(K){if(CAVEgetbutton(CAVE_LEFTSHIFTKEY)||\
                           CAVEgetbutton(CAVE_RIGHTSHIFTKEY)){b;}else{A;}}
#define  CAVETOGGLE(K,flg) CAVEIF(K){(flg) = 1-(flg); }
#define  CAVECYCLE(K,f,m)  CAVEPRESS((K),(f)=(((f)+(m)-1)%(m)),(f)=(++(f)%(m)) )
#define  CAVESLIDI(K,f,m,M)  CAVEPRESS(K,(--f<m?m:f), (++f>M?M:f))
#define  CAVESLIDF(K,f,m,M,d) CAVEPRESS(K,((f -= d)<m?m:f), ((f += d)>M?M:f))
  CAVEPRESS(CAVE_PKEY, far *= 1.01,   far   /= 1.01) /* rear clipping plane*/
  CAVEPRESS(CAVE_QKEY, speed /= 1.02, speed *= 1.02);/* flying speed       */
  CAVEPRESS(CAVE_RKEY, torq /= 1.02,  torq *= 1.02); /* turning speed      */
  CAVETOGGLE(CAVE_YKEY,wnd);                         /* mauspaw vs wandpaw */
/* not yet implemented */ 
   CAVEPRESS(CAVE_ZKEY, deFault(), deFault());        /* zap changes       */
}

void graffiti(void){             /* used to be called speedo  */
  char buf[256];                 /*messages written into here */ 
#define  LABEL3(x,y,z,W,u){sprintf(buf,(W),(u));char2wall(x,y,z,buf);}
  static float last=0.,fps;      /*for measuring time         */ 
  if(!CAVEMasterWall()) return;  /* USE CAVEMasterWall in papeBeta */
  if(floor(2.*(*CAVETime))>floor(2.*last)){  /* rationalize this */ 
     last=*CAVETime;
     fps=*CAVEFramesPerSecond;
     }
  if(mode==TURNMODE){
        glColor3f(1.,0.8,1.); /* bright MAGENTA */
        LABEL3(-3.8,1.,-5.0,\
          "(L)morph (M)mode (R)cycleJOY=%d \
          hold(M)click(L|R)resize hold(R)click(L|M)resize",joy);
        } else {
        glColor3f(1.,1.,0.);
        LABEL3(-3.8,1.0,-5.0,
          " (R)STEER %s (M)ode  hold(M)tractor \
 RESET = hold(M)click(R+L) ",\
 joy==3?" friz ":joy==2?" by thumb ": joy==1?" by gesture ": " not ");
        }
     LABEL3(-4.8,7.0,-5.0, "illiSnail  \
by Francis, Hartman & Chappell, (C) 1994..2003 U.Illinois %s","")
       LABEL3(-4.8,1.0,-5.0,"%5.1f fps",fps);
}

void cavetrack(void){
  float angle[3], posit[3];
  float azi,ele,rol,hx,hy,hz,wx,wy,wz;
  static float ohx,ohy,ohz;   /*old head position */
  static float owx,owy,owz;   /*old wand position */
  static int opaw = 0,paw, friz;

  if(!CAVEMasterDisplay()) return;  /* doit once per frame */
  paw = wnd ? (CAVEBUTTON1*2+CAVEBUTTON2)*2+CAVEBUTTON3 : mauspaw;
  /* old joy is gone */
  if(opaw!=2 && paw==2) mode = (mode+1)%(TURNMODE+1); /* click modes */
  if(mode==TURNMODE){   /* hold middle button and click right to shrink */
     if (opaw == 2 && paw == 3)siz /= 1.5;     /*shrink object */
     if (opaw == 2 && paw == 6)siz *= 1.5;     /* grow   object */
/*   if (opaw != 1 && paw == 1)friz = 1-friz;  /* parking option */
     if(opaw==1 && paw == 5)gap *= 1.2;  /* hold right and  */
     if(opaw==1 && paw == 3)gap /= 1.2;  /* +left -mid    */
     } 
  if (opaw != 4 && paw == 4)morph = 1-morph;/* shape changer */
  if(opaw==2 && paw == 7){ /* restart, the most useful feature */
     deFault(); ohx=ohy=ohz=0; owx=owy=owz=0;
     } 

  if(wnd){ 
/* HERE */
      CAVEGetSensorOrientation(CAVESENSOR(WHICH), CAVE_TRACKER_FRAME, angle);
      azi=angle[1]; ele=angle[0]; rol=angle[2];
    /* CAVEGetWandOrientation(azi,ele,rol);*/
      CAVEGetHead(hx,hy,hz);  /*position*/
      CAVEGetSensorPosition(CAVESENSOR(WHICH), CAVE_TRACKER_FRAME, posit);
      wx=posit[0]; wy=posit[1]; wz=posit[2];
    /* CAVEGetWand(wx,wy,wz);  /*position*/ 
      }
   else{  /* fix this for CAVE mouse flying */ 
      azi = .5*512; ele = .5*-512;
      } 
   glMatrixMode(GL_MODELVIEW); glPushMatrix(); glLoadIdentity();

   glTranslatef(ohx-hx,ohy-hy,ohz-hz); 
 if(mode==TURNMODE) glTranslatef(aff[12],aff[13],aff[14]);
   if(joy!=3){  /* joy==3 freezes */ 
      glRotatef(rol*(mode?torq:-torq),0.,0.,1.); 
      glRotatef(ele*-torq, 1.,0.,0.); 
      glRotatef(azi*-torq,0.,1.,0.);
      }

/**********************************************************************/
  if(opaw != 1 && paw == 1)joy = joy<3?joy+1:0;  /* easy joy */

  if(joy==2&&((fabsf(CAVE_JOYSTICK_Y)>.02)||(fabsf(CAVE_JOYSTICK_X)>.02)))
       glTranslatef(CAVE_JOYSTICK_X*speed,0.,CAVE_JOYSTICK_Y*speed);

  if(joy==1)glTranslatef((wx-hx)*speed*(mode==TURNMODE&&opaw==1&&paw==1), 
                       (wy-hy + 1.5 )*speed*(mode==TURNMODE&&opaw==1&&paw==1),
                       (-wz+hz + wrist)*speed); /* someday auto calibrate ? */
/**********************************************************************/
 
 if(opaw==2 && paw==2)glTranslatef(wx-owx, wy-owy, wz-owz); /*wand tractor */

 if(mode == TURNMODE) glTranslatef(-aff[12],-aff[13],-aff[14]);
   glMultMatrixf(aff); 
   glGetFloatv(GL_MODELVIEW_MATRIX,aff);

  {int ii,jj; for(ii=0;ii<3;ii++){ lu[ii]=0; /* calculite */
   for(jj=0;jj<3;jj++) lu[ii] += aff[ii*4+jj]*lux[jj];} }

   if(mode==FLYMODE && !friz) /*make the star matrix rotate*/
      {
      glLoadIdentity();
      glRotatef(rol*(mode?torq:-torq),0.,0.,1.); 
      glRotatef(ele*-torq,1.,0.,0.); 
      glRotatef(azi*-torq,0.,1.,0.);
      glMultMatrixf(starmat); 
      glGetFloatv(GL_MODELVIEW_MATRIX,starmat);
      }
   glPopMatrix();
   opaw=paw; ohx=hx; ohy=hy; ohz=hz;
             owx=wx; owy=wy; owz=wz;
   if(morph) autotymer(0);  /* advance autotymer */
   audiofunc();
}

void drawcaveinit(void){   /* kludge? needed why ? */  
   CAVEFar = 1000.;
   glClearColor(0.,0.,0.,0.);
   glClearDepth(1.);
}

void drawcave(void){
  float hx,hy,hz;
  glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
  drawstars();
  graffiti();
  CAVEGetHead(hx,hy,hz);
  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();
  glTranslatef(hx,hy,hz);
  glMultMatrixf(aff);
  glScalef(siz,siz,siz);
  drawall();
  glPopMatrix();
}
#endif   // ifdef CAVE

float speedometer(void){
double dbl; static double rate; static int ii=0;
static struct timezone notused; static struct timeval now, then;
   if(++ii % 8 == 0){  /* 8 times around measure time */
      gettimeofday(&now, &notused); /* elapsed time */
      dbl =  (double)(now.tv_sec - then.tv_sec)
         +(double)(now.tv_usec - then.tv_usec)/1000000;
      then = now;  rate = 8/dbl;
      }
   return((float)rate);
}
 
void messages(void){     
  char buf[256]; /* console messages are done differently from cave */
#define  LABEL2(x,y,W,u) {sprintf(buf,(W),(u));char2wall(x,y,0.,buf);}
  glMatrixMode(GL_PROJECTION); glPushMatrix(); glLoadIdentity();
  gluOrtho2D(0,3000,0,3000);
  glMatrixMode(GL_MODELVIEW); glPushMatrix(); glLoadIdentity();
      /*bull's eye*/
      if(mode==TURNMODE) glColor3f(0x22/255.,0x88/255.,0xdd/255.);
        else      glColor3f(.8,.8,.8);
      LABEL2(1500,1500,"%s","o");
      /* writings */
      if(mode==TURNMODE) glColor3f(1.,0.,1.);
        else      glColor3f(1.,1.,0.);
      LABEL2(80,80,"%4.1f fps",speedometer());
      LABEL2(80,2840,\
      "(ESC)ape (V)Binoc (MAUS2)Fore (BAR)Flymode %s (H)omotopy (W)riting",
             mode?"FLYING":"CONTROL");
      LABEL2(10,10,"illiSnail \
   by Francis, Bourd, Hartman & Chappell, U Illinois, 1995..1997 %s","");
      LABEL2(80,2770,"(N)ose   %0.3f",nose);
      LABEL2(80,2700,"(S)peed  %0.4f",speed);
      LABEL2(80,2630," tor(Q) %0.4f",torq);
      LABEL2(80,2560,"near clipper %g", mysiz*focal);
      LABEL2(80,2490,"f(O)cal factor %g",focal);
      LABEL2(80,2420,"my s(I)ze %.2g",mysiz);
      LABEL2(80,2350,"far cli(P)er= %.2g",far);
      LABEL2(80,2280,"(Z)ap %s","");
      LABEL2(80,2210,"(G)ap %.2g",gap);

      LABEL2(80,2000,"(t)railmake %d",trailmake);
      LABEL2(80,1930,"NOtrail(d)raw %d",traildraw);
      LABEL2(80,1860,"trailtie %d",trailtie);
      LABEL2(80,1790,"trailwr(y)te %d",trailwryte);

    glPopMatrix();
glMatrixMode(GL_PROJECTION); glPopMatrix();
} 

void chaptrack(int but,int xx,int yy,int shif){  
   long dx,dy; 
   dx = xx -.5*xt; dx = abs(dx)>1?dx:0;
   dy = yy -.5*yt; dy = abs(dy)>1?dy:0;

   glMatrixMode(GL_MODELVIEW); glPushMatrix(); glLoadIdentity();

   if(mode==TURNMODE) glTranslatef(aff[12],aff[13],aff[14]);
   glRotatef(dx*torq,0.,1.,0.); glRotatef(dy*torq,1.,0.,0.);
   if(but&(1<<GLUT_RIGHT_BUTTON ))glRotatef(shif?-10:-1,0.,0.,1.);
   if(but&(1<<GLUT_LEFT_BUTTON  ))glRotatef(shif?10:1,0.,0.,1.);
   if(mode==FLYMODE){
      glPushMatrix();
      glMultMatrixf(starmat);
      glGetFloatv(GL_MODELVIEW_MATRIX,starmat);
      glPopMatrix();
   }
   flying = 0;
   if(but&(1<<GLUT_MIDDLE_BUTTON)){ 
        glTranslatef(0.,0.,shif ? -speed : speed); flying =1; }
   if(mode==TURNMODE) glTranslatef(-aff[12],-aff[13],-aff[14]);
   glMultMatrixf(aff); 
   glGetFloatv(GL_MODELVIEW_MATRIX,aff);
   {int ii,jj; for(ii=0;ii<3;ii++){ lu[ii]=0; /* calculite */
          for(jj=0;jj<3;jj++) lu[ii] += aff[ii*4+jj]*lux[jj];}}
   glPopMatrix();
}

void reshaped(int xx, int yy){xt=xx ; yt=yy;}   /* what is this for ? */

void drawcons(void){  
  glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
  if(binoc) glViewport(0,yt/4,xt/2,yt/2);
  glMatrixMode(GL_PROJECTION); glLoadIdentity();
  glFrustum(-mysiz*xt/yt,mysiz*xt/yt,-mysiz,mysiz,mysiz*focal,far); 
  glMatrixMode(GL_MODELVIEW); glLoadIdentity();
  drawstars();
  glTranslatef(-binoc*nose,0.0,0.0);
  glMultMatrixf(aff);
  drawall();
  if(binoc){
    glViewport(xt/2,yt/4,xt/2,yt/2); 
    glMatrixMode(GL_MODELVIEW);
    glLoadIdentity();
    drawstars();
    glTranslatef(binoc*nose,0.0,0.0);
    glMultMatrixf(aff);
    drawall();
    }
  glViewport(0,0,xt,yt);
  if(msg) messages();
  glutSwapBuffers();
}

void idle(void){ /*do this when nothing else is happening*/
   static int doit = 0;
   doit = ++doit %  MANY;
   if(flying && trailmake && (doit==2))maketrail();
   if(trailwryte){printf("trail is "); writetrail(); }
   if(morph && (doit==2)) autotymer(0);  /* advance autotymer */ 
   glutPostRedisplay();  /*redraw the window*/
   chaptrack(BUT,XX,YY,SHIF);
   audiofunc();  
}

void mousepushed(int but,int stat,int x,int y){
  if(stat==GLUT_DOWN) BUT |= (1<<but);
  else BUT &= (-1 ^ (1<<but));  
  XX=x; YY=y; SHIF=(glutGetModifiers()==GLUT_ACTIVE_SHIFT)?1:0;
}

void mousemoved(int x,int y){  XX=x; YY=y; }

int main(int argc, char **argv){  
   arguments(argc,argv); 
   if(caveyes)
#ifdef CAVE
       CAVEConfigure(&argc, argv, NULL)
#endif
       ;
 //  getmem();
   dataprep();
 
   if(caveyes){
#ifdef CAVE
       CAVEInit(); /* Each wall is (part of) a forked process from here on.*/ 
       CAVEFrameFunction(cavetrack,0);  
       /*is restricted to MasterWall, so once per frame */
       CAVEInitApplication(drawcaveinit, 0); 
       CAVEDisplay(drawcave, 0);
       while(!CAVEgetbutton(CAVE_ESCKEY))
         {
         cavekeybo();  /* is asynchronous from display processes */ 
	 }
       audioclean();
       CAVEExit();
#endif
       ;}
     else{ /*console main*/
       glutInit(&argc, argv);
       glutInitDisplayMode(GLUT_DOUBLE|GLUT_DEPTH);
       switch(win)
         { case 0: break;
           case 1: glutInitWindowSize(640, 480);
                   glutInitWindowPosition(0,1024-480);
                   break;
           case 2: glutInitWindowPosition(0,0);
	           break;
         }
       glutCreateWindow("<* illiSkel in C/OpenGL/GLUT *>");
       if(win==2) glutFullScreen();
       glEnable(GL_DEPTH_TEST);
       glutDisplayFunc(drawcons);       
       glutKeyboardFunc(keyboard);
       glutSpecialFunc(special_keybo);
       glutMouseFunc(mousepushed);
       glutMotionFunc(mousemoved);       
       glutPassiveMotionFunc(mousemoved); 
       glutReshapeFunc(reshaped);
       glutIdleFunc(idle);             
       glutMainLoop();
       }
} 
