/*
 *  stonehenge.c
 *  schprel
 *
 *  Created by mflider on 2001-07-19.
 *  Copyright (c) 2001 Mark Flider. All rights reserved.
 *
 */

/*** initialize functions down here ***/

#ifdef __sgi
#include <glut.h>	/* SGI glut libs */
#else
#ifdef __MWERKS__
#include <glut.h>	/* MacOS 9 glut libs */
#else
#ifdef __LINUX
#include <GL/glut.h>
#else
#include <GLUT/glut.h>	/*OS X glut libs */
#endif
#endif
#endif

#include <stdio.h>
#include <stdlib.h>

unsigned long 	texture[1];


void LoadGLTextures(void)
{ /*
    GLTXimage *texture1;
    
    texture1 = gltxReadRGB("tim.sgi"); //Load our texture data
        
    glPixelStorei(GL_UNPACK_ALIGNMENT,   1   );
	
    glTexImage2D(GL_TEXTURE_2D, 			//target 
                    0, 					//level
                    GL_RGB, 				//internalFormat
                    texture1->width, 			//w
                    texture1->height,			//h
                    0, 					//border
                    GL_RGB, GL_UNSIGNED_BYTE, 		//format,type
                    texture1->data);			//data

    glGenTextures(1, &texture[0]);
    glBindTexture(GL_TEXTURE_2D, texture[0]);
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);

    glTexImage2D(GL_TEXTURE_2D, 0, 3, 
                texture1->width, texture1->height, 0, 
                GL_RGB, GL_UNSIGNED_BYTE, texture1->data);


    gltxDelete(texture1); */
}

void initGL(void)
{
#ifdef __sgi
      /*  LoadGLTextures();
        glEnable(GL_TEXTURE_2D); *//* For texturing */
        glEnable(GL_LINE_SMOOTH);
        glHint(GL_LINE_SMOOTH_HINT,GL_NICEST);
        glEnable(GL_BLEND);
        glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);
#endif
}

void initall ()
{
   wVert=0;
   for (vez=-25;vez<=25;vez++)  /* initialize floor matrix */
   for (vex=-25;vex<=25;vex++)
   if ((int)vex % 5 == 0 || (int)vez % 5 == 0)
        {
        flod[wVert][0] = vex;
        flod[wVert][1] = -5;
	flod[wVert][2] = vez;
        wVert++;
        }
   for (aa=0;aa<1001;aa++)
   for (bb=0;bb<3;bb++)
	flodraw[aa][bb] = flod[aa][bb];

   for (aa=0;aa<11;aa++) {     /* init pillars matrix */
      wVert=0;
      for (vey=0;vey<10;vey++)
      for (vex=-.25;vex<=.25;vex+=.5)
      for (vez=-.25;vez<=.25;vez+=.5)
      {
         pillars[aa][wVert][0] = vex-25;
         pillars[aa][wVert][1] = vey-5;
         pillars[aa][wVert][2] = vez-25+aa*5;
         wVert++;
      }
   }
   for (aa=0;aa<11;aa++)
   for (bb=0;bb<40;bb++)
   for (dd=0;dd<3;dd++)
      pilldraw[aa][bb][dd] = pillars[aa][bb][dd];


   vey = 0;		/* init trit, trib matrices */
   aa=0;
   for (bb=-2;bb<=2;bb++)
   for (dd=-2;dd<=2;dd++)
   {
      if ( fabs(bb)==2 || fabs(dd)==2 )
      {
         trib[aa][0][0] = bb;
         trib[aa][0][1] = -4.9;
         trib[aa][0][2] = dd;
         wVert=1;
         for (vex=-.09;vex<=.09;vex+=.18)
         for (vez=-.09;vez<=.09;vez+=.18)
         {
            trib[aa][wVert][0] = vex+bb;
            trib[aa][wVert][1] = -5;
            trib[aa][wVert][2] = vez+dd;
            wVert++;
         }
         aa++;
      }
   }

   for (aa=0;aa<16;aa++)
   for (wVert=0;wVert<5;wVert++)
   {
      trit[aa][wVert][0] = trib[aa][wVert][0];
      trit[aa][wVert][1] = -1.0-trib[aa][wVert][1];
      trit[aa][wVert][2] = trib[aa][wVert][2];
   }
   for (aa=0;aa<16;aa++)
   for (wVert=0;wVert<5;wVert++)
   for (bb=0;bb<3;bb++)
   {
      tribdraw[aa][wVert][bb] = trib[aa][wVert][bb];
      tritdraw[aa][wVert][bb] = trit[aa][wVert][bb];
   }

   for (aa=0;aa<16;aa++)		/* init beam matrix */
   {
   wVert = 0;
   for (vey = tribdraw[aa][0][1];vey<=tritdraw[aa][0][1];vey+=(tritdraw[aa][0][1]-tribdraw[aa][0][1])/29)
      {
         beamdraw[aa][wVert][0] = beam[aa][wVert][0] = tribdraw[aa][0][0];
         beamdraw[aa][wVert][1] = beam[aa][wVert][1] = vey;
         beamdraw[aa][wVert][2] = beam[aa][wVert][2] = tribdraw[aa][0][2];
         wVert++;
      }
   }

/* head: */
   self[0][0] = -.2347; self[0][1] = 5.5432; self[0][2] = -.2856;
   self[1][0] = -.2347; self[1][1] = 5.5432; self[1][2] = 0.1167;
   self[2][0] = 0.2347; self[2][1] = 5.5432; self[2][2] = 0.1167;
   self[3][0] = 0.2347; self[3][1] = 5.5432; self[3][2] = -.2856;
   self[4][0] = -.1509; self[4][1] = 4.9230; self[4][2] = -.2856;
   self[5][0] = -.2179; self[5][1] = 5.2247; self[5][2] = 0.1167;
   self[6][0] = 0.2179; self[6][1] = 5.2247; self[6][2] = 0.1167;
   self[7][0] = 0.1509; self[7][1] = 4.9230; self[7][2] = -.2856;
/* upper torso: */   
   self[8][0]  = -.4506; self[8][1]  = 4.5423; self[8][2]  = -.2236;
   self[9][0]  = -.4506; self[9][1]  = 4.5423; self[9][2]  = 0.3172;
   self[10][0] = 0.4506; self[10][1] = 4.5423; self[10][2] = 0.3172;
   self[11][0] = 0.4506; self[11][1] = 4.5423; self[11][2] = -.2236;
   self[12][0] = -.3966; self[12][1] = 3.7492; self[12][2] = -.2596;
   self[13][0] = -.3966; self[13][1] = 3.7492; self[13][2] = 0.2811;
   self[14][0] = 0.3966; self[14][1] = 3.7492; self[14][2] = 0.2811;
   self[15][0] = 0.3966; self[15][1] = 3.7492; self[15][2] = -.2596;
/* lower torso: */   
   self[16][0] = -.3605; self[16][1] = 3.3527; self[16][2] = -.2056;
   self[17][0] = -.3605; self[17][1] = 3.3527; self[17][2] = 0.2270;
   self[18][0] = 0.3605; self[18][1] = 3.3527; self[18][2] = 0.2270;
   self[19][0] = 0.3605; self[19][1] = 3.3527; self[19][2] = -.2056;
   self[20][0] = -.3605; self[20][1] = 2.9561; self[20][2] = -.2056;
   self[21][0] = -.3605; self[21][1] = 2.9561; self[21][2] = 0.2270;
   self[22][0] = 0.3605; self[22][1] = 2.9561; self[22][2] = 0.2270;
   self[23][0] = 0.3605; self[23][1] = 2.9561; self[23][2] = -.2056;
/* upper right arm */   
   self[24][0] = 0.5223; self[24][1] = 4.5468; self[24][2] = -.0974;
   self[25][0] = 0.5223; self[25][1] = 4.5468; self[25][2] = 0.1549;
   self[26][0] = 0.7348; self[26][1] = 4.5005; self[26][2] = 0.1549;
   self[27][0] = 0.7348; self[27][1] = 4.5005; self[27][2] = -.0974;
   self[28][0] = 0.6656; self[28][1] = 3.7106; self[28][2] = -.0974;
   self[29][0] = 0.6656; self[29][1] = 3.7106; self[29][2] = 0.1549;
   self[30][0] = 0.9141; self[30][1] = 3.7544; self[30][2] = 0.1549;
   self[31][0] = 0.9141; self[31][1] = 3.7544; self[31][2] = -.0974;
/* lower right arm */   
   self[32][0] = 0.6875; self[32][1] = 3.5961; self[32][2] = -.1094;
   self[33][0] = 0.6875; self[33][1] = 3.4084; self[33][2] = 0.0079;
   self[34][0] = 0.9005; self[34][1] = 3.4283; self[34][2] = 0.0398;
   self[35][0] = 0.9005; self[35][1] = 3.6160; self[35][2] = -.0775;
   self[36][0] = 0.7994; self[36][1] = 3.2959; self[36][2] = -.5430;
   self[37][0] = 0.7994; self[37][1] = 3.1262; self[37][2] = -.4437;
   self[38][0] = 0.9764; self[38][1] = 3.1461; self[38][2] = -.4118;
   self[39][0] = 0.9764; self[39][1] = 3.3158; self[39][2] = -.5111;
/* right hand */   
   self[40][0] = 0.7291; self[40][1] = 3.3184; self[40][2] = -.7041;
   self[41][0] = 0.7291; self[41][1] = 3.0500; self[41][2] = -.5364;
   self[42][0] = 1.0132; self[42][1] = 3.0765; self[42][2] = -.4940;
   self[43][0] = 1.0132; self[43][1] = 3.3449; self[43][2] = -.6617;
   self[44][0] = 0.7824; self[44][1] = 3.1584; self[44][2] = -.9601;
   self[45][0] = 0.7824; self[45][1] = 2.8900; self[45][2] = -.7923;
   self[46][0] = 1.0664; self[46][1] = 2.9166; self[46][2] = -.7499;
   self[47][0] = 1.0664; self[47][1] = 3.1850; self[47][2] = -.9176;
/* right thigh */   
   self[48][0] = 0.1622; self[48][1] = 2.8119; self[48][2] = -.2416;
   self[49][0] = 0.1622; self[49][1] = 2.8119; self[49][2] = 0.2451;
   self[50][0] = 0.5047; self[50][1] = 2.8119; self[50][2] = 0.2451;
   self[51][0] = 0.5047; self[51][1] = 2.8119; self[51][2] = -.2416;
   self[52][0] = 0.2343; self[52][1] = 1.7304; self[52][2] = -.2777;
   self[53][0] = 0.2343; self[53][1] = 1.7304; self[53][2] = 0.1549;
   self[54][0] = 0.5227; self[54][1] = 1.7304; self[54][2] = 0.1549;
   self[55][0] = 0.5227; self[55][1] = 1.7304; self[55][2] = -.2777;
/* right shin */    
   self[56][0] = 0.2163; self[56][1] = 1.5862; self[56][2] = -.2056;
   self[57][0] = 0.2163; self[57][1] = 1.5862; self[57][2] = 0.2090;
   self[58][0] = 0.5948; self[58][1] = 1.5862; self[58][2] = 0.2090;
   self[59][0] = 0.5948; self[59][1] = 1.5862; self[59][2] = -.2056;
   self[60][0] = 0.3425; self[60][1] = 0.4867; self[60][2] = -.2056;
   self[61][0] = 0.3425; self[61][1] = 0.4867; self[61][2] = 0.2090;
   self[62][0] = 0.5768; self[62][1] = 0.4867; self[62][2] = 0.2090;
   self[63][0] = 0.5768; self[63][1] = 0.4867; self[63][2] = -.2056;
/* right foot */   
   self[64][0] = 0.3605; self[64][1] = 0.3425; self[64][2] = 0.1910;
   self[65][0] = 0.3064; self[65][1] = 0.0180; self[65][2] = 0.1910;
   self[66][0] = 0.7390; self[66][1] = 0.0180; self[66][2] = 0.1910;
   self[67][0] = 0.6489; self[67][1] = 0.3425; self[67][2] = 0.1910;
   self[68][0] = 0.3064; self[68][1] = 0.1442; self[68][2] = -.5661;
   self[69][0] = 0.3064; self[69][1] = 0.0180; self[69][2] = -.6382;
   self[70][0] = 0.7390; self[70][1] = 0.0180; self[70][2] = -.6382;
   self[71][0] = 0.7390; self[71][1] = 0.0721; self[71][2] = -.5661;
/* upper left arm */   
   self[72][0] = -1.0*self[24][0]; self[72][1] = self[24][1]; self[72][2] = self[24][2];
   self[73][0] = -1.0*self[25][0]; self[73][1] = self[25][1]; self[73][2] = self[25][2];   
   self[74][0] = -1.0*self[26][0]; self[74][1] = self[26][1]; self[74][2] = self[26][2];
   self[75][0] = -1.0*self[27][0]; self[75][1] = self[27][1]; self[75][2] = self[27][2];
   self[76][0] = -1.0*self[28][0]; self[76][1] = self[28][1]; self[76][2] = self[28][2];
   self[77][0] = -1.0*self[29][0]; self[77][1] = self[29][1]; self[77][2] = self[29][2];
   self[78][0] = -1.0*self[30][0]; self[78][1] = self[30][1]; self[78][2] = self[30][2];
   self[79][0] = -1.0*self[31][0]; self[79][1] = self[31][1]; self[79][2] = self[31][2];
/* lower left arm */
   self[80][0] = -1.0*self[32][0]; self[80][1] = self[32][1]; self[88][2] = self[32][2];
   self[81][0] = -1.0*self[33][0]; self[81][1] = self[33][1]; self[89][2] = self[33][2];   
   self[82][0] = -1.0*self[34][0]; self[82][1] = self[34][1]; self[82][2] = self[34][2];
   self[83][0] = -1.0*self[35][0]; self[83][1] = self[35][1]; self[83][2] = self[35][2];   
   self[84][0] = -1.0*self[36][0]; self[84][1] = self[36][1]; self[84][2] = self[36][2];
   self[85][0] = -1.0*self[37][0]; self[85][1] = self[37][1]; self[85][2] = self[37][2];
   self[86][0] = -1.0*self[38][0]; self[86][1] = self[38][1]; self[86][2] = self[38][2];
   self[87][0] = -1.0*self[39][0]; self[87][1] = self[39][1]; self[87][2] = self[39][2];
/* left hand */
   self[88][0] = -1.0*self[40][0]; self[88][1] = self[40][1]; self[88][2] = self[40][2];
   self[89][0] = -1.0*self[41][0]; self[89][1] = self[41][1]; self[89][2] = self[41][2];
   self[90][0] = -1.0*self[42][0]; self[90][1] = self[42][1]; self[90][2] = self[42][2];
   self[91][0] = -1.0*self[43][0]; self[91][1] = self[43][1]; self[91][2] = self[43][2];   
   self[92][0] = -1.0*self[44][0]; self[92][1] = self[44][1]; self[92][2] = self[44][2];
   self[93][0] = -1.0*self[45][0]; self[93][1] = self[45][1]; self[93][2] = self[45][2];   
   self[94][0] = -1.0*self[46][0]; self[94][1] = self[46][1]; self[94][2] = self[46][2];
   self[95][0] = -1.0*self[47][0]; self[95][1] = self[47][1]; self[95][2] = self[47][2];
/* left thigh */   
   self[96][0]  = -1.0*self[48][0]; self[96][1]  = self[48][1]; self[96][2]  = self[48][2];
   self[97][0]  = -1.0*self[49][0]; self[97][1]  = self[49][1]; self[97][2]  = self[49][2];
   self[98][0]  = -1.0*self[50][0]; self[98][1]  = self[50][1]; self[98][2]  = self[50][2];
   self[99][0]  = -1.0*self[51][0]; self[99][1]  = self[51][1]; self[99][2]  = self[51][2];
   self[100][0] = -1.0*self[52][0]; self[100][1] = self[52][1]; self[100][2] = self[52][2];
   self[101][0] = -1.0*self[53][0]; self[101][1] = self[53][1]; self[101][2] = self[53][2];   
   self[102][0] = -1.0*self[54][0]; self[102][1] = self[54][1]; self[102][2] = self[54][2];
   self[103][0] = -1.0*self[55][0]; self[103][1] = self[55][1]; self[103][2] = self[55][2];
/* left shin */   
   self[104][0] = -1.0*self[56][0]; self[104][1] = self[56][1]; self[104][2] = self[56][2];
   self[105][0] = -1.0*self[57][0]; self[105][1] = self[57][1]; self[105][2] = self[57][2];
   self[106][0] = -1.0*self[58][0]; self[106][1] = self[58][1]; self[106][2] = self[58][2];
   self[107][0] = -1.0*self[59][0]; self[107][1] = self[59][1]; self[107][2] = self[59][2];
   self[108][0] = -1.0*self[60][0]; self[108][1] = self[60][1]; self[108][2] = self[60][2];
   self[109][0] = -1.0*self[61][0]; self[109][1] = self[61][1]; self[109][2] = self[61][2];
   self[110][0] = -1.0*self[62][0]; self[110][1] = self[62][1]; self[110][2] = self[62][2];
   self[111][0] = -1.0*self[63][0]; self[111][1] = self[63][1]; self[111][2] = self[63][2];
/* left foot */      
   self[112][0] = -1.0*self[64][0]; self[112][1] = self[64][1]; self[112][2] = self[64][2];
   self[113][0] = -1.0*self[65][0]; self[113][1] = self[65][1]; self[113][2] = self[65][2];
   self[114][0] = -1.0*self[66][0]; self[114][1] = self[66][1]; self[114][2] = self[66][2];
   self[115][0] = -1.0*self[67][0]; self[115][1] = self[67][1]; self[115][2] = self[67][2];
   self[116][0] = -1.0*self[68][0]; self[116][1] = self[68][1]; self[116][2] = self[68][2];
   self[117][0] = -1.0*self[69][0]; self[117][1] = self[69][1]; self[117][2] = self[69][2];
   self[118][0] = -1.0*self[70][0]; self[118][1] = self[70][1]; self[118][2] = self[70][2];
   self[119][0] = -1.0*self[71][0]; self[119][1] = self[71][1]; self[119][2] = self[71][2];

   for (aa=0; aa<HOW_FAR_BACK; aa++)
   for (bb=0; bb<3; bb++)
      selfPosition[aa][bb] = 0;


      
   initGL();
}


/***** --- draw functions down here --*****/

void drawfloor(void){

float color;

if(highquality)	color = 1.;
else		color = .1;

   for (aa=0;aa<1001;aa+=95)
   {
      glBegin(GL_LINE_STRIP);
      glColor4f(0,color/2+.5,color/2+.5,1);
      for (wVert=aa;wVert<51+aa;wVert++)
         glVertex3f(flodraw[wVert][0],flodraw[wVert][1]+.01,flodraw[wVert][2]);
      glEnd();
   }
   for (aa=0;aa<51;aa+=5)
   {
      glBegin(GL_LINE_STRIP);
      glColor4f(0,color/2+.5,color/2+.5,1);
         glVertex3f(flodraw[aa][0],flodraw[aa][1]+.01,flodraw[aa][2]);
      for (bb=51+aa/5;bb<1001;bb+=95)
      {
      for (wVert=bb;wVert<11*4+bb;wVert+=11)
         glVertex3f(flodraw[wVert][0],flodraw[wVert][1]+.01,flodraw[wVert][2]);
      glVertex3f(flodraw[wVert+aa/5*4][0],flodraw[wVert+aa/5*4][1]+.01,flodraw[wVert+aa/5*4][2]);
      }
      glEnd();
   }

if(highquality)
{
   for (dd=0;dd<950;dd+=95)
   for (aa=dd;aa<dd+50;aa+=5)
   {
      glBegin(GL_TRIANGLE_STRIP);
      glColor4f(0,color,color,.2);
      wVert=aa+1;
         glVertex3fv(flodraw[aa]);
      for (bb=aa+51-(aa-dd)/5*4;bb<aa+85-(aa-dd)/5*4;bb+=11)
      {
         glVertex3fv(flodraw[wVert]);
         glVertex3fv(flodraw[bb]);
         wVert++;
      }
      glVertex3fv(flodraw[wVert]);
      glVertex3fv(flodraw[aa+95]);
      glEnd();

      glBegin(GL_TRIANGLE_STRIP);
      glColor4f(0,color,color,.2);
      wVert=aa+95;
         glVertex3fv(flodraw[aa+5]);
      for (bb=aa+56-(aa+5-dd)/5*4;bb<aa+90-(aa+5-dd)/5*4;bb+=11)
      {
         glVertex3fv(flodraw[wVert]);
         glVertex3fv(flodraw[bb]);
         wVert++;
      }
      glVertex3fv(flodraw[wVert]);
      glVertex3fv(flodraw[aa+100]);
      glEnd();
   }
}
}

void drawceiling(void){

float color;

if(highquality)
{
        glEnable(GL_LINE_SMOOTH);
        glEnable(GL_BLEND);
        glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);
        glHint(GL_LINE_SMOOTH_HINT,GL_DONT_CARE);

        color = 1.;
}
else		color = .1;

   for (aa=0;aa<1001;aa+=95)
   {
      glBegin(GL_LINE_STRIP);
      glColor4f(0,color/4+.25,color/2+.5,1);
      for (wVert=aa;wVert<51+aa;wVert++)
         glVertex3f(ceidraw[wVert][0],ceidraw[wVert][1]-.01,ceidraw[wVert][2]);
      glEnd();
   }
   for (aa=0;aa<51;aa+=5)
   {
      glBegin(GL_LINE_STRIP);
      glColor4f(0,color/4+.25,color/2+.5,1);
         glVertex3f(ceidraw[aa][0],ceidraw[aa][1]-.01,ceidraw[aa][2]);
      for (bb=51+aa/5;bb<1001;bb+=95)
      {
      for (wVert=bb;wVert<11*4+bb;wVert+=11)
         glVertex3f(ceidraw[wVert][0],ceidraw[wVert][1]-.01,ceidraw[wVert][2]);
      glVertex3f(ceidraw[wVert+aa/5*4][0],ceidraw[wVert+aa/5*4][1]-.01,ceidraw[wVert+aa/5*4][2]);
      }
      glEnd();
   }

if(highquality)
{
   for (dd=0;dd<950;dd+=95)
   for (aa=dd;aa<dd+50;aa+=5)
   {
      glBegin(GL_TRIANGLE_STRIP);
      glColor4f(0,color/2,color,.1);
      wVert=aa+1;
         glVertex3fv(ceidraw[aa]);
      for (bb=aa+51-(aa-dd)/5*4;bb<aa+85-(aa-dd)/5*4;bb+=11)
      {
         glVertex3fv(ceidraw[wVert]);
         glVertex3fv(ceidraw[bb]);
         wVert++;
      }
      glVertex3fv(ceidraw[wVert]);
      glVertex3fv(ceidraw[aa+95]);
      glEnd();

      glBegin(GL_TRIANGLE_STRIP);
      glColor4f(0,color/2,color,.1);
      wVert=aa+95;
         glVertex3fv(ceidraw[aa+5]);
      for (bb=aa+56-(aa+5-dd)/5*4;bb<aa+90-(aa+5-dd)/5*4;bb+=11)
      {
         glVertex3fv(ceidraw[wVert]);
         glVertex3fv(ceidraw[bb]);
         wVert++;
      }
      glVertex3fv(ceidraw[wVert]);
      glVertex3fv(ceidraw[aa+100]);
      glEnd();
   }
}
}

void drawpillars(void) {

for (aa=0;aa<11;aa++) {

   glColor3f(1,1,1);
   for (bb=0;bb<4;bb++) {
      glBegin(GL_LINE_STRIP);
         for (wVert=bb;wVert<40;wVert+=4)
            glVertex3fv(pilldraw[aa][wVert]);
      glEnd();
   }

   glColor3f(.5,.25,0);
   glBegin(GL_TRIANGLE_STRIP);
      for (wVert=0;wVert<40;wVert+=4) {
         glVertex3fv(pilldraw[aa][wVert]);
	 glVertex3fv(pilldraw[aa][wVert+1]);
      }
   glEnd();
   glColor3f(.75,.375,.25);
   glBegin(GL_TRIANGLE_STRIP);
      for (wVert=0;wVert<40;wVert+=4) {
         glVertex3fv(pilldraw[aa][wVert]);
         glVertex3fv(pilldraw[aa][wVert+2]);
      }
   glEnd();
   glColor3f(1,.5,0);
   glBegin(GL_TRIANGLE_STRIP);
      for (wVert=3;wVert<40;wVert+=4) {
         glVertex3fv(pilldraw[aa][wVert]);
         glVertex3fv(pilldraw[aa][wVert-1]);
      }
   glEnd();
   glColor3f(.75,.375,.25);
   glBegin(GL_TRIANGLE_STRIP);
      for (wVert=3;wVert<40;wVert+=4) {
         glVertex3fv(pilldraw[aa][wVert]);
         glVertex3fv(pilldraw[aa][wVert-2]);
      }
   glEnd();
}
}



void drawtris(void) {

for (aa=0;aa<16;aa++)
{
if (highquality)
{
   glColor4f(1,1,1,1);
   glBegin(GL_LINE_STRIP);
      glVertex3fv(tribdraw[aa][1]);
      glVertex3fv(tribdraw[aa][2]);
      glVertex3fv(tribdraw[aa][0]);
      glVertex3fv(tribdraw[aa][3]);
      glVertex3fv(tribdraw[aa][4]);
   glEnd();
   glBegin(GL_LINE_STRIP);
      glVertex3fv(tribdraw[aa][1]);
      glVertex3fv(tribdraw[aa][3]);
      glVertex3fv(tribdraw[aa][0]);
      glVertex3fv(tribdraw[aa][2]);
      glVertex3fv(tribdraw[aa][4]);
   glEnd();

   glBegin(GL_LINE_STRIP);
      glVertex3fv(tritdraw[aa][1]);
      glVertex3fv(tritdraw[aa][2]);
      glVertex3fv(tritdraw[aa][0]);
      glVertex3fv(tritdraw[aa][3]);
      glVertex3fv(tritdraw[aa][4]);
   glEnd();
   glBegin(GL_LINE_STRIP);
      glVertex3fv(tritdraw[aa][1]);
      glVertex3fv(tritdraw[aa][3]);
      glVertex3fv(tritdraw[aa][0]);
      glVertex3fv(tritdraw[aa][2]);
      glVertex3fv(tritdraw[aa][4]);
   glEnd();
}
   glColor4f(.5,1,.2,1);
   glBegin(GL_TRIANGLE_FAN);
      glVertex3fv(tribdraw[aa][0]);
      glVertex3fv(tribdraw[aa][1]);
      glVertex3fv(tribdraw[aa][2]);
      glVertex3fv(tribdraw[aa][4]);
      glVertex3fv(tribdraw[aa][3]);
      glVertex3fv(tribdraw[aa][1]);
   glEnd();

   glColor4f(.5,.2,1,1);
   glBegin(GL_TRIANGLE_FAN);
      glVertex3fv(tritdraw[aa][0]);
      glVertex3fv(tritdraw[aa][1]);
      glVertex3fv(tritdraw[aa][2]);
      glVertex3fv(tritdraw[aa][4]);
      glVertex3fv(tritdraw[aa][3]);
      glVertex3fv(tritdraw[aa][1]);
   glEnd();

}
}


void drawbeams(void){

for (aa=0;aa<16;aa++)
   {
   glColor4f(1,1-((float)aa)/20.0,1-16.0/20.0+((float)aa)/20.0,1);
   glBegin(GL_LINE_STRIP);
   for (bb=0;bb<30;bb++)
      glVertex3fv(beamdraw[aa][bb]);
   glEnd();
   }
}

void drawSelf(void){
float transp=1;
if(highquality) transp = .5;

	glColor4f(1,0,0,transp);
      
      for (aa=0; aa<119; aa+=8)
      {
      
	  glBegin(GL_TRIANGLE_FAN);
           glVertex3fv(selfdraw[aa+0]);
           glVertex3fv(selfdraw[aa+1]);
           glVertex3fv(selfdraw[aa+2]);
           glVertex3fv(selfdraw[aa+3]);
           glVertex3fv(selfdraw[aa+7]);
           glVertex3fv(selfdraw[aa+4]);
           glVertex3fv(selfdraw[aa+5]);
           glVertex3fv(selfdraw[aa+1]);
        glEnd();
        
        glBegin(GL_TRIANGLE_FAN);
           glVertex3fv(selfdraw[aa+6]);
           glVertex3fv(selfdraw[aa+7]);
           glVertex3fv(selfdraw[aa+3]);
           glVertex3fv(selfdraw[aa+2]);
           glVertex3fv(selfdraw[aa+1]);
           glVertex3fv(selfdraw[aa+5]);
           glVertex3fv(selfdraw[aa+4]);
           glVertex3fv(selfdraw[aa+7]);
        glEnd();
      }
      
      /*
        glColor4f(1,1,1,transp);
        glBegin(GL_LINES);
           glVertex3f(selfdraw[0][0],selfdraw[0][1],selfdraw[0][2]);
           glVertex3f(selfdraw[2][0],selfdraw[2][1],selfdraw[2][2]);
           glVertex3f(selfdraw[3][0],selfdraw[3][1],selfdraw[3][2]);
        glEnd();

        glColor4f(1,.2,.2,transp);
        glBegin(GL_TRIANGLES);
           glVertex3f(selfdraw[0][0],selfdraw[0][1],selfdraw[0][2]);
           glVertex3f(selfdraw[3][0],selfdraw[3][1],selfdraw[3][2]);
           glVertex3f(selfdraw[1][0],selfdraw[1][1],selfdraw[1][2]);
	glEnd();
      */
}

void drawSelfPositionLine(void)
{

      glBegin(GL_POINTS);      

      for (aa=0; aa < HOW_FAR_BACK; aa++)
      {
         glColor3f(1-(float)aa/(float)HOW_FAR_BACK,1-(float)aa/(float)HOW_FAR_BACK,1-(float)aa/(float)HOW_FAR_BACK);
         glVertex3fv(selfPosition[aa]);
      }

      glEnd();
/*      
      glColor3f(1,1,1);
      
      glBegin(GL_LINE_STRIP);	* actual position of beams on floor *
         glVertex3fv(beam[0][0]);
         glVertex3fv(beam[4][0]);
         glVertex3fv(beam[15][0]);
         glVertex3fv(beam[11][0]);
         glVertex3fv(beam[0][0]);
      glEnd();
  */   
}

void drawall()
{
   drawbeams(); drawtris(); drawpillars();
      if (!track) { drawSelf(); drawSelfPositionLine(); }
   drawfloor(); drawceiling();
}

/* update functions begin here */

void updateTriangles(float ca,float cb,float sa,float sb,float v,float thegamma)
{
   float temp, temp_best; int dd_best;
   for (aa=0; aa<16; aa++) for(bb=0;bb<5;bb++)
   {
      temp  = trib[aa][bb][2] * ca - sa * trib[aa][bb][0];
      trib[aa][bb][0] = trib[aa][bb][0] * ca + sa * trib[aa][bb][2];
      trib[aa][bb][2] = temp * cb - sb * trib[aa][bb][1];
      trib[aa][bb][1] = trib[aa][bb][1] * cb + sb * temp;
      
      temp  = trit[aa][bb][2] * ca - sa * trit[aa][bb][0];
      trit[aa][bb][0] = trit[aa][bb][0] * ca + sa * trit[aa][bb][2];
      trit[aa][bb][2] = temp * cb - sb * trit[aa][bb][1];
      trit[aa][bb][1] = trit[aa][bb][1] * cb + sb * temp;      

      if(mode==FLYMODE) { trib[aa][bb][2] += v; trit[aa][bb][2] += v; }
            
      if (linearVel)
       {
         tribdraw[aa][bb][2] = updateVertex(trib[aa][bb][0], trib[aa][bb][1], trib[aa][bb][2], cls, v, thegamma);
         tribdraw[aa][bb][1] = trib[aa][bb][1];
         tribdraw[aa][bb][0] = trib[aa][bb][0];
         
         tritdraw[aa][bb][2] = updateVertex(trit[aa][bb][0], trit[aa][bb][1], trit[aa][bb][2], cls, v, thegamma);
         tritdraw[aa][bb][1] = trit[aa][bb][1];
         tritdraw[aa][bb][0] = trit[aa][bb][0];
       }
       else
       {          
          dd=ff=HOW_FAR_BACK/2;
          temp_best = 1000;
          for (;;)
          {
            ff /= 2;
            if (ff < 1) break;
            
            temp = cls*/* v/ */(float)dd - fsqrt(
                     dist2(trib[aa][bb][0]-selfPosition[dd][0],
                           trib[aa][bb][1],
                           trib[aa][bb][2]-selfPosition[dd][2]) );
            
             /* if ( ABS(temp) <= theThreshold) break; */
             if ( ABS(temp) < ABS(temp_best) )
             {
                dd_best = dd; temp_best = temp;
             }

             if (temp < 0) dd += ff;
             else dd -= ff;
           }
                tribdraw[aa][bb][0] = trib[aa][bb][0]-selfPosition[dd_best][0];
                tribdraw[aa][bb][1] = trib[aa][bb][1];
                tribdraw[aa][bb][2] = trib[aa][bb][2]-selfPosition[dd_best][2];
        
          dd=ff=HOW_FAR_BACK/2;
          temp_best = 1000;
          for (;;)
          {
            ff /= 2;
            if (ff < 1) break;
            
            temp = cls*/* v/ */(float)dd - fsqrt(
                     dist2(trit[aa][bb][0]-selfPosition[dd][0],
                           trit[aa][bb][1],
                           trit[aa][bb][2]-selfPosition[dd][2]) );
            
             /* if ( ABS(temp) <= theThreshold) break; */
             if ( ABS(temp) < ABS(temp_best) )
             {
                dd_best = dd; temp_best = temp;
             }


             if (temp < 0) dd += ff;
             else dd -= ff;
           }
                tritdraw[aa][bb][0] = trit[aa][bb][0]-selfPosition[dd_best][0];
                tritdraw[aa][bb][1] = trit[aa][bb][1];
                tritdraw[aa][bb][2] = trit[aa][bb][2]-selfPosition[dd_best][2];
         }

      
   }

}

void updateBeams(float ca,float cb,float sa,float sb,float v,float thegamma)
{
   float temp, temp_best; int dd_best;
   for (aa=0; aa<16; aa++) for (bb=0;bb<30;bb++) /* rotation */
   {
      temp  = beam[aa][bb][2] * ca - sa * beam[aa][bb][0];
      beam[aa][bb][0] = beam[aa][bb][0] * ca + sa * beam[aa][bb][2];
      beam[aa][bb][2] = temp * cb - sb * beam[aa][bb][1];
      beam[aa][bb][1] = beam[aa][bb][1] * cb + sb * temp;
      
      if(mode==FLYMODE) beam[aa][bb][2] += v;
      
       if (linearVel)
       {
         beamdraw[aa][bb][2] = updateVertex(beam[aa][bb][0], beam[aa][bb][1], beam[aa][bb][2], cls, v, thegamma);
         beamdraw[aa][bb][1] = beam[aa][bb][1];
         beamdraw[aa][bb][0] = beam[aa][bb][0];
       }
       else
       {          
          dd=ff=HOW_FAR_BACK/2;
          temp_best = 1000;
          for (;;)
          {
            ff /= 2;
            if (ff < 1) break;
            
            temp = cls*/* v/ */(float)dd - fsqrt(
                     dist2(beam[aa][bb][0]-selfPosition[dd][0],
                           beam[aa][bb][1],
                           beam[aa][bb][2]-selfPosition[dd][2]) );
            
             /* if ( ABS(temp) <= theThreshold) break; */
             if ( ABS(temp) < ABS(temp_best) )
             {
                dd_best = dd; temp_best = temp;
             }


             if (temp < 0) dd += ff;
             else dd -= ff;
           }
                beamdraw[aa][bb][0] = beam[aa][bb][0]-selfPosition[dd_best][0];
                beamdraw[aa][bb][1] = beam[aa][bb][1];
                beamdraw[aa][bb][2] = beam[aa][bb][2]-selfPosition[dd_best][2];
         }

   }
}

void updatePillars(float ca,float cb,float sa,float sb,float v,float thegamma)
{
   float temp;
   for (aa=0; aa<11; aa++) for(bb=0;bb<40;bb++)  /* rotation */
   {
       temp  = pillars[aa][bb][2] * ca - sa * pillars[aa][bb][0];
       pillars[aa][bb][0] = pillars[aa][bb][0] * ca + sa * pillars[aa][bb][2];
       pillars[aa][bb][2] = temp * cb - sb * pillars[aa][bb][1];
       pillars[aa][bb][1] = pillars[aa][bb][1] * cb + sb * temp;
      /* translation */
       if(mode==FLYMODE) pillars[aa][bb][2] += v;
              
       if (linearVel)
       {
         pilldraw[aa][bb][2] = updateVertex(pillars[aa][bb][0], pillars[aa][bb][1], pillars[aa][bb][2], cls, v, thegamma);
         pilldraw[aa][bb][1] = pillars[aa][bb][1];
         pilldraw[aa][bb][0] = pillars[aa][bb][0];

       }
       else
       {          
          dd=ff=HOW_FAR_BACK/2;
          temp_best = 1000;
          for (;;)
          {
            ff /= 2;
            if (ff < 1) break;
            
            temp = cls*/* v/ */(float)dd - fsqrt(
                     dist2(pillars[aa][bb][0]-selfPosition[dd][0],
                           pillars[aa][bb][1],
                           pillars[aa][bb][2]-selfPosition[dd][2]) );
            
             /* if ( ABS(temp) <= theThreshold) break; */
             if ( ABS(temp) < ABS(temp_best) )
             {
                dd_best = dd; temp_best = temp;
             }

             if (temp < 0) dd += ff;
             else dd -= ff;
           }
                pilldraw[aa][bb][0] = pillars[aa][bb][0]-selfPosition[dd_best][0];
                pilldraw[aa][bb][1] = pillars[aa][bb][1];
                pilldraw[aa][bb][2] = pillars[aa][bb][2]-selfPosition[dd_best][2];
         }
       
   }
}

void updateFloor(float ca,float cb,float sa,float sb,float v,float thegamma)
{
   float temp;
   for (aa=0; aa<1001; aa++)   /* rotation */
   {
       temp  = flod[aa][2] * ca - sa * flod[aa][0];
       flod[aa][0] = flod[aa][0] * ca + sa * flod[aa][2];
       flod[aa][2] = temp * cb - sb * flod[aa][1];
       flod[aa][1] = flod[aa][1] * cb + sb * temp;
       /* translation */
       if(mode==FLYMODE) flod[aa][2] += v;
       
       if (linearVel)
       {
         flodraw[aa][2] = updateVertex(flod[aa][0], flod[aa][1], flod[aa][2], cls, v, thegamma);
         flodraw[aa][1] = flod[aa][1];
         flodraw[aa][0] = flod[aa][0];
       }
       else
       {          
          dd=ff=HOW_FAR_BACK/2;
          temp_best = 1000;
          for (;;)
          {
            ff /= 2;
            if (ff < 1) break;
            
            temp = cls*/* v/ */(float)dd - fsqrt(
                     dist2(flod[aa][0]-selfPosition[dd][0],
                           flod[aa][1],
                           flod[aa][2]-selfPosition[dd][2]) );
            
             /* if ( ABS(temp) <= theThreshold) break; */
             if ( ABS(temp) < ABS(temp_best) )
             {
                dd_best = dd; temp_best = temp;
             }

             if (temp < 0) dd += ff;
             else dd -= ff;
           }
                flodraw[aa][0] = flod[aa][0]-selfPosition[dd_best][0];
                flodraw[aa][1] = flod[aa][1];
                flodraw[aa][2] = flod[aa][2]-selfPosition[dd_best][2];
         }

   }
}

void updateCeiling(float ca,float cb,float sa,float sb,float v,float thegamma)
{
   float temp;
   for (aa=0; aa<1001; aa++) {	/* rotation */
       temp  = ceid[aa][2] * ca - sa * ceid[aa][0];
       ceid[aa][0] = ceid[aa][0] * ca + sa * ceid[aa][2];
       ceid[aa][2] = temp * cb - sb * ceid[aa][1];
       ceid[aa][1] = ceid[aa][1] * cb + sb * temp;
           /* translation */
       if(mode==FLYMODE) ceid[aa][2] += v;
              
       if (linearVel)
       {
         ceidraw[aa][2] = updateVertex(ceid[aa][0], ceid[aa][1], ceid[aa][2], cls, v, thegamma);
         ceidraw[aa][1] = ceid[aa][1];
         ceidraw[aa][0] = ceid[aa][0];
       }
       else
       {          
          dd=ff=HOW_FAR_BACK/2;
          temp_best = 1000;
          for (;;)
          {
            ff /= 2;
            if (ff < 1) break;
            
            temp = cls*/* v/ */(float)dd - fsqrt(
                     dist2(ceid[aa][0]-selfPosition[dd][0],
                           ceid[aa][1],
                           ceid[aa][2]-selfPosition[dd][2]) );
            
             /* if ( ABS(temp) <= theThreshold) break; */
             if ( ABS(temp) < ABS(temp_best) )
             {
                dd_best = dd; temp_best = temp;
             }

             if (temp < 0) dd += ff;
             else dd -= ff;
           }
                ceidraw[aa][0] = ceid[aa][0]-selfPosition[dd_best][0];
                ceidraw[aa][1] = ceid[aa][1];
                ceidraw[aa][2] = ceid[aa][2]-selfPosition[dd_best][2];
         }

       
   }
}

void updateSelf(float ca,float cb,float sa,float sb,float v,float thegamma)
{
   for (aa=0; aa<120; aa++) {
       float temp;
        	/* rotation */
       /* temp  = self[aa][2] * ca - sa * self[aa][0];
       self[aa][0] = self[aa][0] * ca + sa * self[aa][2];
       self[aa][2] = temp * cb -ff < 1 sb * self[aa][1];
       self[aa][1] = self[aa][1] * cb + sb * temp; */
           /* translation */
       /*if(mode==FLYMODE) self[aa][2] += v;*/
       
       
       if (linearVel)
       {
         selfdraw[aa][2] = updateVertex(self[aa][0], self[aa][1]-5.0, self[aa][2], cls, -1.0*v, thegamma);
         selfdraw[aa][1] = self[aa][1]-5;
         selfdraw[aa][0] = self[aa][0];
       }
       else
       {          
          dd=ff=HOW_FAR_BACK/2;
          temp_best = 1000;
          for (;;)
          {
            ff /= 2;
            if (ff < 1) break;
            
            temp = cls*/* v/ */(float)dd - fsqrt(
                     dist2(self[aa][0]+selfPosition[dd][0],
                           self[aa][1]-5.0,
                           self[aa][2]+selfPosition[dd][2]) );
            
             /* if ( ABS(temp) <= theThreshold) break; */
             if ( ABS(temp) < ABS(temp_best) )
             {
                dd_best = dd; temp_best = temp;
             }

             if (temp < 0) dd += ff;
             else dd -= ff;
           }
                selfdraw[aa][0] = self[aa][0]+selfPosition[dd_best][0];
                selfdraw[aa][1] = self[aa][1]-5.0;
                selfdraw[aa][2] = self[aa][2]+selfPosition[dd_best][2];
         }

       
   }
}

void updateall (float ca,float cb,float sa,float sb,float v,float thegamma)
{
   updateCeiling(ca,cb,sa,sb,v,thegamma);
   updateFloor(ca,cb,sa,sb,v,thegamma); 
   updatePillars(ca,cb,sa,sb,v,thegamma);
   updateTriangles(ca,cb,sa,sb,v,thegamma);
   updateBeams(ca,cb,sa,sb,v,thegamma);
   updateSelf(ca,cb,sa,sb,v,thegamma);
}
