/*
 *  spacejunk.c
 *  schprel
 *
 *  Created by mflider on Mon Oct 16 2000.
 *  Copyright (c) 2000 Mark Flider. All rights reserved.
 *
 */

/*** initialize functions down here ***/

/* GLUT for *every* platform! */
#ifdef __sgi
#include <glut.h>	/* SGI glut libs */
#endif
#ifdef __MWERKS__
#include <glut.h>	/* MacOS 9 glut libs */
#endif
#ifdef __LINUX
#include <GL/glut.h>	/* Linux glut libs */
#endif
#ifdef __MACOSX
#include <GLUT/glut.h>	/*OS X glut libs */
#endif
#ifdef __WINDOWS
#include <gl\glut.h>	/* Windows glut libs */
#endif

#include <stdio.h>
#include <stdlib.h>

#include "self.c"

void initGL(void)
{
#ifdef __sgi
        glEnable(GL_LINE_SMOOTH);
        glHint(GL_LINE_SMOOTH_HINT,GL_NICEST);
        glEnable(GL_BLEND);
        glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);
#endif
}

void initall ()
{
   wVert=0;
   for (vez=-25;vez<=25;vez++)  /* initialize floor matrix */
   for (vex=-25;vex<=25;vex++)
   if ((int)vex % 5 == 0 || (int)vez % 5 == 0)
        {
        flod[wVert][0] = vex;
        flod[wVert][1] = -5;
	flod[wVert][2] = vez;
        wVert++;
        }
   for (aa=0;aa<1001;aa++)
   for (bb=0;bb<3;bb++)
	flodraw[aa][bb] = flod[aa][bb];

   for (aa=0;aa<1001;aa++)		/* init ceiling matrix */
   {
      ceid[aa][0] = ceidraw[aa][0] = flodraw[aa][0];
      ceid[aa][1] = ceidraw[aa][1] = 4;
      ceid[aa][2] = ceidraw[aa][2] = flodraw[aa][2];
   }

   for (aa=0;aa<11;aa++) {     /* init pillars matrix */
      wVert=0;
      for (vey=0;vey<10;vey++)
      for (vex=-.25;vex<=.25;vex+=.5)
      for (vez=-.25;vez<=.25;vez+=.5)
      {
         pillars[aa][wVert][0] = vex-25;
         pillars[aa][wVert][1] = vey-5;
         pillars[aa][wVert][2] = vez-25+aa*5;
         wVert++;
      }
   }
   for (aa=0;aa<11;aa++)
   for (bb=0;bb<40;bb++)
   for (dd=0;dd<3;dd++)
      pilldraw[aa][bb][dd] = pillars[aa][bb][dd];


   vey = 0;		/* init trit, trib matrices */
   aa=0;
   for (bb=-2;bb<=2;bb++)
   for (dd=-2;dd<=2;dd++)
   {
      if ( fabs(bb)==2 || fabs(dd)==2 )
      {
         trib[aa][0][0] = bb;
         trib[aa][0][1] = -4.9;
         trib[aa][0][2] = dd;
         wVert=1;
         for (vex=-.09;vex<=.09;vex+=.18)
         for (vez=-.09;vez<=.09;vez+=.18)
         {
            trib[aa][wVert][0] = vex+bb;
            trib[aa][wVert][1] = -5;
            trib[aa][wVert][2] = vez+dd;
            wVert++;
         }
         aa++;
      }
   }

   for (aa=0;aa<16;aa++)
   for (wVert=0;wVert<5;wVert++)
   {
      trit[aa][wVert][0] = trib[aa][wVert][0];
      trit[aa][wVert][1] = -1.0-trib[aa][wVert][1];
      trit[aa][wVert][2] = trib[aa][wVert][2];
   }
   for (aa=0;aa<16;aa++)
   for (wVert=0;wVert<5;wVert++)
   for (bb=0;bb<3;bb++)
   {
      tribdraw[aa][wVert][bb] = trib[aa][wVert][bb];
      tritdraw[aa][wVert][bb] = trit[aa][wVert][bb];
   }

   for (aa=0;aa<16;aa++)		/* init beam matrix */
   {
   wVert = 0;
   for (vey = tribdraw[aa][0][1];vey<=tritdraw[aa][0][1];vey+=(tritdraw[aa][0][1]-tribdraw[aa][0][1])/29)
      {
         beamdraw[aa][wVert][0] = beam[aa][wVert][0] = tribdraw[aa][0][0];
         beamdraw[aa][wVert][1] = beam[aa][wVert][1] = vey;
         beamdraw[aa][wVert][2] = beam[aa][wVert][2] = tribdraw[aa][0][2];
         wVert++;
      }
   }

   initSelf();

   initGL();
}


/***** --- draw functions down here --*****/

void drawfloor(void){

float color;

if(highquality)	color = 1.;
else		color = .1;

   for (aa=0;aa<1001;aa+=95)
   {
      glBegin(GL_LINE_STRIP);
      glColor4f(0,color/2+.5,color/2+.5,1);
      for (wVert=aa;wVert<51+aa;wVert++)
         glVertex3f(flodraw[wVert][0],flodraw[wVert][1]+.01,flodraw[wVert][2]);
      glEnd();
   }
   for (aa=0;aa<51;aa+=5)
   {
      glBegin(GL_LINE_STRIP);
      glColor4f(0,color/2+.5,color/2+.5,1);
         glVertex3f(flodraw[aa][0],flodraw[aa][1]+.01,flodraw[aa][2]);
      for (bb=51+aa/5;bb<1001;bb+=95)
      {
      for (wVert=bb;wVert<11*4+bb;wVert+=11)
         glVertex3f(flodraw[wVert][0],flodraw[wVert][1]+.01,flodraw[wVert][2]);
      glVertex3f(flodraw[wVert+aa/5*4][0],flodraw[wVert+aa/5*4][1]+.01,flodraw[wVert+aa/5*4][2]);
      }
      glEnd();
   }

if(highquality)
{
   for (dd=0;dd<950;dd+=95)
   for (aa=dd;aa<dd+50;aa+=5)
   {
      glBegin(GL_TRIANGLE_STRIP);
      glColor4f(0,color,color,.2);
      wVert=aa+1;
         glVertex3fv(flodraw[aa]);
      for (bb=aa+51-(aa-dd)/5*4;bb<aa+85-(aa-dd)/5*4;bb+=11)
      {
         glVertex3fv(flodraw[wVert]);
         glVertex3fv(flodraw[bb]);
         wVert++;
      }
      glVertex3fv(flodraw[wVert]);
      glVertex3fv(flodraw[aa+95]);
      glEnd();

      glBegin(GL_TRIANGLE_STRIP);
      glColor4f(0,color,color,.2);
      wVert=aa+95;
         glVertex3fv(flodraw[aa+5]);
      for (bb=aa+56-(aa+5-dd)/5*4;bb<aa+90-(aa+5-dd)/5*4;bb+=11)
      {
         glVertex3fv(flodraw[wVert]);
         glVertex3fv(flodraw[bb]);
         wVert++;
      }
      glVertex3fv(flodraw[wVert]);
      glVertex3fv(flodraw[aa+100]);
      glEnd();
   }
}
}

void drawceiling(void){

float color;

if(highquality)
{
        glEnable(GL_LINE_SMOOTH);
        glEnable(GL_BLEND);
        glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);
        glHint(GL_LINE_SMOOTH_HINT,GL_DONT_CARE);

        color = 1.;
}
else		color = .1;

   for (aa=0;aa<1001;aa+=95)
   {
      glBegin(GL_LINE_STRIP);
      glColor4f(0,color/4+.25,color/2+.5,1);
      for (wVert=aa;wVert<51+aa;wVert++)
         glVertex3f(ceidraw[wVert][0],ceidraw[wVert][1]-.01,ceidraw[wVert][2]);
      glEnd();
   }
   for (aa=0;aa<51;aa+=5)
   {
      glBegin(GL_LINE_STRIP);
      glColor4f(0,color/4+.25,color/2+.5,1);
         glVertex3f(ceidraw[aa][0],ceidraw[aa][1]-.01,ceidraw[aa][2]);
      for (bb=51+aa/5;bb<1001;bb+=95)
      {
      for (wVert=bb;wVert<11*4+bb;wVert+=11)
         glVertex3f(ceidraw[wVert][0],ceidraw[wVert][1]-.01,ceidraw[wVert][2]);
      glVertex3f(ceidraw[wVert+aa/5*4][0],ceidraw[wVert+aa/5*4][1]-.01,ceidraw[wVert+aa/5*4][2]);
      }
      glEnd();
   }

if(highquality)
{
   for (dd=0;dd<950;dd+=95)
   for (aa=dd;aa<dd+50;aa+=5)
   {
      glBegin(GL_TRIANGLE_STRIP);
      glColor4f(0,color/2,color,.1);
      wVert=aa+1;
         glVertex3fv(ceidraw[aa]);
      for (bb=aa+51-(aa-dd)/5*4;bb<aa+85-(aa-dd)/5*4;bb+=11)
      {
         glVertex3fv(ceidraw[wVert]);
         glVertex3fv(ceidraw[bb]);
         wVert++;
      }
      glVertex3fv(ceidraw[wVert]);
      glVertex3fv(ceidraw[aa+95]);
      glEnd();

      glBegin(GL_TRIANGLE_STRIP);
      glColor4f(0,color/2,color,.1);
      wVert=aa+95;
         glVertex3fv(ceidraw[aa+5]);
      for (bb=aa+56-(aa+5-dd)/5*4;bb<aa+90-(aa+5-dd)/5*4;bb+=11)
      {
         glVertex3fv(ceidraw[wVert]);
         glVertex3fv(ceidraw[bb]);
         wVert++;
      }
      glVertex3fv(ceidraw[wVert]);
      glVertex3fv(ceidraw[aa+100]);
      glEnd();
   }
}
}

void drawpillars(void) {

for (aa=0;aa<11;aa++) {

   glColor3f(1,1,1);
   for (bb=0;bb<4;bb++) {
      glBegin(GL_LINE_STRIP);
         for (wVert=bb;wVert<40;wVert+=4)
            glVertex3fv(pilldraw[aa][wVert]);
      glEnd();
   }

   glColor3f(.5,.25,0);
   glBegin(GL_TRIANGLE_STRIP);
      for (wVert=0;wVert<40;wVert+=4) {
         glVertex3fv(pilldraw[aa][wVert]);
	 glVertex3fv(pilldraw[aa][wVert+1]);
      }
   glEnd();
   glColor3f(.75,.375,.25);
   glBegin(GL_TRIANGLE_STRIP);
      for (wVert=0;wVert<40;wVert+=4) {
         glVertex3fv(pilldraw[aa][wVert]);
         glVertex3fv(pilldraw[aa][wVert+2]);
      }
   glEnd();
   glColor3f(1,.5,0);
   glBegin(GL_TRIANGLE_STRIP);
      for (wVert=3;wVert<40;wVert+=4) {
         glVertex3fv(pilldraw[aa][wVert]);
         glVertex3fv(pilldraw[aa][wVert-1]);
      }
   glEnd();
   glColor3f(.75,.375,.25);
   glBegin(GL_TRIANGLE_STRIP);
      for (wVert=3;wVert<40;wVert+=4) {
         glVertex3fv(pilldraw[aa][wVert]);
         glVertex3fv(pilldraw[aa][wVert-2]);
      }
   glEnd();
}
}



void drawtris(void) {

for (aa=0;aa<16;aa++)
{
if (highquality)
{
   glColor4f(1,1,1,1);
   glBegin(GL_LINE_STRIP);
      glVertex3fv(tribdraw[aa][1]);
      glVertex3fv(tribdraw[aa][2]);
      glVertex3fv(tribdraw[aa][0]);
      glVertex3fv(tribdraw[aa][3]);
      glVertex3fv(tribdraw[aa][4]);
   glEnd();
   glBegin(GL_LINE_STRIP);
      glVertex3fv(tribdraw[aa][1]);
      glVertex3fv(tribdraw[aa][3]);
      glVertex3fv(tribdraw[aa][0]);
      glVertex3fv(tribdraw[aa][2]);
      glVertex3fv(tribdraw[aa][4]);
   glEnd();

   glBegin(GL_LINE_STRIP);
      glVertex3fv(tritdraw[aa][1]);
      glVertex3fv(tritdraw[aa][2]);
      glVertex3fv(tritdraw[aa][0]);
      glVertex3fv(tritdraw[aa][3]);
      glVertex3fv(tritdraw[aa][4]);
   glEnd();
   glBegin(GL_LINE_STRIP);
      glVertex3fv(tritdraw[aa][1]);
      glVertex3fv(tritdraw[aa][3]);
      glVertex3fv(tritdraw[aa][0]);
      glVertex3fv(tritdraw[aa][2]);
      glVertex3fv(tritdraw[aa][4]);
   glEnd();
}
   glColor4f(.5,1,.2,1);
   glBegin(GL_TRIANGLE_FAN);
      glVertex3fv(tribdraw[aa][0]);
      glVertex3fv(tribdraw[aa][1]);
      glVertex3fv(tribdraw[aa][2]);
      glVertex3fv(tribdraw[aa][4]);
      glVertex3fv(tribdraw[aa][3]);
      glVertex3fv(tribdraw[aa][1]);
   glEnd();

   glColor4f(.5,.2,1,1);
   glBegin(GL_TRIANGLE_FAN);
      glVertex3fv(tritdraw[aa][0]);
      glVertex3fv(tritdraw[aa][1]);
      glVertex3fv(tritdraw[aa][2]);
      glVertex3fv(tritdraw[aa][4]);
      glVertex3fv(tritdraw[aa][3]);
      glVertex3fv(tritdraw[aa][1]);
   glEnd();

}
}


void drawbeams(void){

for (aa=0;aa<16;aa++)
   {
   glColor4f(1,1-((float)aa)/20.0,1-16.0/20.0+((float)aa)/20.0,1);
   glBegin(GL_LINE_STRIP);
   for (bb=0;bb<30;bb++)
      glVertex3fv(beamdraw[aa][bb]);
   glEnd();
   }
}
#if 0
void drawSelf(void){
float transp=1;
if(highquality) transp = .5;

	glColor4f(1,0,0,transp);
      
      for (aa=0; aa<119; aa+=8)
      {
      
	  glBegin(GL_TRIANGLE_FAN);
           glVertex3fv(selfdraw[aa+0]);
           glVertex3fv(selfdraw[aa+1]);
           glVertex3fv(selfdraw[aa+2]);
           glVertex3fv(selfdraw[aa+3]);
           glVertex3fv(selfdraw[aa+7]);
           glVertex3fv(selfdraw[aa+4]);
           glVertex3fv(selfdraw[aa+5]);
           glVertex3fv(selfdraw[aa+1]);
        glEnd();
        
        glBegin(GL_TRIANGLE_FAN);
           glVertex3fv(selfdraw[aa+6]);
           glVertex3fv(selfdraw[aa+7]);
           glVertex3fv(selfdraw[aa+3]);
           glVertex3fv(selfdraw[aa+2]);
           glVertex3fv(selfdraw[aa+1]);
           glVertex3fv(selfdraw[aa+5]);
           glVertex3fv(selfdraw[aa+4]);
           glVertex3fv(selfdraw[aa+7]);
        glEnd();
      }
      
      /*
        glColor4f(1,1,1,transp);
        glBegin(GL_LINES);
           glVertex3f(selfdraw[0][0],selfdraw[0][1],selfdraw[0][2]);
           glVertex3f(selfdraw[2][0],selfdraw[2][1],selfdraw[2][2]);
           glVertex3f(selfdraw[3][0],selfdraw[3][1],selfdraw[3][2]);
        glEnd();

        glColor4f(1,.2,.2,transp);
        glBegin(GL_TRIANGLES);
           glVertex3f(selfdraw[0][0],selfdraw[0][1],selfdraw[0][2]);
           glVertex3f(selfdraw[3][0],selfdraw[3][1],selfdraw[3][2]);
           glVertex3f(selfdraw[1][0],selfdraw[1][1],selfdraw[1][2]);
	glEnd();
      */
}
#endif
void drawSelfPositionLine(void)
{

      glBegin(GL_POINTS);      

      for (aa=0; aa < HOW_FAR_BACK; aa++)
      {
         glColor3f(1-(float)aa/(float)HOW_FAR_BACK,1-(float)aa/(float)HOW_FAR_BACK,1-(float)aa/(float)HOW_FAR_BACK);
         glVertex3fv(selfPosition[aa]);
      }

      glEnd();
/*      
      glColor3f(1,1,1);
      
      glBegin(GL_LINE_STRIP);	* actual position of beams on floor *
         glVertex3fv(beam[0][0]);
         glVertex3fv(beam[4][0]);
         glVertex3fv(beam[15][0]);
         glVertex3fv(beam[11][0]);
         glVertex3fv(beam[0][0]);
      glEnd();
  */   
}

void drawall()
{
   drawbeams(); drawtris(); drawpillars();
      if (!track) { drawSelf(); drawSelfPositionLine(); }
   drawfloor(); drawceiling();
}

/* update functions begin here */
#if 0
void updateTriangles(float ca,float cb,float sa,float sb,float v,float thegamma)
{
   float temp, temp_best; int dd_best;
   for (aa=0; aa<16; aa++) for(bb=0;bb<5;bb++)
   {
      temp  = trib[aa][bb][2] * ca - sa * trib[aa][bb][0];
      trib[aa][bb][0] = trib[aa][bb][0] * ca + sa * trib[aa][bb][2];
      trib[aa][bb][2] = temp * cb - sb * trib[aa][bb][1];
      trib[aa][bb][1] = trib[aa][bb][1] * cb + sb * temp;
      
      temp  = trit[aa][bb][2] * ca - sa * trit[aa][bb][0];
      trit[aa][bb][0] = trit[aa][bb][0] * ca + sa * trit[aa][bb][2];
      trit[aa][bb][2] = temp * cb - sb * trit[aa][bb][1];
      trit[aa][bb][1] = trit[aa][bb][1] * cb + sb * temp;      

      if(mode==FLYMODE) { trib[aa][bb][2] += v; trit[aa][bb][2] += v; }
            
      if (linearVel)
       {
         tribdraw[aa][bb][2] = updateVertex(trib[aa][bb][0], trib[aa][bb][1], trib[aa][bb][2], cls, v, thegamma);
         tribdraw[aa][bb][1] = trib[aa][bb][1];
         tribdraw[aa][bb][0] = trib[aa][bb][0];
         
         tritdraw[aa][bb][2] = updateVertex(trit[aa][bb][0], trit[aa][bb][1], trit[aa][bb][2], cls, v, thegamma);
         tritdraw[aa][bb][1] = trit[aa][bb][1];
         tritdraw[aa][bb][0] = trit[aa][bb][0];
       }
       else
       {          
          dd=ff=HOW_FAR_BACK/2;
          temp_best = 1000;
          for (;;)
          {
            ff /= 2;
            if (ff < 1) break;
            
            temp = cls*/* v/ */(float)dd - fsqrt(
                     dist2(trib[aa][bb][0]-selfPosition[dd][0],
                           trib[aa][bb][1],
                           trib[aa][bb][2]-selfPosition[dd][2]) );
            
             /* if ( ABS(temp) <= theThreshold) break; */
             if ( ABS(temp) < ABS(temp_best) )
             {
                dd_best = dd; temp_best = temp;
             }

             if (temp < 0) dd += ff;
             else dd -= ff;
           }
                tribdraw[aa][bb][0] = trib[aa][bb][0]-selfPosition[dd_best][0];
                tribdraw[aa][bb][1] = trib[aa][bb][1];
                tribdraw[aa][bb][2] = trib[aa][bb][2]-selfPosition[dd_best][2];
        
          dd=ff=HOW_FAR_BACK/2;
          temp_best = 1000;
          for (;;)
          {
            ff /= 2;
            if (ff < 1) break;
            
            temp = cls*/* v/ */(float)dd - fsqrt(
                     dist2(trit[aa][bb][0]-selfPosition[dd][0],
                           trit[aa][bb][1],
                           trit[aa][bb][2]-selfPosition[dd][2]) );
            
             /* if ( ABS(temp) <= theThreshold) break; */
             if ( ABS(temp) < ABS(temp_best) )
             {
                dd_best = dd; temp_best = temp;
             }


             if (temp < 0) dd += ff;
             else dd -= ff;
           }
                tritdraw[aa][bb][0] = trit[aa][bb][0]-selfPosition[dd_best][0];
                tritdraw[aa][bb][1] = trit[aa][bb][1];
                tritdraw[aa][bb][2] = trit[aa][bb][2]-selfPosition[dd_best][2];
         }

      
   }

}
#endif

void updateBeams(float ca,float cb,float sa,float sb,float v,float thegamma)
{
   float temp, temp_best; int dd_best;
   for (aa=0; aa<16; aa++) for (bb=0;bb<30;bb++) /* rotation */
   {
      temp  = beam[aa][bb][2] * ca - sa * beam[aa][bb][0];
      beam[aa][bb][0] = beam[aa][bb][0] * ca + sa * beam[aa][bb][2];
      beam[aa][bb][2] = temp * cb - sb * beam[aa][bb][1];
      beam[aa][bb][1] = beam[aa][bb][1] * cb + sb * temp;
      
      if(mode==FLYMODE) beam[aa][bb][2] += v;
      
       if (linearVel)
       {
         beamdraw[aa][bb][2] = updateVertex(beam[aa][bb][0], beam[aa][bb][1], beam[aa][bb][2], cls, v, thegamma);
         beamdraw[aa][bb][1] = beam[aa][bb][1];
         beamdraw[aa][bb][0] = beam[aa][bb][0];
       }
       else
       {          
          dd=ff=HOW_FAR_BACK/2;
          temp_best = 1000;
          for (;;)
          {
            ff /= 2;
            if (ff < 1) break;
            
            temp = cls*/* v/ */(float)dd - fsqrt(
                     dist2(beam[aa][bb][0]-selfPosition[dd][0],
                           beam[aa][bb][1],
                           beam[aa][bb][2]-selfPosition[dd][2]) );
            
             /* if ( ABS(temp) <= theThreshold) break; */
             if ( ABS(temp) < ABS(temp_best) )
             {
                dd_best = dd; temp_best = temp;
             }


             if (temp < 0) dd += ff;
             else dd -= ff;
           }
                beamdraw[aa][bb][0] = beam[aa][bb][0]-selfPosition[dd_best][0];
                beamdraw[aa][bb][1] = beam[aa][bb][1];
                beamdraw[aa][bb][2] = beam[aa][bb][2]-selfPosition[dd_best][2];
         }

   }
}

void updatePillars(float ca,float cb,float sa,float sb,float v,float thegamma)
{
   float temp;
   for (aa=0; aa<11; aa++) for(bb=0;bb<40;bb++)  /* rotation */
   {
       temp  = pillars[aa][bb][2] * ca - sa * pillars[aa][bb][0];
       pillars[aa][bb][0] = pillars[aa][bb][0] * ca + sa * pillars[aa][bb][2];
       pillars[aa][bb][2] = temp * cb - sb * pillars[aa][bb][1];
       pillars[aa][bb][1] = pillars[aa][bb][1] * cb + sb * temp;
      /* translation */
       if(mode==FLYMODE) pillars[aa][bb][2] += v;
              
       if (linearVel)
       {
         pilldraw[aa][bb][2] = updateVertex(pillars[aa][bb][0], pillars[aa][bb][1], pillars[aa][bb][2], cls, v, thegamma);
         pilldraw[aa][bb][1] = pillars[aa][bb][1];
         pilldraw[aa][bb][0] = pillars[aa][bb][0];

       }
       else
       {          
          dd=ff=HOW_FAR_BACK/2;
          temp_best = 1000;
          for (;;)
          {
            ff /= 2;
            if (ff < 1) break;
            
            temp = cls*/* v/ */(float)dd - fsqrt(
                     dist2(pillars[aa][bb][0]-selfPosition[dd][0],
                           pillars[aa][bb][1],
                           pillars[aa][bb][2]-selfPosition[dd][2]) );
            
             /* if ( ABS(temp) <= theThreshold) break; */
             if ( ABS(temp) < ABS(temp_best) )
             {
                dd_best = dd; temp_best = temp;
             }

             if (temp < 0) dd += ff;
             else dd -= ff;
           }
                pilldraw[aa][bb][0] = pillars[aa][bb][0]-selfPosition[dd_best][0];
                pilldraw[aa][bb][1] = pillars[aa][bb][1];
                pilldraw[aa][bb][2] = pillars[aa][bb][2]-selfPosition[dd_best][2];
         }
       
   }
}

void updateFloor(float ca,float cb,float sa,float sb,float v,float thegamma)
{
   float temp;
   for (aa=0; aa<1001; aa++)   /* rotation */
   {
       temp  = flod[aa][2] * ca - sa * flod[aa][0];
       flod[aa][0] = flod[aa][0] * ca + sa * flod[aa][2];
       flod[aa][2] = temp * cb - sb * flod[aa][1];
       flod[aa][1] = flod[aa][1] * cb + sb * temp;
       /* translation */
       if(mode==FLYMODE) flod[aa][2] += v;
       
       if (linearVel)
       {
         flodraw[aa][2] = updateVertex(flod[aa][0], flod[aa][1], flod[aa][2], cls, v, thegamma);
         flodraw[aa][1] = flod[aa][1];
         flodraw[aa][0] = flod[aa][0];
       }
       else
       {          
          dd=ff=HOW_FAR_BACK/2;
          temp_best = 1000;
          for (;;)
          {
            ff /= 2;
            if (ff < 1) break;
            
            temp = cls*/* v/ */(float)dd - fsqrt(
                     dist2(flod[aa][0]-selfPosition[dd][0],
                           flod[aa][1],
                           flod[aa][2]-selfPosition[dd][2]) );
            
             /* if ( ABS(temp) <= theThreshold) break; */
             if ( ABS(temp) < ABS(temp_best) )
             {
                dd_best = dd; temp_best = temp;
             }

             if (temp < 0) dd += ff;
             else dd -= ff;
           }
                flodraw[aa][0] = flod[aa][0]-selfPosition[dd_best][0];
                flodraw[aa][1] = flod[aa][1];
                flodraw[aa][2] = flod[aa][2]-selfPosition[dd_best][2];
         }

   }
}

void updateCeiling(float ca,float cb,float sa,float sb,float v,float thegamma)
{
   float temp;
   for (aa=0; aa<1001; aa++) {	/* rotation */
       temp  = ceid[aa][2] * ca - sa * ceid[aa][0];
       ceid[aa][0] = ceid[aa][0] * ca + sa * ceid[aa][2];
       ceid[aa][2] = temp * cb - sb * ceid[aa][1];
       ceid[aa][1] = ceid[aa][1] * cb + sb * temp;
           /* translation */
       if(mode==FLYMODE) ceid[aa][2] += v;
              
       if (linearVel)
       {
         ceidraw[aa][2] = updateVertex(ceid[aa][0], ceid[aa][1], ceid[aa][2], cls, v, thegamma);
         ceidraw[aa][1] = ceid[aa][1];
         ceidraw[aa][0] = ceid[aa][0];
       }
       else
       {          
          dd=ff=HOW_FAR_BACK/2;
          temp_best = 1000;
          for (;;)
          {
            ff /= 2;
            if (ff < 1) break;
            
            temp = cls*/* v/ */(float)dd - fsqrt(
                     dist2(ceid[aa][0]-selfPosition[dd][0],
                           ceid[aa][1],
                           ceid[aa][2]-selfPosition[dd][2]) );
            
             /* if ( ABS(temp) <= theThreshold) break; */
             if ( ABS(temp) < ABS(temp_best) )
             {
                dd_best = dd; temp_best = temp;
             }

             if (temp < 0) dd += ff;
             else dd -= ff;
           }
                ceidraw[aa][0] = ceid[aa][0]-selfPosition[dd_best][0];
                ceidraw[aa][1] = ceid[aa][1];
                ceidraw[aa][2] = ceid[aa][2]-selfPosition[dd_best][2];
         }

       
   }
}
#if 0
void updateSelf(float ca,float cb,float sa,float sb,float v,float thegamma)
{
   for (aa=0; aa<120; aa++) {
       float temp;
        	/* rotation */
       /* temp  = self[aa][2] * ca - sa * self[aa][0];
       self[aa][0] = self[aa][0] * ca + sa * self[aa][2];
       self[aa][2] = temp * cb -ff < 1 sb * self[aa][1];
       self[aa][1] = self[aa][1] * cb + sb * temp; */
           /* translation */
       /*if(mode==FLYMODE) self[aa][2] += v;*/
       
       
       if (linearVel)
       {
         selfdraw[aa][2] = updateVertex(self[aa][0], self[aa][1]-5.0, self[aa][2], cls, -1.0*v, thegamma);
         selfdraw[aa][1] = self[aa][1]-5;
         selfdraw[aa][0] = self[aa][0];
       }
       else
       {          
          dd=ff=HOW_FAR_BACK/2;
          temp_best = 1000;
          for (;;)
          {
            ff /= 2;
            if (ff < 1) break;
            
            temp = cls*/* v/ */(float)dd - fsqrt(
                     dist2(self[aa][0]+selfPosition[dd][0],
                           self[aa][1]-5.0,
                           self[aa][2]+selfPosition[dd][2]) );
            
             /* if ( ABS(temp) <= theThreshold) break; */
             if ( ABS(temp) < ABS(temp_best) )
             {
                dd_best = dd; temp_best = temp;
             }

             if (temp < 0) dd += ff;
             else dd -= ff;
           }
                selfdraw[aa][0] = self[aa][0]+selfPosition[dd_best][0];
                selfdraw[aa][1] = self[aa][1]-5.0;
                selfdraw[aa][2] = self[aa][2]+selfPosition[dd_best][2];
         }

       
   }
}
#endif

void updateall (float ca,float cb,float sa,float sb,float v,float thegamma)
{
   updateCeiling(ca,cb,sa,sb,v,thegamma);
   updateFloor(ca,cb,sa,sb,v,thegamma); 
   updatePillars(ca,cb,sa,sb,v,thegamma);
   updateTriangles(ca,cb,sa,sb,v,thegamma);
   updateBeams(ca,cb,sa,sb,v,thegamma);
   updateSelf(ca,cb,sa,sb,v,thegamma);
}
