/*************************************************************************

 cave_ogl.h

 Authors:	Carolina Cruz-Neira, Dave Pape, Marek Czernuszenko
 Version:	2.6
 Last revised:	30 April 1997

  This file contains the definitions required by CAVE applications.

**************************************************************************/

/*
*	Copyright 1995,1997, Board of Trustees of the University of Illinois,
*	Electronic Visualization Laboratory.
*	All rights reserved.
*
*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF EVL.
*	Unless otherwise agreed to in writing by EVL, this code is
*	to be used and accessed only by SIGGRAPH VROOM participants.
*	It is not public domain software.  Call Margaret Rawlings at
*	(312)-996-3002 for details.
*
*/

#ifndef	__CAVE_H__
#define	__CAVE_H__

#include <stdio.h>
#include <math.h>
#include <GL/gl.h>
#include <GL/glx.h>
#include <X11/Xlib.h>
#ifdef __sgi
#include <ulocks.h>
#endif
#include <sys/types.h>
#include <inttypes.h>


#ifdef __cplusplus
extern "C" {
#endif


#ifdef LINUX
   typedef int key_t;		/* added by Marwan Y. Ansari for Linux */
#endif /*linux */

typedef int32_t boolean;

/* Wall IDs - for CAVEWall, WallGeom, ProjectionData, etc */
/*	(used as array indices, so should be defined as 1-n) */
typedef enum {
		CAVE_BOGUS_WALL=0,
		CAVE_FRONT_WALL=1,
		CAVE_FLOOR_WALL=2,
		CAVE_RIGHT_WALL=3,
		CAVE_LEFT_WALL=4,
		CAVE_CEILING_WALL=5,
		CAVE_BACK_WALL=6,
		CAVE_SCREEN0_WALL=7,
		CAVE_SCREEN1_WALL=8,
		CAVE_SCREEN2_WALL=9,
		CAVE_SCREEN3_WALL=10,
		CAVE_SCREEN4_WALL=11,
		CAVE_SCREEN5_WALL=12,
		CAVE_SCREEN6_WALL=13,
		CAVE_SCREEN7_WALL=14,
		CAVE_SIMULATOR_WALL=15,
		CAVE_SIMULATOR1_WALL=16,
		CAVE_SIMULATOR2_WALL=17,
		CAVE_NUM_WALL_IDS=18
	} CAVE_WALL_ID;
#define CAVE_MAX_WALL_ID	(CAVE_NUM_WALL_IDS-1)

/* Maximum # of walls that can be used simultaneously */
#define CAVE_MAX_WALLS	CAVE_MAX_WALL_ID


/* Controller input device macros */
#define  CAVEBUTTON1    (CAVEController->button[0])
#define  CAVEBUTTON2    (CAVEController->button[1])
#define  CAVEBUTTON3    (CAVEController->button[2])
#define  CAVEBUTTON4    (CAVEController->button[3])

#define CAVE_JOYSTICK_X	(CAVEController->valuator[0])
#define CAVE_JOYSTICK_Y	(CAVEController->valuator[1])

#define CAVESENSOR(i)		((CAVE_SENSOR_ST *)(CAVEptr->sensor[i]))
#define CAVENETSENSOR(user,i)	((CAVE_SENSOR_ST *)(&user->sensor[i]))

#define CAVE_MAX_BUTTONS	32
#define CAVE_MAX_VALUATORS	32

#define CAVE_MAX_SENSORS	32

#define CAVE_DISTRIB_MAX_NODES		32
#define CAVE_DISTRIB_MAX_CHANNELID	31

#define CAVE_TRACKER_PID_FILE	"/tmp/cavetracker_pid"


/* Miscellaneous constants for utility functions & CAVEConfig entries */
/* New names should be added to the end of the list, to maintain
   backward-compatibility of values */
typedef enum {
		CAVE_NULL=0,
		CAVE_HEAD,
		CAVE_WAND,
		CAVE_LEFT_EYE,
		CAVE_RIGHT_EYE,
		CAVE_FRONT,
		CAVE_BACK,
		CAVE_LEFT,
		CAVE_RIGHT,
		CAVE_UP,
		CAVE_DOWN,
		CAVE_FRONT_NAV,
		CAVE_BACK_NAV,
		CAVE_LEFT_NAV,
		CAVE_RIGHT_NAV,
		CAVE_UP_NAV,
		CAVE_DOWN_NAV,
		CAVE_HEAD_FRONT,
		CAVE_HEAD_BACK,
		CAVE_HEAD_LEFT,
		CAVE_HEAD_RIGHT,
		CAVE_HEAD_UP,
		CAVE_HEAD_DOWN,
		CAVE_WAND_FRONT,
		CAVE_WAND_BACK,
		CAVE_WAND_LEFT,
		CAVE_WAND_RIGHT,
		CAVE_WAND_UP,
		CAVE_WAND_DOWN,
		CAVE_HEAD_NAV,
		CAVE_WAND_NAV,
		CAVE_LEFT_EYE_NAV,
		CAVE_RIGHT_EYE_NAV,
		CAVE_HEAD_FRONT_NAV,
		CAVE_HEAD_BACK_NAV,
		CAVE_HEAD_LEFT_NAV,
		CAVE_HEAD_RIGHT_NAV,
		CAVE_HEAD_UP_NAV,
		CAVE_HEAD_DOWN_NAV,
		CAVE_WAND_FRONT_NAV,
		CAVE_WAND_BACK_NAV,
		CAVE_WAND_LEFT_NAV,
		CAVE_WAND_RIGHT_NAV,
		CAVE_WAND_UP_NAV,
		CAVE_WAND_DOWN_NAV,
/* CAVESetOption() arguments */
		CAVE_PROJ_USEWINDOW,
		CAVE_TRACKER_SIGNALRESET,
		CAVE_DIST_NETWORKSLAVE,
		CAVE_GL_SAMPLES,
		CAVE_GL_STENCILSIZE,
		CAVE_GL_ACCUMSIZE,
		CAVE_SCRAMNET_ARENASIZE,
		CAVE_SHMEM_SIZE,
		CAVE_SHMEM_ADDRESS,
		CAVE_NET_BUFFERSIZE,
		CAVE_NET_NUMBUFFERS,
		CAVE_NET_UPDATELOCALDATA,
/* Values for CAVEConfig->DisplayMode  */
		CAVE_MONO,
		CAVE_STEREO,
/* Values for CAVEConfig->ControllerType */
		CAVE_MOUSE_CONTROLLER,
		CAVE_PC_CONTROLLER,
		CAVE_SIMULATOR_CONTROLLER,
		CAVE_LOGITECH_CONTROLLER,
		CAVE_CUSTOM_CONTROLLER,
		CAVE_DAEMON_CONTROLLER,
		CAVE_SCRAMNET_CONTROLLER,
/* Values for CAVEConfig->TrackerType */
		CAVE_POLHEMUS_TRACKER_OBSOLETE,
		CAVE_BIRDS_TRACKER,
		CAVE_LOGITECH_TRACKER,
		CAVE_MOUSE_TRACKER,
		CAVE_SIMULATOR_TRACKER,
		CAVE_SPACEBALL_TRACKER,
		CAVE_BOOM_TRACKER,
		CAVE_DAEMON_TRACKER,
		CAVE_SCRAMNET_TRACKER,
		CAVE_SPACEPAD_TRACKER,
/* Values for CAVEConfig->BirdsHemisphere */
		CAVE_FRONT_HEMI,
		CAVE_LEFT_HEMI,
		CAVE_RIGHT_HEMI,
		CAVE_AFT_HEMI,
		CAVE_UPPER_HEMI,
		CAVE_LOWER_HEMI,
/* Flock-of-birds sync type, for CAVEConfig->SyncBirds */
		CAVE_BIRDS_SYNC1,
		CAVE_BIRDS_SYNC2,
/* Frames of reference, for CAVE_SENSOR_ST.frame */
		CAVE_TRACKER_FRAME,
		CAVE_NAV_FRAME,
/* Values for CAVEConfig->Units */
		CAVE_FEET,
		CAVE_METERS,
		CAVE_INCHES,
		CAVE_CENTIMETERS,
/* Additional eye value for CAVEConfig->WallEyes */
		CAVE_BOTH_EYES,
/* Callback types, for CAVEAddCallback */
		CAVE_DISPLAY_CALLBACK,
		CAVE_INITGRAPHICS_CALLBACK,
		CAVE_PERFRAME_CALLBACK,
		CAVE_NETADDUSER_CALLBACK,
		CAVE_NETDELETEUSER_CALLBACK,
		CAVE_NETAPPDATA_CALLBACK,
/* Distributed CAVE method, for CAVEConfig->Distribution */
		CAVE_DIST_SCRAMNET,
		CAVE_DIST_TCP,
/* Networking types, for CAVEConfig->Network */
		CAVE_NET_MCAST,
		CAVE_NET_TCP,
		CAVE_NET_UDP,
/* Process types; returned by CAVEProcessType() */
		CAVE_APP_PROCESS,
		CAVE_DISPLAY_PROCESS,
		CAVE_TRACKER_PROCESS,
		CAVE_NETWORK_PROCESS,
		CAVE_DISTRIB_PROCESS,
/* Projection types (for screen# walls) */
		CAVE_WALL_PROJECTION,
		CAVE_HMD_PROJECTION,
/* Further 2.6beta additions */
		CAVE_PROJ_USEMODELVIEW,
		CAVE_SIM_DRAWWAND,
		CAVE_SIM_DRAWOUTLINE,
		CAVE_SIM_DRAWUSER,
		CAVE_SIM_DRAWTIMING,
		CAVE_SIM_VIEWMODE,
		CAVE_PROJ_INCLUDENAVIGATION,
/* v2.6 - NCSA extension */
		CAVE_DISPLAY_UNKNOWN,
		CAVE_DISPLAY_CAVE,
		CAVE_DISPLAY_IWALL,
		CAVE_DISPLAY_IDESK,
		CAVE_DISPLAY_HEAD,
		CAVE_DISPLAY_FISH,
		CAVE_DISPLAY_PALM,
		CAVE_DISPLAY_SIM
		} CAVEID;


/* For old code using obsolete names */
#define	CAVE_NO_CONTROLLER	CAVE_NULL
#define	CAVE_NO_TRACKING	CAVE_NULL
#define	CAVE_DIST_NONE		CAVE_NULL


/* Device ID's for Custom controller buttons & valuators */
typedef enum {
	CAVE_NULLDEVICE=0,
	CAVE_AKEY,
	CAVE_BKEY,
	CAVE_CKEY,
	CAVE_DKEY,
	CAVE_EKEY,
	CAVE_FKEY,
	CAVE_GKEY,
	CAVE_HKEY,
	CAVE_IKEY,
	CAVE_JKEY,
	CAVE_KKEY,
	CAVE_LKEY,
	CAVE_MKEY,
	CAVE_NKEY,
	CAVE_OKEY,
	CAVE_PKEY,
	CAVE_QKEY,
	CAVE_RKEY,
	CAVE_SKEY,
	CAVE_TKEY,
	CAVE_UKEY,
	CAVE_VKEY,
	CAVE_WKEY,
	CAVE_XKEY,
	CAVE_YKEY,
	CAVE_ZKEY,
	CAVE_ZEROKEY,
	CAVE_ONEKEY,
	CAVE_TWOKEY,
	CAVE_THREEKEY,
	CAVE_FOURKEY,
	CAVE_FIVEKEY,
	CAVE_SIXKEY,
	CAVE_SEVENKEY,
	CAVE_EIGHTKEY,
	CAVE_NINEKEY,
	CAVE_BREAKKEY,
	CAVE_CTRLKEY,
	CAVE_LEFTCTRLKEY,
	CAVE_CAPSLOCKKEY,
	CAVE_RIGHTSHIFTKEY,
	CAVE_LEFTSHIFTKEY,
	CAVE_NOSCRLKEY,
	CAVE_ESCKEY,
	CAVE_TABKEY,
	CAVE_RETKEY,
	CAVE_SPACEKEY,
	CAVE_LINEFEEDKEY,
	CAVE_BACKSPACEKEY,
	CAVE_DELKEY,
	CAVE_SEMICOLONKEY,
	CAVE_PERIODKEY,
	CAVE_COMMAKEY,
	CAVE_QUOTEKEY,
	CAVE_ACCENTGRAVEKEY,
	CAVE_MINUSKEY,
	CAVE_VIRGULEKEY,
	CAVE_BACKSLASHKEY,
	CAVE_EQUALKEY,
	CAVE_LEFTBRACKETKEY,
	CAVE_RIGHTBRACKETKEY,
	CAVE_LEFTARROWKEY,
	CAVE_DOWNARROWKEY,
	CAVE_RIGHTARROWKEY,
	CAVE_UPARROWKEY,
	CAVE_PAD0,
	CAVE_PAD1,
	CAVE_PAD2,
	CAVE_PAD3,
	CAVE_PAD4,
	CAVE_PAD5,
	CAVE_PAD6,
	CAVE_PAD7,
	CAVE_PAD8,
	CAVE_PAD9,
	CAVE_PADPF1,
	CAVE_PADPF2,
	CAVE_PADPF3,
	CAVE_PADPF4,
	CAVE_PADPERIOD,
	CAVE_PADMINUS,
	CAVE_PADCOMMA,
	CAVE_PADENTER,
	CAVE_LEFTALTKEY,
	CAVE_RIGHTALTKEY,
	CAVE_RIGHTCTRLKEY,
	CAVE_F1KEY,
	CAVE_F2KEY,
	CAVE_F3KEY,
	CAVE_F4KEY,
	CAVE_F5KEY,
	CAVE_F6KEY,
	CAVE_F7KEY,
	CAVE_F8KEY,
	CAVE_F9KEY,
	CAVE_F10KEY,
	CAVE_F11KEY,
	CAVE_F12KEY,
	CAVE_PRINTSCREENKEY,
	CAVE_SCROLLLOCKKEY,
	CAVE_PAUSEKEY,
	CAVE_INSERTKEY,
	CAVE_HOMEKEY,
	CAVE_PAGEUPKEY,
	CAVE_ENDKEY,
	CAVE_PAGEDOWNKEY,
	CAVE_NUMLOCKKEY,
	CAVE_PADVIRGULEKEY,
	CAVE_PADASTERKEY,
	CAVE_PADPLUSKEY,

	CAVE_LEFTMOUSE,
	CAVE_MIDDLEMOUSE,
	CAVE_RIGHTMOUSE,
	CAVE_MOUSEX,
	CAVE_MOUSEY,
	CAVE_MOUSEWINX,
	CAVE_MOUSEWINY,

	CAVE_DIAL0,
	CAVE_DIAL1,
	CAVE_DIAL2,
	CAVE_DIAL3,
	CAVE_DIAL4,
	CAVE_DIAL5,
	CAVE_DIAL6,
	CAVE_DIAL7,
	CAVE_DIAL8,
	CAVE_BUT110,
	CAVE_BUT111,
	CAVE_BUT112,
	CAVE_BUT113,
	CAVE_BUT114,
	CAVE_BUT115,
	CAVE_BUT116,
	CAVE_BUT117,
	CAVE_BUT118,
	CAVE_BUT119,
	CAVE_BUT120,
	CAVE_BUT121,
	CAVE_BUT122,
	CAVE_BUT123,
	CAVE_BUT124,
	CAVE_BUT125,
	CAVE_BUT126,
	CAVE_BUT127,
	CAVE_BUT128,
	CAVE_BUT129,
	CAVE_BUT130,
	CAVE_BUT131,
	CAVE_BUT132,
	CAVE_BUT133,
	CAVE_BUT134,
	CAVE_BUT135,
	CAVE_BUT136,
	CAVE_BUT137,
	CAVE_BUT138,
	CAVE_BUT139,
	CAVE_BUT140,
	CAVE_BUT141,

	CAVE_SBPICK,
	CAVE_SBBUT1,
	CAVE_SBBUT2,
	CAVE_SBBUT3,
	CAVE_SBBUT4,
	CAVE_SBBUT5,
	CAVE_SBBUT6,
	CAVE_SBBUT7,
	CAVE_SBBUT8,
	CAVE_SBTX,
	CAVE_SBTY,
	CAVE_SBTZ,
	CAVE_SBRX,
	CAVE_SBRY,
	CAVE_SBRZ,
	CAVE_SBPERIOD,

	CAVE_NUM_DEVICES
	} CAVEDevice;


#define CAVE_REDMASK_BIT	1
#define CAVE_GREENMASK_BIT	2
#define CAVE_BLUEMASK_BIT	4


/* CAVE display window description (from WallDisplay configuration) */
typedef struct
	{
	int		xoff,yoff;
	int		xdim,ydim;
	boolean		window;		/* TRUE == "normal" window - framed, sizeable */
	char		*display_env;	/* definition of DISPLAY variable */
	} CAVE_WINDOW_ST;


/* Offsets for tracker devices */
typedef struct
	{
	float dx,dy,dz;
	} CAVE_OFFSET_ST;

typedef struct
	{
	float axis_x,axis_y,axis_z;
	float theta;
	} CAVE_ROTATION_ST;

typedef struct
	{
	float elem[3][3];
	} CAVE_ROTATIONMATRIX_ST;

typedef struct
	{
	int x0,x1,y0,y1;
	} CAVE_VIEWPORT_ST;


/* Screen geometry; for Screen[0-7], Left_Eye_Wall, & Right_Eye_Wall */
typedef struct
	{
	CAVEID type;
	float lowerleft[3];	/* Position of lower left corner */
	float upperleft[3];	/* Position of upper left corner */
	float lowerright[3];	/* Position of lower right corner */
	} CAVE_PROJINFO_ST;

/* Configuration - contains data from config files */
typedef struct
	{
/* Display stuff */
	int		ActiveWalls;
	CAVE_WALL_ID	DisplayWall[CAVE_MAX_WALLS];
	CAVE_WINDOW_ST	WallGeom[CAVE_NUM_WALL_IDS];
	CAVE_PROJINFO_ST	ProjectionData[CAVE_NUM_WALL_IDS][2];
	CAVEID		WallEyes[CAVE_NUM_WALL_IDS];
	CAVE_VIEWPORT_ST	Viewport[CAVE_NUM_WALL_IDS][2];
	char *		ViewportMask[CAVE_NUM_WALL_IDS][2];
	int		Colormask[CAVE_NUM_WALL_IDS][2];
	float		CAVEWidth,CAVEHeight;
	float		OrigX,OrigY,OrigZ;
	CAVEID		DisplayMode;
	boolean		StereoBuffer;
	CAVE_OFFSET_ST		CAVETranslation;
	CAVE_ROTATIONMATRIX_ST	CAVERotation;
	float		CAVEScale;
	boolean		HideCursor;
	char *		InitCommand[CAVE_NUM_WALL_IDS];
	char *		ExitCommand[CAVE_NUM_WALL_IDS];
/* Tracker stuff */
	boolean		UseTracker;
	boolean		SerialTracking;
	boolean		SensorActive[CAVE_MAX_SENSORS];
	CAVEID		TrackerType;  /* CAVE_BIRDS / CAVE_LOGITECH / etc. */
	char *		TrackerSerialPort[CAVE_MAX_SENSORS];
	int		TrackerBaudRate;
	CAVEID		SyncBirds;
	boolean		FilterBirds;
	int		FilterBirdsParameter;
	CAVEID		BirdsHemisphere;
	int		BirdsSensorsCount;
	int		BirdsSensors[CAVE_MAX_SENSORS];
	int		BirdsTransmitter;
	boolean		UseCalibration;
	char *		CalibrationFile;
	float		DefaultTrackerPosition[3];
	float		DefaultTrackerOrientation[3];
	CAVE_OFFSET_ST		TransmitterOffset;
	CAVE_ROTATIONMATRIX_ST	TransmitterRotationMatrix;
	CAVE_OFFSET_ST		WandSensorOffset;
	CAVE_ROTATIONMATRIX_ST	HeadSensorRotationMatrix;
	CAVE_OFFSET_ST		HeadSensorOffset;
	CAVE_ROTATIONMATRIX_ST	WandSensorRotationMatrix;
	float		InterocularDistance;
	key_t		TrackdKey;
/* Controller stuff */
	CAVEID		ControllerType;
	int		ControllerButtonsCount;
	CAVEDevice	ControllerButtons[CAVE_MAX_BUTTONS];
	int		ControllerValuatorsCount;
	CAVEDevice	ControllerValuators[CAVE_MAX_VALUATORS];
	int		ControllerValuatorsMin[CAVE_MAX_VALUATORS];
	int		ControllerValuatorsMax[CAVE_MAX_VALUATORS];
	key_t		ControllerdKey;
/* Simulator stuff */
	boolean		Simulator;
	CAVEDevice	SimulatorControls[22];
	float		SimViewDistance,SimViewHeight,SimViewWidth;
	CAVEDevice	SimulatorJoystickControl;
	int		SimulatorNumWands;
/* Network stuff */
	CAVEID		Network;
	int		NetworkPort;
	int		NetworkAppPort;
	char *		NetworkAddr;
	float		NetworkUpdateInterval;
	int		NetworkTTL;
	int		NetworkMaxUsers;
	boolean		NetworkCPUHog;
	char *		NetworkTCPServer;
	char *		NetworkUDPHost;
/* Distributed CAVE stuff */
	CAVEID		Distribution;	/* Method - none/Scramnet/TCP */
	CAVEID		AppDistribution;
	int		DistribNodes;
	int		DistribID;
	char *		DistribTCPMaster;
	int		DistribTCPPort;
	boolean		GangSwap;
	boolean		DistribCPUHog;
/* Scramnet stuff */
	boolean		Scramnet;
	char *		ScramnetDevice[2];
	int		ScramnetMemSize;
	int		ScramnetMemBase;
	int		ScramnetRegSize;
	int		ScramnetRegBase;
	short		ScramnetPrefix;
	key_t		SimScramKey;
/* Miscellaneous stuff */
	boolean		CPULock;
	CAVEID		Units;
	key_t		ShmemKey;
/* v2.6 - NCSA extension */
	CAVEID		DisplayType;
	}  CAVE_CONFIG_ST;


/* Display process synchronization data */
typedef	struct
	{
	boolean 	Initted;
	boolean		Quit;
	} CAVE_SYNC_ST;

/* Sensor timestamp (can't use struct timeval because its size is different in 64-bit mode!) */
typedef struct
	{
	uint32_t	sec;
	uint32_t	usec;
	} CAVE_TIMESTAMP_ST;

/* Position & orientation data for trackers */
typedef struct
	{
	float 		x, y, z;
	float 		azim, elev, roll;
	CAVE_TIMESTAMP_ST	timestamp;
	boolean		calibrated;
	CAVEID		frame;		/* CAVE_TRACKER_FRAME or CAVE_NAV_FRAME */
	} CAVE_SENSOR_ST;


/* Collection of buttons & valuators associated with wand */
typedef struct
	{
	uint32_t	num_buttons,num_valuators;
	int32_t		button[CAVE_MAX_BUTTONS];
	float		valuator[CAVE_MAX_VALUATORS];
	} CAVE_CONTROLLER_ST;


typedef uint32_t CAVENETID[2];

/* A networked user - tracker & controller data, & time of last info received.
	Tracker data is in navigated coordinates. */
typedef struct
	{
	CAVENETID		id;
	float			timestamp;
	uint32_t		num_sensors;
	CAVE_SENSOR_ST		sensor[CAVE_MAX_SENSORS];
	CAVE_CONTROLLER_ST	controller;
	void 			*app_data;
	} CAVE_USER_ST;


/* CAVE lock pointer */
typedef struct CAVE_LOCK_ST * CAVELOCK;

typedef void (*CAVECALLBACK)();

typedef void (*CAVECalibrationFunc)(CAVE_SENSOR_ST *,int);


typedef struct
	{
	CAVE_CONFIG_ST		*config;
	volatile CAVE_SYNC_ST	*procsync;
	unsigned int		num_sensors;
	volatile CAVE_SENSOR_ST **sensor;
	volatile CAVE_CONTROLLER_ST	*controller;
	CAVE_WALL_ID		wall;
	CAVEID			eye;
	volatile float		*time;
	volatile float		*framesPerSecond;
	volatile CAVE_USER_ST	**user;
	volatile unsigned int	*numUsers;
 
	struct _CAVEipcdata		*ipc;
	volatile struct _CAVEdispdata	*disp;
	struct _CAVEprojdata		*projection;
	struct _CAVEpipedata		*pipe;
	struct _CAVEchannel		*channel;
	struct _CAVEsimdata		*sim;
	struct _CAVEcallbackdata	*callbacks;
	volatile struct _CAVEtrackerData	*trackerData;
	struct _CAVEdistribdata		*distrib;
	struct _CAVEscramdata		*scram;
	struct _CAVEshmemdata		*shmem;
	volatile struct _CAVEnetdata	*net;
	struct _CAVEprocdata		*proc;
	} CAVE_ST;

extern void	CAVEInit(void);
extern void	CAVEHalt(void);
extern void	CAVEExit(void);
extern void	CAVEDisplay(CAVECALLBACK, int, ...);
extern void	CAVEInitApplication(CAVECALLBACK, int, ...);
extern void	CAVEFrameFunction(CAVECALLBACK, int, ...);
extern void	CAVEStopApplication(CAVECALLBACK, int, ...);
extern void	CAVEAddCallback(CAVEID cbtype, CAVECALLBACK function, void *app_data);
extern void	*CAVEUserSharedMemory(int);
extern void	*CAVEMalloc(size_t);
extern void	CAVEFree(void *p);
extern void	CAVEGetEyePosition(CAVEID eye,float *x,float *y,float *z);
extern void	CAVEConfigure(int *argc,char **argv,char **appdefaults);
extern boolean	CAVEMasterDisplay(void);
extern boolean	CAVEMasterWall(void);
extern void	CAVEDisplayBarrier(void);
extern void	CAVEDisplaySync(void);
extern void	CAVESetOption(CAVEID option,int value);
extern CAVEID	CAVEProcessType(void);
extern int	CAVENumPipes(void);
extern int	CAVEPipeNumber(void);

extern int	CAVEButtonChange(int num);
extern void	CAVEGetSensorVector(CAVE_SENSOR_ST *sensor,CAVEID vecname,float *vec);
extern void	CAVEGetVector(CAVEID vecname,float *vec);
extern void	CAVEGetSensorPosition(CAVE_SENSOR_ST *sensor,CAVEID frame,float *pos);
extern void	CAVEGetPosition(CAVEID posname,float *pos);
extern void	CAVEGetSensorOrientation(CAVE_SENSOR_ST *sensor,CAVEID frame,float *or);
extern void	CAVEGetOrientation(CAVEID oname,float *or);
extern double	CAVEGetTime(void);
extern unsigned int	CAVEGetFrameNumber(void);
extern void	CAVEWallTransform(void);
extern void	CAVEHeadTransform(void);
extern void	CAVEWandTransform(void);
extern void	CAVESensorTransform(CAVE_SENSOR_ST *sensor);
extern boolean	CAVEInStereo(void);
extern void	CAVEGetWindowGeometry(int *origX,int *origY,int *width,int *height);
extern void	CAVEGetViewport(int *x,int *y,int *width,int *height);
extern void	CAVEGetPipeChannels(CAVEID wall[CAVE_NUM_WALL_IDS]);
extern void	CAVEGetActiveChannels(CAVEID wall[CAVE_NUM_WALL_IDS]);
extern float	CAVEConvertToCAVEUnits(float val,CAVEID units);
extern float	CAVEConvertFromCAVEUnits(float val,CAVEID units);
extern void	CAVEGetProjection(CAVE_WALL_ID wall,CAVEID eye,float *frustum,float viewmat[4][4]);

extern CAVELOCK	CAVENewLock(void);
extern void	CAVEFreeLock(CAVELOCK lock);
extern void	CAVESetReadLock(CAVELOCK lock);
extern void	CAVESetWriteLock(CAVELOCK lock);
extern void	CAVEUnsetReadLock(CAVELOCK lock);
extern void	CAVEUnsetWriteLock(CAVELOCK lock);
extern void	*CAVEScramnetMalloc(size_t);
extern void	CAVEScramnetFree(void *p);

extern void	CAVENavLoadIdentity(void);
extern void	CAVENavLoadMatrix(float matrix[4][4]);
extern void	CAVENavGetMatrix(float matrix[4][4]);
extern void	CAVENavMultMatrix(float matrix[4][4]);
extern void	CAVENavTranslate(float x,float y,float z);
extern void	CAVENavRot(float a,char axis);
extern void	CAVENavScale(float x,float y,float z);
extern void	CAVENavPreMultMatrix(float matrix[4][4]);
extern void	CAVENavWorldTranslate(float x,float y,float z);
extern void	CAVENavWorldRot(float a,char axis);
extern void	CAVENavWorldScale(float x,float y,float z);
extern void	CAVENavConvertWorldToCAVE(float *in,float *out);
extern void	CAVENavConvertCAVEToWorld(float *in,float *out);
extern void	CAVENavConvertVectorWorldToCAVE(float *in,float *out);
extern void	CAVENavConvertVectorCAVEToWorld(float *in,float *out);
extern void	CAVENavTransform(void);
extern void	CAVENavInverseTransform(void);
extern void	CAVENavLock(void);
extern void	CAVENavUnlock(void);

extern void	CAVEResetTracker(void);

extern CAVE_USER_ST * CAVENetFindUser(CAVENETID id);
extern void CAVENetGetVector(volatile CAVE_USER_ST *user,CAVEID vecname,float *vec);
extern void CAVENetGetPosition(volatile CAVE_USER_ST *user,CAVEID posname,float *pos);
extern void CAVENetGetOrientation(volatile CAVE_USER_ST *user,CAVEID oname,float *or);
extern void CAVENetHeadTransform(volatile CAVE_USER_ST *user);
extern void CAVENetWandTransform(volatile CAVE_USER_ST *user);
extern void CAVENetSend(void *data,size_t size);
extern int CAVENetReceive(void *buf,size_t size,CAVE_USER_ST **user);
extern boolean CAVEgetbutton(CAVEDevice);
extern int CAVEgetvaluator(CAVEDevice);

extern boolean CAVEDistribOpenConnection(int chanID);
extern void CAVEDistribCloseConnection(int chanID);
extern void CAVEDistribWrite(int chanID,void *buf,size_t size);
extern size_t CAVEDistribRead(int chanID,void *buf,size_t size);
extern void	CAVEDistribBarrier(int chanID);
extern boolean	CAVEDistribMaster(void);
extern unsigned int CAVEDistribNumNodes(void);
extern volatile void * CAVEAllocDisplayData(size_t size);
extern void CAVEPassDisplayData(volatile void *buf,size_t size);
extern void CAVEPassAllDisplayData(void);
extern volatile void * CAVEGetDisplayData(volatile void *buf,size_t *size);
extern boolean CAVEDisplayDataChanged(volatile void *buf);
extern volatile void * CAVEAllocDisplayDataByID(int id,size_t size);
extern void CAVEPassDisplayDataByID(int id,size_t size);
extern volatile void * CAVEGetDisplayDataByID(int id,size_t *size);
extern boolean CAVEDisplayDataChangedByID(int id);
extern boolean CAVEDisplayDataIDExists(int id);
extern int CAVEGetDisplayDataID(volatile void *buf);
extern int CAVENewID(void);

extern void  CAVESetCalibrationFunc(CAVECalibrationFunc callback);


extern Display * CAVEXDisplay(void);
extern Window CAVEXWindow(void);
extern XVisualInfo *CAVEXVisualInfo(void);
extern GLXContext CAVEGLXContext(void);



/* CAVE library global data;  data in shared memory is declared volatile */
extern	CAVE_ST			*CAVEptr;

extern	volatile float     	*CAVEFramesPerSecond;
extern	volatile float		*CAVETime;
extern	CAVE_WALL_ID		CAVEWall;
extern	CAVE_CONFIG_ST		*CAVEConfig;
extern	volatile CAVE_SYNC_ST  	*CAVESync;     
extern	volatile CAVE_SENSOR_ST	*CAVESensor1, *CAVESensor2;
extern  float    		CAVENear, CAVEFar;
extern	CAVEID			CAVEEye;
extern	char 			*CAVEVersion;
extern	volatile CAVE_CONTROLLER_ST	*CAVEController;
extern	volatile CAVE_USER_ST		**CAVEUser;
extern	volatile unsigned int		*CAVENumUsers;


#ifdef __cplusplus
}
#endif

#endif

