// Greg Kaiser
//
// CS290 with Prof. Francis
// 4D Tetris
//
// Shared.h
// Last modified: April 17, 1996
//
// (C) 1996 Board of Trustees University of Illinois

#ifndef _SHARED_H_
#define _SHARED_H_

#define X 0
#define Y 1
#define Z 2
#define W 3


//attempt to convert to OpenGL
#define BF_SA GL_SRC_ALPHA
#define BF_MSA GL_ONE_MINUS_SRC_ALPHA

#define pushmatrix()   {glMatrixMode(GL_MODELVIEW); glPushMatrix();}
#define loadmatrix   glLoadMatrixf
#define multmatrix   glMultMatrixf
#define popmatrix    glPopMatrix
#define bgntmesh()   glBegin(GL_TRIANGLE_STRIP) 
#define endtmesh     glEnd
#define bgnpolygon() glBegin(GL_POLYGON)
#define endpolygon() glEnd
#define bgnline()    glBegin(GL_LINE_STRIP);
#define endline      glEnd
#define linewidth   
#define depthcue    
#define v3f          glVertex3fv
#define v2f          glVertex2fv
#define translate    glTranslatef
#define viewport     glViewport
#define window       glFrustum
#define ortho        glOrtho
#define ortho2(a,b,c,d)   glOrtho(a,b,c,d,10.0,-10) /* ogl has no ortho2 ?? */
#define swapbuffers  glutSwapBuffers
#define rectzoom     glPixelZoom
#define blendfunction glBlendFunc
#define zbuffer(a) glEnable(GL_DEPTH_TEST)
#define doublebuffer ChoosePixelFormat
//#define clear() glClear(GL_COLOR_BUFFER_BIT) // has problems with clear in the iostream library
#define zclear() glCear(GL_DEPTH_BUFFER_BIT)

#include <GL/gl.h>


/**********************************************************************/
//void rotate(int angle, int axis){return;}
void getmatrix(float* mat){glGetFloatv(GL_MODELVIEW_MATRIX, mat);}
/**********************************************************************/
//int getbutton(unsigned char key){ /* returns that keybit was set */
//  if(CLAW & (1<<key)){ CLAW &= (-1 ^ (1 << key)); return 1;}
//  else return 0; /* and if it was, unsets it */  /* gkf 23jul2K */
//}

void rectcopy(int x1, int y1, int x2, int y2, int newx, int newy){
    glCopyPixels( x1, y1, x2-x1, y2-y1,  GL_COLOR); 
}

void cpack(long hexad){
   float red, green, blue;
   red   = (hexad & 255)/255.;
   green = ((hexad >> 8) & 255)/255.;
   blue =  ((hexad >> 16)& 255)/255.;
   glColor3f(red,green,blue);
 }


void lrectwrite(int x1, int y1, int x2, int y2, unsigned long* offbase){
    int pair[2]; 
    pair[0]=x1;
    pair[1]=y1;
    glRasterPos2iv(pair) ;
    glDrawPixels(x2-x1, y2-y1, GL_RGB, GL_UNSIGNED_INT, offbase);

}




#endif


