//  illiShell in C++ VERSION TWO 1996
//  Original illishell George Francis, Glenn Chappell, Chris Hartman
// F  C++ version: Alex Bourd, George Francis     
//  started on June 15, 1996, 23pm 
//  gkf 7 nov 96  3D-tractor on the middle  wand button
//  full wrist action restored in CONTROL mode
//  how do you deFault a gadget to 1 in viewmode and 0 in cavemode ?? 
//  autotymer is now the way it was in the snail
//  the speed difference screws up the timing so you 
// can't do it by counting raw cycles 
//  you need to count actual time.
//  alternatively, do each scene on demand.
// 12feb97 modifications for Van der Pol gkf cmh 
// Modified from Iris to OpenGL by Ann Delano Spring '99
// Modified to work on Mac by Matt Hall, Fall '99 





#include "phaser.h"

unsigned int BUT,XX,YY,SHIF; 
int xt,yt,xo,yo; 

/*************************/
#ifdef SOUND
#include "vssClient.h"
char* AIFFDIR = getenv("AIFFDIR");
if (getenv("AIFFDIR")==NULL){
   fprintf(stderr," Environment variable AIFFDIR is not set \n");
   fprintf(stderr," It should contain the path to .aiff files\n");
   fprintf(stderr," set the variable and restart.\n");
   exit(-1);
        }

#endif

//forward prototypes
#ifdef SOUND
float aSampleActor;
int soundinter;
#endif

#define  WALL  -5. // for IWALL; -5.0 for CAVE; and ?? for IDESK  fixit!!



void char2wall(char buf[]) {
     char *p;
     void *font = GLUT_BITMAP_9_BY_15;
     for(p = buf;*p;p++) glutBitmapCharacter(font,*p);
}




/* these are used only in console mode      */
int binoc;    /* flag                       */
float nose;   /* to eye distance in console */


float mysiz,speed,torq,focal,ffar;        /*notCAVE navigation variables */




//*********** include functions for right-hand sides and parameters*******
//+----------------------------------------------------------------------+
//+---------------------------   generic function  ----------------------+
//+----------------------------------------------------------------------+
#define ZDESK(y) ((-39.3834-y*-14.3213)/(-18.3319))
//************************************************************************
template <class A> A MAX(A x,A y) { return (x<y)?y:x; }
//************************************************************************
template <class A> A MIN(A x,A y) { return (x>y)?y:x; }
//************************************************************************
template <class A> A ABS(A x) { return (x<0)?-x:x; }
//************************************************************************
float DOT(float *p,float *q){
return (*p*(*q)+(*(p+1))*(*(q+1))+(*(p+2))*(*(q+2)));
}
//************************************************************************
float NRM(float *p){ return (float)sqrt(DOT(p,p)); }
#ifdef SOUND
void audioprep()
{

   if (!FBgnSoundServer())
      fprintf(stderr,"UDP connection to sound server failed\n");

   aSampleActor = createActor(SampleActor);
   actorMessage (A_SetPrintCommands, "F", 1.);
   actorMessage(A_SetDirectory, "FS", aSampleActor, AIFFDIR);
}
void cleanup(void)
{
  EndSoundServer();
}
#endif

//FORWARD prototypes
void app_init(void){
#ifdef CAVE
    CAVEFar=1000.0;
#endif
};
//************************************************************************
//************ DEFINITION OF THE CLASS VIEW ******************************
//************************************************************************
#define  siz     (s_var->s_siz)    //code beautification kludge
#define  aff     (s_var->s_aff)    //by Stuart Levy, October 1993
#define  starmat (s_var->s_star)   //list matches and is documented
#define  lu      (s_var->s_lu)     // in structure definition below
#define  mode    (s_var->s_mode)
#define  aff2     (s_var->s_aff2)
#define  msg     (s_var->s_msg)
#define  wnd     (s_var->s_wnd)
#define  gnd     (s_var->s_gnd)
#define mauspaw  (s_var->s_paw)
#define mausx    (s_var->s_maus[0])
#define mausy    (s_var->s_maus[1])
#define speed    (s_var->s_speed)
#define torq     (s_var->s_torq)
#define fpss     (s_var->s_fpss)


  



//************************************************************************
void view::startcave(void)  { }  // C++ uglification

//**************************************************************************
void view::initstars(void) {
  int ii,jj,kk=117; 
  srandom(kk); // seed random generator
  for(ii=0;ii<1000;ii++)
     for(jj=0;jj<3;jj++)star[ii][jj] =((float)random())/(float)0x40000000-1.;
}




void view::drawstars(void){
  int ii;
  return;   //because they don't work right (wrong location)
  glPushMatrix();
  {
  Matrix tmpmat; 
  for (int ii=0;ii<16;ii++)
  	tmpmat[ii]=starmat[ii];
  glMultMatrixf(tmpmat);
  } //scramnet uglification since starmat is shared
//  glColor4f(1.0,1.0,0.0,0.0);    
  glColor4f(1.0,1.0,0.0,1.0);   // alpha is wrong?    
  glBegin(GL_POINTS);
   for(ii=0;ii<1000;ii++) glVertex3fv(star[ii]);
  glEnd();
  glPopMatrix();
  glClear(GL_DEPTH_BUFFER_BIT);
}

//**************************************************************************
// illiLighting Model
// Returns *colr diminished by Lambert cosine =(light.normal) directions,
// clamped to ambient fraction and pseudo-specular (caustic) highlights.

int view::light(float *nv, int *colr) {
float AMB=.2,PWR=16.;
int rr,gg,bb;
float spec,lmb;
   rr=*colr;  gg=*(colr+1);  bb=*(colr+2);
   lmb = DOT(nv,lu);              // Lambert cosine
   lmb = (lmb<0.)?-.5*lmb:lmb;    //for 50 % backlight
   lmb = MAX(lmb,AMB);            //clamp to ambient fraction
   spec=MIN(1.,1.*( 1. - PWR + PWR*lmb)); //clamp to pseudo-specular
   rr =(int)MAX(lmb*rr, spec);    // maximal envelope of three lines
   gg =(int)MAX(lmb*gg, spec);
   bb =(int)MAX(lmb*bb, spec);
   return(0+ (bb<<16) + (gg<<8)+rr);
}

//**************************************************************************
void view::deFault(void){
int ii,jj;
float tmp;
   for(ii=0;ii<numgf;ii++)agf[ii]->set_default();
   for(ii=0;ii<numgi;ii++)agi[ii]->set_default();
   mauspaw = 0;
   wnd = 1;
   for(ii=0;ii<4;ii++)
     for(jj=0;jj<4;jj++) starmat[4*ii+jj]=aff[4*ii+jj]=id[4*ii+jj];  //initializes matrices to identity
   tmp=NRM(lux);
   for(ii=0;ii<3;ii++)lux[ii]/=tmp;
   aff[12]= 0.; aff[13]= 0.; aff[14]= -10.2;
}

//**************************************************************************
void view::calculite(void)
{ int ii,jj;   //orthogonal^inverse = orthogonal^transpose !!
  for(ii=0;ii<3;ii++)
     { lu[ii]=0; for(jj=0;jj<3;jj++) lu[ii] += aff[4*ii+jj]*lux[jj];}
}


//**************************************************************************
void view::control(char ch, int mods){
   int ii;
   for(ii=0;ii<numgf;ii++)agf[ii]->keyboard(ch, mods);
   for(ii=0;ii<numgi;ii++)agi[ii]->keyboard(ch, mods);
   if (ch=='z') deFault();
}

//**************************************************************************
float view::speedometer(void){
/*
double  dbl;
static double rate;
static int ii=0;
static struct timezone notused;
static struct timeval now, then;
   if(++ii % 8 == 0){                       // 8 times around measure time
     gettimeofday (&now, &notused);          // elapsed time
     dbl =  (double)(now.tv_sec - then.tv_sec)
           +(double)(now.tv_usec - then.tv_usec)/1000000;
     then = now;  rate = 8/dbl;
     fpss=(float)rate;
     }
     return((float)rate);
     */
     return 0;
}

//**************************************************************************
void view::messages(void){      // Heads up display for console

int ii; float ht,tt;
char phrase[256];
short cred,cblue,cgreen;
glClear(GL_DEPTH_BUFFER_BIT);
glMatrixMode(GL_MODELVIEW);
glLoadIdentity();
glMatrixMode(GL_PROJECTION);
// gluOrtho2D(-1.,1.,-1.,1.); glColor4f(1.0,0.0,1.0,0.0);
gluOrtho2D(-1.,1.,-1.,1.); glColor4f(1.0,0.0,1.0,1.0); //alpha?
sprintf(phrase,"%0.1f",speedometer());glRasterPos2f(-.9,-.9);char2wall(phrase);
tt=xt/(float)yt;
glLoadIdentity();
gluOrtho2D(-tt,tt,-1.,1.);
  if(mode ==0)
	glColor4f(1.0,0.0,0.8,0.2);
  else 
	glColor4f(1.0,0.5,0.5,0.5); 
  if(mode==0)
	glColor4f(1.0,1.0,0.0,1.0); 
  else
	glColor4f(1.0,0.0,1.0,1.0);
sprintf(phrase,"(ESC)ape");glRasterPos2f(-1.1,.95);char2wall(phrase);
sprintf(phrase,"illiFlow++ by Alex Bourd, George Francis, Ann Delano, Matt Hall U Illinois, 1999");
glRasterPos2f(-.5,-.97);char2wall(phrase);


 glRasterPos2f(-1.1,-.05);
  glColor4f(1.0,0.0,0.0,1.0);
  sprintf(phrase,"         Z  ");
  char2wall(phrase);
  glColor3b(cred,cgreen,cblue);
  sprintf(phrase,"zap this/all");
  char2wall(phrase);

  glRasterPos2f(-1.1,-.10);
 
  glColor4f(1.0,1.0,1.0,1.0);
  sprintf(phrase,"BACKSPACEKEY ");   // so where is CTL-C picked up ??????
  char2wall(phrase);
  glColor3b(cred,cgreen,cblue);
  sprintf(phrase,"IC");
  char2wall(phrase);

for(ii=0, ht= -.15 ; ii < numgf; ii++, ht -= .05){
  glRasterPos2f(-1.1, ht); agf[ii]->print_message();
  }
for(ii=0, ht= -.15-numgf*.05 ; ii < numgi-3; ii++, ht -= .05){
  glRasterPos2f(-1.1, ht); agi[ii]->print_message();
  }
}

//**************************************************************************
int view::chaptrack(int xx,int yy){
   #define RMAUS 6
   #define MMAUS 5
   #define LMAUS 4
   long dx,dy;
   rmaus=lmaus=mmaus=0;
   if (BUT & 4)rmaus=SHIF?-1:1;
   if (BUT & 2)mmaus=SHIF?-1:1;
   if (BUT & 1)lmaus=SHIF?-1:1;
   dx = XX -.5*xt; dx = abs(dx)>5?dx:0;    
   dy = YY -.5*yt; dy = abs(dy)>5?dy:0;
   #ifdef macintosh
   dy=-dy;
   #endif
   GLenum terr=glGetError();
   glMatrixMode(GL_MODELVIEW);
   glLoadIdentity();
   if(mode==0) glTranslatef(aff[12],aff[13],aff[14]);
   glRotatef(dx*torq,0,1,0); glRotatef(-dy*torq, 1,0,0);
   if(mode==1){                            //make the star matrix rotate
	  glPushMatrix(); glLoadIdentity();
      glRotatef(dx*torq,0,'y',0); glRotatef(-dy*torq, 1,0,0);
      if(rmaus==1) glRotatef(-10,0,0,1);
      if(rmaus==-1) glRotatef(-1,0,0,1);
      if(lmaus==1) glRotatef(10,0,0,1);
      if(lmaus==-1) glRotatef(1,0,0,1);
      glMultMatrixf(starmat); glGetFloatv(GL_MODELVIEW_MATRIX,starmat);
      glPopMatrix();
      }
    if(rmaus==1)  glRotatef(-10,0,0,1);
    if(rmaus==-1) glRotatef(-1,0,0,1);
    if(lmaus==1)  glRotatef(10,0,0,1);
    if(lmaus==-1) glRotatef(1,0,0,1);
    if(mmaus==1)  glTranslatef(0.,0.,-speed);
    if(mmaus==-1) glTranslatef(0.,0.,speed);
    if(mode==0) glTranslatef(-aff[12],-aff[13],-aff[14]);
    glMultMatrixf(aff);
    glGetFloatv(GL_MODELVIEW_MATRIX,aff);
    calculite();
    return 0;
}






//**************************************************************************
view::view(int win) {
  int i,j;
     
  if(caveyes)
#ifdef CAVE
      s_var=(share_var *)CAVEMalloc(sizeof(struct share_var))
#endif
		;
    else
      s_var = new struct share_var;
    if(s_var==0){ 
       // cout<<"I can't allocate memory for struct share_var %x \n";
      exit(1);
     }

  lux[0]=1.; lux[1]=2.; lux[2]=3.;             //light source direction vector
  for(i=0;i<4;i++)
    for(j=0;j<4;j++) 
	if (i==j)  
		id[i*4+j]=1.0; 
	else 
		id[i*4+j]=0.0; //Kronecker delta for id
//         param  default   message     button          min  max  step
agf[0]=new gadget<float>(&speed,.40,"(S)peed ","S", 's',MULT,0.001,1.0,1.02,SLIDER,NOSOAK);
agf[1]=new gadget<float>(&torq, .02,"Tor(Q)ue","Q", 'q',MULT,.0005,.08,1.02,SLIDER,NOSOAK);
agf[2]=new gadget<float>(&mysiz,.01,"My s(I)ze","I", 'i',MULT,.005,1.0,1.02,SLIDER,NOSOAK);
agf[3]=new gadget<float>(&siz,   3.,"cav(E)size","E", 'e',MULT,.05,20.,1.02,SLIDER,NOSOAK);
agf[4]=new gadget<float>(&nose, .06,"(N)ose","N", 'n',MULT,.01,.3,1.02,SLIDER,NOSOAK);
agf[5]=new gadget<float>(&focal, 2.,"F(O)cal","O", 'o',MULT,0.3,10.0,1.02,SLIDER,NOSOAK);
agf[6]=new gadget<float>(&ffar,  555.,"Fa(R)","R", 'r',MULT,1.,1000.,1.02,SLIDER,NOSOAK);
agi[0]=new gadget<int>(&binoc,  0,"Stereo(V)iew","V", 'v',ADD,   0,  1,  1,CYCLER,SOAK);
agi[1]=new gadget<int>(&mode,   0,"Navigation mode","SPACEKEY", ' ',ADD,0,1,1,CYCLER,SOAK);
agi[2]=new gadget<int>(&gnd,    0,"B/W mask","*", '*',ADD,0,1,1,CYCLER,SOAK);
agi[3]=new gadget<int>(&msg,    1,"Messages","INSERT", GLUT_KEY_INSERT+128,ADD,0,1,1,CYCLER,SOAK);
agi[4]=new gadget<int>(&lmaus,  0,"leftMouse","", LEFTMOUSE,  ADD,-1,1,1,SLIDER,NOSOAK);
agi[5]=new gadget<int>(&mmaus,  0,"midMouse","", MIDDLEMOUSE,ADD,-1,1,1,SLIDER,NOSOAK);
agi[6]=new gadget<int>(&rmaus,  0,"rightMouse","", RIGHTMOUSE, ADD,-1,1,1,SLIDER,NOSOAK);
numgf=7; numgi=7;     //change these when adding gadgets
deFault();

}
//**************************************************************************
view::~view(void){  // free memory;
   delete s_var;
}


//**************************************************************************
//*******  DEFINITION OF THE CLASS "PHASE" - User's object *****************
//**************************************************************************
#define  lightvec  (s_phase->s_lightvec)
#define  currpar   (s_phase->s_currpar)
#define  currvar   (s_phase->s_currvar)
#define  fmb       (s_phase->s_fmb)
#define  orb       (s_phase->s_orb)
#define  dsx       (s_phase->s_dsx)
#define  dsy       (s_phase->s_dsy)
#define  dsz       (s_phase->s_dsz)
#define  kt        (s_phase->s_kt)
#define  hhh       (s_phase->s_hhh)
#define  gray      (s_phase->s_gray)
#define  rgbase    (s_phase->s_rgbase)
#define  tlength   (s_phase->s_tlength)
#define  vlength   (s_phase->s_vlength)
#define  oshow     (s_phase->s_oshow)
#define  show      (s_phase->s_show)
#define  minx      (s_phase->s_box[0])
#define  midx      (s_phase->s_box[6])
#define  maxx      (s_phase->s_box[1])
#define  miny      (s_phase->s_box[2])
#define  midy      (s_phase->s_box[7])
#define  maxy      (s_phase->s_box[3])
#define  minz      (s_phase->s_box[4])
#define  midz      (s_phase->s_box[8])
#define  maxz      (s_phase->s_box[5])
#define  boxscale  (s_phase->s_boxscale)
#define  tdir      (s_phase->s_tdir)
#define  nfirst    (s_phase->s_nfirst)
#define  norbits   (s_phase->s_norbits)
#define  nvorbits  (s_phase->s_nvorbits)
#define  mfc       (s_phase->s_mfc)
#define  colourB   (s_phase->s_colourB)
#define  colourG   (s_phase->s_colourG)
#define  colourR   (s_phase->s_colourR)
#define  nc        (s_phase->s_nc)
#define  kc        (s_phase->s_kc)
#define  reg       (s_phase->s_reg)
#define  param     (s_phase->s_param)
#define  pstep     (s_phase->s_pstep)
#define  numparam  (s_phase->s_numparam)
#define  axes      (s_phase->s_axes)
#define  pfps      (s_phase->s_pfps)
#define  slength   (s_phase->s_slength)
#define  show_ic   (s_phase->s_show_ic)
#define  intcon    (s_phase->s_intcon)
#define  ep        (s_phase->s_ep)
#define  ieq       (s_phase->s_ieq)
#define  oieq      (s_phase->s_oieq)
#define  box       (s_phase->s_box)
#define  morph     (s_phase->s_morph)



// **************************************************************
void phase::show_initial_conditions(void)
{ int i;
  float rad;
  rad=(maxx-miny)*0.01;
  float vv1[3],vv2[3],xx[3];
  for(i=0;i<norbits;i++)
    {
    xx[0]=intcon[i][0]; xx[1]=intcon[i][1]; xx[2]=intcon[i][2];
    glColor4f(1.0,0.0,0.0,1.0);
    vv1[0]=xx[0]-rad; vv2[0]=xx[0]+rad;
    vv1[1]=vv2[1]=xx[1];
    vv1[2]=vv2[2]=xx[2];
    glBegin(GL_LINE_STRIP); glVertex3fv(vv1); glVertex3fv(vv2);  glEnd();
    glColor4f(1.0,0.0,1.0,1.0);
    vv1[1]=xx[1]-rad; vv2[1]=xx[1]+rad;
    vv1[0]=vv2[0]=xx[0];
    vv1[2]=vv2[2]=xx[2];
    glBegin(GL_LINE_STRIP); glVertex3fv(vv1); glVertex3fv(vv2);  glEnd();
    glColor4f(1.0,1.0,0.0,1.0);
    vv1[2]=xx[2]-rad; vv2[2]=xx[2]+rad;
    vv1[1]=vv2[1]=xx[1];
    vv1[0]=vv2[0]=xx[0];
    glBegin(GL_LINE_STRIP); glVertex3fv(vv1); glVertex3fv(vv2);  glEnd();
    }
 
}
// **************************************************************
void phase::runge_mult(float ic[],int i,int nf,int npoints)
{  float q1, q2, q3, q4,                // temporary variables for
         r1, r2, r3, r4,                // Runge-Kutta
         s1, s2, s3, s4,                //
         dx,dy,dz,                      //
         x1,y1,z1,t1,                   //
         tmp1,tmp2,tmp3,tmp4,           //
         h;                             // time step
   int   k;                             // counter for points
         h=fabs(hhh)*tdir[i]; //tdir[i] =1 or -1 direction of time
         t1=0.0; x1=ic[0]; y1=ic[1]; z1=ic[2];
   for(k=nf;k<nf+npoints;k=(++k)%MAX_LENGTH_OF_ORBIT)
                           // generate n point starting at i
     { // step 1
       q1=h*ep->der_x(t1,x1,y1,z1,param);
       r1=h*ep->der_y(t1,x1,y1,z1,param);
       s1=h*ep->der_z(t1,x1,y1,z1,param);
       // step 2
       tmp1=t1+0.5*h; tmp2=x1+0.5*q1; tmp3=y1+0.5*r1;  tmp4=z1+0.5*s1;
       q2=h*ep->der_x(tmp1,tmp2,tmp3,tmp4,param);
         r2=h*ep->der_y(tmp1,tmp2,tmp3,tmp4,param);
       s2=h*ep->der_z(tmp1,tmp2,tmp3,tmp4,param);
       // step 3
       tmp1=t1+0.5*h; tmp2=x1+0.5*q2; tmp3=y1+0.5*r2;  tmp4=z1+0.5*s2;
       q3=h*ep->der_x(tmp1,tmp2,tmp3,tmp4,param);
       r3=h*ep->der_y(tmp1,tmp2,tmp3,tmp4,param);
       s3=h*ep->der_z(tmp1,tmp2,tmp3,tmp4,param);
       // step 4
       tmp1=t1+h; tmp2=x1+q3; tmp3=y1+r3;  tmp4=z1+s3;
       q4=h*ep->der_x(tmp1,tmp2,tmp3,tmp4,param);
       r4=h*ep->der_y(tmp1,tmp2,tmp3,tmp4,param);
       s4=h*ep->der_z(tmp1,tmp2,tmp3,tmp4,param);
       // changes in x,y,z
       dx=(q1+q2+q2+q3+q3+q4)/6.0;
       dy=(r1+r2+r2+r3+r3+r4)/6.0;
       dz=(s1+s2+s2+s3+s3+s4)/6.0;
       // cliping, when orbits goes out of the limit of the box
       orb[i][k][0]=x1; orb[i][k][1]=y1; orb[i][k][2]=z1;
       if ((x1>minx)&&(x1<maxx)&&(y1>miny)&&(y1<maxy)&&(z1>minz)&&(z1<maxz))
           orb[i][k][3]=1.0;
         else
           orb[i][k][3]=-1.0;
       t1+= h; x1+=dx; y1+=dy; z1+=dz;
            }
}
// **************************************************************
inline void phase::runge_one(float ic[],int i,int nf)
{ float q1, q2, q3, q4,                // temporary variables for
        r1, r2, r3, r4,                // Runge-Kutta
        s1, s2, s3, s4,                //
        dx,dy,dz,                      //
        x1,y1,z1,t1,                   //
        tmp1,tmp2,tmp3,tmp4,           //
        h;                             // time step
   int  k;                             // counter for points
        h=fabs(hhh)*tdir[i]; //tdir[i] =1 or -1 direction of time
        t1=0.0; x1=ic[0]; y1=ic[1]; z1=ic[2];
       // new setup
        k=nf;
       // step 1
       q1=h*ep->der_x(t1,x1,y1,z1,param);
       r1=h*ep->der_y(t1,x1,y1,z1,param);
       s1=h*ep->der_z(t1,x1,y1,z1,param);
       // step 2
       tmp1=t1+0.5*h; tmp2=x1+0.5*q1; tmp3=y1+0.5*r1;  tmp4=z1+0.5*s1;
       q2=h*ep->der_x(tmp1,tmp2,tmp3,tmp4,param);
           r2=h*ep->der_y(tmp1,tmp2,tmp3,tmp4,param);
       s2=h*ep->der_z(tmp1,tmp2,tmp3,tmp4,param);
       // step 3
       tmp1=t1+0.5*h; tmp2=x1+0.5*q2; tmp3=y1+0.5*r2;  tmp4=z1+0.5*s2;
       q3=h*ep->der_x(tmp1,tmp2,tmp3,tmp4,param);
       r3=h*ep->der_y(tmp1,tmp2,tmp3,tmp4,param);
       s3=h*ep->der_z(tmp1,tmp2,tmp3,tmp4,param);
       // step 4
       tmp1=t1+h; tmp2=x1+q3; tmp3=y1+r3;  tmp4=z1+s3;
       q4=h*ep->der_x(tmp1,tmp2,tmp3,tmp4,param);
       r4=h*ep->der_y(tmp1,tmp2,tmp3,tmp4,param);
       s4=h*ep->der_z(tmp1,tmp2,tmp3,tmp4,param);
       // changes in x,y,z
       dx=(q1+q2+q2+q3+q3+q4)/6.0;
       dy=(r1+r2+r2+r3+r3+r4)/6.0;
       dz=(s1+s2+s2+s3+s3+s4)/6.0;
       t1+= h; x1+=dx; y1+=dy; z1+=dz;
       orb[i][k][0]=x1; orb[i][k][1]=y1; orb[i][k][2]=z1;
       // cliping, when orbits goes out of the limit of the box
       if ((x1>minx)&&(x1<maxx)&&(y1>miny)&&(y1<maxy)&&(z1>minz)&&(z1<maxz))
           orb[i][k][3]=1.0;
         else
           orb[i][k][3]=-1.0;

    
}
//*************************************************************************
void phase::calc_ribbons_regular(void)     // prepare to draw ribbons
{ int i,ix,iy,iz;
  float ic[3],ic2[3],hx,hy,hz;
     //calculations of trajectories
tlength=vlength;
     norbits=4*rgbase*rgbase*rgbase;
     ix=iy=iz=0;
     hx=0.9*(maxx-minx)/(rgbase-1.0) ;
     hy=0.9*(maxy-miny)/(rgbase-1.0) ;
     hz=0.9*(maxz-minz)/(rgbase-1.0) ;
     for(i=0;i<norbits;i++)
       {
       // generating of initial points
       ic[0]=(float)hx*ix+minx+0.05*(maxx-minx);
       ic[1]=(float)hy*iy+miny+0.05*(maxy-miny);
       ic[2]=(float)hz*iz+minz+0.05*(maxz-minz);
       colourR[i]=(int)(90.0+135.0*(ic[0]-minx)/(maxx-minx));
       colourG[i]=(int)(90.0+135.0*(ic[1]-miny)/(maxy-miny));
       colourB[i]=(int)(90.0+135.0*(ic[2]-minz)/(maxz-minz));
       iz=(iz+1) % rgbase;
       if((iy==0)&&(iz==0)) ix=(ix+1) % rgbase;
       tdir[i]=1;
       runge_mult(ic,i,0,tlength);  // ic[], time forward
       intcon[i][0]=orb[i][0][0];intcon[i][1]=orb[i][0][1];intcon[i][2]=orb[i][0][2];
       i++;
       tdir[i]=-1;
       runge_mult(ic,i,0,tlength);  // ic[], time backward
       intcon[i][0]=orb[i][0][0];intcon[i][1]=orb[i][0][1];intcon[i][2]=orb[i][0][2];
       i++;
       ic2[0]=ic[0]+0.03*hx;   // NOTE: coefficient is questionable
       ic2[1]=ic[1]+0.02*hy;
       ic2[2]=ic[2]-0.02*hz;
       tdir[i]=1;
       runge_mult(ic2,i,0,tlength);  // ic2[], time forward (second for ribbon)
       intcon[i][0]=orb[i][0][0];intcon[i][1]=orb[i][0][1];intcon[i][2]=orb[i][0][2];
       i++;
       tdir[i]=-1;
       runge_mult(ic2,i,0,tlength);  // ic2[], time backward (second for ribbon)
       intcon[i][0]=orb[i][0][0];intcon[i][1]=orb[i][0][1];intcon[i][2]=orb[i][0][2];
       }
   nvorbits=norbits;
}
//*************************************************************************
void phase::calc_ribbons_random(void)     // prepare to draw ribbons
{ int i,ix,iy,iz;
  float ic[3],ic2[3],hx,hy,hz;
     //calculations of trajectories
     ix=iy=iz=0;
tlength=vlength;
     //seed the random number generator
     srandom(5);
     hx=0.5*(maxx-minx);
     hy=0.5*(maxy-miny);
     hz=0.5*(maxz-minz);
     for(i=0;i<norbits;i++)
       {
       // generating of initial points
       ic[0]=minx+hx*(float)random()/((float)0x40000000-1);
       ic[1]=miny+hy*(float)random()/((float)0x40000000-1);
       ic[2]=minz+hz*(float)random()/((float)0x40000000-1);
       colourR[i]=(int)(90.0+135.0*(ic[0]-minx)/(maxx-minx));
       colourG[i]=(int)(90.0+135.0*(ic[1]-miny)/(maxy-miny));
       colourB[i]=(int)(90.0+135.0*(ic[2]-minz)/(maxz-minz));
       iz=(iz+1) % rgbase;
       if(iz==0) iy=(iy+1) % rgbase;
       if((iy==0)&&(iz==0)) ix=(ix+1) % rgbase;
       tdir[i]=1;
       runge_mult(ic,i,0,tlength);  // ic[], time forward
       intcon[i][0]=orb[i][0][0];intcon[i][1]=orb[i][0][1];intcon[i][2]=orb[i][0][2];
       i++;
       tdir[i]=-1;
       runge_mult(ic,i,0,tlength);  // ic[], time backward
       intcon[i][0]=orb[i][0][0];intcon[i][1]=orb[i][0][1];intcon[i][2]=orb[i][0][2];
       i++;
       ic2[0]=ic[0]+0.05*hx;   // NOTE: coefficient is questionable
       ic2[1]=ic[1]+0.05*hy;
       ic2[2]=ic[2]-0.05*hz;
       tdir[i]=1;
       runge_mult(ic2,i,0,tlength);  // ic2[], time forward (second for ribbon)
       intcon[i][0]=orb[i][0][0];intcon[i][1]=orb[i][0][1];intcon[i][2]=orb[i][0][2];
       i++;
       tdir[i]=-1;
              runge_mult(ic2,i,0,tlength);  // ic2[], time backward (second for ribbon)
       intcon[i][0]=orb[i][0][0];intcon[i][1]=orb[i][0][1];intcon[i][2]=orb[i][0][2];
       }
   nvorbits=norbits;
}
//***********************************************************************
void phase::draw_gray_points(void)     // DRAWING OF GRAY POINTS
{ float stx,sty,stz,v[3];
   stx=0.1*(maxx-minx);
   sty=0.1*(maxy-miny);
   stz=0.1*(maxz-minz);
   glColor4f(1.0,0.3,0.9,0.9);
   glBegin(GL_POINTS);
     for(v[0]=minx;v[0]<=maxx;v[0]+=stx)
       for(v[1]=miny;v[1]<=maxy;v[1]+=sty)
         for(v[2]=minz;v[2]<=maxz;v[2]+=stz)
           glVertex3fv(v);
    glEnd();
}
//*************************************************************************
void phase::draw_axes(void)
{ float vert[20][3];

       // recalculating box and axes
     vert[0][0]=minx; vert[0][1]=miny;  vert[0][2]=minz;
     vert[1][0]=minx; vert[1][1]=maxy;  vert[1][2]=minz;
     vert[2][0]=minx; vert[2][1]=maxy;  vert[2][2]=maxz;
     vert[3][0]=maxx; vert[3][1]=maxy;  vert[3][2]=maxz;
     vert[4][0]=maxx; vert[4][1]=maxy;  vert[4][2]=minz;
     vert[5][0]=maxx; vert[5][1]=miny;  vert[5][2]=minz;
     vert[6][0]=maxx; vert[6][1]=miny;  vert[6][2]=maxz;
     vert[7][0]=minx; vert[7][1]=miny;  vert[7][2]=maxz;

     vert[8][0]=minx-0.2*(maxx-minx);
     vert[8][1]=0.5*(miny+maxy);
     vert[8][2]=0.5*(minz+maxz);

     vert[9][0]=maxx+0.2*(maxx-minx);
     vert[9][1]=0.5*(miny+maxy);
     vert[9][2]=0.5*(minz+maxz);

     vert[10][0]=0.5*(minx+maxx);
     vert[10][1]=miny-0.2*(maxy-miny);
     vert[10][2]=0.5*(minz+maxz);

     vert[11][0]=0.5*(minx+maxx);
     vert[11][1]=maxy+0.2*(maxy-miny);
     vert[11][2]=0.5*(minz+maxz);

     vert[12][0]=0.5*(minx+maxx);
     vert[12][1]=0.5*(miny+maxy);
     vert[12][2]=minz-0.2*(maxz-minz);

     vert[13][0]=0.5*(minx+maxx);
     vert[13][1]=0.5*(miny+maxy);
     vert[13][2]=maxz+0.2*(maxz-minz);

     // drawing of box and coordinate axes
     // color corresponds to the color of the current mode
//     if(view::caveyes)
//         switch(mode){
//           case 0:glColor4f(1.0,1.0,0.0,1.0);break;
//           case 1:glColor4f(1.0,0.0,1.0,1.0);break;
//           case 2:glColor4f(1.0,0.0,1.0,0.0);
//           }
//       else
//         glColor4f((mode==0)?1.0,1.0,0.0,1.0:1.0,0.0,1.0,1.0);
     glColor4f(1.0,0.6,0.6,0.6);
     glBegin(GL_LINE_STRIP);
            glVertex3fv(vert[0]); glVertex3fv(vert[5]); glVertex3fv(vert[4]);glVertex3fv(vert[1]);
       glVertex3fv(vert[2]); glVertex3fv(vert[3]); glVertex3fv(vert[6]); glVertex3fv(vert[7]); glVertex3fv(vert[0]);
     glEnd();
     glBegin(GL_LINE_STRIP);   glVertex3fv(vert[5]);  glVertex3fv(vert[6]);     glEnd();
     glBegin(GL_LINE_STRIP);   glVertex3fv(vert[3]);  glVertex3fv(vert[4]);     glEnd();
     glBegin(GL_LINE_STRIP);   glVertex3fv(vert[0]);  glVertex3fv(vert[1]);     glEnd();
     glBegin(GL_LINE_STRIP);   glVertex3fv(vert[2]);  glVertex3fv(vert[7]);     glEnd();
//    glBegin(GL_LINE_STRIP);   glVertex3fv(vert[8]);  glVertex3fv(vert[9]);     glEnd();
//    glBegin(GL_LINE_STRIP);  glVertex3fv(vert[10]); glVertex3fv(vert[11]);    glEnd();
//     glBegin(GL_LINE_STRIP);   glVertex3fv(vert[12]); glVertex3fv(vert[13]);    glEnd();
}
//************************************************************************
void phase::draw_ribbons(void)
{
     int  i,k,colrs;
     for(i=0;i<nvorbits;i+=4)  //  four orbits related to each point
       { colrs=((colourB[i])<<16)+((colourG[i])<<8)+colourR[i];
         for(k=0;k<MIN(vlength,tlength)-1;k++) // forward orbits
           if( orb[i][k][3]>0.0 &&  orb[i][k+1][3]>0.0 && orb[i+2][k][3]>0.0&&  orb[i+2][k+1][3]>0.0 )
              { if(k % kc==nc)
		    glColor4f( 1.0,1.0,1.0, 1.0);
		else 
		    glColor3b((colourB[i]),(colourG[i]),(colourR[i]));
		    
               glBegin(GL_TRIANGLE_STRIP);
                  glVertex3fv(orb[i][k]);     glVertex3fv(orb[i+2][k]);
                       glVertex3fv(orb[i][k+1]);   glVertex3fv(orb[i+2][k+1]);
                 glEnd();
               }
         for(k=MIN(vlength,tlength)-2;k>0;k--)   // backward orbits
            if( orb[i+1][k][3]>0.0&&  orb[i+1][k-1][3]>0.0&&
                orb[i+3][k][3]>0.0 &&  orb[i+3][k-1][3]>0.0 )
               { if((tlength-k+1) % kc==nc)
		    glColor4f(1.0,1.0,1.0,1.0);
		 else //colrs
			glColor3b((colourB[i]),(colourG[i]),(colourR[i]));
		    
                  glBegin(GL_TRIANGLE_STRIP);
                    glVertex3fv(orb[i+1][k]);   glVertex3fv(orb[i+3][k]);
                    glVertex3fv(orb[i+1][k-1]); glVertex3fv(orb[i+3][k-1]);
                   glEnd();
                }

       }
}
//********************************************************************
void phase::update(void)
{ float tmp;
    tmp=MAX(maxx-minx,maxy-miny);
    tmp=MAX(tmp,maxz-minz);
    boxscale=4.0/tmp;
    midx=(minx+maxx)*0.5; midy=(miny+maxy)*0.5; midz=(minz+maxz)*0.5;
    //if user has changed the system

      if(ieq!=oieq)
      { ep=eqnp[ieq];
        numparam=ep->parameters_setup(param,pstep,box,&hhh);
        agi[5]->ulim=numparam-1;  agi[6]->ulim=numparam-1;
      }
    //addendum: makes ribbons mode more fun
    if(show!=1) // if not particles mode
      if(reg)
           calc_ribbons_regular();
         else
           calc_ribbons_random();

    // if mode has changed them some recalculations are needed
    if(show!=oshow || ieq!=oieq)
       {   oieq=ieq;
           mfc=0;
           tlength=TLENGTH;
           nfirst=0;
           nc=0;
           kc=10;
           if(show==1)
             if(reg)
                 init_particles_regular();
                                     else
                 init_particles_random();
             else
               if(reg)
                   calc_ribbons_regular();
                 else
                   calc_ribbons_random();
         oshow=show;
       }
    // adopt speed of illisive motion to framerate
//    if(show!=1)
//      fmb=MAX(1,(int)(pfps/6.0));

    //  acceleration : controls speed of flow and particles
        mfc=(mfc+1) % fmb;
    if(mfc==0)
      if(show==0 || show==2)
          nc=(nc+1) % kc;
        else
          if(!show_ic) update_particles();
}
//************************************************************************
void phase::draw_lines(void)
{
   int  i,k,colrs;
     for(i=0;i<nvorbits;i+=4)  //  four orbits related to each point
       { colrs=((colourB[i])<<16)+((colourG[i])<<8)+colourR[i];
         for(k=0;k<MIN(vlength,tlength)-1;k++) // forward orbits
           if( orb[i][k][3]>0.0   &&  orb[i][k+1][3]>0.0 &&
               orb[i+2][k][3]>0.0 &&  orb[i+2][k+1][3]>0.0 )
              {if(k % kc==nc) 
		glColor4f(1.0,1.0,1.0,1.0);
		else glColor3b((colourB[i]),(colourG[i]),(colourR[i]));
		    
               glBegin(GL_LINE_STRIP); glVertex3fv(orb[i][k]); glVertex3fv(orb[i][k+1]);     glEnd();
                glBegin(GL_LINE_STRIP); glVertex3fv(orb[i+2][k]); glVertex3fv(orb[i+2][k+1]);  glEnd();
               }
         for(k=MIN(vlength,tlength)-2;k>0;k--)   // backward orbits
            if( orb[i+1][k][3]>0.0 &&  orb[i+1][k-1][3]>0.0 &&
                orb[i+3][k][3]>0.0 &&  orb[i+3][k-1][3]>0.0 )
               { if((tlength-k+1) % kc==nc)
		glColor4f( 1.0,1.0,1.0,1.0);
		else glColor3b((colourB[i]),(colourG[i]),(colourR[i]));
		    
                  glBegin(GL_LINE_STRIP); glVertex3fv(orb[i+1][k]); glVertex3fv(orb[i+1][k-1]);  glEnd();
                  glBegin(GL_LINE_STRIP); glVertex3fv(orb[i+3][k]);  glVertex3fv(orb[i+3][k-1]); glEnd();
                }

       }

}
//********************************************************************
void phase::init_particles_random(void)
{ int i;
  float ic[3],hx,hy,hz,mod1;
  //seed the random number generator
  srandom(5);
  mod1= (float)0x40000000-1; mod1=1/mod1;
  hx=0.5*(maxx-minx)*mod1;
  hy=0.5*(maxy-miny)*mod1;
  hz=0.5*(maxz-minz)*mod1;
  for(i=0;i<norbits;i++)
    {  // generating of initial points
       ic[0]=minx+hx*(float)random();
       ic[1]=miny+hy*(float)random();
       ic[2]=minz+hz*(float)random();
       colourR[i]=(int)(140.0+110.0*(ic[0]-minx)/(maxx-minx));
       colourG[i]=(int)(140.0+110.0*(ic[1]-miny)/(maxy-miny));
       colourB[i]=(int)(140.0+110.0*(ic[2]-minz)/(maxz-minz));
       tdir[i]=1;
       runge_mult(ic,i,0,tlength);  // ic[], time forward
       intcon[i][0]=orb[i][0][0];
       intcon[i][1]=orb[i][0][1];
       intcon[i][2]=orb[i][0][2];
    }
   nfirst=0;
  nvorbits=norbits;
  slength=0;
  tlength=TLENGTH; vlength=25;
}
//********************************************************************
void phase::init_particles_regular(void)
{ int i,ix,iy,iz;
  float ic[3],hx,hy,hz;
  //calculations of trajectories
  norbits=rgbase*rgbase*rgbase;
  ix=iy=iz=0;
  hx=0.9*(maxx-minx)/(rgbase-1.0) ;
  hy=0.9*(maxy-miny)/(rgbase-1.0) ;
  hz=0.9*(maxz-minz)/(rgbase-1.0) ;
  for(i=0;i<norbits;i++)
     { 
	// generating of initial points
       ic[0]=(float)hx*ix+minx+0.05*(maxx-minx);
       ic[1]=(float)hy*iy+miny+0.05*(maxy-miny);
       ic[2]=(float)hz*iz+minz+0.05*(maxz-minz);
       colourR[i]=(int)(100.0+135.0*(ic[0]-minx)/(maxx-minx));
       colourG[i]=(int)(100.0+135.0*(ic[1]-miny)/(maxy-miny));
       colourB[i]=(int)(100.0+135.0*(ic[2]-minz)/(maxz-minz));
        iz=(iz+1) % rgbase;
       if(iz==0) iy=(iy+1) % rgbase;
       if((iy==0)&&(iz==0)) ix=(ix+1) % rgbase;
       tdir[i]=1;
       runge_mult(ic,i,0,tlength);  // ic[], time forward
       intcon[i][0]=orb[i][0][0];
       intcon[i][1]=orb[i][0][1];
       intcon[i][2]=orb[i][0][2];
     }
  nfirst=0;
  nvorbits=norbits;
  slength=0;
  tlength=TLENGTH; vlength=25;
} 
//********************************************************************
void phase::update_particles(void)
{ int i;
	static int nlast;
  if(slength>=tlength)
      { nlast=(nfirst>0)?nfirst-1:tlength-1;
        for(i=0;i<nvorbits;i++)
          runge_one(orb[i][nlast],i,nfirst);
        nfirst=(++nfirst) % tlength;
      }
     else
       nlast++;
  slength++;
}
//********************************************************************
void phase::draw_particles(void)  // draw flying particles
{
  int  i,i1,j,nlast,k,len,lst;
  nlast=(nfirst>0)?nfirst-1:tlength-1;

  len=MIN(MIN(vlength,tlength),slength);
  lst=(slength<tlength)?slength:nlast;
  glLineWidth(1);
  for(j=0;j<nvorbits;j++) // for each particle
    { glBegin(GL_LINE_STRIP);
      // orbit's length is tlength but we use vlength
      for(i=0,k=lst,i1=1;i<len;i++,k=(tlength+k-1)%tlength)
        {if(!(i%5)) i1++;
           if(orb[j][k][3]>0.0)
            { glColor3b((colourB[j]),(colourG[j]),(colourR[j]));
              //glColor4fv(((colourB[j])<<16)+((colourG[j])<<8)+colourR[j]);
              glVertex3fv(orb[j][k]);
            }
            else
                          {  glEnd(); glBegin(GL_LINE_STRIP); }
       }
      glEnd();
    }
  glLineWidth(1);
}
//********************************************************************
void phase::drawit(void)
{  glScalef(boxscale,boxscale,boxscale);
  glTranslatef(-midx,-midy,-midz);

   if(gray)
      draw_gray_points();
   if(axes)
      draw_axes();
   if(show_ic)
     {show_initial_conditions();
      return;
     }
   switch(show)
   {
    case 0: draw_ribbons();
            break;
    case 1: draw_particles();
            break;
    case 2: draw_lines();
            break;
   }

  glTranslatef(midx,midy,midz);
}
//***********************************************************************
void phase::draw_test_orbit(void){ // for green ball NOTE : must be fixed later
// float stx,sty,stz; int i,k;
// starting point of the new trajectory
//  stx=(float)0.6*dsx-3.0; sty=(float)0.6*dsy-3.0; stz=(float)0.6*dsz-3.0;
// calculations of trajectory
//     kt+=2; i=kt-1; // increment number of trajectories
//     runge(stx,sty,stz,i);
//     kt+=2; i=kt-1;
//     runge(stx+0.05,sty+0.05,stz-0.05,i);
}

// illiLighting Model. Returns changed colr based on light
// lmb is dot product of lux and current normal vector
int phase::light(float *nv, int *colr){
   float AMB=.2,PWR=16.;
   int rr,gg,bb;
   float spec,lmb;
   rr=*colr;  gg=*(colr+1);  bb=*(colr+2);
   lmb = DOT(nv,s_phase->s_lightvec);
   lmb = (lmb<0.)?-1.*lmb:lmb;    //for backlight
   lmb = MAX(lmb,AMB);
   spec=MIN(255.,255.*( 1. - PWR + PWR*lmb));
   rr =(int)MAX(lmb*rr, spec);
   gg =(int)MAX(lmb*gg, spec);
   bb =(int)MAX(lmb*bb, spec);
   return( 0xff000000 + (bb<<16) + (gg<<8)+rr);
}
//**************************************************************************
void phase::deFault(void){        // can be executed by Z-key
   int i;
   for(i=0;i<numgf;i++)agf[i]->set_default();
   for(i=0;i<numgi;i++)agi[i]->set_default();
   numparam=ep->parameters_setup(param,pstep,box,&hhh);  // setting o.d.e.parameters
   mfc=0;
   tlength=TLENGTH;
   nfirst=0;
   nc=0;
   kc=10;
   if(show==1)
         if(reg)
             init_particles_regular();
           else
             init_particles_random();
       else
         if(reg)
             calc_ribbons_regular();
           else
             calc_ribbons_random();
}

//**************************************************************************
#define  TYME(cnt,act)  if(cnt?cnt--:0){ act ; goto Break;}
#define  NOTHING ;
#ifdef SOUND
#define  SAY(what)  actorMessage(A_BeginNote, "FS",aSampleActor, what);
#define  HUSH  deleteActor(aSampleActor); \
         aSampleActor = createActor(SampleActor); \
         actorMessage (A_SetPrintCommands, "F", 1.); \
         actorMessage(A_SetDirectory, "FS", aSampleActor, AIFFDIR);
#else
#define  SAY(what)  ;
#define  HUSH  ;
#endif
void phase::autotymer(int wand_stat){
  static int first=1;
  static int lorstart, lorpause1, lorenz2, lorpause2, lorenz3, lorpause3,
             lorenz4, lorpause4, lorenz5, lorpause5,
             rosstart,rospause1, maystart,
             maypause1, mayleonard2, maypause2, mayleonard3, maypause3,
             linstart, linpause1, linear2, linpause2;
  static int *curpause=&lorpause1;
  int wandP,oldwandP,        // current and old value of cavebuttons
       modeP;                 // FLYING MODE
     wandP=wand_stat&7;
  oldwandP=(wand_stat>>3)&7;
     modeP=(wand_stat>>6)&7;

 /* if(glGetButton(PADENTER))
    { while(glGetButton(PADENTER));
      *curpause=0;
      HUSH;
      return;
    }
*/
  if(wandP==4 && oldwandP!=4)  // cycle phaser
    { *curpause=0;
      HUSH;
      return;
     }
//so the next, without the first time option we could write each duration
//only twice, instead of 3 times.
#define LORfps  25    //each phaser is a different speed
#define ROSfps  25
#define MAYfps  15
#define LINfps  20
   if(first){
      first     = 0;
//it can't be done this way. Countdowns are great for animation, bad for switchings
//and the sound lenght variability drives you crazy
//so, back to the drawing board.
      lorstart  = 1;
      lorpause1 = 32 * LORfps;   //ah, but can you trust the impact to doit in 34 seconds?
      lorenz2   = 1;
      lorpause2 = 28 * LORfps;
      lorenz3   = 1;

      lorpause3 = 23 * LORfps;
      lorenz4   = 1;
      lorpause4 = 15 * LORfps;
      lorenz5   = 1;
      lorpause5 = 25 * LORfps;

      rosstart  = 1;
      rospause1 = 30 * ROSfps;

      maystart  = 1;
      maypause1 = 23 * MAYfps;
      mayleonard2 = 1;
      maypause2 = 16 * MAYfps;
      mayleonard3 = 1;
      maypause3 = 25 * MAYfps;

      linstart  = 1;
      linpause1 = 16 * LINfps;
      linear2    = 1;
      linpause2 = 17 * LINfps ;
     }

  //don't forget to put what into quotes

//-----------LORENZ-----------------------------------------------
//               Lorenz  streamers  Welcome to illiFlow

  TYME( lorstart , agi[4]->set_default();  // for norbits
                  ieq=0; reg=0; show=1; SAY("L1.aiff");curpause=&lorpause1)
  TYME( lorpause1, NOTHING)
  TYME( lorenz2, SAY("L2.aiff");
         curpause=&lorpause2)
  TYME( lorpause2, NOTHING)
  TYME( lorenz5, SAY("L5.aiff");curpause=&lorpause5)
  TYME( lorpause5, if(lorpause5>50  && lorpause5<250) param[1]+=0.1;
                   if(lorpause5>350 && lorpause5<550) param[1]-=0.1; )
  TYME( lorenz3, SAY("L3.aiff");curpause=&lorpause3)
  TYME( lorpause3, NOTHING)
  TYME( lorenz4, SAY("L4.aiff");curpause=&lorpause4)
  TYME( lorpause4, NOTHING)


//-----------ROESSLER-----------------------------------------------

  TYME( rosstart, ieq=3; show=1; SAY("R1.aiff");curpause=&rospause1)
  TYME (rospause1, NOTHING)

//-----------MAY-LEONARD-----------------------------------------------

  TYME (maystart, ieq=2; show=1; hhh=0.4; restart(); SAY("M1.aiff");curpause=&maypause1)
  TYME (maypause1,NOTHING)
  TYME (mayleonard2, param[1]=1.0;  hhh=0.3; restart(); SAY("M2.aiff");curpause=&maypause2)
  TYME (maypause2,NOTHING)
  TYME (mayleonard3, param[1]=1.6; hhh=0.3; restart(); SAY("M3.aiff");curpause=&maypause3)
  TYME(maypause3,NOTHING)

//-----------LINEAR-----------------------------------------------
  TYME( linstart, ieq=1; show = 1;restart(); SAY("N1.aiff");curpause=&linpause1)
  TYME( linpause1, NOTHING)
  TYME( linear2,show = 0;norbits=90;vlength=80;reg=0;restart();SAY("N2.aiff");curpause=&linpause2)
  TYME( linpause2, NOTHING)

  first=1; /*time to start over */

 Break: ;/* C++ also has goto's, what a shame ! On the contrary, hooray for some sanity. */

}

//**************************************************************************
void phase::restart(void){
//   static int old_show_ic;
   show_ic=1;
//       if(!old_show_ic)
         if(show==1)
            if(reg)
                init_particles_regular();
              else
                init_particles_random();
          else
            if(reg)
                calc_ribbons_regular();
              else
                calc_ribbons_random();
//   old_show_ic=show_ic;
}
//**************************************************************************

 void phase::control(char ch, int mods){
   int i;
   static int old_show_ic;
   for(i=0;i<numgf;i++)agf[i]->keyboard(ch, mods);
   for(i=0;i<numgi;i++)agi[i]->keyboard(ch, mods);
// if(vlength>tlength) vlength=tlength;
//NOTE: Z-key should not change certain parameters

  if(ch=='Z')
      deFault();

   show_ic=0;
   if(ch==8)restart();

   if(ch==13)
     if(morph) morph=0;
       else {  morph=1; }


// changing of parameters of the system
   if(ch==GLUT_KEY_LEFT+128)
     param[currpar]-=pstep[currpar];
   if(ch==GLUT_KEY_RIGHT+128)
      param[currpar]+=pstep[currpar];
}
//**************************************************************************
void phase::wandresponse(int wand_stat){
   int wandP,oldwandP,        // current and old value of cavebuttons
       modeP;                 // FLYING MODE
   if(!wand_stat) return;     // for speed
     wandP=wand_stat&7;
  oldwandP=(wand_stat>>3)&7;
     modeP=(wand_stat>>6)&7;

  if(wandP==4 && oldwandP!=4)  //{ ieq += ++ieq % 4;} cycle phaser
    morph=1-morph;



  if(wandP==5 && oldwandP==1)   // press right, click left
     switch(ieq){
        //lorenz
        case 0: param[1]-=pstep[1];
        //linear
        case 1: param[8]-=pstep[8];
        //mayleonard
                case 2: param[1]-=pstep[1];
        //roessler
        case 3: param[0]-=pstep[0];
       }
  if(wandP==5 && oldwandP==1)   // press right, click middle
     switch(ieq){
        //lorenz
        case 0: param[1]+=pstep[1];
        //linear
        case 1: param[8]+=pstep[8];
        //mayleonard
        case 2: param[1]+=pstep[1];
        //roessler
        case 3: param[0]+=pstep[0];
       }



  if((modeP==2 && wandP==5) || (modeP==0 && wandP==5)) //&& oldwandP==4 )
    if(currvar<numgi)           // integer gadgets
        agi[currvar]->incr();
      else
        if(currvar<numgi+numgf) // float gadgets

                   agf[currvar-numgi]->incr();
          else                  // o.d.e.parameters
            param[currvar-numgi-numgf]+=pstep[currvar-numgi-numgf];

  if((modeP==2 && wandP==6)||(modeP==0 && wandP==6))  //&& oldwandP==4 )
    if(currvar<numgi)           // integer gadgets
        agi[currvar]->decr();
      else
        if(currvar<numgi+numgf) // float gadgets
            agf[currvar-numgi]->decr();
          else                  // o.d.e.parameters
            param[currvar-numgi-numgf]-=pstep[currvar-numgi-numgf];

    if(modeP==2 && wandP==0 && oldwandP==4)
       currvar=(++currvar)%numconpar;

    if(modeP==2 && wandP==0 && oldwandP==1)
       currvar=(currvar>0)?currvar-1:numconpar-1;

  // show initial conditions
  if(modeP==0 && wandP==1 && oldwandP==1)
    show_ic=1;

      // restart of simulation from the wand
  if(modeP==0 && wandP==1 && oldwandP!=1)
    {if(show==1)
            if(reg)
                init_particles_regular();
              else
                init_particles_random();
          else
            if(reg)
                calc_ribbons_regular();
              else
                calc_ribbons_random();
    show_ic=0;
    }
  // reset for user's class - return to start up parameters
  if(modeP && wandP==5 && oldwandP==1)
     deFault();
}
//**************************************************************************
void phase::messages(void){ // Positioning on a screen and in the CAVE
                           // are different (glRasterPos3f, glRasterPos2f)

 int i;
  char str[80];
 float disp,disp2;
 char eq0[80],eq1[80],eq2[80],eq3[80];

 for(i=0,disp=7.4,disp2=0.9;i<numgi;i++,disp-=0.1,disp2-=0.05)
   { if(view::caveyes) glRasterPos3f(-2.8,disp,ZDESK(disp));
                       else glRasterPos2f(-1.1,disp2);
     agi[i]->print_message();
   }

 for(i=0,disp=7.4-numgi*0.1,disp2=0.9-numgi*0.05;
     i<numgf;
     i++,disp-=0.1,disp2-=0.05)
   { if(view::caveyes) glRasterPos3f(-2.8,disp,ZDESK(disp));
                       else glRasterPos2f(-1.1,disp2);
     agf[i]->print_message();
   };

 for(i=0,disp=7.4-numgi*0.1-numgf*0.1,disp2=0.7;i<numparam;i++,disp-=0.1,disp2-=0.05)
   if(i!=currpar || view::caveyes)
    { if(view::caveyes) glRasterPos3f(-2.8,disp,ZDESK(disp));  
	else glRasterPos2f(0.8,disp2);
        sprintf(str,"A[%d]=%9.4f \n",i,param[i]); char2wall(str);
    }
  
 if(view::caveyes)
     {
       glColor4f(1.0,0.0,1.0,0.0);
//       glRasterPos3f(-2.8,7.4-currvar*0.1,ZDESK(7.4-currvar*0.2));
//       if(currvar<numgi)
//           agi[currvar]->print_message();
//         else
//           if(currvar<numgi+numgf)
//               agf[currvar-numgi]->print_message();
//             else
//               { sprintf(str,"A[%d]=%9.4f \n",currvar-numgi-numgf,
//                 param[currvar-numgi-numgf]);
//                 char2wall(str);
//               };
       ep->symeq(eq0,eq1,eq2,eq3,param);
       glRasterPos3f(0.,4.0,ZDESK(4.0)); char2wall(eq0);
       glRasterPos3f(0.,3.8,ZDESK(3.8)); char2wall(eq1);
       glRasterPos3f(0.,3.6,ZDESK(3.6)); char2wall(eq2);
       glRasterPos3f(0.,3.4,ZDESK(3.4)); char2wall(eq3);
     }
 else
     { glColor4f(1.0,1.0,1.0,1.0);
       disp2=0.7-0.05*currpar;
       glRasterPos2f(0.8,disp2);
       sprintf(str,"A[%d]=%9.4f \n",currpar,param[currpar]);
       char2wall(str);
       disp2=0.7-0.05*numparam;
       glRasterPos2f(0.8,disp2);
       sprintf(str," <- and -> change parameter \n");
       char2wall(str);
       glColor4f(1.0,0.9,0.9,0.9);
       ep->symeq(eq0,eq1,eq2,eq3,param);
       glRasterPos2f(.4,0.9); char2wall(eq0);
       glRasterPos2f(.4,0.85); char2wall(eq1);
       glRasterPos2f(.4,0.80); char2wall(eq2);
       glRasterPos2f(.4,0.75); char2wall(eq3);
     }


}
//**************************************************************************
phase::phase(void)
{
#ifdef CAVE
if(view::caveyes)
    s_phase=(share_phase *)CAVEMalloc(sizeof(struct share_phase));
  else
#endif //CAVE
    s_phase = new struct share_phase;
if(s_phase==0)
   {
     //  cout<<"No room to share user's object in CAVESharedMemory!";
      exit(1);
    }

/* initializes user's parameters*/

eqnp[0]=new lorenz;
eqnp[1]=new linear;
eqnp[2]=new mayleonard;
eqnp[3]=new roessler;
ep=eqnp[0];
numparam=ep->parameters_setup(param,pstep,box,&hhh);    // setting o.d.e.parameters
numgi=12;  numgf=7;
numconpar=numparam;
if(view::caveyes) numconpar=numgi+numgf+numparam; // to make it clear

// this will be needed for gadgets
agi[0]=new gadget<int> (&rgbase,4,   "Grid (B)ase ",
                           "B",'b',ADD,0,10,1,SLIDER,SOAK);
agi[1]=new gadget<int> (&show,1,     "Trajectory (M)ode ",
                           "M",'m',ADD,0,2,1,CYCLER,SOAK);
agi[2]=new gadget<int> (&vlength,25, "Tail (L)ength",
                           "L",'l',ADD,2,100,1,SLIDER,NOSOAK);
agi[3]=new gadget<int> (&reg,0,      "Grid/Ran(D)om IC",
                           "D",'d',ADD,0,1,1,CYCLER,SOAK);
agi[4]=new gadget<int> (&norbits,200,"Orbit n(U)mber",
                           "U",'u',ADD,1,1000,5,SLIDER,NOSOAK);
agi[5]=new gadget<int> (&currpar,1,  "Pick parameter",
                           "SOUTH",GLUT_KEY_DOWN+128,ADD,0,numparam-1,-1,CYCLER,SOAK);
agi[6]=new gadget<int> (&currpar,1,  "Pick parameter",
                           "NORTH",  GLUT_KEY_UP+128,ADD,0,numparam-1,1,CYCLER,SOAK);
agi[7]=new gadget<int> (&fmb,1,      "(F)aster/slower",
                           "F",'f',ADD,1,1000,1,SLIDER,SOAK);
agi[8]=new gadget<int> (&gray,0,     "(G)rid points" ,
                           "G",'g',ADD,0,1,1,CYCLER,SOAK);

                           
agi[9]=new gadget<int> (&axes,1,     "Bo(X)",
                           "X",'x',ADD,0,1,1,CYCLER,SOAK);
agi[10]=new gadget<int> (&ieq,0,     "(P)hase cycler",
                           "P",'p',ADD,0,MAX_NUM_SYSTEMS-1,1,CYCLER,SOAK);
agi[11]=new gadget<int> (&morph,1,     "Au(T)omatic",
                           "T",'t',ADD,0,1,1,CYCLER,SOAK);
oieq=ieq;
agf[0]=new gadget<float> (&hhh,0.01,  "RK time-step",
                           "H",'h',MULT,0.001,0.5,1.03,SLIDER,SOAK);
agf[1]=new gadget<float> (&minx,-24.0,"X-min",
                           "F3",GLUT_KEY_F3+128,ADD,-200.0,200.0,0.5,SLIDER,NOSOAK);
agf[2]=new gadget<float> (&maxx, 24.0,"X-max",
                           "F4",GLUT_KEY_F4+128,ADD,-200.0,200.0,0.5,SLIDER,NOSOAK);
agf[3]=new gadget<float> (&miny,-24.0,"Y-min",
                           "F5",GLUT_KEY_F5+128,ADD,-200.0,200.0,0.5,SLIDER,NOSOAK);
agf[4]=new gadget<float> (&maxy, 24.0,"Y-max",
                           "F6",GLUT_KEY_F6+128,ADD,-200.0,200.0,0.5,SLIDER,NOSOAK);
agf[5]=new gadget<float> (&minz, 4.0,"Z-min",
                           "F7",GLUT_KEY_F7+128,ADD,-200.0,200.0,0.5,SLIDER,NOSOAK);
agf[6]=new gadget<float> (&maxz, 50.0,"Z-max",
                           "F8",GLUT_KEY_F8+128,ADD,-200.0,200.0,0.5,SLIDER,NOSOAK);


   mfc=0;
   tlength=TLENGTH;
   nfirst=0;
   nc=0;
   kc=10;
   show_ic=0;
   if(show==1)
       if(reg)
           init_particles_regular();
         else
           init_particles_random();
     else
       if(reg)
           calc_ribbons_regular();
         else
           calc_ribbons_random();
}
//**************************************************************************
phase::~phase(void){
  /* free user's memory, close connections and this kinda things*/
   if(view::caveyes)
#ifdef CAVE
        CAVEFree(s_phase)
#endif
		;
    else
      delete s_phase;
 }



// legacy, Bourd had these here for reasons no-one knows
// C++ static class members (= C global variables)
void* view::arena;
int view::caveyes;


// MAIN FUNCTION

