/* Old idea:
   Possibly change to vary thickness or width of line objects to 
   indicate longer stairways */

#define ADDXYz(M,i,j) M[0]+i,M[1]+j,M[2]+0.02
#define ADDXZy(M,i,k) M[0]+i,M[1]+0.02,M[2]+k
#define ADDYZx(M,j,k) M[0]+0.02,M[1]+j,M[2]+k
#define ADDXY(M,i,j) M[0]+i,M[1]+j,M[2]
#define ADDXZ(M,i,k) M[0]+i,M[1],M[2]+k
#define ADDYZ(M,j,k) M[0],M[1]+j,M[2]+k
/* MAY 1999: */
#define DDList DD[0],DD[1],DD[2]
/*
#define RAND_MAX 32767
#include <device.h>
*/
#include <gl\glut.h>
#include <stdlib.h>
#include <stdio.h>

#include <math.h>
/* The following pair must be consecutive: */
#define ROWS 5
#define ROWS1 6
float vv[ROWS1][ROWS1][ROWS1][3];
float DD[3];/* MAY 1999 */
/* The maze data: */
int xyzfaces[ROWS][ROWS][ROWS][ROWS1]; /* incidence matrix */
int xzwfaces[ROWS][ROWS1][ROWS][ROWS];
int yzwfaces[ROWS1][ROWS][ROWS][ROWS];
int xywfaces[ROWS][ROWS][ROWS1][ROWS];
/* Newly created (MAY 1999) 'local' matrices: */
int he[ROWS][ROWS1][ROWS][ROWS];
int ve[ROWS1][ROWS][ROWS][ROWS];
int oe1[ROWS][ROWS][ROWS1][ROWS];
int oe2[ROWS][ROWS][ROWS][ROWS1];
/* MAY 1999: */
GLfloat he_color[3], ve_color[3], oe1_color[3], oe2_color[3];
GLfloat BASIC_BLUE[3],BASIC_GREEN[3],BASIC_RED[3],BASIC_YELLOW[3],BASIC_GREY[3];

/* moving_axes is always abs(ActualAxes) from main(), in:
   setDD, init_edges, draw_hedge, draw_vedge, draw_hvedge, 
   draw_otheredges, and draw_intersections */

/* for Visual C++ / PC version only: */
double trunc(double ff){double temp;
	temp=floor(fabs(ff));	
	temp*=(int)(ff/fabs(ff));
	return temp;
}

initvv(){int ii,jj,kk;
 for(ii=0;ii<ROWS1;ii++)for(jj=0;jj<ROWS1;jj++)for(kk=0;kk<ROWS1;kk++){
   vv[ii][jj][kk][0] = (ii-ROWS/2.0)*8.0;
   vv[ii][jj][kk][1] = (jj-ROWS/2.0)*8.0;
   vv[ii][jj][kk][2] = (kk-ROWS/2.0)*8.0;}
}

/* Creates faces with probability __CHANCE */
makemaze(unsigned int seed,float xyzchance,float xywchance,float xzwchance,
	 float yzwchance)
{int ii,jj,kk,ll; srand(seed);for(ii=0;ii<ROWS;ii++)for(jj=0;jj<ROWS;jj++)
  for(kk=0;kk<ROWS;kk++)for(ll=0;ll<ROWS1;ll++)
    xyzfaces[ii][jj][kk][ll] = (0==trunc((rand()/xyzchance)/RAND_MAX));
 for(ii=0;ii<ROWS;ii++)for(jj=0;jj<ROWS;jj++)
   for(kk=0;kk<ROWS1;kk++)for(ll=0;ll<ROWS;ll++)
     xywfaces[ii][jj][kk][ll] = (0==trunc((rand()/xywchance)/RAND_MAX));
 for(ii=0;ii<ROWS;ii++)for(jj=0;jj<ROWS1;jj++)
   for(kk=0;kk<ROWS;kk++)for(ll=0;ll<ROWS;ll++)
     xzwfaces[ii][jj][kk][ll] = (0==trunc((rand()/xzwchance)/RAND_MAX));
 for(ii=0;ii<ROWS1;ii++)for(jj=0;jj<ROWS;jj++)
   for(kk=0;kk<ROWS;kk++)for(ll=0;ll<ROWS;ll++)
     yzwfaces[ii][jj][kk][ll] = (0==trunc((rand()/yzwchance)/RAND_MAX));
}

/* Creates a specfic maze, intended for use with autotymer as a demo */
/* THIS VERSION intended for use without stairs and with sound */
/* and with 4D rotation... so the 'stairs' are added to empty space */
/* which is really more representative of the 4D building that I envision */
/* Needs ROWS=5 */
setmaze(){int ii,jj,kk,ll;
 for(ii=0;ii<ROWS;ii++)for(jj=0;jj<ROWS;jj++)for(kk=0;kk<ROWS;kk++)
   for(ll=0;ll<ROWS1;ll++)xyzfaces[ii][jj][kk][ll] = 0;
 for(ii=0;ii<ROWS;ii++)for(jj=0;jj<ROWS;jj++)for(kk=0;kk<ROWS1;kk++)
   for(ll=0;ll<ROWS;ll++)xywfaces[ii][jj][kk][ll] = 0;
 for(ii=0;ii<ROWS;ii++)for(jj=0;jj<ROWS1;jj++)for(kk=0;kk<ROWS;kk++)
   for(ll=0;ll<ROWS;ll++)xzwfaces[ii][jj][kk][ll] = 0;
 for(ii=0;ii<ROWS1;ii++)for(jj=0;jj<ROWS;jj++)for(kk=0;kk<ROWS;kk++)
   for(ll=0;ll<ROWS;ll++)yzwfaces[ii][jj][kk][ll] = 0;
 /* 
 xyzfaces[4][2][4][0] = 0;xyzfaces[3][2][4][1] = 0;
 xyzfaces[2][2][4][2] = 0;xyzfaces[4][2][0][3] = 0;
 xyzfaces[4][2][3][3] = 0;xyzfaces[4][2][3][4] = 0;
 for(ii=0;ii<=2;ii++)for(jj=2;jj<=4;jj++)for(kk=1;kk<=3;kk++)
   for(ll=3;ll<=4;ll++)xyzfaces[ii][jj][kk][ll]=0;
   */
 for(ii=0;ii<=2;ii++)for(jj=2;jj<=4;jj++)for(kk=1;kk<=3;kk++)
   for(ll=2;ll<=5;ll+=3)xyzfaces[ii][jj][kk][ll]=1;
 xyzfaces[1][2][4][2]=xyzfaces[1][2][4][3]=1;
 xyzfaces[2][2][4][3]=xyzfaces[2][2][4][1]=1;
 xyzfaces[3][2][4][0]=xyzfaces[3][2][4][2]=1;
 xyzfaces[3][1][4][0]=xyzfaces[3][0][4][0]=1;
 xyzfaces[3][1][4][1]=xyzfaces[3][0][4][1]=1;
 xyzfaces[4][2][4][1]=1;
 xyzfaces[1][3][0][3]=xyzfaces[1][3][0][4]=1;
 xyzfaces[2][3][0][3]=xyzfaces[2][3][0][4]=1;
 xyzfaces[3][3][0][3]=xyzfaces[3][3][0][4]=1;
 xyzfaces[3][2][0][3]=xyzfaces[3][2][0][4]=1;
 xyzfaces[4][2][0][2]=xyzfaces[4][2][0][4]=1;
 for(ii=0;ii<4;ii++)xyzfaces[3][2][ii][3]=xyzfaces[3][2][ii][2]=1;
 xyzfaces[4][2][3][2]=xyzfaces[4][2][3][5]=1;

 for(jj=0;jj<=2;jj++)for(kk=4;kk<=5;kk++)xywfaces[3][jj][kk][0] = 1;
 for(kk=4;kk<=5;kk++)xywfaces[4][2][kk][0] = 1;
 for(ii=2;ii<=3;ii++)for(kk=4;kk<=5;kk++)xywfaces[ii][2][kk][1] = 1;
 for(ii=0;ii<=2;ii++)for(jj=2;jj<=4;jj++)for(ll=2;ll<=4;ll++)
   {xywfaces[ii][jj][1][ll]=1;xywfaces[ii][jj][4][ll]=1;}
 for(ii=1;ii<=2;ii++)xywfaces[ii][2][5][2]=1;
 for(ii=3;ii<=4;ii++)for(ll=2;ll<=3;ll++)xywfaces[ii][2][0][ll] = 1;
 for(ll=2;ll<=3;ll++){xywfaces[4][2][1][ll] = xywfaces[4][2][4][ll] = 1;}
 for(ll=2;ll<=4;ll++)xywfaces[4][2][3][ll] = 1;
 xywfaces[3][2][4][2] = 1;
 for(jj=2;jj<=3;jj++)xywfaces[3][jj][1][3] = 1;
 for(ii=1;ii<=3;ii++)xywfaces[ii][3][0][3]=1;
 xywfaces[1][2][4][2] = xywfaces[1][3][1][3] = 0; 
 
 for(jj=2;jj<=4;jj++)for(kk=1;kk<=3;kk++)for(ll=2;ll<=4;ll++)
   {yzwfaces[0][jj][kk][ll]=1;yzwfaces[3][jj][kk][ll]=1;}
 for(ll=3;ll<=4;ll++){yzwfaces[4][2][3][ll]=1;yzwfaces[5][2][3][ll]=1;}
 yzwfaces[5][2][3][2]=1;
 for(ii=3;ii<=4;ii++)for(jj=0;jj<=1;jj++)yzwfaces[ii][jj][4][0]=1;
 yzwfaces[3][2][4][0]=1;yzwfaces[5][2][4][0]=1;
 yzwfaces[2][2][4][1]=1;yzwfaces[4][2][4][1]=1;
 yzwfaces[3][2][4][2]=1;yzwfaces[1][2][4][2]=1;
 yzwfaces[4][2][1][2]=1;yzwfaces[4][2][2][2]=1;
 for(ll=2;ll<=3;ll++){yzwfaces[3][2][0][ll]=1;yzwfaces[5][2][0][ll]=1;}
 yzwfaces[1][3][0][3]=1;yzwfaces[4][3][0][3]=1;
 
 xzwfaces[4][2][4][0]=1;xzwfaces[4][3][4][0]=1;xzwfaces[3][3][4][0]=1;
 for(ii=2;ii<=3;ii++)for(jj=2;jj<=3;jj++)xzwfaces[ii][jj][4][1]=1;
 for(ii=0;ii<=2;ii++)for(kk=1;kk<=3;kk++)for(ll=2;ll<=4;ll++)
   {xzwfaces[ii][2][kk][ll]=1;xzwfaces[ii][5][kk][ll]=1;}
 for(jj=2;jj<=3;jj++)for(ll=2;ll<=4;ll++)xzwfaces[4][jj][3][ll]=1;
 for(ii=1;ii<=2;ii++)for(jj=2;jj<=3;jj++)xzwfaces[ii][jj][4][2]=1;
 for(jj=2;jj<=3;jj++)for(kk=0;kk<=3;kk++)xzwfaces[3][jj][kk][2]=1;
 for(jj=2;jj<=3;jj++)xzwfaces[4][jj][0][2]=1;
 for(ii=3;ii<=4;ii++)xzwfaces[ii][2][0][3]=1;
 xzwfaces[1][3][0][3]=1;xzwfaces[2][3][0][3]=1;xzwfaces[4][3][0][3]=1;
 for(ii=1;ii<=3;ii++)xzwfaces[ii][4][0][3]=1;
}

drawmaze(int LL, float del, int dir4[4]){int ii,jj,kk;
/*
 if(LL==-1 || LL==ROWS){
   glColor3f(1.0,1.0,1.0);glBegin(GL_POINTS);
   glVertex3f(vv[0][0][0][0]-4.0,vv[0][0][0][1]-4.0,vv[0][0][0][2]-4.0);
   glVertex3f(vv[0][0][ROWS][0]-4.0,vv[0][0][ROWS][1]-4.0,
	      vv[0][0][ROWS][2]+4.0);
   glVertex3f(vv[0][ROWS][0][0]-4.0,vv[0][ROWS][0][1]+4.0,
	      vv[0][ROWS][0][2]-4.0);
   glVertex3f(vv[0][ROWS][ROWS][0]-4.0,vv[0][ROWS][ROWS][1]+4.0,
	      vv[0][ROWS][ROWS][2]+4.0);
   glVertex3f(vv[ROWS][0][0][0]+4.0,vv[ROWS][0][0][1]-4.0,
	      vv[ROWS][0][0][2]-4.0);
   glVertex3f(vv[ROWS][0][ROWS][0]+4.0,vv[ROWS][0][ROWS][1]-4.0,
	      vv[ROWS][0][ROWS][2]+4.0);
   glVertex3f(vv[ROWS][ROWS][0][0]+4.0,vv[ROWS][ROWS][0][1]+4.0,
	      vv[ROWS][ROWS][0][2]-4.0);
   glVertex3f(vv[ROWS][ROWS][ROWS][0]+4.0,vv[ROWS][ROWS][ROWS][1]+4.0,
	      vv[ROWS][ROWS][ROWS][2]+4.0);
   glEnd();}
*/
 if(LL>=0 && LL<ROWS) {
  if(dir4[3]!=0){
   for(ii=0;ii<ROWS;ii++)for(jj=0;jj<ROWS;jj++)for(kk=0;kk<ROWS1;kk++)
    if (xywfaces[ii][jj][kk][LL]){
     glBegin(GL_TRIANGLE_STRIP); /* bgntmesh();*/
     glColor3f(0.,0.,1.0);glVertex3f(ADDXY(vv[ii][jj][kk],del,del));
     glColor3f(0.,0.,.73);glVertex3f(ADDXY(vv[ii+1][jj][kk],-1*del,del));
     glColor3f(0.,.07,.87);glVertex3f(ADDXY(vv[ii][jj+1][kk],del,-1*del));
     glColor3f(0.,0.,.80);glVertex3f(ADDXY(vv[ii+1][jj+1][kk],-1*del,-1*del));
     glColor3f(0.,0.,.6);glVertex3f(ADDXYz(vv[ii][jj][kk],del,del)); 
     glColor3f(0.,0.,.73);glVertex3f(ADDXYz(vv[ii+1][jj][kk],-1*del,del));
     glEnd(); /*endtmesh(); */}}
  else{
   for(ii=0;ii<ROWS;ii++)for(jj=0;jj<ROWS;jj++)for(kk=0;kk<ROWS1;kk++)
    if ((xyzfaces[ii][jj][LL][kk]&&(dir4[2]!=0))||
	(xyzfaces[ii][LL][jj][kk]&&(dir4[1]!=0))||
	(xyzfaces[LL][ii][jj][kk]&&(dir4[0]!=0))){
     glBegin(GL_TRIANGLE_STRIP); /* bgntmesh();*/
     glColor3f(1.0,1.0,0.);glVertex3f(ADDXY(vv[ii][jj][kk],del,del));
     glColor3f(.73,.73,0.);glVertex3f(ADDXY(vv[ii+1][jj][kk],-1*del,del));
     glColor3f(.93,.93,.07);glVertex3f(ADDXY(vv[ii][jj+1][kk],del,-1*del));
     glColor3f(.8,.8,0.);glVertex3f(ADDXY(vv[ii+1][jj+1][kk],-1*del,-1*del));
     glColor3f(.6,.6,0.);glVertex3f(ADDXYz(vv[ii][jj][kk],del,del)); 
     glColor3f(.73,.73,0.);glVertex3f(ADDXYz(vv[ii+1][jj][kk],-1*del,del));
     glEnd(); /*endtmesh(); */}}
  if(dir4[3]!=0 || dir4[2]!=0){
   for(ii=0;ii<ROWS;ii++)for(jj=0;jj<ROWS1;jj++)for(kk=0;kk<ROWS;kk++)
    if ((xzwfaces[ii][jj][kk][LL]&&(dir4[3]!=0))||
	(xzwfaces[ii][jj][LL][kk]&&(dir4[2]!=0))){
     glBegin(GL_TRIANGLE_STRIP); 
     glColor3f(0.,1.0,0.);glVertex3f(ADDXZ(vv[ii][jj][kk],del,del));
     glColor3f(0.,.73,0.);glVertex3f(ADDXZ(vv[ii+1][jj][kk],-1*del,del));
     glColor3f(0.,.93,.07);glVertex3f(ADDXZ(vv[ii][jj][kk+1],del,-1*del));
     glColor3f(0.,.8,0.);glVertex3f(ADDXZ(vv[ii+1][jj][kk+1],-1*del,-1*del));
     glColor3f(0.,.6,0.);glVertex3f(ADDXZy(vv[ii][jj][kk],del,del));
     glColor3f(0.,.73,0.);glVertex3f(ADDXZy(vv[ii+1][jj][kk],-1*del,del));
     glEnd();}}
  else{
   for(ii=0;ii<ROWS;ii++)for(jj=0;jj<ROWS1;jj++)for(kk=0;kk<ROWS;kk++)
    if ((xywfaces[ii][LL][jj][kk]&&(dir4[1]!=0))||
	(xywfaces[LL][ii][jj][kk]&&(dir4[0]!=0))){
     glBegin(GL_TRIANGLE_STRIP); 
     glColor3f(0.,0.,1.0);glVertex3f(ADDXZ(vv[ii][jj][kk],del,del));
     glColor3f(0.,0.,.73);glVertex3f(ADDXZ(vv[ii+1][jj][kk],-1*del,del));
     glColor3f(0.,.07,.87);glVertex3f(ADDXZ(vv[ii][jj][kk+1],del,-1*del));
     glColor3f(0.,0.,.80);glVertex3f(ADDXZ(vv[ii+1][jj][kk+1],-1*del,-1*del));
     glColor3f(0.,0.,.6);glVertex3f(ADDXZy(vv[ii][jj][kk],del,del));
     glColor3f(0.,0.,.73);glVertex3f(ADDXZy(vv[ii+1][jj][kk],-1*del,del));
     glEnd();}}
  if(dir4[0]==0){
   for(ii=0;ii<ROWS1;ii++)for(jj=0;jj<ROWS;jj++)for(kk=0;kk<ROWS;kk++)
    if ((yzwfaces[ii][jj][kk][LL]&&(dir4[3]!=0))||
	(yzwfaces[ii][jj][LL][kk]&&(dir4[2]!=0))||
	(yzwfaces[ii][LL][jj][kk]&&(dir4[1]!=0))){
     glBegin(GL_TRIANGLE_STRIP);glColor3f(1.0,0.,0.);
     glVertex3f(ADDYZ(vv[ii][jj][kk],del,del));
     glColor3f(.73,0.,0.);glVertex3f(ADDYZ(vv[ii][jj+1][kk],-1*del,del));
     glColor3f(.93,0.,.07);glVertex3f(ADDYZ(vv[ii][jj][kk+1],del,-1*del));
     glColor3f(.8,0.,0.);glVertex3f(ADDYZ(vv[ii][jj+1][kk+1],-1*del,-1*del));
     glColor3f(.6,0.,0.);glVertex3f(ADDYZx(vv[ii][jj][kk],del,del));
     glColor3f(.73,0.,0.);glVertex3f(ADDYZx(vv[ii][jj+1][kk],-1*del,del));
     glEnd();}}
  else{
   for(ii=0;ii<ROWS1;ii++)for(jj=0;jj<ROWS;jj++)for(kk=0;kk<ROWS;kk++)
    if (xzwfaces[LL][ii][jj][kk]){
     glBegin(GL_TRIANGLE_STRIP);glColor3f(0.,1.0,0.);
     glVertex3f(ADDYZ(vv[ii][jj][kk],del,del));
     glColor3f(0.,.73,0.);glVertex3f(ADDYZ(vv[ii][jj+1][kk],-1*del,del));
     glColor3f(0.,.93,.07);glVertex3f(ADDYZ(vv[ii][jj][kk+1],del,-1*del));
     glColor3f(0.,.8,0.);glVertex3f(ADDYZ(vv[ii][jj+1][kk+1],-1*del,-1*del));
     glColor3f(0.,.6,0.);glVertex3f(ADDYZx(vv[ii][jj][kk],del,del));
     glColor3f(0.,.73,0.);glVertex3f(ADDYZx(vv[ii][jj+1][kk],-1*del,del));
     glEnd();}}
  /* 99->ff for same appearance on both sides.  Now one is darker. */
 }}
drawHmark(int II,int JJ,int KK,int thick){int ii,jj;float vH[6][3];
 static float vo[6][3] = { { 1.0, 0.0, 0.0 },
			   { 0.0, 1.0, 0.0 },
			   { 0.0, 0.0, 1.0 }, /* a purple octehedron */
			   {-1.0, 0.0, 0.0 },
			   { 0.0,-1.0, 0.0 },
			   { 0.0, 0.0,-1.0 } };
 static int fr[]= {0,1,2,0,4,2,3,1,5,3,4,5,0};
 for(ii=0;ii<6;ii++)for(jj=0;jj<3;jj++)
   vH[ii][jj]=vo[ii][jj]+4+vv[II][JJ][KK][jj];
  glLineWidth(thick);
  glBegin(GL_LINE_STRIP); /*bgnline(); */ 
  glColor3f(.6,0.,.6); for(ii=0;ii<13;ii++)glVertex3fv(vH[fr[ii]]); 
  glEnd(); /* endline(); */
}
drawhmark(int II,int JJ,int KK,int thick){ /* a dark grey cube */
  static int first=1; static float vq[8][3]; float vh[8][3]; int ii,jj;
    static int fr[]= {0,1,5,1,3,7,3,2,6,2,0,4,5,7,6,4};
    if(first){for(ii=0;ii<8;ii++)for(jj=0;jj<3;jj++)
      vq[ii][jj]=(ii&(1<<jj))?.65:-.65; first=0;}
    for(ii=0;ii<8;ii++)for(jj=0;jj<3;jj++)
      vh[ii][jj]=vq[ii][jj]+4+vv[II][JJ][KK][jj];
    glLineWidth(thick);
    glBegin(GL_LINE_STRIP); glColor3f(.4,.4,.4); 
    for(ii=0;ii<16;ii++)glVertex3fv(vh[fr[ii]]); 
    glEnd();
}

/* MAY 1999 */
drawportal(int II,int JJ,int KK,int thick, int whichway){
  if(whichway==1)drawHmark(II,JJ,KK,thick);
  else if(whichway==-1)drawhmark(II,JJ,KK,thick);
}

/* MAY 1999 */
/* could be defined when declared - could even be made const int arrays */
void init_colors(void){
  BASIC_BLUE[0]=0;BASIC_BLUE[1]=0;BASIC_BLUE[2]=1;
  BASIC_GREEN[0]=0;BASIC_GREEN[1]=1;BASIC_GREEN[2]=0;
  BASIC_RED[0]=1;BASIC_RED[1]=0;BASIC_RED[2]=0;
  BASIC_YELLOW[0]=1;BASIC_YELLOW[1]=1;BASIC_YELLOW[2]=0;
  BASIC_GREY[0]=.5;BASIC_GREY[1]=.5;BASIC_GREY[2]=.5;
}

/* MAY 1999 */
void init_edges(int moving_axes){
  int ii,jj,kk,ll;
  switch(moving_axes){
  case 1: 
    for(ii=0;ii<ROWS;ii++)for(jj=0;jj<ROWS1;jj++)
      for(kk=0;kk<ROWS;kk++)for(ll=0;ll<ROWS;ll++)
	he[ii][jj][kk][ll]=xzwfaces[ii][jj][kk][ll];
    for(ii=0;ii<ROWS1;ii++)for(jj=0;jj<ROWS;jj++)
      for(kk=0;kk<ROWS;kk++)for(ll=0;ll<ROWS;ll++)
	ve[ii][jj][kk][ll]=yzwfaces[ii][jj][kk][ll];
    for(ii=0;ii<ROWS;ii++)for(jj=0;jj<ROWS;jj++)
      for(kk=0;kk<ROWS1;kk++)for(ll=0;ll<ROWS;ll++)
	oe1[ii][jj][kk][ll]=xywfaces[ii][jj][kk][ll];
    for(ii=0;ii<ROWS;ii++)for(jj=0;jj<ROWS;jj++)
      for(kk=0;kk<ROWS;kk++)for(ll=0;ll<ROWS1;ll++)
	oe2[ii][jj][kk][ll]=xyzfaces[ii][jj][kk][ll];
    for(ii=0;ii<3;ii++){
      he_color[ii]=BASIC_GREEN[ii];
      ve_color[ii]=BASIC_RED[ii];
      oe1_color[ii]=BASIC_BLUE[ii];
      oe2_color[ii]=BASIC_YELLOW[ii];}
    break;
  case 2: 
    for(ii=0;ii<ROWS;ii++)for(jj=0;jj<ROWS1;jj++)
      for(kk=0;kk<ROWS;kk++)for(ll=0;ll<ROWS;ll++)
	he[ii][jj][kk][ll]=xywfaces[ii][kk][jj][ll];
    for(ii=0;ii<ROWS1;ii++)for(jj=0;jj<ROWS;jj++)
      for(kk=0;kk<ROWS;kk++)for(ll=0;ll<ROWS;ll++)
	ve[ii][jj][kk][ll]=yzwfaces[ii][kk][jj][ll];
    for(ii=0;ii<ROWS;ii++)for(jj=0;jj<ROWS;jj++)
      for(kk=0;kk<ROWS1;kk++)for(ll=0;ll<ROWS;ll++)
	oe1[ii][jj][kk][ll]=xzwfaces[ii][kk][jj][ll];
    for(ii=0;ii<ROWS;ii++)for(jj=0;jj<ROWS;jj++)
      for(kk=0;kk<ROWS;kk++)for(ll=0;ll<ROWS1;ll++)
	oe2[ii][jj][kk][ll]=xyzfaces[ii][kk][jj][ll];
    for(ii=0;ii<3;ii++){
      he_color[ii]=BASIC_BLUE[ii];
      ve_color[ii]=BASIC_RED[ii];
      oe1_color[ii]=BASIC_GREEN[ii];
      oe2_color[ii]=BASIC_YELLOW[ii];}
    break;
  case 3: 
    for(ii=0;ii<ROWS;ii++)for(jj=0;jj<ROWS1;jj++)
      for(kk=0;kk<ROWS;kk++)for(ll=0;ll<ROWS;ll++)
	he[ii][jj][kk][ll]=xyzfaces[ii][kk][ll][jj];
    for(ii=0;ii<ROWS1;ii++)for(jj=0;jj<ROWS;jj++)
      for(kk=0;kk<ROWS;kk++)for(ll=0;ll<ROWS;ll++)
	ve[ii][jj][kk][ll]=yzwfaces[ii][kk][ll][jj];
    for(ii=0;ii<ROWS;ii++)for(jj=0;jj<ROWS;jj++)
      for(kk=0;kk<ROWS1;kk++)for(ll=0;ll<ROWS;ll++)
	oe1[ii][jj][kk][ll]=xzwfaces[ii][kk][ll][jj];
    for(ii=0;ii<ROWS;ii++)for(jj=0;jj<ROWS;jj++)
      for(kk=0;kk<ROWS;kk++)for(ll=0;ll<ROWS1;ll++)
	oe2[ii][jj][kk][ll]=xywfaces[ii][kk][ll][jj];
    for(ii=0;ii<3;ii++){
      he_color[ii]=BASIC_YELLOW[ii];
      ve_color[ii]=BASIC_RED[ii];
      oe1_color[ii]=BASIC_GREEN[ii];
      oe2_color[ii]=BASIC_BLUE[ii];}
    break;
  case 4: 
    for(ii=0;ii<ROWS;ii++)for(jj=0;jj<ROWS1;jj++)
      for(kk=0;kk<ROWS;kk++)for(ll=0;ll<ROWS;ll++)
	he[ii][jj][kk][ll]=xywfaces[kk][ii][jj][ll];
    for(ii=0;ii<ROWS1;ii++)for(jj=0;jj<ROWS;jj++)
      for(kk=0;kk<ROWS;kk++)for(ll=0;ll<ROWS;ll++)
	ve[ii][jj][kk][ll]=xzwfaces[kk][ii][jj][ll];
    for(ii=0;ii<ROWS;ii++)for(jj=0;jj<ROWS;jj++)
      for(kk=0;kk<ROWS1;kk++)for(ll=0;ll<ROWS;ll++)
	oe1[ii][jj][kk][ll]=yzwfaces[kk][ii][jj][ll];
    for(ii=0;ii<ROWS;ii++)for(jj=0;jj<ROWS;jj++)
      for(kk=0;kk<ROWS;kk++)for(ll=0;ll<ROWS1;ll++)
	oe2[ii][jj][kk][ll]=xyzfaces[kk][ii][jj][ll];
    for(ii=0;ii<3;ii++){
      he_color[ii]=BASIC_BLUE[ii];
      ve_color[ii]=BASIC_GREEN[ii];
      oe1_color[ii]=BASIC_RED[ii];
      oe2_color[ii]=BASIC_YELLOW[ii];}
    break;
  case 5: 
    for(ii=0;ii<ROWS;ii++)for(jj=0;jj<ROWS1;jj++)
      for(kk=0;kk<ROWS;kk++)for(ll=0;ll<ROWS;ll++)
	he[ii][jj][kk][ll]=xyzfaces[kk][ii][ll][jj];
    for(ii=0;ii<ROWS1;ii++)for(jj=0;jj<ROWS;jj++)
      for(kk=0;kk<ROWS;kk++)for(ll=0;ll<ROWS;ll++)
	ve[ii][jj][kk][ll]=xzwfaces[kk][ii][ll][jj];
    for(ii=0;ii<ROWS;ii++)for(jj=0;jj<ROWS;jj++)
      for(kk=0;kk<ROWS1;kk++)for(ll=0;ll<ROWS;ll++)
	oe1[ii][jj][kk][ll]=yzwfaces[kk][ii][ll][jj];
    for(ii=0;ii<ROWS;ii++)for(jj=0;jj<ROWS;jj++)
      for(kk=0;kk<ROWS;kk++)for(ll=0;ll<ROWS1;ll++)
	oe2[ii][jj][kk][ll]=xywfaces[kk][ii][ll][jj];
    for(ii=0;ii<3;ii++){
      he_color[ii]=BASIC_YELLOW[ii];
      ve_color[ii]=BASIC_GREEN[ii];
      oe1_color[ii]=BASIC_RED[ii];
      oe2_color[ii]=BASIC_BLUE[ii];}
    break;
  case 6: 
    for(ii=0;ii<ROWS;ii++)for(jj=0;jj<ROWS1;jj++)
      for(kk=0;kk<ROWS;kk++)for(ll=0;ll<ROWS;ll++)
	he[ii][jj][kk][ll]=xyzfaces[kk][ll][ii][jj];
    for(ii=0;ii<ROWS1;ii++)for(jj=0;jj<ROWS;jj++)
      for(kk=0;kk<ROWS;kk++)for(ll=0;ll<ROWS;ll++)
	ve[ii][jj][kk][ll]=xywfaces[kk][ll][ii][jj];
    for(ii=0;ii<ROWS;ii++)for(jj=0;jj<ROWS;jj++)
      for(kk=0;kk<ROWS1;kk++)for(ll=0;ll<ROWS;ll++)
	oe1[ii][jj][kk][ll]=yzwfaces[kk][ll][ii][jj];
    for(ii=0;ii<ROWS;ii++)for(jj=0;jj<ROWS;jj++)
      for(kk=0;kk<ROWS;kk++)for(ll=0;ll<ROWS1;ll++)
	oe2[ii][jj][kk][ll]=xzwfaces[kk][ll][ii][jj];
    for(ii=0;ii<3;ii++){
      he_color[ii]=BASIC_YELLOW[ii];
      ve_color[ii]=BASIC_BLUE[ii];
      oe1_color[ii]=BASIC_RED[ii];
      oe2_color[ii]=BASIC_GREEN[ii];}
    break;
  }
}/* MAY 1999 */

/* MAY 1999 */
/* JUNE 1999:
   If -ii,-jj,-kk are used, then 'del' in draw_intersections must be 
   redone, too */
setDD(float ii, float jj, float kk, int ss, int moving_axes){
  switch(moving_axes){
  case 1:
  case 2:
  case 3:
    DD[0] = (ii+0.5+ss-ROWS/2.0)*8.0;
    DD[1] = (jj-ROWS/2.0)*8.0;
    DD[2] = (kk-ROWS/2.0)*8.0;
    break;
  case 4:
  case 5:
    DD[0] = (jj-ROWS/2.0)*8.0;
    DD[1] = (ii+0.5+ss-ROWS/2.0)*8.0;
    DD[2] = (kk-ROWS/2.0)*8.0;
    break;
  case 6:
    DD[0] = (jj-ROWS/2.0)*8.0;
    DD[1] = (kk-ROWS/2.0)*8.0;
    DD[2] = (ii+0.5+ss-ROWS/2.0)*8.0;
    break;
  }
}

/* MAY 1999 */
/* These could easily be 'define' */
/* Note: Here rectangles have just one face and 4 vertices...
   do I really need 2 faces and 6 vertices? */
draw_otheredges(float dd, float old_dd, int ss, int II, int JJ, 
		int moving_axes, float del){
  int kk,ll;
  /* JUNE 1999
     del_div8 because, unlike init_vv & drawmaze, 
     setDD & draw_intersections misses the factor of 8.0 */
  float del_div8 = del/8.0;
  if((dd+(2*del_div8))<old_dd){
    for(kk=0;kk<ROWS1;kk++)for(ll=0;ll<ROWS;ll++)
      if(oe1[II][JJ][kk][ll]){
	glBegin(GL_TRIANGLE_STRIP);
	glColor3f(oe1_color[0],oe1_color[1],oe1_color[2]);
	setDD(dd+del_div8,kk,ll+del_div8,ss,moving_axes);glVertex3f(DDList);
	setDD(old_dd-del_div8,kk,ll+del_div8,ss,moving_axes);glVertex3f(DDList);
	setDD(dd+del_div8,kk,ll+1-del_div8,ss,moving_axes);glVertex3f(DDList);
	setDD(old_dd-del_div8,kk,ll+1-del_div8,ss,moving_axes);glVertex3f(DDList);
	glEnd();
      }
    for(kk=0;kk<ROWS;kk++)for(ll=0;ll<ROWS1;ll++)
      if(oe2[II][JJ][kk][ll]){
	glBegin(GL_TRIANGLE_STRIP);
	glColor3f(oe2_color[0],oe2_color[1],oe2_color[2]);
	setDD(dd+del_div8,kk+del_div8,ll,ss,moving_axes);glVertex3f(DDList);
	setDD(old_dd-del_div8,kk+del_div8,ll,ss,moving_axes);glVertex3f(DDList);
	setDD(dd+del_div8,kk+1-del_div8,ll,ss,moving_axes);glVertex3f(DDList);
	setDD(old_dd-del_div8,kk+1-del_div8,ll,ss,moving_axes);glVertex3f(DDList);
	glEnd();
      }
  }
  else if((old_dd+(2*del_div8))<dd){
    for(kk=0;kk<ROWS;kk++)for(ll=0;ll<ROWS1;ll++)
      if(oe2[II][JJ][kk][ll]){
	glBegin(GL_TRIANGLE_STRIP);
	glColor3f(oe2_color[0],oe2_color[1],oe2_color[2]);
	setDD(dd-del_div8,kk+del_div8,ll,ss,moving_axes);glVertex3f(DDList);
	setDD(old_dd+del_div8,kk+del_div8,ll,ss,moving_axes);glVertex3f(DDList);
	setDD(dd-del_div8,kk+1-del_div8,ll,ss,moving_axes);glVertex3f(DDList);
	setDD(old_dd+del_div8,kk+1-del_div8,ll,ss,moving_axes);glVertex3f(DDList);
	glEnd();
      }
    for(kk=0;kk<ROWS1;kk++)for(ll=0;ll<ROWS;ll++)
      if(oe1[II][JJ][kk][ll]){
	glBegin(GL_TRIANGLE_STRIP);
	glColor3f(oe1_color[0],oe1_color[1],oe1_color[2]);
	setDD(dd-del_div8,kk,ll+del_div8,ss,moving_axes);glVertex3f(DDList);
	setDD(old_dd+del_div8,kk,ll+del_div8,ss,moving_axes);glVertex3f(DDList);
	setDD(dd-del_div8,kk,ll+1-del_div8,ss,moving_axes);glVertex3f(DDList);
	setDD(old_dd+del_div8,kk,ll+1-del_div8,ss,moving_axes);glVertex3f(DDList);
	glEnd();
      }    
  }
}
draw_hedge(float dd, int kk, int ll, int ss, int moving_axes, float del){
  float del_div8 = del/8.0;
  glBegin(GL_TRIANGLE_STRIP);
  glColor3f(he_color[0],he_color[1],he_color[2]);
  setDD(dd,kk+del_div8,ll+del_div8,ss,moving_axes);glVertex3f(DDList);
  setDD(dd,kk+1-del_div8,ll+del_div8,ss,moving_axes);glVertex3f(DDList);
  setDD(dd,kk+del_div8,ll+1-del_div8,ss,moving_axes);glVertex3f(DDList);
  setDD(dd,kk+1-del_div8,ll+1-del_div8,ss,moving_axes);glVertex3f(DDList);
  glEnd();
}
draw_vedge(float dd, int kk, int ll, int ss, int moving_axes, float del){
  float del_div8 = del/8.0;
  glBegin(GL_TRIANGLE_STRIP);
  glColor3f(ve_color[0],ve_color[1],ve_color[2]);
  setDD(dd,kk+del_div8,ll+del_div8,ss,moving_axes);glVertex3f(DDList);
  setDD(dd,kk+1-del_div8,ll+del_div8,ss,moving_axes);glVertex3f(DDList);
  setDD(dd,kk+del_div8,ll+1-del_div8,ss,moving_axes);glVertex3f(DDList);
  setDD(dd,kk+1-del_div8,ll+1-del_div8,ss,moving_axes);glVertex3f(DDList);
  glEnd();
}
draw_hvedge(float dd, int kk, int ll, int ss, int moving_axes, float del){
  float del_div8 = del/8.0;
  glBegin(GL_TRIANGLE_STRIP);
  glColor3f(BASIC_GREY[0],BASIC_GREY[1],BASIC_GREY[2]);
  setDD(dd,kk+del_div8,ll+del_div8,ss,moving_axes);glVertex3f(DDList);
  setDD(dd,kk+1-del_div8,ll+del_div8,ss,moving_axes);glVertex3f(DDList);
  setDD(dd,kk+del_div8,ll+1-del_div8,ss,moving_axes);glVertex3f(DDList);
  setDD(dd,kk+1-del_div8,ll+1-del_div8,ss,moving_axes);glVertex3f(DDList);
  glEnd();
}

/* MAY 1999: Changed */
draw_intersections(int ss, int tt, float theta, int moving_axes,float del) {
  /***/static int virgin=0;
  
  float ii,jj,old_ii,old_jj,slope,tanTh,sinTh,cosTh,dd,old_dd;
  int skip_many,kk,ll;
  int II,JJ;/* the edge of the point ii,jj */
  int h_or_v;  /* 1 if he, 2 if ve, 3 if both, 0 if neither */
  tanTh = tan(theta);
  sinTh = sin(theta);
  cosTh = cos(theta);
  
  /* JUNE 1999 EDIT
  printf("\n theta = %f",theta);
     JUNE 1999 EDIT */

  if(theta>0){
    /* Draw edges orthogonal to the moving axes, but uh... */
    /* Draw other line segments later, as intersecting 
       points are drawn */
    if(ss>=0 && tt>=0 && ss<ROWS && tt<ROWS){
      if(1.0<=tanTh){
	old_jj=tt+1;
	old_ii=ss+0.5+(old_jj-tt-0.5)/tanTh;
	jj=tt;
	ii=ss+0.5+(jj-tt-0.5)/tanTh;
	old_dd=.5/sinTh;dd=-.5/sinTh;
	draw_otheredges(dd,old_dd,ss,ss,tt,moving_axes,del);
      }
      else /*(slope=1.0)>tanTh*/{
	old_ii=ss;
	old_jj=tt+0.5+(old_ii-ss-0.5)*tanTh;
	ii=ss+1;
	jj=tt+0.5+(ii-ss-0.5)*tanTh;
	old_dd=.5/cosTh;dd=-.5/cosTh;
	draw_otheredges(dd,old_dd,ss,ss,tt,moving_axes,del);
      }  
    }
    /* Determine whether or not the lower left part of the line-of-sight
       intersects the maze at all, and find the first intersection with
       the border */
    if(ss<0 || tt<0) skip_many=1;
    else{
      if(ss<ROWS && tt<ROWS){
	skip_many=0;
	if(1.0<=tanTh){
	  old_jj=jj=tt;
	  old_ii=ii=ss+0.5+(jj-tt-0.5)/tanTh;
	  old_dd=dd=-.5/sinTh;}
	else /*(slope=1.0)>tanTh*/{
	  old_ii=ii=ss;
	  old_jj=jj=tt+0.5+(ii-ss-0.5)*tanTh;
	  old_dd=dd=-.5/cosTh;}
      }
      else{            /* not in maze, but in first quadrant */
	ii=ss+0.5;jj=tt+0.5;
	if(ss>=ROWS && tt>=ROWS){
	  skip_many=0;
	  slope=jj/(ii-ROWS);/* location to lower right corner */
	  if(tanTh>slope)skip_many=1;
	  slope=(jj-ROWS)/ii;/* location to upper left corner */
	  if(tanTh<slope)skip_many=1;
	  if(skip_many==0){
	    slope=(jj-ROWS)/(ii-ROWS);
	    if(tanTh<slope){
	      old_jj=jj=ROWS;
	      old_ii=ii=ss+0.5-(tt+0.5-jj)/tanTh;
	      old_dd=dd=-(tt+0.5-jj)/sinTh;
	    }
	    else{ /* tanTh>=slope */
	      old_ii=ii=ROWS;
	      old_jj=jj=tt+0.5-(ss+0.5-ii)*tanTh;
	      old_dd=dd=-(ss+0.5-ii)/cosTh;
	    }
	  }
	}
	else if(ss<ROWS){ /* && tt>=ROWS */
	  slope=(jj-ROWS)/ii;/* location to upper left corner */
	  if(tanTh<slope)skip_many=1;
	  else{
	    skip_many=0;
	    old_jj=jj=ROWS;
	    old_ii=ii=ss+0.5-(tt+0.5-jj)/tanTh;
	    old_dd=dd=-(tt+0.5-jj)/sinTh;
	  }
	}
	else{ /* tt<ROWS && ss>=ROWS */
	  slope=jj/(ii-ROWS);/* location to lower right corner */
	  if(tanTh>slope)skip_many=1;	
	  else{
	    skip_many=0;
	    old_ii=ii=ROWS;
	    old_jj=jj=tt+0.5-(ss+0.5-ii)*tanTh;
	    old_dd=dd=-(ss+0.5-ii)/cosTh;
	  }
	}
      }
    } /* determined skip_many and found first intersection point */
    
    if(!skip_many){   /* Draw the lower left intersection points 
			 and segments */
      /***
	  if(!virgin)printf("tanTh=%f\n",tanTh);
	  if(!virgin)printf("ii=%f jj=%f\n",ii,jj);
      ***/
      
      /* Draw the first interection point */
      if(ii==ceil(ii) && jj==ceil(jj)){/* hits a corner */
	II = (int)ii;JJ=(int)jj;
	for(kk=0;kk<ROWS;kk++)for(ll=0;ll<ROWS;ll++){
	  if(ii==ROWS) h_or_v = he[II-1][JJ][kk][ll];
	  else if(ii==0) h_or_v = he[II][JJ][kk][ll];
	  else h_or_v = ((he[II][JJ][kk][ll] || he[II-1][JJ][kk][ll])?1:0);
	  if(jj==ROWS) h_or_v += 2*ve[II][JJ-1][kk][ll];
	  else if(jj==0) h_or_v += 2*ve[II][JJ][kk][ll];
	  else h_or_v += 2*((ve[II][JJ][kk][ll]||ve[II][JJ-1][kk][ll])?1:0);
	  switch(h_or_v){
	  case 1: draw_hedge(dd,kk,ll,ss,moving_axes,del);break;
	  case 2: draw_vedge(dd,kk,ll,ss,moving_axes,del);break;
	  case 3: draw_hvedge(dd,kk,ll,ss,moving_axes,del);break;
	  }
	}
      }
      else if(jj==ceil(jj)){ /* point on horizontal edge */
	II=(int)floor(ii); JJ=(int)jj;
	for(kk=0;kk<ROWS;kk++)for(ll=0;ll<ROWS;ll++)
	  if(he[II][JJ][kk][ll])
	    draw_hedge(dd,kk,ll,ss,moving_axes,del);
      }
      else{                  /* point on a vertical edge */
	II=(int)ii; JJ=(int)floor(jj);
	for(kk=0;kk<ROWS;kk++)for(ll=0;ll<ROWS;ll++)
	  if(ve[II][JJ][kk][ll])
	    draw_vedge(dd,kk,ll,ss,moving_axes,del);
      }
      /* Drew the first intersection point */
      
      while(ii>0 && jj>0){  /* lower left interior intersection points */
	/***
	    if(!virgin)printf("while: ii=%f jj=%f",ii,jj);
	***/
	slope = (jj-ceil(jj)+1)/(ii-ceil(ii)+1);
	/***
	    if(!virgin)printf(" slope=%f\n",slope);
	***/
	if(slope==tanTh){     /* hits a corner, which is unlikely, but....
				 Up to 2 vert edges and 2 horiz edges to check */
	  ii = ceil(ii)-1; jj = ceil(jj)-1;II = (int)ii;JJ=(int)jj;
	  dd=-(ss+.5-ii)/cosTh;
	  for(kk=0;kk<ROWS;kk++)for(ll=0;ll<ROWS;ll++){
	    if(ii==0) h_or_v = he[II][JJ][kk][ll];
	    else h_or_v = ((he[II][JJ][kk][ll] || he[II-1][JJ][kk][ll])?1:0);
	    if(jj==0) h_or_v += 2*ve[II][JJ][kk][ll];
	    else h_or_v += 2*((ve[II][JJ][kk][ll]||ve[II][JJ-1][kk][ll])?1:0);
	    switch(h_or_v){
	    case 1: draw_hedge(dd,kk,ll,ss,moving_axes,del);break;
	    case 2: draw_vedge(dd,kk,ll,ss,moving_axes,del);break;
	    case 3: draw_hvedge(dd,kk,ll,ss,moving_axes,del);break;
	    }
	  }
	}
	else if(slope<tanTh){ /* hits a horizontal edge */
	  jj=ceil(jj)-1;
	  ii=ss+0.5+(jj-tt-0.5)/tanTh;
	  dd=-(tt+.5-jj)/sinTh;
	  II=(int)floor(ii); JJ=(int)jj;
	  for(kk=0;kk<ROWS;kk++)for(ll=0;ll<ROWS;ll++)
	    if(he[II][JJ][kk][ll])
	      draw_hedge(dd,kk,ll,ss,moving_axes,del);
	}
	else /*slope>tanTh*/{ /* hits a vertical edge */
	  ii=ceil(ii)-1;
	  jj=tt+0.5+(ii-ss-0.5)*tanTh;
	  dd=-(ss+.5-ii)/cosTh;
	  II=(int)ii; JJ=(int)floor(jj);
	  for(kk=0;kk<ROWS;kk++)for(ll=0;ll<ROWS;ll++)
	    if(ve[II][JJ][kk][ll])
	      draw_vedge(dd,kk,ll,ss,moving_axes,del);
	}
	/* DrawOtherColoredLineSomewhere */
	II=floor((ii+old_ii)/2.0);
	JJ=floor((jj+old_jj)/2.0);
	draw_otheredges(dd,old_dd,ss,II,JJ,moving_axes,del);
	old_ii=ii;old_jj=jj;old_dd=dd;
      }
    }

    /* SAME rigamarole for upper right points and segments */
    if(ss>=ROWS || tt>=ROWS) skip_many=1;
    else{
      if(ss>=0 && tt>=0){
	skip_many=0;
	if(1.0<=tanTh){
	  old_jj=jj=tt+1;
	  old_ii=ii=ss+0.5+(jj-tt-0.5)/tanTh;
	  old_dd=dd=.5/sinTh;}
	else /*(slope=1.0)>tanTh*/{
	  old_ii=ii=ss+1;
	  old_jj=jj=tt+0.5+(ii-ss-0.5)*tanTh;
	  old_dd=dd=.5/cosTh;}
      }
      else{            /* not in maze, but in first quadrant */
	ii=ss+0.5;jj=tt+0.5;
	if(ss<0 && tt<0){
	  skip_many=0;
	  slope=jj/(ii-ROWS);/* location to lower right corner */
	  if(tanTh<slope)skip_many=1;
	  slope=(jj-ROWS)/ii;/* location to upper left corner */
	  if(tanTh>slope)skip_many=1;
	  if(skip_many==0){
	    slope=(jj)/(ii);
	    if(tanTh<slope){
	      old_jj=jj=0;
	      old_ii=ii=ss+0.5-(tt+0.5-jj)/tanTh;
	      old_dd=dd=(jj-(tt+0.5))/sinTh;
	    }
	    else{ /* tanTh>=slope */
	      old_ii=ii=0;
	      old_jj=jj=tt+0.5-(ss+0.5-ii)*tanTh;
	      old_dd=dd=(ii-(ss+0.5))/cosTh;
	    }
	  }
	}
	else if(ss>=0){ /* && tt<=0 */
	  slope=jj/(ii-ROWS);/* location to lower right corner */
	  if(tanTh<slope)skip_many=1;
	  else{
	    skip_many=0;
	    old_jj=jj=0;
	    old_ii=ii=ss+0.5-(tt+0.5-jj)/tanTh;
	    old_dd=dd=-(tt+0.5-jj)/sinTh;
	  }
	}
	else{ /* tt>0 && ss<=0 */
	  slope=(jj-ROWS)/ii;/* location to upper left corner */
	  if(tanTh>slope)skip_many=1;	
	  else{
	    skip_many=0;
	    old_ii=ii=0;
	    old_jj=jj=tt+0.5-(ss+0.5-ii)*tanTh;
	    old_dd=dd=-(ss+0.5-ii)/cosTh;
	  }
	}
      }
    } /* determined skip_many and found first intersection point */
    
    if(!skip_many){   /* Draw the upper right intersection points 
			 and segments */
      /* Draw the first point */
      if(ii==ceil(ii) && jj==ceil(jj)){/* hits a corner */
	II = (int)ii;JJ=(int)jj;
	for(kk=0;kk<ROWS;kk++)for(ll=0;ll<ROWS;ll++){
	  if(ii==ROWS) h_or_v = he[II-1][JJ][kk][ll];
	  else if(ii==0) h_or_v = he[II][JJ][kk][ll];
	  else h_or_v = ((he[II][JJ][kk][ll] || he[II-1][JJ][kk][ll])?1:0);
	  if(jj==ROWS) h_or_v += 2*ve[II][JJ-1][kk][ll];
	  else if(jj==0) h_or_v += 2*ve[II][JJ][kk][ll];
	  else h_or_v += 2*((ve[II][JJ][kk][ll]||ve[II][JJ-1][kk][ll])?1:0);
	  switch(h_or_v){
	  case 1: draw_hedge(dd,kk,ll,ss,moving_axes,del);break;
	  case 2: draw_vedge(dd,kk,ll,ss,moving_axes,del);break;
	  case 3: draw_hvedge(dd,kk,ll,ss,moving_axes,del);break;
	  }
	}
      }
      else if(jj==ceil(jj)){ /* point on horizontal edge */
	II=(int)floor(ii); JJ=(int)jj;
	for(kk=0;kk<ROWS;kk++)for(ll=0;ll<ROWS;ll++)
	  if(he[II][JJ][kk][ll])
	    draw_hedge(dd,kk,ll,ss,moving_axes,del);
      }
      else{                  /* point on a vertical edge */
	II=(int)ii; JJ=(int)floor(jj);
	for(kk=0;kk<ROWS;kk++)for(ll=0;ll<ROWS;ll++)
	  if(ve[II][JJ][kk][ll])
	    draw_vedge(dd,kk,ll,ss,moving_axes,del);
      }
      /* Drew the first point */
      
      while(ii<ROWS && jj<ROWS){  /* upper right intersection points */
	slope = (jj-floor(jj)-1)/(ii-floor(ii)-1);
	if(slope==tanTh){
	  ii = floor(ii)+1; jj = floor(jj)+1;II = (int)ii;JJ=(int)jj;
	  dd=-(ss+.5-ii)/cosTh;
	  for(kk=0;kk<ROWS;kk++)for(ll=0;ll<ROWS;ll++){
	    if(ii==ROWS) h_or_v = he[II-1][JJ][kk][ll];
	    else h_or_v = ((he[II][JJ][kk][ll] || he[II-1][JJ][kk][ll])?1:0);
	    if(jj==ROWS) h_or_v += 2*ve[II][JJ-1][kk][ll];
	    else h_or_v += 2*((ve[II][JJ][kk][ll]||ve[II][JJ-1][kk][ll])?1:0);
	    switch(h_or_v){
	    case 1: draw_hedge(dd,kk,ll,ss,moving_axes,del);break;
	    case 2: draw_vedge(dd,kk,ll,ss,moving_axes,del);break;
	    case 3: draw_hvedge(dd,kk,ll,ss,moving_axes,del);break;
	    }
	  }
	}
	else if(slope<tanTh){ /* hits a horizontal edge */
	  jj=floor(jj)+1;
	  ii=ss+0.5+(jj-tt-0.5)/tanTh;
	  dd=-(tt+.5-jj)/sinTh;
	  II=(int)floor(ii); JJ=(int)jj;
	  for(kk=0;kk<ROWS;kk++)for(ll=0;ll<ROWS;ll++)
	    if(he[II][JJ][kk][ll])
	      draw_hedge(dd,kk,ll,ss,moving_axes,del);
	}
	else /*slope>tanTh*/{ /* hits a vertical edge */
	  ii=floor(ii)+1;
	  jj=tt+0.5+(ii-ss-0.5)*tanTh;
	  dd=-(ss+.5-ii)/cosTh;
	  II=(int)ii; JJ=(int)floor(jj);
	  for(kk=0;kk<ROWS;kk++)for(ll=0;ll<ROWS;ll++)
	    if(ve[II][JJ][kk][ll])
	      draw_vedge(dd,kk,ll,ss,moving_axes,del);
	}
	/* DrawOtherColoredLineSomewhere */
	II=floor((ii+old_ii)/2.0);
	JJ=floor((jj+old_jj)/2.0);
	draw_otheredges(dd,old_dd,ss,II,JJ,moving_axes,del);
	old_ii=ii;old_jj=jj;old_dd=dd;
      }
    }
    /***/virgin=1;
  }
  
  if(theta<0){
    /* Draw line segment containing location */
    /* Draw other line segments later, as intersecting 
       points are drawn */
    if(ss>=0 && tt>=0 && ss<ROWS && tt<ROWS){
      if(-1.0>=tanTh){
	old_jj=tt+1;
	old_ii=ss+0.5+(old_jj-tt-0.5)/tanTh;      
	jj=tt;
	ii=ss+0.5+(jj-tt-0.5)/tanTh;
	old_dd=.5/sinTh;dd=-.5/sinTh;
	draw_otheredges(dd,old_dd,ss,ss,tt,moving_axes,del);
      }
      else /*(slope=-1.0)<tanTh*/{
	old_ii=ss;
	old_jj=tt+0.5+(old_ii-ss-0.5)*tanTh;
	ii=ss+1;
	jj=tt+0.5+(ii-ss-0.5)*tanTh;
	old_dd=.5/cosTh;dd=-.5/cosTh;
	draw_otheredges(dd,old_dd,ss,ss,tt,moving_axes,del);
      }
    }  
    
    /* Determine whether or not the upper left part of the line-of-sight
       intersects the maze at all, and find the first intersection with
       the border */
    if(ss<0 || tt>=ROWS) skip_many=1;
    else{
      if(ss<ROWS && tt>=0){
	skip_many=0;
	if(-1.0>=tanTh){
	  old_jj=jj=tt+1;
	  old_ii=ii=ss+0.5+(jj-tt-0.5)/tanTh;
	  old_dd=dd=.5/sinTh;}
	else /*(slope=-1.0)<tanTh*/{
	  old_ii=ii=ss;
	  old_jj=jj=tt+0.5+(ii-ss-0.5)*tanTh;
	  old_dd=dd=-.5/cosTh;}
      }
      else{            /* not in maze, but in lower rightish aprt */
	ii=ss+0.5;jj=tt+0.5;
	if(ss>=ROWS && tt<0){
	  skip_many=0;
	  slope=(jj-ROWS)/(ii-ROWS);/* location to upper right corner */
	  if(tanTh<slope)skip_many=1;
	  slope=jj/ii;/* location to lower left corner */
	  if(tanTh>slope)skip_many=1;
	  if(skip_many==0){
	    slope=jj/(ii-ROWS);
	    if(tanTh>slope){
	      old_jj=jj=0;
	      old_ii=ii=ss+0.5-(tt+0.5-jj)/tanTh;
	      old_dd=dd=-(tt+0.5-jj)/sinTh;
	    }
	    else{ /* tanTh<=slope */
	      old_ii=ii=ROWS;
	      old_jj=jj=tt+0.5-(ss+0.5-ii)*tanTh;
	      old_dd=dd=-(ss+0.5-ii)/cosTh;
	    }
	  }
	}
	else if(ss<ROWS){ /* && tt<0 */
	  slope=jj/ii;/* location to lower left corner */
	  if(tanTh>slope)skip_many=1;
	  else{
	    skip_many=0;
	    old_jj=jj=0;
	    old_ii=ii=ss+0.5-(tt+0.5-jj)/tanTh;
	    old_dd=dd=-(tt+0.5-jj)/sinTh;
	  }
	}
	else{ /* tt>=0 && ss>=ROWS */
	  slope=(jj-ROWS)/(ii-ROWS);/* location to upper right corner */
	  if(tanTh<slope)skip_many=1;	
	  else{
	    skip_many=0;
	    old_ii=ii=ROWS;
	    old_jj=jj=tt+0.5-(ss+0.5-ii)*tanTh;
	    old_dd=dd=-(ss+0.5-ii)/cosTh;
	  }
	}
      }
    } /* determined skip_many and found first intersection point */

    if(!skip_many){   /* Draw the upper left intersection points 
			 and segments */
      /* Draw the first intersection point */
      /* no change here due to sign of theta */
      if(ii==ceil(ii) && jj==ceil(jj)){/* hits a corner */
	II = (int)ii;JJ=(int)jj;
	for(kk=0;kk<ROWS;kk++)for(ll=0;ll<ROWS;ll++){
	  if(ii==ROWS) h_or_v = he[II-1][JJ][kk][ll];
	  else if(ii==0) h_or_v = he[II][JJ][kk][ll];
	  else h_or_v = ((he[II][JJ][kk][ll] || he[II-1][JJ][kk][ll])?1:0);
	  if(jj==ROWS) h_or_v += 2*ve[II][JJ-1][kk][ll];
	  else if(jj==0) h_or_v += 2*ve[II][JJ][kk][ll];
	  else h_or_v += 2*((ve[II][JJ][kk][ll]||ve[II][JJ-1][kk][ll])?1:0);
	  switch(h_or_v){
	  case 1: draw_hedge(dd,kk,ll,ss,moving_axes,del);break;
	  case 2: draw_vedge(dd,kk,ll,ss,moving_axes,del);break;
	  case 3: draw_hvedge(dd,kk,ll,ss,moving_axes,del);break;
	  }
	}
      }
      else if(jj==ceil(jj)){ /* point on horizontal edge */
	II=(int)floor(ii); JJ=(int)jj;
	for(kk=0;kk<ROWS;kk++)for(ll=0;ll<ROWS;ll++)
	  if(he[II][JJ][kk][ll])
	    draw_hedge(dd,kk,ll,ss,moving_axes,del);
      }
      else{                  /* point on a vertical edge */
	II=(int)ii; JJ=(int)floor(jj);
	for(kk=0;kk<ROWS;kk++)for(ll=0;ll<ROWS;ll++)
	  if(ve[II][JJ][kk][ll])
	    draw_vedge(dd,kk,ll,ss,moving_axes,del);
      }
      /* Drew the first intersection point */
      
      while(ii>0 && jj<ROWS){  /* upper left interior intersection points */
	slope = (jj-floor(jj)-1)/(ii-ceil(ii)+1);
	if(slope==tanTh){     /* hits a corner, which is unlikely, but....
				 Up to 2 vert edges and 2 horiz edges to check */
	  ii = ceil(ii)-1; jj = floor(jj)+1;II = (int)ii;JJ=(int)jj;
	  dd=-(ss+.5-ii)/cosTh;
	  for(kk=0;kk<ROWS;kk++)for(ll=0;ll<ROWS;ll++){
	    if(ii==0) h_or_v = he[II][JJ][kk][ll];
	    else h_or_v = ((he[II][JJ][kk][ll] || he[II-1][JJ][kk][ll])?1:0);
	    if(jj==ROWS) h_or_v += 2*ve[II][JJ-1][kk][ll];
	    else h_or_v += 2*((ve[II][JJ][kk][ll]||ve[II][JJ-1][kk][ll])?1:0);
	    switch(h_or_v){
	    case 1: draw_hedge(dd,kk,ll,ss,moving_axes,del);break;
	    case 2: draw_vedge(dd,kk,ll,ss,moving_axes,del);break;
	    case 3: draw_hvedge(dd,kk,ll,ss,moving_axes,del);break;
	    }
	  }
	}
	else if(slope>tanTh){ /* hits a horizontal edge */
	  jj=floor(jj)+1;
	  ii=ss+0.5+(jj-tt-0.5)/tanTh;
	  dd=-(tt+.5-jj)/sinTh;
	  II=(int)floor(ii); JJ=(int)jj;
	  for(kk=0;kk<ROWS;kk++)for(ll=0;ll<ROWS;ll++)
	    if(he[II][JJ][kk][ll])
	      draw_hedge(dd,kk,ll,ss,moving_axes,del);
	}
	else /*slope<tanTh*/{ /* hits a vertical edge */
	  ii=ceil(ii)-1;
	  jj=tt+0.5+(ii-ss-0.5)*tanTh;
	  dd=-(ss+.5-ii)/cosTh;
	  II=(int)ii; JJ=(int)floor(jj);
	  for(kk=0;kk<ROWS;kk++)for(ll=0;ll<ROWS;ll++)
	    if(ve[II][JJ][kk][ll])
	      draw_vedge(dd,kk,ll,ss,moving_axes,del);
	}
	/* DrawOtherColoredLineSomewhere */
	II=floor((ii+old_ii)/2.0);
	JJ=floor((jj+old_jj)/2.0);
	draw_otheredges(dd,old_dd,ss,II,JJ,moving_axes,del);
	old_ii=ii;old_jj=jj;old_dd=dd;
      }
    }
    
    /* SAME rigamarole for lower right points and segments */
    if(ss>=ROWS || tt<0) skip_many=1;
    else{
      if(ss>=0 && tt<ROWS){
	skip_many=0;
	if(-1.0>=tanTh){
	  old_jj=jj=tt;
	  old_ii=ii=ss+0.5+(jj-tt-0.5)/tanTh;
	  old_dd=dd=-.5/sinTh;}
	else /*(slope=-1.0)<tanTh*/{
	  old_ii=ii=ss+1;
	  old_jj=jj=tt+0.5+(ii-ss-0.5)*tanTh;
	  old_dd=dd=.5/cosTh;}
      }
      else{            /* not in maze, but in upper leftish part */
	ii=ss+0.5;jj=tt+0.5;
	if(ss<0 && tt>=ROWS){
	  skip_many=0;
	  slope=(jj-ROWS)/(ii-ROWS);/* location to upper right corner */
	  if(tanTh>slope)skip_many=1;
	  slope=jj/ii;/* location to lower left corner */
	  if(tanTh<slope)skip_many=1;
	  if(skip_many==0){
	    slope=(jj-ROWS)/(ii);
	    if(tanTh>slope){
	      old_jj=jj=ROWS;
	      old_ii=ii=ss+0.5-(tt+0.5-jj)/tanTh;
	      old_dd=dd=(jj-(tt+0.5))/sinTh;
	    }
	    else{ /* tanTh<=slope */
	      old_ii=ii=0;
	      old_jj=jj=tt+0.5-(ss+0.5-ii)*tanTh;
	      old_dd=dd=(ii-(ss+0.5))/cosTh;
	    }
	  }
	}
	else if(ss>=0){ /* && tt>=ROWS */
	  slope=(jj-ROWS)/(ii-ROWS);/* location to upper right corner */
	  if(tanTh>slope)skip_many=1;
	  else{
	    skip_many=0;
	    old_jj=jj=ROWS;
	    old_ii=ii=ss+0.5-(tt+0.5-jj)/tanTh;
	    old_dd=dd=-(tt+0.5-jj)/sinTh;
	  }
	}
	else{ /* tt<ROWS && ss<0 */
	  slope=jj/ii;/* location to lower left corner */
	  if(tanTh<slope)skip_many=1;	
	  else{
	    skip_many=0;
	    old_ii=ii=0;
	    old_jj=jj=tt+0.5-(ss+0.5-ii)*tanTh;
	    old_dd=dd=-(ss+0.5-ii)/cosTh;
	  }
	}
      }
    } /* determined skip_many and found first intersection point */
    
    if(!skip_many){   /* Draw the lower right intersection points 
			 and segments */
      /* Draw the first point */
      if(ii==ceil(ii) && jj==ceil(jj)){/* hits a corner */
	II = (int)ii;JJ=(int)jj;
	for(kk=0;kk<ROWS;kk++)for(ll=0;ll<ROWS;ll++){
	  if(ii==ROWS) h_or_v = he[II-1][JJ][kk][ll];
	  else if(ii==0) h_or_v = he[II][JJ][kk][ll];
	  else h_or_v = ((he[II][JJ][kk][ll] || he[II-1][JJ][kk][ll])?1:0);
	  if(jj==ROWS) h_or_v += 2*ve[II][JJ-1][kk][ll];
	  else if(jj==0) h_or_v += 2*ve[II][JJ][kk][ll];
	  else h_or_v += 2*((ve[II][JJ][kk][ll]||ve[II][JJ-1][kk][ll])?1:0);
	  switch(h_or_v){
	  case 1: draw_hedge(dd,kk,ll,ss,moving_axes,del);break;
	  case 2: draw_vedge(dd,kk,ll,ss,moving_axes,del);break;
	  case 3: draw_hvedge(dd,kk,ll,ss,moving_axes,del);break;
	  }
	}
      }
      else if(jj==ceil(jj)){ /* point on horizontal edge */
	II=(int)floor(ii); JJ=(int)jj;
	for(kk=0;kk<ROWS;kk++)for(ll=0;ll<ROWS;ll++)
	  if(he[II][JJ][kk][ll])
	    draw_hedge(dd,kk,ll,ss,moving_axes,del);
      }
      else{                  /* point on a vertical edge */
	II=(int)ii; JJ=(int)floor(jj);
	for(kk=0;kk<ROWS;kk++)for(ll=0;ll<ROWS;ll++)
	  if(ve[II][JJ][kk][ll])
	    draw_vedge(dd,kk,ll,ss,moving_axes,del);
      }
      /* Drew the first point */
      
      while(ii<ROWS && jj>0){  /* lower right intersection points */
	slope = (jj-ceil(jj)+1)/(ii-floor(ii)-1);
	if(slope==tanTh){
	  ii = floor(ii)+1; jj = ceil(jj)-1;II = (int)ii;JJ=(int)jj;
	  II = (int)ii;JJ=(int)jj;
	  dd=-(ss+.5-ii)/cosTh;
	  for(kk=0;kk<ROWS;kk++)for(ll=0;ll<ROWS;ll++){
	    if(ii==ROWS) h_or_v = he[II-1][JJ][kk][ll];
	    else h_or_v = ((he[II][JJ][kk][ll] || he[II-1][JJ][kk][ll])?1:0);
	    if(jj==0) h_or_v += 2*ve[II][JJ][kk][ll];
	    else h_or_v += 2*((ve[II][JJ][kk][ll]||ve[II][JJ-1][kk][ll])?1:0);
	    switch(h_or_v){
	    case 1: draw_hedge(dd,kk,ll,ss,moving_axes,del);break;
	    case 2: draw_vedge(dd,kk,ll,ss,moving_axes,del);break;
	    case 3: draw_hvedge(dd,kk,ll,ss,moving_axes,del);break;
	    }
	  }
	}
	else if(slope>tanTh){ /* hits a horizontal edge */
	  jj=ceil(jj)-1;
	  ii=ss+0.5+(jj-tt-0.5)/tanTh;
	  dd=-(tt+.5-jj)/sinTh;
	  II=(int)floor(ii); JJ=(int)jj;
	  for(kk=0;kk<ROWS;kk++)for(ll=0;ll<ROWS;ll++)
	    if(he[II][JJ][kk][ll])
	      draw_hedge(dd,kk,ll,ss,moving_axes,del);
	}
	else /*slope<tanTh*/{ /* hits a vertical edge */
	  ii=floor(ii)+1;
	  jj=tt+0.5+(ii-ss-0.5)*tanTh;
	  dd=-(ss+.5-ii)/cosTh;
	  II=(int)ii; JJ=(int)floor(jj);
	  for(kk=0;kk<ROWS;kk++)for(ll=0;ll<ROWS;ll++)
	    if(ve[II][JJ][kk][ll])
	      draw_vedge(dd,kk,ll,ss,moving_axes,del);
	}
	/* DrawOtherColoredLineSomewhere */
	II=floor((ii+old_ii)/2.0);
	JJ=floor((jj+old_jj)/2.0);
	draw_otheredges(dd,old_dd,ss,II,JJ,moving_axes,del);
	old_ii=ii;old_jj=jj;old_dd=dd;
      }
    }
  }
}
