// gkf 23dec04 for the mac
/* gkf Seattle, 8aug00 */
/* This is the successful version from 6-9-99, but on 6-10-99 was
   brought to beckman and is now being slightly improved, a la old_true/ */


/* 6-3-99 
   Should theta & sign_theta be floats, or merely converted to floats
   when and if necessary? */

/** Doesn't work, but compiles: 5-26-99 **/
/** Fundamental change - need to think about when including cavetrack:
    Made theta only global:
      Old: in chaptrack: static int theta; globally: int theta
      New: globally: int theta 
    This is needed for drawall & draw_intersections to use theta.
**/

/** This is being canibalized/changed into the final May 1999 version
    with visual 4D rotation:
    These changes will be highlighted with an indicator: 'MAY 1999'
    Still not done in June, so new edits: 'JUNE 1999'
**/

/** Note: this grafixlab one is not caved - a caved version should exist
    in Beckman **/



/* collision detection added 5/12/98 predawn 1am */

/* I think it works!, mostly 2/22/98 */
/* still have to add collision detection */
/* And either stairways or sound */
/* To cave it, I must figure out how I want to use the wand to ask 
   for a 4D rotation */

/* only changed for chaptrack - cavetrack probably won't work at all */
/* lagmvg was needed because the round multiples of 8 and 1 that I think
   of as typical aff & taff values are not that in the heart of chaptrack,
   only outside of the mucking around in chaptrack.  So to use roundaff, 
   roundtaff, showaff, showtaff, taff2aff & aff2taff right after a movement
   had been completed, I needed lagmvg. */
/* Changed location_w to location[3] */
/* location[4] represents the absolute location */
/* drawmaze() thinks LL is the location of the hidden variable */
/* The old program thinks that location_w is really
   the fourth location - not so good */
/* Actually, should replace location with lctn */
/* setmaze has a new maze, one with the concept of true 4D not stairs */

/* True4DMaze.c by Michael Pelsmajer 1998 */
/* maze4Dogl gkf 4dec97 */
/* This may just be the final elevator-style version */
/* note: location incompatible with TURNMODE - to begin correct location 
   again, need to zap */
/* based heavily on illiSkel (C) 1996 G.Francis, C.Hartman */
/* based even more so on... */
/****************************************************************/
/****            noosh.c = ishell97 to be                    ****/
/****           descended from ishell95                      ****/
/****            14 February 1995                            ****/
/****            29 August   1995                            ****/
/****             1 November 1995                            ****/ 
/****            15 november 1996   ishell96.c               ****/
/****            27 november 1996   ishell96.c               ****/
/****            23 march    1997   newsh.c                  ****/
/****    (C) 1994 Board of Trustees University of Illinois   ****/ 
/****    A Model Real-Time Interactive CAVE Application      ****/
/****    George Francis, Glenn Chappell, Chris Hartman       ****/
/****    e-mail  gfrancis@math.uiuc.edu                      ****/
/****    Generic RTICA by GGC 7/25/94 revised gkf 12.30.94   ****/ 
/****    Revised by GGC and GKF august 95                    ****/
/****    "Opengl ed" by AVB, nov 14-15, 1996                 ****/
/****    Reformatted by AVB, nov 16, 1996                    ****/
/****    adaptation to CAVE 2.6Beta started 6feb97 gkf       ****/
/****    New version to fix many bugs and clean up 17mar97 cmh  */
/****    Rationalization begun 26mar97 gkf                   ****/    
/****************************************************************/
/* CAVE trials 1apr97 bugs:
   1. At 24x24x2 triangles = 1152 we get 24fps with all 8 processors
      At 30x30x2 triangles = 1800 this drops to 16 fps on 8 processors
      With fewer processors (mpunlock) the dropoff is disastrous, 
   2. Current version (= 31mar97) does ambient only on process 2 (right
      wall and floor) .... no paint at all!
 
/* 
/* Some emerging conventions on the path of rationalization 

   draw<what> == this function uses GL calls for drawing something
   cons       == pertaining to the console mode only
   cave       == pertaining to the CAVE mode(s)
                 all such functions are protected by #ifdef CAVEs for
                 CAVE less compilation
   audio      == pertaining to the vss audio stuff required three
                 matched files: vssClient.h libsnd.a and vss 
                 should also be protected by #ifdef SOUNDs
   autotymer  == is (now) called only by the master process in the CAVE
                 with the result that non-shared globals are not updated
                 on the other walls. So we share them. 
   <factor>  == a factor is a function that has been separated out for 
                 (1) convenience (i.e. is not a factor of any other function) 
                 (2) necessity (i.e. is a factor of another function )
   <depth>   == from main() in the factor graph. 

   Of necessity, C requires that the factor graph be treelike with the leaves
   at the top of the program code. For a C++ conversion, this tree will be 
   turned upside down.  
*/

/* Factor graph for this program. Please indicate structural modifications 
   The asterisk indicates a factor that has more than one function calling it. 
   The Mm indicats something that is different from noosh. 
   Mm  main  
   Mm    arguments ....................command line switches and parameters 
           getopt  
         CAVEconfigure
         getmem .......................allocate shared memory  
           Malloc(share_var)
         dataprep .....................done only once   
           audioprep
             AUDinit
   Mm     *deFault 
   Mm      initvv
   Mm      makemaze/setmaze 
         ifCAVE
           FrameFunc(cavetrack)........done once every frame 
                       *deFault........on the reset button combination
                       *autotymer .....automatic clockwork animation
                       *audiofunc .....sends messages to soundserver
           InitApplic(drawcaveinit)....done each frame 
           Display(drawcave)...........done each frame
                    *drawstars
                     graffiti..........on the front CAVE wall
                        char2wall
                    *drawall
                       drawtor.........compressed version of tr1.c 
                         dovert........do everything for one vertex
                       drawcube........transfer from skel.c as exercise 
           while(notESC) cavekeybo.....done asynchronously from display
                           *deFault
           audioclean .................shut down audio server
           Exit........................shut down CAVE properly 
         ifCONS
           gluttery....................we use the GLUT library
              drawcons.................analogue to drawcave
                *drawstars
   Mm           *drawall 
   Mm               drawmaze
   Mm               drawstairs (commented out)
   Mm           messages...............analogue to grafitti
                  char2wall
                  speedometer..........unix based speedometer
   Mm         keyboard.................GLUT distinguishes between ascii keys 
   Mm           *deFault
                *audioclean
              special_keybo............and other kinds of keys
              mousepushed..............mouse buttons were pressed
              mousemoved...............mouse was moved       
              reshaped.................what to do if window is reshaped
   Mm         idle.....................done when nothing else is being done 
   Mm            chaptrack.............updates the two affine matrices 
   Mm           *autotymer.............preset directions for chaptrack
                *audiofunc.............updates the sound servers  
         endIF 
*/


//#pragma warning (disable:4305)  /* double-to-float  */
//#pragma warning (disable:4101)	/* unreferenced local variable */
//#pragma warning (disable:4056)	/* overflow in fp constant arithmetic */

#include <stdlib.h>
//#include <sys/types.h>
#include <math.h>

#include <sys/time.h>

#include <stdio.h>
#include <malloc.h>

#include <glut.h>
/*
#ifdef SOUND
#include <device.h>
#include <string.h>
#include "vssClient.h"
#endif
*/
#ifdef CAVE
#include <cave_ogl.h>
#include <cave.macros.h>
#endif 

#include "maze4Dogl.h"

/* Examples of useful geometric macros, use inliners in C++ */
#define  MAX(x,y)         (((x)<(y))?(y):(x))
#define  MIN(x,y)         (((x)<(y))?(x):(y))
#define  FOR(a,b,c)       for((a)=(b);(a)<(c);(a)++)
#define  DOT(p,q)         ((p)[0]*(q)[0]+(p)[1]*(q)[1]+(p)[2]*(q)[2])
#define  M_PI		   3.1415926
#define  DG            M_PI/180
#define  NRM(p)           sqrt(DOT((p),(p)))
/*
#define  S(u)          fsin(u*DG)
#define  C(u)          fcos(u*DG)
*/
#define  CLAMP(x,u,v) (x<u? u : (x>v ? v: x))

/* global variables ... add new ones on top of the stack */
char which[20]; /* audio needs this */
int delta; /* new variables for autotymer to change torus */
float gap, gap0=1.; /*very bad kludge ... for letting arguments reset default gap value */
int audiohandle; /* for telling vss the name of the .aud file */
float lux[3]={1.,2.,3.};             /*light source direction vector        */
float lu[3];     /* this needs to be shared current light direction vector*/
float mysiz, speed, torq, focal, Far; /*console navigation variables         */
int win = 0;                     /* 2 full screen, use 0 for demand sized */
int knopf = 0;
unsigned int BUT,XX,YY,SHIF;     /* used in chaptrack gluttery           */ 
int xt,yt;                       /* once was xt,yt,xm,ym for viewportery */
int caveyes=0;                      /* rename? ----------> caveflag */
int mode,morph,msg,binoc;            /* pretty global */
int th0, th1, dth, ta0, ta1, dta;    /* torus parameters */
/* some of center.c's variables follow: */
int rseed,location[4];/* location is absolute location */
int in_maze=1;int w_shift=0; int rand_maze=0;
float XYZchance,XZWchance,YZWchance,XYWchance,Delta;
char phrase[256];
long mx,my,xorig,yorig,xcen,ycen;
int cube,thick;int moving;int frozen,demo; 
int dir4[4];/* taff[3,8,13,18], the hidden direction */
/* MAY 1999: New variables: */
/* JUNE 1999: New variables: */
int rotating_in_4D; /* Boolean: chooses draw_maze on 0, 
		       draw_intersections on 1 */
float theta,sign_theta; /* for the 4D rotation */
int ActualAxes; /* 1: xzw->yzw, -1: yzw->xzw
		   2: xyw->yzw, -2: yzw->xyw
		   3: xyz->yzw, -3: yzw->xyz
		   4: xyw->xzw, -4: xzw->xyw
		   5: xyz->xzw, -5: xzw->xyz
		   6: xyz->xyw, -6: xyw->xyz */
/* theta_jump is change in theta for the 4D rotation only */
/* theta_jump must divide 90  */
#define theta_jump 3
#define max_theta_delay 1

#define FLYMODE  (0)
#define TURNMODE (1) 
/* From center.c; IF, TOGGLE, PRESS, FLYMODE & TURNMODE renamed SkFOO */
/* Let's use noosh's FLY/TURNMODE convention */
#define  ABS(x)           (((x)<0)?-(x):(x))
#define  SkIF(K)          if(getbutton(K))
#define  SOAK(K)        while(getbutton(K))
#define  SkTOGGLE(K,f)    SkIF(K){f = !f;SOAK(K);}
#define  IFCLICK(i,K,a) {static flg=i; SkTOGGLE(K,flg); if(flg){a};}
#define  ZDELTA         0xfffff
#define  ROUND(x)         (floor(x+.5))
#define  IFSHIFT        if(getbutton(LEFTSHIFTKEY)||getbutton(RIGHTSHIFTKEY))
#define  SkPRESS(K,A,b)   SkIF(K){IFSHIFT{A;}else{b;}}
#define  PRES_S(K,A,b)  SkIF(K){IFSHIFT{A;}else{b;};SOAK(K);}
#define  CYCLER(K,f,m)  PRES_S((K), (f)=(((f)+(m)-1)%(m)), (f)=(++(f)%(m)) )
#define  LF         (vert-=0.035)  /*as in line-feed */
#define  LAB_L(s,u) sprintf(phrase,s,u); cmov2(horz,vert); charstr(phrase);


/*Shared memory variables as per Stuart Levy 1994 */  
struct share_var{ 
   float  s_siz;         /*final scaling factor before projection      */  
   int s_wnd;            /*wand or maus flag                           */
   int s_gnd;            /*background color                            */
   float s_lu[3];         /* current light direction */ 
   int s_mauspaw ;      /*binary for mouse button state                     */
   int s_th0 ;           /* since the autotymer changes these          */
   int s_th1 ;           /* they need to be shared                      */
   int s_ta0 ;           /*                                             */
   int s_ta1 ;           /*                                             */
   float s_gap ;           /*                                             */
   GLfloat s_aff[16],s_starmat[16]; /*affine matrices for object, stars*/
   GLfloat s_taff[25],s_id[16]; /* 5D affine matrix */
} *s_var; 

#define siz     (s_var->s_siz)
#define wnd     (s_var->s_wnd)
#define gnd     (s_var->s_gnd)  /* use only if printframe function is present */
#define lu      (s_var->s_lu )
#define aff     (s_var->s_aff)  
#define starmat (s_var->s_starmat)
#define id     (s_var->s_id)  
#define taff     (s_var->s_taff)  
#define mauspaw (s_var->s_mauspaw)
#define th0 (s_var->s_th0)
#define th1 (s_var->s_th1)
#define ta0 (s_var->s_ta0)
#define ta1 (s_var->s_ta1)
#define gap (s_var->s_gap)

/* these are used only in console mode      */
int binoc;    /* flag                       */
float nose;   /* to eye distance in console */

/* For diagnostic purposes */
void showaff(){int ii,jj;printf("\n"); for(ii=0; ii<4; ii++){int i=ii*4;
 printf(" %f %f %f %f \n",aff[i],aff[i+1],aff[i+2],aff[i+3]);}
 printf("\t\tlocation");
 for(ii=0;ii<4;ii++)printf(" %d",location[ii]);
 printf("\tdir4");
 for(ii=0;ii<4;ii++)printf(" %d",dir4[ii]);
 printf(" \n");
}
void showtaff(){int ii,jj;printf("\n"); for(ii=0; ii<5; ii++){int i=ii*5;
 printf(" %f %f %f %f %f \n",taff[i],taff[i+1],taff[i+2],taff[i+3],taff[i+4]);}
}
/* JUNE 1999 */
void showAA(){printf("\nActualAxes=%i",ActualAxes);}

void roundaff(){int ii;
 for(ii=0;ii<16;ii++)aff[ii]=ROUND(aff[ii]);
} 
void roundtaff(){int ii;
 for(ii=0;ii<25;ii++)taff[ii]=ROUND(taff[ii]);
} 

/* Updates taff from aff, dir4[3], location[3] */
#define DSUM (dir4[0]+dir4[1]+dir4[2]+dir4[3])
void aff2taff(){
  int ii;
  for(ii=0;ii<4;ii++)taff[3+(5*ii)]=(GLfloat)dir4[ii];/* hidden col */
  taff[20]=aff[12];taff[21]=aff[13];taff[22]=aff[14]; /* location */  
  if(dir4[3]!=0){
    for(ii=0;ii<3;ii++)taff[15+ii]=0;
    taff[0]=aff[0];taff[1]=aff[1];taff[2]=aff[2];      /* direction */
    taff[5]=aff[4];taff[6]=aff[5];taff[7]=aff[6];
    taff[10]=aff[8];taff[11]=aff[9];taff[12]=aff[10];
    taff[23]=dir4[3]*4.0*(ROWS-(2*location[3])-1);}    /* location */
  if(dir4[2]!=0){
    for(ii=0;ii<3;ii++)taff[10+ii]=0;
    taff[0]=aff[0];taff[1]=aff[1];taff[2]=aff[2];      /* direction */
    taff[5]=aff[4];taff[6]=aff[5];taff[7]=aff[6];
    taff[15]=aff[8];taff[16]=aff[9];taff[17]=aff[10];
    taff[23]=dir4[2]*4.0*(ROWS-(2*location[2])-1);}    /* location */
  if(dir4[1]!=0){
    for(ii=0;ii<3;ii++)taff[5+ii]=0;
    taff[0]=aff[0];taff[1]=aff[1];taff[2]=aff[2];      /* direction */
    taff[10]=aff[4];taff[11]=aff[5];taff[12]=aff[6];
    taff[15]=aff[8];taff[16]=aff[9];taff[17]=aff[10];
    taff[23]=dir4[1]*4.0*(ROWS-(2*location[1])-1);}    /* location */
  if(dir4[0]!=0){
    for(ii=0;ii<3;ii++)taff[ii]=0;
    taff[5]=aff[0];taff[6]=aff[1];taff[7]=aff[2];      /* direction */
    taff[10]=aff[4];taff[11]=aff[5];taff[12]=aff[6];
    taff[15]=aff[8];taff[16]=aff[9];taff[17]=aff[10];
    taff[23]=dir4[0]*4.0*(ROWS-(2*location[0])-1);}    /* location */
}
void taff2aff(){
  int ii;
  for(ii=0;ii<4;ii++)dir4[ii]=ROUND(taff[3+(5*ii)]); /* update dir4 too */
  aff[12]=taff[20];aff[13]=taff[21];aff[14]=taff[22];/* location */
  if(dir4[3]!=0){
    aff[0]=taff[0];aff[1]=taff[1];aff[2]=taff[2];      /* direction */
    aff[4]=taff[5];aff[5]=taff[6];aff[6]=taff[7];
    aff[8]=taff[10];aff[9]=taff[11];aff[10]=taff[12];}
  if(dir4[2]!=0){
    aff[0]=taff[0];aff[1]=taff[1];aff[2]=taff[2];      /* direction */
    aff[4]=taff[5];aff[5]=taff[6];aff[6]=taff[7];
    aff[8]=taff[15];aff[9]=taff[16];aff[10]=taff[17];}
  if(dir4[1]!=0){
    aff[0]=taff[0];aff[1]=taff[1];aff[2]=taff[2];      /* direction */
    aff[4]=taff[10];aff[5]=taff[11];aff[6]=taff[12];
    aff[8]=taff[15];aff[9]=taff[16];aff[10]=taff[17];}
  if(dir4[0]!=0){
    aff[0]=taff[5];aff[1]=taff[6];aff[2]=taff[7];      /* direction */
    aff[4]=taff[10];aff[5]=taff[11];aff[6]=taff[12];
    aff[8]=taff[15];aff[9]=taff[16];aff[10]=taff[17];}
}

/* MAY 1999: Cleaned up comments */
/* Rotate around the (fixed) XY,XZ&YZ planar axes */
/* Recall Front is -z, Up is +y, and Right is +x */

void XYrotate(int sgn){GLfloat temp;GLfloat gsgn=(GLfloat)sgn;int ii;
/* Rotate old (sgn)*Other to new Front */
 for(ii=0;ii<5;ii++){
   temp=(-1)*taff[3+(5*ii)];
   taff[3+(5*ii)]=taff[2+(5*ii)]*gsgn;
   taff[2+(5*ii)]=temp*gsgn;}}
void XZrotate(int sgn){GLfloat temp;GLfloat gsgn=(GLfloat)sgn;int ii;
/* Rotate old (sgn)*Other to new Up */
 for(ii=0;ii<5;ii++){
   temp=taff[3+(5*ii)];
   taff[3+(5*ii)]=(-1)*taff[1+(5*ii)]*gsgn;
   taff[1+(5*ii)]=temp*gsgn;}}
void YZrotate(int sgn){GLfloat temp;GLfloat gsgn=(GLfloat)sgn;int ii;
/* if Rotate old (sgn)*Other to new Right */
 for(ii=0;ii<5;ii++){
   temp=taff[3+(5*ii)];
   taff[3+(5*ii)]=(-1)*taff[5*ii]*gsgn;
   taff[5*ii]=temp*gsgn;}}

/* MAY 1999: Created XY,XZ,YZinitRotate */
/* Initialize gradual rotation of 3D slice through 4D space
   with XY,XZ&YZ planar axes fixed */
void XYinitRotate(int sgn){
  if(taff[3+0]!=0){ /*                   Moving Axis: x->? */
    if(taff[2+5]!=0){ /*                              x->y */
      ActualAxes=-1; init_edges(1);
      sign_theta=(sgn)*(taff[3+0])*(-1)*(taff[2+5]);}
    else if(taff[2+10]!=0){ /*                        x->z */
      ActualAxes=-2; init_edges(2);
      sign_theta=(sgn)*(taff[3+0])*(-1)*(taff[2+10]);}
    else{ /* taff[2+15]!=0                            x->w */
      ActualAxes=-3; init_edges(3);
      sign_theta=(sgn)*(taff[3+0])*(-1)*(taff[2+15]);}
  }
  else if(taff[3+5]!=0){ /*              Moving Axis: y->? */
    if(taff[2+0]!=0){ /*                              y->x */
      ActualAxes=1; init_edges(1);
      sign_theta=(sgn)*(taff[3+5])*(-1)*(taff[2+0]);}
    else if(taff[2+10]!=0){ /*                        y->z */
      ActualAxes=-4; init_edges(4);
      sign_theta=(sgn)*(taff[3+5])*(-1)*(taff[2+10]);}
    else{ /* taff[2+15]!=0                            y->w */
      ActualAxes=-5; init_edges(5);
      sign_theta=(sgn)*(taff[3+5])*(-1)*(taff[2+15]);}
  }
  else if(taff[3+10]!=0){ /*             Moving Axis: z->? */
    if(taff[2+0]!=0){ /*                              z->x */
      ActualAxes=2; init_edges(2);
      sign_theta=(sgn)*(taff[3+10])*(-1)*(taff[2+0]);}
    else if(taff[2+5]!=0){ /*                         z->y */
      ActualAxes=4; init_edges(4);
      sign_theta=(sgn)*(taff[3+10])*(-1)*(taff[2+5]);}
    else{ /* taff[2+15]!=0                            z->w */
      ActualAxes=-6; init_edges(6);
      sign_theta=(sgn)*(taff[3+10])*(-1)*(taff[2+15]);}
  }
  else{ /* taff[3+15]!=0                 Moving Axis: w->? */
    if(taff[2+0]!=0){ /*                              w->x */
      ActualAxes=3; init_edges(3);
      sign_theta=(sgn)*(taff[3+15])*(-1)*(taff[2+0]);}
    else if(taff[2+5]!=0){ /*                         w->y */
      ActualAxes=5; init_edges(5);
      sign_theta=(sgn)*(taff[3+15])*(-1)*(taff[2+5]);}
    else{ /* taff[2+10]!=0                            w->z */
      ActualAxes=6; init_edges(6);
      sign_theta=(sgn)*(taff[3+15])*(-1)*(taff[2+10]);}
  }
}/* XYinitRotate */
void XZinitRotate(int sgn){
  if(taff[3+0]!=0){ /*                   Moving Axis: x->? */
    if(taff[1+5]!=0){ /*                              x->y */
      ActualAxes=-1; init_edges(1);
      sign_theta=(sgn)*(taff[3+0])*(taff[1+5]);}
    else if(taff[1+10]!=0){ /*                        x->z */
      ActualAxes=-2; init_edges(2);
      sign_theta=(sgn)*(taff[3+0])*(taff[1+10]);}
    else{ /* taff[1+15]!=0                            x->w */
      ActualAxes=-3; init_edges(3);
      sign_theta=(sgn)*(taff[3+0])*(taff[1+15]);}
  }
  else if(taff[3+5]!=0){ /*              Moving Axis: y->? */
    if(taff[1+0]!=0){ /*                              y->x */
      ActualAxes=1; init_edges(1);
      sign_theta=(sgn)*(taff[3+5])*(taff[1+0]);}
    else if(taff[1+10]!=0){ /*                        y->z */
      ActualAxes=-4; init_edges(4);
      sign_theta=(sgn)*(taff[3+5])*(taff[1+10]);}
    else{ /* taff[1+15]!=0                            y->w */
      ActualAxes=-5; init_edges(5);
      sign_theta=(sgn)*(taff[3+5])*(taff[1+15]);}
  }
  else if(taff[3+10]!=0){ /*             Moving Axis: z->? */
    if(taff[1+0]!=0){ /*                              z->x */
      ActualAxes=2; init_edges(2);
      sign_theta=(sgn)*(taff[3+10])*(taff[1+0]);}
    else if(taff[1+5]!=0){ /*                         z->y */
      ActualAxes=4; init_edges(4);
      sign_theta=(sgn)*(taff[3+10])*(taff[1+5]);}
    else{ /* taff[1+15]!=0                            z->w */
      ActualAxes=-6; init_edges(6);
      sign_theta=(sgn)*(taff[3+10])*(taff[1+15]);}
  }
  else{ /* taff[3+15]!=0                 Moving Axis: w->? */
    if(taff[1+0]!=0){ /*                              w->x */
      ActualAxes=3; init_edges(3);
      sign_theta=(sgn)*(taff[3+15])*(taff[1+0]);}
    else if(taff[1+5]!=0){ /*                         w->y */
      ActualAxes=5; init_edges(5);
      sign_theta=(sgn)*(taff[3+15])*(taff[1+5]);}
    else{ /* taff[1+10]!=0                            w->z */
      ActualAxes=6; init_edges(6);
      sign_theta=(sgn)*(taff[3+15])*(taff[1+10]);}
  }
}/* XZinitRotate */
void YZinitRotate(int sgn){
  if(taff[3+0]!=0){ /*                   Moving Axis: x->? */
    if(taff[0+5]!=0){ /*                              x->y */
      ActualAxes=-1; init_edges(1);
      sign_theta=(sgn)*(taff[3+0])*(taff[0+5]);}
    else if(taff[0+10]!=0){ /*                        x->z */
      ActualAxes=-2; init_edges(2);
      sign_theta=(sgn)*(taff[3+0])*(taff[0+10]);}
    else{ /* taff[0+15]!=0                            x->w */
      ActualAxes=-3; init_edges(3);
      sign_theta=(sgn)*(taff[3+0])*(taff[0+15]);}
  }
  else if(taff[3+5]!=0){ /*              Moving Axis: y->? */
    if(taff[0+0]!=0){ /*                              y->x */
      ActualAxes=1; init_edges(1);
      sign_theta=(sgn)*(taff[3+5])*(taff[0+0]);}
    else if(taff[0+10]!=0){ /*                        y->z */
      ActualAxes=-4; init_edges(4);
      sign_theta=(sgn)*(taff[3+5])*(taff[0+10]);}
    else{ /* taff[0+15]!=0                            y->w */
      ActualAxes=-5; init_edges(5);
      sign_theta=(sgn)*(taff[3+5])*(taff[0+15]);}
  }
  else if(taff[3+10]!=0){ /*             Moving Axis: z->? */
    if(taff[0+0]!=0){ /*                              z->x */
      ActualAxes=2; init_edges(2);
      sign_theta=(sgn)*(taff[3+10])*(taff[0+0]);}
    else if(taff[0+5]!=0){ /*                         z->y */
      ActualAxes=4; init_edges(4);
      sign_theta=(sgn)*(taff[3+10])*(taff[0+5]);}
    else{ /* taff[0+15]!=0                            z->w */
      ActualAxes=-6; init_edges(6);
      sign_theta=(sgn)*(taff[3+10])*(taff[0+15]);}
  }
  else{ /* taff[3+15]!=0                 Moving Axis: w->? */
    if(taff[0+0]!=0){ /*                              w->x */
      ActualAxes=3; init_edges(3);
      sign_theta=(sgn)*(taff[3+15])*(taff[0+0]);}
    else if(taff[0+5]!=0){ /*                         w->y */
      ActualAxes=5; init_edges(5);
      sign_theta=(sgn)*(taff[3+15])*(taff[0+5]);}
    else{ /* taff[0+10]!=0                            w->z */
      ActualAxes=6; init_edges(6);
      sign_theta=(sgn)*(taff[3+15])*(taff[0+10]);}
  }
}/* YZinitRotate */
/* MAY 1999: Created XY,XZ,YZinitRotate */

void getmem(void){
  if(caveyes)
#ifdef CAVE
     s_var = CAVEMalloc(sizeof(struct share_var))
#endif
     ;
   else
     s_var = malloc(sizeof(struct share_var));
  if(s_var==NULL)
    {fprintf(stderr,"No room to share! %x \n",s_var); exit(1);}
}

void char2wall(GLfloat x,GLfloat y, GLfloat z, char buf[]){
     char *p; glRasterPos3f(x,y,z);
     for(p = buf;*p;p++) glutBitmapCharacter(GLUT_BITMAP_9_BY_15,*p);
}

void autotymer(int);  /* to allow deFault to call the autotymer later */

void deFault(void){
  int ii; /*float tmp;*/
  gnd = 0;
  th0=5; th1=355;  dth=15; ta0=5; ta1=355; dta=15; gap = gap0;
  msg=1; binoc=0; nose=.06; mauspaw = 0; wnd = 1; siz = 1.; 
  mode=TURNMODE; if(caveyes)mode=FLYMODE;
  speed=.1; torq=.02; focal = 1.5/1.1/1.1/1.1/1.1/1.1/1.1; mysiz=.01;
  if(rand_maze)Far=13.;else Far=38.; if(demo)morph=1;else morph=0; frozen=0;
  for(ii=0;ii<16;ii++)  starmat[ii]=aff[ii]=id[ii] = (ii/4==ii%4) ? 1 : 0;   
/*  tmp=NRM(lux);  for(ii=0;ii<3;ii++)lux[ii]/=tmp;*/
/*if(caveyes){aff[12]=0; aff[13]= 5; aff[14]= -3;}/*5ft beyond front wall*/ 
/*else{*/
  aff[12]=4*(ROWS1%2); aff[13]=4*(ROWS1%2);      /*inside the console */
  if(in_maze)aff[14]=4*(ROWS1%2);
  else aff[14]= -4*ROWS1; /* move it away */ 
/*}*/
  location[0] = (ROWS1/2)-1;location[1] = trunc(ROWS1/2)-1;
  if(in_maze)location[2] = trunc(ROWS1/2)-1;else location[2]=ROWS;
  location[3] = trunc(ROWS1/2)-1; 
  rotating_in_4D=cube=0;theta=moving=0;
  /* Note: much of the previous stuff is rendered irrelevent by the 
     repositioning that is a part of the next line */
  if(demo)autotymer(1);
  for(ii=0;ii<25;ii++) taff[ii] = (ii/5==ii%5) ? 1 : 0;   
  taff[20]=aff[12];taff[21]=aff[13];taff[22]=aff[14];
  dir4[0]=0;dir4[1]=0;dir4[2]=0;dir4[3]=1;
  /* Cannot update lagmvg=0; because it is local */
}
/*
void drawvert(int th, int ta){  
/* exercise ... float all the angles for a smoother homotopy */ 
/*float lmb,spec,nn[3], dog, cat;
nn[0] = C(th)*C(ta); /* unit sphere vector */  
/*nn[1] = S(th)*C(ta);
nn[2] =       S(ta);
lmb = MAX(CLAMP(nn[0]*lu[0] + nn[1]*lu[1] + nn[2]*lu[2],0.,1.),.3);
spec = MIN(1, 1*(1-10+10*lmb));                    /* clamp spec below maximum       */
/*dog = (ta-ta0)/(float)(ta1-ta0); cat = (th-th0)/(float)(th1-th0);
glColor3f(MAX(lmb*dog,spec),                     /* map R^2(dog,cat)->R^3(RGBspace */
/*          MAX(lmb*(.25 + fabsf(cat -.5)),spec),  /* dog cat model of Hartman       */
/*          MAX(lmb*(1 - cat ),spec));             /* illiLight by Ray Idaszak 1989  */
/*glVertex3f(C(th) + .5*nn[0],S(th) + .5*nn[1],.5*nn[2]);
}

void drawtor(void){
int th, ta;
dth = (int)((th1-th0)/24);  /* 24  meridian strips */ 
/*dta = (int)((ta1-ta0)/24);  /* 24  triangle pairs per strip */
/*for(th=th0; th < th1; th += dth){
  glBegin(GL_TRIANGLE_STRIP);
  for(ta=ta0; ta < ta1; ta += dta){ drawvert(th,ta); drawvert(th+gap*dth,ta); }
  glEnd();
  }
}
*/
void drawcube(void){ /* transfer from skel.c as an exercise  */ }

/* MAY 1999 */
drawstairs(int dir4[4]){
  int ii,jj,kk;
  if(dir4[3]!=0)FOR(ii,0,ROWS)FOR(jj,0,ROWS)FOR(kk,0,ROWS){
    if(xyzfaces[ii][jj][kk][location[3]]==0 && 
       location[3]>=0 && location[3]<ROWS1)
      drawportal(ii,jj,kk,thick,dir4[3]);
    if(xyzfaces[ii][jj][kk][location[3]+1]==0 &&
       location[3]>=-1 && location[3]<ROWS)
      drawportal(ii,jj,kk,thick,(-1)*dir4[3]);
  }
  else if(dir4[2]!=0)FOR(ii,0,ROWS)FOR(jj,0,ROWS)FOR(kk,0,ROWS){
    if(xywfaces[ii][jj][location[2]][kk]==0 && 
       location[2]>=0 && location[2]<ROWS1)
      drawportal(ii,jj,kk,thick,dir4[2]);
    if(xywfaces[ii][jj][location[2]+1][kk]==0 &&
       location[2]>=-1 && location[2]<ROWS)
      drawportal(ii,jj,kk,thick,(-1)*dir4[2]);
  }
  else if(dir4[1]!=0)FOR(ii,0,ROWS)FOR(jj,0,ROWS)FOR(kk,0,ROWS){
    if(xzwfaces[ii][location[1]][jj][kk]==0 && 
       location[1]>=0 && location[1]<ROWS1)
      drawportal(ii,jj,kk,thick,dir4[1]);
    if(xzwfaces[ii][location[1]+1][jj][kk]==0 &&
       location[1]>=-1 && location[1]<ROWS)
      drawportal(ii,jj,kk,thick,(-1)*dir4[1]);
  }
  else /* dir4[0]!=0 */ FOR(ii,0,ROWS)FOR(jj,0,ROWS)FOR(kk,0,ROWS){
    if(yzwfaces[location[0]][ii][jj][kk]==0 && 
       location[0]>=0 && location[0]<ROWS1)
      drawportal(ii,jj,kk,thick,dir4[0]);
    if(yzwfaces[location[0]+1][ii][jj][kk]==0 &&
       location[0]>=-1 && location[0]<ROWS)
      drawportal(ii,jj,kk,thick,(-1)*dir4[0]);
  }
}

/* MAY 1999 */
/* JUNE 1999 */
void drawall(void){static int ss,tt;
 if(rotating_in_4D==0){
   drawmaze(((ROWS-ROUND(DSUM*taff[23]/4.0)-1)/2),Delta,dir4); 
   drawstairs(dir4);   
 }
 else /* rotating_in_4D==1 */ {
  /* JUNE 1999 EDIT
  printf("\n drawall:theta = %f",theta);
  printf("\n drawall:sign_theta = %f",sign_theta);
     JUNE 1999 EDIT */
   if(theta==theta_jump)
     switch(abs(ActualAxes)){
     case 1:ss=location[0];tt=location[1];break;
     case 2:ss=location[0];tt=location[2];break;
     case 3:ss=location[0];tt=location[3];break;
     case 4:ss=location[1];tt=location[2];break;
     case 5:ss=location[1];tt=location[3];break;
     case 6:ss=location[2];tt=location[3];break;
     }
   if(ActualAxes>0)
     draw_intersections(ss,tt,sign_theta*(theta)*DG,abs(ActualAxes),Delta);
   else /* ActualAxes<0 */
     draw_intersections(ss,tt,sign_theta*(90-theta)*DG,abs(ActualAxes),Delta);
 }
}

void drawstars(void){
int i;
static float star[1000][3];
static int virgin=1;
if(virgin){
  int ii,jj;
  float fact;
  virgin=0;
  for(ii=0;ii<1000;ii++)
     {
     for(jj=0;jj<3;jj++) star[ii][jj] =   rand()/(float)0x40000000-1.;
     if(caveyes){
           fact = 90./NRM(star[ii]);
           for(jj=0;jj<3;jj++) star[ii][jj] *= fact;
           }   
     }
  }
  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();
  glMultMatrixf(starmat);
  glColor3f(0.6,0.6,0.3);    
  glBegin(GL_POINTS);
    for(i=0;i<1000;i++) glVertex3fv(star[i]);
  glEnd();
  glPopMatrix();
  glClear(GL_DEPTH_BUFFER_BIT);
}

void audioprep(void){
#ifdef SOUND
   if (!FBgnSoundServer())
      fprintf(stderr,"UDP connection to sound server failed\n");
   else if ((audiohandle = AUDinit("noosh.aud")) == -1)
      fprintf(stderr,"Couldn't open noosh.aud\n");
#endif
}

void dohoot(void) {strcpy(which,"hoot");}
void dotrump(void){strcpy(which,"trump");}
void doflute(void){strcpy(which,"flute");}
void dodrum(void) {strcpy(which,"drum");}

void audiofunc(void){
#ifdef SOUND 
#define LIRP(X,A,B,x,a,b)  (X = A + (x-a)*(B-A)/(b-a))
  static float freq=440., ampl=1., indx=20., cmra=2.; 
  static float data[4];
  static omode =0; static ofocal = 0;
  static beep =0;  /* the sound server */

  if(omode > mode){dohoot(); beep = 1;}
  if(omode < mode){dodrum(); beep = 1;}

  LIRP(freq, 440, 1760, th0,  10, 170); /* frequeny mimics th1 */ 
  LIRP(indx, 10, 1,  focal, .03, 2.0); /* index  mimics focal */ 
  if(ofocal != focal){dodrum(); beep = 1;}    /* there is an fp bug here */

if(beep){data[0] = freq;  /* pitch in Herz      */ 
          data[1] = ampl;  /* the sum of all amplitudes must be < 1.0 */ 
          data[2] = indx;    
          data[3] = cmra;
          AUDupdate(audiohandle, which, 4, data);  /* send message  to vss */ 
          beep = 0; 
}
  omode = mode;  ofocal = focal; 
#endif
}

void audioclean(void){
#ifdef SOUND
   AUDterminate(audiohandle);
   EndSoundServer();
#endif
}

void arguments(int argc,char **argv){
  extern char *optarg;
  extern int optind; 
  int chi;   
/* defaults if not set by command line: */
  rseed=43; XYZchance=.6, XYWchance= .7,  XZWchance=.75 , YZWchance=.6 ;
  thick=2;demo=0;Delta=.15;
  /* w: needs ONE number after -w, c<nothing> means NO number follows*/ 
 /*
  while ((chi = getopt(argc,argv,"w:cg:r:ts:x:y:z:h:odD:")) != -1) 
  switch(chi)  {case 'c': caveyes=1; break;  
                case 'w': win=atoi(optarg); break; 
                case 'g': gap0=atof(optarg); break;
      case 'r': rseed=atoi(optarg); rand_maze=1; break;
      case 't': thick=1; break;   
      case 's': speed=atof(optarg); break;
      case 'x': YZWchance=atof(optarg); break;
      case 'y': XZWchance=atof(optarg); break;
      case 'z': XYWchance=atof(optarg); break;
      case 'h': XYZchance=atof(optarg); break;
      case 'o': in_maze=0; break;
      case 'd': demo=1; break;
      case 'D': Delta=atof(optarg); break;
                }
  if (optind!=argc) {
    fprintf(stderr,"%s: Incorrect usage\n",argv[0]);
    fprintf(stderr,"Usage: %s [-w win] [-t] [-s speed] [-r rseed] [-x probability of red walls]\n  [-y probability of green walls] [-z probability of blue walls]\n  [-h probability of hidden walls] ([-o]) [-d] [-c] [-g ?] [-D Delta]\n",argv[0]);
    /*    exit(-1);    */ /* Why is this in skel but not noosh? */
/*  }
*/
}

void dataprep(void){
   audioprep();
   deFault();
   initvv();  /* initializes the vertices */
   if(rand_maze)makemaze(rseed,XYZchance,XYWchance,XZWchance,YZWchance);
   else setmaze();
   init_colors(); /* MAY 1999 */
}
/* autymer adjusted to prevent user movement and _move_ autmomatically */
void autotymer(int reset){int ii;
/* cnt4D is used for all 4D rotations */
 static int cnt4D=(max_theta_delay*((90/theta_jump)-1))+1;
#define  TYME(cnt,max,act) {static cnt; if(first)cnt=max; else\
                            if(cnt?cnt--:0){ act ; goto Break;}}
#define  HYTHER  TYME( dwell  , 8,  moving= 0)\
  TYME( hither , 1,  moving=10) TYME( dwell  , 8,  moving= 0)
#define THYTHER  TYME( dwell  , 8,  moving= 0)\
  TYME( thither, 1,  moving= 9) TYME( dwell  , 8,  moving= 0)
/* The following is not being used: */
#define PADDEDTYME(cnt,act) TYME( dwell  , 8,  moving= 0)\
  TYME( cnt , 1, act) TYME( dwell  , 8,  moving= 0)

  static first = 1;  /* the first time autymer is called */
  if(reset)first=1;  /* or if it is reset to start over  */
  if(first){moving=0;theta=0;/* moving=0 necessary? */
    location[0]=3;location[1]=2;location[2]=2;location[3]=2;
    for(ii=0;ii<16;ii++)starmat[ii]=aff[ii]=id[ii]=(ii/4==ii%4)?1:0;   
    /* JUNE 1999 edit: 'siz*' will have to be added to the next line */
    aff[12]=4*(ROWS1%2)-8.0;aff[13]=4*(ROWS1%2);aff[14]=4*(ROWS1%2);
    dir4[0]=dir4[1]=dir4[2]=0;dir4[3]=1;aff2taff();}

  /* elevator-only demo follows */

  TYME( forward, 16, moving= 8) 
  TYME( forward, 16, moving= 8)
  TYME( right  , 18, moving= 3)
  TYME( forward, 16, moving= 8)
  TYME( left   , 18, moving= 4)
  TYME( left   , 18, moving= 4)
  HYTHER
  TYME( forward, 16, moving= 8)
  TYME( up     , 18, moving= 5)
  TYME( forward, 16, moving= 8)
  TYME( down   , 18, moving= 6)
  TYME( forward, 16, moving= 8)
  TYME( bankRgt, 18, moving= 1)
  TYME( bankLft, 18, moving= 2)
  TYME( forward, 16, moving= 8)
  TYME( left   , 18, moving= 4)
  TYME( forward, 16, moving= 8)
  HYTHER
  THYTHER
  THYTHER
  TYME( forward, 16, moving= 8)
  TYME( down   , 18, moving= 6)
  TYME( forward, 16, moving= 8)
  TYME( up     , 18, moving= 5)
  TYME( forward, 16, moving= 8)
  TYME( forward, 16, moving= 8)
  TYME( left   , 18, moving= 4)
  TYME( forward, 16, moving= 8)
  THYTHER
  TYME( forward, 16, moving= 8)
  THYTHER
  TYME( down   , 18, moving= 6)
  TYME( up     , 18, moving= 5)
  TYME( forward, 16, moving= 8)
  THYTHER
  TYME( left   , 18, moving= 4)
  TYME( back   , 16, moving= 7)
  HYTHER
  TYME( back   , 16, moving= 7)
  HYTHER
  TYME( back   , 16, moving= 7)
  HYTHER
  HYTHER
  HYTHER
  TYME( forward, 16, moving= 8)
  TYME( forward, 16, moving= 8)
  TYME( forward, 16, moving= 8)
  TYME( forward, 16, moving= 8)
  THYTHER
  THYTHER
  TYME( left   , 18, moving= 4)
  TYME( forward, 16, moving= 8)
  TYME( right  , 18, moving= 3)
  TYME( forward, 16, moving= 8)
  TYME( dwell  , 30, moving= 0)

  /* elevator-less demo follows */
  TYME( FourRotate, cnt4D, moving=11)
  TYME( FourRotate, cnt4D, moving=12)
  TYME( FourRotate, cnt4D, moving=13)
  TYME( FourRotate, cnt4D, moving=14)
  TYME( FourRotate, cnt4D, moving=16)
  TYME( FourRotate, cnt4D, moving=15)
  TYME( dwell  , 10, moving= 0)
  TYME( forward, 16, moving= 8) 
  TYME( forward, 16, moving= 8)
  TYME( right  , 18, moving= 3)
  TYME( forward, 16, moving= 8) 
  TYME( FourRotate, cnt4D, moving=11)
  TYME( right  , 18, moving= 3)
  TYME( forward, 16, moving= 8) 
  TYME( right  , 18, moving= 3)
  TYME( forward, 16, moving= 8) 
  TYME( up     , 18, moving= 5)
  TYME( forward, 16, moving= 8) 
  TYME( down   , 18, moving= 6)
  TYME( forward, 16, moving= 8)
  TYME( forward, 16, moving= 8)
  TYME( FourRotate, cnt4D, moving=11)
  TYME( left   , 18, moving= 4)
  TYME( forward, 16, moving= 8)
  TYME( FourRotate, cnt4D, moving=15)
  TYME( FourRotate, cnt4D, moving=15)
  TYME( FourRotate, cnt4D, moving=15)
  TYME( FourRotate, cnt4D, moving=15)
  TYME( FourRotate, cnt4D, moving=11)
  TYME( forward, 16, moving= 8)
  TYME( left   , 18, moving= 4)
  TYME( forward, 16, moving= 8)
  TYME( down   , 18, moving= 6)
  TYME( forward, 16, moving= 8)
  TYME( right  , 18, moving= 3)
  TYME( bankLft, 18, moving= 2)
  TYME( forward, 16, moving= 8)
  TYME( FourRotate, cnt4D, moving=14)
  TYME( forward, 16, moving= 8)
  TYME( down   , 18, moving= 6)
  TYME( forward, 16, moving= 8)
  TYME( left   , 18, moving= 4)
  TYME( forward, 16, moving= 8)
  TYME( right  , 18, moving= 3)
  TYME( forward, 16, moving= 8)
  TYME( left   , 18, moving= 4)
  TYME( forward, 16, moving= 8)
  TYME( right  , 18, moving= 3)
  TYME( forward, 16, moving= 8)
  TYME( left   , 18, moving= 4)
  TYME( forward, 16, moving= 8)
  TYME( left   , 18, moving= 4)
  TYME( left   , 18, moving= 4)
  TYME( back   , 16, moving= 7)
  TYME( up     , 18, moving= 5)
  TYME( forward, 16, moving= 8)
  TYME( down   , 18, moving= 6)
  TYME( forward, 16, moving= 8)
  TYME( forward, 16, moving= 8)
  TYME( forward, 16, moving= 8)
  TYME( forward, 16, moving= 8)
  TYME( forward, 16, moving= 8)
  TYME( forward, 16, moving= 8)
  TYME( down   , 18, moving= 6)
  TYME( forward, 16, moving= 8)
  TYME( forward, 16, moving= 8)
  TYME( down   , 18, moving= 6)
  TYME( forward, 16, moving= 8)
  TYME( forward, 16, moving= 8)
  TYME( right  , 18, moving= 3)
  TYME( forward, 16, moving= 8)
  TYME( up     , 18, moving= 5)
  TYME( forward, 16, moving= 8)
  TYME( FourRotate, cnt4D, moving=12)
  TYME( bankRgt, 18, moving= 1)
  TYME( dwell  , 30, moving= 0)

  TYME(finish  , 1 , first = 1  )
  first = 0;
  Break:   ;   /* yes Virginia, C has gotos */
}

/*Beware of competing keys in CAVEsimulation and wnd==1   */
/* you may want to remap these keys to avoid the conflict */
void keyboard(unsigned char key, int x, int y){
#define  IF(K)            if(key==K)
#define  PRESS(K,A,b)     IF(K){b;}IF((K-32)){A;}  
/*was backwards in previous versions */
#define  TOGGLE(K,flg)    IF(K){(flg) = 1-(flg); }
#define  CYCLE(K,f,m)     PRESS((K), (f)=(((f)+(m)-1)%(m)),(f)=(++(f)%(m)))
#define  SLIDI(K,f,m,M)   PRESS(K,(--f<m?m:f), (++f>M?M:f))
#define  SLIDF(K,f,m,M,d) PRESS(K,((f -= d)<m?m:f), ((f += d)>M?M:f))
   static int begin_morph=0;
/* Only ASCII characters can be processes by this GLUT callback function */ 
   TOGGLE('v',binoc);                            /* cross-eyed STEREO   */
   TOGGLE('w',msg);                              /* writing on/off      */
   knopf = 0;
   PRESS('e',knopf=-1, knopf=1);
   if(demo==0){
     if(morph==0)begin_morph=1;  /* b_morph was 0 - afterwards, b_morph */
     TOGGLE('h',morph);                            /* autotymer on/off    */
     if(morph==0)begin_morph=0;  /* set to 1 if morph has been switched on  */
     if(begin_morph){autotymer(1); begin_morph=0;}}
   else IF('h'){rotating_in_4D=0;moving=0;theta=0;autotymer(1);}
   TOGGLE('f',frozen);
   PRESS('n', nose -= .001 , nose += .001 );     /* for binoculars      */
   CYCLE(' ', mode,TURNMODE+1);                  /* fly/turn modes      */
   PRESS('i', mysiz /= 1.1, mysiz *= 1.1)        /* rescale the world   */
   PRESS('o', focal *= 1.1 , focal /= 1.1)       /* telephoto           */
   PRESS('p', Far *= 1.01 , Far   /= 1.01)       /* rear clipping plane */
/* PRESS('s',speed /= 1.02, speed *= 1.02);      /* flying speed        */
   PRESS('q',torq /= 1.02, torq *= 1.02);        /* turning speed       */
   PRESS('g',gap /= .99, gap *= .99);             /* gap parameter       */
   PRESS('z', deFault(), deFault());             /* zap changes         */
   PRESS('s', w_shift=10, w_shift=9);            /* move in 4th dimension */
   PRESS('d', if(Delta==0)Delta=.01;else if(Delta<.25)Delta+=.005;else if(Delta<4)Delta *= 1.02; else Delta=4, if(Delta <= .02)Delta=0;else if(Delta<=.25)Delta-=.005;else Delta /= 1.02);
   /*
   PRESS('a',showaff(),showtaff());
   PRESS('r',roundaff(),roundtaff());
   PRESS('t',taff2aff(),aff2taff());
   */
   /* JUNE 1999 edit */
   PRESS('a',showAA(),showAA());   

   IF('1')w_shift=11;/* rotate right towards +hidden */
   IF('!')w_shift=12;/* rotate left towards +hidden */
   IF('2')w_shift=13;/* rotate up towards hidden */
   IF('@')w_shift=14;/* rotate down towards hidden */
   IF('3')w_shift=15;/* rotate forwards towards hidden */
   IF('#')w_shift=16;/* rotate back towards hidden */
   IF(27) {audioclean(); exit(0); }              /* ESC exit            */
}

void special_keybo(int key, int x, int y){
/*non-ASCII keypresses go here, if you're lucky enough to know their names */
  IF(GLUT_KEY_RIGHT)w_shift=11;
  IF(GLUT_KEY_LEFT) w_shift=12;
  IF(GLUT_KEY_UP)   w_shift=13;
  IF(GLUT_KEY_DOWN) w_shift=14;
  IF(GLUT_KEY_PAGE_UP) w_shift=15;
  IF(GLUT_KEY_PAGE_DOWN)w_shift=16;
//  IF(GLUT_KEY_F1)
//  IF(GLUT_KEY_END)
}



/* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */
#ifdef CAVE
/* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */

void cavekeybo(void){
#define  CAVEIF(K)         if(CAVEgetbutton(K))
#define  CAVEPRESS(K,A,b)  CAVEIF(K){if(CAVEgetbutton(CAVE_LEFTSHIFTKEY)||\
                           CAVEgetbutton(CAVE_RIGHTSHIFTKEY)){b;}else{A;}}
#define  CAVETOGGLE(K,flg) CAVEIF(K){(flg) = 1-(flg); }
#define  CAVECYCLE(K,f,m)  CAVEPRESS((K),(f)=(((f)+(m)-1)%(m)),(f)=(++(f)%(m)) )
#define  CAVESLIDI(K,f,m,M)  CAVEPRESS(K,(--f<m?m:f), (++f>M?M:f))
#define  CAVESLIDF(K,f,m,M,d) CAVEPRESS(K,((f -= d)<m?m:f), ((f += d)>M?M:f))
  CAVEPRESS(CAVE_PKEY, Far *= 1.01,   Far   /= 1.01) /* rear clipping plane*/
  CAVEPRESS(CAVE_QKEY, speed /= 1.02, speed *= 1.02);/* flying speed       */
  CAVEPRESS(CAVE_RKEY, torq /= 1.02,  torq *= 1.02); /* turning speed      */
  CAVETOGGLE(CAVE_YKEY,wnd);                         /* mauspaw vs wandpaw */
/* not yet implemented */ 
   CAVEPRESS(CAVE_ZKEY, deFault(), deFault());        /* zap changes       */
}

void graffiti(void){             /* used to be called speedo  */
  char buf[256];                 /*messages written into here */ 
#define  LABEL3(x,y,z,W,u){sprintf(buf,(W),(u));char2wall(x,y,z,buf);}
  static float last=0.,fps;      /*for measuring time         */ 
  if(!CAVEMasterDisplay()) return;  /* USE CAVEMasterWall in papeBeta */
  if(floor(2.*(*CAVETime))>floor(2.*last)){  /* rationalize this */ 
     last=*CAVETime;
     fps=*CAVEFramesPerSecond;
     }
  if(mode==TURNMODE)glColor3f(1.,0.,1.);
  else glColor3f(1.,1.,0.);
  LABEL3(-3.8,1.,-5.0,\
	 "Hold3=auto Click3=freeze Hold2=tractor 1=mode %s","");
  LABEL3(-3.8,1.5,-5.0,
          "JoyRight=Yellow JoyLeft=Purple JoyAhead/Back=Delta+/-%s","gap");
  
  LABEL3(-4.8,8.0,-5.0, "not illiOpenSkelGLUT\
      by Francis, Bourd, Hartman & Chappell, (C) 1995..1997 U.Illinois %s","")
       LABEL3(-4.8,1.0,-5.0,"%5.1f fps",fps);
}

void cavetrack(void){
  float azi,ele,rol,hx,hy,hz,wx,wy,wz;
  static float ohx,ohy,ohz;   /*old head position */
  static float owx,owy,owz;   /*old wand position */
  static float oazi,oele,orol;   /*old wand orientation */
  static int opaw = 0,paw, joy = 0, friz;
  /* static int theta=0; */
  int ii;
  if(!CAVEMasterDisplay()) return;  /* doit once per frame */
  paw = wnd ? (CAVEBUTTON1*2+CAVEBUTTON2)*2+CAVEBUTTON3 : mauspaw;
  if(paw) joy = 1; /* activate joystick by clicking any button*/
  if(opaw == 4 && paw == 4){
    if(demo==0){morph=1-morph;if(morph)autotymer(1);}/* autotymer on/off  */
    else{moving=0;theta=0;autotymer(1);}}            /* autotymer restart */
  if(opaw == 0 && paw == 4)frozen=1-frozen;
  if(opaw!=0 && paw==1) mode = (mode+1)%(TURNMODE+1); /* click modes */
  /* Hopefully, pulling the joystick back lowers Delta/
     increases the wallsize, and joy right is yellow... */
  /* Eventually should use the varying of the joy.  limits? */
  if(joy&&(CAVE_JOYSTICK_Y>.55)){
    if(Delta==0)Delta=.01; else if(Delta<.25)Delta+=.005;
    else if(Delta<4)Delta *= 1.02; else Delta=4;}
  if(joy&&(CAVE_JOYSTICK_Y<-.55)){
    if(Delta <= .02)Delta=0;else if(Delta<=.25)Delta-=.005;
    else Delta /= 1.02;}
  if(joy&&(CAVE_JOYSTICK_X>.44))w_shift=10;
  if(joy&&(CAVE_JOYSTICK_X>.44))w_shift=9;  /* joystick */
  if(paw == 7){ /* restart, the most useful feature */
    deFault(); ohx=ohy=ohz=0; owx=owy=owz=0;} 
  if(wnd){ 
      CAVEGetWandOrientation(azi,ele,rol);
      CAVEGetHead(hx,hy,hz);  /*position*/
      CAVEGetWand(wx,wy,wz);  /*position*/ 
      }
   else{  /* fix this for CAVE mouse flying */ 
      azi = .5*512; ele = .5*-512;
      } 
  if(opaw!=2 && paw==2){
    oazi=azi;oele=ele;orol=rol;owz=wz;
  }
   glMatrixMode(GL_MODELVIEW); glPushMatrix(); glLoadIdentity();

   glTranslatef(ohx-hx,ohy-hy,ohz-hz); 

   if(!frozen){
     if(morph)autotymer(0); /* advance autotymer */
     if(mode==TURNMODE) glTranslatef(aff[12],aff[13],aff[14]);
     switch(moving){
     case 0 : if(morph)break;/* only used when autotymer has first=1 */
       if((ele-oele)>20 && ABS(azi-oazi)<20)moving=6;
       else if((ele-oele)<-20 && ABS(azi-oazi)<20)moving=5;
       else if(ABS(azi-oazi)>=20 && (azi-oazi)>ABS(rol-orol))moving=3;
       else if(ABS(azi-oazi)>=20 && (azi-oazi)<-ABS(rol-orol))moving=4;
       else if((rol-orol)>=20)moving=1;
       else if((orol-rol)>=20)moving=2;
       else if((wz-owz)<-2)moving=7;
       else if((wz-owz)>2)moving=8;
       if(paw!=2)moving=0;    /* Only make a move if holding button 2 */
       if(w_shift!=0)moving=w_shift;
       /* collision check: */
       /*
       {int may_go=1;int dirx=(-1)*ROUND(aff[2]);
       int diry=(-1)*ROUND(aff[6]);int dirz=(-1)*ROUND(aff[10]);
       if(moving==7 && location[3]>=0 && location[3]<ROWS){
	 if(dirx!=0 && location[1]<ROWS && location[1]>=0 && 
	    location[2]<ROWS && location[2]>=0)
	   if((dirx>0 && location[0]<ROWS1 && location[0]>=0) || 
	      (dirx<0 && location[0]<ROWS && location[0]>=-1))
	     if(yzwfaces[location[0]+(1-dirx)/2][location[1]][location[2]][location[3]])
	       may_go=0;
	 if(diry!=0 && location[0]<ROWS && location[0]>=0 && 
	    location[2]<ROWS && location[2]>=0)
	   if((diry>0 && location[1]<ROWS1 && location[1]>=0) || 
	      (diry<0 && location[1]<ROWS && location[1]>=-1))
	     if(xzwfaces[location[0]][location[1]+(1-diry)/2][location[2]][location[3]])
	       may_go=0;
	 if(dirz!=0 && location[0]<ROWS && location[0]>=0 && 
	    location[1]<ROWS && location[1]>=0)
	   if((dirz>0 && location[2]<ROWS1 && location[2]>=0) || 
	      (dirz<0 && location[2]<ROWS && location[2]>=-1))
	     if(xywfaces[location[0]][location[1]][location[2]+(1-dirz)/2][location[3]])
	       may_go=0;}
       if(moving==8 && location[3]>=0 && location[3]<ROWS){
	 if(dirx!=0 && location[1]<ROWS && location[1]>=0 && 
	    location[2]<ROWS && location[2]>=0)
	   if((dirx<0 && location[0]<ROWS1 && location[0]>=0) || 
	      (dirx>0 && location[0]<ROWS && location[0]>=-1))
	     if(yzwfaces[location[0]+(dirx+1)/2][location[1]][location[2]][location[3]])
	       may_go=0;
	 if(diry!=0 && location[0]<ROWS && location[0]>=0 && 
	    location[2]<ROWS && location[2]>=0)
	   if((diry<0 && location[1]<ROWS1 && location[1]>=0) || 
	      (diry>0 && location[1]<ROWS && location[1]>=-1))
	     if(xzwfaces[location[0]][location[1]+(diry+1)/2][location[2]][location[3]])
	       may_go=0;
	 if(dirz!=0 && location[0]<ROWS && location[0]>=0 && 
	    location[1]<ROWS && location[1]>=0)
	   if((dirz<0 && location[2]<ROWS1 && location[2]>=0) || 
	      (dirz>0 && location[2]<ROWS && location[2]>=-1))
	     if(xywfaces[location[0]][location[1]][location[2]+(dirz+1)/2][location[3]])
	       may_go=0;} 
       if(moving==9)
	 if(location[0]<ROWS && location[0]>=0 && location[1]<ROWS && 
	    location[1]>=0 && location[2]<ROWS && location[2]>=0 &&
	    location[3]>=0 && location[3]<ROWS1 &&
	    xyzfaces[location[0]][location[1]][location[2]][location[3]]){
	   may_go=0;w_shift=0;}
       if(moving==10)
	 if(location[0]<ROWS && location[0]>=0 && location[1]<ROWS && 
	    location[1]>=0 && location[2]<ROWS && location[2]>=0 &&
	    location[3]>=-1 && location[3]<ROWS &&
	    xyzfaces[location[0]][location[1]][location[2]][location[3]+1]){
	   may_go=0;w_shift=0;}
       if(may_go==0)moving=0;}
       */
       /* collision check */ 
       break;/* case 0 */
     case 1 : theta+=1;glRotatef(-5,0.,0.,1.);
       if(theta==18){theta=0;moving=0;}break;
     case 2 : theta+=1;glRotatef( 5,0.,0.,1.);
       if(theta==18){theta=0;moving=0;}break;
     case 3 : theta+=1;glRotatef( 5,0.,1.,0.);
       if(theta==18){theta=0;moving=0;}break;
     case 4 : theta+=1;glRotatef(-5,0.,1.,0.);
       if(theta==18){theta=0;moving=0;}break;
     case 5 : theta+=1;glRotatef(-5,1.,0.,0.);
       if(theta==18){theta=0;moving=0;}break;
     case 6 : theta+=1;glRotatef( 5,1.,0.,0.);
       if(theta==18){theta=0;moving=0;}break;
     }/* switch */
     
     if(mode==FLYMODE){
       glPushMatrix();
       glMultMatrixf(starmat);
       glGetFloatv(GL_MODELVIEW_MATRIX,starmat);
       glPopMatrix();
     }
#define  DOT3(M,i) (M[4*i]*M[12]+M[4*i+1]*M[13]+M[4*i+2]*M[14])
     switch(moving){
     case 7 : theta+=1;glTranslatef(0.,0.,-.5);
       if(theta==16){theta=0;moving=0;
       FOR(ii,0,3)location[ii]=((ROWS-ROUND(DOT3(aff,ii)/4.0))-1)/2;}break;
     case 8 : theta+=1;glTranslatef(0.,0., .5);
       if(theta==16){theta=0;moving=0;
       FOR(ii,0,3)location[ii]=((ROWS-ROUND(DOT3(aff,ii)/4.0))-1)/2;}break;
     case 9 : location[3]-=1;moving=0;w_shift=0;break;
     case 10: location[3]+=1;moving=0;w_shift=0;break;
     }/* switch */
/* Maybe in the future will be able to use more wand translate tractor */
     if(mode == TURNMODE) glTranslatef(-aff[12],-aff[13],-aff[14]);
   }/* if(!frozen) */
   glMultMatrixf(aff); 
   glGetFloatv(GL_MODELVIEW_MATRIX,aff);

  {int ii,jj; for(ii=0;ii<3;ii++){ lu[ii]=0; /* calculite */
   for(jj=0;jj<3;jj++) lu[ii] += aff[ii*4+jj]*lux[jj];} }

  glPopMatrix();
  opaw=paw; ohx=hx; ohy=hy; ohz=hz; owx=wx; owy=wy;
  audiofunc();
}

void drawcaveinit(void){   /* kludge? needed why ? */  
   CAVEFar = 1000.;
   glClearColor(0.,0.,0.,0.);
   glClearDepth(1.);
}

void drawcave(void){
  float hx,hy,hz;
  glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
  drawstars();
  graffiti();
  CAVEGetHead(hx,hy,hz);
  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();
  glTranslatef(hx,hy,hz);
  glMultMatrixf(aff);
  glScalef(siz,siz,siz);
  drawall();
  glPopMatrix();
}
#endif



float speedometer(void){
double dbl; static double rate; static int ii=0;
static struct timezone notused; static struct timeval now, then;
   if(++ii % 8 == 0){  /* 8 times around measure time */
      gettimeofday(&now, &notused); /* elapsed time */
      dbl =  (double)(now.tv_sec - then.tv_sec)
         +(double)(now.tv_usec - then.tv_usec)/1000000;
      then = now;  rate = 8/dbl;
      }
   return((float)rate);
}
#if 0 
float speedometer(void){
double dbl; static double rate; static int ii=0;

static struct _timeb lnow, lthen;

   if(++ii % 8 == 0){  /* 8 times around measure time */

	   _ftime(&lnow);
		dbl =  (double)(lnow.time - lthen.time)
			 +(double)(lnow.millitm - lthen.millitm)/1000;
		lthen = lnow;  rate = 8/dbl;
      }

   return((float)rate);
}
#endif 
void messages(void){     
  char buf[256]; /* console messages are done differently from cave */
#define  LABEL2(x,y,W,u) {sprintf(buf,(W),(u));char2wall(x,y,0.,buf);}
  glMatrixMode(GL_PROJECTION); glPushMatrix(); glLoadIdentity();
  gluOrtho2D(0,3000,0,3000);
  glMatrixMode(GL_MODELVIEW); glPushMatrix(); glLoadIdentity();
      /*bull's eye*/
      if(mode==0) glColor3f(0x22/255.,0x88/255.,0xdd/255.);
        else      glColor3f(.8,.8,.8);
      LABEL2(1500,1500,"%s","o");
      /* writings */
      if(mode==0) glColor3f(1.,0.,1.);
        else      glColor3f(1.,1.,0.);
      LABEL2(80,80,"%4.1f fps",speedometer());
      LABEL2(80,2770,"(ESC)ape (Z)ap (V)Binoc%s","");
      LABEL2(10,10,"illiMaze4D \
   by Michael Pelsmajer, U Illinois, 1999 %s","");
      LABEL2(80,2840,"(N)ose   %0.3f",nose);
      LABEL2(80,2700,"(W)riting %s","");   
      LABEL2(80,2630,"near clipper %g", mysiz*focal);
      LABEL2(80,2560,"f(O)cal factor %g",focal);
      LABEL2(80,2490,"my s(I)ze %.2g",mysiz);
      LABEL2(80,2420,"far cli(P)er= %.2g",Far);
      LABEL2(80,2350,"(D)elta %1.3f",Delta);
      if(demo){LABEL2(80,2280,"(H)ypertour %s","");}
      else LABEL2(80,2280,"(h)demo %s","");
      LABEL2(80,2210,"(f)reeze/unfreeze motion%s","");
      LABEL2(80,2140,"hither(S)%s","");
      LABEL2(80,2070,"yonder(s)%s","");
 //     if(mode==FLYMODE){LABEL2(80,2000,"%sWarning: rotate is wack! Use sparingly.","");}
   //   LABEL2(80,1930,"Print 4D (A)ffine matrix or 5D (a)ffine matrix%s","");
      LABEL2(80,1860,"arrows rotate yonder %s","");
      {sprintf(buf,"             location %d %d %d %d",location[0],location[1],
	       location[2],location[3]);char2wall(300,80,0.,buf);}
      glPopMatrix();
glMatrixMode(GL_PROJECTION); glPopMatrix();
} 

void chaptrack(int but,int xx,int yy,int shif){  
  /* JUNE 1999: theta_delay to slow down 4D rotation */
  static int theta_delay=0;
  /* MAY 1999: commented it out: */
  /* static int theta=0; */
   static int lagmvg=0;/* moving, but slightly delayed updates */
   /* for conversion/rounding of taff/aff towards end of chaptrack */
   long dx,dy; 
   dx = xx -.5*xt; dy = yy -.5*yt; 
   glMatrixMode(GL_MODELVIEW); glPushMatrix(); glLoadIdentity();
   if(mode==FLYMODE) glTranslatef(aff[12],aff[13],aff[14]);
   switch(moving){
   case 0 : if(morph)break;/* only used when autotymer has first=1 */
     if(but==4)moving=1;   /* rolls left */
     if(but==1)moving=2;   /* rolls right */
     if(dx>90 && dx>ABS(dy))moving=3;else if(dx<-90 && -1*dx>ABS(dy))moving=4;
     else if(dy>90)moving=6;else if(dy<-90)moving=5; /* yawing */
/*
     else if(but==5)moving=8-shif;   later for guarantee ?
*/
     if(w_shift!=0)moving=w_shift;
     if(but&(1<<GLUT_MIDDLE_BUTTON))moving=8-shif;
     {/* collision check */
       int may_go=1;int dirx=(-1)*ROUND(aff[2]);
       int diry=(-1)*ROUND(aff[6]);int dirz=(-1)*ROUND(aff[10]);
       int relloc[4];/* location relative to aff */
       /* The immediate following adjustments to dirx,etc is an expirement */
       if(dir4[0]!=0){relloc[3]=location[0];relloc[0]=location[1];
        relloc[1]=location[2];relloc[2]=location[3];}
       if(dir4[1]!=0){relloc[3]=location[1];relloc[0]=location[0];
        relloc[1]=location[2];relloc[2]=location[3];}
       if(dir4[2]!=0){relloc[3]=location[2];relloc[0]=location[0];
        relloc[1]=location[1];relloc[2]=location[3];}
       if(dir4[3]!=0){relloc[3]=location[3];relloc[0]=location[0];
        relloc[1]=location[1];relloc[2]=location[2];}
       if(moving==7 && relloc[3]>=0 && relloc[3]<ROWS){
	 if(dirx!=0 && relloc[1]<ROWS && relloc[1]>=0 && 
	    relloc[2]<ROWS && relloc[2]>=0)
	   if((dirx>0 && relloc[0]<ROWS1 && relloc[0]>=0) || 
	      (dirx<0 && relloc[0]<ROWS && relloc[0]>=-1))
	     if(dir4[0]==0)
	       {if(yzwfaces[location[0]+(1-dirx)/2][location[1]][location[2]][location[3]])
		 may_go=0;}
	     else if(xzwfaces[location[0]][location[1]+(1-dirx)/2][location[2]][location[3]])
	       may_go=0;
	 if(diry!=0 && relloc[0]<ROWS && relloc[0]>=0 && 
	    relloc[2]<ROWS && relloc[2]>=0)
	   if((diry>0 && relloc[1]<ROWS1 && relloc[1]>=0) || 
	      (diry<0 && relloc[1]<ROWS && relloc[1]>=-1))
	     if(dir4[0]==0 && dir4[1]==0)
	       {if(xzwfaces[location[0]][location[1]+(1-diry)/2][location[2]][location[3]])
		 may_go=0;}
	     else if(xywfaces[location[0]][location[1]][location[2]+(1-diry)/2][location[3]])
	       may_go=0;
	 if(dirz!=0 && relloc[0]<ROWS && relloc[0]>=0 && 
	    relloc[1]<ROWS && relloc[1]>=0)
	   if((dirz>0 && relloc[2]<ROWS1 && relloc[2]>=0) || 
	      (dirz<0 && relloc[2]<ROWS && relloc[2]>=-1))
	     if(dir4[3]!=0){
	       if(xywfaces[location[0]][location[1]][location[2]+(1-dirz)/2][location[3]])
		 may_go=0;}
	     else if(xyzfaces[location[0]][location[1]][location[2]][location[3]+(1-dirz)/2])
	       may_go=0;
       }
       if(moving==8 && relloc[3]>=0 && relloc[3]<ROWS){
	 if(dirx!=0 && relloc[1]<ROWS && relloc[1]>=0 && 
	    relloc[2]<ROWS && relloc[2]>=0)
	   if((dirx<0 && relloc[0]<ROWS1 && relloc[0]>=0) || 
	      (dirx>0 && relloc[0]<ROWS && relloc[0]>=-1))
	     if(dir4[0]==0)
	       {if(yzwfaces[location[0]+(dirx+1)/2][location[1]][location[2]][location[3]])
		 may_go=0;}
	     else if(xzwfaces[location[0]][location[1]+(dirx+1)/2][location[2]][location[3]])
	       may_go=0;
	 if(diry!=0 && relloc[0]<ROWS && relloc[0]>=0 && 
	    relloc[2]<ROWS && relloc[2]>=0)
	   if((diry<0 && relloc[1]<ROWS1 && relloc[1]>=0) || 
	      (diry>0 && relloc[1]<ROWS && relloc[1]>=-1))
	     if(dir4[0]==0 && dir4[1]==0)
	       {if(xzwfaces[location[0]][location[1]+(diry+1)/2][location[2]][location[3]])
		 may_go=0;}
	     else if(xywfaces[location[0]][location[1]][location[2]+(diry+1)/2][location[3]])
	       may_go=0;
	 if(dirz!=0 && relloc[0]<ROWS && relloc[0]>=0 && 
	    relloc[1]<ROWS && relloc[1]>=0)
	   if((dirz<0 && relloc[2]<ROWS1 && relloc[2]>=0) || 
	      (dirz>0 && relloc[2]<ROWS && relloc[2]>=-1))
	     if(dir4[3]!=0){
	       if(xywfaces[location[0]][location[1]][location[2]+(dirz+1)/2][location[3]])
		 may_go=0;}
	     else if(xyzfaces[location[0]][location[1]][location[2]][location[3]+(dirz+1)/2])
	       may_go=0;} 
       if(moving==9 || moving==10)
	 if(0<=relloc[0] && relloc[0]<ROWS &&
	    0<=relloc[1] && relloc[1]<ROWS &&
	    0<=relloc[2] && relloc[2]<ROWS){
	   if(dir4[0]!=0){
	     if((moving==9 && dir4[0]==1)||(moving==10 && dir4[0]==-1)){
	       if(0<=relloc[3] && relloc[3]<ROWS1)
		 if(yzwfaces[location[0]][location[1]][location[2]][location[3]])
		   {may_go=0;w_shift=0;} }
	     else 
	       if(-1<=relloc[3] && relloc[3]<ROWS)
		 if(yzwfaces[location[0]+1][location[1]][location[2]][location[3]])
		   {may_go=0;w_shift=0;} }
	   else if(dir4[1]!=0){
	     if((moving==9 && dir4[1]==1)||(moving==10 && dir4[1]==-1)){
	       if(0<=relloc[3] && relloc[3]<ROWS1)
		 if(xzwfaces[location[0]][location[1]][location[2]][location[3]])
		   {may_go=0;w_shift=0;} }
	     else 
	       if(-1<=relloc[3] && relloc[3]<ROWS)
		 if(xzwfaces[location[0]][location[1]+1][location[2]][location[3]])
		   {may_go=0;w_shift=0;} }
	   else if(dir4[2]!=0){
	     if((moving==9 && dir4[2]==1)||(moving==10 && dir4[2]==-1)){
	       if(0<=relloc[3] && relloc[3]<ROWS1)
		 if(xywfaces[location[0]][location[1]][location[2]][location[3]])
		   {may_go=0;w_shift=0;} }
	     else 
	       if(-1<=relloc[3] && relloc[3]<ROWS)
		 if(xywfaces[location[0]][location[1]][location[2]+1][location[3]])
		   {may_go=0;w_shift=0;} }
	   else /* dir4[3]!=0 */{
	     if((moving==9 && dir4[3]==1)||(moving==10 && dir4[3]==-1)){
	       if(0<=relloc[3] && relloc[3]<ROWS1)
		 if(xyzfaces[location[0]][location[1]][location[2]][location[3]])
		   {may_go=0;w_shift=0;} }
	     else 
	       if(-1<=relloc[3] && relloc[3]<ROWS)
		 if(xyzfaces[location[0]][location[1]][location[2]][location[3]+1])
		   {may_go=0;w_shift=0;} }
	 }/* w-shift collsion checked */
       if(may_go==0)moving=0;}/* collision check */
     lagmvg=moving;/* This needed to be in cases 9 and 10      */
     /*               Perhaps should be in all cases somewhere */
     break;/* case 0 */
   case 1 : lagmvg=1;theta+=1;glRotatef(-5,0.,0.,1.);
     if(theta==18){theta=0;moving=0;}break;
   case 2 : lagmvg=2;theta+=1;glRotatef( 5,0.,0.,1.);
     if(theta==18){theta=0;moving=0;}break;
   case 3 : lagmvg=3;theta+=1;glRotatef( 5,0.,1.,0.);
     if(theta==18){theta=0;moving=0;}break;
   case 4 : lagmvg=4;theta+=1;glRotatef(-5,0.,1.,0.);
     if(theta==18){theta=0;moving=0;}break;
   case 5 : lagmvg=5;theta+=1;glRotatef(-5,1.,0.,0.);
     if(theta==18){theta=0;moving=0;}break;
   case 6 : lagmvg=6;theta+=1;glRotatef( 5,1.,0.,0.);
     if(theta==18){theta=0;moving=0;}break;
/* MAY 1999: cases 11-16 redone */
   case 11: lagmvg=11;
     if(theta==0){
       rotating_in_4D=1; YZinitRotate(1);
       if(ActualAxes<0)YZrotate(1);}
     if(theta_delay==0)theta+=theta_jump;
     theta_delay+=1;
     if(theta_delay==max_theta_delay)theta_delay=0;
     if(theta==90){
       theta_delay=0;
       theta=0;moving=0;w_shift=0;rotating_in_4D=0;
       if(ActualAxes>0)YZrotate(1);}
     break;
   case 12: lagmvg=12;
     if(theta==0){
       rotating_in_4D=1; YZinitRotate(-1);
       if(ActualAxes<0)YZrotate(-1);}
     if(theta_delay==0)theta+=theta_jump;
     theta_delay+=1;
     if(theta_delay==max_theta_delay)theta_delay=0;
     if(theta==90){
       theta_delay=0;
       theta=0;moving=0;w_shift=0;rotating_in_4D=0;
       if(ActualAxes>0)YZrotate(-1);}
     break;
   case 13: lagmvg=13;
     if(theta==0){
       rotating_in_4D=1; XZinitRotate(1);
       if(ActualAxes<0)XZrotate(1);}
     if(theta_delay==0)theta+=theta_jump;
     theta_delay+=1;
     if(theta_delay==max_theta_delay)theta_delay=0;
     if(theta==90){
       theta_delay=0;
       theta=0;moving=0;w_shift=0;rotating_in_4D=0;
       if(ActualAxes>0)XZrotate(1);}
     break;
   case 14: lagmvg=14;
     if(theta==0){
       rotating_in_4D=1; XZinitRotate(-1);
       if(ActualAxes<0)XZrotate(-1);}
     if(theta_delay==0)theta+=theta_jump;
     theta_delay+=1;
     if(theta_delay==max_theta_delay)theta_delay=0;
     if(theta==90){
       theta_delay=0;
       theta=0;moving=0;w_shift=0;rotating_in_4D=0;
       if(ActualAxes>0)XZrotate(-1);}
     break;
   case 15: lagmvg=15;
     if(theta==0){
       rotating_in_4D=1; XYinitRotate(1);
       if(ActualAxes<0)XYrotate(1);}
     if(theta_delay==0)theta+=theta_jump;
     theta_delay+=1;
     if(theta_delay==max_theta_delay)theta_delay=0;
     if(theta==90){
       theta_delay=0;
       theta=0;moving=0;w_shift=0;rotating_in_4D=0;
       if(ActualAxes>0)XYrotate(1);}
     break;
   case 16: lagmvg=16;
     if(theta==0){
       rotating_in_4D=1; XYinitRotate(-1);
       if(ActualAxes<0)XYrotate(-1);}
     if(theta_delay==0)theta+=theta_jump;
     theta_delay+=1;
     if(theta_delay==max_theta_delay)theta_delay=0;
     if(theta==90){
       theta_delay=0;
       theta=0;moving=0;w_shift=0;rotating_in_4D=0;
       if(ActualAxes>0)XYrotate(-1);}
     break;
/* MAY 1999: cases 11-16 redone */
   }/* switch */

   if(mode==TURNMODE){
      glPushMatrix();
      glMultMatrixf(starmat);
      glGetFloatv(GL_MODELVIEW_MATRIX,starmat);
      glPopMatrix();
   }
#define  DOT3(M,i) (M[4*i]*M[12]+M[4*i+1]*M[13]+M[4*i+2]*M[14])
   switch(moving){
   case 7 : lagmvg=7;theta+=1;glTranslatef(0.,0.,-.5);if(theta==16){
     theta=0;moving=0;
     /* update location */ /* Can't be updating location as normal! */
     /*
     if(dir4[3]!=0)
       FOR(ii,0,3)location[ii]=((ROWS-ROUND(DOT3(aff,ii)/4.0))-1)/2;
     if(dir4[2]!=0){
       if(aff[2]!=0)location[0]=(ROWS-1-ROUND(aff[2]*aff[14]/4.0))/2;
       else if(aff[6]!=0)location[1]=aff[6]*aff[14];
       else location[3]=aff[10]*aff[14];}
     else if(dir4[1]!=0){
       if(aff[2]!=0)location[0]=aff[2]*aff[14];
       else if(aff[6]!=0)location[2]=aff[6]*aff[14];
       else location[3]=aff[10]*aff[14];}
     else{
       if(aff[2]!=0)location[1]=aff[2]*aff[14];
       else if(aff[6]!=0)location[2]=aff[6]*aff[14];
       else location[3]=aff[10]*aff[14];}
   */
     if(dir4[3]!=0){
       if(aff[2]!=0)location[0]+=(int)aff[2];
       else if(aff[6]!=0)location[1]+=(int)aff[6];
       else location[2]+=(int)aff[10];}
     else if(dir4[2]!=0){
       if(aff[2]!=0)location[0]+=(int)aff[2];
       else if(aff[6]!=0)location[1]+=(int)aff[6];
       else location[3]+=(int)aff[10];}
     else if(dir4[1]!=0){
       if(aff[2]!=0)location[0]+=(int)aff[2];
       else if(aff[6]!=0)location[2]+=(int)aff[6];
       else location[3]+=(int)aff[10];}
     else /*dir4[1]!=0*/{
       if(aff[2]!=0)location[1]+=(int)aff[2];
       else if(aff[6]!=0)location[2]+=(int)aff[6];
       else location[3]+=(int)aff[10];}
   }break;
   case 8 : lagmvg=8;theta+=1;glTranslatef(0.,0., .5);if(theta==16){
     theta=0;moving=0;
     /* update location */
     if(dir4[3]!=0){
       if(aff[2]!=0)location[0]-=(int)aff[2];
       else if(aff[6]!=0)location[1]-=(int)aff[6];
       else location[2]-=(int)aff[10];}
     else if(dir4[2]!=0){
       if(aff[2]!=0)location[0]-=(int)aff[2];
       else if(aff[6]!=0)location[1]-=(int)aff[6];
       else location[3]-=(int)aff[10];}
     else if(dir4[1]!=0){
       if(aff[2]!=0)location[0]-=(int)aff[2];
       else if(aff[6]!=0)location[2]-=(int)aff[6];
       else location[3]-=(int)aff[10];}
     else /*dir4[1]!=0*/{
       if(aff[2]!=0)location[1]-=(int)aff[2];
       else if(aff[6]!=0)location[2]-=(int)aff[6];
       else location[3]-=(int)aff[10];}
     /* FOR(ii,0,3)location[ii]=((ROWS-ROUND(DOT3(aff,ii)/4.0))-1)/2;*/
   }break;
   case 9 : 
     lagmvg=9;
     if(dir4[3]!=0)location[3]-=dir4[3];
     else if(dir4[2]!=0)location[2]-=dir4[2];
     else if(dir4[1]!=0)location[1]-=dir4[1];
     else location[0]-=dir4[0];moving=0;w_shift=0;break;
   case 10: 
     lagmvg=10;
     if(dir4[3]!=0)location[3]+=dir4[3];
     else if(dir4[2]!=0)location[2]+=dir4[2];
     else if(dir4[1]!=0)location[1]+=dir4[1];
     else location[0]+=dir4[0];moving=0;w_shift=0;break;
   }/* switch */
   if(mode==FLYMODE) glTranslatef(-aff[12],-aff[13],-aff[14]);
   glMultMatrixf(aff); 
   glGetFloatv(GL_MODELVIEW_MATRIX,aff);
   {int ii,jj; for(ii=0;ii<3;ii++){ lu[ii]=0; /* calculite */
   for(jj=0;jj<3;jj++) lu[ii] += aff[ii*4+jj]*lux[jj];}}
   glPopMatrix();

   if(lagmvg!=moving && lagmvg!=0){
     if(lagmvg<9){ /* 3D rotation or movement*/
       /*
       if(lagmvg<7)printf("\nrotated in 3D:");
       else printf("\nmoved in 3D:");
       */
       /*
       showaff();roundaff();showaff();aff2taff();showtaff();}
       */
       roundaff();aff2taff();}
     else if(lagmvg<11){ /* 4D movement */
       /*printf("\nmoved in 4D:");*/
       /*
       showaff();showtaff();aff2taff();showtaff();}
       */
       aff2taff();}
     else{ /* 4D rotation */
       /*printf("\nrotated in 4D:");*/
       /*
       showtaff();roundtaff();showtaff();taff2aff();showaff();}
       */
       roundtaff();taff2aff();}
   }
   /* JUNE 1999 */
   /* To make ActualAxes<0 cases work, too */
   if(moving>10){roundtaff();taff2aff();}
}

void reshaped(int xx, int yy){xt=xx ; yt=yy;}   /* what is this for ? */

void drawcons(void){  
  glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
  if(binoc) glViewport(0,yt/4,xt/2,yt/2);
  glMatrixMode(GL_PROJECTION); glLoadIdentity();
  glFrustum(-mysiz*xt/yt,mysiz*xt/yt,-mysiz,mysiz,mysiz*focal,Far); 
  glMatrixMode(GL_MODELVIEW); glLoadIdentity();
  drawstars();
  glTranslatef(-binoc*nose,0.0,0.0);
  glMultMatrixf(aff);
  drawall();
  if(binoc){
    glViewport(xt/2,yt/4,xt/2,yt/2); 
    glMatrixMode(GL_MODELVIEW);
    glLoadIdentity();
    drawstars();
    glTranslatef(binoc*nose,0.0,0.0);
    glMultMatrixf(aff);
    drawall();
    }
  glViewport(0,0,xt,yt);
  if(msg) messages();
  glutSwapBuffers();
}

void idle(void){ /*do this when nothing else is happening*/
if(frozen==0){
  if(morph)autotymer(0);  /* advance autotymer */ 
  glutPostRedisplay();  /*redraw the window*/
  chaptrack(BUT,XX,YY,SHIF);
  audiofunc();} 
}

void mousepushed(int but,int stat,int x,int y){
  if(stat==GLUT_DOWN) BUT |= (1<<but);
  else BUT &= (-1 ^ (1<<but));  
  XX=x; YY=y; SHIF=(glutGetModifiers()==GLUT_ACTIVE_SHIFT)?1:0;
}

void mousemoved(int x,int y){  XX=x; YY=y; }

int  main(int argc, char **argv){  
   arguments(argc,argv); 
   if(caveyes)
#ifdef CAVE
       CAVEConfigure(&argc, argv, NULL)
#endif
       ;
   getmem();
   dataprep();
 
   if(caveyes){
#ifdef CAVE
       CAVEInit(); /* Each wall is (part of) a forked process from here on.*/ 
       CAVEFrameFunction(cavetrack,0);  
       /*is restricted to MasterWall, so once per frame */
       CAVEInitApplication(drawcaveinit, 0); 
       CAVEDisplay(drawcave, 0);
       while(!CAVEgetbutton(CAVE_ESCKEY))
         {
         cavekeybo();  /* is asynchronous from display processes */ 
	 }
       audioclean();
       CAVEExit();
#endif
       ;}
     else{ /*console main*/
       glutInit(&argc, argv);
       glutInitDisplayMode(GLUT_DOUBLE|GLUT_DEPTH);
       switch(win)
         { case 0: break;
           case 1: glutInitWindowSize(640, 480);
                   glutInitWindowPosition(0,1024-480);
                   break;
           case 2: glutInitWindowPosition(0,0);
	           break;
         }
       glutCreateWindow("<* illiSkel in C/OpenGL/GLUT *>");
       if(win==2) glutFullScreen();
       glEnable(GL_DEPTH_TEST);
       glutDisplayFunc(drawcons);       
       glutKeyboardFunc(keyboard);
       glutSpecialFunc(special_keybo);
       glutMouseFunc(mousepushed);
       glutMotionFunc(mousemoved);       
       glutPassiveMotionFunc(mousemoved); 
       glutReshapeFunc(reshaped);
       glutIdleFunc(idle);             
       glutMainLoop();
       }
} 
