/****************************************************************/
/* Cleaning up code for "distribution"                          */
/****************************************************************/
/* Added the ability to append curves to an existing developmnet*/
/*    and to scale the number of points in the curve.           */
/****************************************************************/
/* Added the ablility to open devel curves that have any number */
/*    of control points.                                        */
/****************************************************************/
/* Binocular view reinstalled.  Program was tested in win32     */
/****************************************************************/
/* Adding multiple chasePlanes                                  */
/****************************************************************/
/* Now the develompent can be used to compute both the bishop   */
/*    and frenet framings and curves                            */
/****************************************************************/
/* Added the shuttle to the devel so you can track location     */
/****************************************************************/
/* I can now open and save development curves from/to files     */
/****************************************************************/
/* Color-coding the developmnts and putting them on a curve     */
/****************************************************************/
/* Fixed  the keyboard/messages legacy stuff, (ie, getting rid  */
/*   of the junk)                                               */
/****************************************************************/
/* Added the ability to scale the orthoVolume that the slate    */
/*   looks at.  It is temporarily changed with 'x'              */
/****************************************************************/
/* I am seperating the lissajou and the curve defined by the    */
/*   development cuves into distinct things that can be drawn   */
/*   seperatly or, more directly, simultaneously.               */
/****************************************************************/
/* this code still has sinf cosf gettimeoday and squrtf see skel*/
/****************************************************************/
/* gkf 12jul window ready: don't forget to #define IRIX */
/* gkf alloca problem */
/****************************************************************/
/****************************************************************/
/* fixed drwdevelopment points problem: WHEN YOU DEFINE A CONST */
/*   TO BE A MULTIPLE OF A DIFFERENT CONSTANT, USE PARENTHESIS! */
/* fixed dragtrak to the click twice method                     */
/* Fixed the "facing the wrong way" problem: it was due to OGL's*/
/*   desire to look in the -z direction vs. Math's desire to    */
/*   look in the +z direction.                                  */
/* Fixed "Memory leak" of development arrays.                   */
/****************************************************************/
/* Everything for both development curves is now a distinct set.*/
/*   If it pertains to the first development curve it has a 1   */
/*   suffixed to it.  Likewise devel. 2 things have a 2 suffixed*/
/*   Each control point now has 2 names, the first tells it's   */
/*   development curve, the second its ID.  pCubeId has thus    */
/*   become pickedcube[2], where pickedcube[0] is the develop.  */
/*   and pickedcube[1] is the ID.  I changed the name per GKF   */
/****************************************************************/
/* I am now drawing the 2 development curves in a single        */
/*   viewport.  Both development curves exist, and I can pick   */
/*   both of them.                                              */
/****************************************************************/
/* moved slate stuff from drawconts to its own function,        */
/*     called drawslate                                         */
/****************************************************************/
/* Splining works beautifuly now.  I also fixed viewfro to      */
/*    correct the off-center origin problem.                    */ 
/****************************************************************/
/* Picking works now and controls f(t)                          */
/****************************************************************/
/* Bishop reborn -- I am overhauling the bishop coaster per the */
/*   request of GKF.  I plan to fix any problems I find  and    */
/*   set right what was wrong previously.  The goal is          */
/*   readability and reuseabilty.  ~baf 13jul02 im2002          */
/****************************************************************/
/* latest features of bishopCoaster -> 25 jul 01, 11:20pm  ~bf  */
/*   the car is a shuttle                                       */
/*   the shuttle can fly either FRENET XOR BISHOP frames        */
/*   you can (of course) ride the shuttle                       */
/*   you can have Snoopy chase the shuttle riding the other frame*/
/*   if snoopy is there AND you ride, you are snoopy            */
/*   the track is Illini colors if Bishop, RGB if FRENET        */
/*   you can put the shuttle on autopilot, and control speed    */
/*   if not on autopilot, you can step along the track          */
/*   if you are riding, you can drive/fly                       */
/*                                                              */
/****************************************************************/
/****         bishopCoaster by Ben Farmer                    ****/ 
/****         Based on CAVEcoaster by Dalal, which           ****/ 
/****         modifiyied illiCoaster for the CAVE            ****/ 
/****         Stuarts gadgets included !                     ****/   
/****************************************************************/

/****************************************************************/
/* Cross-platform definitions.                                  */
/****************************************************************/
/*#define WIN32*/
#define IRIX
/****************************************************************/
#include <stdlib.h>
#include <stdio.h>
#include <math.h>

// #ifdef IRIX
#include <sys/time.h>           /* for the speedometer */
#include <glut.h>
// #endif

#ifdef WIN32
/* put this into the source code */
#pragma warning (disable:4305)  /* double-to-float  */
#pragma warning (disable:4101)	/* unreferenced local variable */
#pragma warning (disable:4056)	/* overflow in fp constant arithmetic */
#pragma warning (disable:4047)
#pragma warning (disable:4024)
#pragma warning (disable:4133)
#include <sys\timeb.h>          /* for the speedometer */
#include <GL\glut.h>
#define  M_PI  3.1415296
#endif

#define  DTCONS     1           /* how fast autopilot is in console          */ 
#define  DTCAVE     10          /* how fast autopilot is in console          */ 
#define  BIGCAR     0.05        /* how BIG a coaster you want                */
#define  BIGCURF    10.00       /* how BIG a curve  you want                 */
#define  BIGCUBE    40.00       /* how BIG a cube you want                   */
#define  RAILSIZE   .15         /* how wide the railroad ties are            */
#define  CONTROLPTS 23          /* how many control points there are initaly */
#define  NUMBPTS    1000        /* number of points computed                 */
#define  DEVELPTS   (numbpts*2) /* number of development points              */
#define  SPLINELEG  DEVELPTS/(controlpts-3) /* how dense the legs of the spline are */
#define  LONGFLIGHT 500         /* how many contrails we record              */
#define  DGG 2*M_PI/(numbpts+1) /* Degrees?                                  */
#define  SPACE      15          /* how far apart the 2 vehicles are          */
#define  RAILTIE    (numbpts/200)/* how far apart the railties are           */
#define  BUFSIZE    512         /* the size of the pick buffer               */
#define  CUBELET    .15         /* how large the control point cubes are     */
#define  SLATEOFFSET 4.0        /* how far apart the development curves are  */

#define  MAX(x,y)       (((x)<(y))?(y):(x))
#define  MIN(x,y)       (((x)<(y))?(x):(y))
#define  ABS(u)         ((u)<0 ? -(u): (u))
#define  FOR(a,b,c)     for((a)=(b);(a)<(c);(a)++)
#define  DOT(p,q)       ((p)[0]*(q)[0]+(p)[1]*(q)[1]+(p)[2]*(q)[2])
#define  DOT4(p,q)      (DOT(p,q)+((p)[3]*(q)[3]))
#define  NRM(p)         sqrt(DOT((p),(p)))
#define  DG             M_PI/180
#define  S(u)           sin(u*DG)
#define  C(u)           cos(u*DG)
#define SCALE(A, B, C)  C[0]=A[0]*B; C[1]=A[1]*B; C[2]=A[2]*B;
#define MAG(A, B)       B = SQRT(DOT(A,A));
#define SQRT(u)         sqrt(u)
#define VSUB(A, B, C)   C[0]=A[0]-B[0]; C[1]=A[1]-B[1]; C[2]=A[2]-B[2];
#define VADD(A, B, C)   C[0]=A[0]+B[0]; C[1]=A[1]+B[1]; C[2]=A[2]+B[2];
#define CLAMP(x,u,v)    (x<u? u : (x>v ? v: x))
#define CROSS(A, B, C)  C[0]=A[1]*B[2]-A[2]*B[1];\
                        C[1]=A[2]*B[0]-A[0]*B[2];\
                        C[2]=A[0]*B[1]-A[1]*B[0];
#define FLYMODE         (0)
#define TURNMODE        (1) 

/**********Matt Hall's stereo*******/
#define leyeTOP 0
#define leyeBOT 491
#define reyeTOP 532
#define reyeBOT 1023
#define scrWID 1280
#define scrHT 492
#define windLEFT 256
#define ster_rot (-0.4)
/***********************************/

/******* global variables ********/
       /* skel variable */
float gap, gap0=1.;                    /* kludge so that arguments() can set a default gap0 */
float lux[3]={1.,2.,3.};               /* world light direction vector                      */
float luxx[3];                         /* object space  direction vector                    */
float amb, pwr ;                       /* ambient fraction, pseudo-specular power           */
float mysiz,speed, torq, focal, wfar;  /* console navigation variables                      */
int win = 1;                           /* 2 full screen, use 0 for demand sized             */
unsigned int BUT, XX, YY,SHIF;         /* used in chaptrack gluttery                        */ 
int xt,yt;                             /* once was xt,yt,xm,ym for viewportery              */
int mode,morph,msg,binoc;              /* pretty global                                     */
int th0, th1, dth, ta0, ta1, dta;      /* torus parameters                                  */

float t=0, temp2, temp3;               /* we hope                                           */ 
int ii, jj, kk;  float tmp, temp;      /* saves gray hairs later                            */
float aff[16], starmat[16], mat[16];   /* places for the world                              */
float nose;                            /* to eye distance in console                        */
int hasnumber, number, decimal, sign ; /* for Stuart's number parser                        */
float dot1, dot2, dot3;
float tempvec[3];

int showcube;
int dragmode;

       /* bishop variables */
int numbpts;                           /* variable number of points on the curves */
int showplanar;                        /* flag to show planar development curve   */
int mousePosition[3];                  /* the mouse position for picking          */
int friz;                              /* friz is back                            */
int stereomode;                        /* for Matt Hall's stereo                  */

/**********************CAVEISH****************************************/
#include <malloc.h>     /* for the shared vars */

#ifdef CAVE
#include <cave_ogl.h>
#include <cave.macros.h>
#endif  /* CAVE */

int caveyes ;  /* read cave...yes! */

/*Shared memory variables as per Stuart Levy 1994 */
/*********************************************************************/
/* This shared variable structure is for the CAVE.  I truly don't    */
/*    know if I should be sharing everything that I do.  As a general*/
/*    rule, if I need a global variable I put it here. ~baf 31jul02  */
/*********************************************************************/
struct share_var {
   float  s_siz;            /* final scaling factor before projection     */
   int s_wnd;               /* wand or maus flag                          */
   int s_gnd;               /* background color                           */
   float s_luxx[3];         /* current light direction                    */
   int s_mauspaw ;          /* binary for mouse button state              */
   int s_th0 ;              /* since the autotymer changes these          */
   int s_th1 ;              /* they need to be shared                     */
   int s_ta0 ;             
   int s_ta1 ;            
   float s_gap ;
   float  s_aa ;            /* Karan .... document these                  */ 
   float  s_bb ;      
   float  s_cc ;     
   int  s_dtt ;    
   int  s_tt ;    
   GLfloat s_aff[16], s_starmat[16]; /* affine matrices for object, stars */
   GLfloat s_const_aff[16];          /* constant affine matrix            */

   float (*s_frenetcurve)[3];        /* the coords of the curve in space */
   float (*s_bishopcurve)[3];        /* the coords of the curve in space */
   float (*s_curvefrenetframe)[9];   /* the Frennett frame of the curve  */
   float (*s_curvebishopframe)[9];   /* the Bishop frame of the curve    */

   float s_lissajou[NUMBPTS][3];           /* the coords of the liss in space  */
   float s_lissfrenetframe[NUMBPTS][9];    /* the Frennett frame of the curve  */
   float s_lissbishopframe[NUMBPTS][9];    /* the Bishop frame of the curve    */

   /**** trying some better memory mangegment - variable lenght ****/
   float (*s_controlPoints1)[3];
   float (*s_controlPoints2)[3];
   int s_controlpts;
   int s_paramlength;

   float (*s_development1)[2];         /* the 1st development of the function */ 
   float (*s_development2)[2];         /* the 2nd development of the function */ 

   float s_initframe[9];               /* the initial value of the frame */
   float s_initpos[3];                 /* the initial value of the frame */
   int   s_pickedcube[2];              /* which control cube we picked */
   int   s_vertslatescale;             /* the vertical scaling factor of the slate */

   float s_contrail[LONGFLIGHT][16];
   float s_fram[16];
   float s_fram2[16];
   float s_fram3[16];
   float s_fram4[16];
   float s_fram5[16];

       /* flags */
   int s_showframe;        /* flag to show frame                   */
   int s_showlissajou;     /* flag to show lissajou                */
   int s_showchaseplane;   /* flag to show chaseplane              */
   int s_showcontrail;     /* flag to show contrail                */
   int s_showslate;        /* flag to show slate                   */
   int s_cockpit;          /* flag to view from cockpit            */
   int s_showbishop;       /* flag to show the frenet/bishop frame */
   int s_autopilot;        /* flag to turn on autopilot            */
 
} *s_var;
/* HERE */
#define siz       (s_var->s_siz)
#define wnd       (s_var->s_wnd)
#define gnd       (s_var->s_gnd)  /* use only if printframe curve is present */
#define luxx      (s_var->s_luxx)
#define mauspaw   (s_var->s_mauspaw)
#define th0       (s_var->s_th0)
#define th1       (s_var->s_th1)
#define ta0       (s_var->s_ta0)
#define ta1       (s_var->s_ta1)
#define gap       (s_var->s_gap)
#define aa        (s_var->s_aa)
#define bb        (s_var->s_bb)
#define cc        (s_var->s_cc)
#define dtt       (s_var->s_dtt)
#define tt        (s_var->s_tt)
#define aff       (s_var->s_aff)
#define starmat   (s_var->s_starmat)
#define const_aff (s_var->s_const_aff)

#define frenetcurve      (s_var->s_frenetcurve)
#define bishopcurve      (s_var->s_bishopcurve)
#define curvefrenetframe (s_var->s_curvefrenetframe)
#define curvebishopframe (s_var->s_curvebishopframe)
#define lissajou         (s_var->s_lissajou)
#define lissfrenetframe  (s_var->s_lissfrenetframe)
#define lissbishopframe  (s_var->s_lissbishopframe)
#define controlPoints1   (s_var->s_controlPoints1)
#define controlPoints2   (s_var->s_controlPoints2)
#define controlpts       (s_var->s_controlpts)
#define paramlength      (s_var->s_paramlength)
#define development1     (s_var->s_development1)
#define development2     (s_var->s_development2)
#define initframe        (s_var->s_initframe)
#define initpos          (s_var->s_initpos)
#define pickedcube       (s_var->s_pickedcube)
#define vertslatescale   (s_var->s_vertslatescale)

#define contrail (s_var->s_contrail)
#define fram     (s_var->s_fram)
#define fram2    (s_var->s_fram2)
#define fram3    (s_var->s_fram3)
#define fram4    (s_var->s_fram4)
#define fram5    (s_var->s_fram5)

#define showframe      (s_var->s_showframe)
#define showlissajou   (s_var->s_showlissajou)
#define showchaseplane (s_var->s_showchaseplane)
#define showcontrail   (s_var->s_showcontrail)
#define showslate      (s_var->s_showslate)
#define cockpit        (s_var->s_cockpit)
#define showbishop     (s_var->s_showbishop)
#define autopilot      (s_var->s_autopilot)

/**********************************************************************/
/* function prototypes - fixes functions being defined out of order   */
/*    so that I can group functions according to their purpose.  This */
/*    is only a partial list.                                         */
/**********************************************************************/
void dragtrack(int but, int xx, int yy, int shif);
void processhits(GLint numbHits, GLuint buffer[]);
void drawaxis(void);
void drawplanaraxis(void);

/**********************************************************************/
/* getmem - allocates the memory initially.                           */
/**********************************************************************/
void getmem(void){  
    /* remember, you need (struct share_var*) for C++ compiler */
    if(caveyes)
#ifdef CAVE
    s_var = (struct share_var *) CAVEMalloc(sizeof(struct share_var)) 
    /* no ; here ! */
#endif /* CAVE */
     ; /* but ;  here */
   else /* CONSOLE */
     s_var =(struct share_var *) malloc(sizeof(struct share_var));
    if(s_var==NULL){fprintf(stderr,"No room to share! %x \n",s_var); exit(1);}

   /******** these now need to vary in size - added by bafarmer */
   controlPoints1 = (float (*)[3]) malloc(CONTROLPTS*3*sizeof(float));
   controlPoints2 = (float (*)[3]) malloc(CONTROLPTS*3*sizeof(float));
   development1 = (float (*)[2]) malloc((NUMBPTS*2)*2*sizeof(float));
   development2 = (float (*)[2]) malloc((NUMBPTS*2)*2*sizeof(float));
   frenetcurve  = (float (*)[3]) malloc(NUMBPTS*3*sizeof(float));
   bishopcurve  = (float (*)[3]) malloc(NUMBPTS*3*sizeof(float));
   curvefrenetframe = (float (*)[9]) malloc(NUMBPTS*9*sizeof(float));
   curvebishopframe = (float (*)[9]) malloc(NUMBPTS*9*sizeof(float));

}
/******************end*CAVEISH*****************************************/

/**********************************************************************/
/* autotymer - illiView animator                                      */
/**********************************************************************/
void autotymer(int reset){ /* cheap animations */
#define  TYME(cnt,max,act) {static cnt; if(first)cnt=max; else\
                            if(cnt?cnt--:0){ act ; goto Break;}}
  static first = 1;  /* the first time autymer is called */
  if(reset)first=1;  /* or if it is reset to start over  */
  TYME( shrink , 150,th0++;th1--;ta0++;ta1--)
  TYME( pause  , 20,          )
  TYME( grow   , 150,th0--;th1++;ta0--;ta1++)
  TYME( dwell  , 30,            )
  TYME(finish  , 1 , first = 1  )
  first = 0;
  Break:   ;   /* yes Virginia, C has gotos */
}
/**********************************************************************/
/* initpoints - initializes the control points and the points in the  */
/*     of the development.                                            */
/**********************************************************************/
void initpoints(void){
   double step;  /* step is the fractional part for the LIRP from A to B */
   for(ii=0; ii<(controlpts); ii++){
      step = (double)ii/controlpts;

      /* evenly span the control points on a line */
      controlPoints1[ii][0] = controlPoints2[ii][0] = -5*(1-step)+5*step;

      /* make y-values 0 */
      controlPoints1[ii][1] = controlPoints2[ii][1] = 0;

      /* make z-values 0 */
      controlPoints1[ii][2] = controlPoints2[ii][2] = 0;
   }
#if 0 /* enable this if you want a circular development curve */
   for(ii=1; ii<(controlpts-1); ii++){
      step = (double)(ii-1)/(controlpts-3);
      /* make y-values cosine or sine */
         controlPoints1[ii][1] = cos(step*2*M_PI);
         controlPoints2[ii][1] = sin(step*2*M_PI);
   } 
   
   controlPoints1[0][1] = controlPoints1[1][1];
   controlPoints1[controlpts-1][1] = controlPoints1[controlpts-2][1];
   controlPoints2[0][1] = controlPoints2[1][1];
   controlPoints2[controlpts-1][1] = controlPoints2[controlpts-2][1];
#endif

   for(ii=0; ii<DEVELPTS; ii++){
      /* evenly span the development points on a line */
      step = (float)ii/DEVELPTS;
      development1[ii][0] = controlPoints1[1][0]*(1-step) + controlPoints1[controlpts-2][0]*step;
      development1[ii][1] = 0;

      development2[ii][0] = controlPoints2[1][0]*(1-step) + controlPoints2[controlpts-2][0]*step;
      development2[ii][1] = 0;
   }
}
/**********************************************************************/
/**********************************************************************/
/**********************************************************************/
/******* Calculation Functions - these functions do the math **********/
/**********************************************************************/
/**********************************************************************/
/**********************************************************************/

/**********************************************************************/
/* calculatefram - updates fram and fram2                             */
/**********************************************************************/
void calculatefram(void){
   int hangback, hangback2, hangback3, hangback4;

   /* fram is for the vehicle on the lissajou         */
   /* fram2 is for the chaseplane on the lissajou     */
   /* fram3 is for the vehilce on the curve           */
   /* fram4 is for the 1st chase vehilce on the curve */
   /* fram5 is for the 2nd chase vehilce on the curve */

   /* This statement handles the case where the front */
   /*  vehicle goes back to the begining of the loop, */
   /*  but the next vehicle is still at the end.      */
   if(tt>=SPACE){ hangback2=tt-SPACE;
   }else{         hangback2=numbpts-(SPACE*1-tt); }

   if(tt>=SPACE*2){ hangback3=tt-SPACE*2;
   }else{           hangback3=numbpts-((SPACE*2)-tt); }

   /* curvefrenetframe[0 3 6]  [T0 N0 B0] */
   /*                 [1 4 7]==[T1 N1 B1] */
   /*                 [2 5 8]  [T2 N2 B2] */


   if(showbishop){  /* The shuttle flies along the Bishop frame */
      /* on the lissajou */
      fram[ 0] = lissbishopframe[tt][6]; /* Tangent */
      fram[ 1] = lissbishopframe[tt][7];
      fram[ 2] = lissbishopframe[tt][8];
      fram[ 3] = 0;
      fram[ 4] = lissbishopframe[tt][3]; /* Normal */
      fram[ 5] = lissbishopframe[tt][4];
      fram[ 6] = lissbishopframe[tt][5];
      fram[ 7] = 0;
      fram[ 8] = -lissbishopframe[tt][0]; /* Binormal */
      fram[ 9] = -lissbishopframe[tt][1];
      fram[10] = -lissbishopframe[tt][2];
      fram[11] = 0;
      fram[12] = lissajou[tt][0];
      fram[13] = lissajou[tt][1];
      fram[14] = lissajou[tt][2];
      fram[15] = 1;

      fram2[ 0] = lissbishopframe[hangback2][6];
      fram2[ 1] = lissbishopframe[hangback2][7];
      fram2[ 2] = lissbishopframe[hangback2][8];
      fram2[ 3] = 0;
      fram2[ 4] = lissbishopframe[hangback2][3];
      fram2[ 5] = lissbishopframe[hangback2][4];
      fram2[ 6] = lissbishopframe[hangback2][5];
      fram2[ 7] = 0;
      fram2[ 8] = -lissbishopframe[hangback2][0];
      fram2[ 9] = -lissbishopframe[hangback2][1];
      fram2[10] = -lissbishopframe[hangback2][2];
      fram2[11] = 0;
      fram2[12] = lissajou[hangback2][0];
      fram2[13] = lissajou[hangback2][1];
      fram2[14] = lissajou[hangback2][2];
      fram2[15] = 1;

      /* on the curve */
      fram3[ 0] = curvebishopframe[tt][6];
      fram3[ 1] = curvebishopframe[tt][7];
      fram3[ 2] = curvebishopframe[tt][8];
      fram3[ 3] = 0;
      fram3[ 4] = curvebishopframe[tt][3];
      fram3[ 5] = curvebishopframe[tt][4];
      fram3[ 6] = curvebishopframe[tt][5];
      fram3[ 7] = 0;
      fram3[ 8] = -curvebishopframe[tt][0];
      fram3[ 9] = -curvebishopframe[tt][1];
      fram3[10] = -curvebishopframe[tt][2];
      fram3[11] = 0;
      fram3[12] = bishopcurve[tt][0];
      fram3[13] = bishopcurve[tt][1];
      fram3[14] = bishopcurve[tt][2];
      fram3[15] = 1;

      fram4[ 0] = curvebishopframe[hangback2][6];
      fram4[ 1] = curvebishopframe[hangback2][7];
      fram4[ 2] = curvebishopframe[hangback2][8];
      fram4[ 3] = 0;
      fram4[ 4] = curvebishopframe[hangback2][3];
      fram4[ 5] = curvebishopframe[hangback2][4];
      fram4[ 6] = curvebishopframe[hangback2][5];
      fram4[ 7] = 0;
      fram4[ 8] = -curvebishopframe[hangback2][0];
      fram4[ 9] = -curvebishopframe[hangback2][1];
      fram4[10] = -curvebishopframe[hangback2][2];
      fram4[11] = 0;
      fram4[12] = bishopcurve[hangback2][0];
      fram4[13] = bishopcurve[hangback2][1];
      fram4[14] = bishopcurve[hangback2][2];
      fram4[15] = 1;


      fram5[ 0] = curvebishopframe[hangback3][6];
      fram5[ 1] = curvebishopframe[hangback3][7];
      fram5[ 2] = curvebishopframe[hangback3][8];
      fram5[ 3] = 0;
      fram5[ 4] = curvebishopframe[hangback3][3];
      fram5[ 5] = curvebishopframe[hangback3][4];
      fram5[ 6] = curvebishopframe[hangback3][5];
      fram5[ 7] = 0;
      fram5[ 8] = -curvebishopframe[hangback3][0];
      fram5[ 9] = -curvebishopframe[hangback3][1];
      fram5[10] = -curvebishopframe[hangback3][2];
      fram5[11] = 0;
      fram5[12] = bishopcurve[hangback3][0];
      fram5[13] = bishopcurve[hangback3][1];
      fram5[14] = bishopcurve[hangback3][2];
      fram5[15] = 1;

   }else{  /* the shuttle flies along the Frenet frame */
      /* on the lissajou */
      fram[ 0] = lissfrenetframe[tt][6];
      fram[ 1] = lissfrenetframe[tt][7];
      fram[ 2] = lissfrenetframe[tt][8];
      fram[ 3] = 0;
      fram[ 4] = lissfrenetframe[tt][3];
      fram[ 5] = lissfrenetframe[tt][4];
      fram[ 6] = lissfrenetframe[tt][5];
      fram[ 7] = 0;
      fram[ 8] = -lissfrenetframe[tt][0];
      fram[ 9] = -lissfrenetframe[tt][1];
      fram[10] = -lissfrenetframe[tt][2];
      fram[11] = 0;
      fram[12] = lissajou[tt][0];
      fram[13] = lissajou[tt][1];
      fram[14] = lissajou[tt][2];
      fram[15] = 1;

      fram2[ 0] = lissfrenetframe[hangback2][6];
      fram2[ 1] = lissfrenetframe[hangback2][7];
      fram2[ 2] = lissfrenetframe[hangback2][8];
      fram2[ 3] = 0;
      fram2[ 4] = lissfrenetframe[hangback2][3];
      fram2[ 5] = lissfrenetframe[hangback2][4];
      fram2[ 6] = lissfrenetframe[hangback2][5];
      fram2[ 7] = 0;
      fram2[ 8] = -lissfrenetframe[hangback2][0];
      fram2[ 9] = -lissfrenetframe[hangback2][1];
      fram2[10] = -lissfrenetframe[hangback2][2];
      fram2[11] = 0;
      fram2[12] = lissajou[hangback2][0];
      fram2[13] = lissajou[hangback2][1];
      fram2[14] = lissajou[hangback2][2];
      fram2[15] = 1;

      /* on the curve */
      fram3[ 0] = curvefrenetframe[tt][6];
      fram3[ 1] = curvefrenetframe[tt][7];
      fram3[ 2] = curvefrenetframe[tt][8];
      fram3[ 3] = 0;
      fram3[ 4] = curvefrenetframe[tt][3];
      fram3[ 5] = curvefrenetframe[tt][4];
      fram3[ 6] = curvefrenetframe[tt][5];
      fram3[ 7] = 0;
      fram3[ 8] = -curvefrenetframe[tt][0];
      fram3[ 9] = -curvefrenetframe[tt][1];
      fram3[10] = -curvefrenetframe[tt][2];
      fram3[11] = 0;
      fram3[12] = frenetcurve[tt][0];
      fram3[13] = frenetcurve[tt][1];
      fram3[14] = frenetcurve[tt][2];
      fram3[15] = 1;

      fram4[ 0] = curvefrenetframe[hangback2][6];
      fram4[ 1] = curvefrenetframe[hangback2][7];
      fram4[ 2] = curvefrenetframe[hangback2][8];
      fram4[ 3] = 0;
      fram4[ 4] = curvefrenetframe[hangback2][3];
      fram4[ 5] = curvefrenetframe[hangback2][4];
      fram4[ 6] = curvefrenetframe[hangback2][5];
      fram4[ 7] = 0;
      fram4[ 8] = -curvefrenetframe[hangback2][0];
      fram4[ 9] = -curvefrenetframe[hangback2][1];
      fram4[10] = -curvefrenetframe[hangback2][2];
      fram4[11] = 0;
      fram4[12] = frenetcurve[hangback2][0];
      fram4[13] = frenetcurve[hangback2][1];
      fram4[14] = frenetcurve[hangback2][2];
      fram4[15] = 1;

      /* fram on the curve */
      fram5[ 0] = curvefrenetframe[hangback3][6];
      fram5[ 1] = curvefrenetframe[hangback3][7];
      fram5[ 2] = curvefrenetframe[hangback3][8];
      fram5[ 3] = 0;
      fram5[ 4] = curvefrenetframe[hangback3][3];
      fram5[ 5] = curvefrenetframe[hangback3][4];
      fram5[ 6] = curvefrenetframe[hangback3][5];
      fram5[ 7] = 0;
      fram5[ 8] = -curvefrenetframe[hangback3][0];
      fram5[ 9] = -curvefrenetframe[hangback3][1];
      fram5[10] = -curvefrenetframe[hangback3][2];
      fram5[11] = 0;
      fram5[12] = frenetcurve[hangback3][0];
      fram5[13] = frenetcurve[hangback3][1];
      fram5[14] = frenetcurve[hangback3][2];
      fram5[15] = 1;

   }
}
/**********************************************************************/
/* calculatecardinalspline - computes the cardinal spline for a set   */
/*     of 4 control points and a given value of paramT in one         */
/*     in one dimension. Returns the value at the given value of      */
/*     paramT.                                                        */
/**********************************************************************/
float calculatecardinalspline(float P0, float P1, float P2, float P3, float paramT){
   float TEMP[4];
    /* {-1,  1, -1,  1} {P0} {TEMP[0]} */
    /* { 2, -2,  1, -1} {P1} {TEMP[1]} */
    /* {-1,  0,  1,  0}*{P2}={TEMP[2]} */
    /* { 0,  1,  0,  0} {P3} {TEMP[3]} */
    /* Cardinal Matrix K times the 4 control points */

   TEMP[0] = -P0 + P1 - P2 + P3;
   TEMP[1] = 2*P0 - 2*P1 + P2 - P3;
   TEMP[2] = -P0 + P2;
   TEMP[3] = P1;

    /* {t^3 t^2 t 1}*{TEMP[0]} */
    /*               {TEMP[1]} */
    /*               {TEMP[2]} */
    /*               {TEMP[3]} */

    return paramT*paramT*paramT*TEMP[0] + paramT*paramT*TEMP[1] + paramT*TEMP[2] + TEMP[3]; 
}
/**********************************************************************/
/* calculatedevelopment1 - calculates the 1st development curve.      */
/**********************************************************************/
void calculatedevelopment1(void){
   float tParam;
   int ii, jj;
   for(ii=0; ii<(controlpts-3); ii++){
      for(jj=0; jj<SPLINELEG; jj++){
         tParam = ((float)jj)/((float)SPLINELEG);

         development1[ii*SPLINELEG+jj][1] \
          = calculatecardinalspline(controlPoints1[ii][1], controlPoints1[ii+1][1],\
          controlPoints1[ii+2][1], controlPoints1[ii+3][1], tParam);
      }
   }
}
/**********************************************************************/
/* calculatedevelopment2 - calculates the 2nd development curve.      */
/**********************************************************************/
void calculatedevelopment2(void){
   float tParam;
   int ii, jj;
   for(ii=0; ii<(controlpts-3); ii++){
      for(jj=0; jj<SPLINELEG; jj++){
         tParam = ((float)jj)/((float)SPLINELEG);

         development2[ii*SPLINELEG+jj][1] \
          = calculatecardinalspline(controlPoints2[ii][1], controlPoints2[ii+1][1],\
          controlPoints2[ii+2][1], controlPoints2[ii+3][1], tParam);
      }
   }
}
/**********************************************************************/
/* calculatelissajou - calculates the values(coords) of our curve     */
/*    in space.                                                       */
/**********************************************************************/
void calculatelissajou(void){
   for(ii=0; ii<NUMBPTS; ii++){
      lissajou[ii][0] = cos(aa*ii*DGG);
      lissajou[ii][1] = sin(bb*ii*DGG);
      lissajou[ii][2] = cos(cc*ii*DGG);
   }
}
/**********************************************************************/
/**********************************************************************/
/***** McCreary's curve/frame computation functions *******************/
/**********************************************************************/
/**********************************************************************/

/***der_Gamma is same for both Bishop and Frenet frames***/
float der_Gamma(float TTT){
        return  TTT;
}
/**********************************************************************/

/**********************************************************************/
float der_TttF(int ttt,float TTT,float NNN,float BBB){
        return NNN*development1[ttt][1];
         /* Normal*kappa(ttt) */
}
/**********************************************************************/
float der_NnnF(int ttt,float TTT,float NNN,float BBB){
        return  -development1[ttt][1]*TTT + development2[ttt][1]*BBB;
        /*return  -kappa(ttt)*TTT + tau(ttt)*BBB;*/

}
/**********************************************************************/
float der_BbbF(int ttt,float TTT,float NNN,float BBB){
        return -development2[ttt][1]*NNN;
        /*return -tau(ttt)*NNN;*/
}
/**********************************************************************/

/**********************************************************************/
float der_TttB(int ttt,float TTT,float NNN,float BBB){
    return development1[ttt][1]*NNN + development2[ttt][1]*BBB;
    /*return  kappa(ttt)*NNN + tau(ttt)*BBB;*/
}
/**********************************************************************/
float der_NnnB(int ttt,float TTT,float NNN,float BBB){
   return  -1*development1[ttt][1]*TTT;
   /*return  -kappa(ttt)*TTT;*/
}
/**********************************************************************/
float der_BbbB(int ttt,float TTT,float NNN,float BBB){
   return  -1*development2[ttt][1]*TTT;
   /*return  -tau(ttt)*TTT;*/
}
/***** end of McCreary's curve/frame computation functions *************/

/**********************************************************************/
/* calculatefrenetliss - calculates the Frennett frame of our curve.      */
/**********************************************************************/
void calculatefrenetliss(void){
    double dotprod, temp1, temp2, temp3;
    float TEMP1[3], TEMP2[3], TEMP3[3];
    float R[3], T[3], N[3], BN[3]; 
    float RPRIME[3], R2PRIME[3], R3PRIME[3], TMP[3];    /* vectors */

    for(ii=0; ii<=NUMBPTS; ii++){
       R[0] = cos(aa*ii*DGG);
       R[1] = sin(bb*ii*DGG);
       R[2] = cos(cc*ii*DGG);
 
       RPRIME[0] = -aa*sin(aa*ii*DGG);
       RPRIME[1] =  bb*cos(bb*ii*DGG);
       RPRIME[2] = -cc*sin(cc*ii*DGG);

       R2PRIME[0] = -aa*aa*cos(aa*ii*DGG);
       R2PRIME[1] = -bb*bb*sin(bb*ii*DGG);
       R2PRIME[2] = -cc*cc*cos(cc*ii*DGG);

       R3PRIME[0] = aa*aa*aa*sin(aa*ii*DGG);
       R3PRIME[1] = -bb*bb*bb*cos(bb*ii*DGG);
       R3PRIME[2] = cc*cc*cc*sin(cc*ii*DGG);

       MAG(RPRIME, temp);  /* temp = the magnitude of RPRIME */
       temp = ABS(temp);

       T[0] = RPRIME[0]/temp;
       T[1] = RPRIME[1]/temp;
       T[2] = RPRIME[2]/temp;
 
       /* TMP is the projection of R2PRIME onto RPRIME */
       temp2 = DOT(R2PRIME, T);
       SCALE(T,temp2,TMP)
       VSUB(R2PRIME, TMP, N)

       MAG(N, temp3);  /* temp3 = the magnitude of N */
       temp3 = ABS(temp3);

       if(temp3!=0){  /*  takes care of "bad" undefined places */
         N[0] = N[0]/temp3;
         N[1] = N[1]/temp3;
         N[2] = N[2]/temp3;
       }else{
         N[0] = lissfrenetframe[ii-1][3]; 
         N[1] = lissfrenetframe[ii-1][4]; 
         N[2] = lissfrenetframe[ii-1][5]; 
       }
       
       CROSS(T, N, BN);
       
       lissfrenetframe[ii][0]=T[0]; /* the Frennett frame */
       lissfrenetframe[ii][1]=T[1];
       lissfrenetframe[ii][2]=T[2];  
       lissfrenetframe[ii][3]=N[0];  
       lissfrenetframe[ii][4]=N[1];  
       lissfrenetframe[ii][5]=N[2];  
       lissfrenetframe[ii][6]=BN[0];  
       lissfrenetframe[ii][7]=BN[1];  
       lissfrenetframe[ii][8]=BN[2];  

     } /*end of the for() loop */
}

/**********************************************************************/
/* calculatefrenetcurve - calculates the curve if the developments are*/
/*    the Curvature and Torsion                                       */
/**********************************************************************/
void calculatefrenetcurve(void){ /* calculates the curve with Runge-Kutta */
   for(jj=0; jj<3; jj++){ /* for X, Y, and Z*/
      /**derivative functions for T, N, & B use precomputed values of k_1 and k_2**/
      /**to construct the Bishop or Frenet framed curve**/
      /**Note: k_1=kappa; k_2=tau if whichFrame==Frenet**/
      int ii;

      /**(G)amma curve**/
      float  G1, dG, g1, g2, g3, g4;
      /** initial value, step, variables for transition functions:**/
      /** 4 transition variables for this Runge-Kutta **/
      /**Bishop frame vectors (T,N,B). (n.b., need all three)**/
      float  T1, dT, tmpT, t1, t2, t3, t4,
             N1, dN, tmpN, n1, n2, n3, n4,
             B1, dB, tmpB, b1, b2, b3, b4;
      /**time variables**/
      float  h,hhh;
      /**parameter variables**/
      int  tt1,tmp1;

      /**Following is (potentially variable) number of points placed between each point computed on Gamma**/
      /**As ppi gets larger, this is equivalent to decreasing the step size in the R-K process.**/
      /**Note that the same number of points on the curve will be computed no matter what ppi's value **/        
      int ppi=1;

      /**** have initframe initialized in deFault or somewhere else**/
      /*hhh=portion of curve traversed each step*/
      hhh=(float)1.0/(numbpts-1); /*gammaLength;*/
      h=fabs(hhh);/**only positive steps here. Safety check**/

      h*= paramlength;  /* scale the stepsize */

      /** initial frame values specified in determineInitialConditions() **/
      tt1=0;
      G1=initpos[jj];
      T1=initframe[jj+0];
      N1=initframe[jj+3];
      B1=initframe[jj+6];

      FOR(ii,0,numbpts*ppi){
         /*record the solution for this step**/
         if(ii%ppi==0){
            /* the frame points are located in space centered at point on curve, not centered at origin*/
            /* gammaCurve[whichFrame][ii][whichCoord]=G1; */
            /* frame[whichFrame][TT][ii/ppi][whichCoord]=T1+gammaCurve[whichFrame][ii][whichCoord]; */
            /* frame[whichFrame][NN][ii/ppi][whichCoord]=N1+gammaCurve[whichFrame][ii][whichCoord]; */
            /* frame[whichFrame][BB][ii/ppi][whichCoord]=B1+gammaCurve[whichFrame][ii][whichCoord]; */

            /*   frenetframe[0 3 6]  [T0 N0 B0] */
            /*              [1 4 7]==[T1 N1 B1] */
            /*              [2 5 8]  [T2 N2 B2] */

            frenetcurve[ii/ppi][jj]        = G1;  /* Scale things to be huge! */
            curvefrenetframe[ii/ppi][jj+0] = T1;  
            curvefrenetframe[ii/ppi][jj+3] = N1;
            curvefrenetframe[ii/ppi][jj+6] = B1;

         }
         /*step 1*/
         tt1 = 2*ii;
         t1=h*der_TttF(tt1,T1,N1,B1);
         n1=h*der_NnnF(tt1,T1,N1,B1);
         b1=h*der_BbbF(tt1,T1,N1,B1);
         g1=h*der_Gamma(T1);

         /*step 2*/
         tmp1=tt1+1;
           tmpT=T1+.5*t1;
           tmpN=N1+.5*n1;
           tmpB=B1+.5*b1;

         t2=h*der_TttF(tmp1,tmpT,tmpN,tmpB);
         n2=h*der_NnnF(tmp1,tmpT,tmpN,tmpB);
         b2=h*der_BbbF(tmp1,tmpT,tmpN,tmpB);
         g2=h*der_Gamma(tmpT);

         /*step 3*/
           tmpT=T1+.5*t2;
           tmpN=N1+.5*n2; 
           tmpB=B1+.5*b2;
         t3=h*der_TttF(tmp1,tmpT,tmpN,tmpB);
         n3=h*der_NnnF(tmp1,tmpT,tmpN,tmpB);
         b3=h*der_BbbF(tmp1,tmpT,tmpN,tmpB);
         g3=h*der_Gamma(tmpT);

         /*step 4*/
         tmp1=tt1+2;
           tmpT=T1+t3;
           tmpN=N1+n3;
           tmpB=B1+b3;
         t4=h*der_TttF(tmp1,tmpT,tmpN,tmpB);
         n4=h*der_NnnF(tmp1,tmpT,tmpN,tmpB);
         b4=h*der_BbbF(tmp1,tmpT,tmpN,tmpB);
         g4=h*der_Gamma(tmpT);

         /*changes in all parameters*/
         dG=(g1+g2+g2+g3+g3+g4)/6.;
         dT=(t1+t2+t2+t3+t3+t4)/6.;
         dN=(n1+n2+n2+n3+n3+n4)/6.;
         dB=(b1+b2+b2+b3+b3+b4)/6.;

         /*update parameter values*/
         G1+=dG;
         T1+=dT;
         N1+=dN;
         B1+=dB;
     }/*end of loop*/
   }
}
/**********************************************************************/
/* calculatebishopcurve - calculates the curve if the developments are*/
/*    the Bishop parameters.                                          */
/**********************************************************************/
void calculatebishopcurve(void){ /* calculates the curve with Runge-Kutta */
      /**derivative functions for T, N, & B use precomputed values of k_1 and k_2**/
      /**to construct the Bishop or Frenet framed curve**/
      /**Note: k_1=kappa; k_2=tau if whichFrame==Frenet**/
      int ii;

      /**(G)amma curve**/
      float  G1, dG, g1, g2, g3, g4;
      /** initial value, step, variables for transition functions:**/
      /** 4 transition variables for this Runge-Kutta **/
      /**Bishop frame vectors (T,N,B). (n.b., need all three)**/
      float  T1, dT, tmpT, t1, t2, t3, t4,
             N1, dN, tmpN, n1, n2, n3, n4,
             B1, dB, tmpB, b1, b2, b3, b4;
      /**time variables**/
      float  h,hhh;
      /**parameter variables**/
      int  tt1,tmp1;

      /**Following is (potentially variable) number of points placed between each point computed on Gamma**/
      /**As ppi gets larger, this is equivalent to decreasing the step size in the R-K process.**/
      /**Note that the same number of points on the curve will be computed no matter what ppi's value **/        
      int ppi=1;

      /**** have initframe initialized in deFault or somewhere else**/
      /*hhh=portion of curve traversed each step*/
      hhh=(float)1.0/(numbpts-1); /*gammaLength;*/
      h=fabs(hhh);/**only positive steps here. Safety check**/

      h*= paramlength;  /* scale the stepsize */


   for(jj=0; jj<3; jj++){ /* for X, Y, and Z*/

      /** initial frame values specified in determineInitialConditions() **/
      tt1=0;
      G1=initpos[jj];
      T1=initframe[jj+0];
      N1=initframe[jj+3];
      B1=initframe[jj+6];

      FOR(ii,0,numbpts*ppi){
         /*record the solution for this step**/
         if(ii%ppi==0){
            /* the frame points are located in space centered at point on curve, not centered at origin*/
            /* gammaCurve[whichFrame][ii][whichCoord]=G1; */
            /* frame[whichFrame][TT][ii/ppi][whichCoord]=T1+gammaCurve[whichFrame][ii][whichCoord]; */
            /* frame[whichFrame][NN][ii/ppi][whichCoord]=N1+gammaCurve[whichFrame][ii][whichCoord]; */
            /* frame[whichFrame][BB][ii/ppi][whichCoord]=B1+gammaCurve[whichFrame][ii][whichCoord]; */

            /*   showbishopframe[0 3 6]  [T0 U0 V0] */
            /*              [1 4 7]==[T1 U1 V1] */
            /*              [2 5 8]  [T2 U2 V2] */

            bishopcurve[ii/ppi][jj]        = G1; 
            curvebishopframe[ii/ppi][jj+0] = T1;  
            curvebishopframe[ii/ppi][jj+3] = N1;
            curvebishopframe[ii/ppi][jj+6] = B1;

         }
         /*step 1*/
         tt1 = 2*ii;
         t1=h*der_TttB(tt1,T1,N1,B1);
         n1=h*der_NnnB(tt1,T1,N1,B1);
         b1=h*der_BbbB(tt1,T1,N1,B1);
         g1=h*der_Gamma(T1);

         /*step 2*/
         tmp1=tt1+1;
           tmpT=T1+.5*t1;
           tmpN=N1+.5*n1;
           tmpB=B1+.5*b1;

         t2=h*der_TttB(tmp1,tmpT,tmpN,tmpB);
         n2=h*der_NnnB(tmp1,tmpT,tmpN,tmpB);
         b2=h*der_BbbB(tmp1,tmpT,tmpN,tmpB);
         g2=h*der_Gamma(tmpT);

         /*step 3*/
           tmpT=T1+.5*t2;
           tmpN=N1+.5*n2; 
           tmpB=B1+.5*b2;
         t3=h*der_TttB(tmp1,tmpT,tmpN,tmpB);
         n3=h*der_NnnB(tmp1,tmpT,tmpN,tmpB);
         b3=h*der_BbbB(tmp1,tmpT,tmpN,tmpB);
         g3=h*der_Gamma(tmpT);

         /*step 4*/
         tmp1=tt1+2;
           tmpT=T1+t3;
           tmpN=N1+n3;
           tmpB=B1+b3;
         t4=h*der_TttB(tmp1,tmpT,tmpN,tmpB);
         n4=h*der_NnnB(tmp1,tmpT,tmpN,tmpB);
         b4=h*der_BbbB(tmp1,tmpT,tmpN,tmpB);
         g4=h*der_Gamma(tmpT);

         /*changes in all parameters*/
         dG=(g1+g2+g2+g3+g3+g4)/6.;
         dT=(t1+t2+t2+t3+t3+t4)/6.;
         dN=(n1+n2+n2+n3+n3+n4)/6.;
         dB=(b1+b2+b2+b3+b3+b4)/6.;

         /*update parameter values*/
         G1+=dG;
         T1+=dT;
         N1+=dN;
         B1+=dB;
     }/*end of loop*/
     /*******constructCurve();/*and frame from the frame and path coordinates*/
   }
}
/**************************************************************************/
/* calculatebishopliss - calculates the Bishop frame of the lissajou.     */
/**************************************************************************/
void calculatebishopliss(void){

   double dotprod, temp1, temp2, temp3;
   float TEMP1[3], TEMP2[3], TEMP3[3];
   float TAN[3], TANPLUS1[3], BINO[3], OLDVEC[3], NEWVEC[3];
   float R[3], T[3], RPRIME[3], TMP[3];    /* vectors */
   float BCROSSU0[3];

   /*   showbishopframe[0 3 6]  [T0 U0 V0] */
   /*              [1 4 7]==[T1 U1 V1] */
   /*              [2 5 8]  [T2 U2 V2] */

   /* At tt=0 the Bishop frame is the same as the Frennett frame */
   lissbishopframe[0][0] = lissfrenetframe[0][0];
   lissbishopframe[0][1] = lissfrenetframe[0][1];
   lissbishopframe[0][2] = lissfrenetframe[0][2];
   lissbishopframe[0][3] = lissfrenetframe[0][3];
   lissbishopframe[0][4] = lissfrenetframe[0][4];
   lissbishopframe[0][5] = lissfrenetframe[0][5];
   lissbishopframe[0][6] = lissfrenetframe[0][6];
   lissbishopframe[0][7] = lissfrenetframe[0][7];
   lissbishopframe[0][8] = lissfrenetframe[0][8];

   /* first we must go through and find all the Tan vectors */
   /* The Tan is just the normalized first derivative */
   for(ii=1; ii<(NUMBPTS); ii++){ 
      RPRIME[0] = -aa*sin(aa*ii*DGG);
      RPRIME[1] =  bb*cos(bb*ii*DGG);
      RPRIME[2] = -cc*sin(cc*ii*DGG);

      MAG(RPRIME, temp);  /* temp = the magnitude of RPRIME */

      lissbishopframe[ii][0] = RPRIME[0]/temp;
      lissbishopframe[ii][1] = RPRIME[1]/temp;
      lissbishopframe[ii][2] = RPRIME[2]/temp;
   }

   for(ii=0; ii<(NUMBPTS-1); ii++){ 
      TAN[0] = lissbishopframe[ii][0]; /* TAN is the Tan*/
      TAN[1] = lissbishopframe[ii][1];
      TAN[2] = lissbishopframe[ii][2];

      TANPLUS1[0] = lissbishopframe[ii+1][0]; /* TANPLUS1 is the Tan+1*/
      TANPLUS1[1] = lissbishopframe[ii+1][1];
      TANPLUS1[2] = lissbishopframe[ii+1][2];
      CROSS(TAN,TANPLUS1,BINO)  /* BINO=cross the Tan and the Tan+1 */

      MAG(BINO, temp1);  /* temp1 = mag cross */

      if(temp1<0.000001){  /* if the tangent doesn't turn,the frame stays the same */
         lissbishopframe[ii+1][0] = lissbishopframe[ii][0];
         lissbishopframe[ii+1][1] = lissbishopframe[ii][1];
         lissbishopframe[ii+1][2] = lissbishopframe[ii][2];
         lissbishopframe[ii+1][3] = lissbishopframe[ii][3];
         lissbishopframe[ii+1][4] = lissbishopframe[ii][4];
         lissbishopframe[ii+1][5] = lissbishopframe[ii][5];
         lissbishopframe[ii+1][6] = lissbishopframe[ii][6];
         lissbishopframe[ii+1][7] = lissbishopframe[ii][7];
         lissbishopframe[ii+1][8] = lissbishopframe[ii][8];
      }else{   /* if it does turn, fix the frame */

 
      /* BINO is the calculated binormal at the new position */ 
      /*    The first showbishop vector     */

         OLDVEC[0] = lissbishopframe[ii][3];  /* OLDVEC = old bvector V */
         OLDVEC[1] = lissbishopframe[ii][4];
         OLDVEC[2] = lissbishopframe[ii][5];

         dotprod = DOT(TAN, TANPLUS1);  /* dotprod = Tan dot Tan+1 */ 
         CROSS(BINO, OLDVEC, BCROSSU0)  /*BCROSSU0 = BcrossU */ 
         
         SCALE(OLDVEC, dotprod, TEMP1)  /* TEMP1 is (T0dotT1)<U> */
         temp1 = 1-dotprod;
         temp2 = DOT(OLDVEC, BINO);
         temp3 = temp1*temp2;

         temp1 = DOT(BINO, BINO);
         temp2 = temp3/temp1;
         SCALE(BINO, temp2, TEMP2)
         VADD(TEMP1, BCROSSU0, TEMP3)
         VADD(TEMP3, TEMP2, NEWVEC)

         lissbishopframe[ii+1][3] = NEWVEC[0];
         lissbishopframe[ii+1][4] = NEWVEC[1];
         lissbishopframe[ii+1][5] = NEWVEC[2];

      /******   the second showbishop vector  ******/
         OLDVEC[0] = lissbishopframe[ii][6];  /* OLDVEC = old bvector V */
         OLDVEC[1] = lissbishopframe[ii][7];
         OLDVEC[2] = lissbishopframe[ii][8];

         dotprod = DOT(TAN, TANPLUS1);  /* dotprod = Tan dot Tan+1 */
         CROSS(BINO, OLDVEC, BCROSSU0)  /*BCROSSU0 = BcrossU */

         SCALE(OLDVEC, dotprod, TEMP1)  /* TEMP1 is (T0dotT1)<U> */
         temp1 = 1-dotprod;
         temp2 = DOT(OLDVEC, BINO);
         temp3 = temp1*temp2;

         temp1 = DOT(BINO, BINO);
         temp2 = temp3/temp1;
         SCALE(BINO, temp2, TEMP2)
         VADD(TEMP1, BCROSSU0, TEMP3)
         VADD(TEMP3, TEMP2, NEWVEC)

         lissbishopframe[ii+1][6]=NEWVEC[0];
         lissbishopframe[ii+1][7]=NEWVEC[1];
         lissbishopframe[ii+1][8]=NEWVEC[2];

      } /* end of else for the turning Tan */
   } /*end of for() loop */

}
/**********************************************************************/
/* computelissajou - Computes the lissajou, its Frennett frame, and   */
/*                its Bishop frame.                                   */
/**********************************************************************/
void computelissajou(void){

   calculatelissajou();
   calculatefrenetliss();
   calculatebishopliss(); 

}
/**********************************************************************/
/* computecurve - Computes the curve and its Frenet frame.            */
/**********************************************************************/
void computecurve(void){

   calculatedevelopment1();
   calculatedevelopment2();
   calculatefrenetcurve();
   calculatebishopcurve();
}
/**********************************************************************/
/**********************************************************************/
/****** Miscelanous functions - do various things, not calc or draw****/
/**********************************************************************/
/**********************************************************************/

/***********************************************************************/
/** morecontrolpoints - doubles or halves the number of controlpoints  */
/***********************************************************************/
void morecontrolpoints(int moreorless){
   int oldnumber = controlpts;
   float (*tempPoints1)[3] = (float (*)[3]) malloc(oldnumber*3*sizeof(float));
   float (*tempPoints2)[3] = (float (*)[3]) malloc(oldnumber*3*sizeof(float));

   for(ii=0; ii<oldnumber; ii++){
      for(jj=0; jj<3; jj++){
         tempPoints1[ii][jj] = controlPoints1[ii][jj];
         tempPoints2[ii][jj] = controlPoints2[ii][jj];
      }
   }

   if(moreorless==0){
      controlpts *= 2;
      numbpts *= 2;
      paramlength = controlpts/2;
   }else{
      controlpts /= 2;
      numbpts /= 2;
      paramlength = controlpts/2;
   }

   free(controlPoints1); /* reclaim the previously used mem */
   free(controlPoints2);
   free(development1);
   free(development2);
   free(frenetcurve);
   free(bishopcurve);
   free(curvebishopframe);
   free(curvefrenetframe);

   controlPoints1 = (float (*)[3]) malloc(controlpts*3*sizeof(float)); /* grab some new mem */
   controlPoints2 = (float (*)[3]) malloc(controlpts*3*sizeof(float));
   development1 = (float (*)[2]) malloc(DEVELPTS*2*sizeof(float));
   development2 = (float (*)[2]) malloc(DEVELPTS*2*sizeof(float));
   curvebishopframe = (float (*)[9]) malloc(numbpts*9*sizeof(float));
   curvefrenetframe = (float (*)[9]) malloc(numbpts*9*sizeof(float));
   frenetcurve  = (float (*)[3]) malloc(numbpts*3*sizeof(float));
   bishopcurve  = (float (*)[3]) malloc(numbpts*3*sizeof(float));


   initpoints();  /* this takes care of the horizontal spacing of everything*/

   if(moreorless==0){  /* if we doubled the number, fill in the first half with the old vals */
      for(ii=0; ii<oldnumber; ii++){
         controlPoints1[ii][1] = tempPoints1[ii][1];
         controlPoints2[ii][1] = tempPoints2[ii][1];
      }
   }else{
      /* figure it out later */
   }

   free(tempPoints1);
   free(tempPoints2);

   computecurve();
}
/***********************************************************************/
/*********************** stereo    *************************************/
/***********************************************************************/
void turnoffstereo(void){
        system("/usr/gfx/setmon -n 60HZ");
        glutFullScreen(); /* to force a reshape */
stereomode=0;
        glutSetCursor(GLUT_CURSOR_RIGHT_ARROW);

}
void turnonstereo(void){
        glutFullScreen();
        system("/usr/gfx/setmon -n STR_RECT");
        stereomode=1;
        glutSetCursor(GLUT_CURSOR_NONE);
}
void cleanup(void){
        if (stereomode) system("/usr/gfx/setmon -n 60HZ");
}

/**********************************************************************/
/* invert - Inverts a placement matrix                                */
/**********************************************************************/
void invert(float *inv, float *mat){
 inv[0] = mat[0];
 inv[1] = mat[4];
 inv[2] = mat[8];
 inv[3] = mat[3];
 inv[4] = mat[1];
 inv[5] = mat[5];
 inv[6] = mat[9];
 inv[7] = mat[7];
 inv[8] = mat[2];
 inv[9] = mat[6];
 inv[10] = mat[10];
 inv[11] = mat[11];
 inv[12] = -mat[0]*mat[12] - mat[1]*mat[13] - mat[2]*mat[14];
 inv[13] = -mat[4]*mat[12] - mat[5]*mat[13] - mat[6]*mat[14];
 inv[14] = -mat[8]*mat[12] - mat[9]*mat[13] - mat[10]*mat[14];
 inv[15] = mat[15];

}
/**********************************************************************/
/* updatecontrail - This gets the places to make the contrail.        */
/**********************************************************************/
void updatecontrail(void){
  static int flightpt=0;
  float temp[16];
  if(flightpt>=LONGFLIGHT){
      flightpt=0;
    }
    glGetFloatv(GL_MODELVIEW_MATRIX,temp);
    invert(contrail[flightpt], temp);
    flightpt++; 
}
/**********************************************************************/
/* odometer - computes the framerate                                  */
/**********************************************************************/
#ifdef IRIX
float odometer(void){ /* right now we're not using the odometer */
    static struct timeval tv0;  /* time when program started */
    struct timeval tv;
    gettimeofday(&tv, NULL);
    if(tv0.tv_sec == 0) tv0 = tv;  /* initialize tv0 */
    return (tv.tv_sec - tv0.tv_sec) + (tv.tv_usec - tv0.tv_usec)*1e-6;
}
#endif
/**********************************************************************/
/* updateTT - This is the function that handles the autopilot feature.*/
/*    It is needed because of the complexity of the interface, and    */
/*    because there are issues with overstepping the array.           */
/**********************************************************************/
void updateTT(int updown, int whichupdate){
   if(whichupdate){               /* if it is 1, we increase dtt only */
       if(updown){                /* if we are to increase up         */
         if((dtt<10)&&(dtt>=-10)){dtt++;}else{dtt+=10;}
       }else{                     /* we are to increase down          */
         if((dtt<=10)&&(dtt>-10)){dtt--;}else{dtt-=10;}
       }
   }else{                      /* if whichupdate is 0, we update tt only      */ 
      if(tt>0){                /* if tt is greater than 0                     */
        if(tt>=numbpts){       /* if tt is at the end of the array or beyond  */ 
          if(tt=(numbpts-1)){  /* if tt is at the endpoint                 */
            tt = updown>0?0: tt-dtt;
          }else{               /* tt is beyond the array                      */
            tt = updown>0?0: (numbpts-1);
          } 
        }else{                 /* if tt is somewhere inside the array         */
          tt = updown>0?tt+dtt: tt-dtt;
        }  
      }else{                   /* tt is less than or equal to 0               */
        if(tt==0){             /* tt is 0                                     */ 
           if(dtt>=0){
              tt = updown>0?tt+dtt: (numbpts-RAILTIE);
           }else{
              tt = updown>0?(numbpts-RAILTIE): tt+dtt;
           }
        }else{              /* tt is less than 0                           */
           tt = updown>0?0: (numbpts-1);
        }
      }
   }

   calculatefram();

}
/**********************************************************************/
/* opendevelopmentfile - reads in control points from a file.  The    */
/*    file is called "input" and it should be created with this pogram*/
/**********************************************************************/
void opendevelopmentfile(void){
   FILE* openptr;
   int howmanycontrol;
   openptr = fopen("input", "r");

   if(openptr==NULL){
      fprintf(stderr,"The file did not open\n");
      return;
   }


   fscanf(openptr, "%i", &howmanycontrol); /* number of control points in the development */

   if(howmanycontrol!=controlpts){
      fprintf(stderr,"The file you are opening has a different number of control points\n");
      fprintf(stderr,"I will change the number of control points for you!\n");
      
      controlpts = howmanycontrol;
      numbpts = NUMBPTS;  /* default number of points */

      free(controlPoints1); /* reclaim the previously used mem */
      free(controlPoints2);
      free(development1);
      free(development2);
      free(frenetcurve);
      free(bishopcurve);
      free(curvebishopframe);
      free(curvefrenetframe);

      controlPoints1 = (float (*)[3]) malloc(controlpts*3*sizeof(float)); /* grab some new mem */
      controlPoints2 = (float (*)[3]) malloc(controlpts*3*sizeof(float));
      development1 = (float (*)[2]) malloc(DEVELPTS*2*sizeof(float));
      development2 = (float (*)[2]) malloc(DEVELPTS*2*sizeof(float));
      frenetcurve  = (float (*)[3]) malloc(numbpts*3*sizeof(float));
      bishopcurve  = (float (*)[3]) malloc(numbpts*3*sizeof(float));
      curvefrenetframe = (float (*)[9]) malloc(numbpts*9*sizeof(float));
      curvebishopframe = (float (*)[9]) malloc(numbpts*9*sizeof(float));
 
      initpoints();  /* this takes care of the horizontal spacing of everybody */
   } 

   /* load the new values */
   for(ii=0; ii<controlpts; ii++){ 
      fscanf(openptr, "%f", &controlPoints1[ii][0]);
      fscanf(openptr, "%f", &controlPoints1[ii][1]);
      fscanf(openptr, "%f", &controlPoints1[ii][2]);
   }
   for(ii=0; ii<controlpts; ii++){ 
      fscanf(openptr, "%f", &controlPoints2[ii][0]);
      fscanf(openptr, "%f", &controlPoints2[ii][1]);
      fscanf(openptr, "%f", &controlPoints2[ii][2]);
   }

   fclose(openptr);
   paramlength = controlpts/2;
   computecurve();

}
/**********************************************************************/
/* appenddevelompentfile - appends a developement file to the current */
/*    one.  THIS DIDN'T WORK BEFORE THE END OF IM2002 ~baf            */
/**********************************************************************/
void appenddevelopmentfile(void){
   FILE* openptr;
   int howmanycontrol, howmanydata, oldnumber;
   float (*tempPoints1)[3] = (float (*)[3]) malloc(oldnumber*3*sizeof(float));
   float (*tempPoints2)[3] = (float (*)[3]) malloc(oldnumber*3*sizeof(float));
   float bitbucket; /* hack - I don't want to change the way we save developments */
  

   openptr = fopen("input", "r");

   if(openptr==NULL){
      fprintf(stderr,"The file was not appended\n");
      return;
   }

   /* save the old values */
   for(ii=0; ii<controlpts; ii++){
      tempPoints1[ii][1] = controlPoints1[ii][1]; /* we only really want the y vals */
      tempPoints2[ii][1] = controlPoints2[ii][1]; 
   }

   fscanf(openptr, "%i", &howmanycontrol); /* number of control points in the development */

   oldnumber = controlpts;
   controlpts += howmanycontrol;

   free(controlPoints1); /* reclaim the previously used mem */
   free(controlPoints2);

      /* this will have to be done once we save the number of data points */
      /* in the file */
   free(development1);
   free(development2);
   free(frenetcurve);
   free(bishopcurve);
   free(curvebishopframe);
   free(curvefrenetframe);

   controlPoints1 = (float (*)[3]) malloc(controlpts*3*sizeof(float)); /* grab some new mem */
   controlPoints2 = (float (*)[3]) malloc(controlpts*3*sizeof(float));

   development1 = (float (*)[2]) malloc(DEVELPTS*2*sizeof(float));
   development2 = (float (*)[2]) malloc(DEVELPTS*2*sizeof(float));
   frenetcurve  = (float (*)[3]) malloc(numbpts*3*sizeof(float));
   bishopcurve  = (float (*)[3]) malloc(numbpts*3*sizeof(float));
   curvebishopframe = (float (*)[9]) malloc(numbpts*9*sizeof(float));
   curvefrenetframe = (float (*)[9]) malloc(numbpts*9*sizeof(float));


   initpoints();  /* this takes care of the horizontal spacing of everybody */

   /* restore the old values */
   for(ii=0; ii<oldnumber; ii++){
      controlPoints1[ii][1] = tempPoints1[ii][1]; 
      controlPoints2[ii][1] = tempPoints2[ii][1]; 
   }
   /* append the new values */
   for(ii=oldnumber; ii<controlpts; ii++){ 
      fscanf(openptr, "%f", &bitbucket);
      fscanf(openptr, "%f", &controlPoints1[ii][1]);
      fscanf(openptr, "%f", &bitbucket);
   }
   for(ii=oldnumber; ii<controlpts; ii++){ 
      fscanf(openptr, "%f", &bitbucket);
      fscanf(openptr, "%f", &controlPoints2[ii][1]);
      fscanf(openptr, "%f", &bitbucket);
   
   }

   fclose(openptr);
   free(tempPoints1);
   free(tempPoints2);

   paramlength = controlpts/2;

   computecurve();

}
/**********************************************************************/
/* savedevelopmentfile - saves the controlpoints to a file called     */
/*    output.                                                         */
/**********************************************************************/
void savedevelopmentfile(void){
   FILE* saveptr;   /* Create a file pointer */
   int numbercontrolpts = controlpts;

   saveptr = fopen("output", "w");  /* open the file ("output") for writing */

   if(saveptr==NULL){  /* make sure it worked */
      fprintf(stderr,"The file did not save\n");
      return;
   }
   
   fprintf(saveptr, "%i\n", numbercontrolpts);

   for(ii=0; ii<controlpts; ii++){  /* write the control points to the file */
      fprintf(saveptr, "%f ", controlPoints1[ii][0]);
      fprintf(saveptr, "%f ", controlPoints1[ii][1]);
      fprintf(saveptr, "%f\n", controlPoints1[ii][2]);
   } 

   for(ii=0; ii<controlpts; ii++){
      fprintf(saveptr, "%f ", controlPoints2[ii][0]);
      fprintf(saveptr, "%f ", controlPoints2[ii][1]);
      fprintf(saveptr, "%f\n", controlPoints2[ii][2]);
   } 

   fclose(saveptr);  /* close the file */
}
/**********************************************************************/

/**********************************************************************/
/**********************************************************************/
/******** Drawing functions - these do all of the drawing *************/
/**********************************************************************/
/**********************************************************************/
/**********************************************************************/
/**********************************************************************/
/* drawcar - Draws the vehicle that flies the curve. Its current   */
/*    encarnation is a space shuttle.                                 */
/**********************************************************************/
void drawcar(void){ 
    /* first I store the points I want to use */ 
   float vv[13][3] = {  { 0.0, 0.0,-2.0 }, /* 0 */
                        {-0.5, 0.0,-1.0 }, /* 1 */
   		        {-0.5, 0.0,-0.0 }, /* 2 */
		        {-1.5, 0.0, 1.0 }, /* 3 */
		        {-0.5, 0.0, 1.0 }, /* 4 */
		        { 0.5, 0.0, 1.0 }, /* 5 */
		        { 1.5, 0.0, 1.0 }, /* 6 */
		        { 0.5, 0.0,-0.0 }, /* 7 */
		        { 0.5, 0.0,-1.0 }, /* 8 */
		        { 0.0, 1.0,-1.0 }, /* 9 */
		        { 0.0, 1.0,-0.0 }, /* 10*/
		        { 0.0, 1.0, 1.0 }, /* 11*/
		        { 0.0, 2.5, 1.0 }, /* 12*/ };
   
   /* Now I draw the shuttle */
  glBegin(GL_TRIANGLE_FAN); /* nose */
     glColor3f(.2, .2, .2);
     glVertex3fv(vv[0]);
     glVertex3fv(vv[1]);
     glVertex3fv(vv[9]);
     glVertex3fv(vv[8]);
     glVertex3fv(vv[1]);
  glEnd();
  
  glBegin(GL_QUADS); /* left side */
     if(showbishop) glColor3f(1.0,0.5,0.0); else glColor3f(1.0,0.0,0.0);
     glVertex3fv(vv[1]);
     glVertex3fv(vv[4]);
     glVertex3fv(vv[11]);
     glVertex3fv(vv[9]);
  glEnd();

  glLineWidth(1);
  glBegin(GL_LINE_LOOP); /* left side outline */
     glColor3f(1.0,1.0,1.0);
     glLineWidth(2.5);
     glVertex3fv(vv[1]);
     glVertex3fv(vv[4]);
     glVertex3fv(vv[11]);
     glVertex3fv(vv[9]);
  glEnd();
 
  glBegin(GL_QUADS); /* right side */
     if(showbishop) glColor3f(0.0,0.0,1); else glColor3f(0.0,1.0,0.0);
     glVertex3fv(vv[8]);
     glVertex3fv(vv[5]);
     glVertex3fv(vv[11]);
     glVertex3fv(vv[9]);
  glEnd();

  glLineWidth(1);
  glBegin(GL_LINE_LOOP); /* right side outline */
     glColor3f(1.0,1.0,1.0);
     glLineWidth(2.5);
     glVertex3fv(vv[8]);
     glVertex3fv(vv[5]);
     glVertex3fv(vv[11]);
     glVertex3fv(vv[9]);
  glEnd();

  glBegin(GL_QUADS); /* bottom side */
     glColor3f(1,1,1);
     glVertex3fv(vv[1]);
     glVertex3fv(vv[4]);
     glVertex3fv(vv[5]);
     glVertex3fv(vv[8]);
  glEnd();

  glBegin(GL_TRIANGLES); /* left wing */
     if(showbishop) glColor3f(1.0,0.5,0.0); else glColor3f(1.0,0.0,0.0);
     glVertex3fv(vv[2]);
     glVertex3fv(vv[3]);
     glVertex3fv(vv[4]);
  glEnd();
  
  glBegin(GL_TRIANGLES); /* right wing */
     if(showbishop) glColor3f(0.0,0.0,1); else glColor3f(0.0,1.0,0.0);
     glVertex3fv(vv[7]);
     glVertex3fv(vv[5]);
     glVertex3fv(vv[6]);
  glEnd();

  glBegin(GL_TRIANGLES); /* fin */
     glColor3f(0,0,1);
     glVertex3fv(vv[10]);
     glVertex3fv(vv[11]);
     glVertex3fv(vv[12]);
     glVertex3fv(vv[10]);
  glEnd();

  glBegin(GL_TRIANGLES); /* back side */
     glColor3f(0.0,0.0,1.0);
     glVertex3fv(vv[4]);
     glVertex3fv(vv[5]);
     glVertex3fv(vv[11]);
  glEnd();

  glLineWidth(1);
  glBegin(GL_LINE_STRIP); /* back side outline */
     glColor3f(1.0,1.0,1.0);
     glLineWidth(2.5);
     glVertex3fv(vv[4]);
     glVertex3fv(vv[5]);
     glVertex3fv(vv[11]);
  glEnd();
}
/**********************************************************************/
/* drawdevelopment1 - draws the top development curve                 */
/**********************************************************************/
void drawdevelopment1(void){
   float colour = 0;
   glLineWidth(2);
   glBegin(GL_LINE_STRIP);
      for(ii=0; ii<DEVELPTS; ii++){
         colour = (float)ii/DEVELPTS;
         glColor3f(1-colour, colour, colour);
         glVertex3f(development1[ii][0], development1[ii][1]+vertslatescale, 0);
      }
   glEnd();
}
/**********************************************************************/
/* drawdevelopment2 - draws the top development curve                 */
/**********************************************************************/
void drawdevelopment2(void){
   float colour = 0;
   glLineWidth(2);
   glBegin(GL_LINE_STRIP);
      for(ii=0; ii<DEVELPTS; ii++){ 
         colour = (float)ii/DEVELPTS;
         glColor3f(1-colour, colour, colour);
         glVertex3f(development2[ii][0], development2[ii][1]-vertslatescale, 0);
      }
   glEnd();
}
/**********************************************************************/
/* drawplanarcontrol - draws the control points along the planar      */
/*    development curve.                                              */
/**********************************************************************/
void drawplanarcontrol(GLenum mode){
    glColor3f(0.50,0.50,0.50);
    glMatrixMode(GL_MODELVIEW);

    if(mode == GL_SELECT){
       glLoadName(0);  /* for planar development curve*/
       glPushName(0);  /* push a new name on the namestack */
    }

    for(ii=0; ii<controlpts; ii++){
       if(mode == GL_SELECT){
          glLoadName(ii);
       }
       glPushMatrix();
          glTranslatef(controlPoints1[ii][1], controlPoints2[ii][1] ,0);
          glScalef((float)vertslatescale/6, (float)vertslatescale/6, 1);
          glutSolidCube(CUBELET);
       glPopMatrix();
    }
    if(mode == GL_SELECT){
       glPopName();
    }
}
/**********************************************************************/
/* drawplanardevelopment - draws the development as a planar curve    */
/*    in its own view port, just as the slate.  Any time this is drawn*/
/*    it needs to be picked, therefore it contains all of the         */
/*    machinery for picking.                                          */
/**********************************************************************/
void drawplanardevelopment(void){
   GLuint selectBuf[BUFSIZE];
   GLint hits;
   GLint viewport[4];
   float oldProj[16];
   
   float colour = 0;
   
   glViewport(xt/8,yt/2,xt/2,yt/2);    /* set up the viewport */

   glMatrixMode(GL_PROJECTION); glLoadIdentity();
   /*glFrustum(-mysiz*xt/yt,mysiz*xt/yt,-2*mysiz,2*mysiz,mysiz*focal,wfar); */
   glOrtho(-1*(float)vertslatescale, 1*(float)vertslatescale,-1.0*(float)vertslatescale, 1.0*(float)vertslatescale,-10, 10);
   glMatrixMode(GL_MODELVIEW);
   glPushMatrix(); glLoadIdentity();
   glMultMatrixf(const_aff); /* MODELVIEW matrix for this viewport*/
 
   glGetIntegerv(GL_VIEWPORT,viewport); /* store the viewport */
   glGetFloatv(GL_PROJECTION_MATRIX, oldProj); /* store the proj mat */
   glMatrixMode(GL_PROJECTION);
   glPushMatrix(); glLoadIdentity();
      glSelectBuffer(BUFSIZE, selectBuf);
      (void) glRenderMode(GL_SELECT);
      glInitNames();
      glPushName(0);
      gluPickMatrix((GLdouble) XX, (GLdouble) (yt-YY), 5.0,5.0,viewport);
      glMultMatrixf(oldProj); /* restores the projection mat we want */
         /* Draw Things for picking */
         drawplanarcontrol(GL_SELECT);

      hits = glRenderMode(GL_RENDER) ;
      processhits(hits, selectBuf);
      dragtrack(BUT,XX,YY,SHIF);
   glMatrixMode(GL_PROJECTION);
   glPopMatrix(); /* pop the picking PROJECTION mat */

   drawplanarcontrol(GL_RENDER);

   /* draw the planar curve */
   glLineWidth(2);
   glBegin(GL_LINE_STRIP);
      for(ii=0; ii<DEVELPTS; ii++){ 
         colour = (float)ii/DEVELPTS;
         glColor3f(1-colour, colour, colour);
         glVertex3f(development1[ii][1], development2[ii][1], 0);
      }
   glEnd();

   /* draw car on planar curve */
   #define THISCAR  0.1
   glMatrixMode(GL_MODELVIEW);
   glPushMatrix();
      glTranslatef(development1[tt*2][1], development2[tt*2][1], 0);
      glScalef(THISCAR*0.4*vertslatescale, THISCAR*0.4*vertslatescale, THISCAR);
      glRotatef(-90, 0, 1, 0);
      drawcar();
   glPopMatrix();

   drawplanaraxis();

   glMatrixMode(GL_PROJECTION); glPopMatrix();
   glMatrixMode(GL_MODELVIEW); glPopMatrix();
}
/**********************************************************************/
/* drawcontrolpoints1 - draws the control points to the screen        */
/**********************************************************************/
void drawcontrolpoints1(GLenum mode){
    glColor3f(0.50,0.50,0.50);
    glMatrixMode(GL_MODELVIEW);

    if(mode == GL_SELECT){
       glLoadName(1);  /* for development curve 1 */
       glPushName(0);  /* push a new name on the namestack */
    }
    for(ii=0; ii<controlpts; ii++){
       if(mode == GL_SELECT){
          glLoadName(ii);
       }
       glPushMatrix();
          glTranslatef(controlPoints1[ii][0],controlPoints1[ii][1]+vertslatescale ,0);
          glScalef(1, (float)vertslatescale/4, 1);
          glutSolidCube(CUBELET);
       glPopMatrix();
    }
    if(mode == GL_SELECT){
       glPopName();
    }
}
/**********************************************************************/
/* drawcontrolpoints2 - draws the control points to the screen        */
/**********************************************************************/
void drawcontrolpoints2(GLenum mode){
    glColor3f(0.50,0.50,0.50);
    glMatrixMode(GL_MODELVIEW);

    if(mode == GL_SELECT){
       glLoadName(2); /* for development curve 2 */
       glPushName(0); /* push a new name on the name stack */
    }
    for(ii=0; ii<controlpts; ii++){
       if(mode == GL_SELECT){
          glLoadName(ii);
       }
       glPushMatrix();
          glTranslatef(controlPoints2[ii][0],controlPoints2[ii][1]-vertslatescale ,0);
          glScalef(1, (float)vertslatescale/4, 1);
          glutSolidCube(CUBELET);
       glPopMatrix();
    }
    if(mode == GL_SELECT){
       glPopName();
    }
}
/**********************************************************************/
/* drawplanaraxis - draws the axis and grid for the planar develompent*/
/*    curve.                                                          */
/**********************************************************************/
void drawplanaraxis(void){
   glLineWidth(1);

   glColor3f(0.25, 0.25, 0.25);
   /* horizontal gridlines*/
   glBegin(GL_LINES);
      for(ii=0; ii<vertslatescale; ii++){
         glVertex3f(-vertslatescale, ii, 0);
         glVertex3f(vertslatescale, ii, 0);

         glVertex3f(-vertslatescale, -ii, 0);
         glVertex3f(vertslatescale, -ii, 0);
      }
   glEnd();

   /* vertical gridlines*/
   glBegin(GL_LINES);
      for(ii=0; ii<vertslatescale; ii++){
         glVertex3f(ii,  vertslatescale, 0);
         glVertex3f( ii, -vertslatescale, 0);

         glVertex3f(-ii,  vertslatescale, 0);
         glVertex3f(-ii, -vertslatescale, 0);
      }
   glEnd();

   /* origin */
   glLineWidth(4);
   glBegin(GL_LINES);
      glColor3f(0.0, 0.0, 1.0);
      glVertex3f(-0.5, 0.0, 0.0);
      glVertex3f( 0.5, 0.0, 0.0);

      glVertex3f(0.0,-0.5, 0.0);
      glVertex3f(0.0, 0.5, 0.0);
   glEnd();
}
/**********************************************************************/
/* drawaxis - draw the axis and grid for the slate developments       */
/**********************************************************************/
void drawaxis(void){
   glLineWidth(1);

   glColor3f(0.25, 0.25, 0.25);
   /* horizontal gridlines*/
   glBegin(GL_LINES);
      for(ii=0; ii<vertslatescale; ii++){
         /* top development */ 
         glVertex3f(controlPoints1[0][0], vertslatescale+ii, 0);
         glVertex3f(controlPoints1[controlpts-1][0], vertslatescale+ii, 0);

         glVertex3f(controlPoints1[0][0], vertslatescale-ii, 0);
         glVertex3f(controlPoints1[controlpts-1][0], vertslatescale-ii, 0);

         /* bottom development */ 
         glVertex3f(controlPoints2[0][0], -vertslatescale+ii, 0);
         glVertex3f(controlPoints2[controlpts-1][0], -vertslatescale+ii, 0);
         
         glVertex3f(controlPoints2[0][0], -vertslatescale-ii, 0);
         glVertex3f(controlPoints2[controlpts-1][0], -vertslatescale-ii, 0);
      }
   glEnd();
   /* vertical gridlines */
   glBegin(GL_LINES);
      for(ii=0; ii<controlpts; ii++){
         /* top development */
         glVertex3f(controlPoints1[ii][0],2*vertslatescale, 0);
         glVertex3f(controlPoints1[ii][0],0, 0);
         /* bottom development */
         glVertex3f(controlPoints2[ii][0],-2*vertslatescale, 0);
         glVertex3f(controlPoints2[ii][0],0, 0);
      }
   glEnd();
   /* horizontal axis */
   glColor3f(0.0, 0.7, 0.9);
   glBegin(GL_LINES);
      glVertex3f(controlPoints1[0][0], vertslatescale, 0.001);
      glVertex3f(controlPoints1[controlpts-1][0], vertslatescale, 0.001);

      glVertex3f(controlPoints2[0][0], -vertslatescale, 0.001);
      glVertex3f(controlPoints2[controlpts-1][0], -vertslatescale, 0.001);
   glEnd();
}
/**********************************************************************/
/* drawcube() - Draws a cube for visual reference                     */
/**********************************************************************/
void drawcube(void){
      glColor3f(0.0,0.0,1.0);
      glLineWidth(3);
      glutWireCube(2);
      /*glutWireSphere(1,10,10); */
}
/**********************************************************************/
/* drawcontrail - Draws the contrail                                  */
/**********************************************************************/
void drawcontrail(void){
   int ii;
   glLineWidth(1);
   for(ii=0; ii<=LONGFLIGHT; ii++){
     glPushMatrix();
     glMultMatrixf(contrail[ii]);
       glBegin(GL_LINES);

         glColor3f(1,0,0);
         glVertex3f( 1, 0, 0);
         glVertex3f(-1, 0, 0);  

         glColor3f(0,1,0);
         glVertex3f( 0, 1, 0);
         glVertex3f( 0,-1, 0);

         glColor3f(0,0,1);
         glVertex3f( 0, 0, 1);
         glVertex3f( 0, 0,-1);
       glEnd();
    glPopMatrix();
    }
}  
/**********************************************************************/
/* drawdoghouse - Draws the dog house                                */
/**********************************************************************/
void drawdoghouse(void){
   /* Grab your scarf and prepare to take on */
   /* the Red Barren, Snoopy! */

    glBegin(GL_QUAD_STRIP);

      glColor3f(1.0, 0.0, 0.0); /* light red */
       glVertex3f( 0.8, 1.0, 1.5); /* walls and floor */
       glVertex3f( 0.8, 1.0,-1.5);
      glColor3f(0.5, 0.0, 0.0); /* dark red */ 
       glVertex3f( 0.8,-1.0, 1.5);
       glVertex3f( 0.8,-1.0,-1.5);
       glVertex3f(-0.8,-1.0, 1.5);
       glVertex3f(-0.8,-1.0,-1.5);
      glColor3f(1.0, 0.0, 0.0); /* light red */
       glVertex3f(-0.8, 1.0, 1.5);
       glVertex3f(-0.8, 1.0,-1.5);

      glColor3f(0.2, 0.2, 0.2); /* grey */
       glVertex3f(-0.8, 1.0, 1.5); /* left soffet */
       glVertex3f(-0.8, 1.0,-1.5);
       glVertex3f(-1.2, 1.0, 1.5);
       glVertex3f(-1.2, 1.0,-1.5);

      glColor3f(0.0, 0.5, 0.0);  /* dark green */
       glVertex3f(-1.2, 1.0, 1.5); /* roof */
       glVertex3f(-1.2, 1.0,-1.5);
      glColor3f(0.0, 1.0, 0.0);  /* bright green */
       glVertex3f( 0.0, 2.0, 1.5);
       glVertex3f( 0.0, 2.0,-1.5);
      glColor3f(0.0, 0.5, 0.0);  /* dark green */
       glVertex3f( 1.2, 1.0, 1.5);
       glVertex3f( 1.2, 1.0,-1.5);

      glColor3f(0.2, 0.2, 0.2); /* grey */
       glVertex3f( 1.2, 1.0, 1.5); /* right soffet */
       glVertex3f( 1.2, 1.0,-1.5);
       glVertex3f( 0.8, 1.0, 1.5);
       glVertex3f( 0.8, 1.0,-1.5);

    glEnd(); 

    glBegin(GL_QUADS);

      glColor3f(1.0, 0.0, 0.0); /* light red */
       glVertex3f( 0.8, 1.0, 1.5); /* back wall  */
       glVertex3f(-0.8, 1.0, 1.5);
      glColor3f(0.5, 0.0, 0.0); /* dark red */ 
       glVertex3f(-0.8,-1.0, 1.5);
       glVertex3f( 0.8,-1.0, 1.5);

      glColor3f(1.0, 0.0, 0.0); /* light red */
       glVertex3f( 0.8, 1.0,-1.5); /* front wall  */
       glVertex3f(-0.8, 1.0,-1.5);
      glColor3f(0.5, 0.0, 0.0); /* dark red */
       glVertex3f(-0.8,-1.0,-1.5);
       glVertex3f( 0.8,-1.0,-1.5);

      glColor3f(0.1, 0.1, 0.3); /* grey */
       glVertex3f( 0.4, 0.0,-1.51); /* door  */
       glVertex3f(-0.4, 0.0,-1.51); 
       glVertex3f(-0.4,-1.0,-1.51);
       glVertex3f( 0.4,-1.0,-1.51);
    glEnd();

    glBegin(GL_TRIANGLES);
      glColor3f(1.0, 0.5, 0.0); /* orange */
       glVertex3f(-1.2, 1.0, 1.5); /* back roof facia */
       glVertex3f( 0.0, 2.0, 1.5);
       glVertex3f( 1.2, 1.0, 1.5); 

      glColor3f(0.0, 0.0, 1.0); /* blue */
       glVertex3f(-1.2, 1.0,-1.5); /* front roof facia */
       glVertex3f( 0.0, 2.0,-1.5);
       glVertex3f( 1.2, 1.0,-1.5); 
    glEnd();

    glLineWidth(2);
    glBegin(GL_POLYGON);
     glColor3f(1.0, 0.3, 0.6); /* blue */
      glVertex3f( 0.81, 0.00,-0.75); /* right arrow */ 
      glVertex3f( 0.81, 0.50,-0.25);
      glVertex3f( 0.81, 0.20,-0.25);
      glVertex3f( 0.81, 0.20, 0.75);
      glVertex3f( 0.81,-0.20, 0.75);
      glVertex3f( 0.81,-0.20,-0.25);
      glVertex3f( 0.81,-0.50,-0.25);
    glEnd();

    glBegin(GL_POLYGON);
    glColor3f(0.5, 0.2, 0.7); /* blue */
      glVertex3f(-0.81, 0.00,-0.75); /* left arrow */
      glVertex3f(-0.81, 0.50,-0.25);
      glVertex3f(-0.81, 0.20,-0.25);
      glVertex3f(-0.81, 0.20, 0.75);
      glVertex3f(-0.81,-0.20, 0.75);
      glVertex3f(-0.81,-0.20,-0.25);
      glVertex3f(-0.81,-0.50,-0.25);
    glEnd();
}
/**********************************************************************/
/* drawtrackvehicles - just draws the vehicles on the track.          */
/*    Now all calculations of fram and fram2 are done in calculatefram*/
/**********************************************************************/
void drawtrackvehicles(void){
   /* On curve */
   glPushMatrix(); /* main car */
      glMultMatrixf(fram3);
      glScalef(BIGCAR,BIGCAR,BIGCAR);
      drawcar();
   glPopMatrix();

   if(showchaseplane){ /* chaseplanes on curve */
      glPushMatrix(); /* on the curve */
        glMultMatrixf(fram4);
        glScalef(BIGCAR,BIGCAR,BIGCAR); 
        drawcar();
      glPopMatrix();

      if(!cockpit){ /* don't draw if cockpit view - gets in the way */
         glPushMatrix();
           glMultMatrixf(fram5);
           glScalef(BIGCAR,BIGCAR,BIGCAR); 
           drawcar();
         glPopMatrix();
      }
   }

   /* on the lissajou */
   if(showlissajou){
      glPushMatrix(); /* main car */
         glMultMatrixf(fram);
         glScalef(BIGCAR,BIGCAR,BIGCAR);
         glColor3f(1.0, 1.0, 0.0);
         if(!cockpit) glutSolidSphere(.10, 10, 10);
         drawcar();
      glPopMatrix();

      if(showchaseplane){ /* the chasePlane */
         glPushMatrix(); 
           glMultMatrixf(fram2);
           glScalef(BIGCAR/3,BIGCAR/3,BIGCAR/3); 
           drawdoghouse();
         glPopMatrix();
      }
   }
}
/**********************************************************************/
/* drawframedlissajou - Draws the lissajou and its frame.             */
/**********************************************************************/
void drawframedlissajou(void){

   float temp0[3], temp1[3];
   if(showbishop){  /* Bishop Frame */
      for(ii=0; ii<(NUMBPTS-RAILTIE); ii+=RAILTIE){
         glLineWidth(2);
         glBegin(GL_LINES);
            /* Draw the lissajou */
            glColor3f(1.0,0.5,0.0);
            glVertex3fv(lissajou[ii]);
            glVertex3fv(lissajou[ii+RAILTIE]);
         glEnd();

            /* Scale and Translate the Normal Vector */
            temp0[0] = (lissbishopframe[ii][6]*RAILSIZE) + lissajou[ii][0];
            temp0[1] = (lissbishopframe[ii][7]*RAILSIZE) + lissajou[ii][1];
            temp0[2] = (lissbishopframe[ii][8]*RAILSIZE) + lissajou[ii][2];

            /* Draw the Railroad Tie  */
            glLineWidth(1.0);
            glColor3f(0.0,0.0,1.0); 
         glBegin(GL_LINES);
            glVertex3fv(lissajou[ii]);
            glVertex3fv(temp0);
         glEnd();

            /* Scale and Translate the next Normal Vector */
            temp1[0] = (lissbishopframe[ii+RAILTIE][6]*RAILSIZE) + lissajou[ii+RAILTIE][0];
            temp1[1] = (lissbishopframe[ii+RAILTIE][7]*RAILSIZE) + lissajou[ii+RAILTIE][1];
            temp1[2] = (lissbishopframe[ii+RAILTIE][8]*RAILSIZE) + lissajou[ii+RAILTIE][2];

	    /* connects the tips of the Railroad Ties */
            glLineWidth(1.0);
            glColor3f(0.0,0.5,1.0);
         glBegin(GL_LINES);
            glVertex3fv(temp0);
            glVertex3fv(temp1);
         glEnd();
      }
   }else{  /* Frennett Frame */
      for(ii=0; ii<(NUMBPTS-RAILTIE); ii+=RAILTIE){

         glLineWidth(2);
         glBegin(GL_LINES);
            /* Draw the lissajou */
            glColor3f(0.0,1.0,0.0);
            glVertex3fv(lissajou[ii]);
            glVertex3fv(lissajou[ii+RAILTIE]);
         glEnd();

            /* Scale and Translate the biNormal Vector */
            temp0[0] = (lissfrenetframe[ii][6]*RAILSIZE) + lissajou[ii][0];
            temp0[1] = (lissfrenetframe[ii][7]*RAILSIZE) + lissajou[ii][1];
            temp0[2] = (lissfrenetframe[ii][8]*RAILSIZE) + lissajou[ii][2];

            /* Draw the Railroad Tie  */
            glLineWidth(1.0);
            glColor3f(1.0,0.0,0.0); 
         glBegin(GL_LINES);
            glVertex3fv(lissajou[ii]);
            glVertex3fv(temp0);
         glEnd();

            /* Scale and Translate the next biNormal Vector */
            temp1[0] = (lissfrenetframe[ii+RAILTIE][6]*RAILSIZE) + lissajou[ii+RAILTIE][0];
            temp1[1] = (lissfrenetframe[ii+RAILTIE][7]*RAILSIZE) + lissajou[ii+RAILTIE][1];
            temp1[2] = (lissfrenetframe[ii+RAILTIE][8]*RAILSIZE) + lissajou[ii+RAILTIE][2];

	    /* connects the tips of the Railroad Ties */
            glLineWidth(1.0);
            glColor3f(1.0,1.0,0.0);
         glBegin(GL_LINES);
            glVertex3fv(temp0);
            glVertex3fv(temp1);
         glEnd();
      }
   }
} 
/**********************************************************************/
/* drawframedcurve - draws the curve we create and it's frame         */
/**********************************************************************/
void drawframedcurve(void){
   float temp0[3], temp1[3];
   float colour = 0;
   if(showbishop){  /* Bishop Frame */
      for(ii=0; ii<(numbpts-RAILTIE); ii+=RAILTIE){
         colour = (float)(ii*2)/DEVELPTS;

         glLineWidth(2);
         glColor3f(1, .5, 0);
         glBegin(GL_LINES);
            /* Draw the curve */
            glVertex3fv(bishopcurve[ii]);
            glVertex3fv(bishopcurve[ii+RAILTIE]);
         glEnd();

            /* Scale and Translate the Normal Vector */
            temp0[0] = (curvebishopframe[ii][6]*RAILSIZE) + bishopcurve[ii][0];
            temp0[1] = (curvebishopframe[ii][7]*RAILSIZE) + bishopcurve[ii][1];
            temp0[2] = (curvebishopframe[ii][8]*RAILSIZE) + bishopcurve[ii][2];

            /* Draw the Railroad Tie  */
            glLineWidth(1);
            glColor3f(1-colour, colour, colour);
         glBegin(GL_LINES);
            glVertex3fv(bishopcurve[ii]);
            glVertex3fv(temp0);
         glEnd();

            /* Scale and Translate the next Normal Vector */
            temp1[0] = (curvebishopframe[ii+RAILTIE][6]*RAILSIZE) + bishopcurve[ii+RAILTIE][0];
            temp1[1] = (curvebishopframe[ii+RAILTIE][7]*RAILSIZE) + bishopcurve[ii+RAILTIE][1];
            temp1[2] = (curvebishopframe[ii+RAILTIE][8]*RAILSIZE) + bishopcurve[ii+RAILTIE][2];

            /* connects the tips of the Railroad Ties */
            glLineWidth(1);
            glColor3f(1-colour, colour, colour);
         glBegin(GL_LINES);
            glVertex3fv(temp0);
            glVertex3fv(temp1);
         glEnd();
      }
   }else{  /* Frennett Frame */
      for(ii=0; ii<(numbpts-RAILTIE); ii+=RAILTIE){
         colour = (float)(ii*2)/DEVELPTS;

         /* Draw the curve */
         glLineWidth(2);
         glColor3f(0, 1, 0);
         glBegin(GL_LINES);
            glVertex3fv(frenetcurve[ii]);
            glVertex3fv(frenetcurve[ii+RAILTIE]);
         glEnd();

            /* Scale and Translate the biNormal Vector */
            temp0[0] = (curvefrenetframe[ii][6]*RAILSIZE) + frenetcurve[ii][0];
            temp0[1] = (curvefrenetframe[ii][7]*RAILSIZE) + frenetcurve[ii][1];
            temp0[2] = (curvefrenetframe[ii][8]*RAILSIZE) + frenetcurve[ii][2];

         /* Draw the Railroad Tie  */
         glLineWidth(1);
         glColor3f(1-colour, colour, colour);
         glBegin(GL_LINES);
            glVertex3fv(frenetcurve[ii]);
            glVertex3fv(temp0);
         glEnd();

            /* Scale and Translate the next biNormal Vector */
            temp1[0] = (curvefrenetframe[ii+RAILTIE][6]*RAILSIZE) + frenetcurve[ii+RAILTIE][0];
            temp1[1] = (curvefrenetframe[ii+RAILTIE][7]*RAILSIZE) + frenetcurve[ii+RAILTIE][1];
            temp1[2] = (curvefrenetframe[ii+RAILTIE][8]*RAILSIZE) + frenetcurve[ii+RAILTIE][2];

         /* connects the tips of the Railroad Ties */
         glLineWidth(1);
         glColor3f(1-colour, colour, colour);
         glBegin(GL_LINES);
            glVertex3fv(temp0);
            glVertex3fv(temp1);
         glEnd();
      }
   }
}
/**********************************************************************/
/* drawcurve - Draws the curve without a frame                        */
/**********************************************************************/
void drawcurve(void){
   float colour = 0;
      glLineWidth(2);
      glBegin(GL_LINE_STRIP);
         for(ii=0; ii<numbpts;ii++){
            colour = (float)(ii*2)/DEVELPTS;
            glColor3f(1-colour, colour, colour);
               if(showbishop) glVertex3fv(bishopcurve[ii]);
               else       glVertex3fv(frenetcurve[ii]);
         }
      glEnd();
}
/**********************************************************************/
/* drawlissajou - Draws the lissajou without a frame                  */
/**********************************************************************/
void drawlissajou(void){
   if(showbishop)
      glColor3f(1.0,0.5,0.0);
   else
      glColor3f(0.0,1.0,0.0);

      glLineWidth(2);
      glBegin(GL_LINE_STRIP);
         for(ii=0; ii<NUMBPTS;ii++){
            glVertex3fv(lissajou[ii]);
         }
      glEnd();
}
/**********************************************************************/
/* drawdevelopmentvehicle - draws the vehicle on the development to   */
/*    mark our place.                                                 */
/**********************************************************************/
void drawdevelopmentvehicle(void){
#define THISCAR  0.1
   glMatrixMode(GL_MODELVIEW);
   /* car on upper development */
   glPushMatrix();
      glTranslatef(development1[tt*2][0], development1[tt*2][1]+vertslatescale, 0);
      glScalef(THISCAR, THISCAR*0.4*vertslatescale, THISCAR);
      glRotatef(-90, 0, 1, 0);
      drawcar();
   glPopMatrix();

   /* car on lower development */
   glPushMatrix();
      glTranslatef(development2[tt*2][0], development2[tt*2][1]-vertslatescale, 0);
      glScalef(THISCAR, THISCAR*0.4*vertslatescale, THISCAR);
      glRotatef(-90, 0, 1, 0);
      drawcar();
   glPopMatrix();



}
/**********************************************************************/
/* drawtheslate - draws the Top Slate.  This does the actual drawing, */
/*    not the viewportery or picking.  It was previously just called  */
/*    drawSlate, but that is a different function now.  I know this   */
/*    is bad, but I didn't get around to changing it. ~baf            */
/**********************************************************************/
void drawtheslate(GLenum rendermode){
    if(rendermode==GL_RENDER){
       drawdevelopment1();
       drawdevelopment2();
       drawdevelopmentvehicle();
       /*drawplanardevelopment();*/
       drawaxis();
    }
    drawcontrolpoints1(rendermode);
    drawcontrolpoints2(rendermode);
}
/**********************************************************************/
/* drawall - draws the main viewport.  this is where one should toggle*/
/*    things we want to draw.                                         */
/**********************************************************************/
void drawall(void){
    if(!cockpit || showchaseplane) drawtrackvehicles();
    if(showframe){
       if(showlissajou) drawframedlissajou();
       else drawframedcurve();
    }else{
       if(showlissajou) drawlissajou();
       else drawcurve();
    }
    if(showcontrail) drawcontrail();
    if(showcube) drawcube(); 

}
/**********************************************************************/
/* deFault - Sets the default values for state variables.             */
/**********************************************************************/
void deFault(void){
th0=5; th1=355;  ta0=5; ta1=355; gap = gap0; 
msg=1; binoc=0; nose=.06; mode=TURNMODE;  
siz = 1.;
friz = 1;
speed=.05; torq=.01; focal = 2.; wfar =250.; mysiz=.01; morph=0; 
aa=1; bb=2; cc=3; dtt=caveyes?DTCAVE:DTCONS; 
FOR(ii,0,16) starmat[ii]=aff[ii] = (ii/4==ii%4);   /* identities */ 
FOR(ii,0,3)lux[ii]/=NRM(lux); amb = .3; pwr = 10. ;
aff[12]=0; aff[13]= 0; aff[14]= -4.0;   /* place where we can see it */
FOR(ii,0,16) const_aff[ii] = (ii/4==ii%4);   /* identity */ 
const_aff[14]= -5.0;   /* place where we can see it */

autotymer(1); /* reset autotymer to start at the beginning */

tt=0;
cockpit=0;
showcube=1;
showframe=1;
showlissajou=0;
showchaseplane=0;
cockpit = 0;
showbishop = 0;
autopilot=0;
showslate = 0;
dragmode = 0;
showplanar = 0;
stereomode = 0;

vertslatescale = 5;
pickedcube[0] = pickedcube[1] = -1;  /* which cube is picked */

FOR(ii,0,9) initframe[ii]=(ii/3==ii%3);  /* identity */
FOR(ii,0,3) initpos[ii]=0; /* origin */ 

/* when we were trying to recreate the lissajou */
/*FOR(ii,0,9) initframe[ii]=lissfrenetframe[0][ii]; */
/*FOR(ii,0,3) initpos[ii]=lissajou[0][ii];*/ 

/* new changable array sizes */
controlpts = CONTROLPTS;
numbpts = NUMBPTS;
paramlength = controlpts/2;

/***** these should always be last, after we set things up *******/
initpoints();      /* set up the initial pos for the points */
computecurve();    /* computes the curve for the first time */
computelissajou();
calculatefram();   /* calculates the matrix the car is drawn on */
}
 
/**********************************************************************/
/* Code for stars - do not meddle in the afairs of wizards...         */
/**********************************************************************/

#ifdef IRIX
#include <alloca.h>
#endif
#include <stdlib.h>
#include <stdio.h>
#include <math.h>
// #include <GL/gl.h>
#include <gl.h>

#define NewA(type, count)  ((type *)alloca((count)*sizeof(type)))
#define NewN(type, count)  ((type *)malloc((count)*sizeof(type)))

typedef float Matrix[4*4];
typedef struct { float x[3]; } Point;

int zoom2 = 0;		/* Flag for "enlarge stars twofold" */

 extern int    caveyes;	    /* Hope this is defined somewhere else*/
 extern Matrix s_starmat;  /* Hope this is defined elsewhere too */

void vtfmvector( Point *dst, register Point *src, register Matrix T )
{
  int i;
  for(i = 0; i < 3; i++)
    dst->x[i] = src->x[0]*T[i] + src->x[1]*T[i+4] + src->x[2]*T[i+8];
}


struct starsize {
  float size;
  int base;
  int count;
  int color;
} *starsizes;
int nstarsizes = 0;

float scolors[][3] = {
	.5, 1, 1,	/* W */
	.7, .8, 1,	/* O */
	.9, .9, 1,	/* B */
	1, 1, 1,	/* A */
	1, 1, .9,	/* F */
	1, 1, .8,	/* G */
	1, .8, .7,	/* K */
	1, .7, .5,	/* M */
};

float *starpos;

#define SRADIX  91
#define SZERO   '$'
#define SSIZE   '!'
#define SSIZESCL 8
#define SRASCALE (8192 / (2*M_PI))
#define SDECSCALE (8192 / M_PI)
#define SDECBIAS 4096
#define SCOLORBASE 0
#define SSIZEBASE  8

#define SRADIX  91
#define SZERO   '$'
#define SSIZE   '!'
#define SSIZESCL 8
#define SRASCALE (8192 / (2*M_PI))
#define SDECSCALE (8192 / M_PI)
#define SDECBIAS 4096
#define SCOLORBASE 0
#define SSIZEBASE  8


/* 1128 real stars, to about visual magnitude 4.7 */
/* from  star2illi -m 4.7 -d 1.2 -c 3.5 */
char stardata[] =
  /* Show Pleiades at upper right, Orion at center of field */
"#@ -.98525 .062202 .1594 0  .16485 .095488 .98169 0  .045842 .99349 -.10433  0 0 0 1\n"
"!<'=BH_"
"!:(<$6`"
"!9'iodI!9&7`Lw!9)Z~2Y7mh&!9*YQZ["
"!8&*.4G!8(@eS\\!8+:7Te"
"!7'nLUM!7&Xh2oVCKK!7*5;Y=!7+arCl"
"!6'z/B6q[g`!6&S~33J'W$!6*A,_'Z~2Y"
"!5'@J`{@J`{FY.1!5&>3BTRa1Mes>N8BT58H_A9&PIw'9S!5+R{4M"
"!4'TGm$:OgQ<sY7Dm5_ezW?!4&i&?nWgiap]4^;xH'j|Cr$T_W9gL4Ra1M!4(0jiz>kCn"
"f-;R-Q}`!4*MQouCJ3:c).PGPLb+z\\h&fH&Xy>o[bv-!4+(Ebo!4%9?P'!4$B[9C"
"!3'PBX?S[8S^K^FFo3EV;lPMFm7!3&/ieQ8iPrW;6=[09AZg;y`'EdfJ=Q!3(pIe1$XnZ!3*"
"F<;>&Tm>g@ji+hf5c2?r%_;ruTU{!3+y59W!3%B9=%"
"!2'dJI2P]kssyp@N1[=bCKfkKB*:Pc]+3[J)Eo0!2&?iBE'VoFzXX\\G15QX99ER$H9QU7_"
"]BLA`DG.99?}\\4;LSC.Lec>D!2(8mH-!2)S3E@X4Z7LK8?!2*qwb$JiZy_'T96XaZ?B>N"
"[B^VhoB,n2VA!2+zR_)/HS)"
"!1'V)>_[cH~7:NOueHz]M.`TSd4Hd0Ok[Wz,-bR!1&L60m^N<JQ{3]b;Bv$oX[2^`{28]*"
"n+gY2se&_zCzaCD7?{U2RtHhei8*9.[Z!1(BPDr_e1>+K28ktFR6tfx!1)aSokav[ieak3"
"%[*FbZ`nTvVQ8SF]tgN9/Vkjy7`/vtPr=;]YH]\\vUzEK!1*fPS?i<D?eD5:wb2s=]7cgtAm"
"Q_Ed!1+`wO3;z\\=2tJ;!1%8|N)"
"!0'ZSd3]WtyEdi(dd]K[30S!0&1yhwv1>A;kA}>LE,Ws;jSv.{c;=}OQ1Q\\7;{73e^<s;I"
"dAqtjFCS][<bofP[tWt@k6aD!0(fg<ypBI\\Gnjr6/TQ!0)l)rrEOS~sY`0a3N`!0*Msg<"
"m5_$L\\HwqE9E9z?/G+b8Ge4Pcb5%ddcK7-Eoc\\Udft>P|gwp@,;DhqOW!0+,eOSJvejh\\>]"
"27+u"
"!/'505P=S2'yyI-Q}mUN2XfVyPe4lXz/1<rqo/vJYfO.7R]yW7D!/&e1DR7WHwJE-~KR23"
"eD4n8>On]b:`+2pry.VKWr<3`&=mFL3Sk`NXj_ad3(W;Am6S!/(dT;G=CWNlrRX+*_mJV\\f!/)(09_ACDX3v1jCvoFDyT8]'6{fa^s'*mx]9aay_]A*RI("
"\\Ge7!/*&N`MXwCa]onRkdC4gNL0w6n/JY2Cqqoy(>Kx>EC(NJaW!/+;L\\<\\SDETPRe/XdK"
")T;DnzZidbX7"
"!.'HBU|I|YH_EO?w2T.9cI[?GY==mb$E~hZP./^Xlq7_2Xf_LS;[IQ{!.&i6:&IA5fYf9}"
",U7:4/@.c>>$7rMYDT6Vee2`zHf5.]^_2B](&@k|^bB/gy7{Dg@J67Sn2)]+6HR9!.(?S\\$"
"f.I@hpuG9UEkGb<jPKQuqEX@S\\P>GfpVS\\P>^$_Wu=Ha:>Ixscd(!.)4lZ[bcdOOAA+NOI\\"
"oW/wA']7p1Jg0mUT)eXcHY1i+;76gF_^nfT7!.*k/FNC(U[y]r/1{L0%8L[]]>s*0iBZR`6"
"^YBzRC2m);LxA,>&J4JpTv-9cK;of]0_4:XorM3kzrFK{CR_P1hw:Ol2s+f}!.+0OF0!.%"
"8{U}"
"!-'g}UlaGZZfiREr$L<xOj2m/jtFycJazR$wsPA9e7OJK;zSE8g'Vd<R;PbC\\O*36T$Du9}!-&0{UtqQX|f9h&2&a2XI;{g~_HEM2b^y^3?5C]KWU`hFFO2/]6S(,yS-swXK:[]%8^F`R3_oBHNX5ia;h4"
"Ri7u!-(xCn98r1iv{]c2+f@>S[?HznU^LV=^LV=K;3^DV9bKq8u_lXq0%BS[7N4nVQS!-)"
"tLEmkWF0lCkd?s^wJiZy9|FX59Af|\\h;n=t2;u@>`}13Vd=@b.)VMl3S^PI\\!-**|Kq1@L>"
"AS<e6weWF&9Mg.mM4LYlc03PuE*@C\\/y>m-hLr3YoshG/qgLK1HZLqb/[R)O4lY$i$[v2%0["
"ieLu3t;rg>c^5HIr8d?==uDw$Z:0I)^%/'LWnlbWzx:GH;PL!-+ynM8.al|n9Z=O8sb!-%"
"94Oe"
"!,'(=5Gck`PsiS^5=OC@pL9l]H,%^;3DmZ,NiV=rZe[)d8O.ukH<mGG@s,dV;lO_M@5yK\\m4R@$"
":M;Z=\\@hA$BTQg6o`LFao),U9}dZDS?DEmewFN1qgWROli<cxD;;{dF{+eu9;KMt?@/'o~ht{E3u"
"+RFN.s8*Ew/mK'+~[0>.,YazE3C2VClR`0n?`jG=j7->lb:jpr`6y\\J7}}TM5qOGDx_HQUD^a;7y"
"k:XVkFN1tugnxfP{6|o:P0T=TK4JgrR<q-V`2ybw3Vht3hMZR31$j}f~/oioNYT'Ym>*Z,jzZt8>"
"[:?K\\n:E&{]1@R^Ncg6J*PjE-|Q46TWj=uJ~C3*UDk;bWrXw]E3[s1HHGw3GM:GrNnH3YSN%t2Zw"
"uPnI"
"!+'*)ee,r.a/IE69*U__@Z+-}.s.(=+15WPAB9oKf)dP32IR./&^W/qkr>)ku=Cr;CVxG;0.<i^"
":`Up>QI6H}IYQCUFzB6]iA8Onf<+uW]pwScu|jSo3yi88;M.DE;S^A`dqvDF|lg5<A[/?$PiQL0c"
"_]H^_s^MyH(@&*pP:i\\_DESrb>?GwXM/2C>veJDwy*CP22\\~@+`vYUh)Wr?kYAKtjF[>wNmUyLW-"
"8bS~AnEXb1f91*n~9?P'K;cEz&@g{<LO4Z\\3hntbjNN^jk1wpspSqs`FtJ0A{3M~%;0W.`d41Ui/"
"25EGW\\@P`K>[a}?`buz'nKaOsrdeuciaAZ8{bd*:p/Ji"
"!*'(?|1(Ch^-592.<J+4%7<59V-5?e_CLf[E`VyK7AOZ9vs*ZUY:Rg}R2)CS/ecUR^{X\\Ql`WgP"
"fDJX.@V*0Q;O1EF55GW=7BL^B[9BTD<wU68)]J9*qyY*vxJ+'yT{-<U:1WQ74_\\J5_\\P@|_NK|57"
"PX@)a{Hdt3HZzd;;|&T73Jj53}UN4ZY}6Gr67}JJH+yceOB+f)=cle:[u\\oXviqCw1a[xQ@p|`f_"
"2+];DeReOXP[jxcNorm?'`BBGg\\QS%Hw]lcd5TG4@&UPDwJ9PE1.Z6'3[g;7_&wx`OFXqJPN(LlZ"
"+]RH<QE?DV3/Q61CTB8TYk4n^^;fe*JYhic(BVOSFj4:X\\:7]FAyeKS+uVYcuY@Q/}Zt9V00;O_j"
">,n9BR.cC?*<H*8BZ2:Ah)13&@as&e4=13i&3?\\)63UN7YJU:D?EE'SxRc_1Xu<Jek|Ah*[Jh|2;"
"jAcnjMZ.l>d+mWPFxEhs%|1S&I_a,AUL;U?L>%HPJ$V%mjZ&mpYio$?E|B>-"
"!)'8jZAUGN:cHV-6@N><c6SB2R4M=;ue+FMl0dZoXwtt%6={GLJ{vFb=]66?KDTBXGG\\LR)vG5R"
"{r\\e$/N$+.9r8yUi:2[2>{`1Av8GNH`k[`C&ec^+gJ`.zjve{M@g'X\\f/1<r20J{:}XHMI[.Y{=;"
"ZV7kadGkr$NQxAQ$'(Tm3{M5<tGu[,Wt_3TcpRa.qgXVsubNw~k0$wGU*CSi4'3D;~S@Bu<pDKRb"
"k+/Gm*]D5U<+7TK+@GErBe=6C3>aEi<GKg49LF(gb&F=g]Q`l:ucmHTd.X@m7YRLG?^.PN:JZb_u"
"vv=9y)g2ym@W.AGf0T_U2Dqk6Yku6`Qs=QR8N?O5QS7aae99zcE0;;X/;gnT<<@eF+,dF@jnI}b^"
"M~EZmVj/x90S"
"!('4_Xo=;W]?(9]AV=XDx4\\J$Po\\,NpsaV%wGdt|zIg<WTb@bC[A<D(Gyk(Jn4}L~]GWeYgaSF~"
"s8DRw(@S|vQv~&07(P`).Q_^3)1x5-B/9s4xGY?']f3Co6r{qj7(qrmnsFKBtWF.xKfX%1cI-Are"
"9od[H82CYdJB^rZqe:cZnoCKp$^xzdUf{)ie'.eW.fbV:ROO@Z?TP<[/V42SV<0gh8:'q}c;zSRx"
"%}1S&li2+]tO1/nN7uad<cET@/W%YDjw\\U^Q]&G/]e>X^R:TeKNOfgC,}amj$9HC7'?<><wSGvc8"
"[fZWa@Dxs5hq|,WH2x2@F3d:GwsyX$@RZ1:HuGtb"
"!''97S*GiPJJg5PL92fa[X'h&Bkt^\\pwph>x)ii}BBz1X<s:,^oF<D+H~9ffGu-n[])o5C2&Y9|"
"1y>D8KRW8|NZ@}BmI%l)_\\DC`kC(e~9ijy\\Ckl<ilWqtr=^WxAQ$<@MQDSq5GYO]IoJOM)>LN(2q"
"UT3([CYQ\\.q~]q=^mWDX{W\\t$BN3%*dE41j3B$GnMa1ll]I'q1b^+-R[8hME@bC[DgMHFh>?OK5s"
"TK3K^HK}_Wf:f0L{gVO3k'S.'Un[/7[b/7[b/{do2Itb:h[+AX86MXTbN7\\W_E^(`94.ahLoxrjl"
"!&'6z[m??C*?xi]@OBoSR=%^p:a_MD0gUS6g}UFiO1ri\\;qo,^u(\\]@2\\Dd5/XL6LV,:01N=xW["
"@4ATSw4iWb7>W}qF`88Gc0K\\dsc`h_CPzTj((N[T.8^s3$E$=*U|?1Cp?H>^De[hK845Ky3JQ*TA"
"SNM%Sa8ZW@lEjenelxQ4x-Qd}t]Y*qKa1,ik:uIUFLpk^h?mgSYGrq@tuIj["
"!%'7(Xe=}FzB,P@H3SCa>)_i$LUm>srq8XCu,G=+5/4+kBE4aXF5NX|ET6_G7BZGNEpSs2SViMu"
"gpB8mf`,sJV+u0M,vfOyvf4\\y:GZzuEk"
;

static int slow_stars = 0;

void initstars() {
  char *cp;
  float ra, dec, cd;
  int maxstars = 5000;
  int maxsizes = 32;
  float *stars = NewA(float, maxstars*3);
  float *starp;
  int nstars = 0;
  struct starsize *sizes = NewA(struct starsize, maxsizes);
  struct starsize *sizep;
  int i, nsizes = 0;
  char line[512];
  FILE *inf = fopen("stars.illi", "r");
  float r = caveyes ? 90. : 1.;
  const GLubyte *rend = glGetString(GL_RENDERER);
  Point sp;
  static Matrix startfm = { 0,0,-1,0, -1,0,0,0, 0,1,0,0, 0,0,0,1 };

  if(rend==NULL || (rend[0]=='X'||rend[0]=='G'))
    slow_stars = 1;

  starp = &stars[0];
  sizep = &sizes[0];
  sizep->size = 1;
  sizep->base = 0;
  sizep->color = 3;
  nsizes = 0;
  cp = stardata;
  do {
    if(inf) {
	line[sizeof(line)-1] = '\0';
	if(fgets(line, sizeof(line)-1, inf) == NULL)
	    break;
	cp = line;
    }
    for(;;) {
      if(*cp >= '$') {
	if(nstars >= maxstars-1) {
	    maxstars *= 3;
	    starp = NewA(float, 3*maxstars);
	    memcpy(starp, stars, nstars*3*sizeof(float));
	    stars = starp;
	    starp = &stars[nstars*3];
	}
	ra = ((cp[0] - SZERO)*SRADIX + (cp[1] - SZERO)) / SRASCALE;
	dec = ((cp[2] - SZERO)*SRADIX + (cp[3] - SZERO) - SDECBIAS) / SDECSCALE;
	cd = cos(dec);
	sp.x[0] /*starp[2]*/ = -r * cd * cos(ra);
	sp.x[1] /*starp[0]*/ = -r * cd * sin(ra);
	sp.x[2] /*starp[1]*/ = r * sin(dec);
	vtfmvector( (Point *)starp, &sp, startfm );

	cp += 4;
	starp += 3;
	nstars++;
      } else if(*cp == '#') {
	/* Comments.
	 * Also, "#@" hack allows specifying star transformation.
	 */
	if(cp[1] == '@') {
	  cp += 2;
	  for(i = 0; i<16; i++)
	    startfm[i] = strtod(cp, &cp);
	  cp--;
	}
	while(*++cp != '\n' && *cp != '\0')
	    ;
      } else if(*cp == '!') {
	sizep->count = nstars - sizep->base;
	if(sizep->count > 0)
	    nsizes++, sizep++;
	if(nsizes >= maxsizes) {
	    maxsizes *= 3;
	    sizep = NewA(struct starsize, maxsizes);
	    memcpy(sizep, sizes, nsizes*sizeof(struct starsize));
	    sizes = sizep;
	    sizep = &sizes[nsizes];
	}
	sizep->size = (cp[1] - SZERO) / (float)SSIZESCL;
	sizep->color = (cp[2] - SZERO);
	sizep->base = nstars;
	cp += 3;
      } else if(*cp == '\0') {
	break;
      } else {
	cp++;
      }
    }
  } while(inf || *cp != '\0');
  sizep->count = nstars - sizep->base;
  nstarsizes = nsizes+1;
  starsizes = NewN(struct starsize, nstarsizes);
  memcpy(starsizes, sizes, nstarsizes*sizeof(struct starsize));

  starpos = NewN(float, 3*nstars);
  memcpy(starpos, stars, nstars*3*sizeof(float));
}

  void drawstars(float * lstarmat) {
  int s, i;
  float v, size;
  struct starsize *sp;
  float *starp;

  if(getenv("NOSTARS"))
    return;
  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();
  if(!slow_stars || zoom2)
    glEnable(GL_POINT_SMOOTH);
  glDisable(GL_DEPTH_TEST);
  glMultMatrixf(lstarmat);
  for(i = nstarsizes; --i >= 0; ) {
    sp = &starsizes[i];
    size = zoom2 ? 2*sp->size : sp->size;
    glPointSize( size );
    v = size < 1 ? size : 1 - (ceil(size) - size) * .25;
    glColor3f(	v*scolors[sp->color][0],
		v*scolors[sp->color][1],
		v*scolors[sp->color][2] );
    glBegin(GL_POINTS);
    for(s = sp->count, starp = &starpos[3*sp->base]; --s >= 0; starp += 3)
	glVertex3fv( starp );
    glEnd();
  }
  glPopMatrix();
  glDisable(GL_POINT_SMOOTH);
  glEnable(GL_DEPTH_TEST);
}
/**********************************************************************/
/* arguments - Handles the command line arguments                     */
/**********************************************************************/
#ifdef IRIX
void arguments(int argc,char **argv){
  extern char *optarg;
  extern int optind; 
  int chi;   
  /* w: needs ONE number after -w, c<nothing> means NO number follows*/ 
  while ((chi = getopt(argc,argv,"cw:d:g:")) != -1) 
  switch(chi)  {
                case 'c': caveyes=1; break;
                case 'w': win=atoi(optarg); break; 
                case 'g': gap0=atof(optarg); break;
                }
  if (optind!=argc) fprintf(stderr,"%s: Incorrect usage\n",argv[0]);
}
#endif
/**********************************************************************/
#ifdef WIN32
void arguments(int argc,char **argv){           /* Pat Hanrahan 1989 */
      while(--argc){++argv; if(argv[0][0]=='-')switch(argv[0][1]){
      case 'w': win =atoi(argv[1]); argv++; argc--; break; 
      case 'g': gap0 =atof(argv[1]); argv++; argc--; break;
      case 'L': lux[0]=atof(argv[1]);
                lux[1]=atof(argv[2]);
                lux[2]=atof(argv[3]); argv +=3; argc -=3; break;
   }}}
#endif
/**********************************************************************/
/**********************************************************************/
/* Stuart Levy  1998  improved gadgets  getnumber, bump               */
/**********************************************************************/
float getnumber(float dflt){    /* dflt is an action or a constant */ 
      if(!hasnumber)return dflt;  /* in case no number to put in */
      tmp = sign ? -number : number;  
      return decimal>0 ? tmp/(float)decimal : tmp ;
}
/**********************************************************************/
void bump(float *val, float incr){ /* use bump(&nose, .01) for example */
     float abs = fabs(incr); char  frmt[8], code[32]; int digits = 1; 
     if(hasnumber){ *val = getnumber(0); return; }
     if(abs <= .003) digits=3; else if(abs <= .03) digits=2;
     sprintf(frmt, "%%.%de" , digits);
     sprintf(code, frmt, incr >0 ? (*val)*(1+abs):(*val)/(1+abs));
     sscanf(code, "%f", val); 
}
/**********************************************************************/
/* keyboard - handles input fromt the keyboard.                       */
/*   I needed more keys, so I commented out some of the classic skel  */
/*   state variables and stole their keys.  ~baf                      */
/**********************************************************************/
void keyboard(unsigned char key, int x, int y){
     #define  IF(K)            if(key==K)
     #define  PRESS(K,A,b)     IF(K){b;}IF((K-32)){A;}  
     /*was backwards in previous versions */
     #define  TOGGLE(K,flg)    IF(K){(flg) = getnumber(1-(flg));}
     #define  CYCLE(K,f,m)     PRESS((K), \
              getnumber((f)=(((f)+(m)-1)%(m))), getnumber((f)=(++(f)%(m)))) 
   /* Only ASCII characters can be processes by this GLUT callback function */ 
   IF(27)exit(0);                                         /* ESC exit            */
   TOGGLE('v',showslate);                                 /* cross-eyed STEREO*/
   CYCLE(' ', mode,TURNMODE+1);                           /* fly/turn modes      */
   /*TOGGLE('h',morph); */                                /* autotymer on/off    */
   TOGGLE('w',msg);                                       /* writing on/off      */
   /*PRESS('n', bump(&nose, -.001), bump(&nose,.001))*/   /* for binoculars      */
   PRESS('s', bump(&speed,-.02), bump(&speed,.02))        /* flying speed        */
   PRESS('q', bump(&torq, -.02),  bump(&torq,.02))        /* turning speed*/
   /*PRESS('o', bump(&focal,-.1) ,   bump(&focal,.1))*/   /* telephoto    */ 
   /*PRESS('i', bump(&mysiz,-.1) ,   bump(&mysiz, .1))*/  /* rescale the world   */
   /*PRESS('p', bump(&wfar, -.01) , bump(&wfar, .01))*/   /* rear clipping plane */
   PRESS('z', deFault(), deFault())                       /* zap changes         */
   /*PRESS('g',bump(&gap, -.1), bump(&gap,.1))*/          /* gap parameter      */
   /*PRESS('m',bump(&amb, -.1), bump(&amb,.1))*/          /* ambient fraction   */
   /*PRESS('r',bump(&pwr, -.1), bump(&pwr,.1))*/          /* pseudo-spec power  */
   TOGGLE('i', showlissajou)                              /* Show the lissajou */
   TOGGLE('f', showframe)                                 /* Show the frame */
   TOGGLE('u', showcube)
   TOGGLE('k', cockpit)
   TOGGLE('d', showbishop)
   PRESS('t', updateTT(0, autopilot), updateTT(1, autopilot))
        /*move along one step at a time, or change the autopilot speed */
        /* or change the speed, depeding on autopilot */
   PRESS('a', {aa -= 1; computelissajou();}, {aa=aa+1; computelissajou();})  
   PRESS('b', {bb=bb-1; computelissajou();}, {bb=bb+1; computelissajou();})
   PRESS('c', {cc=cc-1; computelissajou();}, {cc=cc+1; computelissajou();})
   TOGGLE('y', autopilot)
   TOGGLE('e', showchaseplane)
   TOGGLE('l', showcontrail)
   TOGGLE('n', binoc)
   PRESS('x',vertslatescale--;, vertslatescale++;)   /* slate scale along y axis  */
   PRESS('o', /*appenddevelopmentfile()*/;, opendevelopmentfile();)
   PRESS('r', savedevelopmentfile();, savedevelopmentfile();)
   TOGGLE('p', friz)
   TOGGLE('h', showplanar)
   PRESS('m', morecontrolpoints(1);, morecontrolpoints(0);)
   /* letters that are not in use: g */

/* Stuart Levy's gadget parser from avn.c */ 
   if(key >= '0' && key <= '9'){ hasnumber = 1; 
         number = 10*number + (key - '0'); decimal *= 10;}
   else if(key == '.'){ decimal = 1;}
   else if(key == '-'){ sign = -1;}
   else {hasnumber = number = decimal = sign = 0;}
   glutPostRedisplay(); 
}
/**********************************************************************/
/* special_keybo - handles non-ASCII keypresses                       */
/**********************************************************************/
void special_keybo(int key, int x, int y){
/*non-ASCII keypresses go here, if you're lucky enough to know their names */
  if (key==GLUT_KEY_F1){
        if (stereomode) turnoffstereo(); else turnonstereo(); }

 fprintf(stderr," non-ASCII character was pressed.\n");
 fprintf(stderr," use special_keybo() to process it\n");
}
/**********************************************************************/
/* speedometer - Calculates framerate                                 */
/**********************************************************************/
#ifdef WIN32
float speedometer(void){                      /* this one is for win32*/ 
  double dbl; static double rate; static int ii=0;
  static struct _timeb lnow, lthen;
    if(++ii % 8 == 0){                 /* 8 times around measure time */
	   _ftime(&lnow);
		dbl =  (double)(lnow.time - lthen.time)
			 +(double)(lnow.millitm - lthen.millitm)/1000;
		lthen = lnow;  rate = 8/dbl;
      }
    return((float)rate);
}
#endif
/**********************************************************************/
#ifdef IRIX
float speedometer(void){
double dbl; static double rate; static int ii=0;
static struct timezone notused; static struct timeval now, then;
   if(++ii % 8 == 0){  /* 8 times around measure time */
      gettimeofday(&now, &notused); /* elapsed time */
      dbl =  (double)(now.tv_sec - then.tv_sec)
         +(double)(now.tv_usec - then.tv_usec)/1000000;
      then = now;  rate = 8/dbl;
      }
   return((float)rate);
}
#endif
/**********************************************************************/
/* char2wall - ??                                                     */
/**********************************************************************/
void char2wall(float x,float y,float z, char buf[]){
     char *p; glRasterPos3f(x,y,z);
     for(p = buf;*p;p++) glutBitmapCharacter(GLUT_BITMAP_9_BY_15,*p);
}
/**********************************************************************/
/* messages - writes text on the screen                               */
/**********************************************************************/
void messages(void){     
  char buf[256]; /* console messages are done differently from cave */
#define  LABEL2(x,y,W,u) {sprintf(buf,(W),(u));char2wall(x,y,0.,buf);}
  glMatrixMode(GL_PROJECTION); glPushMatrix(); glLoadIdentity();
  gluOrtho2D(0,3000,0,3000);
  glMatrixMode(GL_MODELVIEW); glPushMatrix(); glLoadIdentity();

    /*bull's eye*/
      /* complicated colors */
      if(showslate){
         if(showbishop) glColor3f(1, 0.5, 0);
         else       glColor3f(0, 1, 0);
      }else{
         if(mode==TURNMODE) glColor3f(0x22/255.,0x88/255.,0xdd/255.);
         else      glColor3f(.8,.8,.8);
      }

      LABEL2(1499,1500,"%s","o");
    /* writings */
      if(showslate){
         if(showbishop) glColor3f(1, 0.5, 0);
         else       glColor3f(0, 1, 0);
      }else{
         if(mode==TURNMODE) glColor3f(1, 0, 1);
         else      glColor3f(1, 1, 0);
      }
      LABEL2(80,80,"%4.1f fps",speedometer());
      LABEL2(80,2840,\
      "(ESC)ape (MAUS2)Fore (BAR)Flymode %s (W)riting (P)ause",
             mode?"FLYING":"CONTROL");
      LABEL2(10,10,"showbishop by Farmer, 24 July 2002. Modified version of showbishopCoaster %s","");
      LABEL2(80,2700,"(S)peed  %0.3f",speed);
      LABEL2(80,2650," tor(Q) %0.3f",torq);
      LABEL2(80,2600,"(Z)ap %s","");
      LABEL2(80,2550,"c(U)be %0.3f",showcube);
      LABEL2(80,2500,"(F)rame %0.3f",showframe);
      LABEL2(80,2450,"coc(K)pit %0.3f",cockpit);
      LABEL2(80,2400,"showbishop (D) %1i",showbishop);
      LABEL2(80,2350,"(A)ngle %0.3f",aa);
      LABEL2(80,2300,"(B)ngle %0.3f",bb);
      LABEL2(80,2250,"(C)ngle %0.3f",cc);
      LABEL2(80,2200,"autop(Y)lot %1i", autopilot);  
      LABEL2(80,2150,"(T)ime = %1i", tt); 
      LABEL2(80,2100,"d(T)t = %3i", dtt); 
      LABEL2(80,2050, "(V)Slate %1i", showslate);
      LABEL2(80,2000, "chas(E)plane %1i", showchaseplane);
      LABEL2(80,1900, "leave a contrai(l) %1i", showcontrail);
      LABEL2(80,1850, "draw the l(I)ssajou %1i", showlissajou);
      LABEL2(80,1800, "(O)pen the development file %s","");
      LABEL2(80,1750, "w(R)ite the development file %s","");
      LABEL2(80,1700, "bi(N)oc %i", binoc);
      LABEL2(80,1650, "(M)ore control points %s", "");
      LABEL2(80,1600, "s(H)ow planar development %1i", showplanar);
    glPopMatrix();
glMatrixMode(GL_PROJECTION); glPopMatrix();
} 
/**********************************************************************/
/* dragtrack - the picking tracker. This handles what happens when    */
/*    a control point has been picked.                                */
/**********************************************************************/
void dragtrack(int but, int xx, int yy, int shif){
        float dx,dy,dz, vv[3];
        dx =0.006*vertslatescale*(float)(xx-mousePosition[0]);  /*displacement of mouse*/
        dy =-0.006*vertslatescale*(float)(yy-mousePosition[1]);

        mousePosition[0]=xx;
        mousePosition[1]=yy;
        mousePosition[2]=0;

        /* move the control point */
        if(dragmode){
           if(pickedcube[0] == 1){ /* we picked a cube in devel1 */
              controlPoints1[ pickedcube[1] ][1] += dy;
              computecurve();
           }else if(pickedcube[0] == 2){ /* we picked a cube in devel2 */
              controlPoints2[ pickedcube[1] ][1] += dy;
              computecurve();
           }else if(pickedcube[0] == 0){ /* we picked a cube in planar development */
              controlPoints1[ pickedcube[1] ][1] += dx;
              controlPoints2[ pickedcube[1] ][1] += dy;
              computecurve();
           }else{} 
        }
        /*fprintf(stderr,"dx = %0.3f, dy = %0.3f, pickedcube[1] = %3i \n", dx, dy, pickedcube[1]);*/
        /*fprintf(stderr,"x = %3i, y = %3i \n", xx, yy );*/
}
/**********************************************************************/
/* processhits - decides which object is to be the picked object      */
/**********************************************************************/
void processhits(GLint numbHits, GLuint buffer[]){
   unsigned int  ii, j;
   GLuint names, *ptr ;
   unsigned int whichgroup;
   GLuint biggestZ, currentZ, id;
   biggestZ = currentZ = whichgroup = id = 0;
   
   if(dragmode){ return;}  /* if we have annother point selected */

   if(numbHits!=0){      /* if we have a hit */
      /* we know that if each object has exactly 1 name  */
      /* @ 4*i we have the number of names for the ith hit */
      /* @ 4*i+1 we have the minZ vaule of the ith hit   */
      /* @ 4*i+2 we have the maxZ vaule of the ith hit   */
      /* @ 4*i+3 we have which set the object belongs to */
      /* @ 4*i+4 we have the name of the object we hit   */
      /* I ASSUME EACH OBJECT HAS EXACTLY 2 NAMES        */

      /* compare the minZ values */
      biggestZ = buffer[1];  
      whichgroup = buffer[3];
      id = buffer[4];
      for(ii=0; ii<numbHits; ii++){
         if(biggestZ<buffer[ii*4+1]){
            biggestZ = buffer[ii*4+1];
            whichgroup = buffer[ii*4+3];
            id = buffer[ii*4+4];
         }
      }

      pickedcube[0] = whichgroup;
      pickedcube[1] = id;
      /*fprintf(stderr,"There was a hit \n");*/
   }else{
      pickedcube[0] = -1;
      pickedcube[1] = -1;
   }

}
/**********************************************************************/
/* chaptrack - Handles mouse input durring FLYMODE/TURNMODE           */
/**********************************************************************/
void chaptrack(int but,int xx,int yy,int shif){  
   long dx,dy; 
   dx = xx -.5*xt; dx = abs(dx)>5?dx:0;
   dy = yy -.5*yt; dy = abs(dy)>5?dy:0;

   if(friz || showslate) return; /* freeze if we are in slate mode or friz */

   glMatrixMode(GL_MODELVIEW); glPushMatrix(); glLoadIdentity();

   if(mode==TURNMODE) glTranslatef(aff[12],aff[13],aff[14]);
   glRotatef(dx*torq,0.,1.,0.); glRotatef(dy*torq,1.,0.,0.);
   if(but&(1<<GLUT_RIGHT_BUTTON ))glRotatef(shif?-10:-1,0.,0.,1.);
   if(but&(1<<GLUT_LEFT_BUTTON  ))glRotatef(shif?10:1,0.,0.,1.);
   if(mode==FLYMODE){
      glPushMatrix();
      glMultMatrixf(starmat);
      glGetFloatv(GL_MODELVIEW_MATRIX,starmat);
      glPopMatrix();
   }
   if(but&(1<<GLUT_MIDDLE_BUTTON)) glTranslatef(0.,0.,shif ? -speed : speed);
   if(mode==TURNMODE) glTranslatef(-aff[12],-aff[13],-aff[14]);
   glMultMatrixf(aff); 
   glGetFloatv(GL_MODELVIEW_MATRIX,aff);
   FOR(ii,0,3){luxx[ii]=0; FOR(jj,0,3)luxx[ii] +=aff[ii*4+jj]*lux[jj];}
   glPopMatrix();
}
/**********************************************************************/
/* viewfrom - Handles the changes for riding in the cockpit           */
/**********************************************************************/
void viewfrom(int lcockpit){  /* was just "cockpit" but CAVE macro failed here */
    if(!lcockpit){
      drawstars(starmat);
      if(binoc) glTranslatef(-binoc*nose,0.0,0.0); 
      glMultMatrixf(aff);
   }else{
    float inv[16];
                       /* if there is showchaseplane, view from it */ 
       if(showlissajou) invert(inv, showchaseplane? fram2: fram); 
              /* if we don't show the lissajou, view from the curve */
       else             invert(inv, showchaseplane? fram5: fram3); 

       glTranslatef(0.,-BIGCAR,0.); /* moves the head above the track */ 
      glMultMatrixf(inv);
      glPushMatrix();
         glScalef(9,9,9);  /*makes sure stars stay a good size*/
         drawstars(starmat);
      glPopMatrix();
  }

}
/**********************************************************************/
/* drawslate - creates the slate viewport, sets up the picking        */
/*    machinery, and calls the proper drawing functions.              */
/**********************************************************************/
void drawslate(void){
   GLuint selectBuf[BUFSIZE];
   GLint hits;
   GLint viewport[4];
   float oldProj[16];
   
   glViewport(xt/2,0,xt/2,yt);    /* set up the viewport */

   glMatrixMode(GL_PROJECTION); glLoadIdentity();
   /*glFrustum(-mysiz*xt/yt,mysiz*xt/yt,-2*mysiz,2*mysiz,mysiz*focal,wfar); */
   glOrtho(-6, 6,-2.0*(float)vertslatescale, 2.0*(float)vertslatescale,-10, 10);
   glMatrixMode(GL_MODELVIEW);
   glPushMatrix(); glLoadIdentity();
   glMultMatrixf(const_aff); /* MODELVIEW matrix for this viewport*/
 
   if(!showplanar){  /* if the planar devel is drawn, pick from it instead */
      glGetIntegerv(GL_VIEWPORT,viewport); /* store the viewport */
      glGetFloatv(GL_PROJECTION_MATRIX, oldProj); /* store the proj mat */
      glMatrixMode(GL_PROJECTION);
      glPushMatrix(); glLoadIdentity();
         glSelectBuffer(BUFSIZE, selectBuf);
         (void) glRenderMode(GL_SELECT);
         glInitNames();
         glPushName(0);
         gluPickMatrix((GLdouble) XX, (GLdouble) (yt-YY), 5.0,5.0,viewport);
         glMultMatrixf(oldProj); /* restores the projection mat we want */
            /* Draw Things for picking */
            drawtheslate(GL_SELECT);
  
         hits = glRenderMode(GL_RENDER) ;
         processhits(hits, selectBuf);
         dragtrack(BUT,XX,YY,SHIF);
      glMatrixMode(GL_PROJECTION);
      glPopMatrix(); /* pop the picking PROJECTION mat */
   }
   drawtheslate(GL_RENDER);

   glMatrixMode(GL_MODELVIEW);
   glPopMatrix();  /* pop the matrix on the MODELVIEW stack */
}
/**********************************************************************/
/* reshaped - handles window resizing                                 */
/**********************************************************************/
void reshaped(int xx, int yy){xt=xx ; yt=yy;}   /* origin of moved window */
/**********************************************************************/
/* drawcons - draws everything                                        */
/*   - Now uses showslate variable to draw multiple viewports         */
/**********************************************************************/
void drawcons(void){  
   glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

if (stereomode){/* Matt Hall's stereoviewer */
        glViewport(0,leyeTOP,windLEFT,scrHT);
        /**if(msg) messages();**/
        glViewport(windLEFT,leyeTOP,2*scrHT,scrHT);
         glMatrixMode(GL_PROJECTION); glLoadIdentity();
         glFrustum(-mysiz,mysiz,-mysiz,mysiz,mysiz*focal,wfar);
         glMatrixMode(GL_MODELVIEW); glLoadIdentity();
        glTranslatef(-nose,0.0,0.0);
        glRotatef(ster_rot,0.0,1.0,0.0);
        drawstars(starmat);
        /* curse3d(); */
        glMultMatrixf(aff);
        drawall();

        glViewport(0,reyeTOP,windLEFT,scrHT);
        /**if(msg) messages();**/
        glViewport(windLEFT,reyeTOP,2*scrHT,scrHT);
          glMatrixMode(GL_PROJECTION); glLoadIdentity();
        glFrustum(-mysiz,mysiz,-mysiz,mysiz,mysiz*focal,wfar);
         glMatrixMode(GL_MODELVIEW); glLoadIdentity();
        glTranslatef(nose,0.0,0.0);
        glRotatef(-ster_rot,0.0,1.0,0.0);
        drawstars(starmat);
        /* curse3d(); */
        glMultMatrixf(aff);
        drawall();
   } else {

     if(binoc) glViewport(0,yt/4,xt/2,yt/2);
     else  glViewport(0,0,xt,yt);

      /***********Main*Window*******************/
      glMatrixMode(GL_PROJECTION); glLoadIdentity();
      glFrustum(-mysiz*xt/yt,mysiz*xt/yt,-mysiz,mysiz,mysiz*focal,wfar); 
      glMatrixMode(GL_MODELVIEW); glLoadIdentity();
      viewfrom(cockpit);
      drawall(); 
      if(binoc){
         glViewport(xt/2,yt/4,xt/2,yt/2);
         glMatrixMode(GL_MODELVIEW);
         glLoadIdentity();
         drawstars(starmat);
         glTranslatef(binoc*nose,0.0,0.0);
         glMultMatrixf(aff);
         drawall();
      }
      if(showslate){ drawslate(); }
      if(showplanar){ drawplanardevelopment(); }
   }
   glViewport(0,0,xt,yt);
   if(msg) messages();
   glutSwapBuffers();
 
}
/**********************************************************************/
/* idle - function that gets executed when the CPU is idle            */
/**********************************************************************/
void idle(void){ /*do this when nothing else is happening*/
   if(morph) autotymer(0);  /* advance autotymer */ 
   if(showcontrail) updatecontrail(); /* keep track of the flight path */
   glutPostRedisplay();  /*redraw the window*/
   chaptrack(BUT,XX,YY,SHIF);
   if(autopilot) updateTT(1,0); 
}
/**********************************************************************/
/* mousepushed - mouse button handler. I use this to determine dragmode*/
/**********************************************************************/
void mousepushed(int but,int stat,int x,int y){
  if(stat==GLUT_DOWN) BUT |= (1<<but);
  else BUT &= (-1 ^ (1<<but));  
  XX=x; YY=y; SHIF=(glutGetModifiers()==GLUT_ACTIVE_SHIFT)?1:0;

   if(stat==GLUT_DOWN){ /* if a button was pushed */
      if(showslate || showplanar){ /* if we are in a valid picking  mode */
         if(pickedcube[1] != -1){  /* if we have a valid point picked */
            dragmode = 1 - dragmode; /* switch the dragmode */
         }
      }
   }
}
/**********************************************************************/
/* mousemoved - mouse movement handler                                */
/**********************************************************************/
void mousemoved(int x,int y){  XX=x; YY=y; }
/**********************************************************************/
/* dataprep - intializes data                                         */
/**********************************************************************/
void dataprep(void){
 	deFault(); 
        initstars();
}
/**********************************************************************/
/* %%%%%%%%%%%%%      CAVEISH        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */
/**********************************************************************/

#ifdef CAVE
void cavekeybo(void){
#define  CAVEIF(K)         if(CAVEgetbutton(K))
#define  CAVESOAK(K)        while(CAVEgetbutton(K))

#define  CAVEPRESS(K,A,b)  CAVEIF(K){if(CAVEgetbutton(CAVE_LEFTSHIFTKEY)||\
                           CAVEgetbutton(CAVE_RIGHTSHIFTKEY)){b;}else{A;}\
                           CAVESOAK(K);}
#define  CAVETOGGLE(K,flg) CAVEIF(K){(flg) = 1-(flg); CAVESOAK(K);}
#define  CAVECYCLE(K,f,m)  CAVEPRESS((K),(f)=(((f)+(m)-1)%(m)),(f)=(++(f)%(m)) )
#define  CAVESLIDI(K,f,m,M)  CAVEPRESS(K,(--f<m?m:f), (++f>M?M:f))
#define  CAVESLIDF(K,f,m,M,d) CAVEPRESS(K,((f -= d)<m?m:f), ((f += d)>M?M:f))  
CAVEPRESS(CAVE_PKEY, wfar *= 1.01,   wfar   /= 1.01) /* rear clipping plane*/  
CAVEPRESS(CAVE_QKEY, speed /= 1.02, speed *= 1.02); /* flying speed       */  
CAVEPRESS(CAVE_RKEY, torq /= 10.02,  torq *= 10.02); /* turning speed      */  
CAVETOGGLE(CAVE_YKEY,wnd);  /* mauspaw vs wandpaw *//* not yet implemented */
CAVEPRESS(CAVE_ZKEY, deFault(), deFault());        /* zap changes       */
CAVETOGGLE(CAVE_FKEY, showframe );
CAVETOGGLE(CAVE_UKEY, showcube );
CAVETOGGLE(CAVE_KKEY,  cockpit  );
CAVEPRESS(CAVE_TKEY, updateTT(0,autopilot), updateTT(1,autopilot));
CAVEPRESS(CAVE_AKEY, {aa=aa-1; computelissajou();}, {aa=aa+1; computelissajou();})
CAVEPRESS(CAVE_BKEY, {bb=bb-1; computelissajou();}, {bb=bb+1; computelissajou();})
CAVEPRESS(CAVE_CKEY, {cc=cc-1; computelissajou();}, {cc=cc+1; computelissajou();})


CAVETOGGLE(CAVE_DKEY, showbishop );
CAVETOGGLE(CAVE_YKEY, autopilot );
CAVETOGGLE(CAVE_EKEY, showchaseplane );
} /* end cavekeybo */

void graffiti(void){             /* used to be called speedo  */
  char buf[256];                 /*messages written into here */
#define  LABEL3(x,y,z,W,u){sprintf(buf,(W),(u));char2wall(x,y,z,buf);}
  static float last=0.,fps;      /*for measuring time         */
  if(!CAVEMasterDisplay()) return;  /* USE CAVEMasterWall in papeBeta */
                                    /* in grafiXlab we have old CAVElib? */
  if(floor(2.*(*CAVETime))>floor(2.*last)){  /* rationalize this */
     last=*CAVETime;
     fps=*CAVEFramesPerSecond;
     }
  if(mode==TURNMODE){
        glColor3f(1.,0.,1.);
        LABEL3(-3.8,1.,-5.0,\
        "4=auto 2=mode 3=shrink 6=grow 5=freeze 7=reset %s","");
        } else {
        glColor3f(1.,1.,0.);
        LABEL3(-3.8,1.0,-5.0,
          " push thumb-button to fly, 2=tractor gap %s","gap");
        }
     LABEL3(-4.8,8.0,-5.0, "bishopCoaster\
    by Ben Farmer and Karan Dalal, im2001 (C)Summer 2001  U.Illinois %s","")
       LABEL3(-4.8,1.0,-5.0,"%5.1f fps",fps);
       LABEL3(-4.8,7.5,-5.0,"Time = %i",tt);
       LABEL3(-4.8,7.0,-5.0,"d(T) = %3i",dtt);
}

void cavetrack(void){
  float azi,ele,rol,hx,hy,hz,wx,wy,wz;
  static float ohx,ohy,ohz;   /*old head position */
  static float owx,owy,owz;   /*old wand position */
  static int opaw = 0,paw, joy = 0, friz = 0;

  if(!CAVEMasterDisplay()) return;  /* doit once per frame */
  paw = wnd ? (CAVEBUTTON1*2+CAVEBUTTON2)*2+CAVEBUTTON3 : mauspaw;
  if(paw) joy = 1; /* activate joystick by clicking any button*/
  if(opaw!=2 && paw==2) mode = (mode+1)%(TURNMODE+1); /* click modes */
  if(mode==TURNMODE){   /* hold middle button and click right to shrink */
     if (opaw == 2 && paw == 3)siz /= 1.5;     /*shrink object */
     if (opaw == 2 && paw == 6)siz *= 1.5;     /* grow   object */
     if (opaw != 4 && paw == 4)cockpit=1-cockpit; /* viewchanger */
     if (opaw != 5 && paw == 5)friz = 1-friz;  /* parking option */
     if (opaw != 1 && paw == 1)autopilot = 1-autopilot; /* car moves on its own */
     }

  if(opaw==2 && paw == 7){ /* restart, the most useful feature */
     deFault(); ohx=ohy=ohz=0; owx=owy=owz=0;
     }
        wnd=1;
	if(wnd){
      CAVEGetWandOrientation(azi,ele,rol);
      CAVEGetHead(hx,hy,hz);  /*position*/
      CAVEGetWand(wx,wy,wz);  /*position*/
      }
   else{  /* fix this for CAVE mouse flying */
      azi = .05*512; ele = .05*-512;
      }
   glMatrixMode(GL_MODELVIEW); glPushMatrix(); glLoadIdentity();

   glTranslatef(ohx-hx,ohy-hy,ohz-hz);
   if(mode==TURNMODE) glTranslatef(aff[12],aff[13],aff[14]);
   if(!friz){  /* if not parked */
      glRotatef(rol*(mode?torq:-torq),0.,0.,1.);
      glRotatef(ele*-torq, 1.,0.,0.);
      glRotatef(azi*-torq,0.,1.,0.);
      }
   if(joy&&((fabsf(CAVE_JOYSTICK_Y)>.02)||(fabsf(CAVE_JOYSTICK_X)>.02)))
       glTranslatef(CAVE_JOYSTICK_X*speed,0.,CAVE_JOYSTICK_Y*speed);

 if(opaw==2 && paw==2)glTranslatef(wx-owx, wy-owy, wz-owz); /*wand tractor */
 if(mode == TURNMODE) glTranslatef(-aff[12],-aff[13],-aff[14]);
   glMultMatrixf(aff);
   glGetFloatv(GL_MODELVIEW_MATRIX,aff);

  {int ii,jj; for(ii=0;ii<3;ii++){ luxx[ii]=0; /* calculite */
   for(jj=0;jj<3;jj++) luxx[ii] += aff[ii*4+jj]*lux[jj];} }

 if(mode==FLYMODE && !friz) /*make the star matrix rotate*/
      {
      glLoadIdentity();
      glRotatef(rol*(mode?torq:-torq),0.,0.,1.);
      glRotatef(ele*-torq,1.,0.,0.);
      glRotatef(azi*-torq,0.,1.,0.);
      glMultMatrixf(starmat);
      glGetFloatv(GL_MODELVIEW_MATRIX,starmat);
      }
   glPopMatrix();
   opaw=paw; ohx=hx; ohy=hy; ohz=hz;
             owx=wx; owy=wy; owz=wz;
   if(morph) autotymer(0);  /* advance autotymer */
/* audiofunc(); */
}

void drawcaveinit(void){   /* kludge? needed why ? */
   CAVEFar = 1000.;
   glClearColor(0.,0.,0.,0.);
   glClearDepth(1.);
}
#if 0
This is how it works in the console
      float inv[16]; invert(inv, fram);  /* we want the inverse frame */
      glRotatef(180,0,1,0);  /*hack to correct the facing the wrong way problem*/
      glMultMatrixf(inv);
      glPushMatrix();
      glScalef(2,2,2);
      drawstars();
      glPopMatrix();
#endif 

void drawcave(void){
  float hx,hy,hz;
  float inv[16], rinv[16]; 
  if(cockpit){  /* this could be neater */
    invert(inv, showchaseplane? fram2: fram); /* if there is a chaseplane, look from it */
    {int ii; FOR(ii,0,16)rinv[ii]=inv[ii]; }
    rinv[12]=rinv[13]=rinv[14]=0.;  /* just the rotation part of inv */
  }
  glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
  drawstars(cockpit?rinv:starmat);   /* replace starmat by rot(fram^-1) */
  graffiti();
  CAVEGetHead(hx,hy,hz);
  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();
  glTranslatef(hx,hy,hz);  /* ancient and sacred translation to the head*/
  if(cockpit)glRotatef(180,0,1,0);  /* so we face the front of the coaster */
  glMultMatrixf(cockpit? inv : aff);
  glScalef(siz,siz,siz);    
  glTranslatef(0.,0.,2.);  /* puts the head above the track */
  /* but it doesn't work right here. I don't like removing this */
  drawall();
  glPopMatrix();
}
#endif  /* CAVE */

/*%%%%%%%%%%%%%%%%%%%%%%%%%%%end CAVE %%%%%%%%%%%%%%*/
int  main(int argc, char **argv){
	arguments(argc,argv);
	if(caveyes)
#ifdef CAVE
	CAVEConfigure(&argc,argv,NULL)
#endif
	;	
	getmem();
	dataprep();
	if(caveyes){
#ifdef CAVE
	CAVEInit();
        deFault(); /* maybe this cures it ? */
	CAVEFrameFunction(cavetrack,0);
	CAVEInitApplication(drawcaveinit,0);
	CAVEDisplay(drawcave,0);
	while(!CAVEgetbutton(CAVE_ESCKEY))
	{
	cavekeybo();
	}
	CAVEExit();
#endif
	;}
	else{
	getmem();  /* added by bafarmer 24jul02*/
        deFault();
	glutInit(&argc,argv);
	glutInitDisplayMode(GLUT_DOUBLE|GLUT_DEPTH);
	switch(win)
	{ case 0: break;
	  case 1: glutInitWindowSize(640 ,480);
		  glutInitWindowPosition(300,1024-480);
		  break;
	  case 2: glutInitWindowPosition(0,0);
		  break;
	}
	glutCreateWindow("BishopCoaster");
	if(win==2) glutFullScreen();
	glEnable(GL_DEPTH_TEST);
	glutDisplayFunc(drawcons);
	glutKeyboardFunc(keyboard);
	glutSpecialFunc(special_keybo);
	glutMouseFunc(mousepushed);
	glutMotionFunc(mousemoved);
	glutPassiveMotionFunc(mousemoved);
	glutReshapeFunc(reshaped);
	glutIdleFunc(idle);
	glutMainLoop();
	}
}

