// Greg Kaiser
//
// CS290 with Prof. Francis
// 4D Tetris
//
// Rotor.C
// Last modified: April 25, 1996
//
// (C) 1996 Board of Trustees University of Illinois

#include <iostream.h>
#include "Rotor.h"

#define ABS(x) ((x>0)?x:-x)
#define IFSHIFT  if(getbutton(LEFTSHIFTKEY)||getbutton(RIGHTSHIFTKEY))
#define PRESS(K,A,b)   if(getbutton(K)){IFSHIFT{A;}else{b;}}

static Matrix id  = {{1.,0.,0.,0.},
		     {0.,1.,0.,0.},
		     {0.,0.,1.,0.},
		     {0.,0.,0.,1.}};
/*Matrix aff = {{1.,0.,0.,0.},
		      {0.,1.,0.,0.},
		      {0.,0.,1.,0.},
		      {0.,0.,0.,1.}};
*/

Rotor::Rotor()
{
  active = 1;

  for (int i = 0; i < 4; i++)
    for (int j = 0; j < 4; j++)
      aff[i][j] = ((i==j) ? 1.0 : 0.0);
}

Rotor::~Rotor()
{}

void Rotor::Rotate()
{
  float dx = (active ? getvaluator(MOUSEX) : 0.0);
  float dy = (active ? getvaluator(MOUSEY) : 0.0);
  if (active) {
    long mx, my, xt, yt, xo, yo;
    getsize(&xt,&yt);
    getorigin(&xo,&yo); 
    mx=xo+xt/2; 
    my=yo+yt/2;
    dx -= mx;
    dx = ABS(dx)>20?dx:0;
    dy -= my;
    dy = ABS(dy)>20?dy:0;
    //get  dims and lower left corner of window and calculate the center
  }  

  pushmatrix();
  loadmatrix(id); //replaces what's there by the identity
  translate(aff[3][0],aff[3][1],aff[3][2]);
  
  if (active) {
    float torq = .01;
    rot(dx*torq,'y'); rot(-dy*torq, 'x');
    PRESS(RIGHTMOUSE, rot(-10,'z'), rot(-1,'z'));
    PRESS(LEFTMOUSE,  rot( 10,'z'), rot( 1,'z'));
  }

  translate(-aff[3][0],-aff[3][1],-aff[3][2]);
  multmatrix(aff); getmatrix(aff);  //x = x+dx  aff<- daff*aff
  popmatrix();
  multmatrix(aff); //replaces rotate turn tilt
}

void Rotor::Activate()
{
  active = 1;
}

void Rotor::Deactivate()
{
  active = 0;
}
