#oc1.py
#7feb09 shadow experiments
#based on lorenz.py by Stan Blank 22mar05
#OpenGL by Alex Bourd and Matthew Stiak 9oct96
#IrisGL by G Francis 9apr89, last revision 9sep96
#Correction of 1988 SGI GUIDE p2-21

#replaces include <GL/glut.h>
from OpenGL.GL import *
from OpenGL.GLUT import *
from OpenGL.GLU import *
import sys

#allocate some globals
global aff
global vlt
global pln
global cnv
global vv
global wd
global ht
global MouseX
global MouseY

#assign the affine identity matrix
#for mouse motion
aff = (1.0,0.0,0.0,0.0,
       0.0,1.0,0.0,0.0,
       0.0,0.0,1.0,0.0,
       0.0,0.0,0.0,1.0)

#new things for the planar projections
vlt = (0.1, 0.1, 1.0, 0.0)  #light direction
pln = (0.0, 0.0, 1.0, 3.0)   #canvas place
den = vlt[0]*pln[0]+vlt[1]*pln[1]+vlt[2]*pln[2]
cnv =( den-vlt[0]*pln[0],    -vlt[1]*pln[0],   -vlt[2]*pln[0], 0.0,
          -vlt[0]*pln[1], den-vlt[1]*pln[1],   -vlt[2]*pln[1], 0.0,
          -vlt[0]*pln[2],    -vlt[1]*pln[2],den-vlt[2]*pln[2], 0.0,
          -vlt[0]*pln[3],    -vlt[1]*pln[3],den-vlt[2]*pln[3], den) 
'''
def populate():
    global cnv
    cnv[0]=den-vlt[0]*pln[0]; cnv[1]=    -vlt[1]*pln[0]; cnv[2]=   -vlt[2]*pln[0]; cnv[3]= 0.0
    cnv[4]=   -vlt[0]*pln[1]; cnv[5]= den-vlt[1]*pln[1]; cnv[6]=   -vlt[2]*pln[1]; cnv[7]= 0.0
    cnv[8]=   -vlt[0]*pln[2]; cnv[9]=    -vlt[1]*pln[2]; cnv[10]=den-vlt[2]*pln[2];cnv[11]= 0.0
    cnv[12]=             0.0; cnv[13]=              0.0; cnv[14]=              0.0;cnv[15]= den 
''' 
#be careful, cnv is actually the transpose of what you are used to

#assign the vertices of the octahedron
vv=( (1.0,0.0,0.0),
     (0.0,1.0,0.0),
     (0.0,0.0,1.0),
     (-1.0,0.0,0.0),
     (0.0,-1.0,0.0),
     (0.0,0.0,-1.0) )

#assign initial window and mouse settings
wd = 800
ht = 800
MouseX = wd/2
MouseY = ht/2
brake = 512. 


def octa():
   glBegin(GL_TRIANGLE_FAN)
   glColor3f(0,1,0);  glVertex3fv(vv[1])
   glColor3f(0,0,1);  glVertex3fv(vv[0])
   glColor3f(0,1,1);  glVertex3fv(vv[5])
   glColor3f(1,1,0);  glVertex3fv(vv[3])
   glColor3f(1,0,0);  glVertex3fv(vv[2])
   glColor3f(0,0,1);  glVertex3fv(vv[0])
   glEnd()
   glBegin(GL_TRIANGLE_FAN)
   glColor3f(1,0,1);  glVertex3fv(vv[4])
   glColor3f(0,0,1);  glVertex3fv(vv[0])
   glColor3f(0,1,1);  glVertex3fv(vv[5])
   glColor3f(1,1,0);  glVertex3fv(vv[3])
   glColor3f(1,0,0);  glVertex3fv(vv[2])
   glColor3f(0,0,1);  glVertex3fv(vv[0])
   glEnd() 

# typical display callback 
def display():
   glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT)
   glMatrixMode(GL_MODELVIEW)
   glLoadIdentity()
   glMultMatrixf(aff)
   octa()
   glMultMatrixf(cnv)
   octa()
   glutSwapBuffers()
#end display()

#typical keyboard callback 
def keyboard(key, x, y):
   if key == chr(27) or key == 'q':
     sys.exit(0)
   glutPostRedisplay()
#end keyboard()

#adjust to resizing of the window
def reshape(width, height):
   global wd
   global ht
   glClearColor(0.0, 0.0, 0.0, 0.0)
   if height == 0:
      height = 1
   wd = width
   ht = height
   glViewport(0,0,wd,ht)
   glMatrixMode(GL_PROJECTION)
   glLoadIdentity()
   if wd<=ht:
      glOrtho(-2.0,2.0,-2.0*ht/wd,2.0*ht/wd,-2.0,2.0)
   else:
      glOrtho(-2.0*wd/ht,2.0*wd/ht,-2.0,2.0,-2.0,2.0)
   glMatrixMode(GL_MODELVIEW)
   glLoadIdentity()
#end reshape()

#Note that we must declare the globals again
def chaptrack():
   global MouseX
   global MouseY
   global wd
   global ht
   global aff
   dx = (MouseX-wd/2)/brake  
   dy = (MouseY-ht/2)/brake
   glMatrixMode(GL_TEXTURE)
#  glMatrixMode(GL_MODELVIEW)     #if this stack then push/pop
#   glPushMatrix()
   glLoadIdentity()
   glRotatef(dx,0,1.0,0.0)
   glRotatef(dy,1.0,0.0,0.0)
   glMultMatrixf(aff)
   aff = glGetFloatv(GL_TEXTURE_MATRIX)
#  aff = glGetFloatv(GL_MODELVIEW_MATRIX)
#  glPopMatrix()
#end chaptrack()

#traditional idle
def idle():
#   populate()
   chaptrack()
   glutPostRedisplay()
#end idle()

#ditto traditional mousemotion
#Note globals
def mousemotion(x,y):
   global MouseX
   global MouseY
   MouseX = x
   MouseY = y
#end mousemotion()

#Traditional main subroutine
def main(argv) :
   global wd
   global ht
   glutInitDisplayMode(GLUT_RGB | GLUT_DEPTH | GLUT_DOUBLE)
   glutInitWindowPosition(50, 50)
   glutInitWindowSize(wd, ht)
   glutInit(argv)
   glutCreateWindow("Octahedron")
   glutKeyboardFunc(keyboard)
   glutDisplayFunc(display)
   glutIdleFunc(idle)
   glutPassiveMotionFunc(mousemotion)
   glEnable(GL_DEPTH_TEST)
   glShadeModel(GL_SMOOTH)
   glMatrixMode(GL_PROJECTION)
   glLoadIdentity()
   glOrtho(-2.0,2.0,-2.0,2.0,-2.0,2.0)
   glutMainLoop()

#Necessary if we want to this program to run
if __name__=='__main__':
   main(sys.argv)

