/* windowed 11aug2K */
/**************************oc1.c******************************/
/* Correction of 1988 SGI GUIDE pg2-21 on 9apr89             */
/* revised gkf 9sep96, rewritten in GLUT and OpenGL      by  */
/* Alex Bourd, Matthew Stiak October 9,1996, gkf 15 jan 2000 */
/**************************oc1.c******************************/
#include <stdlib.h>
#include <stdarg.h>
#include <stdio.h>
#include <math.h>
#include <GL\glut.h>
#include <windows.h>

#define  FOR(uu,u0,u1)  for(uu=u0; uu<u1; uu++)
#define WIN  400  /* default window size in pixel coordinates */ 
/* vertices for the octahedron */
float vv[6][3] = { { 1.0, 0.0, 0.0 },
                     { 0.0, 1.0, 0.0 },
   		     { 0.0, 0.0, 1.0 },
		     {-1.0, 0.0, 0.0 },
		     { 0.0,-1.0, 0.0 },
		     { 0.0, 0.0,-1.0 } };
float aff[16]; /* the affine matrix */ 
int MouseX,  MouseY; /* mouse position */

/***********************************************************/
void display(void){
  glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
  glMatrixMode(GL_MODELVIEW);
  glLoadIdentity();
  glMultMatrixf(aff);
  glBegin(GL_TRIANGLE_FAN);
     glColor3f(0.,255.,0.);  glVertex3fv(vv[1]);
     glColor3f(0.,0.,255.);  glVertex3fv(vv[0]);
     glColor3f(0.,255.,255.);glVertex3fv(vv[5]);
     glColor3f(255.,255.,0.);glVertex3fv(vv[3]);
     glColor3f(255.,0.,0.);  glVertex3fv(vv[2]);
     glColor3f(0.,0.,255.);  glVertex3fv(vv[0]);
  glEnd();
  glBegin(GL_TRIANGLE_FAN);
     glColor3f(255.,0.,255.);glVertex3fv(vv[4]);
     glColor3f(0.,0.,255.);  glVertex3fv(vv[0]);
     glColor3f(0.,255.,255.);glVertex3fv(vv[5]);
     glColor3f(255.,255.,0.);glVertex3fv(vv[3]);
     glColor3f(255.,0.,0.);  glVertex3fv(vv[2]);
     glColor3f(0.,0.,255.);  glVertex3fv(vv[0]);
  glEnd();
  glutSwapBuffers();
}
/***********************************************************/
void keyboard(unsigned char key, int x, int y){
  switch(key)
   { case  27: fprintf(stderr," Thanks for using GLUT ! \n"); exit(0); break;
     case 'a': {break;};
     case 'A': {break;};
   }
}
/***********************************************************/
void chaptrack(void){ 
  static ox = 200, oy = 200; /* blemish, use window center */ 
  int dx=(MouseX-200)/16; int dy=(MouseY-200)/16; 
  glMatrixMode(GL_TEXTURE);    /* algebra on a spare matrix stack */ 
  glLoadIdentity();                  /* place the identity matrix */
  glRotatef((GLfloat)dx,0.0,1.0,0.0); /* multiply it by a rotation  */
  glRotatef((GLfloat)dy,1.0,0.0,0.0); 
  glMultMatrixf(aff);                 
  glGetFloatv(GL_TEXTURE_MATRIX,aff); /* update the affine matrix */
}
/***********************************************************/
void mousemotion(int x,int y) { MouseX=x; MouseY=y; }
/***********************************************************/
void idle(void){    
  glutPostRedisplay(); /* if the window was moved around */
  chaptrack();         /* update the affine matrix */
}
/***********************************************************/
int main(int argc, char **argv){

  { int ii,jj; FOR(ii,0,4)FOR(jj,0,4)aff[ii*4+jj]=(ii==jj);}

  glutInitWindowSize(WIN, WIN);
  MouseX=MouseY=WIN/2;
  glutInit(&argc, argv);
  glutInitDisplayMode(GLUT_DOUBLE | GLUT_RGB | GLUT_DEPTH);
  glutCreateWindow("<< octahedron in in GLUT >>");
  glutDisplayFunc(display);
  glutKeyboardFunc(keyboard);
  glutPassiveMotionFunc(mousemotion);
  glutIdleFunc(idle); 
    glEnable(GL_DEPTH_TEST);
    glShadeModel(GL_SMOOTH);
    glMatrixMode(GL_PROJECTION);
    glLoadIdentity();
    glOrtho(-2.0,2.0,-2.0,2.0,-2.0,2.0);
    glMatrixMode(GL_MODELVIEW);
    glLoadIdentity();
  glutMainLoop();
  return 0;             /* ANSI C requires main to return int. */
}
