/*
 *	Lorenz Mask
 *
 *	created: 2/9/01 by Benjamin Bernard
 *
 *  description: creates a rotating lorenz mask, with mouse zoom
 */
 
import javax.swing.*;
import javax.swing.event.*;
import java.awt.*;
import java.awt.event.*;
import java.util.List;
import java.util.LinkedList;
import javax.vecmath.*;
import javax.media.j3d.*;
import com.sun.j3d.utils.universe.*;
import com.sun.j3d.utils.geometry.*;
import com.sun.j3d.utils.behaviors.mouse.*;

class LorenzMask extends JFrame
{
	private List balls = new LinkedList();
	private JPanel mainPanel;
	private Canvas3D canvas;
	
	
	public LorenzMask()
	{
		super("Lorenz Mask");
		addWindowListener(new WindowAdapter()
		{
			public void windowClosing(WindowEvent e)
			{
				close();
			}
		});
	}
	
	private void close()
	{
		dispose();
		System.exit(0);
	}
	
	public static void main(String args[])
	{
		LorenzMask lm = new LorenzMask();
		lm.go();
	}
	
	public void go()
	{
		setSize(800, 600);
		setupComponents();
		setVisible(true);
	}
	
	private void setupComponents()
	{
		
		Container contentPane = getContentPane();
		mainPanel = new JPanel();
		
		canvas = new Canvas3D(null);
		canvas.setBackground(Color.lightGray);
		contentPane.add(canvas);

		SimpleUniverse simpleU = new SimpleUniverse(canvas);
		
		//get the "meat" of the program
		BranchGroup scene = createScene();
		
		scene.compile();
	
		simpleU.getViewingPlatform().setNominalViewingTransform();
		simpleU.addBranchGraph(scene);

		//move the view back, to see the whole thing
		Transform3D t3d = new Transform3D();
		t3d.set(new Vector3d(0,0, 40));
		simpleU.getViewingPlatform().getViewPlatformTransform().setTransform(t3d);

	}
	
	//setups the visual objects
	private BranchGroup createScene()
	{
		BranchGroup bg= new BranchGroup();
		TransformGroup topGroup = new TransformGroup();
		
		//set access permissions
		topGroup.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
		topGroup.setCapability(TransformGroup.ALLOW_TRANSFORM_READ);

		TransformGroup rotateGroup = new TransformGroup();
		rotateGroup.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
		rotateGroup.setCapability(TransformGroup.ALLOW_TRANSFORM_READ);

		topGroup.addChild(rotateGroup);
		
		//setup the x-axis rotation
		Alpha rotationAlpha = new Alpha(-1, 10000);
		RotationInterpolator ri = 
			new RotationInterpolator(rotationAlpha, rotateGroup);
		ri.setSchedulingBounds(new BoundingSphere(new Point3d(), 10000));
		rotateGroup.addChild(ri);
	
		//add mouse zoom capabilities, acitived by the "meta" button
		//could be middle or right button
		MouseZoom mz = new MouseZoom(topGroup);
		mz.setSchedulingBounds(new BoundingSphere(new Point3d(), 10000));
		topGroup.addChild(mz);
	
		TransformGroup lorenzGroup = new TransformGroup();
		rotateGroup.addChild(lorenzGroup);
		
		//setup the Lorenz behavior to draw the points
		LorenzBehavior maskBehavior = new LorenzBehavior(lorenzGroup);
		maskBehavior.setSchedulingBounds(new BoundingSphere(new Point3d(), 10000));
		lorenzGroup.addChild(maskBehavior);
		
		lorenzGroup.setCapability(TransformGroup.ALLOW_CHILDREN_EXTEND);
		
		Background back = new Background(convertColor(Color.black));
		back.setApplicationBounds(new BoundingSphere(new Point3d(), 1000000));
		bg.addChild(back);

		bg.addChild(topGroup);
		
		return bg;
	}
	
	//converts from java.awt.Color to Color3f, a java3D color
	private Color3f convertColor(Color color)
	{
		int red, green, blue;
		
		red = color.getRed()/255;
		green = color.getGreen()/255;
		blue = color.getBlue()/255;
		
		return new Color3f(red, green, blue);
	}
}
