/*
 *	Lorenz Behavior
 *
 *	created: 2/9/01 by Benjamin Bernard
 *
 *  description: will create lorenz picture in specified transform group
 */

import javax.vecmath.*;
import javax.media.j3d.IndexedPointArray;
import javax.media.j3d.Behavior;
import java.util.Enumeration;
import javax.media.j3d.WakeupOnElapsedTime;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.*;
import com.sun.j3d.utils.universe.SimpleUniverse;
import com.sun.j3d.utils.geometry.Sphere;
import java.awt.Color;


class LorenzBehavior extends Behavior
{
	private TransformGroup parentTransformGroup;
	private double x, y, z, xnew, ynew;
	public final static double H_VALUE = .01;
	public final static double SCALE_FACTOR = .2;


	
	//transform goup must allow children extension
	// TransformGroup.ALLOW_CHILDREN_EXTEND
	public LorenzBehavior(TransformGroup parentTransformGroup)
	{
		this.parentTransformGroup = parentTransformGroup;
		
		x=120 * SCALE_FACTOR;
		y= 32 * SCALE_FACTOR;
		z = .01;
	}
	
	public void processStimulus(Enumeration enum)
	{
		addPoint();
		this.wakeupOn(new WakeupOnElapsedTime(1l));
	}
	
	public void initialize()
	{
		this.wakeupOn(new WakeupOnElapsedTime(1l));
	}
	
	private void addPoint()
	{
	
		//get new x, y, and z values
		xnew = x + ((10 * y) - (10 * x)) * H_VALUE;
		ynew = y + (28 * x - x*z - y) * H_VALUE;
		z = z + (x*y - ((8d/3d)*z)) * H_VALUE;
		x = xnew;
		y = ynew;
		
		BranchGroup bg= new BranchGroup();
		
		//plot new point, scaled correctly
		IndexedPointArray ipa = 
			new IndexedPointArray(1, IndexedPointArray.COORDINATES, 1);
		ipa.setCoordinate(0, 
			new Point3d(x*SCALE_FACTOR, y*SCALE_FACTOR, z*SCALE_FACTOR));
		Shape3D point = new Shape3D(ipa);

		bg.addChild(point);
		parentTransformGroup.addChild(bg);
	}
}