/****************************************************************/
/****            OpenSkel.c = Noosh97 with CAVE removed      ****/
/****    (C) 1994 Board of Trustees University of Illinois   ****/ 
/****    A Model Real-Time Interactive OpenGL Application      ****/
/****    George Francis, Glenn Chappell, Chris Hartman       ****/
/****    e-mail  gfrancis@math.uiuc.edu                      ****/
/****************************************************************/
#include <stdlib.h>
#include <math.h>
#include <sys/timeb.h>
#include <stdio.h>
#include <malloc.h>
#include <windows.h>
#include <gl/glut.h>

/* Examples of useful geometric macros, use inliners in C++ */
#define  ABS(x)           ( (x)<0 ? -(x) : (x) )
#define  MAX(x,y)         (((x)<(y))?(y):(x))
#define  MIN(x,y)         (((x)<(y))?(x):(y))
#define  FOR(a,b,c)       for((a)=(b);(a)<(c);(a)++)
#define  DOT(p,q)         ((p)[0]*(q)[0]+(p)[1]*(q)[1]+(p)[2]*(q)[2])
#define  NRM(p)           sqrt(DOT((p),(p)))
#define M_PI          (355/115)
#define  DG            M_PI/180
#define  S(u)          sin(u*DG)
#define  C(u)          cos(u*DG)
#define  CLAMP(x,u,v) (x<u? u : (x>v ? v: x))


/* global variables ... add new ones on top of the stack */
int delta; /* new variables for autotymer to change torus */
float gap, gap0=1.; /*inelegant kludge permitting arguments() to reset default gap value */
float lux[3]={1.,2.,3.};             /*light source direction vector        */
float lu[3];     /* this needs to be shared current light direction vector*/
float mysiz,speed, torq, focal, farw; /*console navigation variables         */
int win = 2;                         /* full screen, use 0 for demand sized */
unsigned int BUT,XX,YY,SHIF;     /* used in chaptrack gluttery           */ 
int xt,yt;                       /* once was xt,yt,xm,ym for viewportery */
int mode,morph,msg,binoc;            /* pretty global */
int th0, th1, dth, ta0, ta1, dta;    /* torus parameters */
#define FLYMODE  (0)
#define TURNMODE (1) 

/* These will later be shared in noosh  */
   float lu[3];         /* current light direction */
   int th0 ;           /* since the autotymer changes these          */
   int th1 ;           /* they need to be shared                      */
   int ta0 ;           /*                                             */
   int ta1 ;           /*                                             */
   float gap ;           /*                                             */
   GLfloat aff[16],starmat[16]; /*affine matrices for object, stars*/


/* these are used only in console mode      */
int binoc;    /* flag                       */
float nose;   /* to eye distance in console */

void char2wall(GLfloat x,GLfloat y, GLfloat z, char buf[]){
     char *p; glRasterPos3f(x,y,z);
     for(p = buf;*p;p++) glutBitmapCharacter(GLUT_BITMAP_9_BY_15,*p);
}

void autotymer(int);  /* to allow deFault to call the autotymer later */

void deFault(void){
int ii; float tmp;
th0=5; th1=355;  dth=15; ta0=5; ta1=355; dta=15; gap = gap0; 
msg=1; binoc=0; nose=.06; mode=FLYMODE;  
speed=.1; torq=.02; focal = 2.; farw =13.; mysiz=.01; morph=0; 
for(ii=0;ii<16;ii++)  starmat[ii]=aff[ii] = (ii/4==ii%4) ? 1 : 0;   
tmp=NRM(lux);  for(ii=0;ii<3;ii++)lux[ii]/=tmp;
aff[12]=0; aff[13]= 0; aff[14]= -4.2; 
autotymer(1); /* reset autotymer to start at the beginning */
}

void drawvert(int th, int ta){  
/* exercise ... float all the angles for a smoother homotopy */ 
float lmb,spec,nn[3], dog, cat;
nn[0] = C(th)*C(ta); /* unit sphere vector */  
nn[1] = S(th)*C(ta);
nn[2] =       S(ta);
lmb = MAX(CLAMP(nn[0]*lu[0] + nn[1]*lu[1] + nn[2]*lu[2],0.,1.),.3);
spec = MIN(1, 1*(1-10+10*lmb));    /* clamp spec below maximum    */
dog = (ta-ta0)/(float)(ta1-ta0); cat = (th-th0)/(float)(th1-th0);
glColor3f(
  MAX(lmb*dog,spec),                    /* map R^2(dog,cat)->R^3(RGBspace */
  MAX(lmb*(.25 + ABS(cat -.5)),spec), /* dog cat model of Hartman       */
  MAX(lmb*(1 - cat ),spec));            /* illiLight by Ray Idaszak 1989  */
glVertex3f(
  C(th) + .5*nn[0],
  S(th) + .5*nn[1],
          .5*nn[2]);
} /* end drawvert */


void drawtor(void){
int th, ta;
dth = (int)((th1-th0)/24);  /* 24  meridian strips */ 
dta = (int)((ta1-ta0)/24);  /* 24  triangle pairs per strip */
for(th=th0; th < th1; th += dth){
  glBegin(GL_TRIANGLE_STRIP);
  for(ta=ta0; ta < ta1; ta += dta){ drawvert(th,ta); drawvert(th+gap*dth,ta); }
  glEnd();
  } /* end for.theta loop */
}   /* end drawtor */

void drawcube(void){ /* transfer from skel.c as an exercise  */ }

void drawall(void){ drawtor(); drawcube();}

void drawstars(void){
int i;
static float star[1000][3];
static int virgin=1;
if(virgin){ /* the first time through the stars are set up */
  int ii,jj;
  float fact;
  virgin=0; /* never again */
  for(ii=0;ii<1000;ii++)
     {
     for(jj=0;jj<3;jj++) star[ii][jj] =   rand()/(float)0x40000000-1.;
     }
  }
  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();
  glMultMatrixf(starmat);
  glColor3f(1.0,1.0,0.0);    
  glBegin(GL_POINTS);
    for(i=0;i<1000;i++) glVertex3fv(star[i]);
  glEnd();
  glPopMatrix();
  glClear(GL_DEPTH_BUFFER_BIT);
}

void arguments(int argc,char **argv){
#if 0
  extern char *optarg;
  extern int optind; 
  int chi;   
  /* w: needs ONE number after -w, c<nothing> means NO number follows*/ 
  while ((chi = getopt(argc,argv,"w:d:g:")) != -1) 
  switch(chi)  {
                case 'w': win=atoi(optarg); break; 
                case 'g': gap0=atof(optarg); break;
                }
  if (optind!=argc) fprintf(stderr,"%s: Incorrect usage\n",argv[0]);
#endif
  win=1;
}

void dataprep(void){
   deFault();
}

void autotymer(int reset){
#define  TYME(cnt,max,act) {static cnt; if(first)cnt=max; else\
                            if(cnt?cnt--:0){ act ; goto Break;}}
  static first = 1;  /* the first time autymer is called */
  if(reset)first=1;  /* or if it is reset to start over  */
  TYME( shrink , 150,th0++;th1--;ta0++;ta1--)
  TYME( pause  , 20,          )
  TYME( grow   , 150,th0--;th1++;ta0--;ta1++)
  TYME( dwell  , 30,            )
  TYME(finish  , 1 , first = 1  )
  first = 0;
  Break:   ;   /* yes Virginia, C has gotos */
}

/*Beware of competing keys in CAVEsimulation and wnd==1   */
/* you may want to remap these keys to avoid the conflict */

void keyboard(unsigned char key, int x, int y){
#define  IF(K)            if(key==K)
#define  PRESS(K,A,b)     IF(K){b;}IF((K-32)){A;}  
/*was backwards in previous versions */
#define  TOGGLE(K,flg)    IF(K){(flg) = 1-(flg); }
#define  CYCLE(K,f,m)     PRESS((K), (f)=(((f)+(m)-1)%(m)),(f)=(++(f)%(m)))
#define  SLIDI(K,f,m,M)   PRESS(K,(--f<m?m:f), (++f>M?M:f))
#define  SLIDF(K,f,m,M,d) PRESS(K,((f -= d)<m?m:f), ((f += d)>M?M:f))
/* Only ASCII characters can be processes by this GLUT callback function */ 
   TOGGLE('v',binoc);                            /* cross-eyed STEREO   */
   TOGGLE('w',msg);                              /* writing on/off      */
   TOGGLE('h',morph);                            /* autotymer on/off    */
   PRESS('n', nose -= .001 , nose += .001 );     /* for binoculars      */
   CYCLE(' ', mode,TURNMODE+1);                  /* fly/turn modes      */
   PRESS('i', mysiz /= 1.1, mysiz *= 1.1)        /* rescale the world   */
   PRESS('o', focal *= 1.1 , focal /= 1.1)       /* telephoto           */
   PRESS('p', farw *= 1.01 , farw   /= 1.01)       /* rear clipping plane */
   PRESS('s',speed /= 1.02, speed *= 1.02);      /* flying speed        */
   PRESS('q',torq /= 1.02, torq *= 1.02);        /* turning speed       */
   PRESS('g',gap /= .99, gap *= .99);             /* gap parameter       */
   PRESS('z', deFault(), deFault());             /* zap changes         */
   IF(27) { exit(0); }              /* ESC exit            */
}

void special_keybo(int key, int x, int y){
/*non-ASCII keypresses go here, if you're lucky enough to know their names */
 fprintf(stderr," non-ASCII character was pressed.\n");
 fprintf(stderr," use special_keybo() to process it\n");
}
/* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */


/**********************************************************/
/*** console speedometer                                  */
/**********************************************************/
float speedometer(void){
double dbl; static double rate; static int ii=0;

static struct _timeb lnow, lthen;

   if(++ii % 8 == 0){  /* 8 times around measure time */

	   _ftime(&lnow);
		dbl =  (double)(lnow.time - lthen.time)
			 +(double)(lnow.millitm - lthen.millitm)/1000;
		lthen = lnow;  rate = 8/dbl;
      }

   return((float)rate);
}

void messages(void){     
  char buf[256]; /* console messages are done differently from cave */
#define  LABEL2(x,y,W,u) {sprintf(buf,(W),(u));char2wall(x,y,0.,buf);}
  glMatrixMode(GL_PROJECTION); glPushMatrix(); glLoadIdentity();
  gluOrtho2D(0,3000,0,3000);
  glMatrixMode(GL_MODELVIEW); glPushMatrix(); glLoadIdentity();
      /*bull's eye*/
      if(mode==0) glColor3f(0x22/255.,0x88/255.,0xdd/255.);
        else      glColor3f(.8,.8,.8);
      LABEL2(1500,1500,"%s","o");
      /* writings */
      if(mode==0) glColor3f(1.,0.,1.);
        else      glColor3f(1.,1.,0.);
      LABEL2(80,80,"%4.1f fps",speedometer());
      LABEL2(80,2840,\
      "(ESC)ape (V)Binoc (MAUS2)Fore (BAR)Flymode %s (H)omotopy (W)riting",
             mode?"FLYING":"CONTROL");
      LABEL2(10,10,"illiOpenSkelGLUT \
   by Francis, Bourd, Hartman & Chappell, U Illinois, 1995..1997 %s","");
      LABEL2(80,2770,"(N)ose   %0.3f",nose);
      LABEL2(80,2700,"(S)peed  %0.4f",speed);
      LABEL2(80,2630," tor(Q) %0.4f",torq);
      LABEL2(80,2560,"near clipper %g", mysiz*focal);
      LABEL2(80,2490,"f(O)cal factor %g",focal);
      LABEL2(80,2420,"my s(I)ze %.2g",mysiz);
      LABEL2(80,2350,"farw cli(P)er= %.2g",farw);
      LABEL2(80,2280,"(Z)ap %s","");
      LABEL2(80,2210,"(G)ap %.2g",gap);
    glPopMatrix();
glMatrixMode(GL_PROJECTION); glPopMatrix();
} 

void chaptrack(int but,int xx,int yy,int shif){  
   long dx,dy; 
   dx = xx -.5*xt; dx = ABS(dx)>5?dx:0;
   dy = yy -.5*yt; dy = ABS(dy)>5?dy:0;

   glMatrixMode(GL_MODELVIEW); glPushMatrix(); glLoadIdentity();

   if(mode==FLYMODE) glTranslatef(aff[12],aff[13],aff[14]);
   glRotatef(dx*torq,0.,1.,0.); glRotatef(dy*torq,1.,0.,0.);
   if(but&(1<<GLUT_RIGHT_BUTTON ))glRotatef(shif?-10:-1,0.,0.,1.);
   if(but&(1<<GLUT_LEFT_BUTTON  ))glRotatef(shif?10:1,0.,0.,1.);
   if(mode==TURNMODE){
      glPushMatrix();
      glMultMatrixf(starmat);
      glGetFloatv(GL_MODELVIEW_MATRIX,starmat);
      glPopMatrix();
   }
   if(but&(1<<GLUT_MIDDLE_BUTTON)) glTranslatef(0.,0.,shif ? -speed : speed);
   if(mode==FLYMODE) glTranslatef(-aff[12],-aff[13],-aff[14]);
   glMultMatrixf(aff); 
   glGetFloatv(GL_MODELVIEW_MATRIX,aff);
   {int ii,jj; for(ii=0;ii<3;ii++){ lu[ii]=0; /* calculite */
          for(jj=0;jj<3;jj++) lu[ii] += aff[ii*4+jj]*lux[jj];}}
   glPopMatrix();
}

void reshaped(int xx, int yy){xt=xx ; yt=yy;}   /* what is this for ? */

void drawcons(void){  
  glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
  if(binoc) glViewport(0,yt/4,xt/2,yt/2);
  glMatrixMode(GL_PROJECTION); glLoadIdentity();
  glFrustum(-mysiz*xt/yt,mysiz*xt/yt,-mysiz,mysiz,mysiz*focal,farw); 
  glMatrixMode(GL_MODELVIEW); glLoadIdentity();
  drawstars();
  glTranslatef(-binoc*nose,0.0,0.0);
  glMultMatrixf(aff);
  drawall();
  if(binoc){
    glViewport(xt/2,yt/4,xt/2,yt/2); 
    glMatrixMode(GL_MODELVIEW);
    glLoadIdentity();
    drawstars();
    glTranslatef(binoc*nose,0.0,0.0);
    glMultMatrixf(aff);
    drawall();
    }
  glViewport(0,0,xt,yt);
  if(msg) messages();
  glutSwapBuffers();
}

void idle(void){ /*do this when nothing else is happening*/
   if(morph) autotymer(0);  /* advance autotymer */ 
   glutPostRedisplay();  /*redraw the window*/
   chaptrack(BUT,XX,YY,SHIF);
}

void mousepushed(int but,int stat,int x,int y){
  if(stat==GLUT_DOWN) BUT |= (1<<but);
  else BUT &= (-1 ^ (1<<but));  
  XX=x; YY=y; SHIF=(glutGetModifiers()==GLUT_ACTIVE_SHIFT)?1:0;
}

void mousemoved(int x,int y){  XX=x; YY=y; }

void main(int argc, char **argv){  
   arguments(argc,argv); 
   dataprep();
 
       glutInit(&argc, argv);
       glutInitDisplayMode(GLUT_DOUBLE| GLUT_RGB |GLUT_DEPTH);
#if 0
	   switch(win)
         { case 0: break;
           case 1: glutInitWindowSize(640, 480);
                   glutInitWindowPosition(0,1024-480);
                   break;
           case 2: glutInitWindowPosition(0,0);
	           break;
         }
#endif
       glutCreateWindow("<* illiSkel in C/OpenGL/GLUT *>");
       if(win==2) glutFullScreen();
       glEnable(GL_DEPTH_TEST);
	   glShadeModel(GL_SMOOTH);
       glutDisplayFunc(drawcons);       
       glutKeyboardFunc(keyboard);
       glutSpecialFunc(special_keybo);
       glutMouseFunc(mousepushed);
       glutMotionFunc(mousemoved);       
       glutPassiveMotionFunc(mousemoved); 
       glutReshapeFunc(reshaped);
       glutIdleFunc(idle);             
       glutMainLoop();
}
 
