/***      bcoaster.c Paul McCreary 1997                         */
/****************************************************************/
/****            noosh.c = ishell97 to be                    ****/
/****           descended from ishell95                      ****/
/****            14 February 1995                            ****/
/****            29 August   1995                            ****/
/****             1 November 1995                            ****/ 
/****            15 november 1996   ishell96.c               ****/
/****            27 november 1996   ishell96.c               ****/
/****            23 march    1997   newsh.c                  ****/
/****            15 may    1997   noosh.c                    ****/
/****    (C) 1994 Board of Trustees University of Illinois   ****/ 
/****    A Model Real-Time Interactive CAVE Application      ****/
/****    George Francis, Glenn Chappell, Chris Hartman       ****/
/****    e-mail  gfrancis@math.uiuc.edu                      ****/
/****    Generic RTICA by GGC 7/25/94 revised gkf 12.30.94   ****/ 
/****    Revised by GGC and GKF august 95                    ****/
/****    "Opengl ed" by AVB, nov 14-15, 1996                 ****/
/****    Reformatted by AVB, nov 16, 1996                    ****/
/****    adaptation to CAVE 2.6Beta started 6feb97 gkf       ****/
/****    New version to fix many bugs and clean up 17mar97 cmh  */
/****    Rationalization begun 26mar97 gkf                   ****/    
/****    Insertion of Bishop Coaster CAVE-RTICA begun 1jun97 pmcc*/    
/****    Inserted slate for drawing/displaying development curve 12July97 pmcc*/    
/****    Inserted Runge-Kutta code 13July97 pmcc*/    
/****    Inserted flying frame code 14July97 am pmcc*/    
/****    Inserted R-K code for second frame (Frenet) 14July97 pm pmcc*/    

/****    Inserting coaster code 15July97 pm pmcc*/    
 
/****    Inserted Bishop (osculating) sphere 15July97 pm pmcc*/    
/****************************************************************/

/* Factor graph for this program. Please indicate structural modifications 
   The asterisk indicates a factor that has more than one function calling it. 
       main  
         arguments ....................command line switches and parameters 
           getopt  
         CAVEconfigure
         getmem .......................allocate shared memory  
           Malloc(share_var)
         dataprep .....................done only once   
           audioprep
             AUDinit
          *deFault 
         ifCAVE
           FrameFunc(cavetrack)........done once every frame 
                       *deFault........on the reset button combination
                       *autotymer .....automatic clockwork animation
                       *audiofunc .....sends messages to soundserver
           InitApplic(drawcaveinit)....done each frame 
           Display(drawcave)...........done each frame
                    *drawstars
                     graffiti..........on the front CAVE wall
                        char2wall
                    *drawall
                       drawtor.........compressed version of tr1.c 
                         dovert........do everything for one vertex
                       drawcube........transfer from skel.c as exercise 
           while(notESC) cavekeybo.....done asynchronously from display
                           *deFault
           audioclean .................shut down audio server
           Exit........................shut down CAVE properly 
         ifCONS
           gluttery....................we use the GLUT library
              drawcons.................analogue to drawcave
                *drawstars
                *drawall 
                  drawGammaFS();
                  drawFrameFS();
                  drawGammaB();
                  drawPath();
                  drawOsculatingSphere();
                messages...............analogue to grafitti
                  char2wall
                  speedometer..........unix based speedometer
              keyboard.................GLUT distinguishes between ascii keys 
                *deFault
                *audioclean
              special_keybo............and other kinds of keys
              mousepushed..............mouse buttons were pressed
              mousemoved...............mouse was moved       
              reshaped.................what to do if window is reshaped
              idle.....................done when nothing else is being done 
                 chaptrack.............updates the two affine matrices 
                *autotymer.............updates the animation parameters
                *audiofunc.............updates the sound servers  
         endIF 
*/
#include <stdlib.h>
/*#include <sys/types.h>*/
#include <math.h>
#include <sys/timeb.h>
#include <stdio.h>
#include <malloc.h>
#include <windows.h>
#include <GL/glut.h>



#ifdef SOUND
/*
#include <device.h>
*/
#include <string.h>
/*#include "vssClient.h"   changed in windows*/
#endif
#ifdef CAVE
#include <cave_ogl.h>
#include <cave.macros.h>
#endif 

/* Examples of useful geometric macros, use inliners in C++ */
#define  M_PI             355/115  //changed in windows
#define  MAX(x,y)         (((x)<(y))?(y):(x))
#define  MIN(x,y)         (((x)<(y))?(x):(y))
#define  FOR(a,b,c)       for((a)=(b);(a)<(c);(a)++)
#define  DOT(p,q)         ((p)[0]*(q)[0]+(p)[1]*(q)[1]+(p)[2]*(q)[2])
#define  NRM(p)           sqrt(DOT((p),(p)))
#define  DG            M_PI/180
#define  S(u)          sin(u*DG)
#define  C(u)          cos(u*DG)
#define  CLAMP(x,u,v) (x<u? u : (x>v ? v: x))
#define  GETS(pt1,pt2)  FOR(inx,0,3){pt1[inx]=pt2[inx];}


/* global variables ... add new ones on top of the stack */
char which[20]; /* audio needs this */
int delta; /* new variables for autotymer to change torus */
float gap, gap0=1.; /*very bad kludge ... for letting arguments reset default gap value */
int audiohandle; /* for telling vss the name of the .aud file */
float lux[3]={1.,2.,3.};             /*light source direction vector        */
float mysiz,speed, torq, focal, wfar; /*console navigation variables         */
int win = 1;                         /* full screen, use 0 for demand sized */
unsigned int BUT,XX,YY,SHIF;     /* used in chaptrack gluttery           */ 
int xt,yt;                       /* once was xt,yt,xm,ym for viewportery */
int caveyes=0;                      /* rename? ----------> caveflag */
float lu[3];                         /* current light direction vector*/
int mode,morph,msg,binoc;            /* pretty global */
int th0, th1, dth, ta0, ta1, dta;    /* torus parameters */
#define FLYMODE  (0)
#define TURNMODE (1) 
#define Pi M_PI
#define NAP 57 /***Number of arc points*****/ 
#define GAP 200 /***Number of arc points for gamma (space curve)*****/ 
#define FRESER 1
#define BISHOP 2
#define BOTHFRAMES 0
#define GG 3  /* curve index */
#define TT 0  /* tangent index */  /**N.B. TT must = 0 as frenetFrame[inx=TT,NN,BB]**/
#define NN 1  /* normal index */
#define BB 2  /* binormal index */
#define M1 1  /* first normal index */  /**N.B. TT must = 0 as bFrame[inx=TT,M1,M2]**/
#define M2 2  /* second normal index */
#define X 0	/* x-coordinate or auxiliary "type" of frame or still */
#define Y 1
#define Z 2
#define AAAA 0
#define BBBB 1
#define CCCC 2
#define DDDD 3

/*Shared memory variables as per Stuart Levy 1994 */  
struct share_var{ 
   float  s_siz;         /*final scaling factor before projection      */  
   int s_wnd;            /*wand or maus flag                           */
   int s_gnd;            /*background color                            */
   int s_mauspaw ;      /*binary for mouse button state                     */
   int s_th0 ;           /* since the autotymer changes these          */
   int s_th1 ;           /* they need to be shared                      */
   int s_ta0 ;           /*                                             */
   int s_ta1 ;           /*                                             */
   int s_showslate ;     /*  show/or not                              */
   int s_showFrame ;     /*  show/or not                              */
   int s_showSphere ;     /*  show/or not                              */
   int s_computeOnTheFly ;     /*  switch to ...                              */
   int s_inx ;     /*  integer variable for macro defs                 */
   int s_posOnGam ;     /*  positon on gamma                */
   int s_vernierInx ;     /*  vernier scale used to Lirp position of the frame  */
   int s_jumP ;     /*  size of jump forward on vernier scale for frame  */
   int s_whichGamma ;     /*  size of jump forward on vernier scale for frame  */
   float s_gap ;           /*                                             */
   float s_slate[5][3] ;           /*                                             */
   float s_DCent ;           /* center of development line segment        */
   float s_DHalfLeng ;           /*                             */
   float s_DDist ;           /*                             */
   float s_DAngle ;           /*                                             */
   float s_develoPts[2][3] ;           /*                                             */
   float s_DCirc[NAP][3] ;           /*                                             */
   float s_gammaLength ;           /*                             */
   float s_gammaB[GAP][3] ;           /*                                             */
   float s_gammaFS[GAP][3] ;           /*                                             */
   float s_bFrame[GAP][3][2][3] ;  /* bFrame[#pts][3 vectors][2 ends][3 coordinates] */
   float s_fsFrame[GAP][3][2][3] ;  /* bFrame[#pts][3 vectors][2 ends][3 coordinates] */
   float s_bFlyer[3][2][3] ;  /* Bishop frame flyer */
   float s_fsFlyer[3][2][3] ;  /* Bishop frame flyer */
   float s_bFlyerMast[3][3][3] ;  /* Bishop frame flyer */
   float s_fsFlyerMast[3][3][3] ;  /* Bishop frame flyer */
   float s_bPath[GAP][2][3] ;  /* bPath = twisting ribbon connected to space curve gamma */
   float s_fsPath[GAP][2][3] ;  /* fsPath = twisting ribbon connected to space curve gamma */
   float s_oscSphere[GAP][GAP][3] ;  /* fsPath = twisting ribbon connected to space curve gamma */
   GLfloat s_aff[16],s_starmat[16]; /*affine matrices for object, stars*/
} *s_var; 

#define siz     (s_var->s_siz)
#define wnd     (s_var->s_wnd)
#define gnd     (s_var->s_gnd)  /* use only if printframe function is present */
#define aff     (s_var->s_aff)  
#define starmat (s_var->s_starmat)
#define mauspaw (s_var->s_mauspaw)
#define th0 (s_var->s_th0)
#define th1 (s_var->s_th1)
#define ta0 (s_var->s_ta0)
#define ta1 (s_var->s_ta1)
#define showslate (s_var->s_showslate)
#define showFrame (s_var->s_showFrame)
#define showSphere (s_var->s_showSphere)
#define computeOnTheFly (s_var->s_computeOnTheFly)
#define inx (s_var->s_inx)
#define posOnGam (s_var->s_posOnGam)
#define vernierInx (s_var->s_vernierInx)
#define jumP (s_var->s_jumP)
#define whichGamma (s_var->s_whichGamma)
#define gap (s_var->s_gap)
#define slate (s_var->s_slate)
#define DCent (s_var->s_DCent)
#define DHalfLeng (s_var->s_DHalfLeng)
#define DDist (s_var->s_DDist)
#define DAngle (s_var->s_DAngle)
#define develoPts (s_var->s_develoPts)
#define DCirc (s_var->s_DCirc)
#define gammaLength (s_var->s_gammaLength)
#define gammaB (s_var->s_gammaB)
#define gammaFS (s_var->s_gammaFS)
#define bFrame (s_var->s_bFrame)
#define fsFrame (s_var->s_fsFrame)
#define bFlyer (s_var->s_bFlyer)
#define fsFlyer (s_var->s_fsFlyer)
#define bFlyerMast (s_var->s_bFlyerMast)
#define fsFlyerMast (s_var->s_fsFlyerMast)
#define bPath (s_var->s_bPath)
#define fsPath (s_var->s_fsPath)
#define oscSphere (s_var->s_oscSphere)

/* these are used only in console mode      */
int binoc;    /* flag                       */
float nose;   /* to eye distance in console */

void getmem(void){
  if(caveyes)
#ifdef CAVE
     s_var = CAVEMalloc(sizeof(struct share_var))
#endif
     ;
   else
     s_var = malloc(sizeof(struct share_var));
  if(s_var==NULL)
    {fprintf(stderr,"No room to share! %x \n",s_var); exit(1);}
}

void char2wall(GLfloat x,GLfloat y, GLfloat z, char buf[]){
     char *p; glRasterPos3f(x,y,z);
     for(p = buf;*p;p++) glutBitmapCharacter(GLUT_BITMAP_9_BY_15,*p);
}

void autotymer(int);  /* to allow deFault to call the autotymer later */

void deFault(void){
int ii; float tmp;
th0=5; th1=355;  dth=15; ta0=5; ta1=355; dta=15; gap = gap0; 
FOR(ii,0,5){
	slate[ii][2]=0;
}	
slate[0][0]=slate[0][1]=slate[1][1]=slate[3][0]=slate[4][0]=slate[4][1]=0;
slate[1][0]=slate[2][0]=slate[2][1]=slate[3][1]=1;
DCent=0;DHalfLeng=.5;DDist=.3;DAngle=0;gammaLength=10;showslate=1;
vernierInx=200;jumP=200;
msg=1; binoc=0; nose=.06; mauspaw = 0; wnd = 1; siz = 1.; mode=TURNMODE;  
speed=.1; torq=.02; focal = 2.; wfar =25.; mysiz=.01; morph=0;
whichGamma=BISHOP; 
for(ii=0;ii<16;ii++)  starmat[ii]=aff[ii] = (ii/4==ii%4) ? 1 : 0;   
tmp=NRM(lux);  for(ii=0;ii<3;ii++)lux[ii]/=tmp;
if(caveyes){aff[12]=0; aff[13]= 5; aff[14]= -10 ; } /*5ft beyond front wall*/ 
       else{aff[12]=0; aff[13]= 0; aff[14]= -12.2; } /*inside the console */ 
autotymer(1); /* reset autotymer to start at the beginning */
adjustNormalDev();/* initialize development curve */
rungeKuttaTheFrame();
createOsculatingSphere();
}

quadurn(float pt[3],float cs[2],int axxx){/** rotates pt about axis-axxx
			orientation==smaller indexed axis towards larger one, 
			so for axxx=1, axis 0=X is rotated towards axis 2=Z **/
	float tmp;
	switch(axxx){
		case 0:
			tmp=cs[0]*pt[1]-cs[1]*pt[2];
			pt[2]=cs[1]*pt[1]+cs[0]*pt[2];
			pt[1]=tmp;
		break;
		case 1:
			tmp=cs[0]*pt[0]-cs[1]*pt[2];
			pt[2]=cs[1]*pt[0]+cs[0]*pt[2];
			pt[0]=tmp;
		break;
		case 2:
			tmp=cs[0]*pt[0]-cs[1]*pt[1];
			pt[1]=cs[1]*pt[0]+cs[0]*pt[1];
			pt[0]=tmp;
		break;
	}
}
/****************************************/
/****Runge-Kutta and associated functions******/
/****************************************/
/****Note:  der_X = derivative of X******/
/****************************************/
/***der_Gamma is same for both Bishop and Frenet frames***/
float der_Gamma(float TTT){
	return  TTT;
}
/*** for computing the Bishop frame******/
float der_Tb(float nn,float TTT,float M11,float M22){
	return  ((DCent-DHalfLeng)+nn/gammaLength*(DHalfLeng*2))*M11 + DDist*M22;
}
float der_M1(float nn,float TTT,float M11,float M22){
	return  -((DCent-DHalfLeng)+nn/gammaLength*(DHalfLeng*2))*TTT;
}

float der_M2(float nn,float TTT,float M11,float M22){
	return  -DDist*TTT;
}
/*** for computing the Frenet frame******/
float der_Tf(float nn,float TTT,float NNN,float BBB){
	return  pow(((DCent-DHalfLeng)+nn/gammaLength*(DHalfLeng*2))*((DCent-DHalfLeng)+nn/gammaLength*(DHalfLeng*2))+DDist*DDist,.5)*NNN;
		/** = kappa*N  **/
}
float der_Nnn(float nn,float TTT,float NNN,float BBB){
	float frac4;
	frac4=(float)nn/gammaLength;/** = arclength parameter **/
	return  -pow(((DCent-DHalfLeng)+frac4*(DHalfLeng*2))*((DCent-DHalfLeng)+frac4*(DHalfLeng*2))+DDist*DDist,.5)*TTT + 
		(-1)*DDist*DHalfLeng*2/(pow(DCent-DHalfLeng+frac4*DHalfLeng*2,2)+DDist*DDist) * BBB;

	/** = -kappa T + tau B  **/
}

float der_Bbb(float nn,float TTT,float NNN,float BBB){
	float frac4;
	frac4=(float)nn/gammaLength;/** = arclength parameter **/
	return  -(-1)*DDist*DHalfLeng*2/(pow(DCent-DHalfLeng+frac4*DHalfLeng*2,2)+DDist*DDist)*NNN;
	
	/** = -tau N **/
}
rungeKuttaTheFrame(){/**Uses precomputed values of k_1 and k_2
			to construct the (not Frenet) framed curve **/
	int ii, jj, kk;
	float	/**for x-coordinate**/
		/**(G)amma curve**/
		Gx1, dxG, gx1, gx2, gx3, gx4,
		/** 
		initial value, 
		     step,
			  ,variables for transition functions:
				 4 transition variables for Runge Kutta **/
	 	/**Bishop frame vectors (T,M1,M2)**/
		Tx1, dxT, tmpxT, tx1, tx2, tx3, tx4,
		M1x1, dxM1, tmpxM1, m1x1, m1x2, m1x3, m1x4,
		M2x1, dxM2, tmpxM2, m2x1, m2x2, m2x3, m2x4,
		
		/**for y-coordinate**/
		/**(G)amma curve**/
		Gy1, dyG, gy1, gy2, gy3, gy4,
	 	/**Bishop frame vectors (T,M1,M2)**/
		Ty1, dyT, tmpyT, ty1, ty2, ty3, ty4,
		M1y1, dyM1, tmpyM1, m1y1, m1y2, m1y3, m1y4,
		M2y1, dyM2, tmpyM2, m2y1, m2y2, m2y3, m2y4,
		
		/**for z-coordinate**/
		/**(G)amma curve**/
		Gz1, dzG, gz1, gz2, gz3, gz4,
	 	/**Bishop frame vectors (T,M1,M2)**/
		Tz1, dzT, tmpzT, tz1, tz2, tz3, tz4,
		M1z1, dzM1, tmpzM1, m1z1, m1z2, m1z3, m1z4,
		M2z1, dzM2, tmpzM2, m2z1, m2z2, m2z3, m2z4,

		/**time variables**/		
		h,hhh;
	float t1,tmp1;
	int ppi=1;
	float initValsForFrame[3][3];/**probably could eliminate**/

	initValsForFrame[X][GG]=1;initValsForFrame[Y][GG]=0;initValsForFrame[Z][GG]=0;
	initValsForFrame[X][TT]=0;initValsForFrame[Y][TT]=1;initValsForFrame[Z][TT]=0;
	initValsForFrame[X][NN]=-1;initValsForFrame[Y][NN]=0;initValsForFrame[Z][NN]=0;
	initValsForFrame[X][BB]=0;initValsForFrame[Y][BB]=0;initValsForFrame[Z][BB]=1;

	/**Here is variable number of points placed between each point computed on Gamma**/
	/**As ppi gets larger, this is equivalent to decreasing the step size in the R-K process**/
	ppi=1;

	/*hhh=portion of curve traversed each step*/
	hhh=(float)1.0/(GAP-1)*gammaLength;
	/** initial conditions specified in determineInitialConditions() **/
	h=fabs(hhh);/**only positive steps here**/
	/*initialization of function values:*/
	t1=0;Gx1=initValsForFrame[X][GG];
		Tx1=initValsForFrame[X][TT];
			M1x1=initValsForFrame[X][NN];
				M2x1=initValsForFrame[X][BB];
	     
	     Gy1=initValsForFrame[Y][GG];
		Ty1=initValsForFrame[Y][TT];
			M1y1=initValsForFrame[Y][NN];
				M2y1=initValsForFrame[Y][BB];
	     
	     Gz1=initValsForFrame[Z][GG];
		Tz1=initValsForFrame[Z][TT];
			M1z1=initValsForFrame[Z][NN];
				M2z1=initValsForFrame[Z][BB];
	
    switch(whichGamma){

	case BOTHFRAMES:
	FOR(ii,0,GAP){
		/*record the solution of this step**/
		if(ii%ppi==0){
			gammaFS[ii][X]=Gx1;gammaFS[ii][Y]=Gy1;gammaFS[ii][Z]=Gz1;
			FOR(jj,0,3){
				GETS(fsFrame[ii][jj][0],gammaFS[ii]);
			}
			fsFrame[ii/ppi][TT][1][X]=Tx1+gammaFS[ii][X];
			fsFrame[ii/ppi][TT][1][Y]=Ty1+gammaFS[ii][Y];
			fsFrame[ii/ppi][TT][1][Z]=Tz1+gammaFS[ii][Z];
			fsFrame[ii/ppi][NN][1][X]=M1x1+gammaFS[ii][X];
			fsFrame[ii/ppi][NN][1][Y]=M1y1+gammaFS[ii][Y];
			fsFrame[ii/ppi][NN][1][Z]=M1z1+gammaFS[ii][Z];
			fsFrame[ii/ppi][BB][1][X]=M2x1+gammaFS[ii][X];
			fsFrame[ii/ppi][BB][1][Y]=M2y1+gammaFS[ii][Y];
			fsFrame[ii/ppi][BB][1][Z]=M2z1+gammaFS[ii][Z];
		}
		/*step 1*/
		tx1=h*der_Tf(t1,Tx1,M1x1,M2x1);
		ty1=h*der_Tf(t1,Ty1,M1y1,M2y1);
		tz1=h*der_Tf(t1,Tz1,M1z1,M2z1);
		m1x1=h*der_Nnn(t1,Tx1,M1x1,M2x1);
		m1y1=h*der_Nnn(t1,Ty1,M1y1,M2y1);
		m1z1=h*der_Nnn(t1,Tz1,M1z1,M2z1);
		m2x1=h*der_Bbb(t1,Tx1,M1x1,M2x1);
		m2y1=h*der_Bbb(t1,Ty1,M1y1,M2y1);
		m2z1=h*der_Bbb(t1,Tz1,M1z1,M2z1);
		gx1=h*der_Gamma(Tx1);
		gy1=h*der_Gamma(Ty1);
		gz1=h*der_Gamma(Tz1);
		/*step 2*/
		tmp1=t1+h/2;
			     tmpxT=Tx1+.5*tx1;tmpxM1=M1x1+.5*m1x1;tmpxM2=M2x1+.5*m2x1;
			     tmpyT=Ty1+.5*ty1;tmpyM1=M1y1+.5*m1y1;tmpyM2=M2y1+.5*m2y1;
			     tmpzT=Tz1+.5*tz1;tmpzM1=M1z1+.5*m1z1;tmpzM2=M2z1+.5*m2z1;
		tx2=h*der_Tf(tmp1,tmpxT,tmpxM1,tmpxM2);
		ty2=h*der_Tf(tmp1,tmpyT,tmpyM1,tmpyM2);
		tz2=h*der_Tf(tmp1,tmpzT,tmpzM1,tmpzM2);
		m1x2=h*der_Nnn(tmp1,tmpxT,tmpxM1,tmpxM2);
		m1y2=h*der_Nnn(tmp1,tmpyT,tmpyM1,tmpyM2);
		m1z2=h*der_Nnn(tmp1,tmpzT,tmpzM1,tmpzM2);
		m2x2=h*der_Bbb(tmp1,tmpxT,tmpxM1,tmpxM2);
		m2y2=h*der_Bbb(tmp1,tmpyT,tmpyM1,tmpyM2);
		m2z2=h*der_Bbb(tmp1,tmpzT,tmpzM1,tmpzM2);
		gx2=h*der_Gamma(tmpxT);
		gy2=h*der_Gamma(tmpyT);
		gz2=h*der_Gamma(tmpzT);
		/*step 3*/
			     tmpxT=Tx1+.5*tx2;tmpxM1=M1x1+.5*m1x2;tmpxM2=M2x1+.5*m2x2;
			     tmpyT=Ty1+.5*ty2;tmpyM1=M1y1+.5*m1y2;tmpyM2=M2y1+.5*m2y2;
			     tmpzT=Tz1+.5*tz2;tmpzM1=M1z1+.5*m1z2;tmpzM2=M2z1+.5*m2z2;
		tx3=h*der_Tf(tmp1,tmpxT,tmpxM1,tmpxM2);
		ty3=h*der_Tf(tmp1,tmpyT,tmpyM1,tmpyM2);
		tz3=h*der_Tf(tmp1,tmpzT,tmpzM1,tmpzM2);
		m1x3=h*der_Nnn(tmp1,tmpxT,tmpxM1,tmpxM2);
		m1y3=h*der_Nnn(tmp1,tmpyT,tmpyM1,tmpyM2);
		m1z3=h*der_Nnn(tmp1,tmpzT,tmpzM1,tmpzM2);
		m2x3=h*der_Bbb(tmp1,tmpxT,tmpxM1,tmpxM2);
		m2y3=h*der_Bbb(tmp1,tmpyT,tmpyM1,tmpyM2);
		m2z3=h*der_Bbb(tmp1,tmpzT,tmpzM1,tmpzM2);
		gx3=h*der_Gamma(tmpxT);
		gy3=h*der_Gamma(tmpyT);
		gz3=h*der_Gamma(tmpzT);
		/*step 4*/
		/**/tmp1=t1+h;/**/
			  tmpxT=Tx1+tx3;tmpxM1=M1x1+m1x3;tmpxM2=M2x1+m2x3;
			  tmpyT=Ty1+ty3;tmpyM1=M1y1+m1y3;tmpyM2=M2y1+m2y3;
			  tmpzT=Tz1+tz3;tmpzM1=M1z1+m1z3;tmpzM2=M2z1+m2z3;
		tx4=h*der_Tf(tmp1,tmpxT,tmpxM1,tmpxM2);
		ty4=h*der_Tf(tmp1,tmpyT,tmpyM1,tmpyM2);
		tz4=h*der_Tf(tmp1,tmpzT,tmpzM1,tmpzM2);
		m1x4=h*der_Nnn(tmp1,tmpxT,tmpxM1,tmpxM2);
		m1y4=h*der_Nnn(tmp1,tmpyT,tmpyM1,tmpyM2);
		m1z4=h*der_Nnn(tmp1,tmpzT,tmpzM1,tmpzM2);
		m2x4=h*der_Bbb(tmp1,tmpxT,tmpxM1,tmpxM2);
		m2y4=h*der_Bbb(tmp1,tmpyT,tmpyM1,tmpyM2);
		m2z4=h*der_Bbb(tmp1,tmpzT,tmpzM1,tmpzM2);
		gx4=h*der_Gamma(tmpxT);
		gy4=h*der_Gamma(tmpyT);
		gz4=h*der_Gamma(tmpzT);
		/*changes in all parameters*/
		dxG=(gx1+gx2+gx2+gx3+gx3+gx4)/6.;
		dyG=(gy1+gy2+gy2+gy3+gy3+gy4)/6.;
		dzG=(gz1+gz2+gz2+gz3+gz3+gz4)/6.;
		dxT=(tx1+tx2+tx2+tx3+tx3+tx4)/6.;
		dyT=(ty1+ty2+ty2+ty3+ty3+ty4)/6.;
		dzT=(tz1+tz2+tz2+tz3+tz3+tz4)/6.;
		dxM1=(m1x1+m1x2+m1x2+m1x3+m1x3+m1x4)/6.;
		dyM1=(m1y1+m1y2+m1y2+m1y3+m1y3+m1y4)/6.;
		dzM1=(m1z1+m1z2+m1z2+m1z3+m1z3+m1z4)/6.;
		dxM2=(m2x1+m2x2+m2x2+m2x3+m2x3+m2x4)/6.;
		dyM2=(m2y1+m2y2+m2y2+m2y3+m2y3+m2y4)/6.;
		dzM2=(m2z1+m2z2+m2z2+m2z3+m2z3+m2z4)/6.;
		/*update parameter values*/
		/**/t1+=h; /**/
		Gx1+=dxG;Gy1+=dyG;Gz1+=dzG;	
		Tx1+=dxT;Ty1+=dyT;Tz1+=dzT;	
		M1x1+=dxM1;M1y1+=dyM1;M1z1+=dzM1;	
		M2x1+=dxM2;M2y1+=dyM2;M2z1+=dzM2;
	}/*end of loop*/ 	
	/*reset initial values for Bishop frame when computing BOTHFRAMES*/
	initValsForFrame[X][GG]=1;initValsForFrame[Y][GG]=0;initValsForFrame[Z][GG]=0;
	initValsForFrame[X][TT]=0;initValsForFrame[Y][TT]=1;initValsForFrame[Z][TT]=0;
	initValsForFrame[X][NN]=-1;initValsForFrame[Y][NN]=0;initValsForFrame[Z][NN]=0;
	initValsForFrame[X][BB]=0;initValsForFrame[Y][BB]=0;initValsForFrame[Z][BB]=1;

	/**Here is variable number of points placed between each point computed on Gamma**/
	/**As ppi gets larger, this is equivalent to decreasing the step size in the R-K process**/
	ppi=1;

	/*hhh=portion of curve traversed each step*/
	hhh=(float)1.0/(GAP-1)*gammaLength;
	/** initial conditions specified in determineInitialConditions() **/
	h=fabs(hhh);/**only positive steps here**/
	/*initialization of function values:*/
	t1=0;Gx1=initValsForFrame[X][GG];
		Tx1=initValsForFrame[X][TT];
			M1x1=initValsForFrame[X][NN];
				M2x1=initValsForFrame[X][BB];
	     
	     Gy1=initValsForFrame[Y][GG];
		Ty1=initValsForFrame[Y][TT];
			M1y1=initValsForFrame[Y][NN];
				M2y1=initValsForFrame[Y][BB];
	     
	     Gz1=initValsForFrame[Z][GG];
		Tz1=initValsForFrame[Z][TT];
			M1z1=initValsForFrame[Z][NN];
				M2z1=initValsForFrame[Z][BB];
	/**No break;**/
	case BISHOP:
	FOR(ii,0,GAP){
		/*record the solution of this step**/
		if(ii%ppi==0){
			gammaB[ii][X]=Gx1;gammaB[ii][Y]=Gy1;gammaB[ii][Z]=Gz1;
			FOR(jj,0,3){
				GETS(bFrame[ii][jj][0],gammaB[ii]);
			}
			bFrame[ii/ppi][TT][1][X]=Tx1+gammaB[ii][X];
			bFrame[ii/ppi][TT][1][Y]=Ty1+gammaB[ii][Y];
			bFrame[ii/ppi][TT][1][Z]=Tz1+gammaB[ii][Z];
			bFrame[ii/ppi][NN][1][X]=M1x1+gammaB[ii][X];
			bFrame[ii/ppi][NN][1][Y]=M1y1+gammaB[ii][Y];
			bFrame[ii/ppi][NN][1][Z]=M1z1+gammaB[ii][Z];
			bFrame[ii/ppi][BB][1][X]=M2x1+gammaB[ii][X];
			bFrame[ii/ppi][BB][1][Y]=M2y1+gammaB[ii][Y];
			bFrame[ii/ppi][BB][1][Z]=M2z1+gammaB[ii][Z];
		}
		/*step 1*/
		tx1=h*der_Tb(t1,Tx1,M1x1,M2x1);
		ty1=h*der_Tb(t1,Ty1,M1y1,M2y1);
		tz1=h*der_Tb(t1,Tz1,M1z1,M2z1);
		m1x1=h*der_M1(t1,Tx1,M1x1,M2x1);
		m1y1=h*der_M1(t1,Ty1,M1y1,M2y1);
		m1z1=h*der_M1(t1,Tz1,M1z1,M2z1);
		m2x1=h*der_M2(t1,Tx1,M1x1,M2x1);
		m2y1=h*der_M2(t1,Ty1,M1y1,M2y1);
		m2z1=h*der_M2(t1,Tz1,M1z1,M2z1);
		gx1=h*der_Gamma(Tx1);
		gy1=h*der_Gamma(Ty1);
		gz1=h*der_Gamma(Tz1);
		/*step 2*/
		tmp1=t1+h/2;
			     tmpxT=Tx1+.5*tx1;tmpxM1=M1x1+.5*m1x1;tmpxM2=M2x1+.5*m2x1;
			     tmpyT=Ty1+.5*ty1;tmpyM1=M1y1+.5*m1y1;tmpyM2=M2y1+.5*m2y1;
			     tmpzT=Tz1+.5*tz1;tmpzM1=M1z1+.5*m1z1;tmpzM2=M2z1+.5*m2z1;
		tx2=h*der_Tb(tmp1,tmpxT,tmpxM1,tmpxM2);
		ty2=h*der_Tb(tmp1,tmpyT,tmpyM1,tmpyM2);
		tz2=h*der_Tb(tmp1,tmpzT,tmpzM1,tmpzM2);
		m1x2=h*der_M1(tmp1,tmpxT,tmpxM1,tmpxM2);
		m1y2=h*der_M1(tmp1,tmpyT,tmpyM1,tmpyM2);
		m1z2=h*der_M1(tmp1,tmpzT,tmpzM1,tmpzM2);
		m2x2=h*der_M2(tmp1,tmpxT,tmpxM1,tmpxM2);
		m2y2=h*der_M2(tmp1,tmpyT,tmpyM1,tmpyM2);
		m2z2=h*der_M2(tmp1,tmpzT,tmpzM1,tmpzM2);
		gx2=h*der_Gamma(tmpxT);
		gy2=h*der_Gamma(tmpyT);
		gz2=h*der_Gamma(tmpzT);
		/*step 3*/
			     tmpxT=Tx1+.5*tx2;tmpxM1=M1x1+.5*m1x2;tmpxM2=M2x1+.5*m2x2;
			     tmpyT=Ty1+.5*ty2;tmpyM1=M1y1+.5*m1y2;tmpyM2=M2y1+.5*m2y2;
			     tmpzT=Tz1+.5*tz2;tmpzM1=M1z1+.5*m1z2;tmpzM2=M2z1+.5*m2z2;
		tx3=h*der_Tb(tmp1,tmpxT,tmpxM1,tmpxM2);
		ty3=h*der_Tb(tmp1,tmpyT,tmpyM1,tmpyM2);
		tz3=h*der_Tb(tmp1,tmpzT,tmpzM1,tmpzM2);
		m1x3=h*der_M1(tmp1,tmpxT,tmpxM1,tmpxM2);
		m1y3=h*der_M1(tmp1,tmpyT,tmpyM1,tmpyM2);
		m1z3=h*der_M1(tmp1,tmpzT,tmpzM1,tmpzM2);
		m2x3=h*der_M2(tmp1,tmpxT,tmpxM1,tmpxM2);
		m2y3=h*der_M2(tmp1,tmpyT,tmpyM1,tmpyM2);
		m2z3=h*der_M2(tmp1,tmpzT,tmpzM1,tmpzM2);
		gx3=h*der_Gamma(tmpxT);
		gy3=h*der_Gamma(tmpyT);
		gz3=h*der_Gamma(tmpzT);
		/*step 4*/
		/**/tmp1=t1+h;/**/
			  tmpxT=Tx1+tx3;tmpxM1=M1x1+m1x3;tmpxM2=M2x1+m2x3;
			  tmpyT=Ty1+ty3;tmpyM1=M1y1+m1y3;tmpyM2=M2y1+m2y3;
			  tmpzT=Tz1+tz3;tmpzM1=M1z1+m1z3;tmpzM2=M2z1+m2z3;
		tx4=h*der_Tb(tmp1,tmpxT,tmpxM1,tmpxM2);
		ty4=h*der_Tb(tmp1,tmpyT,tmpyM1,tmpyM2);
		tz4=h*der_Tb(tmp1,tmpzT,tmpzM1,tmpzM2);
		m1x4=h*der_M1(tmp1,tmpxT,tmpxM1,tmpxM2);
		m1y4=h*der_M1(tmp1,tmpyT,tmpyM1,tmpyM2);
		m1z4=h*der_M1(tmp1,tmpzT,tmpzM1,tmpzM2);
		m2x4=h*der_M2(tmp1,tmpxT,tmpxM1,tmpxM2);
		m2y4=h*der_M2(tmp1,tmpyT,tmpyM1,tmpyM2);
		m2z4=h*der_M2(tmp1,tmpzT,tmpzM1,tmpzM2);
		gx4=h*der_Gamma(tmpxT);
		gy4=h*der_Gamma(tmpyT);
		gz4=h*der_Gamma(tmpzT);
		/*changes in all parameters*/
		dxG=(gx1+gx2+gx2+gx3+gx3+gx4)/6.;
		dyG=(gy1+gy2+gy2+gy3+gy3+gy4)/6.;
		dzG=(gz1+gz2+gz2+gz3+gz3+gz4)/6.;
		dxT=(tx1+tx2+tx2+tx3+tx3+tx4)/6.;
		dyT=(ty1+ty2+ty2+ty3+ty3+ty4)/6.;
		dzT=(tz1+tz2+tz2+tz3+tz3+tz4)/6.;
		dxM1=(m1x1+m1x2+m1x2+m1x3+m1x3+m1x4)/6.;
		dyM1=(m1y1+m1y2+m1y2+m1y3+m1y3+m1y4)/6.;
		dzM1=(m1z1+m1z2+m1z2+m1z3+m1z3+m1z4)/6.;
		dxM2=(m2x1+m2x2+m2x2+m2x3+m2x3+m2x4)/6.;
		dyM2=(m2y1+m2y2+m2y2+m2y3+m2y3+m2y4)/6.;
		dzM2=(m2z1+m2z2+m2z2+m2z3+m2z3+m2z4)/6.;
		/*update parameter values*/
		/**/t1+=h; /**/
		Gx1+=dxG;Gy1+=dyG;Gz1+=dzG;	
		Tx1+=dxT;Ty1+=dyT;Tz1+=dzT;	
		M1x1+=dxM1;M1y1+=dyM1;M1z1+=dzM1;	
		M2x1+=dxM2;M2y1+=dyM2;M2z1+=dzM2;
	}/*end of loop*/ 	
	/**/constructPath();/**/
	break;

	case FRESER:
	FOR(ii,0,GAP){
		/*record the solution of this step**/
		if(ii%ppi==0){
			gammaFS[ii][X]=Gx1;gammaFS[ii][Y]=Gy1;gammaFS[ii][Z]=Gz1;
			FOR(jj,0,3){
				GETS(fsFrame[ii][jj][0],gammaFS[ii]);
			}
			fsFrame[ii/ppi][TT][1][X]=Tx1+gammaFS[ii][X];
			fsFrame[ii/ppi][TT][1][Y]=Ty1+gammaFS[ii][Y];
			fsFrame[ii/ppi][TT][1][Z]=Tz1+gammaFS[ii][Z];
			fsFrame[ii/ppi][NN][1][X]=M1x1+gammaFS[ii][X];
			fsFrame[ii/ppi][NN][1][Y]=M1y1+gammaFS[ii][Y];
			fsFrame[ii/ppi][NN][1][Z]=M1z1+gammaFS[ii][Z];
			fsFrame[ii/ppi][BB][1][X]=M2x1+gammaFS[ii][X];
			fsFrame[ii/ppi][BB][1][Y]=M2y1+gammaFS[ii][Y];
			fsFrame[ii/ppi][BB][1][Z]=M2z1+gammaFS[ii][Z];
		}
		/*step 1*/
		tx1=h*der_Tf(t1,Tx1,M1x1,M2x1);
		ty1=h*der_Tf(t1,Ty1,M1y1,M2y1);
		tz1=h*der_Tf(t1,Tz1,M1z1,M2z1);
		m1x1=h*der_Nnn(t1,Tx1,M1x1,M2x1);
		m1y1=h*der_Nnn(t1,Ty1,M1y1,M2y1);
		m1z1=h*der_Nnn(t1,Tz1,M1z1,M2z1);
		m2x1=h*der_Bbb(t1,Tx1,M1x1,M2x1);
		m2y1=h*der_Bbb(t1,Ty1,M1y1,M2y1);
		m2z1=h*der_Bbb(t1,Tz1,M1z1,M2z1);
		gx1=h*der_Gamma(Tx1);
		gy1=h*der_Gamma(Ty1);
		gz1=h*der_Gamma(Tz1);
		/*step 2*/
		tmp1=t1+h/2;
			     tmpxT=Tx1+.5*tx1;tmpxM1=M1x1+.5*m1x1;tmpxM2=M2x1+.5*m2x1;
			     tmpyT=Ty1+.5*ty1;tmpyM1=M1y1+.5*m1y1;tmpyM2=M2y1+.5*m2y1;
			     tmpzT=Tz1+.5*tz1;tmpzM1=M1z1+.5*m1z1;tmpzM2=M2z1+.5*m2z1;
		tx2=h*der_Tf(tmp1,tmpxT,tmpxM1,tmpxM2);
		ty2=h*der_Tf(tmp1,tmpyT,tmpyM1,tmpyM2);
		tz2=h*der_Tf(tmp1,tmpzT,tmpzM1,tmpzM2);
		m1x2=h*der_Nnn(tmp1,tmpxT,tmpxM1,tmpxM2);
		m1y2=h*der_Nnn(tmp1,tmpyT,tmpyM1,tmpyM2);
		m1z2=h*der_Nnn(tmp1,tmpzT,tmpzM1,tmpzM2);
		m2x2=h*der_Bbb(tmp1,tmpxT,tmpxM1,tmpxM2);
		m2y2=h*der_Bbb(tmp1,tmpyT,tmpyM1,tmpyM2);
		m2z2=h*der_Bbb(tmp1,tmpzT,tmpzM1,tmpzM2);
		gx2=h*der_Gamma(tmpxT);
		gy2=h*der_Gamma(tmpyT);
		gz2=h*der_Gamma(tmpzT);
		/*step 3*/
			     tmpxT=Tx1+.5*tx2;tmpxM1=M1x1+.5*m1x2;tmpxM2=M2x1+.5*m2x2;
			     tmpyT=Ty1+.5*ty2;tmpyM1=M1y1+.5*m1y2;tmpyM2=M2y1+.5*m2y2;
			     tmpzT=Tz1+.5*tz2;tmpzM1=M1z1+.5*m1z2;tmpzM2=M2z1+.5*m2z2;
		tx3=h*der_Tf(tmp1,tmpxT,tmpxM1,tmpxM2);
		ty3=h*der_Tf(tmp1,tmpyT,tmpyM1,tmpyM2);
		tz3=h*der_Tf(tmp1,tmpzT,tmpzM1,tmpzM2);
		m1x3=h*der_Nnn(tmp1,tmpxT,tmpxM1,tmpxM2);
		m1y3=h*der_Nnn(tmp1,tmpyT,tmpyM1,tmpyM2);
		m1z3=h*der_Nnn(tmp1,tmpzT,tmpzM1,tmpzM2);
		m2x3=h*der_Bbb(tmp1,tmpxT,tmpxM1,tmpxM2);
		m2y3=h*der_Bbb(tmp1,tmpyT,tmpyM1,tmpyM2);
		m2z3=h*der_Bbb(tmp1,tmpzT,tmpzM1,tmpzM2);
		gx3=h*der_Gamma(tmpxT);
		gy3=h*der_Gamma(tmpyT);
		gz3=h*der_Gamma(tmpzT);
		/*step 4*/
		/**/tmp1=t1+h;/**/
			  tmpxT=Tx1+tx3;tmpxM1=M1x1+m1x3;tmpxM2=M2x1+m2x3;
			  tmpyT=Ty1+ty3;tmpyM1=M1y1+m1y3;tmpyM2=M2y1+m2y3;
			  tmpzT=Tz1+tz3;tmpzM1=M1z1+m1z3;tmpzM2=M2z1+m2z3;
		tx4=h*der_Tf(tmp1,tmpxT,tmpxM1,tmpxM2);
		ty4=h*der_Tf(tmp1,tmpyT,tmpyM1,tmpyM2);
		tz4=h*der_Tf(tmp1,tmpzT,tmpzM1,tmpzM2);
		m1x4=h*der_Nnn(tmp1,tmpxT,tmpxM1,tmpxM2);
		m1y4=h*der_Nnn(tmp1,tmpyT,tmpyM1,tmpyM2);
		m1z4=h*der_Nnn(tmp1,tmpzT,tmpzM1,tmpzM2);
		m2x4=h*der_Bbb(tmp1,tmpxT,tmpxM1,tmpxM2);
		m2y4=h*der_Bbb(tmp1,tmpyT,tmpyM1,tmpyM2);
		m2z4=h*der_Bbb(tmp1,tmpzT,tmpzM1,tmpzM2);
		gx4=h*der_Gamma(tmpxT);
		gy4=h*der_Gamma(tmpyT);
		gz4=h*der_Gamma(tmpzT);
		/*changes in all parameters*/
		dxG=(gx1+gx2+gx2+gx3+gx3+gx4)/6.;
		dyG=(gy1+gy2+gy2+gy3+gy3+gy4)/6.;
		dzG=(gz1+gz2+gz2+gz3+gz3+gz4)/6.;
		dxT=(tx1+tx2+tx2+tx3+tx3+tx4)/6.;
		dyT=(ty1+ty2+ty2+ty3+ty3+ty4)/6.;
		dzT=(tz1+tz2+tz2+tz3+tz3+tz4)/6.;
		dxM1=(m1x1+m1x2+m1x2+m1x3+m1x3+m1x4)/6.;
		dyM1=(m1y1+m1y2+m1y2+m1y3+m1y3+m1y4)/6.;
		dzM1=(m1z1+m1z2+m1z2+m1z3+m1z3+m1z4)/6.;
		dxM2=(m2x1+m2x2+m2x2+m2x3+m2x3+m2x4)/6.;
		dyM2=(m2y1+m2y2+m2y2+m2y3+m2y3+m2y4)/6.;
		dzM2=(m2z1+m2z2+m2z2+m2z3+m2z3+m2z4)/6.;
		/*update parameter values*/
		/**/t1+=h; /**/
		Gx1+=dxG;Gy1+=dyG;Gz1+=dzG;	
		Tx1+=dxT;Ty1+=dyT;Tz1+=dzT;	
		M1x1+=dxM1;M1y1+=dyM1;M1z1+=dzM1;	
		M2x1+=dxM2;M2y1+=dyM2;M2z1+=dzM2;
	}/*end of loop*/ 	
	/**/constructPath();/**/

	break;
    }
	lirpFrame();
}
frameCoaster(){
	int ii, jj, kk;
	float temp[3]={0,0,0},
		radi1, radi2, K,
		cosAndsin[2], Theta, Phi, Psi, 
		normT, normNN, osculRad, zz[2],d2tds2,
		Sx,Sy,Sz,tangentT[3],
		sa1, ca1, sa2, ca2, sa3, ca3;
	switch(whichGamma){
		case FRESER:
			FOR(ii,0,3){tangentT[ii]=fsFrame[posOnGam][TT][1][ii]-fsFrame[posOnGam][TT][0][ii];}
			normT=NRM(tangentT);
			/******Compute rotation angles for flyer************************/
			/******Theta=rot Y->X.  Phi=rot Z->Y.  Psi=rot Y->X ************/
			/**/
   			if(tangentT[Z]*tangentT[Z]+tangentT[Y]*tangentT[Y]>0){
				if(tangentT[Y]>=0){ Theta=Pi+acos(tangentT[Z]/pow(tangentT[Z]*tangentT[Z]+tangentT[Y]*tangentT[Y],.5));}
				else {Theta=(Pi+2*Pi-acos(tangentT[Z]/pow(tangentT[Z]*tangentT[Z]+tangentT[Y]*tangentT[Y],.5)));}
   			}
   			else {Theta=0;}
			Phi=Pi/2-acos(tangentT[X]/pow(tangentT[X]*tangentT[X]+
				tangentT[Y]*tangentT[Y]+tangentT[Z]*tangentT[Z],.5));

			FOR(ii,0,3){
				temp[ii]=fsFrame[posOnGam][NN][1][ii]-fsFrame[posOnGam][NN][0][ii];
			}
			Sx=fsFrame[posOnGam][TT][1][X]-fsFrame[posOnGam][TT][0][X];
			Sy=fsFrame[posOnGam][TT][1][Y]-fsFrame[posOnGam][TT][0][Y];
			Sz=fsFrame[posOnGam][TT][1][Z]-fsFrame[posOnGam][TT][0][Z];
			radi1=pow(Sx*Sx+Sy*Sy,.5);
			sa1=Sy/radi1;ca1=Sx/radi1;
			radi2=pow(Sx*Sx+Sy*Sy+Sz*Sz,.5);
			sa2=Sz/radi2;ca2=radi1/radi2;

			cosAndsin[0]=ca1;cosAndsin[1]=-sa1;
			quadurn(temp,cosAndsin,2);
			cosAndsin[0]=ca2;cosAndsin[1]=-sa2;
			quadurn(temp,cosAndsin,1);
			radi1=pow(temp[Y]*temp[Y]+temp[Z]*temp[Z],.5);
			sa3=temp[Z]/radi1;ca3=temp[Y]/radi1;
			/*****compute Psi=rot Y->X******/
			if(temp[Z]>=0){Psi=acos(-temp[Y]/radi1)+Pi;}
			else {Psi=2*Pi-acos(-temp[Y]/radi1)+Pi;}

		break;
		case BISHOP:
			FOR(ii,0,3){tangentT[ii]=bFrame[posOnGam][TT][1][ii]-bFrame[posOnGam][TT][0][ii];}
			normT=NRM(tangentT);
			/******Compute rotation angles for flyer************************/
			/******Theta=rot Y->X.  Phi=rot Z->Y.  Psi=rot Y->X ************/
			/**/
   			if(tangentT[Z]*tangentT[Z]+tangentT[Y]*tangentT[Y]>0){
				if(tangentT[Y]>=0){ Theta=Pi+acos(tangentT[Z]/pow(tangentT[Z]*tangentT[Z]+tangentT[Y]*tangentT[Y],.5));}
				else {Theta=(Pi+2*Pi-acos(tangentT[Z]/pow(tangentT[Z]*tangentT[Z]+tangentT[Y]*tangentT[Y],.5)));}
   			}
   			else {Theta=0;}
			Phi=Pi/2-acos(tangentT[X]/pow(tangentT[X]*tangentT[X]+
				tangentT[Y]*tangentT[Y]+tangentT[Z]*tangentT[Z],.5));

			FOR(ii,0,3){
				temp[ii]=bFrame[posOnGam][NN][1][ii]-bFrame[posOnGam][NN][0][ii];
			}
			Sx=bFrame[posOnGam][TT][1][X]-bFrame[posOnGam][TT][0][X];
			Sy=bFrame[posOnGam][TT][1][Y]-bFrame[posOnGam][TT][0][Y];
			Sz=bFrame[posOnGam][TT][1][Z]-bFrame[posOnGam][TT][0][Z];
			radi1=pow(Sx*Sx+Sy*Sy,.5);
			sa1=Sy/radi1;ca1=Sx/radi1;
			radi2=pow(Sx*Sx+Sy*Sy+Sz*Sz,.5);
			sa2=Sz/radi2;ca2=radi1/radi2;

			cosAndsin[0]=ca1;cosAndsin[1]=-sa1;
			quadurn(temp,cosAndsin,2);
			cosAndsin[0]=ca2;cosAndsin[1]=-sa2;
			quadurn(temp,cosAndsin,1);
			radi1=pow(temp[Y]*temp[Y]+temp[Z]*temp[Z],.5);
			sa3=temp[Z]/radi1;ca3=temp[Y]/radi1;
			/*****compute Psi=rot Y->X******/
			if(temp[Z]>=0){Psi=acos(-temp[Y]/radi1)+Pi;}
			else {Psi=2*Pi-acos(-temp[Y]/radi1)+Pi;}


		break;
	}

   	/**loadmatrix(id); 
 	translate(-XShift,-YShift,-ZShift); 
	switch(whichgamma){
		case FRESER:
			rotggc(-Psi*180/Pi,'z');
			rotggc(Phi*180/Pi,'y');
			rotggc((Theta)*180/Pi,'x');
			translate(-gammaF[posOnGam][X],-gammaF[posOnGam][Y],-gammaF[posOnGam][Z]);
		break;	
		case BISHOP:
			rotggc(Psi*180/Pi,'z');
			rotggc(Phi*180/Pi,'y');
			rotggc((Theta)*180/Pi,'x');
			translate(-gammaB[posOnGam][X],-gammaB[posOnGam][Y],-gammaB[posOnGam][Z]);
		break;	
	}
   	getmatrix(aff2);/**/
}
flyTheFrame(){
	if(vernierInx+jumP>=GAP){ if(posOnGam<(GAP-1)) posOnGam++; else posOnGam=0;}
	vernierInx=(vernierInx+jumP)%(GAP);
	/**/lirpFrame();/**For the Model curves**/
}
lirpFrame(){/************For model track****************************/
	int ii, jj, kk;
	float cvX;/*convex combination factor*/
	cvX=(float)vernierInx/GAP;
	switch(whichGamma){
		case BOTHFRAMES:
	FOR(jj,0,3){/*XYZ*/
		FOR(ii,0,3){/*TNB*/
			fsFlyer[ii][0][jj]=(1.-cvX)*fsFrame[posOnGam][ii][0][jj]+cvX*fsFrame[posOnGam+1][ii][0][jj];
			fsFlyer[ii][1][jj]=(1.-cvX)*fsFrame[posOnGam][ii][1][jj]+cvX*fsFrame[posOnGam+1][ii][1][jj];
		}
	}
	FOR(jj,0,3){/*XYZ*/
		fsFlyerMast[TT][0][jj]=.2*(((1.-cvX)*fsFrame[posOnGam][M1][1][jj]+cvX*fsFrame[posOnGam+1][M1][1][jj])
				-((1.-cvX)*fsFrame[posOnGam][M1][0][jj]+cvX*fsFrame[posOnGam+1][M1][0][jj]))

				-.001*(((1.-cvX)*fsFrame[posOnGam][M2][1][jj]+cvX*fsFrame[posOnGam+1][M2][1][jj])-
					((1.-cvX)*fsFrame[posOnGam][M2][0][jj]+cvX*fsFrame[posOnGam+1][M2][0][jj]))

				+((1.-cvX)*fsFrame[posOnGam][M1][0][jj]+cvX*fsFrame[posOnGam+1][M1][0][jj]);

		fsFlyerMast[TT][1][jj]=(1.-cvX)*fsFrame[posOnGam][TT][1][jj]+cvX*fsFrame[posOnGam+1][TT][1][jj]

				-.001*(((1.-cvX)*fsFrame[posOnGam][M2][1][jj]+cvX*fsFrame[posOnGam+1][M2][1][jj])-
					((1.-cvX)*fsFrame[posOnGam][M2][0][jj]+cvX*fsFrame[posOnGam+1][M2][0][jj]))

				;

		fsFlyerMast[TT][2][jj]=-.2*(((1.-cvX)*fsFrame[posOnGam][M1][1][jj]+cvX*fsFrame[posOnGam+1][M1][1][jj])
				-((1.-cvX)*fsFrame[posOnGam][M1][0][jj]+cvX*fsFrame[posOnGam+1][M1][0][jj]))

				-.001*(((1.-cvX)*fsFrame[posOnGam][M2][1][jj]+cvX*fsFrame[posOnGam+1][M2][1][jj])-
					((1.-cvX)*fsFrame[posOnGam][M2][0][jj]+cvX*fsFrame[posOnGam+1][M2][0][jj]))


				+((1.-cvX)*fsFrame[posOnGam][M1][0][jj]+cvX*fsFrame[posOnGam+1][M1][0][jj]);


		fsFlyerMast[M2][0][jj]=.3*(((1.-cvX)*fsFrame[posOnGam][TT][1][jj]+cvX*fsFrame[posOnGam+1][TT][1][jj])
				-((1.-cvX)*fsFrame[posOnGam][TT][0][jj]+cvX*fsFrame[posOnGam+1][TT][0][jj]))
				+((1.-cvX)*fsFrame[posOnGam][TT][0][jj]+cvX*fsFrame[posOnGam+1][TT][0][jj]);

		fsFlyerMast[M2][1][jj]=(1.-cvX)*fsFrame[posOnGam][M2][1][jj]+cvX*fsFrame[posOnGam+1][M2][1][jj];

		fsFlyerMast[M2][2][jj]=((1.-cvX)*fsFrame[posOnGam][M2][0][jj]+cvX*fsFrame[posOnGam+1][M2][0][jj]);
	}


		/**No break;**/
		case BISHOP:
	FOR(jj,0,3){/*XYZ*/
		FOR(ii,0,3){/*TNB*/
			bFlyer[ii][0][jj]=(1.-cvX)*bFrame[posOnGam][ii][0][jj]+cvX*bFrame[posOnGam+1][ii][0][jj];
			bFlyer[ii][1][jj]=(1.-cvX)*bFrame[posOnGam][ii][1][jj]+cvX*bFrame[posOnGam+1][ii][1][jj];
		}
	}
	FOR(jj,0,3){/*XYZ*/
		bFlyerMast[TT][0][jj]=.2*(((1.-cvX)*bFrame[posOnGam][M1][1][jj]+cvX*bFrame[posOnGam+1][M1][1][jj])
				-((1.-cvX)*bFrame[posOnGam][M1][0][jj]+cvX*bFrame[posOnGam+1][M1][0][jj]))

				-.001*(((1.-cvX)*bFrame[posOnGam][M2][1][jj]+cvX*bFrame[posOnGam+1][M2][1][jj])-
					((1.-cvX)*bFrame[posOnGam][M2][0][jj]+cvX*bFrame[posOnGam+1][M2][0][jj]))

				+((1.-cvX)*bFrame[posOnGam][M1][0][jj]+cvX*bFrame[posOnGam+1][M1][0][jj]);

		bFlyerMast[TT][1][jj]=(1.-cvX)*bFrame[posOnGam][TT][1][jj]+cvX*bFrame[posOnGam+1][TT][1][jj]

				-.001*(((1.-cvX)*bFrame[posOnGam][M2][1][jj]+cvX*bFrame[posOnGam+1][M2][1][jj])-
					((1.-cvX)*bFrame[posOnGam][M2][0][jj]+cvX*bFrame[posOnGam+1][M2][0][jj]))

				;

		bFlyerMast[TT][2][jj]=-.2*(((1.-cvX)*bFrame[posOnGam][M1][1][jj]+cvX*bFrame[posOnGam+1][M1][1][jj])
				-((1.-cvX)*bFrame[posOnGam][M1][0][jj]+cvX*bFrame[posOnGam+1][M1][0][jj]))

				-.001*(((1.-cvX)*bFrame[posOnGam][M2][1][jj]+cvX*bFrame[posOnGam+1][M2][1][jj])-
					((1.-cvX)*bFrame[posOnGam][M2][0][jj]+cvX*bFrame[posOnGam+1][M2][0][jj]))


				+((1.-cvX)*bFrame[posOnGam][M1][0][jj]+cvX*bFrame[posOnGam+1][M1][0][jj]);


		bFlyerMast[M2][0][jj]=.3*(((1.-cvX)*bFrame[posOnGam][TT][1][jj]+cvX*bFrame[posOnGam+1][TT][1][jj])
				-((1.-cvX)*bFrame[posOnGam][TT][0][jj]+cvX*bFrame[posOnGam+1][TT][0][jj]))
				+((1.-cvX)*bFrame[posOnGam][TT][0][jj]+cvX*bFrame[posOnGam+1][TT][0][jj]);

		bFlyerMast[M2][1][jj]=(1.-cvX)*bFrame[posOnGam][M2][1][jj]+cvX*bFrame[posOnGam+1][M2][1][jj];

		bFlyerMast[M2][2][jj]=((1.-cvX)*bFrame[posOnGam][M2][0][jj]+cvX*bFrame[posOnGam+1][M2][0][jj]);
	}

		break;
		case FRESER:
	FOR(jj,0,3){/*XYZ*/
		FOR(ii,0,3){/*TNB*/
			fsFlyer[ii][0][jj]=(1.-cvX)*fsFrame[posOnGam][ii][0][jj]+cvX*fsFrame[posOnGam+1][ii][0][jj];
			fsFlyer[ii][1][jj]=(1.-cvX)*fsFrame[posOnGam][ii][1][jj]+cvX*fsFrame[posOnGam+1][ii][1][jj];
		}
	}
	FOR(jj,0,3){/*XYZ*/
		fsFlyerMast[TT][0][jj]=.2*(((1.-cvX)*fsFrame[posOnGam][M1][1][jj]+cvX*fsFrame[posOnGam+1][M1][1][jj])
				-((1.-cvX)*fsFrame[posOnGam][M1][0][jj]+cvX*fsFrame[posOnGam+1][M1][0][jj]))

				-.001*(((1.-cvX)*fsFrame[posOnGam][M2][1][jj]+cvX*fsFrame[posOnGam+1][M2][1][jj])-
					((1.-cvX)*fsFrame[posOnGam][M2][0][jj]+cvX*fsFrame[posOnGam+1][M2][0][jj]))

				+((1.-cvX)*fsFrame[posOnGam][M1][0][jj]+cvX*fsFrame[posOnGam+1][M1][0][jj]);

		fsFlyerMast[TT][1][jj]=(1.-cvX)*fsFrame[posOnGam][TT][1][jj]+cvX*fsFrame[posOnGam+1][TT][1][jj]

				-.001*(((1.-cvX)*fsFrame[posOnGam][M2][1][jj]+cvX*fsFrame[posOnGam+1][M2][1][jj])-
					((1.-cvX)*fsFrame[posOnGam][M2][0][jj]+cvX*fsFrame[posOnGam+1][M2][0][jj]))

				;

		fsFlyerMast[TT][2][jj]=-.2*(((1.-cvX)*fsFrame[posOnGam][M1][1][jj]+cvX*fsFrame[posOnGam+1][M1][1][jj])
				-((1.-cvX)*fsFrame[posOnGam][M1][0][jj]+cvX*fsFrame[posOnGam+1][M1][0][jj]))

				-.001*(((1.-cvX)*fsFrame[posOnGam][M2][1][jj]+cvX*fsFrame[posOnGam+1][M2][1][jj])-
					((1.-cvX)*fsFrame[posOnGam][M2][0][jj]+cvX*fsFrame[posOnGam+1][M2][0][jj]))


				+((1.-cvX)*fsFrame[posOnGam][M1][0][jj]+cvX*fsFrame[posOnGam+1][M1][0][jj]);


		fsFlyerMast[M2][0][jj]=.3*(((1.-cvX)*fsFrame[posOnGam][TT][1][jj]+cvX*fsFrame[posOnGam+1][TT][1][jj])
				-((1.-cvX)*fsFrame[posOnGam][TT][0][jj]+cvX*fsFrame[posOnGam+1][TT][0][jj]))
				+((1.-cvX)*fsFrame[posOnGam][TT][0][jj]+cvX*fsFrame[posOnGam+1][TT][0][jj]);

		fsFlyerMast[M2][1][jj]=(1.-cvX)*fsFrame[posOnGam][M2][1][jj]+cvX*fsFrame[posOnGam+1][M2][1][jj];

		fsFlyerMast[M2][2][jj]=((1.-cvX)*fsFrame[posOnGam][M2][0][jj]+cvX*fsFrame[posOnGam+1][M2][0][jj]);
	}

		break;
	}
/**(((1.-cvX)*bFrame[posOnGam][M2][1][jj]+cvX*bFrame[posOnGam+1][M2][1][jj])-
((1.-cvX)*bFrame[posOnGam][M2][0][jj]+cvX*bFrame[posOnGam+1][M2][0][jj]))**/

}
createOsculatingSphere(){
	float radi0, cen[3], y1, y2, x1, x2, ff, gg, cc, ss;
	int ii, jj, bs, LO, LA;
	bs=5/**frameInx2/**/;
	LO=100;LA=100;

	y1=develoPts[0][Y];
	y2=develoPts[1][Y];
	x1=develoPts[0][X];
	x2=develoPts[1][X];
	if((y2*x1-x2*y1)!=0){
		ff=-(y2-y1)/(y2*x1-x2*y1);
		gg=-(x1-x2)/(y2*x1-x2*y1);
		radi0=pow(pow(ff,2)+pow(gg,2),.5);
		cc=cos(-2*DAngle);ss=sin(-2*DAngle);
		FOR(ii,0,3){/**X,Y,& Z**/
			cen[ii]=gammaB[bs][ii]-
					ff*(cc*(bFrame[bs][NN][1][ii]-bFrame[bs][NN][0][ii])+
					    ss*(bFrame[bs][BB][1][ii]-bFrame[bs][BB][0][ii])	
					    )-
					gg*(-ss*(bFrame[bs][NN][1][ii]-bFrame[bs][NN][0][ii])+
					     cc*(bFrame[bs][BB][1][ii]-bFrame[bs][BB][0][ii])
					    );
		}
		FOR(ii,0,LO){
			FOR(jj,0,LA){if(jj%20<=10){
       				oscSphere[ii][jj][X]=radi0*cos(-Pi/2+(float)(jj+1)/(LA+1)*Pi)*cos((float)ii/(LO-1)*2*Pi)+cen[X];
				oscSphere[ii][jj][Y]=radi0*cos(-Pi/2+(float)(jj+1)/(LA+1)*Pi)*sin((float)ii/(LO-1)*2*Pi)+cen[Y];
				oscSphere[ii][jj][Z]=radi0*sin(-Pi/2+(float)(jj+1)/(LA+1)*Pi)+cen[Z];
					}
			}
		}
	}
}
constructPath(){
	int ii, jj, kk;
	float tempNorm[3], normF;
    switch(whichGamma){
	case BOTHFRAMES:
	FOR(ii,0,GAP){
		FOR(jj,0,3){/*X,Y,Z*/
			fsPath[ii][0][jj]=gammaFS[ii][jj]+.3*(fsFrame[ii][NN][1][jj]-fsFrame[ii][NN][0][jj]);
			fsPath[ii][1][jj]=gammaFS[ii][jj]-.3*(fsFrame[ii][NN][1][jj]-fsFrame[ii][NN][0][jj]);
		}
	}
	/**No break;/**/
	case BISHOP:
	FOR(ii,0,GAP){
		FOR(jj,0,3){/*X,Y,Z*/
			bPath[ii][0][jj]=gammaB[ii][jj]+.3*(bFrame[ii][NN][1][jj]-bFrame[ii][NN][0][jj]);
			bPath[ii][1][jj]=gammaB[ii][jj]-.3*(bFrame[ii][NN][1][jj]-bFrame[ii][NN][0][jj]);
		}
	}
	break;
	case FRESER:
	FOR(ii,0,GAP){
		FOR(jj,0,3){/*X,Y,Z*/
			fsPath[ii][0][jj]=gammaFS[ii][jj]+.3*(fsFrame[ii][NN][1][jj]-fsFrame[ii][NN][0][jj]);
			fsPath[ii][1][jj]=gammaFS[ii][jj]-.3*(fsFrame[ii][NN][1][jj]-fsFrame[ii][NN][0][jj]);
		}
	}
	break;
   }
}

adjustNormalDev(){
	int ii, jj, kk;
	develoPts[0][X]=(DCent-DHalfLeng)*cos(DAngle)-DDist*sin(DAngle);
	develoPts[0][Y]=(DCent-DHalfLeng)*sin(DAngle) + DDist*cos(DAngle);
	develoPts[1][X]=(DCent+DHalfLeng)*cos(DAngle)-DDist*sin(DAngle);
	develoPts[1][Y]=(DCent+DHalfLeng)*sin(DAngle) + DDist*cos(DAngle);

	FOR(ii,0,NAP){
		DCirc[ii][X]=DDist*cos((float)ii/(NAP-1)*2*Pi);
		DCirc[ii][Y]=DDist*sin((float)ii/(NAP-1)*2*Pi);
	}
	if(computeOnTheFly){rungeKuttaTheFrame();}
}

void drawvertO(int th, int ta){  
/* exercise ... float all the angles for a smoother homotopy */ 
float lmb,spec,nn[3], dog, cat;
nn[0] = C(th)*C(ta); /* unit sphere vector */  
nn[1] = S(th)*C(ta);
nn[2] =       S(ta);
lmb = MAX(CLAMP(nn[0]*lu[0] + nn[1]*lu[1] + nn[2]*lu[2],0.,1.),.3);
spec =(1-10+10*lmb);
dog = (ta-ta0)/(float)(ta1-ta0); cat = (th-th0)/(float)(th1-th0);
glColor3f(MAX(lmb*dog,spec),                     /* map R^2(dog,cat)->R^3(RGBspace */
          MAX(lmb*(.25 + abs(cat -.5)),spec),  /* dog cat model of Hartman       */
          MAX(lmb*(1 - cat ),spec));             /* illiLight by Ray Idaszak 1989  */
glVertex3f(C(th) + .5*nn[0],S(th) + .5*nn[1],.5*nn[2]);
}

void drawvertB(int pp,float rr,float gg,float bb){  
	float lmb,spec,nn[3];
	/**binormal vector for gamma is normal for path**/
	nn[0]=(bFrame[pp][BB][1][0]-bFrame[pp][BB][0][0]);
	nn[1]=(bFrame[pp][BB][1][1]-bFrame[pp][BB][0][1]);
	nn[2]=(bFrame[pp][BB][1][2]-bFrame[pp][BB][0][2]);
	lmb = MAX(CLAMP(nn[0]*lu[0] + nn[1]*lu[1] + nn[2]*lu[2],0.,1.),.3);
	spec = 1-10+10*lmb;  
	glColor3f(MAX(lmb*rr,spec), MAX(lmb*gg,spec), MAX(lmb*bb,spec));   

	glVertex3f(bPath[pp][0][0],bPath[pp][0][1],bPath[pp][0][2]);
	glVertex3f(bPath[pp][1][0],bPath[pp][1][1],bPath[pp][1][2]);

}
void drawvertBinv(int pp,float rr,float gg,float bb){  
	float lmb,spec,nn[3];
	/**binormal vector for gamma is normal for path**/
	nn[0]=-(bFrame[pp][BB][1][0]-bFrame[pp][BB][0][0]);
	nn[1]=-(bFrame[pp][BB][1][1]-bFrame[pp][BB][0][1]);
	nn[2]=-(bFrame[pp][BB][1][2]-bFrame[pp][BB][0][2]);
	lmb = MAX(CLAMP(nn[0]*lu[0] + nn[1]*lu[1] + nn[2]*lu[2],0.,1.),.3);
	spec = 1-10+10*lmb;                  
	glColor3f(MAX(lmb*rr,spec), MAX(lmb*gg,spec), MAX(lmb*bb,spec));    

	glVertex3f(bPath[pp][0][0],bPath[pp][0][1],bPath[pp][0][2]);
	glVertex3f(bPath[pp][1][0],bPath[pp][1][1],bPath[pp][1][2]);
}
void drawvertFS(int pp,float rr,float gg,float bb){  
	float lmb,spec,nn[3];
	/**binormal vector for gamma is normal for path**/
	nn[0]=(fsFrame[pp][BB][1][0]-fsFrame[pp][BB][0][0]);
	nn[1]=(fsFrame[pp][BB][1][1]-fsFrame[pp][BB][0][1]);
	nn[2]=(fsFrame[pp][BB][1][2]-fsFrame[pp][BB][0][2]);
	lmb = MAX(CLAMP(nn[0]*lu[0] + nn[1]*lu[1] + nn[2]*lu[2],0.,1.),.3);
	spec = MIN(1, 1*(1-10+10*lmb));                    /* clamp spec below maximum       */
	glColor3f(MAX(lmb*rr,spec),                     
          MAX(lmb*gg,spec),  
          MAX(lmb*bb,spec));             /* illiLight by Ray Idaszak 1989  */
	glVertex3f(fsPath[pp][0][0],fsPath[pp][0][1],fsPath[pp][0][2]);
	glVertex3f(fsPath[pp][1][0],fsPath[pp][1][1],fsPath[pp][1][2]);
}
void drawvertInv(int pp,float rr,float gg,float bb){  
	float lmb,spec,nn[3];
	/**binormal vector for gamma is normal for path**/
	nn[0]=-(bFrame[pp][BB][1][0]-bFrame[pp][BB][0][0]);
	nn[1]=-(bFrame[pp][BB][1][1]-bFrame[pp][BB][0][1]);
	nn[2]=-(bFrame[pp][BB][1][2]-bFrame[pp][BB][0][2]);
	lmb = MAX(CLAMP(nn[0]*lu[0] + nn[1]*lu[1] + nn[2]*lu[2],0.,1.),.3);
	spec = MIN(1, 1*(1-10+10*lmb));                    /* clamp spec below maximum       */
	glColor3f(MAX(lmb*rr,spec),                     
          MAX(lmb*gg,spec),  
          MAX(lmb*bb,spec));             /* illiLight by Ray Idaszak 1989  */
	glVertex3f(bPath[pp][0][0],bPath[pp][0][1],bPath[pp][0][2]);
	glVertex3f(bPath[pp][1][0],bPath[pp][1][1],bPath[pp][1][2]);
}
void drawvertInvFS(int pp,float rr,float gg,float bb){  
	float lmb,spec,nn[3];
	/**binormal vector for gamma is normal for path**/
	nn[0]=-(fsFrame[pp][BB][1][0]-fsFrame[pp][BB][0][0]);
	nn[1]=-(fsFrame[pp][BB][1][1]-fsFrame[pp][BB][0][1]);
	nn[2]=-(fsFrame[pp][BB][1][2]-fsFrame[pp][BB][0][2]);
	lmb = MAX(CLAMP(nn[0]*lu[0] + nn[1]*lu[1] + nn[2]*lu[2],0.,1.),.3);
	spec = MIN(1, 1*(1-10+10*lmb));                    /* clamp spec below maximum       */
	glColor3f(MAX(lmb*rr,spec),                     
          MAX(lmb*gg,spec),  
          MAX(lmb*bb,spec));             /* illiLight by Ray Idaszak 1989  */
	glVertex3f(fsPath[pp][0][0],fsPath[pp][0][1],fsPath[pp][0][2]);
	glVertex3f(fsPath[pp][1][0],fsPath[pp][1][1],fsPath[pp][1][2]);
}

void drawtor(void){
	int th, ta;
	dth = (int)((th1-th0)/30);  /* 30  meridian strips */ 
	dta = (int)((ta1-ta0)/30);  /* 30  triangle pairs per strip */
	for(th=th0; th < th1; th += dth){
  glBegin(GL_TRIANGLE_STRIP);
  for(ta=ta0; ta < ta1; ta += dta){ drawvertO(th,ta); drawvertO(th+gap*dth,ta); }
  glEnd();
  }
}
void drawGammaB(void){
	int ii, jj;
  glBegin(GL_LINE_STRIP);
	glColor3f(.9,.5,.1);
	FOR(ii,0,GAP){glVertex3f(gammaB[ii][0],gammaB[ii][1],gammaB[ii][2]);}
  glEnd();

}
void drawGammaFS(void){
	int ii, jj;
  glBegin(GL_LINE_STRIP);
	glColor3f(.9,.5,.1);
	FOR(ii,0,GAP){glVertex3f(gammaFS[ii][0],gammaFS[ii][1],gammaFS[ii][2]);}
  glEnd();

}
void drawPathO(void){
	int ii, jj;
  glBegin(GL_LINE_STRIP);
	glColor3f(.9,.9,.9);
	FOR(ii,0,GAP){glVertex3f(bPath[ii][0][0],bPath[ii][0][1],bPath[ii][0][2]);}
  glEnd();
  glBegin(GL_LINE_STRIP);
	glColor3f(.9,.1,.1);
	FOR(ii,0,GAP){glVertex3f(bPath[ii][1][0],bPath[ii][1][1],bPath[ii][1][2]);}
  glEnd();
  /**glBegin(GL_TRIANGLE_STRIP);
  FOR(ii,0,GAP){drawvert(ii,.2,.2,.2); }
  glEnd();/**/
  glBegin(GL_TRIANGLE_STRIP);
  FOR(ii,0,GAP){drawvertInv(ii,.2,.2,.2); }
  glEnd();
}
void drawPath(void){
	int ii, jj;
	switch(whichGamma){
		case BOTHFRAMES:
  			glBegin(GL_LINE_STRIP);
			glColor3f(.9,.9,.9);
			FOR(ii,0,GAP){glVertex3f(fsPath[ii][0][0],fsPath[ii][0][1],fsPath[ii][0][2]);}
  			glEnd();
  			glBegin(GL_LINE_STRIP);
			glColor3f(.9,.1,.1);
			FOR(ii,0,GAP){glVertex3f(fsPath[ii][1][0],fsPath[ii][1][1],fsPath[ii][1][2]);}
  			glEnd();
  			/**glBegin(GL_TRIANGLE_STRIP);
  			FOR(ii,0,GAP){if((ii==(ii)%(4)) || (ii==(2)%(4))){ drawvert(ii,.8,.1,.1);} }
  			glEnd();/**/


  glFrontFace(GL_CW);
/**qwe Where the two sided gl is wanted**/
						/**if(ii%8==0){glFrontFace(GL_CW);}
						if(ii%8==4){glFrontFace(GL_CCW);}/**/


  			FOR(ii,0,GAP){
				if(ii%4==0){ glBegin(GL_TRIANGLE_STRIP);
						drawvertFS(ii,.8,.8,.1); 
						drawvertFS(ii+1,.8,.8,.1);
  		      			     glEnd();
				}
   			}
		/**No break;**/
		case BISHOP:
  			glBegin(GL_LINE_STRIP);
			glColor3f(.9,.9,.9);
			FOR(ii,0,GAP){glVertex3f(bPath[ii][0][0],bPath[ii][0][1],bPath[ii][0][2]);}
  			glEnd();
  			glBegin(GL_LINE_STRIP);
			glColor3f(.9,.1,.1);
			FOR(ii,0,GAP){glVertex3f(bPath[ii][1][0],bPath[ii][1][1],bPath[ii][1][2]);}
  			glEnd();
  			/**glBegin(GL_TRIANGLE_STRIP);
  			FOR(ii,0,GAP){if((ii==(ii)%(4)) || (ii==(2)%(4))){ drawvert(ii,.8,.1,.1);} }
  			glEnd();/**/
  
  
  			FOR(ii,0,GAP){
				if(ii%4==0){ glBegin(GL_TRIANGLE_STRIP);
						drawvertB(ii,.8,.1,.1); 
						drawvertBinv(ii,.8,.1,.1); 
						drawvertB(ii+1,.8,.1,.1);
						drawvertBinv(ii+1,.8,.1,.1);
  		      			     glEnd();
				}
				if(ii%4==5){ glBegin(GL_TRIANGLE_STRIP);
						drawvertBinv(ii,.8,.1,.1); 
						drawvertBinv(ii+1,.8,.1,.1);
  		      			     glEnd();
				}
   			}
		break;
		case FRESER:
  			glBegin(GL_LINE_STRIP);
			glColor3f(.9,.9,.9);
			FOR(ii,0,GAP){glVertex3f(fsPath[ii][0][0],fsPath[ii][0][1],fsPath[ii][0][2]);}
  			glEnd();
  			glBegin(GL_LINE_STRIP);
			glColor3f(.9,.1,.1);
			FOR(ii,0,GAP){glVertex3f(fsPath[ii][1][0],fsPath[ii][1][1],fsPath[ii][1][2]);}
  			glEnd();
  			/**glBegin(GL_TRIANGLE_STRIP);
  			FOR(ii,0,GAP){if((ii==(ii)%(4)) || (ii==(2)%(4))){ drawvert(ii,.8,.1,.1);} }
  			glEnd();/**/
  
  			FOR(ii,0,GAP){
				if(ii%4==0){ glBegin(GL_TRIANGLE_STRIP);
						drawvertFS(ii,.8,.8,.1); 
						drawvertFS(ii+1,.8,.8,.1);
  		      			     glEnd();
				}
   			}
		break;
	}
}
void drawFrameB(void){
int ii, jj;
  /**glBegin(GL_LINE_STRIP);
	glColor3f(.9,.1,.1);
	FOR(ii,0,2){glVertex3f(bFlyer[TT][ii][0],bFlyer[TT][ii][1],bFlyer[TT][ii][2]);}
  glEnd();
  glBegin(GL_LINE_STRIP);
	glColor3f(.1,.9,.1);
	FOR(ii,0,2){glVertex3f(bFlyer[M1][ii][0],bFlyer[M1][ii][1],bFlyer[M1][ii][2]);}
  glEnd();
  glBegin(GL_LINE_STRIP);
	glColor3f(.9,.9,.1);
	FOR(ii,0,2){glVertex3f(bFlyer[M2][ii][0],bFlyer[M2][ii][1],bFlyer[M2][ii][2]);}
  glEnd();/**/
  glBegin(GL_TRIANGLE_STRIP);
	glColor3f(.9,.1,.1);
  	FOR(ii,0,3){glVertex3f(bFlyerMast[TT][ii][X],bFlyerMast[TT][ii][Y],bFlyerMast[TT][ii][Z]); }
  glEnd();
  glBegin(GL_TRIANGLE_STRIP);
	glColor3f(.9,.9,.1);
  	FOR(ii,0,3){glVertex3f(bFlyerMast[M2][ii][X],bFlyerMast[M2][ii][Y],bFlyerMast[M2][ii][Z]); }
  glEnd();
  glBegin(GL_LINE_STRIP);/*********racing strip (direction of turn)***/
	glColor3f(.1,.9,.1);
	FOR(ii,0,2){glVertex3f(bFlyerMast[TT][ii][0],bFlyerMast[TT][ii][1],bFlyerMast[TT][ii][2]);}
  glEnd();
}
void drawFrameFS(void){
int ii, jj;
  /**glBegin(GL_LINE_STRIP);
	glColor3f(.9,.1,.1);
	FOR(ii,0,2){glVertex3f(fsFlyer[TT][ii][0],fsFlyer[TT][ii][1],fsFlyer[TT][ii][2]);}
  glEnd();
  glBegin(GL_LINE_STRIP);
	glColor3f(.1,.9,.1);
	FOR(ii,0,2){glVertex3f(fsFlyer[M1][ii][0],fsFlyer[M1][ii][1],fsFlyer[M1][ii][2]);}
  glEnd();
  glBegin(GL_LINE_STRIP);
	glColor3f(.9,.9,.1);
	FOR(ii,0,2){glVertex3f(fsFlyer[M2][ii][0],fsFlyer[M2][ii][1],fsFlyer[M2][ii][2]);}
  glEnd();/**/
  glBegin(GL_TRIANGLE_STRIP);
	glColor3f(.9,.1,.1);
  	FOR(ii,0,3){glVertex3f(fsFlyerMast[TT][ii][X],fsFlyerMast[TT][ii][Y],fsFlyerMast[TT][ii][Z]); }
  glEnd();
  glBegin(GL_TRIANGLE_STRIP);
	glColor3f(.9,.9,.1);
  	FOR(ii,0,3){glVertex3f(fsFlyerMast[M2][ii][X],fsFlyerMast[M2][ii][Y],fsFlyerMast[M2][ii][Z]); }
  glEnd();
  glBegin(GL_LINE_STRIP);/*********racing strip (direction of turn)***/
	glColor3f(.1,.9,.1);
	FOR(ii,0,2){glVertex3f(fsFlyerMast[TT][ii][0],fsFlyerMast[TT][ii][1],fsFlyerMast[TT][ii][2]);}
  glEnd();
}
void drawslate2D(void){
int ii, jj;
  glBegin(GL_LINE_STRIP);
	glColor3f(.9,.0,.9);
	FOR(ii,0,5){glVertex3f(slate[ii][0],slate[ii][1],slate[ii][2]);}
  glEnd();

}
drawOsculatingSphere(){
	int ii, jj, LO, LA;
	LO=100;LA=100;
	glColor3f(.1,.9,.9);
	FOR(jj,0,LA-1){
		if(jj%20<10){
  			glBegin(GL_TRIANGLE_STRIP);
			/**bgntmesh();/**/
			FOR(ii,0,LO-1){
				glVertex3f(oscSphere[ii][jj][X],oscSphere[ii][jj][Y],oscSphere[ii][jj][Z]);
				glVertex3f(oscSphere[ii][jj+1][X],oscSphere[ii][jj+1][Y],oscSphere[ii][jj+1][Z]);
				/**v3f(oscSphere[ii][jj]);
				v3f(oscSphere[ii][jj+1]);/**/
			}
  			glEnd();
			/**endtmesh();/**/
		}
	}
}
void drawDevelopment(void){
int ii, jj;
  glBegin(GL_LINE_STRIP);
	glColor3f(.9,.5,.1);
	FOR(ii,0,2){glVertex3f(develoPts[ii][0],develoPts[ii][1],develoPts[ii][2]);}
  glEnd();

}
void drawDevCirc(void){
int ii, jj;
  glBegin(GL_LINE_STRIP);
	glColor3f(.9,.9,.9);
	FOR(ii,0,NAP){glVertex3f(DCirc[ii][0],DCirc[ii][1],DCirc[ii][2]);}
  glEnd();

}

void drawall(void){  
	switch(whichGamma){
		case BOTHFRAMES:
		     	drawGammaFS(); 
			if(showFrame) drawFrameFS();
		/**No break;**/
		case BISHOP:
		     	drawGammaB(); 
			drawPath();
			if(showFrame) drawFrameB();
			if(showSphere) drawOsculatingSphere();
		break;
		case FRESER:
		     	drawGammaFS(); 
			drawPath();
			if(showFrame) drawFrameFS();
		break;
	}
}

void drawstars(void){
int i;
static float star[1000][3];
static int virgin=1;
if(virgin){
  int ii,jj;
  float fact;
  virgin=0;
  for(ii=0;ii<1000;ii++)
     {
     for(jj=0;jj<3;jj++) star[ii][jj] =   rand()/(float)0x40000000-1.;
     if(caveyes){
           fact = 90./NRM(star[ii]);
           for(jj=0;jj<3;jj++) star[ii][jj] *= fact;
           }   
     }
  }
  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();
  glMultMatrixf(starmat);
  glColor3f(1.0,1.0,0.0);    
  glBegin(GL_POINTS);
    for(i=0;i<1000;i++) glVertex3fv(star[i]);
  glEnd();
  glPopMatrix();
  glClear(GL_DEPTH_BUFFER_BIT);
}

void audioprep(void){
#ifdef SOUND
   if (!FBgnSoundServer())
      fprintf(stderr,"UDP connection to sound server failed\n");
   else if ((audiohandle = AUDinit("noosh.aud")) == -1)
      fprintf(stderr,"Couldn't open noosh.aud\n");
#endif
}

void dohoot(void) {strcpy(which,"hoot");}
void dotrump(void){strcpy(which,"trump");}
void doflute(void){strcpy(which,"flute");}
void dodrum(void) {strcpy(which,"drum");}

void audiofunc(void){
#ifdef SOUND 
#define LIRP(X,A,B,x,a,b)  (X = A + (x-a)*(B-A)/(b-a))
  static float freq=440., ampl=1., indx=20., cmra=2.; 
  static float data[4];
  static omode =0; static ofocal = 0;
  static beep =0;  /* the sound server */

  if(omode > mode){dohoot(); beep = 1;}
  if(omode < mode){dodrum(); beep = 1;}

  LIRP(freq, 440, 1760, th0,  10, 170); /* frequeny mimics th1 */ 
  LIRP(indx, 10, 1,  focal, .03, 2.0); /* index  mimics focal */ 
  if(ofocal != focal){dodrum(); beep = 1;}    /* there is an fp bug here */

if(beep){data[0] = freq;  /* pitch in Herz      */ 
          data[1] = ampl;  /* the sum of all amplitudes must be < 1.0 */ 
          data[2] = indx;    
          data[3] = cmra;
          AUDupdate(audiohandle, which, 4, data);  /* send message  to vss */ 
          beep = 0; 
}
  omode = mode;  ofocal = focal; 
#endif
}

void audioclean(void){
#ifdef SOUND
   AUDterminate(audiohandle);
   EndSoundServer();
#endif
}


void arguments(int argc,char **argv){
/*
  extern char *optarg;
  extern int optind; 
  int chi;   
  // w: needs ONE number after -w, c<nothing> means NO number follows
  while ((chi = getopt(argc,argv,"w:cd:g:")) != -1) 
  switch(chi)  {case 'c': caveyes=1; break;  
                case 'w': win=atoi(optarg); break; 
                case 'g': gap0=atof(optarg); break;
                }
  if (optind!=argc) fprintf(stderr,"%s: Incorrect usage\n",argv[0]);

*/
}


void dataprep(void){
   audioprep();
   deFault();
}

void autotymer(int reset){
#define  TYME(cnt,max,act) {static cnt; if(first)cnt=max; else\
                            if(cnt?cnt--:0){ act ; goto Break;}}
  static first = 1;  /* the first time autymer is called */
  if(reset)first=1;  /* or if it is reset to start over  */
  TYME( shrink , 150,th0++;th1--;ta0++;ta1--)
  TYME( pause  , 20,          )
  TYME( grow   , 150,th0--;th1++;ta0--;ta1++)
  TYME( dwell  , 30,            )
  TYME(finish  , 1 , first = 1  )
  first = 0;
  Break:   ;   /* yes Virginia, C has gotos */
}

/*Beware of competing keys in CAVEsimulation and wnd==1   */
/* you may want to remap these keys to avoid the conflict */

void keyboard(unsigned char key, int x, int y){
#define  IF(K)            if(key==K)
#define  PRESS(K,A,b)     IF(K){b;}IF((K-32)){A;}  
/*was backwards in previous versions */
#define  TOGGLE(K,flg)    IF(K){(flg) = 1-(flg); }
#define  CYCLE(K,f,m)     PRESS((K), (f)=(((f)+(m)-1)%(m)),(f)=(++(f)%(m)))
#define  SLIDI(K,f,m,M)   PRESS(K,(--f<m?m:f), (++f>M?M:f))
#define  SLIDF(K,f,m,M,d) PRESS(K,((f -= d)<m?m:f), ((f += d)>M?M:f))
/* Only ASCII characters can be processes by this GLUT callback function */ 
   TOGGLE('v',binoc);                            /* cross-eyed STEREO   */
   TOGGLE('w',msg);                              /* writing on/off      */
   TOGGLE('h',morph);                            /* autotymer on/off    */
   PRESS('n', nose -= .001 , nose += .001 );     /* for binoculars      */
   CYCLE(' ', mode,TURNMODE+1);                  /* fly/turn modes      */
   PRESS('i', mysiz /= 1.1, mysiz *= 1.1)        /* rescale the world   */
   PRESS('o', focal *= 1.1 , focal /= 1.1)       /* telephoto           */
   PRESS('p', wfar *= 1.01 , wfar   /= 1.01)       /* rear clipping plane */
   PRESS('s',speed /= 1.02, speed *= 1.02);      /* flying speed        */
   PRESS('q',torq /= 1.02, torq *= 1.02);        /* turning speed       */
   PRESS('g',gap /= .99, gap *= .99);             /* gap parameter       */
   PRESS('z', deFault(), deFault());             /* zap changes         */

   TOGGLE('b',showSphere);                        /* turn on/off slate   */
   CYCLE('c',whichGamma,3);     /* specify which type of frame   */
   TOGGLE('l',showslate);                        /* turn on/off slate   */
   TOGGLE('k',computeOnTheFly);                            /* autotymer on/off    */
   PRESS('e',DDist-=.01;adjustNormalDev(), DDist+=.01;adjustNormalDev());        /* dist normal dev from origin */
   PRESS('r',DCent-=.01;adjustNormalDev(), DCent+=.01;adjustNormalDev());             /* center of normal dev   */
   PRESS('t', DHalfLeng-=.01;adjustNormalDev(), DHalfLeng+=.01;adjustNormalDev()); /* length of dev line segment */
   PRESS('d',if(jumP>0){ jumP--;}, if(jumP<GAP){ jumP++;}); /* speed up/slow down the frame  */
   PRESS('f',if(showFrame) flyTheFrame(),if(showFrame) flyTheFrame());        /* actually fly */
   TOGGLE('y',showFrame);        /* frame on/off */
   IF(27) {audioclean(); exit(0); }              /* ESC exit            */
}

void special_keybo(int key, int x, int y){
/*non-ASCII keypresses go here, if you're lucky enough to know their names */
 fprintf(stderr," non-ASCII character was pressed.\n");
 fprintf(stderr," use special_keybo() to process it\n");
}
/* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */
#ifdef CAVE
/* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */

void cavekeybo(void){
#define  CAVEIF(K)         if(CAVEgetbutton(K))
#define  CAVEPRESS(K,A,b)  CAVEIF(K){if(CAVEgetbutton(CAVE_LEFTSHIFTKEY)||\
                           CAVEgetbutton(CAVE_RIGHTSHIFTKEY)){b;}else{A;}}
#define  CAVETOGGLE(K,flg) CAVEIF(K){(flg) = 1-(flg); }
#define  CAVECYCLE(K,f,m)  CAVEPRESS((K),(f)=(((f)+(m)-1)%(m)),(f)=(++(f)%(m)) )
#define  CAVESLIDI(K,f,m,M)  CAVEPRESS(K,(--f<m?m:f), (++f>M?M:f))
#define  CAVESLIDF(K,f,m,M,d) CAVEPRESS(K,((f -= d)<m?m:f), ((f += d)>M?M:f))
  CAVEPRESS(CAVE_PKEY, wfar *= 1.01,   wfar   /= 1.01) /* rear clipping plane*/
  CAVEPRESS(CAVE_QKEY, speed /= 1.02, speed *= 1.02);/* flying speed       */
  CAVEPRESS(CAVE_RKEY, torq /= 1.02,  torq *= 1.02); /* turning speed      */
  CAVETOGGLE(CAVE_YKEY,wnd);                         /* mauspaw vs wandpaw */
/* not yet implemented */ 
   CAVEPRESS(CAVE_ZKEY, deFault(), deFault());        /* zap changes       */
}

void graffiti(void){             /* used to be called speedo  */
  char buf[256];                 /*messages written into here */ 
#define  LABEL3(x,y,z,W,u){sprintf(buf,(W),(u));char2wall(x,y,z,buf);}
  static float last=0.,fps;      /*for measuring time         */ 
  if(!CAVEMasterDisplay()) return;  /* USE CAVEMasterWall in papeBeta */
  if(floor(2.*(*CAVETime))>floor(2.*last)){  /* rationalize this */ 
     last=*CAVETime;
     fps=*CAVEFramesPerSecond;
     }
  if(mode==TURNMODE){
        glColor3f(1.,0.,1.);
        LABEL3(-3.8,1.,-5.0,\
          "4=auto 2=mode 3=shrink 6=grow 5=freeze 7=reset %s","");
        } else {
        glColor3f(1.,1.,0.);
        LABEL3(-3.8,1.0,-5.0,
          " push thumb-button to fly, 2=tractor gap %s","gap");
        }
     LABEL3(-4.8,8.0,-5.0, "BishopCoaster In illiOpenSkelGLUT\
    by P. McCreary, (C) 1997 U.Illinois %s","")
       LABEL3(-4.8,1.0,-5.0,"%5.1f fps",fps);
}

void cavetrack(void){
  float azi,ele,rol,hx,hy,hz,wx,wy,wz;
  static float ohx,ohy,ohz;   /*old head position */
  static float owx,owy,owz;   /*old wand position */
  static int opaw = 0,paw, joy = 0, friz;

  if(!CAVEMasterDisplay()) return;  /* doit once per frame */
  paw = wnd ? (CAVEBUTTON1*2+CAVEBUTTON2)*2+CAVEBUTTON3 : mauspaw;
  if(paw) joy = 1; /* activate joystick by clicking any button*/
  if(opaw!=2 && paw==2) mode = (mode+1)%(TURNMODE+1); /* click modes */
  if(mode==TURNMODE){   /* hold middle button and click right to shrink */
     if (opaw == 2 && paw == 3)siz /= 1.5;     /*shrink object */
     if (opaw == 2 && paw == 6)siz *= 1.5;     /* grow   object */
     if (opaw != 4 && paw == 4)morph = 1-morph;/* shape changer */
     if (opaw != 5 && paw == 5)friz = 1-friz;  /* parking option */
     } 
  
  if(opaw==5 && paw == 5)gap *= 1.1;  /* hold right and  */ 
  if(opaw==3 && paw == 3)gap /= 1.1;  /* +left -right    */ 

  if(opaw==2 && paw == 7){ /* restart, the most useful feature */
     deFault(); ohx=ohy=ohz=0; owx=owy=owz=0;
     } 
  if(wnd){ 
      CAVEGetWandOrientation(azi,ele,rol);
      CAVEGetHead(hx,hy,hz);  /*position*/
      CAVEGetWand(wx,wy,wz);  /*position*/ 
      }
   else{  /* fix this for CAVE mouse flying */ 
      azi = .5*512; ele = .5*-512;
      } 
   glMatrixMode(GL_MODELVIEW); glPushMatrix(); glLoadIdentity();

   glTranslatef(ohx-hx,ohy-hy,ohz-hz); 
 if(mode==TURNMODE) glTranslatef(aff[12],aff[13],aff[14]);
   if(!friz){  /* if not parked */
      glRotatef(rol*(mode?torq:-torq),0.,0.,1.); 
      glRotatef(ele*-torq, 1.,0.,0.); 
      glRotatef(azi*-torq,0.,1.,0.);
      }
   if(joy&&((abs(CAVE_JOYSTICK_Y)>.02)||(abs(CAVE_JOYSTICK_X)>.02)))
       glTranslatef(CAVE_JOYSTICK_X*speed,0.,CAVE_JOYSTICK_Y*speed);
 
 if(opaw==2 && paw==2)glTranslatef(wx-owx, wy-owy, wz-owz); /*wand tractor */

 if(mode == TURNMODE) glTranslatef(-aff[12],-aff[13],-aff[14]);
   glMultMatrixf(aff); 
   glGetFloatv(GL_MODELVIEW_MATRIX,aff);

  {int ii,jj; for(ii=0;ii<3;ii++){ lu[ii]=0; /* calculite */
   for(jj=0;jj<3;jj++) lu[ii] += aff[ii*4+jj]*lux[jj];} }

   if(mode==FLYMODE && !friz) /*make the star matrix rotate*/
      {
      glLoadIdentity();
      glRotatef(rol*(mode?torq:-torq),0.,0.,1.); 
      glRotatef(ele*-torq,1.,0.,0.); 
      glRotatef(azi*-torq,0.,1.,0.);
      glMultMatrixf(starmat); 
      glGetFloatv(GL_MODELVIEW_MATRIX,starmat);
      }
   glPopMatrix();
   opaw=paw; ohx=hx; ohy=hy; ohz=hz;
             owx=wx; owy=wy; owz=wz;
   if(morph) autotymer(0);  /* advance autotymer */
   audiofunc();
}

void drawcaveinit(void){   /* kludge? needed why ? */  
   CAVEFar = 1000.;
   glClearColor(0.,0.,0.,0.);
   glClearDepth(1.);
}

void drawcave(void){
  float hx,hy,hz;
  glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
  drawstars();
  graffiti();
  CAVEGetHead(hx,hy,hz);
  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();
  glTranslatef(hx,hy,hz);
  glMultMatrixf(aff);
  glScalef(siz,siz,siz);
  drawall();
  glPopMatrix();
}
#endif
/*
UNIX Speedometer

float speedometer(void){
double dbl; static double rate; static int ii=0;
static struct timezone notused; static struct timeval now, then;
   if(++ii % 8 == 0){  // 8 times around measure time 
      gettimeofday(&now, &notused); // elapsed time 
      dbl =  (double)(now.tv_sec - then.tv_sec)
         +(double)(now.tv_usec - then.tv_usec)/1000000;
      then = now;  rate = 8/dbl;
      }
   return((float)rate);
}
*/

/**********************************************************/
/*** console speedometer                                  */
/**********************************************************/
float speedometer(void){
/* this is the windows speedometer */
double dbl; static double rate; static int ii=0;

static struct _timeb lnow, lthen;

   if(++ii % 8 == 0){  /* 8 times around measure time */

	   _ftime(&lnow);
		dbl =  (double)(lnow.time - lthen.time)
			 +(double)(lnow.millitm - lthen.millitm)/1000;
		lthen = lnow;  rate = 8/dbl;
      }

   return((float)rate);
}



 
void messages(void){     
  char buf[256]; /* console messages are done differently from cave */
#define  LABEL2(x,y,W,u) {sprintf(buf,(W),(u));char2wall(x,y,0.,buf);}
  glMatrixMode(GL_PROJECTION); glPushMatrix(); glLoadIdentity();
  gluOrtho2D(0,3000,0,3000);
  glMatrixMode(GL_MODELVIEW); glPushMatrix(); glLoadIdentity();

      /*bull's eye*/
      if(mode==TURNMODE) glColor3f(0x22/255.,0x88/255.,0xdd/255.);
        else      glColor3f(.8,.8,.8);
      LABEL2(1500,1500,"%s","o");
      /* writings */
      if(mode==TURNMODE) glColor3f(1.,0.,1.);
        else      glColor3f(1.,1.,0.);
      LABEL2(80,80,"%4.1f fps",speedometer());
      LABEL2(80,2840,\
      "(ESC)ape (V)Binoc (MAUS2)Fore (BAR)Flymode %s (H)omotopy (W)riting",
             mode?"FLYING":"CONTROL");
      LABEL2(10,10,"BishopCoaster \
   by P. McCreary, U Illinois, 1997 %s","");
      LABEL2(80,2770,"(N)ose   %0.3f",nose);
      LABEL2(80,2700,"(S)peed  %0.4f",speed);
      LABEL2(80,2630," tor(Q) %0.4f",torq);
      LABEL2(80,2560,"near clipper %g", mysiz*focal);
      LABEL2(80,2490,"f(O)cal factor %g",focal);
      LABEL2(80,2420,"my s(I)ze %.2g",mysiz);
      LABEL2(80,2350,"wfar cli(P)er= %.2g",wfar);
      LABEL2(80,2280,"(Z)ap %s","");
      LABEL2(80,2210,"shws(l)ate %d",showslate);
      LABEL2(80,2140,"whi(c)hG %d",whichGamma);
      LABEL2(80,2070,"(B)ish sph   %d",showSphere);

      LABEL2(80,2000,"spee(d)  %d",jumP);
      LABEL2(80,1930," (k)omp %d",computeOnTheFly);
      LABEL2(80,1860,"e/r/t (parameters)", 0);
      LABEL2(80,1790,"(f)ly the frame %d",flyTheFrame);
      LABEL2(80,1720,"sh(y)wFrame %d",showFrame);
    glPopMatrix();
glMatrixMode(GL_PROJECTION); glPopMatrix();
} 

void chaptrack(int but,int xx,int yy,int shif){  
   long dx,dy; 
   dx = xx -.5*xt; dx = abs(dx)>5?dx:0;
   dy = yy -.5*yt; dy = abs(dy)>5?dy:0;

   glMatrixMode(GL_MODELVIEW); glPushMatrix(); glLoadIdentity();

   if(mode==TURNMODE) glTranslatef(aff[12],aff[13],aff[14]);
   glRotatef(dx*torq,0.,1.,0.); glRotatef(dy*torq,1.,0.,0.);
   if(but&(1<<GLUT_RIGHT_BUTTON ))glRotatef(shif?-10:-1,0.,0.,1.);
   if(but&(1<<GLUT_LEFT_BUTTON  ))glRotatef(shif?10:1,0.,0.,1.);
   if(mode==FLYMODE){      
      glPushMatrix();
      glMultMatrixf(starmat);
      glGetFloatv(GL_MODELVIEW_MATRIX,starmat);
      glPopMatrix();
   }
   if(but&(1<<GLUT_MIDDLE_BUTTON)) glTranslatef(0.,0.,shif ? -speed : speed);
   if(mode==TURNMODE) glTranslatef(-aff[12],-aff[13],-aff[14]);
   glMultMatrixf(aff); 
   glGetFloatv(GL_MODELVIEW_MATRIX,aff);
   {int ii,jj; for(ii=0;ii<3;ii++){ lu[ii]=0; /* calculite */
          for(jj=0;jj<3;jj++) lu[ii] += aff[ii*4+jj]*lux[jj];}}
   glPopMatrix();
}

void reshaped(int xx, int yy){xt=xx ; yt=yy;}   /* what is this for ? */

void drawcons(void){ 
  glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

	if(showslate){
/*******************
****  
****    
******prep screen to draw slate
***************/
  glMatrixMode(GL_PROJECTION); glPushMatrix(); glLoadIdentity();
  gluOrtho2D(-2,2,-1.5,1.5);
  glMatrixMode(GL_MODELVIEW); glPushMatrix(); glLoadIdentity();
/*******************/
drawslate2D();
drawDevCirc();
drawDevelopment();
/*******************/
glPopMatrix();
glMatrixMode(GL_PROJECTION); glPopMatrix();
/*******************
****  
****    
*******un-prep screen after drawing slate
***************/
	}/**End if(showslate)***************************************/
 
  if(binoc) glViewport(0,yt/4,xt/2,yt/2);
  glMatrixMode(GL_PROJECTION); glLoadIdentity();
  glFrustum(-mysiz*xt/yt,mysiz*xt/yt,-mysiz,mysiz,mysiz*focal,wfar); 
  glMatrixMode(GL_MODELVIEW); glLoadIdentity();
  drawstars();
  glTranslatef(-binoc*nose,0.0,0.0);
  glMultMatrixf(aff);
  drawall();
  if(binoc){
    glViewport(xt/2,yt/4,xt/2,yt/2); 
    glMatrixMode(GL_MODELVIEW);
    glLoadIdentity();
    drawstars();
    glTranslatef(binoc*nose,0.0,0.0);
    glMultMatrixf(aff);
    drawall();
    }
  glViewport(0,0,xt,yt);
  if(msg) messages();
  glutSwapBuffers();
}

void idle(void){ /*do this when nothing else is happening*/
   if(morph) autotymer(0);  /* advance autotymer */ 
   glutPostRedisplay();  /*redraw the window*/
   chaptrack(BUT,XX,YY,SHIF);
   audiofunc();  
}

void mousepushed(int but,int stat,int x,int y){
  if(stat==GLUT_DOWN) BUT |= (1<<but);
  else BUT &= (-1 ^ (1<<but));  
  XX=x; YY=y; SHIF=(glutGetModifiers()==GLUT_ACTIVE_SHIFT)?1:0;
}

void mousemoved(int x,int y){  XX=x; YY=y; }

void main(int argc, char **argv){  
   arguments(argc,argv); 
   if(caveyes)
#ifdef CAVE
       CAVEConfigure(&argc, argv, NULL)
#endif
       ;
   getmem();
   dataprep();
 
   if(caveyes){
#ifdef CAVE
       CAVEInit(); /* Each wall is (part of) a forked process from here on.*/ 
       CAVEFrameFunction(cavetrack,0);  
       /*is restricted to MasterWall, so once per frame */
       CAVEInitApplication(drawcaveinit, 0); 
       CAVEDisplay(drawcave, 0);
       while(!CAVEgetbutton(CAVE_ESCKEY))
         {
         cavekeybo();  /* is asynchronous from display processes */ 
	 }
       audioclean();
       CAVEExit();
#endif
       ;}
     else{ /*console main*/
       glutInit(&argc, argv);
       glutInitDisplayMode(GLUT_DOUBLE|GLUT_DEPTH);
       /*
	   switch(win)
         { case 0: break;
           case 1: glutInitWindowSize(640, 480);
                   glutInitWindowPosition(0,1024-480);
                   break;
           case 2: glutInitWindowPosition(0,0);
	           break;
         }*/
       glutCreateWindow("<* illiBishopCoaster in C/OpenGL/GLUT *>");
       if(win==2) glutFullScreen();
       glEnable(GL_DEPTH_TEST);
       glutDisplayFunc(drawcons);       
       glutKeyboardFunc(keyboard);
       glutSpecialFunc(special_keybo);
       glutMouseFunc(mousepushed);
       glutMotionFunc(mousemoved);       
       glutPassiveMotionFunc(mousemoved); 
       glutReshapeFunc(reshaped);
       glutIdleFunc(idle);             
       glutMainLoop();
       }
} 
