/* illini Joe by Sherwin Tam Math 198 May 9, 1996
   my venture into the world of OpenGL graphics */

/* including the standard OpenGL libraries, as well as an auxilliary library aux.h */

#include <GL/gl.h>
#include <GL/glu.h>
#include <GL/glx.h>
#include <math.h>
// #include "aux.h"

/* defining macros for the body parts so that program isn't quite as confusing */
#define UPPER_TORSO      0
#define HEAD             1
#define UPPER_RIGHT_ARM  2
#define LOWER_RIGHT_ARM  3
#define RIGHT_HAND       4
#define UPPER_LEFT_ARM   5
#define LOWER_LEFT_ARM   6
#define LEFT_HAND        7
#define LOWER_TORSO      8
#define UPPER_RIGHT_LEG  9
#define LOWER_RIGHT_LEG 10
#define RIGHT_FOOT      11
#define UPPER_LEFT_LEG  12
#define LOWER_LEFT_LEG  13
#define LEFT_FOOT       14
#define CAMERA          15
#define LIGHT           16	

/* amount  that each key press will move */
#define INCREMENT 3;

/* colors for glColor() */
GLfloat glfBlue[]= {0.0, 0.2, 0.5, 1.0};
GLfloat glfGreen[]= {0.0, 0.5, 0.0, 1.0};
GLfloat glfDarkBrown[] = {0.7, 0.2, 0.1, 1.0};
GLfloat glfSkin[]= {0.8, 0.3, 0.2, 1.0};

/* matrix storing all positional values of the body */
GLfloat positions[17][2];

/* even bigger matrix storing the limits on the joints of the body -- the first
   dimension is the parts, the second is the first pair of limits, and the third is another
   pair of limits */
GLfloat limits[15][2][2];

GLint side;        /* current side of the body */

GLint lastcurrent;    /* last picked body part */

GLint current;     /* current picked body part */

/*  initializes variables */
void initVar(void)
{
  GLint i;  /* counters for for loop */
  GLint j;
  
  for (i = 0; i < 17; i++)   /* initializes positions to (0,0,0) */
    for (j = 0; j < 2; j++)
      positions[i][j] = 0.0;
  current = UPPER_TORSO;
  side = 1;
  
  /* sets limits for all joints */
  limits[UPPER_TORSO][0][0] = -30.0; /* limits for up-down keys */
  limits[UPPER_TORSO][0][1] = 135.0;
  limits[UPPER_TORSO][1][0] = -45.0; /* limits for left-right keys */
  limits[UPPER_TORSO][1][1] =  45.0;
  limits[HEAD][0][0] = -30.0;
  limits[HEAD][0][1] =  30.0;
  limits[HEAD][1][0] = -45.0;
  limits[HEAD][1][1] =  45.0;
  limits[UPPER_RIGHT_ARM][0][0] = -180.0;    
  limits[UPPER_RIGHT_ARM][0][1] =   45.0;
  limits[UPPER_RIGHT_ARM][1][0] =  -30.0;
  limits[UPPER_RIGHT_ARM][1][1] =  180.0;
  limits[LOWER_RIGHT_ARM][0][0] = -165.0;     
  limits[LOWER_RIGHT_ARM][0][1] =    0.0;
  limits[LOWER_RIGHT_ARM][1][0] =  -90.0;
  limits[LOWER_RIGHT_ARM][1][1] =   60.0;
  limits[RIGHT_HAND][0][0] = -90.0;    
  limits[RIGHT_HAND][0][1] =  90.0;
  limits[RIGHT_HAND][1][0] = -90.0;
  limits[RIGHT_HAND][1][1] =  90.0;
  limits[UPPER_LEFT_ARM][0][0] =  -180.0;   
  limits[UPPER_LEFT_ARM][0][1] =    45.0;
  limits[UPPER_LEFT_ARM][1][0] =  -180.0;
  limits[UPPER_LEFT_ARM][1][1] =    30.0;
  limits[LOWER_LEFT_ARM][0][0] =  -165.0;     
  limits[LOWER_LEFT_ARM][0][1] =     0.0;
  limits[LOWER_LEFT_ARM][1][0] =   -60.0;
  limits[LOWER_LEFT_ARM][1][1] =    90.0;
  limits[LEFT_HAND][0][0] = -90.0;     
  limits[LEFT_HAND][0][1] =  90.0;
  limits[LEFT_HAND][1][0] = -90.0;
  limits[LEFT_HAND][1][1] =  90.0;
  limits[UPPER_RIGHT_LEG][0][0] = -135.0;     
  limits[UPPER_RIGHT_LEG][0][1] =   30.0;
  limits[UPPER_RIGHT_LEG][1][0] =  -30.0;
  limits[UPPER_RIGHT_LEG][1][1] =   85.0;
  limits[LOWER_RIGHT_LEG][0][0] =    0.0;    
  limits[LOWER_RIGHT_LEG][0][1] =  165.0;
  limits[LOWER_RIGHT_LEG][1][0] =  -90.0;
  limits[LOWER_RIGHT_LEG][1][1] =   30.0;
  limits[RIGHT_FOOT][0][0] = -90.0;    
  limits[RIGHT_FOOT][0][1] =   0.0;
  limits[RIGHT_FOOT][1][0] = -30.0;
  limits[RIGHT_FOOT][1][1] =  30.0;
  limits[UPPER_LEFT_LEG][0][0] = -135.0;     /*upper legs*/
  limits[UPPER_LEFT_LEG][0][1] =   30.0;
  limits[UPPER_LEFT_LEG][1][0] =  -85.0;
  limits[UPPER_LEFT_LEG][1][1] =   30.0;
  limits[LOWER_LEFT_LEG][0][0] =    0.0;     /*lower legs*/
  limits[LOWER_LEFT_LEG][0][1] =  165.0;
  limits[LOWER_LEFT_LEG][1][0] =  -30.0;
  limits[LOWER_LEFT_LEG][1][1] =   90.0;
  limits[LEFT_FOOT][0][0] =  -90.0;     /*feet*/
  limits[LEFT_FOOT][0][1] =    0.0;
  limits[LEFT_FOOT][1][0] =  -30.0;
  limits[LEFT_FOOT][1][1] =   30.0;
}

/* initializes most of the environment lighting properties */
void initLighting(void)
{
  GLfloat glfDiffuse[]= {0.7, 0.7, 0.7, 1.0};  
  GLfloat glfAmbient[]= {0.1, 0.1, 0.1, 1.0};

  glLightfv( GL_LIGHT0, GL_AMBIENT, glfAmbient); /* sets ambient light */
  glLightfv( GL_LIGHT0, GL_DIFFUSE, glfDiffuse); /* sets diffuse light */

  glEnable(GL_LIGHTING);   /* enables lighting */
  glEnable(GL_LIGHT0);     /* creates light source */
  glDepthFunc(GL_LEQUAL);  /* test for depth buffer */
  glEnable(GL_DEPTH_TEST); /* enables depth test */
  glEnable(GL_NORMALIZE);  /* normalizes normal vectors */
  glShadeModel(GL_SMOOTH); /* smooth (Gourand shading) */
  glColorMaterial(GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE);
    /* color of given faces with given properties is tracked */
  glEnable(GL_COLOR_MATERIAL);  /* enable glColorMaterial() */
}

/* modifies projection and modelview matrices when window is
   created/moved/sized */
void myReshape( const int w, const int h)
{
  glViewport(0, 0, w, h);      
  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  gluPerspective(65.0, (GLfloat) w/(GLfloat) h, 0.5, 500.0);
  glMatrixMode(GL_MODELVIEW);
  glLoadIdentity();
}


/* function for up key */
void currentsubtract1(void)
{
  positions[current][0] -= INCREMENT;
  if (current == CAMERA || current == LIGHT)
    positions[current][0] = (GLint) positions[current][0] % 360;
  else if (positions[current][0] < limits[current][0][0])
    positions[current][0] = limits[current][0][0];
}

 /* function for down key */ 
void currentadd1(void)
{
  positions[current][0] += INCREMENT;
  if (current == CAMERA || current == LIGHT)
    positions[current][0] = (GLint)positions[current][0] % 360;
  else if (positions[current][0] > limits[current][0][1])
    positions[current][0] = limits[current][0][1];
}

/* function for left key */
void currentsubtract2(void)
{
  positions[current][1] -= INCREMENT;
  if (current == CAMERA || current == LIGHT)
    positions[current][1] = (GLint)positions[current][1] % 360;
  else if (positions[current][1] < limits[current][1][0])
    positions[current][1] = limits[current][1][0];
}

/* function for right key */
void currentadd2(void)
{
  positions[current][1] += INCREMENT;
  if (current == CAMERA || current == LIGHT)
    positions[current][1] = (GLint)positions[current][1] % 360;
  else if (positions[current][1] > limits[current][1][1])
    positions[current][1] = limits[current][1][1];
}   

/* changes sides if current is equal to given check */
void checksides(void)
{
  if (current == lastcurrent)
    side = - side;
}

/* function for 1 key */
void to_torso(void)
{
  current = UPPER_TORSO;
  lastcurrent = current;
}

/* function for 2 key */
void to_head(void)
{
  current = HEAD;
  lastcurrent = current;
}

/* function for 3 key */
void to_upper_arms(void)
{
  if (side == 1)
    current = UPPER_RIGHT_ARM;
  else
    current = UPPER_LEFT_ARM;
  checksides();
  lastcurrent = current;
}

/* function for 4 key */
void to_lower_arms(void)
{
  if (side == 1)
    current = LOWER_RIGHT_ARM;
  else
    current = LOWER_LEFT_ARM;
  checksides();
  lastcurrent = current;
}

/* function for 5 key */
void to_hands(void)
{ 
  if (side == 1)
    current = RIGHT_HAND;
  else
    current = LEFT_HAND;
  checksides();
  lastcurrent = current;
}

/* function for 6 key */
void to_upper_legs(void)
{ 
  if (side == 1)
    current = UPPER_RIGHT_LEG;
  else
    current = UPPER_LEFT_LEG;
  checksides();
  lastcurrent = current;
}

/* function for 7 key */
void to_lower_legs(void)
{
  if (side == 1)
    current = LOWER_RIGHT_LEG;
  else
    current = LOWER_LEFT_LEG;
  checksides();
  lastcurrent = current;
}

/* function for 8 key */
void to_feet(void)
{
  if (side == 1)
    current = RIGHT_FOOT;
  else
    current = LEFT_FOOT;
  checksides();
  lastcurrent = current;
}

/* function for 9 key */
void to_camera(void)
{
  current = CAMERA;
  lastcurrent = current;
}

/* function for 0 key */
void to_light(void)
{
  current = LIGHT;
  lastcurrent = current;
}

/* changes emission light for selected body part */
void check_emission(GLint check)
{
  GLfloat glfEmission[] = {0.5, 0., 0.0, 0.0};
  GLfloat glfNoEmission[] = {0.0, 0.0, 0.0, 1.0};

  if (check == current)
    glMaterialfv(GL_FRONT, GL_EMISSION, glfEmission);
  else
    glMaterialfv(GL_FRONT, GL_EMISSION, glfNoEmission);
}

/* draws upper torso*/
void draw_upper_torso(void)              
{  
    glColor4fv(glfSkin);                 /* sets color until next set */
    glPushMatrix();                      /* neck */
      glTranslatef(0.0, 5.0, 0.0);
      glScalef(.75, 1.5, .75);
      auxSolidIcosahedron(1.0);
    glPopMatrix();
  
    glPushMatrix();                      /* left shoudler */
      glTranslatef(-2.25, 4.5, 0.0);
      glScalef(1.0, 1.0, 1.0);
      auxSolidIcosahedron(1.0);
    glPopMatrix();
  
    glPushMatrix();                      /* right shoulde r*/
      glTranslatef(2.25, 4.5, 0.0);
      glScalef(1.0, 1.0, 1.0);
      auxSolidIcosahedron(1.0);
    glPopMatrix();
   
    glColor4fv(glfGreen);
    glPushMatrix();                      /* chest */
      glTranslatef(0.0, 3.15, 0.0);
      glScalef(2.25, 2.5, 1.5);
      auxSolidIcosahedron(1.0);
    glPopMatrix();
    
    glPushMatrix();                      /* upper abdomen */
      glTranslatef(0.0, 1.0, 0.0);
      glScalef(1.35, 1.75, 1.2);
      auxSolidIcosahedron(1.0);
    glPopMatrix();
   
    glPushMatrix();                      /* waist */
      glTranslatef(0.0, -.5, 0.0);
      auxSolidIcosahedron(.75);
    glPopMatrix();
}

/* draws head*/
void draw_head(void)
{
  glColor4fv(glfSkin); 
  glPushMatrix();                        
    glTranslatef(0.0, 0.5, .5);
    glScalef(1.1, 1.5, 1.1);  
    auxSolidIcosahedron(1.0);
  glPopMatrix();
}

/* draws upper arms*/
void draw_upper_arm(void)
{
   glPushMatrix();                      
      glTranslatef(0.0, -2.0, 0.0);
      glScalef(.75, 2.25,.75);
      auxSolidIcosahedron(1.0);
    glPopMatrix();

    glTranslatef(0.0, -4.25, 0.0);  /* elbow */
    auxSolidIcosahedron(.7);
}

/* draws lower arms*/
void draw_lower_arm(void)
{
    glPushMatrix();                       
      glTranslatef(0.0, -1.75, 0.0);
      glScalef(.65, 1.75, .65);
      auxSolidIcosahedron(1.0);
    glPopMatrix();
    
    glTranslatef(0.0, -3.25, 0.0);  /* wrist */
    auxSolidIcosahedron(.5);
}

/* draws hands*/
void draw_hand(void)
{
    glPushMatrix();                     
      glTranslatef(0.0, -1.25, 0.0);
      glScalef(.45, 1.2, .6);
      auxSolidIcosahedron(1.0);
    glPopMatrix();  
}

/* draws lower torso*/
void draw_lower_torso(void)
{
  glColor4fv(glfBlue);
  glPushMatrix();                      
    glTranslatef(0.0, -1.75, 0.0);
    glScalef(2.0, 1.5, 1.25);
    auxSolidIcosahedron(1.0);
  glPopMatrix();
}

/* draws upper legs*/
void draw_upper_leg(void)
{
    glColor4fv(glfBlue);
    glPushMatrix();                      
      glTranslatef(0.0, -3.0, 0.0);   
      glScalef(1.1, 3.5, 1.1);
      auxSolidIcosahedron(1.0);
    glPopMatrix();
    
    glTranslatef(0.0, -6.0, 0.0);        /* knee */
    auxSolidIcosahedron(.75); 
}

/* draws lower legs*/
void draw_lower_leg(void)
{
    glColor4fv(glfDarkBrown);
    glPushMatrix();                     
      glTranslatef(0.0, -2.5, 0.0);
      glScalef(.75, 2.5, .75);
      auxSolidIcosahedron(1.0);
    glPopMatrix();

    glTranslatef(0.0, -4.75, 0.0);       /* ankle */
    auxSolidIcosahedron(.5);
}

/* draws feet*/
void draw_foot(void)
{
  glPushMatrix();                       
    glTranslatef(0.0, -1.5, 0.0);
    glScalef(.6, 1.5, .45);
    auxSolidIcosahedron(1.0);
  glPopMatrix();
}

/* draws individual frame */
void draw_frame(void)
{
  GLfloat glfPosition[]= {0.0, 0.0, 6.0, 1.0};
  
  glPushMatrix();
    glRotatef(positions[LIGHT][0], 1.0, 0.0, 0.0);
    glRotatef(positions[LIGHT][1], 0.0, 1.0, 0.0);
    glLightfv( GL_LIGHT0, GL_POSITION, glfPosition); 
      /* sets light position*/
  glPopMatrix();

  glRotatef(positions[CAMERA][0], 1.0, 0.0, 0.0);  /* rotates camera */
  glRotatef(positions[CAMERA][1], 0.0, 1.0, 0.0);
  
  glPushMatrix();
    glTranslatef(0.0, -.5, 0.0);
    glRotatef(positions[UPPER_TORSO][0], 1.0, 0.0, 0.0);
    glRotatef(positions[UPPER_TORSO][1], 0.0, 1.0, 0.0);
    glTranslatef(0.0, .5, 0.0);
    check_emission(UPPER_TORSO);
    draw_upper_torso();
    glPushMatrix();  
      glTranslatef(0.0, 6.25, 0.0);
      glRotatef(positions[HEAD][0], 1.0, 0.0, 0.0);
      glRotatef(positions[HEAD][1], 0.0, 1.0, 0.0);  
      check_emission(HEAD);
      draw_head();
    glPopMatrix();
    glPushMatrix();  
      glTranslatef(-2.75, 4.5, 0.0);
      glRotatef(positions[UPPER_LEFT_ARM][0], 1.0, 0.0, 0.0);
      glRotatef(positions[UPPER_LEFT_ARM][1], 0.0, 0.0, 1.0);
      check_emission(UPPER_LEFT_ARM);
      draw_upper_arm();
      glRotatef(positions[LOWER_LEFT_ARM][0], 1.0, 0.0, 0.0);
      glRotatef(positions[LOWER_LEFT_ARM][1], 0.0, 0.0, 1.0);
      check_emission(LOWER_LEFT_ARM);
      draw_lower_arm();
      glRotatef(positions[LEFT_HAND][0], 1.0, 0.0, 0.0);
      glRotatef(positions[LEFT_HAND][1], 0.0, 0.0, 1.0);
      check_emission(LEFT_HAND);
      draw_hand();
    glPopMatrix();
    glPushMatrix();
      glTranslatef(2.75, 4.5, 0.0);
      glRotatef(positions[UPPER_RIGHT_ARM][0], 1.0, 0.0, 0.0);
      glRotatef(positions[UPPER_RIGHT_ARM][1], 0.0, 0.0, 1.0);
      check_emission(UPPER_RIGHT_ARM);
      draw_upper_arm();
      glRotatef(positions[LOWER_RIGHT_ARM][0], 1.0, 0.0, 0.0);
      glRotatef(positions[LOWER_RIGHT_ARM][1], 0.0, 0.0, 1.0);
      check_emission(LOWER_RIGHT_ARM);
      draw_lower_arm();
      glRotatef(positions[RIGHT_HAND][0], 1.0, 0.0, 0.0);
      glRotatef(positions[RIGHT_HAND][1], 0.0, 0.0, 1.0);
      check_emission(RIGHT_HAND);
      draw_hand();
    glPopMatrix();
  glPopMatrix();
  glPushMatrix();
    check_emission(LOWER_TORSO);
    draw_lower_torso();
    glPushMatrix();
      glTranslatef(-1.15, -2.25, 0.0);
      glRotatef(positions[UPPER_LEFT_LEG][0], 1.0, 0.0, 0.0);
      glRotatef(positions[UPPER_LEFT_LEG][1], 0.0, 0.0, 1.0);
      check_emission(UPPER_LEFT_LEG);
      draw_upper_leg();
      glRotatef(positions[LOWER_LEFT_LEG][0], 1.0, 0.0, 0.0);
      glRotatef(positions[LOWER_LEFT_LEG][1], 0.0, 0.0, 1.0);
      check_emission(LOWER_LEFT_LEG);
      draw_lower_leg();
      glRotatef(positions[LEFT_FOOT][0], 1.0, 0.0, 0.0);
      glRotatef(positions[LEFT_FOOT][1], 0.0, 0.0, 1.0);
      check_emission(LEFT_FOOT);
      draw_foot();
    glPopMatrix();
    glPushMatrix();
      glTranslatef(1.15, -2.25, 0.0);
      glRotatef(positions[UPPER_RIGHT_LEG][0], 1.0, 0.0, 0.0);
      glRotatef(positions[UPPER_RIGHT_LEG][1], 0.0, 0.0, 1.0);
      check_emission(UPPER_RIGHT_LEG);
      draw_upper_leg();
      glRotatef(positions[LOWER_RIGHT_LEG][0], 1.0, 0.0, 0.0);
      glRotatef(positions[LOWER_RIGHT_LEG][1], 0.0, 0.0, 1.0);
      check_emission(LOWER_RIGHT_LEG);
      draw_lower_leg();
      glRotatef(positions[RIGHT_FOOT][0], 1.0, 0.0, 0.0);
      glRotatef(positions[RIGHT_FOOT][1], 0.0, 0.0, 1.0);
      check_emission(RIGHT_FOOT);
      draw_foot();
    glPopMatrix();
  glPopMatrix();
}

/* primary call to display objects */
void display(void)
{
  glClear(GL_COLOR_BUFFER_BIT| GL_DEPTH_BUFFER_BIT); /* clears buffers */
  glPushMatrix();
  glTranslatef(0.0, 5.0, -30.0);

  draw_frame();

  glPopMatrix();

  glFlush();  /* forces operations to execute */
  glXSwapBuffers( auxXDisplay(), auxXWindow()); 
    /* swaps front and back buffers */
  glFinish(); /* forces operations to finish */
}

/* function driver */
void main()
{ 
  auxInitDisplayMode( AUX_DOUBLE| AUX_RGB| AUX_DIRECT| AUX_DEPTH);
    /* initializes the buffers */
  auxInitPosition(0, 0, 1280, 1024);  
    /* initializes window position and size */
  auxInitWindow("glfullscreen");  /* creates window */
  auxReshapeFunc(myReshape);  /* recalculates viewing matrices */
  initVar();     
  initLighting();
  auxKeyFunc (AUX_UP, currentsubtract1);  /* define functions for keys */
  auxKeyFunc (AUX_DOWN, currentadd1);
  auxKeyFunc (AUX_LEFT, currentsubtract2);
  auxKeyFunc (AUX_RIGHT, currentadd2);
  auxKeyFunc (AUX_1, to_torso);
  auxKeyFunc (AUX_2, to_head);
  auxKeyFunc (AUX_3, to_upper_arms);
  auxKeyFunc (AUX_4, to_lower_arms);
  auxKeyFunc (AUX_5, to_hands);
  auxKeyFunc (AUX_6, to_upper_legs);
  auxKeyFunc (AUX_7, to_lower_legs);
  auxKeyFunc (AUX_8, to_feet);
  auxKeyFunc (AUX_9, to_camera);
  auxKeyFunc (AUX_0, to_light);
  auxIdleFunc(display);  /* function to call when no events pending */
  auxMainLoop(display);  /* function to call for events */
}
