/*****************************2002*************************************/
/**** illiTor.c - program to display the geodesics on a torus ****/
/**** code adapted from tor.c to the illiSkel framework ****/
/**** Last modification by Jingyi Jin - 12/18/2002 ****/
/**********************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <glut.h> /* sgi <glut.h> */
/*#include <sys/timeb.h> /* sgi <sys/time.h> */
#include <sys/time.h> 
#include <math.h>

#pragma warning (disable:4305) /* constant double-to-float */

#define MAX(x,y) (((x)<(y))?(y):(x))
#define MIN(x,y) (((x)<(y))?(x):(y))
#define CLAMP(x,u,v) (x<u? u : (x>v ? v: x))
#define ABS(u) ((u)<0 ? -(u): (u))
#define FOR(a,b,c) for((a)=(b);(a)<(c);(a)++)
#define DOT(p,q) ((p)[0]*(q)[0]+(p)[1]*(q)[1]+(p)[2]*(q)[2])
#define NRM(p) sqrt(DOT((p),(p)))
#define M_PI (355./113) /* sgi already defins \pi */
#define DG M_PI/180
#define S(u) sin(u*DG)
#define C(u) cos(u*DG)
#define CLAMP(x,u,v) (x<u? u : (x>v ? v: x))
#define random rand /* library dependent name */
#define IFCLICK(K,a){static ff=1; if(getbutton(K))ff=1-ff; if(ff){a} }
#define MERIDIANS 32
#define LATITUDES 32
#define MANYSTARS 10000
#define SOAK(A) while(getbutton(A))

/************************** global variables **************************/
int win=1; /* used once to choose window size */
float gap, gap0=1.; /* deFault() uses gap0 set by arguments() */
float lux[3]={1.,2.,3.}; /* world light non unit vector */
float luxx[3]; /* object space direction vector */
float amb, pwr; /*ambient fraction, pseudo-specular power */
float mysiz,speed, torq, focal, wfar; /* navigation control variables */
unsigned int PAW,XX,YY,SHIF; /* used in chaptrack gluttery */
int xwide,yhigh; /* viewportery width and height */
int mode,morph,msg,binoc; /* viewing globals */
int th0, th1, dth0, dth1, dth, ta0, ta1, dta0, dta1, dta; /* torus parameters */

#define FLYMODE (0) /* yellow: turns around head as center */
#define TURNMODE (1) /* purple: turns around object center */

int ii, jj, kk; float tmp, temp; /* saves gray hairs later */
float aff[16], starmat[16], mat[16]; /* OpenGL placement matrices */
int binoc; /* flag for binocular stereo */
float nose; /* to eye distance in console */
char clefs[128]; /* which keys were pressed last */

float ustar = 0.,		/* basepoint */
      vstar = 0., 		/* basepoint, use ARROWKEYS */
      alpha = 0., 		/* initial direction  ANGLE*/
      beta  = 0.,		/* second direction */
     dalpha = 30.,		/* between spokes */
    ddalpha = M_PI/90,	/* turn direction */
      delta = .1,		/* time step size */
      testf = .1;		/* spare parameter */

float rho = 0.52,		/* minor axis  PKEY   */
	  pp[3], nn[3]; 		/* position, normal */

/* surface curvature parameters */
float gama= 0.05; 		/* base dot diameter */
int  bend = 2;			/* TKEY trip through mono - Gauss - mean - kay1 - kay2-barberpole */

/* geodesic flow parameters */
float udot, vdot, pdot, qdot,
	  vecf[4], uvpq[4];
float discr, /* discriminant for geodesic flow */
      ngauss,/* numerator of gaussian curvature */
      nmean; /* numerator of mean curvature */

int   many = 5,		/* how many legs, use MKEY */
     dmany = 1,                 /* arclength parameterm, use MKEY */
       tms = 1,			/* times correction, use UKEY */
     thick = 3, 		/* how thick the geo */
     spray = 0,			/* spray flag, use SKEY  */
       bar = 1,			/* colorbar flag, use JKEY */
       lin = 0,			/* geo-ray flag, use  LKEY */
      mxitr = 10; 		/*  currently max times iterate geod*/

/* INTEGER OPTION FLAGS */
int   qub  = 0, 		/* cubical frame, QKEY */
      web  = 1,                 /* render/wireframe, use RKEY */
      bfl  = 0,			/* binocula/cyclops, use VKEY */
      kbd  = 0,                 /* all/fewer parms are read in */
      skip  = 0;                 /* not in use */

/*********************** steering *************************************/
void autotymer(int reset){ /* cheap animator */
	#define TYME(cnt,max,act) {static cnt; if(first)cnt=max; else\
	if(cnt?cnt--:0){ act ; goto Break;}}
	static first = 1; /* the first time autymer is called */
	if(reset)first=1; /* or if it is reset to start over */
	TYME( shrink , 150 , th0++;th1--;ta0++;ta1--)
	TYME( pause , 20, 0 )
	TYME( grow , 150,th0--;th1++;ta0--;ta1++)
	TYME( dwell , 30, 0 )
	TYME(finish , 1 , first = 1 ) /* this TYME must be the last one */
	first = 0;
	Break: ; /* yes Virginia, C has gotos */
}

/**********************************************************************/
void deFault(void){ /* (Z)ap also restores these assignments */
	th0=5; th1=355; ta0=5; ta1=355; gap = gap0; /* torus parameters */
	msg=1; binoc=0; nose=.06; mode=TURNMODE; /* gadget parameters */
	speed=.02; torq=.02; focal = 2.; wfar=13; mysiz=.01; morph=0;
	FOR(ii,0,16) starmat[ii]=aff[ii] = (ii/4==ii%4); /* identity matrix */
	amb = .3; pwr = 10; /* lighting params */
	tmp=NRM(lux); FOR(ii,0,3)lux[ii] /= tmp; /* normalize light vector */
	aff[12]=0; aff[13]= 0; aff[14]= -4.2; /* place where we can see it */
	autotymer(1); /* reset autotymer to start at the beginning */
	dth1 = .4; dta1 = .5;
	dth=dth0; dta=dta0;
}

/**********************************************************************/
void posn(float u, float v){
      pp[0] = cos(u)*(1. + rho*cos(v));
      pp[1] = sin(u)*(1. + rho*cos(v));
      pp[2] = rho *sin(v); 
}

/**********************************************************************/
/* geodesy */

void geoflow() {
/*this one is in cartesian coordinates */
float  u,v,p,q;
u = uvpq[0]; v = uvpq[1]; p = uvpq[2]; q = uvpq[3];

vecf[0] = p;
vecf[1] = q;
vecf[2] = 2*p*q*sin(v)/(1. +rho*cos(v));
vecf[3] = -p*p*(1.+rho*cos(v))*sin(v)/rho;
}

/*************************** scenery **********************************/
void drawvert(int th, int ta){ /* make one properly lighted vertex */
	float bb,gg,rr;
	float lmb,spec,nn[3], dog, cat;

	/* radius of unit sphere is also unit normal to the torus */
	nn[0] = C(th)*C(ta);
	nn[1] = S(th)*C(ta);
	nn[2] = S(ta);

	/* illiLight by Ray Idaszak 1989 uses max{amb*lmb, rgb*lmb, spec} */
	lmb = DOT(nn,luxx); lmb =(lmb<0 ? .2 : lmb); lmb = MAX(amb, lmb);
	spec = CLAMP((1.1 - pwr+pwr*lmb), 0., 1.);

	/* illiPaint by Chris Hartman 1993 maps R2(cat,dog)->R3(r,g,b) */
	dog = (ta-ta0)/(float)(ta1-ta0); cat = (th-th0)/(float)(th1-th0);
	rr = MAX(spec, lmb*dog);
	gg = MAX(spec, lmb*(.25 + ABS(cat -.5)));
	bb = MAX(spec, lmb*(1 - cat));
	glColor3f(rr,gg,bb);

	/* torus has unit small diameter and unit big radius */
	glVertex3f( C(th) + .5*nn[0],
	S(th) + .5*nn[1],
	0 + .5*nn[2]);
} /* end drawvert */

/**********************************************************************/
void drawtor(void){ /* illiTorus with gaps */
	int th, ta;
	dth0 = (int)((th1-th0)/MERIDIANS); /* this many meridian strips */
	dta0 = (int)((ta1-ta0)/LATITUDES); /* and triangle pairs per strip */
	for(th=th0; th < th1; th += dth0){
	glBegin(GL_TRIANGLE_STRIP);
	for(ta = ta0 ; ta < ta1 ; ta += dta0){
		drawvert(th,ta); drawvert(th+gap*dth0,ta);}
		glEnd();
	}/* end for.theta loop */
}/* end drawtor */

/**********************************************************************/
void drawcube(void){ /* transfer from skel.c as an exercise */ }

/**********************************************************************/
void drawstart(float uu, float vv, float rad) {	
	float mat_diffuse[] = {1,1,1,0};
	GLUquadricObj *qobj = gluNewQuadric();

	GLfloat light_pos[4];
        light_pos[0]=luxx[0];  
        light_pos[1]=luxx[1];  
        light_pos[2]=luxx[2];  
        light_pos[3]= 0;

	mat_diffuse[0]=1; mat_diffuse[1]=1; mat_diffuse[2]=1; mat_diffuse[3]=0;
	glMaterialfv(GL_FRONT, GL_DIFFUSE, mat_diffuse);
	glLightfv(GL_LIGHT0, GL_POSITION, light_pos);
	glEnable(GL_LIGHTING); glEnable(GL_LIGHT0);
	
    posn(uu,vv);
	glColor3f(1,1,1);
	glPushMatrix();
		glTranslatef(pp[0], pp[1], pp[2]);
		gluSphere(qobj, rad, 8, 8);
	glPopMatrix();
	
	glDisable(GL_LIGHTING);
	glDisable(GL_BLEND);
	glDisable(GL_POINT_SMOOTH);
	glPointSize(1);
}

/**********************************************************************/
void drawlin(float al, int mark) {
	int ii,jj,kk;
	float dt =delta;
	float nw[4], po[4], vo[4];

	glColor3f(1,1,1);
	glLineWidth(5);
	glEnable(GL_BLEND);
	glEnable(GL_LINE_SMOOTH);

	uvpq[0] = ustar; uvpq[1] = vstar;
	uvpq[2] = cos(al); uvpq[3] = sin(al);

	glBegin(GL_LINE_STRIP);
	for(ii=0 ; ii< many; ii++){
		posn(uvpq[0],uvpq[1]);
        switch(mark){
        case 0: glColor3f(.04,.1,.7);break;
        case 1: glColor3f(.14,.7,.2);break;
        case 2: glColor3f(.8,.26,0);break; }
		glVertex3fv(pp);
		FOR(jj,0,4)	nw[jj]=po[jj]=uvpq[jj];
		geoflow();
		FOR(jj,0,4) vo[jj]=vecf[jj];
		FOR(kk,0,tms){
			FOR(jj,0,4) po[jj]=uvpq[jj]=nw[jj] + .5 *(vo[jj]+vecf[jj])*dt;
			geoflow(); 
		}
	} /* next i */
	glEnd();
	glDisable(GL_LINE_SMOOTH);
	glDisable(GL_BLEND);
}

/**********************************************************************/
void drawspray() {
	float al; int mk =0;
	for(al=0.; al<=360.; al+=dalpha){
		drawlin(al,0); }
}

/**********************************************************************/
void drawall(void){ 
	drawtor(); drawcube(); drawstart(ustar, vstar, gama); 
	if (spray) drawspray();
    if(lin)drawlin(alpha,1);
    if(lin)drawlin(beta,2);
}

/**********************************************************************/
void drawstars(void){ /* replace with SLevys much prettier stars */
	static float star[MANYSTARS][3]; static int virgin=1;
	if(virgin){ /* first time through set up the stars */
		FOR(ii,0,MANYSTARS){ /* in a unit cube then on unit sphere */
			FOR(jj,0,3)star[ii][jj] =(float)random()/RAND_MAX - 0.5;
			tmp=NRM(star[ii]); FOR(jj,0,3)star[ii][jj]/=tmp;
		}
		virgin=0; /* never again */
	}
	glMatrixMode(GL_MODELVIEW);
	glPushMatrix(); /* optional insurance or superstition */
	glMultMatrixf(starmat);
	glColor3f(0.8,0.9,1.0);

	glBegin(GL_POINTS);
	FOR(ii,0,MANYSTARS)glVertex3fv(star[ii]);
	glEnd();

	/* glutWireTeapot(1); if you prefer one on the firmament instead */
	glPopMatrix(); /* optional insurance or superstition */
	glClear(GL_DEPTH_BUFFER_BIT); /* put the stars at infinity */
}

/************************ steering ***********************************/
void arguments(int argc,char **argv){ /* Pat Hanrahan 1989 */
	while(--argc){
		++argv;
		if(argv[0][0]=='-')
			switch(argv[0][1]){
			case 'w': win =atoi(argv[1]); argv++; argc--; break;
			case 'g': gap0 =atof(argv[1]); argv++; argc--; break;
			case 'L': lux[0]=atof(argv[1]);
				lux[1]=atof(argv[2]);
				lux[2]=atof(argv[3]); argv +=3; argc -=3; break;
			/* surface parameters */
			case 'a' : alpha=atof(argv[1]);   /*  0. initial direction */
				beta=atof(argv[2]);   /*  0. initial direction */
				dalpha=atof(argv[3]);   /*  5. dalpha */
				argv+=3; argc-=3; break;
			case 's' : ustar=atof(argv[1]);   /*  .1 initial position */
				vstar=atof(argv[2]);   /*  .5                  */
				delta=atof(argv[3]);   /*  .01 stepsize */
				many=atoi(argv[4]);   /*  50 number of steps */
				thick=atoi(argv[5]);   /*  5 line thickness   */
				argv+=5; argc-=5; break;
			case 'u' : th0=atof(argv[1]);  /* -1. min u    */
				th1=atof(argv[2]);  /*  1. max u    */
				dth0=atof(argv[3]);  /*  .1 delta u   */
				argv+=3; argc-=3; break;
			case 'v' : ta0=atof(argv[1]);  /* -1. min v     */
				ta1=atof(argv[2]);  /*  1. max v   */
				dta0=atof(argv[3]);  /*  .1 */
				argv+=3; argc-=3; break;
			/*  miscellaneous paramaters, add them hereafter */
			case 'c' : rho=atof(argv[1]);     /*  minor axis     */
				gama=atof(argv[2]);     /*  .1 base point size */
				argv+=2;  argc-=2;  break;
			}
	}
}

/**********************************************************************/
int number, hasnumber, decimal, sign; /* globals for SLevys gadgets */

/* these are assigned in keyboard() but used by these factor fcns */
float getnumber(float dflt){ /* from keyboard, factor of bump() */
	float v = (sign ? -number : number); /* positive or negative nr */
	if(!hasnumber) return dflt; /* if no new nr use old on */
	return decimal>0 ? v/(float)decimal : v;
}

void bump(float *val, float incr){ /* SLevy 98 */
	float by = fabs(incr); /* wizard speak ... best not mess with it */
	char fmt[8], code[32];
	int digits = 1;
	if(hasnumber) {
		*val = getnumber(0);
		return;
	}
	if(by <= .003) digits = 3;
	else if(by <= .03) digits = 2;
	sprintf(fmt, "%%.%de", digits);
	sprintf(code, fmt, *val * (1 + incr));
	sscanf(code, "%f", val);
}

/********************from SLevy 2jan02 ********************************/
int getbutton(char key) {
	int uu = clefs[key & 127]; clefs[key & 127]=0; return uu;
}

/**********************************************************************/
void keyboard(unsigned char key, int x, int y){
	clefs[key&127]=1; /* globalize the keys that were pressed */
	#define IF(K) if(key==K)
	#define PRESS(K,A,b) IF(K){b;} IF(K-32){A;} /* catch upper case */
	#define TOGGLE(K,flg) IF(K){(flg) = 1-(flg); }
	#define CYCLE(K,f,m) PRESS((K),(f)=(((f)+(m)-1)%(m)),(f)=(++(f)%(m)))
	#define SLIDI(K,f,m,M) PRESS(K,(--f<m?m:f), (++f>M?M:f))
	#define SLIDF(K,f,m,M,d) PRESS(K,((f -= d)<m?m:f), ((f += d)>M?M:f))

	/* Only 127 ASCII chars are processed in this GLUT callback function */
	/* Use the specialkeybo function for the special keys */
	IF(27) { exit(0); }		/* ESC exit */
	TOGGLE('v',binoc);		/* cross-eyed STEREO */
	TOGGLE(' ',mode);		/* space key */
	TOGGLE('h',morph);		/* autotymer on/off */
	CYCLE('w',msg,3);		/* writing on/off/speedometer+bullseye */
	PRESS('n', nose -= .001 , nose += .001 );		/* for binoculars */
	PRESS('s', bump(&speed,.02), bump(&speed,-.02));/* flying speed */
	PRESS('q', bump(&torq, .02), bump(&torq, -.02));/* turning speed */
	PRESS('o', focal *= 1.1 , focal /= 1.1)			/* telephoto */
	PRESS('i', mysiz /= 1.1, mysiz *= 1.1)			/* rescale the world */
	PRESS('p', wfar *= 1.01 , wfar /= 1.01)			/* rear clipping plane */
	PRESS('z', deFault(), deFault());				/* zap changes */
	PRESS('g',gap /= .9, gap *= .9);				/* gap parameter */
	PRESS('a',amb /= .9, amb *= .9);				/* ambient fraction */
	PRESS('r',pwr /= .9, pwr *= .9);				/* pseudo-spec power */

	/* geodesics */
	IF('c') { dth= dth1; dta=dta1; }
	TOGGLE('l',lin);
	TOGGLE('y', spray);

	PRESS('x', alpha -= ddalpha, alpha += ddalpha);
	PRESS('b', beta -= ddalpha, beta += ddalpha);

	PRESS('d', delta -= .001, delta  += .001);
	PRESS('f', {dta = (ta1-ta0)/123.; dth =rho*dta;}, {dth=dth0;dta=dta0;});
	PRESS('e', gama -= .01, gama += .01);
	PRESS('m', {if(many>dmany) many -= dmany;}, many += dmany);
	PRESS('k', rho -= .01, rho += .01);
	PRESS('t', bend = 2, bend = (++bend)%8)
	PRESS('u', tms =1, tms = (tms==mxitr)?mxitr:tms++);

	/********** SLevys parser creates the input decimal ******************/
	if(key >= '0' && key <= '9'){ /* if key is a digit numeral */
		hasnumber = 1; number = number*10+key-'0'; decimal *= 10; }
	else if(key == '.') { decimal = 1; } /* its a decimal ! */
	else if(key == '-') { sign = -1; } /* its negative ! */
	else { hasnumber = number = decimal = sign = 0;} /* erase mess */
	glutPostRedisplay(); /* in case window was resized */
}

/**********************************************************************/
void specialkeybo(int key, int x, int y){
	clefs[0]= key ;
	switch(key){ /* HOME END PAGE_DOWN RIGHT F1 etc see glut.h */
	case GLUT_KEY_F1: th0++; th1--; break;
	case GLUT_KEY_F2: th0--; th1++; break;
	/*default: fprintf(stderr,"nonASCII char [%d] was pressed.\n", key);*/
	}
}

/**********************************************************************/
#if 0 
float speedometer(void){ /* this one is for win32*/
	double dbl; static double rate; static int ii=0;
	static struct _timeb lnow, lthen;
	if(++ii % 8 == 0){ /* 8 times around measure time */
		_ftime(&lnow);
		dbl = (double)(lnow.time - lthen.time)
		+(double)(lnow.millitm - lthen.millitm)/1000;
		lthen = lnow; rate = 8/dbl;
	}
	return((float)rate);
}
#endif
/**********************************************************************/
float speedometer(void){                    /* this one is for unix */
double dbl; static double rate; static int ii=0;
static struct timezone notused; static struct timeval now, then;
   if(++ii % 8 == 0){  /* 8 times around measure time */
      gettimeofday(&now, &notused); /* elapsed time */
      dbl =  (double)(now.tv_sec - then.tv_sec)
         +(double)(now.tv_usec - then.tv_usec)/1000000;
      then = now;  rate = 8/dbl;
      }
   return((float)rate);
}

/**********************************************************************/
void char2wall(float x,float y,float z, char buf[]){
	char *p; glRasterPos3f(x,y,z);
	for(p = buf;*p;p++) glutBitmapCharacter(GLUT_BITMAP_9_BY_15,*p);
}

/**********************************************************************/
void messages(void){char buf[256];
	/* console messages are done differently from cave */
	#define LABEL(x,y,W,u) {sprintf(buf,(W),(u));char2wall(x,y,0.,buf);}

	glMatrixMode(GL_PROJECTION); glPushMatrix(); /* new projection matrix */
	glLoadIdentity(); gluOrtho2D(0,3000,0,3000); /* new 2D coordinates */
	glMatrixMode(GL_MODELVIEW); glPushMatrix(); glLoadIdentity();

	if(mode==TURNMODE) glColor3f(1.,0.,1.); else glColor3f(1.,1.,0.);
	LABEL(1500,1500,"%s","o"); /* place a bullseye dead center */
	LABEL(80,80,"%4.1f fps",speedometer());
	if(msg==2)return; 
	LABEL(80,2840,\
	"(ESC)ape (V)Binoc (MAUS2)Fore (BAR)%s (H)omotopy (W)riting",
	mode?"TURNMODE":"FLYMODE");
	LABEL(10,10,"illiSkel-2002 by Francis, Levy, Bourd, Hartman,\
	& Chappell, U Illinois, 1995..2002 %s","");
	LABEL(80,2770,"(N)ose %0.3f",nose);
	LABEL(80,2700,"[S]peed %0.4f",speed);
	LABEL(80,2630," tor[Q] %0.4f",torq);
	LABEL(80,2560,"near clipper %g", mysiz*focal);
	LABEL(80,2490,"f(O)cal factor %g",focal);
	LABEL(80,2420,"my s(I)ze %.2g",mysiz);
	LABEL(80,2350,"far cli(P)per= %.2g",wfar);
	LABEL(80,2280,"(Z)ap %s","");
	LABEL(80,2210,"(G)ap %.2g",gap);
	LABEL(80,2140,"(A)mb %.2g",amb);
	LABEL(80,2070,"pw(R) %.2g",pwr);
	LABEL(80,2000,"(L)ine (Y)Spray",lin);
	LABEL(80,1930,"(X)alpha %.4f",alpha);
	LABEL(80,1860,"(B)beta %.4f",beta);
	LABEL(80,1790,"[D]elta %.4f",delta);
	LABEL(80,1720,"(E)gama %.4f",gama);
	LABEL(80,1650,"[M]any steps %d",many);
	LABEL(80,1580,"(K)rho %.2g",rho);

	glPopMatrix();
	glMatrixMode(GL_PROJECTION); glPopMatrix();
}

/************************ navigation **********************************/
void chaptrack(int paw,int xx,int yy,int shif){/* Glenn Chappell 1992 */
	long dx,dy;

	dx = xx -.5*xwide; dx = abs(dx)>5?dx:0; /* 5 pixel latency */
	dy = yy -.5*yhigh; dy = abs(dy)>5?dy:0;
	glMatrixMode(GL_MODELVIEW); glPushMatrix(); glLoadIdentity();

	if(mode==TURNMODE) glTranslatef(aff[12],aff[13],aff[14]);
	glRotatef(dx*torq,0.,1.,0.); glRotatef(dy*torq,1.,0.,0.);
	if(paw&(1<<GLUT_RIGHT_BUTTON ))glRotatef(shif?-10:-1,0.,0.,1.);
	if(paw&(1<<GLUT_LEFT_BUTTON ))glRotatef(shif?10:1,0.,0.,1.);
	if(mode==FLYMODE){
		glPushMatrix();
		glMultMatrixf(starmat);
		glGetFloatv(GL_MODELVIEW_MATRIX,starmat);
		glPopMatrix();
	}

	if(paw&(1<<GLUT_MIDDLE_BUTTON))glTranslatef(0.,0.,shif?-speed:speed);
	if(clefs[0]==GLUT_KEY_UP) glTranslatef(0.,0., speed);
	if(clefs[0]==GLUT_KEY_DOWN) glTranslatef(0.,0., -speed);
	if(clefs[0]==GLUT_KEY_LEFT) glTranslatef(-speed,0.,0.);
	if(clefs[0]==GLUT_KEY_RIGHT) glTranslatef(speed,0.,0.);
	if(clefs[0]==GLUT_KEY_PAGE_UP) glTranslatef(0., speed,0.);
	if(clefs[0]==GLUT_KEY_PAGE_DOWN) glTranslatef(0.,-speed,0.);
	if(mode==TURNMODE) glTranslatef(-aff[12],-aff[13],-aff[14]);

	glMultMatrixf(aff);
	glGetFloatv(GL_MODELVIEW_MATRIX,aff);
	FOR(ii,0,3){luxx[ii]=0; FOR(jj,0,3)luxx[ii] +=aff[ii*4+jj]*lux[jj];}
	glPopMatrix();
}

/************************* scenery ************************************/
void reshaped(int xx, int yy){xwide=xx ; yhigh=yy;} /*win width,height*/

/**********************************************************************/
void drawcons(void){
	float asp =(float)xwide/yhigh; /* aspect ratio */
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	glClearColor(0,0,0,0); /* base color, try (.1,.2,.3,0.) */
	if(binoc) glViewport(0,yhigh/4,xwide/2,yhigh/2);
	glMatrixMode(GL_PROJECTION); glLoadIdentity();
	glFrustum(-mysiz*asp,mysiz*asp,-mysiz,mysiz,mysiz*focal,wfar);
	glMatrixMode(GL_MODELVIEW); glLoadIdentity();
	drawstars();
	glTranslatef(-binoc*nose,0.0,0.0);
	glMultMatrixf(aff);
	drawall();
	if(binoc){
		glViewport(xwide/2,yhigh/4,xwide/2,yhigh/2);
		glMatrixMode(GL_MODELVIEW);
		glLoadIdentity();
		drawstars();
		glTranslatef(binoc*nose,0.0,0.0);
		glMultMatrixf(aff);
		drawall();
	}
	glViewport(0,0,xwide,yhigh);
	if(msg) messages();
	glutSwapBuffers();
}

/************************** steering **********************************/
void idle(void){ /* do this when nothing else is happening */
	if(morph) autotymer(0); /* advance autotymer */
	glutPostRedisplay(); /* redraw the window */
	IFCLICK('=',chaptrack(PAW,XX,YY,SHIF);) /* bypass navigation */
	glDisable(GL_DEPTH_TEST); /* bypass depth buffer */
	IFCLICK('-',glEnable(GL_DEPTH_TEST); ) /* bypass depth buffer */
}

/**********************************************************************/
void mousepushed(int but,int stat,int x,int y){
	if(stat==GLUT_DOWN) PAW |= (1<<but); /*key came down and called back*/
	else PAW &= (-1 ^ (1<<but)); /* on the wayup erase flag*/
	XX=x; YY=y; /* position in window coordinates (pos integers) */
	SHIF=(glutGetModifiers()==GLUT_ACTIVE_SHIFT)?1:0; /* shift down too*/
}

/**********************************************************************/
void mousemoved(int x,int y){ XX=x; YY=y; }

/***************** one ring to rule the all ***************************/
int main(int argc, char **argv){
	arguments(argc,argv); /* from the commandline */
	deFault(); /* values of control parameters */
	glutInit(&argc, argv);
	glutInitDisplayMode(GLUT_DOUBLE|GLUT_DEPTH);

	switch(win){
	case 0: break; /* manage your own window */
	case 1: glutInitWindowSize(640, 480);
	glutInitWindowPosition(100,100); break;
	case 2: glutInitWindowPosition(0,0); break;
	}

	glutCreateWindow("<* illiSkel 2002 in C/OpenGL/GLUT *>");
	if(win==2) glutFullScreen();
	glEnable(GL_DEPTH_TEST); /* enable z-buffer */
	glutDisplayFunc(drawcons);

	/* the following are optional for interactive control */
	glutKeyboardFunc(keyboard);
	glutSpecialFunc(specialkeybo);
	glutMouseFunc(mousepushed);
	glutMotionFunc(mousemoved);
	glutPassiveMotionFunc(mousemoved);

	/* beyond here all are needed */
	glutReshapeFunc(reshaped);
	glutIdleFunc(idle);
	glutMainLoop();
}
