#define WIN    
//#define UNIX
/*****************************2002*************************************/
/**** skel.cpp = C++ reorganization of...                          ****/
/****       skel.c = OpenSkelGlut.c = Noosh97 with CAVE removed    ****/
/****      (C) 1994--2002 Board of Trustees University of Illinois ****/ 
/****      A Model Real-Time Interactive  C++/OpenGL/GLUT  Animator****/
/****    George Francis, Stuart Levy, Glenn Chappell, Chris Hartman****/
/****    e-mail  gfrancis@math.uiuc.edu : revised 3apr02 by mjw    ****/
/**********************************************************************/
#include <vector>
using std::vector;
using std::pair;
#include <stdlib.h>
#include <stdio.h>
#include <GL/glut.h>  /*#include <gl\glut.h>  */ 
#ifdef WIN
#include <sys\timeb.h> /* #include <sys/timeb.h>  */
#endif
#ifdef UNIX
#include <sys/time.h> /* #include <sys/timeb.h>  */
#endif

#include <math.h>
#pragma warning (disable:4305)       /* constant double-to-float  */

//formerly macros, now typesafe!
template<class TT> inline TT MAX(TT x, TT y){return ((x)<(y))?(y):(x);}
template<class TT> inline TT MIN(TT x, TT y){return ((x)<(y))?(x):(y);}
template<class TT> inline TT CLAMP(TT x, TT u, TT v)
  {return (x<u? u : (x>v ? v: x));}
template<class TT> inline TT ABS(TT u){return ((u)<0 ? -(u): (u));}

//this one is beyond help
#define  FOR(a,b,c)       for((a)=(b);(a)<(c);(a)++)

template<class TT> inline TT DOT(TT* p, TT* q)
  {return((p)[0]*(q)[0]+(p)[1]*(q)[1]+(p)[2]*(q)[2]);}
template<class TT> inline TT NRM(TT* p) {return sqrt(DOT((p),(p)));}
template<class TT> inline void LCPY(TT* u, TT* v)
  {v[0]=u[0]; v[1]=u[1]; v[2]=u[2];}

//We have our own pi, thank you very much!
#ifdef M_PI
#undef M_PI
#endif
const double M_PI = 355.0/113.0;
const double DG = M_PI/180.0;
inline double S(double degrees){return sin(degrees*DG);}
inline double C(double degrees){return cos(degrees*DG);}
#ifdef WIN 
#define  random        rand        /* library dependent name  */
#endif
#define IFCLICK(K,a){static int ff=1; if(getbutton(K))ff=1-ff; if(ff){a} }
const int MANYSTARS=10000;




/************************** global variables **************************/
int win=1;                 /* used once to choose window size         */
double mysiz,speed, torq, focal, wfar; /* navigation control variables */
unsigned int PAW,XX,YY,SHIF;  /* used in chaptrack gluttery           */ 
int xwide,yhigh;                /* viewportery width and height       */
int mode,morph,msg,binoc;       /* viewing globals */
#define FLYMODE  (0)         /* yellow: turns around head as center   */ 
#define TURNMODE (1)         /* purple: turns around object center    */ 
//int ii, jj, kk;  float tmp, temp;     /* **causes** gray hairs later  */
GLfloat aff[16], starmat[16], mat[16];   /* OpenGL placement matrices   */ 
double nose;                       /* to eye distance in console       */
char clefs[128];                  /* which keys were pressed last     */
/*********************** steering *************************************/
/*************************** scenery **********************************/





























/**********************************************************************
 * IlliLuminator 
 * illiLight plus illiPaint.
 * Illumination brings light and color.
 **********************************************************************/
class IlliLuminator
{
  public:
  IlliLuminator();
  void initialize(double amb, double pwr, double lux[3]);
  void increasePwr(double multiple);
  void increaseAmb(double multiple);
  void setLux(double newlux[3]);
  double getAmb();
  double getPwr();

/**********************************************************************
 * transformLux
 * multiply the lux vector by the affine matrix to get the luxx 
 * vector
 **********************************************************************/
  void transformLux(GLfloat aff[16])
  {
    for(int ii=0; ii<3; ii++)
    {
      luxx[ii]=0;
      for(int jj=0; jj<3; jj++)
      {
        luxx[ii] += aff[ii*4+jj]*lux[jj];
      }
    }
  }

/**********************************************************************
 * illuminate maps a normal plus cat and dog to an rgb triple.
 **********************************************************************/
void illuminate(double nn[3], double cat, double dog, GLfloat  rgb[3])
{
  double lmb, spec;
  /* illiLight by Ray Idaszak 1989 uses max{amb*lmb, rgb*lmb, spec}   */ 
  lmb = DOT(nn,luxx); lmb =(lmb<0 ? .2 : lmb); lmb = MAX(amb, lmb); 
  spec = CLAMP((1.1 - pwr+pwr*lmb), 0., 1.);  
  /* illiPaint by Chris Hartman 1993 maps R2(cat,dog)->R3(r,g,b)      */ 
  rgb[0] =  MAX(spec, lmb*dog);
  rgb[1] =  MAX(spec, lmb*(.25 + ABS(cat -.5)));
  rgb[2] =  MAX(spec, lmb*(1 - cat));
}

  private:
  double amb, pwr;
  double lux[3];	/* world light  unit (mostly)  vector    */
  double luxx[3];       /* object space  direction vector  */
};

IlliLuminator::IlliLuminator()
{
  double initialux[3]={1.0, 2.0, 3.0};
  initialize(0.3, 10.0, initialux);
}

void IlliLuminator::setLux(double newlux[3])
{
  LCPY(newlux, lux);

  // normalize light vector
  double magnitude=NRM(lux);
  for(int ii=0;ii<3;ii++)lux[ii] /= magnitude;  

  LCPY(lux, luxx);
}

void IlliLuminator::initialize(double amb, double pwr, double lux[3])
{
  this->amb = amb; 
  this->pwr = pwr;
  setLux(lux);
}

void IlliLuminator::increasePwr(double multiple)
{
  pwr*=multiple;
}

void IlliLuminator::increaseAmb(double multiple)
{
  amb*=multiple;
}

double IlliLuminator::getAmb(){return amb;}
double IlliLuminator::getPwr(){return pwr;}

IlliLuminator illuminator;







/**********************************************************************
 * IlliTorus class definition
 * The venerable torus, with its infamous cat-and-dogging.
 **********************************************************************/
class IlliTorus
{
  public:
  IlliTorus();
  void initialize();
  void draw();
  void increaseSmallSweep(int increment);
  void increaseGreatSweep(int increment);
  void grow();
  void shrink();
  void increaseGap(double multiple);
  double getGap();
  void setDefaultGap(double gapSize);

  private:
  void drawVertex(int th, int ta);

  //arrays are passed by reference, so this function puts the normal into nn
  void getNormal(int th, int ta, double nn[3])
  {
    /* radius of unit sphere is also unit normal to the torus           */
    nn[0] = C(th)*C(ta);
    nn[1] = S(th)*C(ta);
    nn[2] =       S(ta);
  }
  int th0, th1; //starting and ending meridians
  int ta0, ta1; //starting and ending latitudes
  int dth, dta;
  double gap;
  double gap0;
//  static const int meridians=32;
   const int meridians;
// static const int latitudes=32;
   const int latitudes;
};

/**********************************************************************
 * IlliTorus method definitions
 **********************************************************************/
IlliTorus::IlliTorus(): meridians(32), latitudes(32) {initialize();} 
//this is the boa constructor initializing the meridians/latitudes

void IlliTorus::initialize()
{
  //these numbers are angles in degrees
  th0=5; th1=355; 
  ta0=5; ta1=355;
  dth=(th1-th0)/meridians; dta=(ta1-ta0)/latitudes;

  //this is the space between meridian strips
  gap=gap0=1.0;
}

/**********************************************************************
 * small sweep is the arc of the small circle 
 * great sweep is the arc of the large circle
 * increment is applied to both ends of the arc
 **********************************************************************/
void IlliTorus::increaseSmallSweep(int increment)
{
  ta0-=increment;
  ta1+=increment;
  dta = (int)((ta1-ta0)/latitudes);  //increment in degrees
}

void IlliTorus::increaseGreatSweep(int increment)
{
  th0-=increment;
  th1+=increment;
  dth = (int)((th1-th0)/meridians);  //increment in degrees
}

void IlliTorus::grow()
{
  increaseSmallSweep(1); increaseGreatSweep(1);
}

void IlliTorus::shrink()
{
  increaseSmallSweep(-1); increaseGreatSweep(-1);
}

void IlliTorus::increaseGap(double multiple) { gap*=multiple; }
void IlliTorus::setDefaultGap(double gapSize) { gap0=gapSize; }
double IlliTorus::getGap(){return gap;}

/**********************************************************************
 * IlliTorus::draw
 * The functionality of drawtor packaged in a member function:
 * This method draws a torus.
 **********************************************************************/
void IlliTorus::draw()
{
  //th for the big circle, ta for the small one.  both in degrees
  int th=0, ta=0;

  if(dth==0 || dta==0){return;}

  for(th=th0; th < th1; th += dth){
   glBegin(GL_TRIANGLE_STRIP);
     for(ta = ta0 ; ta < ta1 ; ta += dta ){
         drawVertex(th,ta); drawVertex(int(th+gap*dth),ta);}
   glEnd();
  }/* end for.theta loop */
}

/**********************************************************************
 * IlliTorus::drawVertex
 * drawvert repackaged as a member function.  
 * Lights and draws a vertex of the torus
 **********************************************************************/
void IlliTorus::drawVertex(int th, int ta)
{
  double  nn[3], dog, cat;
  GLfloat  rgb[3];

  getNormal(th, ta, nn);	//normal goes in nn

  //dog and cat are for IlliPaint
  dog = (ta-ta0)/(double)(ta1-ta0); cat = (th-th0)/(double)(th1-th0);

  //put color into rgb
  illuminator.illuminate(nn, cat, dog, rgb);

  //set color
  glColor3fv(rgb);

  /* torus has unit small diameter and unit big radius                */
  glVertex3f( C(th) + .5*nn[0],
              S(th) + .5*nn[1],
                0   + .5*nn[2]);
} /* end drawvert */
IlliTorus torus;

/**********************************************************************
 * class AutoThymer
 * The savory (sorry, I couldn't resist) 
 * alternative to autotymer.  Each autothymer object is
 * a program for an animation.  The advance method tells it to 
 * move itself one step further in the animation.
 * marionette is the object whose strings will be pulled.
 **********************************************************************/
template <class TT>
class AutoThymer
{
  public:
  AutoThymer(TT& initMarionette);
  void addStep(void (TT::*fptr)(), int repetitions);
  void advance();
  void reset();

  private:
  TT& marionette;
  vector<pair<void (TT:: * )(), int> > commands;
  void (TT::*fptr)();
  int count;
  int max;
  int currentCommand;
};

template <class TT>
void AutoThymer<TT>::advance()
{
  if(commands.size() == 0) { return; }

  if(count >= max)
  {
    //switch to next command in sequence
    currentCommand++;
    currentCommand %= commands.size();
    fptr=commands[currentCommand].first;
    max=commands[currentCommand].second;
    count=0;
  }

  if(fptr)
  { 
    //execute command if it exists, otherwise rest
    (marionette.*fptr)();
  }
  count++;

}

template <class TT>
AutoThymer<TT>::AutoThymer(TT& marionette) : 
  marionette(marionette), count(0), currentCommand(0), fptr(0)
{max=0;}

/**********************************************************************
 * addStep adds a step to the sequence.  
 * if you want a pause,
 * pass it 0 instead of a function
 **********************************************************************/
template <class TT>
void AutoThymer<TT>::addStep(void (TT::*fptr)(), int repetitions)
{
  commands.push_back(pair<void (TT::*)(), int>(fptr, repetitions));
  //whenever a step is added, the animation is reset
  count=0;
  this->fptr = commands[0].first;
  max=commands[0].second;
}

template <class TT>
void AutoThymer<TT>::reset()
{
  count=0;
  max=0;
  currentCommand=0;
  fptr=0;
}

AutoThymer<IlliTorus> thymer(torus);

/**********************************************************************/
void deFault(void){         /* (Z)ap also restores these assignments  */ 
  torus.initialize();
  msg=1; binoc=0; nose=.06; mode=TURNMODE;       /* gadget parameters */   
  speed=.02; torq=.02; focal = 2.; wfar=13; mysiz=.01; morph=0; 
  for(int ii=0; ii<16; ii++) 
    {starmat[ii]=aff[ii] = (ii/4==ii%4);}        /* identity matrix */ 
  double initialux[3]={1.0,2.0,3.0};		 /* light vector */
  illuminator.initialize(0.3, 10.0, initialux);  /* lighting params   */
  aff[12]=0; aff[13]= 0; aff[14]= -4.2; /* place where we can see it  */
  
  thymer.reset();
  thymer.addStep(&(IlliTorus::shrink), 150);
  thymer.addStep(0, 20);	//pause for a 20 count
  thymer.addStep(&(IlliTorus::grow), 150);
  thymer.addStep(0, 30);	//pause for a 30 count
}

/**********************************************************************/
void drawcube(void){ /* transfer from skel.c as an exercise  */ }
/**********************************************************************/
void drawall(void){ torus.draw(); drawcube();}
/**********************************************************************/
void drawstars(void){  /* replace with SLevy's much prettier stars    */ 
  int ii,jj;
  double tmp;
  static GLfloat star[MANYSTARS][3]; static int virgin=1;
  if(virgin){             /* first time through set up the stars      */
     FOR(ii,0,MANYSTARS){ /* in a unit cube then  on unit sphere      */
       FOR(jj,0,3)star[ii][jj]  =(double)random()/RAND_MAX - 0.5;
       tmp=NRM(star[ii]); FOR(jj,0,3)star[ii][jj]/=tmp;        
     }
   virgin=0; /* never again */
  }
  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();           /* optional insurance or superstition    */ 
    glMultMatrixf(starmat);
    glColor3f(0.8,0.9,1.0);        
    glBegin(GL_POINTS); 
      FOR(ii,0,MANYSTARS)glVertex3fv(star[ii]); 
    glEnd();
  /* glutWireTeapot(1);  if you prefer one on the firmament instead  */ 
  glPopMatrix();            /* optional insurance or superstition    */
  glClear(GL_DEPTH_BUFFER_BIT); /* put the stars at infinity         */ 
}
/************************ steering ***********************************/
void arguments(int argc,char **argv){           /* Pat Hanrahan 1989 */
      while(--argc){++argv; if(argv[0][0]=='-')switch(argv[0][1]){
      case 'w': win =atoi(argv[1]); argv++; argc--; break; 
      case 'g': torus.setDefaultGap(atof(argv[1])); argv++; argc--; break;
      case 'L': 
		double initialux[3];
		initialux[0]=atof(argv[1]);
                initialux[1]=atof(argv[2]);
                initialux[2]=atof(argv[3]); 
		illuminator.setLux(initialux);
		argv +=3; argc -=3; break;
   }}}
/**********************************************************************/
int number, hasnumber, decimal, sign;  /* globals for SLevy's gadgets */
   /* these are assigned in keyboard() but used by these factor fcns  */  
double getnumber(double dflt){    /*  from keyboard, factor of bump()   */ 
     double v = (sign ? -number : number);  /* positive or negative nr */
     if(!hasnumber) return dflt;       /* if no new nr use old on     */ 
     return decimal>0 ? v/(double)decimal : v;
}
void bump(double *val, double incr){          /* SLevy 98 */
  double by = fabs(incr);   /* wizard speak ... best not mess with it  */ 
  char fmt[8], code[32];
  int digits = 1;
  if(hasnumber) {
    *val = getnumber(0);
    return;
  }
  if(by <= .003) digits = 3;
  else if(by <= .03) digits = 2;
  sprintf(fmt, "%%.%de", digits);
  sprintf(code, fmt, *val * (1 + incr));
  sscanf(code, "%lf", val);
}
/********************from SLevy 2jan02 ********************************/
int getbutton(char key) { 
    int uu = clefs[key & 127]; clefs[key & 127]=0; return uu;
}
/**********************************************************************/
void keyboard(unsigned char key, int x, int y){
   clefs[key&127]=1;  /* globalize the keys that were pressed         */ 
#define  IF(K)            if(key==K)  
#define  PRESS(K,A,b)     IF(K){b;} IF(K-32){A;}  /* catch upper case */
#define  TOGGLE(K,flg)    IF(K){(flg) = 1-(flg); }
#define  CYCLE(K,f,m)   PRESS((K),(f)=(((f)+(m)-1)%(m)),(f)=(++(f)%(m)))
#define  SLIDI(K,f,m,M)   PRESS(K,(--f<m?m:f), (++f>M?M:f)) 
#define  SLIDF(K,f,m,M,d) PRESS(K,((f -= d)<m?m:f), ((f += d)>M?M:f))
/* Only 127 ASCII chars are processed in this GLUT callback function  */ 
/* Use the specialkeybo function for the special keys                 */ 
   IF(27) { exit(0); }                           /* ESC exit          */
   TOGGLE('v',binoc);                            /* cross-eyed STEREO */
   TOGGLE(' ',mode);                             /* space key         */
   TOGGLE('h',morph);                            /* autotymer on/off  */
   CYCLE('w',msg,3);           /* writing on/off/speedometer+bullseye */
   PRESS('n', nose -= .001 , nose += .001 );     /* for binoculars    */
   PRESS('s', bump(&speed,.02), bump(&speed,-.02));/* flying speed    */ 
   PRESS('q', bump(&torq, .02), bump(&torq, -.02)); /* turning speed  */
   PRESS('o', focal *= 1.1 , focal /= 1.1)       /* telephoto         */
   PRESS('i', mysiz /= 1.1, mysiz *= 1.1)        /* rescale the world */
   PRESS('p', wfar *= 1.01 , wfar   /= 1.01)   /* rear clipping plane */
   PRESS('z', deFault(), deFault());             /* zap changes       */
   if(key=='g'){torus.increaseGap(0.9);}
   if(key=='G'){torus.increaseGap(1.0/0.9);}
   if(key=='a'){illuminator.increaseAmb(1.0/0.9);}
   if(key=='A'){illuminator.increaseAmb(0.9);}
   if(key=='r'){illuminator.increasePwr(0.9);}
   if(key=='R'){illuminator.increasePwr(1.0/0.9);}
//   PRESS('a',amb /= .9, amb *= .9);             /* ambient fraction   */
//   PRESS('r',pwr /= .9, pwr *= .9);             /* pseudo-spec power  */
/********** SLevy's parser creates the input decimal ******************/
   if(key >= '0' && key <= '9'){         /* if key is a digit numeral */
          hasnumber = 1; number = number*10+key-'0'; decimal *= 10; } 
   else if(key == '.') { decimal = 1; }  /* it's a decimal !          */
   else if(key == '-') { sign = -1; }    /* it's negative  !          */
   else { hasnumber = number = decimal = sign = 0;} /* erase mess     */
   glutPostRedisplay();                 /* in case window was resized */
}
/**********************************************************************/
void specialkeybo(int key, int x, int y){
  clefs[0]= key ;
  switch(key){    /*  HOME END PAGE_DOWN RIGHT F1 etc  see glut.h    */
  case GLUT_KEY_F1:  torus.increaseGreatSweep(-1); break;
  case GLUT_KEY_F2:  torus.increaseGreatSweep( 1); break;
  /* default: fprintf(stderr,"non-ASCII char [%d] pressed.\n", key); */
  }
  hasnumber=number=decimal=0; glutPostRedisplay();
}
/**********************************************************************/
#ifdef WIN 
float speedometer(void){                      /* this one is for win32*/ 
  double dbl; static double rate; static int ii=0;
  static struct _timeb lnow, lthen;
    if(++ii % 8 == 0){                 /* 8 times around measure time */
	   _ftime(&lnow);
		dbl =  (double)(lnow.time - lthen.time)
			 +(double)(lnow.millitm - lthen.millitm)/1000;
		lthen = lnow;  rate = 8/dbl;
      }
    return((float)rate);
}
#endif
#ifdef UNIX
double speedometer(void){                    /* this one is for unix */
double dbl; static double rate; static int ii=0;
static struct timezone notused; static struct timeval now, then;
   if(++ii % 8 == 0){  /* 8 times around measure time */
      gettimeofday(&now, &notused); /* elapsed time */
      dbl =  (double)(now.tv_sec - then.tv_sec)
         +(double)(now.tv_usec - then.tv_usec)/1000000;
      then = now;  rate = 8/dbl;
      }
   return((double)rate);
}
#endif
/**********************************************************************/
void char2wall(double x,double y,double z, char buf[]){
     char *p; glRasterPos3f(x,y,z);
     for(p = buf;*p;p++) glutBitmapCharacter(GLUT_BITMAP_9_BY_15,*p);
}
/**********************************************************************/
void messages(void){char buf[256]; 
  /* console messages are done differently from cave */
#define  LABEL(x,y,W,u) {sprintf(buf,(W),(u));char2wall(x,y,0.,buf);}
  glMatrixMode(GL_PROJECTION); glPushMatrix();  /* new projection matrix */
  glLoadIdentity(); gluOrtho2D(0,3000,0,3000);  /* new 2D coordinates */
  glMatrixMode(GL_MODELVIEW); glPushMatrix(); glLoadIdentity();
      if(mode==TURNMODE) glColor3f(1.,0.,1.); else glColor3f(1.,1.,0.);
      LABEL(1500,1500,"%s","o"); /* place a bullseye dead center */
      LABEL(80,80,"%4.1f fps",speedometer());
      if(msg!=2){              /* bypass the graffiti */
      LABEL(80,2840,\
      "(ESC)ape (V)Binoc (MAUS2)Fore (BAR)%s (H)omotopy (W)riting",
             mode?"TURNMODE":"FLYMODE");
      LABEL(10,10,"illiSkel-2002 by Francis, Levy, Bourd, Hartman,\
& Chappell, U Illinois, 1995..2002 %s","14jan02");
      LABEL(80,2770,"(N)ose   %0.3f",nose);
      LABEL(80,2700,"[S]peed  %0.4f",speed);
      LABEL(80,2630," tor[Q] %0.4f",torq);
      LABEL(80,2560,"near clipper %g", mysiz*focal);
      LABEL(80,2490,"f(O)cal factor %g",focal);
      LABEL(80,2420,"my s(I)ze %.2g",mysiz);
      LABEL(80,2350,"far cli(P)per= %.2g",wfar); 
      LABEL(80,2280,"(Z)ap %s","");
      LABEL(80,2210,"(G)ap %.2lg",torus.getGap());
      LABEL(80,2140,"(A)mb %.2g",illuminator.getAmb());
      LABEL(80,2070,"pw(R) %.2g",illuminator.getPwr());
    } /* end bypass*/ 
    glPopMatrix();
    glMatrixMode(GL_PROJECTION); glPopMatrix();
} 
/************************ navigation **********************************/
void chaptrack(int paw,int xx,int yy,int shif){/* Glenn Chappell 1992 */
   long dx,dy; 
   dx = xx -.5*xwide; dx = abs(dx)>5?dx:0;        /* 5 pixel latency  */
   dy = yy -.5*yhigh; dy = abs(dy)>5?dy:0; 
   glMatrixMode(GL_MODELVIEW); glPushMatrix(); glLoadIdentity();
   if(mode==TURNMODE) glTranslatef(aff[12],aff[13],aff[14]);
   glRotatef(dx*torq,0.,1.,0.); glRotatef(dy*torq,1.,0.,0.);
   if(paw&(1<<GLUT_RIGHT_BUTTON ))glRotatef(shif?-10:-1,0.,0.,1.);
   if(paw&(1<<GLUT_LEFT_BUTTON  ))glRotatef(shif?10:1,0.,0.,1.);
   if(mode==FLYMODE){
      glPushMatrix();
      glMultMatrixf(starmat);
      glGetFloatv(GL_MODELVIEW_MATRIX,starmat);
      glPopMatrix(); }
   if(paw&(1<<GLUT_MIDDLE_BUTTON))glTranslatef(0.,0.,shif?-speed:speed);
   if(clefs[0]==GLUT_KEY_UP) glTranslatef(0.,0., speed);
   if(clefs[0]==GLUT_KEY_DOWN) glTranslatef(0.,0., -speed);
   if(clefs[0]==GLUT_KEY_LEFT) glTranslatef(-speed,0.,0.);
   if(clefs[0]==GLUT_KEY_RIGHT) glTranslatef(speed,0.,0.);
   if(clefs[0]==GLUT_KEY_PAGE_UP) glTranslatef(0., speed,0.);
   if(clefs[0]==GLUT_KEY_PAGE_DOWN) glTranslatef(0.,-speed,0.);
   if(mode==TURNMODE) glTranslatef(-aff[12],-aff[13],-aff[14]);
   glMultMatrixf(aff); 
   glGetFloatv(GL_MODELVIEW_MATRIX,aff);
   int ii=0, jj=0;
   illuminator.transformLux(aff);
   glPopMatrix();
}
/************************* scenery ************************************/
void reshaped(int xx, int yy){xwide=xx ; yhigh=yy;} /*win width,height*/
/**********************************************************************/
void drawcons(void){ double asp =(double)xwide/yhigh; /* aspect ratio   */
  glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT); 
  glClearColor(0,0,0,0);   /* base color, try (.1,.2,.3,0.)           */  
  if(binoc) glViewport(0,yhigh/4,xwide/2,yhigh/2);
  glMatrixMode(GL_PROJECTION); glLoadIdentity();
  glFrustum(-mysiz*asp,mysiz*asp,-mysiz,mysiz,mysiz*focal,wfar); 
  glMatrixMode(GL_MODELVIEW); glLoadIdentity();
  drawstars();
  glTranslatef(-binoc*nose,0.0,0.0);
  glMultMatrixf(aff);
  drawall();
  if(binoc){
      glViewport(xwide/2,yhigh/4,xwide/2,yhigh/2); 
      glMatrixMode(GL_MODELVIEW);
      glLoadIdentity();
      drawstars();
      glTranslatef(binoc*nose,0.0,0.0);
      glMultMatrixf(aff);
      drawall();
    }
  glViewport(0,0,xwide,yhigh);
  if(msg) messages(); 
  glutSwapBuffers();
}
/************************** steering **********************************/
void idle(void){            /* do this when nothing else is happening */
//   if(morph) autotymer(0);                       /* advance autotymer */ 
   if(morph) thymer.advance();
   glutPostRedisplay();                          /* redraw the window */
   IFCLICK('=',chaptrack(PAW,XX,YY,SHIF);)       /* bypass navigation */
   glDisable(GL_DEPTH_TEST);                   /* bypass depth buffer */ 
   IFCLICK('-',glEnable(GL_DEPTH_TEST); )      /* bypass depth buffer */
}
/**********************************************************************/
void mousepushed(int but,int stat,int x,int y){
  if(stat==GLUT_DOWN) PAW |= (1<<but); /*key came down and called back*/
  else PAW &= (-1 ^ (1<<but));              /* on the wayup erase flag*/ 
  XX=x; YY=y;        /* position in window coordinates (pos integers) */ 
  SHIF=(glutGetModifiers()==GLUT_ACTIVE_SHIFT)?1:0;  /* shift down too*/
}
/**********************************************************************/
void mousemoved(int x,int y){ XX=x; YY=y; }
/***************** one ring to rule the all ***************************/
int main(int argc, char **argv){  
   arguments(argc,argv);                      /* from the commandline */
   deFault();                         /* values of control parameters */
       glutInit(&argc, argv);  
       glutInitDisplayMode(GLUT_DOUBLE|GLUT_DEPTH);
       switch(win){ 
           case 0: break;                   /* manage your own window */
           case 1: glutInitWindowSize(640, 480);
                   glutInitWindowPosition(100,100); break;
           case 2: glutInitWindowPosition(0,0); break;
         }
       glutCreateWindow("<* illiSkel 2002 in C/OpenGL/GLUT *>");
       if(win==2) glutFullScreen();
       glEnable(GL_DEPTH_TEST);                    /* enable z-buffer */
       glutDisplayFunc(drawcons); 
               /* the following are optional for interactive control  */ 
       glutKeyboardFunc(keyboard);
       glutSpecialFunc(specialkeybo);
       glutMouseFunc(mousepushed);
       glutMotionFunc(mousemoved);       
       glutPassiveMotionFunc(mousemoved); 
                                      /*  beyond here all are needed  */
       glutReshapeFunc(reshaped);
       glutIdleFunc(idle);             
       glutMainLoop();
}
/**********************************************************************/
 
