/* KeplerianElements.h
 * Created April 16, 2008
 * William Davis
 * University of Illinois at Urbana-Champaign
 * Last edited April 16, 2008 by William Davis
 */

/* This header file is simply a data file that defines the
 * Keplerian Elements of each planets orbit, that will be
 * used to compute each planets location at each time step.
 * There are six elements for each orbit, each with a
 * corresponding error factor.
 * The elements are given in the following format:
 *
 * Semi-Major Axis: PLANETNAME_SM_AXIS
 *    These constants have units of au, or astronomical units
 *
 * Semi-Major Axis Error: PLANETNAME_SM_ERROR
 *    These constants have units of au/century, or astronomical
 *    units per century
 *
 * Eccentricity: PLANETNAME_ECC
 *    These constants are unitless, describing the shape of the
 *    orbit
 *
 * Eccentricity Error: PLANETNAME_ECC_ERROR
 *    These constants have units of units per century
 *
 * Inclination: PLANETNAME_INC
 *    Though these may not be used in final calculations, these
 *    constants have units of degrees
 *
 * Inclination Error: PLANETNAME_INC_ERROR
 *    Though these may not be used in final calculations, these
 *    constants have units of degrees per century
 *
 * Mean Longitude: PLANETNAME_MLONG
 *    These constants have units of degrees
 *
 * Mean Longitude Error: PLANETNAME_MLONG_ERROR
 *    These constants have units of degrees per century
 * 
 * Longitude of Perihelion: PLANETNAME_PERI
 *    These constants have units of degrees
 *
 * Longitude of Perihelion Error: PLANETNAME_PERI_ERROR
 *    These constants have units of degrees per century
 *
 * Longitude of Ascending Node: PLANETNAME_ASC
 *    These constants have units of degrees
 *
 * Longitude of Ascending Node Error: PLANETNAME_ASC_ERROR
 *    These constants have units of degrees per century
 *
 * Radius of Planetary Sphere: PLANETNAME_RADIUS
 *    These constants have units of astronautical unit
 */

 /* NOTE: ********************************************
  * "A" values are for the more specific time interval
  * 1800 AD - 2050 AD
  *
  * "B" values are for the less specific time interval
  * 3000 BC - 3000 AD
  */

                  /*MERCURY*/
#define MERCURY_RADIUS                 0.00016308

/* "A" SET */

#define MERCURY_SM_AXIS_A              0.38709927
#define MERCURY_SM_ERROR_A             0.00000037

#define MERCURY_ECC_A                  0.20563593
#define MERCURY_ECC_ERROR_A            0.00001906

#define MERCURY_INC_A                  7.00497902
#define MERCURY_INC_ERROR_A           -0.00594749

#define MERCURY_MLONG_A              252.25032350
#define MERCURY_MLONG_ERROR_A     149472.67411175

#define MERCURY_PERI_A                77.45779628
#define MERCURY_PERI_ERROR_A           0.16047689

#define MERCURY_ASC_A                 48.33076593
#define MERCURY_ASC_ERROR_A           -0.12534081

/* "B" SET */

#define MERCURY_SM_AXIS_B              0.38709843
#define MERCURY_SM_ERROR_B             0.00000000

#define MERCURY_ECC_B                  0.20563661
#define MERCURY_ECC_ERROR_B            0.00002123

#define MERCURY_INC_B                  7.00559432
#define MERCURY_INC_ERROR_B           -0.00590158

#define MERCURY_MLONG_B              252.25166724
#define MERCURY_MLONG_ERROR_B     149472.67486623

#define MERCURY_PERI_B                77.45771895
#define MERCURY_PERI_ERROR_B           0.15940013

#define MERCURY_ASC_B                 48.33961819
#define MERCURY_ASC_ERROR_B           -0.12214182

                    /*VENUS*/

#define VENUS_RADIUS                 0.00040454

/* "A" SET */

#define VENUS_SM_AXIS_A              0.72333566
#define VENUS_SM_ERROR_A             0.00000390

#define VENUS_ECC_A                  0.00677672
#define VENUS_ECC_ERROR_A           -0.00004107 

#define VENUS_INC_A                  3.39467605
#define VENUS_INC_ERROR_A           -0.00078890

#define VENUS_MLONG_A              181.97909950
#define VENUS_MLONG_ERROR_A      58517.81538729

#define VENUS_PERI_A               131.60246718 
#define VENUS_PERI_ERROR_A           0.00268329

#define VENUS_ASC_A                 76.67984255
#define VENUS_ASC_ERROR_A           -0.27769418

/* "B" SET */

#define VENUS_SM_AXIS_B              0.72332102
#define VENUS_SM_ERROR_B            -0.00000026

#define VENUS_ECC_B                  0.00676399
#define VENUS_ECC_ERROR_B           -0.00005107

#define VENUS_INC_B                  3.39777545
#define VENUS_INC_ERROR_B            0.00043494

#define VENUS_MLONG_B              181.97970850
#define VENUS_MLONG_ERROR_B      58517.81560260

#define VENUS_PERI_B               131.76755713
#define VENUS_PERI_ERROR_B           0.05679648

#define VENUS_ASC_B                 76.67261496
#define VENUS_ASC_ERROR_B           -0.27274174


                    /*EARTH*/

#define EARTH_RADIUS                 0.00042587

/* "A" SET */

#define EARTH_SM_AXIS_A              1.00000261
#define EARTH_SM_ERROR_A             0.00000562

#define EARTH_ECC_A                  0.01671123
#define EARTH_ECC_ERROR_A           -0.00004392 

#define EARTH_INC_A                 -0.00001531
#define EARTH_INC_ERROR_A           -0.01294668

#define EARTH_MLONG_A              100.46457166
#define EARTH_MLONG_ERROR_A      35999.37244981

#define EARTH_PERI_A               102.93768193 
#define EARTH_PERI_ERROR_A           0.32327364

#define EARTH_ASC_A                  0.00000000
#define EARTH_ASC_ERROR_A            0.00000000

/* "B" SET */

#define EARTH_SM_AXIS_B              1.00000018
#define EARTH_SM_ERROR_B            -0.00000003

#define EARTH_ECC_B                  0.01673163
#define EARTH_ECC_ERROR_B           -0.00003661

#define EARTH_INC_B                 -0.00054346
#define EARTH_INC_ERROR_B           -0.01337178

#define EARTH_MLONG_B              100.46691572
#define EARTH_MLONG_ERROR_B      35999.37306329

#define EARTH_PERI_B               102.93005885
#define EARTH_PERI_ERROR_B           0.31795260

#define EARTH_ASC_B                 -5.11260389
#define EARTH_ASC_ERROR_B           -0.24123856

                    /*MARS*/

#define MARS_RADIUS                 0.00022635

/* "A" SET */

#define MARS_SM_AXIS_A              1.52371034
#define MARS_SM_ERROR_A             0.00001847

#define MARS_ECC_A                  0.09339410
#define MARS_ECC_ERROR_A            0.00007882 

#define MARS_INC_A                  1.84969142
#define MARS_INC_ERROR_A           -0.00813131

#define MARS_MLONG_A               -4.55343205
#define MARS_MLONG_ERROR_A      19140.30268499

#define MARS_PERI_A               -23.94362959 
#define MARS_PERI_ERROR_A           0.44441088

#define MARS_ASC_A                 49.55953891
#define MARS_ASC_ERROR_A           -0.29257343

/* "B" SET */

#define MARS_SM_AXIS_B              1.52371243
#define MARS_SM_ERROR_B             0.00000097

#define MARS_ECC_B                  0.09336511
#define MARS_ECC_ERROR_B            0.00009149

#define MARS_INC_B                  1.85181869
#define MARS_INC_ERROR_B           -0.00724757

#define MARS_MLONG_B               -4.56813164
#define MARS_MLONG_ERROR_B      19140.29934243

#define MARS_PERI_B               -23.91744784
#define MARS_PERI_ERROR_B           0.45223625

#define MARS_ASC_B                 49.71320984
#define MARS_ASC_ERROR_B           -0.26852431


                    /*JUPITER*/

#define JUPITER_RADIUS                 0.00462393

/* "A" SET */

#define JUPITER_SM_AXIS_A              5.20288700
#define JUPITER_SM_ERROR_A            -0.00011607

#define JUPITER_ECC_A                  0.04838624
#define JUPITER_ECC_ERROR_A           -0.00013253 

#define JUPITER_INC_A                  1.30439695
#define JUPITER_INC_ERROR_A           -0.00183714

#define JUPITER_MLONG_A               34.39644051
#define JUPITER_MLONG_ERROR_A       3034.74612775

#define JUPITER_PERI_A                14.72847983 
#define JUPITER_PERI_ERROR_A           0.21252668

#define JUPITER_ASC_A                100.47390909
#define JUPITER_ASC_ERROR_A            0.20469106

/* "B" SET - EXTRA CONSTANTS REQUIRED */

#define JUPITER_SM_AXIS_B              5.20248019
#define JUPITER_SM_ERROR_B            -0.00002864

#define JUPITER_ECC_B                  0.04853590
#define JUPITER_ECC_ERROR_B           -0.00018026

#define JUPITER_INC_B                  1.29861416
#define JUPITER_INC_ERROR_B           -0.00322699

#define JUPITER_MLONG_B               34.33479152
#define JUPITER_MLONG_ERROR_B       3034.90371757

#define JUPITER_PERI_B                14.27495244
#define JUPITER_PERI_ERROR_B           0.18199196

#define JUPITER_ASC_B                100.29282654
#define JUPITER_ASC_ERROR_B            0.13024619

#define JUPITER_b                     -0.00012452
#define JUPITER_c                      0.06064060
#define JUPITER_s                     -0.35635438
#define JUPITER_f                     38.35125000


                    /*SATURN*/

#define SATURN_RADIUS                 0.00383133

/* "A" SET */

#define SATURN_SM_AXIS_A              9.53667594
#define SATURN_SM_ERROR_A            -0.00125060

#define SATURN_ECC_A                  0.05386179
#define SATURN_ECC_ERROR_A           -0.00050991 

#define SATURN_INC_A                  2.48599187
#define SATURN_INC_ERROR_A            0.00193609

#define SATURN_MLONG_A               49.95424423
#define SATURN_MLONG_ERROR_A       1222.49362201

#define SATURN_PERI_A                92.59887831 
#define SATURN_PERI_ERROR_A          -0.41897216

#define SATURN_ASC_A                113.66242448
#define SATURN_ASC_ERROR_A           -0.28867794

/* "B" SET - EXTRA CONSTANTS REQUIRED */

#define SATURN_SM_AXIS_B              9.54149883
#define SATURN_SM_ERROR_B            -0.00003065

#define SATURN_ECC_B                  0.05550825
#define SATURN_ECC_ERROR_B           -0.00032044

#define SATURN_INC_B                  2.49424102
#define SATURN_INC_ERROR_B            0.00451969

#define SATURN_MLONG_B               50.07571329
#define SATURN_MLONG_ERROR_B       1222.11494724

#define SATURN_PERI_B                92.86136063
#define SATURN_PERI_ERROR_B           0.54179478

#define SATURN_ASC_B                113.63998702
#define SATURN_ASC_ERROR_B           -0.35015002

#define SATURN_b                      0.00025899
#define SATURN_c                     -0.13434469
#define SATURN_s                      0.87320147
#define SATURN_f                     38.35125000


                    /*URANUS*/

#define URANUS_RADIUS                 0.00168893

/* "A" SET */

#define URANUS_SM_AXIS_A             19.18916464
#define URANUS_SM_ERROR_A            -0.00196176

#define URANUS_ECC_A                  0.04725744
#define URANUS_ECC_ERROR_A           -0.00004397 

#define URANUS_INC_A                  0.77263783
#define URANUS_INC_ERROR_A           -0.00242939

#define URANUS_MLONG_A              313.23810451
#define URANUS_MLONG_ERROR_A        428.48202785

#define URANUS_PERI_A               170.95427630 
#define URANUS_PERI_ERROR_A           0.40805281

#define URANUS_ASC_A                 74.01692503
#define URANUS_ASC_ERROR_A            0.04240589

/* "B" SET - EXTRA CONSTANTS REQUIRED */

#define URANUS_SM_AXIS_B             19.18797948
#define URANUS_SM_ERROR_B            -0.00020455

#define URANUS_ECC_B                  0.04685740
#define URANUS_ECC_ERROR_B           -0.00001550

#define URANUS_INC_B                  0.77298127
#define URANUS_INC_ERROR_B           -0.00180155

#define URANUS_MLONG_B              314.20276625
#define URANUS_MLONG_ERROR_B        428.49512595

#define URANUS_PERI_B               172.43404441
#define URANUS_PERI_ERROR_B           0.09266985

#define URANUS_ASC_B                 73.96250215
#define URANUS_ASC_ERROR_B            0.05739699

#define URANUS_b                      0.00058331
#define URANUS_c                     -0.97731848
#define URANUS_s                      0.17689245
#define URANUS_f                      7.67025000


                    /*NEPTUNE*/

#define NEPTUNE_RADIUS                 0.00164123

/* "A" SET */

#define NEPTUNE_SM_AXIS_A             30.06992276
#define NEPTUNE_SM_ERROR_A             0.00026291

#define NEPTUNE_ECC_A                  0.00859048
#define NEPTUNE_ECC_ERROR_A            0.00005105 

#define NEPTUNE_INC_A                  1.77004347
#define NEPTUNE_INC_ERROR_A            0.00035372

#define NEPTUNE_MLONG_A              -55.12002969
#define NEPTUNE_MLONG_ERROR_A        218.45945325

#define NEPTUNE_PERI_A                44.96476227 
#define NEPTUNE_PERI_ERROR_A          -0.32241464

#define NEPTUNE_ASC_A                131.78422574
#define NEPTUNE_ASC_ERROR_A           -0.00508664

/* "B" SET - EXTRA CONSTANTS REQUIRED */

#define NEPTUNE_SM_AXIS_B             30.06952752
#define NEPTUNE_SM_ERROR_B             0.00006447

#define NEPTUNE_ECC_B                  0.00895439
#define NEPTUNE_ECC_ERROR_B            0.00000818

#define NEPTUNE_INC_B                  1.77005520
#define NEPTUNE_INC_ERROR_B            0.00022400

#define NEPTUNE_MLONG_B              304.22289287
#define NEPTUNE_MLONG_ERROR_B        218.46515314

#define NEPTUNE_PERI_B                46.68158724
#define NEPTUNE_PERI_ERROR_B           0.01009938

#define NEPTUNE_ASC_B                131.78635853
#define NEPTUNE_ASC_ERROR_B           -0.00606302

#define NEPTUNE_b                     -0.00041348
#define NEPTUNE_c                      0.68346318
#define NEPTUNE_s                     -0.10162547
#define NEPTUNE_f                      7.67025000
