/****************************************************************/
/****       anaschprel.c by Mark Flider (2000)               ****/
/****           now with MacOS includes                      ****/
/****           descended from shnail                        ****/
/****    (C) 1994 Board of Trustees University of Illinois   ****/ 
/****    A Model Real-Time Interactive CAVE Application      ****/
/****    George Francis, Glenn Chappell, Chris Hartman       ****/
/****    e-mail  gfrancis@math.uiuc.edu                      ****/
/****    with Stuart Levy's opengl_stars.c                      */ 
/****************************************************************/

#include <stdlib.h>
/* #include <sys/types.h> */
#include <math.h>
#ifndef __MWERKS__
#include <sys/time.h>
#endif

/* Some <math.h> files do not define M_PI... */
#ifndef M_PI
#define M_PI 3.14159265358979323846
#endif

#ifndef __sgi
#ifndef __MWERKS__
/* Most math.h's do not define float versions of the trig functions. */
#define sinf(x) ((float)sin((x)))
#define cosf(x) ((float)cos((x)))
#define atan2f(y, x) ((float)atan2((y), (x)))

#define fsqrt(x) ((float)sqrt(x))
#else
    #define fcos cos
    #define fsin sin
    #define fsqrt sqrt
#endif
#endif

#include <stdio.h>
#ifdef __sgi
#include <glut.h>	/* SGI glut libs */
#else
#ifdef __MWERKS__
#include <glut.h>	/* MacOS 9 glut libs */
#else
#ifdef __LINUX
#include <GL/glut.h>
#else
#include <GLUT/glut.h>	/*OS X glut libs */
#endif
#endif
#endif

#ifdef SOUND
/* #include <device.h> */
#include <string.h>
#include "vssClient.h"
#endif
#ifdef CAVE
#include <cave_ogl.h>
#include <cave.macros.h>
#endif 

/* Examples of useful geometric macros, use inliners in C++ */
#define  MAX(x,y)         (((x)<(y))?(y):(x))
#define  MIN(x,y)         (((x)<(y))?(x):(y))
#define  ABS(x)           fabs(x) 
#define  FOR(a,b,c)       for((a)=(b);(a)<(c);(a)++)
#define  DOT(p,q)         ((p)[0]*(q)[0]+(p)[1]*(q)[1]+(p)[2]*(q)[2])
#define  NRM(p)           fsqrt(DOT((p),(p)))
#define  CLAMP(x,u,v) (x<u? u : (x>v ? v: x))

/* global variables ... add new ones on top of the stack */
char	which[20];           /* audio needs this */
int	delta;               /* new variables for autotymer to change torus */
float	gap0=1.;             /*very bad kludge ... for letting arguments reset default gap value */
int	audiohandle;         /* for telling vss the name of the .aud file */
float	lux[3]={1.,2.,3.};   /*light source direction vector */
float	lu[3];     /* this needs to be shared current light direction vector*/
float	mysiz,speed, torq, focal, far; /*console navigation variables         */
int	win = 2;                 /* full screen, use 0 for demand sized */
unsigned int BUT,XX,YY,SHIF;     /* used in chaptrack gluttery */ 
int	xt,yt;                   /* once was xt,yt,xm,ym for viewportery */
int	caveyes=0;               /* rename? ----------> caveflag */
int	morph,msg,binoc;         /* pretty global */

#define FLYMODE  (0)
#define TURNMODE (1) 
#define MOVING (0)
#define FROZEN (1)
#define GALILEAN (0)
#define RELATIVE (1)
#define CHAPTRACK (0)
#define FLITRACK (1)

#define HOW_FAR_BACK 512
int aa,bb,dd,ee,ff,wVert;	/* Flider variables */
float vex,vey,vez;
int dd_best; float temp_best, temp;

/*Shared memory variables as per Stuart Levy 1994 */  
struct share_var{ 
    float s_vel;
    float s_flod[1001][3];
    float s_flodraw[1001][3];
    float s_ceid[1001][3];
    float s_ceidraw[1001][3];
    float s_beam[16][30][3];
    float s_beamdraw[16][30][3];
    float s_pillars[40][40][3]; 
    float s_pilldraw[40][40][3];
    float s_trib[16][5][3]; 
    float s_tribdraw[16][5][3];
    float s_trit[16][5][3];
    float s_tritdraw[16][5][3];
    float s_self[120][3];
    float s_selfdraw[120][3];
    
    float s_theThreshold;
    int   s_badMathCountdown;

    float s_selfPosition[HOW_FAR_BACK][3];
    int   s_linearVel;  /* Keep track of past positions or not */
    
    int   s_track;  /* 1 = relativistic,  0 = galilean */
    float s_cls;
    float s_tyme;
    int   s_highquality;
    int   s_turn_factor;

   int	 s_mode ;           /* because drawhoop uses it to change color */
   float s_alfa ;           /* because autotymer changes these display vars */
   float s_beta ;
   float s_lima ;
   
   float s_gap ;  
   float s_siz ;          /* final scaling factor before projection	*/  
   int   s_wnd;           /* wand or maus flag             		      */
   int   s_gnd;           /* background color                     	*/
   float s_lu[3];         /* current light direction 				*/ 
   int   s_mauspaw;       /* binary for mouse button state        	*/
   GLfloat s_aff[16];
   GLfloat s_starmat[16]; /* affine matrices for object, stars		*/
} *s_var; 

#define vel  (s_var->s_vel)		/* my shared variables */
#define flod  (s_var->s_flod) 
#define flodraw (s_var->s_flodraw)
#define ceid (s_var->s_ceid)
#define ceidraw (s_var->s_ceidraw)
#define pillars (s_var->s_pillars)
#define pilldraw (s_var->s_pilldraw)
#define beam (s_var->s_beam)
#define beamdraw (s_var->s_beamdraw)
#define trib (s_var->s_trib)
#define tribdraw (s_var->s_tribdraw)
#define trit (s_var->s_trit)
#define tritdraw (s_var->s_tritdraw)
#define track (s_var->s_track)
#define cls (s_var->s_cls)
#define tyme (s_var->s_tyme)
#define highquality (s_var->s_highquality)
#define self (s_var->s_self)
#define selfdraw (s_var->s_selfdraw)
#define turn_factor (s_var->s_turn_factor)
#define selfPosition (s_var->s_selfPosition)

#define theThreshold (s_var->s_theThreshold)
#define badMathCountdown (s_var->s_badMathCountdown)
#define linearVel (s_var->s_linearVel)

#define mode    (s_var->s_mode)	/* other shared variales */
#define alfa    (s_var->s_alfa)
#define beta    (s_var->s_beta)
#define lima    (s_var->s_lima)

#define gap     (s_var->s_gap)
#define siz     (s_var->s_siz)
#define wnd     (s_var->s_wnd)
#define gnd     (s_var->s_gnd)  /* use only if printframe function is present */
#define lu      (s_var->s_lu )  /* else the right wall isn't specularized */
#define aff     (s_var->s_aff)  
#define starmat (s_var->s_starmat) 
#define mauspaw (s_var->s_mauspaw)

/* these are used only in console mode      */
float nose;   /* to eye distance in console */

void getmem(void){
  if(caveyes)
#ifdef CAVE
     s_var = CAVEMalloc(sizeof(struct share_var))
#endif
     ;
   else
     s_var = malloc(sizeof(struct share_var));
  if(s_var==NULL)
    {fprintf(stderr,"No room to share! %x \n",s_var); exit(1);}
}

void char2wall(GLfloat x,GLfloat y, GLfloat z, char buf[]){
     char *p; glRasterPos3f(x,y,z);
     for(p = buf;*p;p++) glutBitmapCharacter(GLUT_BITMAP_9_BY_15,*p);
}

float dist2(float x1, float y1, float z1); /* prototype for ANSI C */
void autotymer(int);  /* to allow deFault to call the autotymer later */
void caveframe(void);

float updateVertex (float x1, float y1, float z1, float c1, float v1, float thegamma);

#include "spacejunk-ana.c"	/*** all the functions to update & draw stuff ***/
                        /*** tres tres importante  ***/

void deFault(void){
  int ii; float tmp; 
  msg=1; binoc=0; nose=.04; mauspaw = 0; wnd = 1; siz = 1.; 
  mode=FROZEN; /* same a TURNMODE in Galilean track */  
  speed=1; /* max speed; between 0 and 1 */
  vel = .025;  /* how fast we're moving      */
  track = RELATIVE; /* relativistic */
  cls = .1;   	/* speed of light */
  turn_factor = 0;
  torq=.005; focal = 2.; far = 5000; mysiz=.01; morph=0; 
  for(ii=0;ii<16;ii++)  starmat[ii]=aff[ii] = (ii/4==ii%4) ? 1 : 0;   
  tmp=NRM(lux);  for(ii=0;ii<3;ii++)lux[ii]/=tmp;
  if(caveyes){aff[12]=0; aff[13]= 0; aff[14]= 0 ; } /*5ft beyond front wall*/ 
       else{aff[12]=0; aff[13]= 0; aff[14]= -4.2; } /*inside the console */ 
    
  theThreshold = .0000;
  highquality = caveyes;
  linearVel = 0;	/* keeps track of position or not */
  badMathCountdown = 0;

initall();	/* calls init from #included datafile */

   autotymer(1); /* reset autotymer to start at the beginning */
}

/***** --- draw functions down here --*****/


#include "opengl_stars_OSX.c"	/* Steven Levy's data and functions for stars */

void audioprep(void){
#ifdef SOUND
   if (!FBgnSoundServer())
      fprintf(stderr,"UDP connection to sound server failed\n");
   else if ((audiohandle = AUDinit("noosh.aud")) == -1)
      fprintf(stderr,"Couldn't open noosh.aud\n");
#endif
}

void dohoot(void) {strcpy(which,"hoot");}
void dotrump(void){strcpy(which,"trump");}
void doflute(void){strcpy(which,"flute");}
void dodrum(void) {strcpy(which,"drum");}

void audiofunc(void){
#ifdef SOUND 
#define LIRP(X,A,B,x,a,b)  (X = A + (x-a)*(B-A)/(b-a))
  static float freq=440., ampl=1., indx=20., cmra=2.; 
  static float data[4];
  static omode =0; static ofocal = 0;
  static beep =0;  /* the sound server */

  if(omode > mode){dohoot(); beep = 1;}
  if(omode < mode){dodrum(); beep = 1;}

  LIRP(freq, 440, 1760, th0,  10, 170); /* frequeny mimics th1 */ 
  LIRP(indx, 10, 1,  focal, .03, 2.0); /* index  mimics focal */ 
  if(ofocal != focal){dodrum(); beep = 1;}    /* there is an fp bug here */

if(beep){data[0] = freq;  /* pitch in Herz      */ 
          data[1] = ampl;  /* the sum of all amplitudes must be < 1.0 */ 
          data[2] = indx;    
          data[3] = cmra;
          AUDupdate(audiohandle, which, 4, data);  /* send message  to vss */ 
          beep = 0; 
}
  omode = mode;  ofocal = focal; 
#endif
}

void audioclean(void){
#ifdef SOUND
   AUDterminate(audiohandle);
   EndSoundServer();
#endif
}

void arguments(int argc,char **argv){
#ifdef CAVE
  extern char *optarg;
  extern int optind; 
  int chi;   
  /* w: needs ONE number after -w, c<nothing> means NO number follows*/ 
  while ((chi = getopt(argc,argv,"w:cd:g:")) != -1) 
  switch(chi)  {case 'c': caveyes=1; break;  
                case 'w': win=atoi(optarg); break; 
                case 'g': gap0=atof(optarg); break;
                }
  if (optind!=argc) fprintf(stderr,"%s: Incorrect usage\n",argv[0])
#endif  
  ;
}

void dataprep(void){
   audioprep();
   deFault();
   initstars();
}

void autotymer(int reset){
   #define  TYME(cnt,max,act) {static int cnt; if(first)cnt=max; else\
                               if(cnt?cnt--:0){ act ; goto Break;}}
   static int first = 1;  /* the first time autymer is called */
   if(reset)first=1;  /* or if it is reset to start over  */
/*  TYME( snl2mob,72, ta0++; ta1--) /shrink snail to moebius*/
/*  TYME( mob2snl,72, ta0--; ta1++) /grow moebius to snail*/
  first = 0;
  Break: ;                         /*yes Virginia, C has gotos */
}/*end autotymer*/

void flitrack (int but,int xx,int yy,int shif); /*prototype*/

/*Beware of competing keys in CAVEsimulation and wnd==1   */
/* you may want to remap these keys to avoid the conflict */

void keyboard(unsigned char key, int x, int y){
#define  IF(K)            if(key==K)
#define  PRESS(K,A,b)     IF(K){b;}IF((K-32)){A;}  
/*was backwards in previous versions */
#define  TOGGLE(K,flg)    IF(K){(flg) = 1-(flg); }
#define  CYCLE(K,f,m)     PRESS((K), (f)=(((f)+(m)-1)%(m)),(f)=(++(f)%(m)))
#define  SLIDI(K,f,m,M)   PRESS(K,(--f<m?m:f), (++f>M?M:f))
#define  SLIDF(K,f,m,M,d) PRESS(K,((f -= d)<m?m:f), ((f += d)>M?M:f))
/* Only ASCII characters can be processes by this GLUT callback function */ 
   TOGGLE('b',binoc);                            /* cross-eyed STEREO   */
   TOGGLE('m',msg);                              /* writing on/off      */
   TOGGLE('h',morph);                            /* autotymer on/off    */
   PRESS('n', nose -= .001 , nose += .001 );     /* for binoculars      */
   CYCLE(' ', mode,TURNMODE+1);                  /* fly/turn modes      */
   PRESS('i', mysiz /= 1.1, mysiz *= 1.1);        /* rescale the world   */
   PRESS('o', focal *= 1.1 , focal /= 1.1);      /* telephoto           */
   PRESS('p', far *= 1.01 , far   /= 1.01);      /* rear clipping plane */
   PRESS('v',   /*velocity*/
      vel=MIN(vel/1.02,.9995*cls); badMathCountdown=HOW_FAR_BACK,
      vel=MIN(vel*1.02,.9995*cls); badMathCountdown=HOW_FAR_BACK);
   PRESS('c',cls = MAX(cls/1.02,.0001),cls = MAX(cls*1.02,.0001)); /* lightspeed */
   PRESS('t',,{track=1-track; if(track)
   {
   int ii; float tmp;
   for(ii=0;ii<16;ii++)  starmat[ii]=aff[ii] = (ii/4==ii%4) ? 1 : 0;   
  tmp=NRM(lux);  for(ii=0;ii<3;ii++)lux[ii]/=tmp;
  if(caveyes){aff[12]=0; aff[13]= 0; aff[14]= 0 ; } /*5ft beyond front wall*/ 
       else{aff[12]=0; aff[13]= 0; aff[14]= -4.2; }
   }}
   );
   TOGGLE('y',highquality);
   TOGGLE('l',linearVel);
   
   PRESS('q',torq /= 1.02, torq *= 1.02);        /* turning speed       */
   PRESS('g',gap /= .99, gap *= .99);            /* gap parameter       */
   PRESS('z', deFault(), deFault());             /* zap changes         */
   IF(27) {audioclean(); exit(0); }              /* ESC exit            */
}

void special_keybo(int key, int x, int y){
 if (key == GLUT_KEY_RIGHT) turn_factor = 256;	/* so we can turn from ecstasy mode */
 else if (key == GLUT_KEY_LEFT) turn_factor = -256;
 else
/*non-ASCII keypresses go here, if you're lucky enough to know their names */
   {
   fprintf(stderr," non-ASCII character was pressed.\n");
   fprintf(stderr," use special_keybo() to process it\n");
   }
}

/* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */
#ifdef CAVE
/* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */

void cavekeybo(void){
#define  CAVEIF(K)         if(CAVEgetbutton(K))
#define  CAVEPRESS(K,A,b)  CAVEIF(K){if(CAVEgetbutton(CAVE_LEFTSHIFTKEY)||\
                           CAVEgetbutton(CAVE_RIGHTSHIFTKEY)){b;}else{A;}}
#define  CAVETOGGLE(K,flg) CAVEIF(K){(flg) = 1-(flg); }
#define  CAVECYCLE(K,f,m)  CAVEPRESS((K),(f)=(((f)+(m)-1)%(m)),(f)=(++(f)%(m)) )
#define  CAVESLIDI(K,f,m,M)  CAVEPRESS(K,(--f<m?m:f), (++f>M?M:f))
#define  CAVESLIDF(K,f,m,M,d) CAVEPRESS(K,((f -= d)<m?m:f), ((f += d)>M?M:f))
  CAVEPRESS(CAVE_PKEY, far *= 1.01,   far   /= 1.01) /* rear clipping plane*/
  CAVETOGGLE(CAVE_QKEY, track); /*track*/
  CAVEPRESS(CAVE_RKEY, torq /= 1.02,  torq *= 1.02); /* turning speed      */
  CAVETOGGLE(CAVE_YKEY,wnd);                         /* mauspaw vs wandpaw */
/* not yet implemented */ 
   CAVEPRESS(CAVE_ZKEY, deFault(), deFault());        /* zap changes       */
}

void graffiti(void){             /* used to be called speedo  */
  char buf[256];                 /*messages written into here */ 
#define  LABEL3(x,y,z,W,u){sprintf(buf,(W),(u));char2wall(x,y,z,buf);}
  static float last=0.,fps;      /*for measuring time         */ 
  if(!CAVEMasterDisplay()) return;  /* USE CAVEMasterWall in papeBeta */
  if(floor(2.*(*CAVETime))>floor(2.*last)){  /* rationalize this */ 
     last=*CAVETime;
     fps=*CAVEFramesPerSecond;
     }
  if(track==GALILEAN) /*Galilean*/ 
      {
        glColor3f(1.,1.,1.);
        LABEL3(-3.8,1.,-5.0,\
        "FREEZE TIME=(M)  CHG. LIGHT SPEED=(L)/(R)  RELATIVISTIC=hold(M)click(L)  RESET=hold(M)click(R) %s","");
        } 
   if(track==RELATIVE){
        glColor3f(1.,1.,0.);
        LABEL3(-3.8,1.0,-5.0, "FREEZE TIME=(M)  CHG. LIGHT SPEED=(L)/(R)  ECSTASY=hold(M)click(L)  RESET=hold(M)click(R) %s",""); 
     }
     LABEL3(-4.8,8.0,-5.0, "SchpRel  \
by Mark Flider, (C) 2000 UIUC %s","");
       LABEL3(-4.8,1.0,-5.4,"%5.1f fps",fps);
       LABEL3(-4.8,1.5,-5.2,"c = %1.4f",cls);
       LABEL3(-4.8,2.0,-5.0,"v = %1.4f",vel);
       LABEL3(-4.8,2.5,-5.0,"percent %2.2f",vel/cls*100);
}

void flicavetrack(void){
  float azi,ele,rol,hx,hy,hz,wx,wy,wz;
  static float ohx,ohy,ohz;   /*old head position */
  static float owx,owy,owz;   /*old wand position */
  static int opaw = 0,paw, joy = 0, friz;

  if(!CAVEMasterDisplay()) return;  /* doit once per frame */
  paw = wnd ? (CAVEBUTTON1*2+CAVEBUTTON2)*2+CAVEBUTTON3 : mauspaw;

  if(opaw==2 && paw==6){ 	/* hold(M)click(L) */
    track = GALILEAN ; 		/* Galilean */
    mode = FLYMODE;
    caveframe();			/* go do normal cavetrack() */
    return;					/* and don't do the rest of our flicavetrack */
  }

  /*if(mode==FROZEN){ 
     if(opaw==1 && paw == 5) vel = MIN(cls*.99995,vel*1.02); 	/ hold(R)click  */
    /* if(opaw==1 && paw == 3) vel = vel/1.02;  					/ +(L) -(M) (for v)  */
   /*  } */

  if (paw == 4) cls = cls*1.005; 			/* change lightspeed */
  if (paw == 1)  cls = MAX(cls/1.005,vel/.99995);
  
  if (opaw==2 && paw == 3)		/* restart, hold(M)click(R) */
     {	deFault(); ohx=ohy=ohz=0; owx=owy=owz=0;}/* no sweat, deFault starts in flitrack */
       						
     
      CAVEGetWandOrientation(azi,ele,rol);
      CAVEGetHead(hx,hy,hz);  /*position*/
      CAVEGetWand(wx,wy,wz);  /*position*/

    if(opaw != 2 && paw == 2) mode=1-mode;
 
    flitrack(0,(int)(azi*-5),(int)(ele*-5),0); /* ele doesn't for now */

   opaw=paw; ohx=hx; ohy=hy; ohz=hz;
             owx=wx; owy=wy; owz=wz;
   if(morph) autotymer(0);  /* advance autotymer */
   audiofunc();
}


void cavetrack(void){
  float azi,ele,rol,hx,hy,hz,wx,wy,wz;
  static float ohx,ohy,ohz;   /*old head position */
  static float owx,owy,owz;   /*old wand position */
  static int opaw = 0,paw, joy = 0, friz;
  float CAVEtorq = torq/4.0;

  if(!CAVEMasterDisplay()) return;  /* doit once per frame */
  paw = wnd ? (CAVEBUTTON1*2+CAVEBUTTON2)*2+CAVEBUTTON3 : mauspaw;
  if(paw) joy = 1; /* activate joystick by clicking any button*/
  if(opaw!=2 && paw==2) mode = (mode+1)%(TURNMODE+1); /* click modes */
/*
  if(opaw==2 && paw==6){ 	* hold(M)click(L) *
    track = RELATIVE ; 		* Relativistic *
    mode = FROZEN;
    caveframe();		* go do flicavetrack() *
    return;			* and don't do the rest of our cavetrack *
  }
*/
     if (paw == 4) cls = cls*1.005; 
     if (paw == 1)  cls = MAX(cls/1.005,vel/.99995);
  if(opaw==2 && paw == 3)		/* restart, hold(M)click(R) */
     {	deFault(); ohx=ohy=ohz=0; owx=owy=owz=0;
      } 						/* no sweat, deFault starts in flitrack */


  if(wnd){ 
      CAVEGetWandOrientation(azi,ele,rol);
      CAVEGetHead(hx,hy,hz);  /*position*/
      CAVEGetWand(wx,wy,wz);  /*position*/ 
      }
   else{  /* fix this for CAVE mouse flying */ 
      azi = .5*512; ele = .5*-512;
      } 
   glMatrixMode(GL_MODELVIEW); glPushMatrix(); glLoadIdentity();

	if (-15.0 < azi && azi < 15.0) azi = 0.0;	/* dead zone... */
	if (-15.0 < ele && ele < 15.0) ele = 0.0;
	if (-15.0 < rol && rol < 15.0) rol = 0.0;

   glTranslatef(ohx-hx,ohy-hy,ohz-hz); 
 if(mode==TURNMODE) glTranslatef(aff[12],aff[13],aff[14]);
   if(!friz){  /* if not parked */
      glRotatef(rol*(mode?CAVEtorq:-CAVEtorq),0.,0.,1.); 
      glRotatef(ele*-CAVEtorq, 1.,0.,0.); 
      glRotatef(azi*-CAVEtorq,0.,1.,0.);
      }
   if(joy&&((fabs(CAVE_JOYSTICK_Y)>.25)||(fabs(CAVE_JOYSTICK_X)>.25)))
       glTranslatef(CAVE_JOYSTICK_X*speed/20.0,0.,CAVE_JOYSTICK_Y*speed/20.0);
 
/* if(opaw==2 && paw==2)glTranslatef((wx-owx)/50.0, (wy-owy)/50.0, (wz-owz)/50.0); *wand tractor */

 if(mode == TURNMODE) glTranslatef(-aff[12],-aff[13],-aff[14]);
   glMultMatrixf(aff); 
   glGetFloatv(GL_MODELVIEW_MATRIX,aff);

  {int ii,jj; for(ii=0;ii<3;ii++){ lu[ii]=0; /* calculite */
   for(jj=0;jj<3;jj++) lu[ii] += aff[ii*4+jj]*lux[jj];} }

   if(mode==FLYMODE && !friz) /*make the star matrix rotate*/
      {
      glLoadIdentity();
      glRotatef(rol*(mode?CAVEtorq:-CAVEtorq),0.,0.,1.); 
      glRotatef(ele*-CAVEtorq,1.,0.,0.); 
      glRotatef(azi*-CAVEtorq,0.,1.,0.);
      glMultMatrixf(starmat); 
      glGetFloatv(GL_MODELVIEW_MATRIX,starmat);
      }
   glPopMatrix();
   
   flitrack(0,(int)(azi*-5),(int)(ele*-5),0); /* ele doesn't for now */
   
   opaw=paw; ohx=hx; ohy=hy; ohz=hz;
             owx=wx; owy=wy; owz=wz;
   if(morph) autotymer(0);  /* advance autotymer */
   audiofunc();
}

void drawcaveinit(void){   /* kludge? needed why ? */  
   CAVEFar = 1000.;
   glClearColor(0.,0.,0.,0.);
   glClearDepth(1.);
}

void drawcave(void){
  float hx,hy,hz;
  glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
  drawstars();
  graffiti();
  CAVEGetHead(hx,hy,hz);
  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();
  glTranslatef(hx,hy,hz);
  glMultMatrixf(aff);
  glScalef(siz,siz,siz);
  drawall();
  glPopMatrix();
}
#else
void cavetrack(void) {};	/* needed to compile on non-CAVE platforms */
void flicavetrack(void) {};
#endif

/**********************************************************************/

float speedometer(void){
#ifndef __MWERKS__
double dbl; static double rate; static int ii=0;
static struct timezone notused; static struct timeval now, then;
   if(++ii % 8 == 0){  /* 8 times around measure time */
      gettimeofday(&now, &notused); /* elapsed time */
      dbl =  (double)(now.tv_sec - then.tv_sec)
         +(double)(now.tv_usec - then.tv_usec)/1000000;
      then = now;  rate = 8/dbl;
      }
   return((float)rate);
#else
	static int ii=0;
  	static long oldticks=-1;
  	long newticks;
  	static float rate=0;
  	if (++ii %8==0){
  		newticks=TickCount();
  		rate=8.0/((float)(newticks-oldticks)/60.0);
  		oldticks=newticks;
  	}
  	return rate;
#endif 	
}
 
void messages(void){     
 
 char buf[256]; /* console messages are done differently from cave */
#define  LABEL2(x,y,W,u) {sprintf(buf,(W),(u));char2wall(x,y,0.,buf);}
  glMatrixMode(GL_PROJECTION); glPushMatrix(); glLoadIdentity();
  gluOrtho2D(0,3000,0,3000);
  glMatrixMode(GL_MODELVIEW); glPushMatrix(); glLoadIdentity();
      /*bull's eye*/
      if(mode==TURNMODE) glColor3f(0,1,1);
        else      glColor3f(1,1,0);
      LABEL2(1500,1500,"%s","o");
      /* writings */
      if(mode==TURNMODE) glColor3f(0.,1.,1.);
        else      glColor3f(1.,1.,0.);
      LABEL2(80,80,"%4.1f fps",speedometer());
      LABEL2(80,2840,\
      "(ESC)ape (B)Binoc (MAUS2)Fore (BAR)Flymode %s (H)omotopy (W)riting",
             mode?"FLYING":"CONTROL");
      LABEL2(10,10,"SchpRel \
   by Mark Flider, UIUC, (C) 2000 %s","");
      LABEL2(80,2770,"(N)ose   %0.3f",nose);
      LABEL2(80,2700,"Velocity (v) %0.4f",vel);
      LABEL2(80,2630,"Speed of Light (c) %0.4f",cls);
      LABEL2(80,2560,"Percent of c %2.2f", vel/cls*100);
    /*  LABEL2(80,2490,"turn_factor %i", turn_factor); *//* who cares? */
    /*  LABEL2(80,2490,"f(O)cal factor %g",focal); */
    /*  LABEL2(80,2420,"my s(I)ze %.2g",mysiz); */
    /*  LABEL2(80,2350,"far cli(P)er= %.2g",far); */
      LABEL2(80,2280,"(Z)ap %s","");

   if(track) {
        LABEL2(80,2210,"(T)rack = flitrack",0); }
   else       {
        LABEL2(80,2210,"(T)rack = chaptrack",0); }

      LABEL2(80,2140,"highqualit(Y): %i",highquality);
      LABEL2(80,2070,"(L)inearVelocity: %i",linearVel);
      
   if (badMathCountdown)
   {
      glColor3f(1,0,0);
      LABEL2(80,160,"WARNING! BAD MATH! Seconds until fixed: %i",badMathCountdown/(int)speedometer());
   }
   glPopMatrix();
glMatrixMode(GL_PROJECTION); glPopMatrix();
} 

        /*  Special Relativity funcs start here @@@@@@@@@@@@@@@@@@@@@@@@@ */
    /* @@@@@ @@@@@ Special Relativity funcs start here @@@@@@@@@@@@@@@@@@@@ */
/* @@@@@ @@@@@ Special Relativity funcs start here @@@@@@@@@@@@@@@@@@@@@@@@@ */

float updateVertex (float x1, float y1, float z2, float c1, float v1, float thegamma)
{
    float temp = c1*c1-v1*v1;
    float z1 = z2;

    z1 = thegamma*z1;
        z1 += v1*(z1*v1-sqrt(z1*z1*v1*v1+temp*dist2(x1,y1,z1)))/temp;
    return z1;	/*the meat of the program */
}

float VEL(float vel1,float c1) {return MAX(c1*-.9999,MIN(c1*.9999,vel1));}
float dist2(float x1, float y1, float z1) {return x1*x1+y1*y1+z1*z1;}
float gamm (float v1,float c1) {return 1/sqrt(1-v1*v1/c1/c1);}

float thetime (float x1, float y1, float z1, float c1) {
        return sqrt(dist2(x1,y1,z1))/c1;
}

void updateSelfPosition (float ca,float cb,float sa,float sb,float v)
{
    float temp;
    
    for (bb=HOW_FAR_BACK-1; bb > 0; bb--)
    {
       selfPosition[bb][0] = selfPosition[bb-1][0];
       selfPosition[bb][1] = selfPosition[bb-1][1];
       selfPosition[bb][2] = selfPosition[bb-1][2];
       
       temp  = selfPosition[bb][2] * ca - sa * selfPosition[bb][0];
       selfPosition[bb][0] = selfPosition[bb][0] * ca + sa * selfPosition[bb][2];
       selfPosition[bb][2] = temp * cb - sb * selfPosition[bb][1];
       selfPosition[bb][1] = selfPosition[bb][1] * cb + sb * temp;
      /* translation */
       if(mode==FLYMODE) selfPosition[bb][2] += v;
    }
    
    selfPosition[0][0] = selfPosition[0][1] = selfPosition[0][2];
    if (badMathCountdown) badMathCountdown--;
    
    
}

/* REPLACEMENT FOR CHAPTRACK - flitrack, special relativity edition */

void flitrack (int but,int xx,int yy,int shif){

   long dx,dy;
   float ca,sa,cb,sb, v,thegamma;
   
   if (track==FLITRACK) {
      dx = xx -.5*xt; dx = fabs(dx)>30?dx:0;
      dy = 0;/*yy -.5*yt; dy = fabs(dy)>5?dy:0;*/
   }
   else {
#ifdef CAVE
      if (mode==FLYMODE) dx = 20; else dx = 0;
#else
      if (xx == turn_factor) dx = turn_factor*3; else dx = 0;	/* for turning from ecstasy */
#endif
      dy = 0;
   }

        ca = cos(torq*dx/100);
        sa = sin(torq*dx/100);
        cb = cos(torq*dy);    /* I'm gonna leave these here in case someone */
        sb = sin(torq*dy);    /* in the future wants to implement them */
 
   if(track)
   {	/* update Stars */
      glMatrixMode(GL_MODELVIEW); glPushMatrix(); glLoadIdentity();
	glRotatef(dx*torq/2,0,1,0);
      glPushMatrix();
      glMultMatrixf(starmat);
      glGetFloatv(GL_MODELVIEW_MATRIX,starmat);
      glPopMatrix();
	glPopMatrix();
   }	

        v = VEL(vel,cls);
        thegamma = gamm(v,cls);

   updateSelfPosition(ca,cb,sa,sb,v);
   updateall(ca,cb,sa,sb,v,thegamma);

}

void chaptrack(int but,int xx,int yy,int shif){

   long dx,dy;
   dx = xx -.5*xt; dx = abs(dx)>25?dx:0;
   dy = yy -.5*yt; dy = abs(dy)>25?dy:0;

   glMatrixMode(GL_MODELVIEW); glPushMatrix(); glLoadIdentity();

   /*if(mode==TURNMODE)*/ glTranslatef(aff[12],aff[13],aff[14]);
   glRotatef(dx*torq,0.,1.,0.); glRotatef(dy*torq,1.,0.,0.);

#ifdef __sgi
   if(but&(1<<GLUT_RIGHT_BUTTON ))glRotatef(shif?-10:-1,0.,0.,1.);
   if(but&(1<<GLUT_LEFT_BUTTON  ))glRotatef(shif?10:1,0.,0.,1.);
#else
   if(but&(1<<GLUT_RIGHT_BUTTON ))glRotatef(shif ? -1 : 1,0.,0.,1.);
   /*if(but&(1<<GLUT_RIGHT_BUTTON ) && shif)glRotatef(-1,0.,0.,1.);
   if(but&(1<<GLUT_RIGHT_BUTTON) && !shif)glRotatef(1,0.,0.,1.);*/
#endif
   /* if(mode==FLYMODE){
      glPushMatrix();
      glMultMatrixf(starmat);
      glGetFloatv(GL_MODELVIEW_MATRIX,starmat);
      glPopMatrix();
   } */
#ifdef __sgi
   if(but&(1<<GLUT_MIDDLE_BUTTON)) glTranslatef(0.,0.,shif ? -speed : speed);
#else
   if(but&(1<<GLUT_LEFT_BUTTON)) glTranslatef(0.,0.,shif ? -speed : speed);
#endif   
   
   /*if(mode==TURNMODE)*/ glTranslatef(-aff[12],-aff[13],-aff[14]);
   glMultMatrixf(aff);
   glGetFloatv(GL_MODELVIEW_MATRIX,aff);
   {int ii,jj; for(ii=0;ii<3;ii++){ lu[ii]=0; /* calculite */
          for(jj=0;jj<3;jj++) lu[ii] += aff[ii*4+jj]*lux[jj];}}
   glPopMatrix();
   

   flitrack(0,turn_factor,0,0); /* relativistic transformations */
   turn_factor = 0;

}


void reshaped(int xx, int yy){xt=xx ; yt=yy;}   /* what is this for ? */

void drawcons(void){	/* anaglyph instead of binoc */
  glDrawBuffer(GL_BACK); glReadBuffer(GL_BACK);
  glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
  /*if(binoc) glViewport(0,yt/4,xt/2,yt/2);*/
  glMatrixMode(GL_PROJECTION); glLoadIdentity();
  glFrustum(-mysiz*xt/yt,mysiz*xt/yt,-mysiz,mysiz,mysiz*focal,far);
  glViewport(0,0,xt,yt);
  if (binoc)
    glColorMask(GL_FALSE, GL_FALSE, GL_TRUE, GL_TRUE);  //left eye (red)
  glMatrixMode(GL_MODELVIEW); glLoadIdentity();
  drawstars();
  glTranslatef(-binoc*nose,0.0,0.0);
  glMultMatrixf(aff);
  drawall();
  if(binoc){
    glFlush();
    glColorMask(GL_TRUE,GL_TRUE,GL_TRUE,GL_TRUE);  
    glDrawBuffer(GL_BACK);
    glClear(GL_DEPTH_BUFFER_BIT);
    glEnable(GL_BLEND);
    glBlendFunc(GL_ONE, GL_ONE);

    glMatrixMode(GL_PROJECTION); glLoadIdentity();
    glFrustum(-mysiz*xt/yt,mysiz*xt/yt,-mysiz,mysiz,mysiz*focal,far);
    glViewport(0,0,xt,yt);
    
    glColorMask(GL_TRUE, GL_FALSE, GL_FALSE, GL_TRUE);  //right eye (blue)
    
    glMatrixMode(GL_MODELVIEW);
    glLoadIdentity();
    drawstars();
    glTranslatef(binoc*nose,0.0,0.0);
    glMultMatrixf(aff);
    drawall();
    glFlush();
    
    glColorMask(GL_TRUE,GL_TRUE,GL_TRUE,GL_TRUE);
    }
  
  if(msg) messages();
  glutSwapBuffers();
}

void idle(void){ /*do this when nothing else is happening*/
   if(morph) autotymer(0);  /* advance autotymer */ 
   glutPostRedisplay();  /*redraw the window*/

   if(track) flitrack(BUT,XX,YY,SHIF);
   else chaptrack(BUT,XX,YY,SHIF);

   audiofunc();  
}

void mousepushed(int but,int stat,int x,int y){
  if(stat==GLUT_DOWN) BUT |= (1<<but);
  else BUT &= (-1 ^ (1<<but));  
  XX=x; YY=y; SHIF=(glutGetModifiers()==GLUT_ACTIVE_SHIFT)?1:0;
}

void mousemoved(int x,int y){  XX=x; YY=y; }

void caveframe(void){
  if(track==GALILEAN) cavetrack();
  if(track==RELATIVE) flicavetrack();
}

int main(int argc, char **argv){  
   arguments(argc,argv); 
   if(caveyes)
#ifdef CAVE
       CAVEConfigure(&argc, argv, NULL)
#endif
       ;
   getmem();
   dataprep();
 
   if(caveyes){
#ifdef CAVE
       CAVEInit(); /* Each wall is (part of) a forked process from here on.*/ 
       CAVEFrameFunction(caveframe,0);
       /*is restricted to MasterWall, so once per frame */
       CAVEInitApplication(drawcaveinit, 0); 
       CAVEDisplay(drawcave, 0);
       while(!CAVEgetbutton(CAVE_ESCKEY))
         {
         cavekeybo();  /* is asynchronous from display processes */ 
	 }
       audioclean();
       CAVEExit();
#endif
       ;}
     else{ /*console main*/
       glutInit(&argc, argv);
       glutInitDisplayMode(GLUT_DOUBLE|GLUT_DEPTH);
       switch( 1 /*win*/)
         { case 0: break;
           case 1: glutInitWindowSize(640, 480);
                   glutInitWindowPosition(0,1024-480);
                   break;
           case 2: glutInitWindowPosition(0,0);
	           break;
         }
       glutCreateWindow("<* SchpRel in C/OpenGL/GLUT *>"); 
       if(win==2) glutFullScreen();
       glEnable(GL_DEPTH_TEST);
       glutDisplayFunc(drawcons);       

       glutKeyboardFunc(keyboard);
       glutSpecialFunc(special_keybo);
       glutMouseFunc(mousepushed);
       glutMotionFunc(mousemoved);       
       glutPassiveMotionFunc(mousemoved); 
       glutReshapeFunc(reshaped);
       glutIdleFunc(idle);             
       glutMainLoop();
       }
       return 0;
} 
