/*** 7/23/2001 - Corrected the error that was involved in spline **/
/*** Therefore, the hack to correct this problem was removed.   **/
/*** 7/19/2001 - Added ability to spline a path. Now labeling as spline#.c **/ 
/*** 7/18/2001 - Corrected cockpit viewer. Added trailing ****/
/** mechanism from chaptrail.c                     **/
/*** 7/17/2001 - Robert Shuttleworth - Added quatomat.c and a  **/
/*** figure with a direction and added a cockpit viewer. The   **/
/** succession of programs are labeled as path#.c, the original **/  
/** came from skel.c        */
/****************************************************************/
/****    skel.c = OpenSkelGlut.c = Noosh97 with CAVE removed ****/
/****    (C) 1994 Board of Trustees University of Illinois   ****/ 
/****    A Model Real-Time Interactive OpenGL Application    ****/
/****    George Francis, Glenn Chappell, Chris Hartman       ****/
/****    e-mail  gfrancis@math.uiuc.edu                      ****/
/******* revised 16jan2K by gkf**********************************/
/****************************************************************/
#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <sys/timeb.h>    /* for the speedometer */
#include <GL/glut.h>

#define  MAX(x,y)         (((x)<(y))?(y):(x))
#define  MIN(x,y)         (((x)<(y))?(x):(y))
#define  ABS(u)           ((u)<0 ? -(u): (u))
#define  FOR(a,b,c)       for((a)=(b);(a)<(c);(a)++)
#define  DOT3(p,q)         ((p)[0]*(q)[0]+(p)[1]*(q)[1]+(p)[2]*(q)[2])
#define  DOT4(p,q)         (DOT3(p,q)+((p)[3]*(q)[3]))
#define  NRM(p)           sqrt(DOT3((p),(p)))
#define  DG            M_PI/180
#define  S(u)          sin(u*DG)
#define  C(u)          cos(u*DG)
#define  CLAMP(x,u,v) (x<u? u : (x>v ? v: x))
#define BIGSTARS 100

#ifndef  M_PI
	#define  M_PI		   3.1415926535897932384
#endif

/* global variables */
float gap, gap0=1.; /* kludge so that arguments() can set a default gap0 */
float lux[3]={1.,2.,3.};             /*world light direction vector     */
float luxx[3];                       /*  object space  direction vector*/
float amb, pwr ;             /* ambient fraction, pseudo-specular power */
float mysiz,speed, torq, focal, farr; /*console navigation variables         */
int win = 1;                   /* 2 full screen, use 0 for demand sized */
unsigned int BUT, XX, YY,SHIF;     /* used in chaptrack gluttery           */ 
int xt,yt;                       /* once was xt,yt,xm,ym for viewportery */
int mode,morph,msg,binoc;            /* pretty global */
int th0, th1, dth, ta0, ta1, dta;    /* torus parameters */
#define FLYMODE  (0)
#define TURNMODE (1) 
int ii, jj;  float tmp, temp;   /* saves gray hairs later */
float aff[16], starmat[16];
float mat[16], camera[16], inv[16];
float tmpmat[16];
int binoc;    /* flag                       */
float nose;   /* to eye distance in console */

int cockpit; /* needed for cockpit view */
int wire = 1;   /* wire frame */
int ttime; /* time for cockpit flyer */
int deltatt; /* time for cockpit flyer */
/*needed for splines */

float totalslirp[7];

float slirpmat[16];

float quat1[7];
float quat2[7]; 
float quat3[7];

int middle=0;

/************************Added from quatomat.c ************************/
void normalize(float *vec){
  int ii;
  float temp = vec[0]*vec[0] + vec[1]*vec[1] + vec[2]*vec[2] + vec[3]*vec[3];
  if (temp == 1){ printf(" The vector is of unit length.\n"); }
  else{ temp = sqrt(temp);
       for(ii=0;ii<4;ii++)vec[ii] /= temp; 
      }
}

void printquat(float *quat){
    printf("\n Quaternion: \n");
	printf(" w = %f \n", quat[0]);
	printf(" x = %f \n", quat[1]);
	printf(" y = %f \n", quat[2]);
	printf(" z = %f \n", quat[3]);
}

void printmat(float *mat){   
	printf("\n Matrix: \n");
	printf(" %f %f %f %f \n", mat[0], mat[4], mat[8],  mat[12]);
	printf(" %f %f %f %f \n", mat[1], mat[5], mat[9],  mat[13]);
	printf(" %f %f %f %f \n", mat[2], mat[6], mat[10], mat[14]);
	printf(" %f %f %f %f \n", mat[3], mat[7], mat[11], mat[15]);
}

void q2m(float *quat, float *mat){
  float w = quat[0], x = quat[1], y = quat[2], z = quat[3]; 
  float ww, xx, yy, zz, xy, xz, yz, wz, wy, wx;

  ww = w*w; xx = x*x; yy = y*y; zz = z*z; 
  xy = x*y; xz = x*z; yz = y*z; wz = w*z; wy = w*y; wx = w*x; xz = x*z;

  mat[0]=ww+xx-yy-zz;  mat[4]=2*xy - 2*wz;  mat[8]=2*wy + 2*xz;
  mat[1]=2*wz + 2*xy;  mat[5]=ww-xx+yy-zz;  mat[9]=2*yz - 2*wx;
  mat[2]=2*xz - 2*wy;  mat[6]=2*wx + 2*yz; mat[10]=ww-xx-yy+zz;

  mat[3] = mat[7] = mat[11] = mat[12] = mat[13] = mat[14] = 0;
  mat[15] = ww + xx + yy + zz; /* this is a check */
}

void m2q(float *mat, float *quat){  /* the inverse operation */
    float tmp; int ii, jj; 
    float tr[4];  /* pseudo traces */

    normalize(quat);
  tr[0]=   mat[0] + mat[5] + mat[10];
  tr[1]=   mat[0] - mat[5] - mat[10];
  tr[2]=  -mat[0] + mat[5] - mat[10];
  tr[3]=  -mat[0] - mat[5] + mat[10];
     
  /* printf("trace  %f %f %f %f \n" , tr[0],tr[1],tr[2],tr[3]);  */

    ii=1; jj=2;  /* find the largest tr */
    if(tr[0] > tr[1])   ii = 0; 
    if(tr[3] > tr[2])   jj = 3; 
    if(tr[jj] > tr[ii]) ii = jj;

    /*printf("\n %i is the largest trace. \n", ii);*/
    tmp = 4*sqrt(tr[ii]+1)/2; 
    
    switch(ii){
    case 0: 
      quat[0] = tmp/4;
      quat[1] = (mat[6] - mat[9]) / tmp; 
      quat[2] = (mat[8] - mat[2]) / tmp; 
      quat[3] = (mat[1] - mat[4]) / tmp; 
      break; 
    case 1: 
      quat[0] = (mat[6] - mat[9]) / tmp;
      quat[1] = tmp/4; 
      quat[2] = (mat[1] + mat[4]) / tmp;
      quat[3] = (mat[8] + mat[2]) / tmp;
      break;
    case 2: 
      quat[0] = (mat[8] - mat[2]) / tmp;
      quat[1] = (mat[4] + mat[1]) / tmp; 
      quat[2] = tmp/4; 
      quat[3] = (mat[9] + mat[6]) / tmp; 
      break; 
    case 3:
      quat[0] = (mat[1] - mat[4]) / tmp;
      quat[1] = (mat[8] + mat[2]) / tmp; 
      quat[2] = (mat[9] + mat[6]) / tmp; 
      quat[3] = tmp/4;
      break; 
    }
}
/*************************Added from chaptrail2.c **********************/
#define MAXTIE 5000   /* chaptrail is shorter than 5000 rungs */
#define TIEWIDTH   .05   /* chaptrail is shorter than 5000 rungs */
float trail[2*MAXTIE][3];

int  trailtie=0, traildraw=0, trailwryte=0 ;  /* trail pointer */
int trailbegan=0, traildone=0;
#define trailmake (trailbegan && !traildone)
/**********************************************************************/
/* chaptrail */
/**********************************************************************/   

void getfirstquat(void){
  static int stat1 = 0;

  if(trailbegan && (!stat1))
    {
      m2q(aff,quat1);
      quat1[4] = aff[12];
      quat1[5] = aff[13];
      quat1[6] = aff[14];
      stat1 = 1;
      printquat(quat1);
      printf(" The values of quat1 are: %f %f %f \n", quat1[4], quat1[5], quat1[6]);

   }
}

void getmiddlequat(void){
  static int stat_local =0;

  if(middle && !stat_local){
    m2q(aff,quat2);
    quat2[4] = aff[12];
    quat2[5] = aff[13];
    quat2[6] = aff[14];
    printquat(quat2);
    printf(" The values of the quat2 are: %f %f %f \n", quat2[4],quat2[5],quat2[6]);
    middle = 0;/* doesn't matter */
    stat_local=1;
  }
}

void getfinalquat()
{
  static int stat2=0;

  if(traildone && !stat2){
    m2q(aff,quat3);
    quat3[4] = aff[12];
    quat3[5] = aff[13];
    quat3[6] = aff[14];
    printquat(quat3);
    printf(" The values of quat3 pos are: %f %f %f\n", quat3[4], quat3[5], quat3[6]);
    stat2 = 1;
  }
}

void whereis3f(float xx, float yy, float zz, float *there){
   /* there = U'*(X-m) = affinv*X */

  if(0/*cockpit*/)
    {
   xx -= aff[12] ; yy -= aff[13]; zz -= aff[14];
   there[0]=aff[0]*xx + aff[4]*yy + aff[8] *zz;
   there[1]=aff[1]*xx + aff[5]*yy + aff[9] *zz;
   there[2]=aff[2]*xx + aff[6]*yy + aff[10]*zz;
    }
  else
    {
   xx -= aff[12] ; yy -= aff[13]; zz -= aff[14];
   there[0]=aff[0]*xx + aff[1]*yy + aff[2] *zz;
   there[1]=aff[4]*xx + aff[5]*yy + aff[6] *zz;
   there[2]=aff[8]*xx + aff[9]*yy + aff[10]*zz;
   }
}

void maketrail(void){
/* TIEWIDTH .08 is better */
     float right = TIEWIDTH, left= -TIEWIDTH;
    if(trailtie==MAXTIE) return;
    whereis3f(right,0,0, trail[2*trailtie]);
    whereis3f(left, 0,0, trail[2*trailtie+1]);
    trailtie++;
}

void writetrail(void){
    int ii,jj;
    FOR(ii,0,trailtie){
    FOR(jj,0,3)printf(" %.2g ", trail[2*ii][jj]);
    printf("\n");
    FOR(jj,0,3)printf(" %.2g ", trail[2*ii+1][jj]);
    printf("\n");
    }
    trailwryte=0;
}

void drawtrail(void){
    int ii;
    float nn=0.0;

glBegin(GL_LINES);
        FOR(ii,0,trailtie)
        {
        glColor3f(cos(M_PI*nn),sin(M_PI*nn),1-cos(M_PI*nn));
	/* printf("R = %f, G = %f, B = %f\n",cos(M_PI*nn),sin(M_PI*nn),1-cos(M_PI*nn));*/
        nn = nn + 0.01;
        glVertex3f(trail[2*ii][0], trail[2*ii][1],trail[2*ii][2]);
        glVertex3f(trail[2*ii+1][0], trail[2*ii+1][1],trail[2*ii+1][2]);
        }
glEnd(); 
}

/**********************************************************************/
/** Splines ***/
/**********************************************************************/
#define MAXSLIRP 5000
#define SLIRPWIDTH   .08   /* chaptrail is shorter than 5000 rungs */

int  slirptie=0, slirpmake=0, slirpdraw=0, slirpwryte=0 ;  /* trail pointer */

float strail[2*MAXSLIRP][3];
float slirppath[MAXSLIRP][7];
/**********************************************************************/
void printslirp(float *path)
{
  printf(" The values of the path are: %f %f %f %f %f %f %f \n", path[0],path[1],path[2],path[3],path[4],path[5],path[6]);
}

void slirp(float t,float *P, float *A, float *B)
{          /* P(t) = slirp(A,B) */

  float dd, sd, sc1, sc2, lc1, lc2;

  dd  = acos(DOT4(A,B));  
  sd  = sin(dd);
  sc1  = sin(dd - t*dd)/sd; lc1 = 1-t;
  sc2  = sin(t*dd)/sd;      lc2 = t;

  P[0] = A[0]*sc1 + B[0]*sc2;
  P[1] = A[1]*sc1 + B[1]*sc2;
  P[2] = A[2]*sc1 + B[2]*sc2;
  P[3] = A[3]*sc1 + B[3]*sc2;
  P[4] = A[4]*lc1 + B[4]*lc2;
  P[5] = A[5]*lc1 + B[5]*lc2;
  P[6] = A[6]*lc1 + B[6]*lc2;

  /* printslirp(P);*/
}

void slirp3(float t, float *P, float *A, float *K, float *B)
{  /* P(t) = L(t,L(t,A,K) , L(t,K,B)) */
      float T1[7],T2[7],T3[7],d1,d2,d3;  

      static int kk = 0;

      slirp(t,T1,A,K);   /* T1(t) */
      slirp(t,T2,K,B);   /* T2(t) */
      slirp(t,P,T1,T2);  /* P(t)  */

      slirppath[kk][0] = P[0];
      slirppath[kk][1] = P[1];
      slirppath[kk][2] = P[2];
      slirppath[kk][3] = P[3];
      slirppath[kk][4] = P[4];
      slirppath[kk][5] = P[5];
      slirppath[kk][6] = P[6];
      kk++;
}

void whereis3float(float xx, float yy, float zz, float *there, int ww)
{
  xx -= totalslirp[4]; yy -= totalslirp[5]; zz -= totalslirp[6];
  there[0] = slirpmat[0]*xx + slirpmat[1]*yy + slirpmat[2]*zz;
  there[1] = slirpmat[4]*xx + slirpmat[5]*yy + slirpmat[6]*zz;
  there[2] = slirpmat[8]*xx + slirpmat[9]*yy + slirpmat[10]*zz;
}

/* When makespline is called, we best be done with trail already */
void makespline(void)
{
  static int stat3 = 0;
  float tt;
  float right = SLIRPWIDTH, left= -SLIRPWIDTH;

  if(traildone && !stat3) {
    for(tt=0.0;tt<=1.0;tt=tt+0.01){
      if(slirptie==MAXSLIRP) return;
      slirp3(tt,totalslirp,quat1,quat2,quat3);/* makes slirppath(tt) */
      q2m(totalslirp,slirpmat);
      whereis3float(right,0,0,strail[2*slirptie], slirptie);
      whereis3float(left,0,0,strail[2*slirptie+1], slirptie);
      slirptie++; /* Note: last value of slirptie is used later */
    }    
    stat3 = 1;
  }
}

void writespline(void){
    int ii,jj;
    FOR(ii,0,slirptie){
      /*
    FOR(jj,0,3)printf(" %.2g ", strail[2*ii][jj]);
    printf("\n");
    FOR(jj,0,3)printf(" %.2g ", strail[2*ii+1][jj]);
    */
    printf("ii=%i\t",ii);
    FOR(jj,4,7)printf(" %f ", slirppath[ii][jj]);
    printf("\n");
    slirpwryte=0;
    }
}

void drawspline(void){
    int ii;
    float nn=0.0;

glBegin(GL_LINES);

        FOR(ii,0,slirptie)
        {
	  glColor3f(1.0,0.0,1.0);
	  /*glColor3f(cos(M_PI*nn),sin(M_PI*nn),1-cos(M_PI*nn));
	  printf("R = %f, G = %f, B = %f\n",cos(M_PI*nn),sin(M_PI*nn),1-cos(M_PI*nn));*/
        nn = nn + 0.01;
        glVertex3f(strail[2*ii][0], strail[2*ii][1], strail[2*ii][2]);
	glColor3f(0.0,1.0,0.0);
        glVertex3f(strail[2*ii+1][0], strail[2*ii+1][1], strail[2*ii+1][2]);
        }
glEnd(); 
}

/**********************************************************************/
void autotymer(int reset){ /* cheap animations */
#define  TYME(cnt,max,act) {static cnt; if(first)cnt=max; else\
                            if(cnt?cnt--:0){ act ; goto Break;}}
  static first = 1;  /* the first time autymer is called */
  if(reset)first=1;  /* or if it is reset to start over  */
  TYME( shrink , 150,th0++;th1--;ta0++;ta1--)
  TYME( pause  , 20,          )
  TYME( grow   , 150,th0--;th1++;ta0--;ta1++)
  TYME( dwell  , 30,            )
  TYME(finish  , 1 , first = 1  )
  first = 0;
  Break:   ;   /* yes Virginia, C has gotos */
}

/**********************************************************************/
void deFault(void){
th0=5; th1=355;  ta0=5; ta1=355; gap = gap0; cockpit = 0;
msg=1; binoc=0; nose=.06; mode=TURNMODE;  
speed=.1; torq=.02; focal = 2.; farr =50.; mysiz=.01; morph=0; 
FOR(ii,0,16) starmat[ii]=aff[ii] = (ii/4==ii%4);   /* identities */ 
FOR(ii,0,3)lux[ii]/=NRM(lux); amb = .3; pwr = 10. ;
deltatt=0;
/* initial place: */
aff[12]=0; aff[13]= 0; aff[14]= -4.2;   /* place where we can see it */

autotymer(1); /* reset autotymer to start at the beginning */
}
/*******************************************************************/
/*********************Replace after switching to quaternions!********/
void invert(float *temp, float *inv){
 inv[0] = temp[0];
 inv[1] = temp[4];
 inv[2] = temp[8];
 inv[3] = temp[3];
 inv[4] = temp[1];
 inv[5] = temp[5];
 inv[6] = temp[9];
 inv[7] = temp[7];
 inv[8] = temp[2];
 inv[9] = temp[6];
 inv[10] = temp[10];
 inv[11] = temp[11];
 inv[12] = -temp[0]*temp[12] - temp[1]*mat[13] - temp[2]*mat[14];
 inv[13] = -temp[4]*temp[12] - temp[5]*mat[13] - temp[6]*mat[14];
 inv[14] = -temp[8]*temp[12] - temp[9]*mat[13] - temp[10]*mat[14];
 inv[15] = temp[15];
}

/**********************************************************************/
void drawvert(int th, int ta){  
float lmb,spec,nn[3], dog, cat;
nn[0] = C(th)*C(ta); /* unit sphere radius vector */  
nn[1] = S(th)*C(ta);
nn[2] =       S(ta);
lmb = DOT3(nn,luxx);lmb =(lmb<0 ? .2 : lmb);  lmb = MAX(amb, lmb); 
spec = CLAMP((1.1 - pwr+pwr*lmb), 0., 1.);  
dog = (ta-ta0)/(float)(ta1-ta0); cat = (th-th0)/(float)(th1-th0);
glColor3f(
  MAX(spec, lmb*dog),                    /* map R^2(dog,cat)->R^3(RGBspace */
  MAX(spec, lmb*(.25 + ABS(cat -.5))),  /* dog cat model of Hartman       */
  MAX(spec, lmb*(1 - cat)));            /* illiLight by Ray Idaszak 1989  */
glVertex3f(
  C(th) + .5*nn[0],
  S(th) + .5*nn[1],
          .5*nn[2]);
}
/* end drawvert */

/**********************************************************************/
void drawtor(void){
int th, ta;
dth = (int)((th1-th0)/24);  /* 24  meridian strips */ 
dta = (int)((ta1-ta0)/24);  /* 24  triangle pairs per strip */
for(th=th0; th < th1; th += dth){
  glBegin(wire?GL_LINE_STRIP:GL_TRIANGLE_STRIP);
  for(ta=ta0; ta < ta1; ta += dta){ drawvert(th,ta); drawvert(th+gap*dth,ta); }
  glEnd();
  } /* end for.theta loop */
 }   /* end drawtor */

/**********************************************************************/
/*
void drawspheres(void){
  if(traildone){
  glColor3f(1.0,0.0,0.0);
  glPushMatrix();
  glTranslatef(quat1[4],quat1[5],quat1[6]);
  glutWireSphere(0.1,10,10);
  glPopMatrix();
  glColor3f(0.0,1.0,0.0);
  glPushMatrix();
  glTranslatef(quat2[4],quat2[5],quat2[6]);
  glutWireSphere(0.1,10,10);
  glPopMatrix();
  glColor3f(0.0,0.0,1.0);
  glPushMatrix();
  glTranslatef(quat3[4],quat3[5],quat3[6]);
  glutWireSphere(0.1,10,10);
  glPopMatrix();
  }
}
*/

/**********************************************************************/
void drawCar(){
    glPushMatrix();
    /*glTranslatef(-slirppath[ttime][4],-slirppath[ttime][5],-slirppath[ttime][6]);*/
    /*glMultMatrixf(tmpmat);*/ 
     /* draw here */
     glColor3f(1,0,0);
      glutWireCone(.1,.5, 10, 10);
      /* end draw here */
    glPopMatrix();
}
/**********************************************************************/
void drawall(void){ 
drawspline();  
drawtrail();
  drawtor();
 /*drawCar();*/ 
    /*drawspheres();*/
}

/**********************************************************************/
void drawstars(void){ 
     static float star[1000][3]; static int virgin=1;
 if(virgin){  /* first time  set up the stars */
     FOR(ii,0,1000)FOR(jj,0,3)star[ii][jj]=rand()/(float)0x40000000-1.;
     virgin=0; /* never again */
  }
  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();   /* insurance of superstition */
  glMultMatrixf(starmat);
  glColor3f(1.0,1.0,0.0);    
  glBegin(GL_POINTS);
    FOR(ii,0,1000)glVertex3fv(star[ii]);
  glEnd();
  glPopMatrix();
  glClear(GL_DEPTH_BUFFER_BIT); /* so the stars are behind everything */
}

/**********************************************************************/
void arguments(int argc,char **argv){
#if 0
  extern char *optarg;
  extern int optind; 
  int chi;   
  /* w: needs ONE number after -w, c<nothing> means NO number follows*/ 
  while ((chi = getopt(argc,argv,"w:d:g:")) != -1) 
  switch(chi)  {
                case 'w': win=atoi(optarg); break; 
                case 'g': gap0=atof(optarg); break;
                }
  if (optind!=argc) fprintf(stderr,"%s: Incorrect usage\n",argv[0]);
#endif
}

/**********************************************************************/
void keyboard(unsigned char key, int x, int y){
#define  IF(K)            if(key==K)
#define  PRESS(K,A,b)     IF(K){b;}IF((K-32)){A;}  
/*was backwards in previous versions */
#define  TOGGLE(K,flg)    IF(K){(flg) = 1-(flg); }
#define  CYCLE(K,f,m)     PRESS((K), (f)=(((f)+(m)-1)%(m)),(f)=(++(f)%(m)))
#define  SLIDI(K,f,m,M)   PRESS(K,(--f<m?m:f), (++f>M?M:f))
#define  SLIDF(K,f,m,M,d) PRESS(K,((f -= d)<m?m:f), ((f += d)>M?M:f))
/* Only ASCII characters can be processes by this GLUT callback function */ 
   IF(27) { exit(0); }              /* ESC exit            */
   TOGGLE('v',binoc);                            /* cross-eyed STEREO   */
   CYCLE(' ', mode,TURNMODE+1);                  /* fly/turn modes      */
   TOGGLE('h',morph);                            /* autotymer on/off    */
   TOGGLE('w',msg);                              /* writing on/off      */
   PRESS('n', nose -= .001 , nose += .001 );     /* for binoculars      */
   PRESS('s',speed /= 1.02, speed *= 1.02);      /* flying speed        */
   PRESS('q',torq /= 1.02, torq *= 1.02);        /* turning speed       */
   PRESS('o', focal *= 1.1 , focal /= 1.1)       /* telephoto           */
   PRESS('i', mysiz /= 1.1, mysiz *= 1.1)        /* rescale the world   */
   PRESS('p', farr *= 1.01 , farr   /= 1.01)       /* rear clipping plane */
   PRESS('z', deFault(), deFault());             /* zap changes         */
   PRESS('g',gap /= .9, gap *= .9);             /* gap parameter      */
   PRESS('a',amb /= .9, amb *= .9);             /* ambient fraction   */
   PRESS('r',pwr /= .9, pwr *= .9);             /* pseudo-spec power  */
   PRESS('k', ttime=0;,cockpit=1-cockpit;);
   PRESS('a', deltatt--;,deltatt++;);
   IF('t'){
     if(!trailbegan){trailbegan=1;}
     else if(!traildone){traildone=1;}
   }
   TOGGLE('d', traildraw);
   TOGGLE('y', trailwryte);
   TOGGLE('l', slirpmake);
   TOGGLE('m', middle);
   TOGGLE('e', slirpwryte);
}

/**********************************************************************/
void special_keybo(int key, int x, int y){
/*non-ASCII keypresses go here, if you're lucky enough to know their names */
 fprintf(stderr," non-ASCII character was pressed.\n");
 fprintf(stderr," use special_keybo() to process it\n");
}

/**********************************************************************/
float speedometer(void){
	double dbl; 
	static double rate; 
	static int ii=0;
	static struct _timeb lnow, lthen;
	if(++ii % 8 == 0)
	{  /* 8 times around measure time */
		_ftime(&lnow);
		dbl =  (double)(lnow.time - lthen.time)+(double)(lnow.millitm - lthen.millitm)/1000;
		lthen = lnow;  rate = 8/dbl;
	}
	return((float)rate);
}
/**********************************************************************/
float speedometer2(void){
#if 0
      double tmp; static double rate; static int ii=0;
      static struct _timeb lnow, lthen; /* what windows _ftime() eats */
      
  if(++ii % 8 == 0){  /* ii is incremented, but we do this everyt 8th time */
     _ftime(&lnow);
     tmp =  (double)(lnow.time - lthen.time)
          + (double)(lnow.millitm - lthen.millitm)/1000;
     rate = 8/tmp; lthen = lnow;  /* structures are assignable */
    }
   return((float)rate);
#endif
}

/**********************************************************************/
void char2wall(float x,float y,float z, char buf[]){
     char *p; glRasterPos3f(x,y,z);
     for(p = buf;*p;p++) glutBitmapCharacter(GLUT_BITMAP_9_BY_15,*p);
}
/**********************************************************************/
void messages(void){     
  char buf[256]; /* console messages are done differently from cave */
#define  LABEL2(x,y,W,u) {sprintf(buf,(W),(u));char2wall(x,y,0.,buf);}
  glMatrixMode(GL_PROJECTION); glPushMatrix(); glLoadIdentity();
  gluOrtho2D(0,3000,0,3000);
  glMatrixMode(GL_MODELVIEW); glPushMatrix(); glLoadIdentity();
      /*bull's eye*/
      if(mode==TURNMODE) glColor3f(0x22/255.,0x88/255.,0xdd/255.);
        else      glColor3f(.8,.8,.8);
      LABEL2(1500,1500,"%s","o");
      /* writings */
      if(mode==TURNMODE) glColor3f(1.,0.,1.);
        else      glColor3f(1.,1.,0.);
      LABEL2(80,80,"%4.1f fps",speedometer());
      LABEL2(80,2840,\
      "(ESC)ape (V)Binoc (MAUS2)Fore (BAR)Flymode %s (H)omotopy (W)riting",
             mode?"FLYING":"CONTROL");
      LABEL2(10,10,"QuatoSpline \
   by Shuttleworth - illiMath2001 %s","");
      LABEL2(80,2770,"(N)ose   %0.3f",nose);
      LABEL2(80,2700,"(S)peed  %0.4f",speed);
      LABEL2(80,2630," tor(Q) %0.4f",torq);
      LABEL2(80,2560,"near clipper %g", mysiz*focal);
      LABEL2(80,2490,"f(O)cal factor %g",focal);
      LABEL2(80,2420,"my s(I)ze %.2g",mysiz);
      LABEL2(80,2350,"far cli(P)er= %.2g",farr);
      LABEL2(80,2280,"(Z)ap %s","");
      LABEL2(80,2210,"(G)ap %.2g",gap);
      LABEL2(80,2140,"(A)mb %.2g",amb);
      LABEL2(80,2070,"pw(R) %.2g",pwr);
      LABEL2(80,2000,"coc(K)pit %i",cockpit);
      LABEL2(80,1930,"(t)railmake %d",trailmake);
      LABEL2(80,1860,"trail(d)raw %d",traildraw);
      LABEL2(80,1790,"trailtie %d",trailtie);
      LABEL2(80,1720,"trailwr(y)te %d",trailwryte);
      LABEL2(80,1650,"draw sp(l)ine %d",slirpmake);
      LABEL2(80,1590,"slirptie %d",slirptie);
      LABEL2(80,1520,"(m)iddle position %d",middle);
      LABEL2(80,1450,"slirpwryt(e) %d",slirpwryte);
      LABEL2(80,1380,"delt(A) t %i",deltatt);

    glPopMatrix();
glMatrixMode(GL_PROJECTION); glPopMatrix();
} 
/**********************************************************************/
void chaptrack(int but,int xx,int yy,int shif){  
   long dx,dy; 
   dx = xx -.5*xt; dx = abs(dx)>5?dx:0;
   dy = yy -.5*yt; dy = abs(dy)>5?dy:0;

   glMatrixMode(GL_MODELVIEW); glPushMatrix(); glLoadIdentity();

   if(mode==TURNMODE) glTranslatef(aff[12],aff[13],aff[14]);
   glRotatef(dx*torq,0.,1.,0.); glRotatef(dy*torq,1.,0.,0.);
   if(but&(1<<GLUT_RIGHT_BUTTON ))glRotatef(shif?-10:-1,0.,0.,1.);
   if(but&(1<<GLUT_LEFT_BUTTON  ))glRotatef(shif?10:1,0.,0.,1.);
   if(mode==FLYMODE){
      glPushMatrix();
      glMultMatrixf(starmat);
      glGetFloatv(GL_MODELVIEW_MATRIX,starmat);
      glPopMatrix();
   }
   if(but&(1<<GLUT_MIDDLE_BUTTON)) glTranslatef(0.,0.,shif ? -speed : speed);
   if(mode==TURNMODE) glTranslatef(-aff[12],-aff[13],-aff[14]);
   glMultMatrixf(aff); 
   glGetFloatv(GL_MODELVIEW_MATRIX,aff);
   FOR(ii,0,3){luxx[ii]=0; FOR(jj,0,3)luxx[ii] +=aff[ii*4+jj]*lux[jj];}
   glPopMatrix();
}
/**********************************************************************/
void reshaped(int xx, int yy){xt=xx ; yt=yy;}   /* origin of moved window */
/**********************************************************************/
void drawcons(void){  
  glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
  if(binoc) glViewport(0,yt/4,xt/2,yt/2);
  glMatrixMode(GL_PROJECTION); glLoadIdentity();
  glFrustum(-mysiz*xt/yt,mysiz*xt/yt,-mysiz,mysiz,mysiz*focal,farr); 
  glMatrixMode(GL_MODELVIEW); glLoadIdentity();
  if(!cockpit){
    drawstars();
    glTranslatef(-binoc*nose,0.0,0.0);
    glMultMatrixf(aff);
  }else{
    q2m(slirppath[ttime], tmpmat);
    { tmpmat[12]=slirppath[ttime][4];
      tmpmat[13]=slirppath[ttime][5];
      tmpmat[14]=slirppath[ttime][6];
    }
    /*drawstars();*/
    invert(tmpmat, inv);  /* we want the inverse frame */
     glMultMatrixf(tmpmat);
      glPushMatrix();
      glMultMatrixf(inv);
        glScalef(BIGSTARS, BIGSTARS, BIGSTARS); 
         drawstars();
      glPopMatrix();
  }
  drawall();
  if(binoc){
    glViewport(xt/2,yt/4,xt/2,yt/2); 
    glMatrixMode(GL_MODELVIEW);
    glLoadIdentity();
    drawstars();
    glTranslatef(binoc*nose,0.0,0.0);
    glMultMatrixf(aff);
    drawall();
    }
  glViewport(0,0,xt,yt);
  if(msg) messages();
  glutSwapBuffers();
}

/**********************************************************************/
void updateTime(void){
   if(cockpit){ ttime+=deltatt; }
   if(ttime>slirptie){ ttime=0;}
}
/**********************************************************************/
void idle(void){ /*do this when nothing else is happening*/
   if(trailwryte){printf("trail is "); writetrail(); } 
   if(trailmake) maketrail();
   getfirstquat();getmiddlequat();getfinalquat();
   if(slirpwryte){printf("Slirp is \n"); writespline();}
   if(slirpmake)makespline();
   if(morph) autotymer(0);  /* advance autotymer */ 
   glutPostRedisplay();  /*redraw the window*/
   chaptrack(BUT,XX,YY,SHIF);
   updateTime();
}

/**********************************************************************/
void mousepushed(int but,int stat,int x,int y){
  if(stat==GLUT_DOWN) BUT |= (1<<but);
  else BUT &= (-1 ^ (1<<but));  
  XX=x; YY=y; SHIF=(glutGetModifiers()==GLUT_ACTIVE_SHIFT)?1:0;
}

/**********************************************************************/
void mousemoved(int x,int y){  XX=x; YY=y; }
/**********************************************************************/
int main(int argc, char **argv){  
   arguments(argc,argv); 
   deFault(); 
 
       glutInit(&argc, argv);
       glutInitDisplayMode(GLUT_DOUBLE|GLUT_DEPTH);
       switch(win){ 
           case 0: break;  /* manage your own window */
           case 1: glutInitWindowSize(640, 480);
                   glutInitWindowPosition(100,100); break;
           case 2: glutInitWindowPosition(0,0); break;
         }
       glutCreateWindow("<* QuatoSpline in C/OpenGL/GLUT *>");
       if(win==2) glutFullScreen();
       glEnable(GL_DEPTH_TEST);
       glutDisplayFunc(drawcons);       
       glutKeyboardFunc(keyboard);
       glutSpecialFunc(special_keybo);
       glutMouseFunc(mousepushed);
       glutMotionFunc(mousemoved);       
       glutPassiveMotionFunc(mousemoved); 
       glutReshapeFunc(reshaped);
       glutIdleFunc(idle);             
       glutMainLoop();
}
 
