from vector import multivector
from solid import solid

import random

class polybar(solid):	
	def __init__(self, dim=1, size=1, mass=1, constrain_position=False, constrain_rotation=False):
		super().__init__(dim, mass, constrain_position, constrain_rotation)
		
		self.radius = size
		self.data = []
		self.inertia = mass * (size**2) * dim # Simulate as a point mass at the end of the polybar: I=m*r^2, r = solid diagonal of N-cube with side length s = s*sqrt(N)
		self.npoints = dim + 1
		
		# Set up the vertices
		vertex = multivector(dim)
		self.data.append(vertex.clone())
		for i in range(dim):
			vertex.data[2**i] = size
			self.data.append(vertex.clone())
	
	def get_edges(self):
		return [(i, i+1) for i in range(self.dim)]
	
	def get_faces(self):
		return None
	
	def internal_point(self, n): # Point in this object's reference frame
		if n > self.dim:
			raise IndexError
		return self.data[n]
	
	def internal_random_point(self): # Ones up to a random point, then a random value, then zeroes.
		index = random.randint(0, self.dim-1)
		value = random.uniform(0, self.radius)
		return multivector.vectorize(
			[1]*index + [value] + [0]*(self.dim-index-1)
		)