from vector import multivector
from solid import solid
from math import pi, sin, cos

import random

class gyro(solid):
	resolution = 12
	
	def __init__(self, dim=3, size=1, mass=1, constrain_position=False, constrain_rotation=False):
		super().__init__(dim, mass, constrain_position, constrain_rotation)
		
		self.radius = size
		self.data = []
	#	self.inertia = mass * (size**2) # Simulate as an infinitely thin disk: I=mr^2
		self.npoints = gyro.resolution + 2
		self.data = [
			multivector(dim), # Zero vector
			multivector.vectorize(
				[0, 0, size] + [0]*(dim-3)
			)
		]
		self.thetafactor = 2*pi/gyro.resolution
	
	def get_edges(self):
		return [(0,1)] + [(i+2, i+3) for i in range(self.npoints-2)]
	
	def get_faces(self):
		return []
	
	def internal_point(self, n): # Point in this object's reference frame
		if n > self.npoints:
			raise IndexError
		if n < len(self.data):
			return self.data[n]
		return multivector.vectorize([
			self.radius * cos(n * self.thetafactor),
			self.radius * sin(n * self.thetafactor),
			self.radius
		] + [0]*(self.dim-3))
	
	def internal_random_point(self):
		pass